/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/CalendarLegend','sap/ui/unified/CalendarLegendRenderer','sap/ui/core/library','sap/ui/unified/library',"sap/base/Log",'sap/ui/core/InvisibleText',"sap/ui/core/format/DateFormat","sap/ui/core/Locale"],function(C,a,b,c,d,l,L,I,D,e){"use strict";var f=l.CalendarDayType;var g=d.CalendarType;var M={};M.render=function(r,m){var o=this.getStartDate(m);var t=m.getTooltip_AsString();var h=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var i=m.getId();var A={value:i+"-Descr",append:true};var w=m.getWidth();r.write("<div");r.writeControlData(m);r.addClass(this.getClass(r,m));if(m._getSecondaryCalendarType()){r.addClass("sapUiCalMonthSecType");}r.writeClasses();this.addWrapperAdditionalStyles(r,m);if(t){r.writeAttributeEscaped("title",t);}if(m._getShowHeader()){A.value=A.value+" "+i+"-Head";}if(w){r.addStyle("width",w);r.writeStyles();}r.writeAccessibilityState(m,{role:"grid",multiselectable:!m.getSingleSelection()||m.getIntervalSelection(),labelledby:A});r.write(">");r.write("<span id=\""+i+"-Descr\" style=\"display: none;\">"+h.getText("CALENDAR_DIALOG")+"</span>");if(m.getIntervalSelection()){r.write("<span id=\""+i+"-Start\" style=\"display: none;\">"+h.getText("CALENDAR_START_DATE")+"</span>");r.write("<span id=\""+i+"-End\" style=\"display: none;\">"+h.getText("CALENDAR_END_DATE")+"</span>");}this.renderMonth(r,m,o);r.write("</div>");};M.addWrapperAdditionalStyles=function(){};M.getStartDate=function(m){return m._getDate();};M.getClass=function(r,m){var s="sapUiCalMonthView",h=m.getPrimaryCalendarType(),S=m.getShowWeekNumbers();if(h==g.Islamic||!S){s=s+" sapUiCalNoWeekNum";}return s;};M.renderMonth=function(r,m,o){var i=m.getId();this.renderHeader(r,m,o);r.write("<div id=\""+i+"-days\" class=\"sapUiCalItems\" role=\"row\">");this.renderDays(r,m,o);r.write("</div>");};M.renderHeader=function(r,m,o){var h=m._getLocaleData();var F=m._getFirstDayOfWeek();var i=m.getId();var j=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");this.renderHeaderLine(r,m,h,o);r.write("<div");r.writeAttribute("id",i+"-CW");r.addStyle("display","none");r.writeStyles();r.writeAccessibilityState(null,{role:"columnheader"});r.write(">");r.write(j.getText("CALENDAR_WEEK"));r.write("</div>");r.write("<div");r.writeAccessibilityState(null,{role:"row"});r.addStyle("overflow","hidden");r.writeStyles();r.write(">");this.renderDayNames(r,m,h,F,7,true,undefined);r.write("</div>");};M.renderHeaderLine=function(r,m,o,h){C._checkCalendarDate(h);if(m._getShowHeader()){var i=m.getId();var s=m.getPrimaryCalendarType();var j=o.getMonthsStandAlone("wide",s);r.write("<div id=\""+i+"-Head\"class=\"sapUiCalHeadText\" >");r.write(j[h.getMonth()]);r.write("</div>");}};M.renderDayNames=function(r,m,o,s,h,j,w){var F=m._getFirstDayOfWeek();var k=m.getId();var n="";var p=m.getPrimaryCalendarType();var W=[];if(m._bLongWeekDays||!m._bNamesLengthChecked){W=o.getDaysStandAlone("abbreviated",p);}else{W=o.getDaysStandAlone("narrow",p);}var q=o.getDaysStandAlone("wide",p);for(var i=0;i<h;i++){r.write("<div");r.addClass("sapUiCalWH");if(j){n=k+"-WH"+((i+F)%7);}else{n=k+"-WH"+i;}r.writeAttribute("id",n);if(i==0){r.addClass("sapUiCalFirstWDay");}if(w){r.addStyle("width",w);}r.writeAccessibilityState(null,{role:"columnheader",label:q[(i+s)%7]});r.writeClasses();r.writeStyles();r.write(">");r.write(W[(i+s)%7]);r.write("</div>");}};M.renderDays=function(r,m,o){var w,h,j,H,i,t,s;C._checkCalendarDate(o);if(!o){o=m._getFocusedDate();}t=o.toUTCJSDate().getTime();if(!t&&t!==0){throw new Error("Date is invalid "+m);}H=this.getDayHelper(m,o);h=m._getVisibleDays(o,true);s=m.getShowWeekNumbers();w=m.getPrimaryCalendarType()!==g.Islamic&&s;j=h.length;for(i=0;i<j;i++){this.renderDay(r,m,h[i],H,true,w,-1);}};M.getDayHelper=function(m,o){var h,s,i=m._getLocaleData(),H={sLocale:m._getLocale(),oLocaleData:i,iMonth:o.getMonth(),iYear:o.getYear(),iFirstDayOfWeek:m._getFirstDayOfWeek(),iWeekendStart:i.getWeekendStart(),iWeekendEnd:i.getWeekendEnd(),aNonWorkingDays:m._getNonWorkingDays(),sToday:i.getRelativeDay(0),oToday:a.fromLocalJSDate(new Date(),m.getPrimaryCalendarType()),sId:m.getId(),oFormatLong:m._getFormatLong(),sSecondaryCalendarType:m._getSecondaryCalendarType(),oLegend:undefined};s=m.getLegend();if(s&&typeof s==="string"){h=sap.ui.getCore().byId(s);if(h){if(!(h instanceof b)){throw new Error(h+" is not an sap.ui.unified.CalendarLegend. "+m);}H.oLegend=h;}else{L.warning("CalendarLegend "+s+" does not exist!",m);}}return H;};M.renderDay=function(r,m,o,h,O,w,n,W,j){C._checkCalendarDate(o);var s=new a(o,h.sSecondaryCalendarType),A={role:m._getAriaRole(),selected:false,label:"",describedby:""},B=o._bBeforeFirstYear,k="";var y=m._oFormatYyyymmdd.format(o.toUTCJSDate(),true);var p=o.getDay();var S=m._checkDateSelected(o);var q=m._getDateTypes(o);var E=m._checkDateEnabled(o);var i=0;if(B){E=false;}var t=0;if(w){t=m._calculateWeekNumber(o);A["describedby"]=h.sId+"-CW"+" "+h.sId+"-WNum-"+t;}if(!j){var u="";if(n<0){u=h.sId+"-WH"+p;}else{u=h.sId+"-WH"+n;}A["describedby"]=A["describedby"]+" "+u;}r.write("<div");r.writeAttribute("id",h.sId+"-"+y);r.addClass("sapUiCalItem");r.addClass("sapUiCalWDay"+p);if(W){r.addStyle("width",W);}if(p==h.iFirstDayOfWeek){r.addClass("sapUiCalFirstWDay");}if(O&&h.iMonth!=o.getMonth()){r.addClass("sapUiCalItemOtherMonth");A["disabled"]=true;}if(o.isSame(h.oToday)){r.addClass("sapUiCalItemNow");A["label"]=h.sToday+" ";}if(S>0){r.addClass("sapUiCalItemSel");A["selected"]=true;}else{A["selected"]=false;}if(S==2){r.addClass("sapUiCalItemSelStart");A["describedby"]=A["describedby"]+" "+h.sId+"-Start";}else if(S==3){r.addClass("sapUiCalItemSelEnd");A["describedby"]=A["describedby"]+" "+h.sId+"-End";}else if(S==4){r.addClass("sapUiCalItemSelBetween");}else if(S==5){r.addClass("sapUiCalItemSelStart");r.addClass("sapUiCalItemSelEnd");A["describedby"]=A["describedby"]+" "+h.sId+"-Start";A["describedby"]=A["describedby"]+" "+h.sId+"-End";}q.forEach(function(v){if(v.type!=f.None){if(v.type===f.NonWorking){r.addClass("sapUiCalItemWeekEnd");return;}r.addClass("sapUiCalItem"+v.type);k=v.type;if(v.tooltip){r.writeAttributeEscaped('title',v.tooltip);}}});if(((m.getParent()&&m.getParent().getMetadata().getName()==="sap.ui.unified.CalendarOneMonthInterval")||(m.getMetadata().getName()==="sap.ui.unified.calendar.OneMonthDatesRow"))&&m.getStartDate()&&o.getMonth()!==m.getStartDate().getMonth()){r.addClass("sapUiCalItemOtherMonth");}if(!E){r.addClass("sapUiCalItemDsbl");A["disabled"]=true;}if(h.aNonWorkingDays){for(i=0;i<h.aNonWorkingDays.length;i++){if(p==h.aNonWorkingDays[i]){r.addClass("sapUiCalItemWeekEnd");break;}}}else if((p>=h.iWeekendStart&&p<=h.iWeekendEnd)||(h.iWeekendEnd<h.iWeekendStart&&(p>=h.iWeekendStart||p<=h.iWeekendEnd))){r.addClass("sapUiCalItemWeekEnd");}r.writeAttribute("tabindex","-1");r.writeAttribute("data-sap-day",y);if(j){A["label"]=A["label"]+h.aWeekDaysWide[p]+" ";}A["label"]=A["label"]+h.oFormatLong.format(o.toUTCJSDate(),true);if(k!==""){c.addCalendarTypeAccInfo(A,k,h.oLegend);}if(h.sSecondaryCalendarType){A["label"]=A["label"]+" "+m._oFormatSecondaryLong.format(s.toUTCJSDate(),true);}r.writeAccessibilityState(null,A);r.writeClasses();r.writeStyles();r.write(">");r.write("<span");r.addClass("sapUiCalItemText");r.writeClasses();r.write(">");if(!B){r.write(o.getDate());}r.write("</span>");if(w&&p==h.iFirstDayOfWeek){r.write("<span");r.writeAttribute("id",h.sId+"-WNum-"+t);r.addClass("sapUiCalWeekNum");r.writeClasses();r.writeAccessibilityState(null,{role:"rowheader",desribedby:h.sId+"-CW"});r.write(">");r.write(t);r.write("</span>");}if(j){r.write("<span");r.addClass("sapUiCalDayName");r.writeClasses();r.write(">");r.write(h.aWeekDays[p]);r.write("</span>");}if(h.sSecondaryCalendarType){r.write("<span");r.addClass("sapUiCalItemSecText");r.writeClasses();r.write(">");r.write(s.getDate());r.write("</span>");}r.write("</div>");};return M;},true);
