/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/Popup','sap/ui/core/theming/Parameters','sap/ui/core/RenderManager','./library','./ToolPopupRenderer','sap/ui/core/ResizeHandler','sap/ui/core/library','sap/base/assert','sap/base/Log','sap/ui/dom/jquery/rect','sap/ui/dom/jquery/control','sap/ui/dom/jquery/Selectors'],function(q,C,I,P,a,R,l,T,b,c,d,L){"use strict";var O=c.OpenState;var e=C.extend("sap.ui.ux3.ToolPopup",{metadata:{interfaces:["sap.ui.core.PopupInterface"],library:"sap.ui.ux3",properties:{title:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconHover:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconSelected:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},modal:{type:"boolean",group:"Behavior",defaultValue:false},inverted:{type:"boolean",group:"Misc",defaultValue:true},autoClose:{type:"boolean",group:"Misc",defaultValue:false},maxHeight:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},maxWidth:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},openDuration:{type:"int",group:"Misc",defaultValue:400},closeDuration:{type:"int",group:"Misc",defaultValue:400}},defaultAggregation:"content",aggregations:{buttons:{type:"sap.ui.core.Control",multiple:true,singularName:"button"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},associations:{initialFocus:{type:"sap.ui.core.Control",multiple:false},opener:{type:"sap.ui.core.Control",multiple:false},defaultButton:{type:"sap.ui.core.Control",multiple:false}},events:{open:{},close:{allowPreventDefault:true},enter:{parameters:{originalEvent:{type:"object"},originalSrcControl:{type:"sap.ui.core.Control"}}},iconChanged:{},closed:{},opened:{}}}});e.ARROW_LEFT=new RegExp(/my:(left|begin)([-+]\d*\%?)?\|[a-z]+([-+]\d*\%?)? at:(right|end)\|[a-z]+/);e.ARROW_RIGHT=new RegExp(/my:(right|end)([-+]\d*\%?)?\|[a-z]+([-+]\d*\%?)? at:(left|begin)\|[a-z]+/);e.ARROW_UP=new RegExp(/my:[a-z]+([-+]\d*\%?)?\|top([-+]\d*\%?)? at:[a-z]+\|bottom/);e.ARROW_DOWN=new RegExp(/my:[a-z]+([-+]\d*\%?)?\|bottom([-+]\d*\%?)? at:[a-z]+\|top/);(function(){e.prototype.init=function(){this.oPopup=null;this._bPositionSet=false;this._mParameters={};this._mParameters.that=this;this._mParameters.firstFocusable=this.getId()+"-firstFocusable";this._mParameters.lastFocusable=this.getId()+"-lastFocusable";this._bFocusSet=false;this._proxyOpened=q.proxy(p,this);this._proxyClosed=q.proxy(o,this);this._proxyFixSize=q.proxy(F,this);this._proxyOnResize=q.proxy(j,this);s(this);};e.prototype.exit=function(){if(this.oPopup){this.oPopup.detachOpened(this._proxyOpened);this.oPopup.detachClosed(this._proxyClosed);this.oPopup.destroy();delete this.oPopup;}delete this._bPositionSet;delete this._mParameters;delete this._bFocusSet;delete this._bPreventRestoreFocus;delete this._proxyOpened;delete this._proxyClosed;delete this._bRTL;delete this._sArrowDir;delete this._oArrowIcon;delete this._bThemeInverted;delete this._sInitialFocusId;};var _=function(i){var t=i;d(!!t,"No ToolPopup instance given for _fnGetInitialFocus");if(!t._bFocusSet){f(t);}else{t._sInitialFocusId=t.oPopup._sInitialFocusId;}return t._sInitialFocusId;};var f=function(n){var E;var t;var v=n;var w=[v._mParameters.firstFocusable,v._mParameters.lastFocusable];var x=q(":sapTabbable",v.$()).get();for(var i=0;i<x.length;i++){if(w.indexOf(x[i].id)===-1){E=x[i];break;}}t=q(E).control();if(t[0]){var y=t[0].getFocusDomRef();E=y||E;}else{E=w[0]?window.document.getElementById(w[0]):null;}if(E){if(E){E.focus();}v._sInitialFocusId=E.id;}};function g(t,i){var n,v;if(!i){return null;}n=sap.ui.getCore().byId(i);while(!n&&n!==t){if(!i||!document.getElementById(i)){return null;}v=document.getElementById(i).parentNode;i=v.id;n=sap.ui.getCore().byId(i);}return n;}e.prototype.getFocusDomRef=function(){var i;var n=g(this,this._sInitialFocusId);if(!n){this._bFocusSet=false;i=_(this);n=g(this,i);}return n?n.getDomRef():this.getDomRef();};e.prototype.onfocusin=function(E){this._mParameters.event=E;this._mParameters.$FocusablesContent=q(":sapTabbable",this.$("content"));this._mParameters.$FocusablesFooter=q(":sapTabbable",this.$("buttons"));this.oPopup.focusTabChain(this._mParameters);};var F=function(){var t=this.$();var v=0;var M=this.getMaxHeight();var i=M?parseInt(M):0;var n=this.getMaxWidth();if(n){var w=parseInt(n);var B=t.css("border-left-width");var x=parseInt(B);var y=t.css("border-right-width");var z=parseInt(y);var A=t.css("padding-left");var D=parseInt(A);var E=t.css("padding-right");var H=parseInt(E);w-=x+D+H+z;t.css("max-width",w+"px");}else{t.css("max-width","");}var J=t.css("padding-top");var K=parseInt(J);var N=t.css("padding-bottom");var Q=parseInt(N);var U=t.css("border-top-width");var V=parseInt(U);var W=t.css("border-bottom-width");var X=parseInt(W);var Y=K+Q+V+X;var Z=q(document).scrollTop();var $=t.rect();var a1=$.top-Z+t.outerHeight(true);var b1=q(window).height();var c1=(a1>b1)&&(i===0);var d1=0;if(c1){var e1=q(document.getElementById(this.getOpener()));var f1=e1.rect();var g1=f1.top-Z+e1.outerHeight(true);var h1=this.oPopup._getPositionOffset();if(a1>g1&&h1.length>0){d1=Math.abs(parseInt(h1[1]));if((a1-d1)<b1){c1=false;var i1="Offset of "+d1+" pushes ToolPopup out of the window";L.warning(i1,"","sap.ui.ux3.ToolPopup");}}i=i?i:b1-$.top;}t.toggleClass("sapUiUx3TPLargeContent",c1);if(i||c1){t.css("max-height",i+"px");var j1=this.$("title");var k1=this.$("title-separator");var l1=this.$("buttons");var m1=this.$("buttons-separator");v=i>0?i:b1-$.top-Q-d1;v-=Y;v-=j1.outerHeight(true);v-=k1.outerHeight(true);v-=m1.outerHeight(true);v-=l1.length>0?l1.outerHeight(true):0;v=parseInt(v);var n1=this.$("content");n1.css("max-height",v+"px");n1.toggleClass("sapUiUx3TPLargeContent",true);}S(this);};var p=function(){this._proxyFixSize();if(!this._sInitialFocusId){var i=_(this);if(i!==sap.ui.getCore().getCurrentFocusedControlId()){var n=q(document.getElementById(i));n.focus();}}if(!this._sResizeID){this._sResizeID=b.register(this.$('content')[0],this._proxyOnResize);}this.fireOpened();};e.prototype.isOpen=function(){return this.oPopup&&(this.oPopup.getOpenState()=="OPENING"||this.oPopup.getOpenState()=="OPEN");};e.prototype.willBeClosed=function(){var i=this.oPopup&&this.oPopup.getOpenState();return i!==O.OPENING&&i!==O.OPEN;};e.prototype.open=function(i,n){this._my=i;this._at=n;this._sArrowDir=G(this);var $=null;this.sOffset="";u(this);if(!this._bPositionSet){var t=0;var v=0;if(!this._my){this._my=P.Dock.BeginTop;}if(!this._at){this._at=P.Dock.EndTop;}$=this.getOpener()?window.document.getElementById(this.getOpener()):null;if($){switch(this._sArrowDir){case"Up":t=0;v=this.iArrowWidth;break;case"Down":t=0;v=-this.iArrowWidth;break;case"Right":t=-this.iArrowWidth;break;default:case"Left":t=this.iArrowWidth;break;}t=parseInt(t);v=parseInt(v);this.sOffset=""+t+" "+v;this.setPosition(this._my,this._at,$,this.sOffset,"none");}else{this.setPosition(P.Dock.BeginTop,P.Dock.BeginTop,window,"0 0","fit");L.warning("No opener set. Using a default position for Popup","","sap.ui.ux3.ToolPopup");}this._bPositionSet=false;}this._ensurePopup();var A=this.getAutoClose();var M=this.getModal();if(A&&M){L.warning("A modal & autoclose ToolPopup will not work properly. Therefore 'autoclose' will be deactived!");A=false;}this.oPopup.setAutoClose(A);this.oPopup.setModal(M);this._oPreviousFocus=P.getCurrentFocusInfo();this.fireOpen();h(this);this.oPopup.open(this.getOpenDuration(),this._my,this._at,$,this.sOffset,"",true);S(this);return this;};var h=function(t){if(!t.getOpener()){var i="";if(t.oPopup){if(t.oPopup._oPosition.of instanceof sap.ui.core.Element){i=t.oPopup._oPosition.of.getId();}else{if(t.oPopup._oPosition.of.length>0){i=t.oPopup._oPosition.of[0].id;}else{i=t.oPopup._oPosition.of.id;}}}if(i!==""){t.setAssociation("opener",i,true);}else{L.error("Neither an opener was set properly nor a corresponding one can be distinguished","","sap.ui.ux3.ToolPopup");}}};var s=function(t){var i="sapUiUx3ToolPopupArrowWidth";t.sArrowWidth=a.get(i);t.iArrowWidth=parseInt(t.sArrowWidth);i="sapUiUx3ToolPopupArrowHeight";t.sArrowHeight=a.get(i);t.iArrowHeight=parseInt(t.sArrowHeight);i="sapUiUx3ToolPopupArrowRightMarginCorrection";t.sArrowPadding=a.get(i);t.iArrowPadding=parseInt(t.sArrowPadding);i="sapUiUx3ToolPopupArrowRightMarginCorrectionInverted";t.sArrowPaddingInverted=a.get(i);t.iArrowPaddingInverted=parseInt(t.sArrowPaddingInverted);};var G=function(t){var D="Left";var i=t._my;var n=t._at;if(!i&&t.oPopup){i=t.oPopup._oPosition.my;}if(!n&&t.oPopup){n=t.oPopup._oPosition.at;}t._bHorizontalArrow=false;if(i&&n){var M=i.split(" ");var A=n.split(" ");var v="my:"+M[0]+"|"+M[1];v+=" at:"+A[0]+"|"+A[1];if(e.ARROW_LEFT.exec(v)){t._bHorizontalArrow=true;D="Left";}else if(e.ARROW_RIGHT.exec(v)){t._bHorizontalArrow=true;D="Right";}else if(e.ARROW_UP.exec(v)){D="Up";}else if(e.ARROW_DOWN.exec(v)){D="Down";}if(t.getDomRef()&&t.isOpen()){var $=t.$();var w=$.rect();var x=q(document.getElementById(t.getOpener()));var y=x.rect();if(y){if(t._bHorizontalArrow){var z=w.left+$.outerWidth(true)+t.iArrowWidth;var B=y.left+x.outerWidth(true);if(z<=B){D="Right";}else{D="Left";}}else{var E=w.top+$.outerHeight(true)+t.iArrowWidth;var H=y.top+x.outerHeight(true);if(E<=H){D="Down";}else{D="Up";}}}}}return D;};var S=function(t){var K="",v=0,z=0,H=t.iArrowHeight/2,i=sap.ui.getCore().getConfiguration().getRTL(),A,n=t.$().rect(),w=q(document.getElementById(t.getOpener())),x=w.rect(),y=0,$=t.$("arrow");if(!t.getDomRef()){return;}t._sArrowDir=G(t);A=t._sArrowDir;if(i){if(t._sArrowDir==="Right"){A="Left";}else if(t._sArrowDir==="Left"){A="Right";}}if(!x){L.warning("Opener wasn't set properly. Therefore arrow will be at a default position","","sap.ui.ux3.ToolPopup");}if(!t._my&&t.oPopup){t._my=t.oPopup._oPosition.my;}if(t._bHorizontalArrow){K="top";if(x){y=parseInt(t.$().css('border-top-width'))||0;z=parseInt(x.top-y-n.top);v=Math.round(z+x.height/2-H);v=v+H>n.height?v-t.iArrowHeight:v;}}else{K="left";if(x){if(i){K="right";y=parseInt(t.$().css('border-right-width'))||0;z=parseInt(n.left+n.width-x.left-x.width-y);}else{y=parseInt(t.$().css('border-left-width'))||0;z=parseInt(x.left-n.left-y);}v=Math.round(z+x.width/2-H);v=v+H>n.width?v-t.iArrowHeight:v;}}if(!x){v=t.iArrowHeight;}var B="";if($.hasClass("sapUiUx3TPNewArrow")){B="sapUiUx3TPNewArrow sapUiUx3TPNewArrow";}else{B=t.isInverted()?"sapUiUx3TPArrow sapUiTPInverted sapUiUx3TPArrow":"sapUiUx3TPArrow sapUiUx3TPArrow";}$.attr("class",B+A);if(A==="Right"){var W=n.width;if(t.isInverted()){W+=t.iArrowPaddingInverted;}else{W+=t.iArrowPadding;}if(i){$.css("right",W+"px");}else{$.css("left",W+"px");}}else{$.css({"left":"","right":""});}v=parseInt(v);v=v<-y?-y:v;$.css(K,v+"px");};e.prototype.onsapescape=function(){if(this.fireClose()){this.close();}};var o=function(E){if(!this._bPreventRestoreFocus){P.applyFocusInfo(this._oPreviousFocus);}if(this.getDomRef()){R.preserveContent(this.getDomRef());this.$().remove();}this.fireClosed();};e.prototype.close=function(i){if(this.oPopup&&this.oPopup.isOpen()){if(this._sResizeID){b.deregister(this._sResizeID);delete this._sResizeID;}this.oPopup.close(this.getCloseDuration());this._bPreventRestoreFocus=i;}return this;};e.prototype.getEnabled=function(){var i=this.oPopup?this.oPopup.getOpenState():O.CLOSED;return i===O.OPENING||i===O.OPEN;};e.prototype.onsapenter=function(E){var i=this.getDefaultButton();var n=sap.ui.getCore().byId(i);if(i&&n&&q.contains(this.getDomRef(),n.getDomRef())){if(n instanceof sap.ui.commons.Button){var $=n.$();$.click();$.focus();}}E.preventDefault();E.stopPropagation();};e.prototype.onBeforeRendering=function(){var i=this.getInitialFocus()||this._sInitialFocusId;var D=this.getDefaultButton();this._bFocusSet=true;if(i){this.oPopup.setInitialFocusId(i);}else if(D){this.oPopup.setInitialFocusId(D);}else{this._bFocusSet=false;}this._bRTL=sap.ui.getCore().getConfiguration().getRTL();};e.prototype._ensurePopup=function(){if(!this.oPopup){this.oPopup=new P(this,false,true,false);this.oPopup.attachOpened(this._proxyOpened);this.oPopup.attachClosed(this._proxyClosed);var t=this;this.oPopup._applyPosition=function(){P.prototype._applyPosition.apply(t.oPopup,arguments);var i=t.oPopup._oLastPosition.of;if(!i){t.oPopup.close();}else{var $=q(document.getElementById(i.id));if(t._bPositionSet){if(!$.hasClass("sapUiUx3ShellTool")){t._my=t.oPopup._oLastPosition.my;t._at=t.oPopup._oLastPosition.at;}}S(t);}};}return this.oPopup;};var j=function(){if(this.getContent().length){this._proxyFixSize();this.oPopup._applyPosition(this.oPopup._oLastPosition);}};e.prototype.setPosition=function(){this._ensurePopup();this.oPopup.setPosition.apply(this.oPopup,arguments);this._bPositionSet=true;h(this);return this;};var k=function(i,t){var n=i;if(t==="content"){r(n);}else if(t==="buttons"){m(n);}n._proxyFixSize();n.oPopup._applyPosition(n.oPopup._oLastPosition);};var r=function(t){var n=t.getDomRef("content");n.innerHTML="";var v=t.getContent();var w=sap.ui.getCore().createRenderManager();for(var i=0;i<v.length;i++){w.renderControl(v[i]);}w.flush(n,true);w.destroy();};var m=function(t){var B=t.getDomRef("buttons");var n=t.getDomRef("buttons-separator");var v=t.getButtons();if(v.length===0){q(B).addClass("sapUiUx3TPButtonRowHidden");q(n).addClass("sapUiUx3TPButtonRowHidden");}else{q(B).removeClass("sapUiUx3TPButtonRowHidden");q(n).removeClass("sapUiUx3TPButtonRowHidden");B.innerHTML="";var w=sap.ui.getCore().createRenderManager();for(var i=0;i<v.length;i++){w.renderControl(v[i]);}w.flush(B,true);w.destroy();}};e.prototype.addContent=function(i){this.addAggregation("content",i,true);if(this.isOpen()){k(this,"content");}return this;};e.prototype.insertContent=function(i,n){this.insertAggregation("content",i,n,true);if(this.isOpen()){k(this,"content");}return this;};e.prototype.removeContent=function(i){this.removeAggregation("content",i,true);if(this.isOpen()){k(this,"content");}return this;};e.prototype.addButton=function(B){this.addAggregation("buttons",B,true);if(this.isOpen()){k(this,"buttons");}return this;};e.prototype.insertButton=function(B,i){this.insertAggregation("buttons",B,i,true);if(this.isOpen()){k(this,"buttons");}return this;};e.prototype.removeButton=function(B){this.removeAggregation("button",B,true);if(this.isOpen()){k(this,"buttons");}return this;};var u=function(t){var i="sapUiUx3ToolPopupInverted";i=a.get(i);t._bThemeInverted=i==="true";};e.prototype.onThemeChanged=function(){u(this);};e.prototype.isInverted=function(){u(this);return this.getInverted()&&this._bThemeInverted;};e.prototype.setAutoCloseAreas=function(A){this._ensurePopup();return this.oPopup.setAutoCloseAreas(A);};e.prototype.addFocusableArea=function(i){this._ensurePopup();if(typeof(i)==="string"){this.oPopup._addFocusableArea("channelId","eventId",{id:i});return this;}else{L.error("Wrong type of focusable area ID - string expected","","sap.ui.ux3.ToolPopup");}};e.prototype.removeFocusableArea=function(i){this._ensurePopup();if(typeof(i)==="string"){this.oPopup._removeFocusableArea("channelId","eventId",{id:i});return this;}else{L.error("Wrong type of focusable area ID - string expected","","sap.ui.ux3.ToolPopup");}};}());e.prototype.setIcon=function(i){this.setProperty("icon",i,true);this.fireIconChanged();return this;};e.prototype.setIconHover=function(i){this.setProperty("iconHover",i,true);this.fireIconChanged();return this;};e.prototype.setIconSelected=function(i){this.setProperty("iconSelected",i,true);this.fireIconChanged();return this;};e.prototype.getIconSelected=function(){return this.getProperty("iconSelected")||this.getProperty("iconHover");};e.prototype.setMaxWidth=function(m){var p=/[0-9]+px/;if(p.test(m)){this.setProperty("maxWidth",m);}else{L.error("Only values in pixels are possible","","sap.ui.ux3.ToolPopup");}return this;};return e;});
