/*
 * ! SAP UI development toolkit for HTML5 (SAPUI5) (c) Copyright 2009-2012 SAP AG. All rights reserved
 */
sap.ui.define(["sap/ui/core/Element","./library"],function(E,l){"use strict";var c=jQuery.sap.log;var A=E.extend("sap.ui.vbm.Adapter",{metadata:{library:"sap.ui.vbm",associations:{map:{type:"sap.ui.vbm.GeoMap"}},events:{submit:{parameters:{data:{type:"string"}}}}}});A.prototype.init=function(){this._eventHandlers=[];this._actions=[];this._mapConfiguration={};this._clusterVOs=new Map();this._dataTypes={};this._data={};this._idKeyMap={};this._propsAnomalies=new Map();this._propsAnomalies.set("pos","position");this._propsAnomalies.set("posarray","position");this._propsAnomalies.set("dragdata","dragData");this._routeProperties=["color","colorBorder","directionIndicator","dotcolor","dotwidth","dragdata","end","hotDeltaColor","labelBgColor","labelPos","labelText","lineDash","linewidth","posarray","selectColor","start","tooltip"];this._spotProperties=["alignment","contentOffset","dragdata","fxdir","fxsize","hotDeltaColor","icon","image","labelBgColor","labelPos","labelText","pos","selectColor","tooltip","semanticType"];};A.prototype.exit=function(){this._actions.forEach(function(a){a.detach();});this._detachHandlers();};A.prototype.setMap=function(m){var o=this._map()||null;var n=sap.ui.getCore().byId(m instanceof sap.ui.vbm.GeoMap?m.getId():m);if((o!=n)&&(o!=null)){this._detachHandlers();this.init();}this.setAssociation("map",m,true);if(n!=null){var M=new sap.ui.model.json.JSONModel();M.setSizeLimit(100000);n.setModel(M);}};A.prototype._map=function(){return sap.ui.getCore().byId(this.getMap());};A.prototype._attachHandler=function(e,h,a){if((e in this.mEventRegistry)&&(this.mEventRegistry[e].length>0)){return this;}else{if(!a._eventHandlers.some(function(b){return b===h;})){a._eventHandlers.push(h);}this.attachEvent(e,h,a);return this;}};A.prototype._detachHandlers=function(){var t=this;var d=function(s){if(this.hasListeners(s)){var b=this.mEventRegistry[s];for(var i=0,L=b.length;i<L;i++){var h=t._eventHandlers.indexOf(b[i].fFunction);if(h!==-1){this.detachEvent(s,b[i].fFunction,b[i].oListener);}}}};var g=this._map();if(g!=null){var m=g.mEventRegistry;for(var e in m){if(m.hasOwnProperty(e)){d.call(g,e);}}var a=function(v){var V=v.mEventRegistry;for(var b in V){if(V.hasOwnProperty(b)){d.call(v,b);}}};g.getVos().forEach(a);}return this;};A.prototype.load=function(d){var o=null;if(typeof d==='string'){try{o=JSON.parse(d);}catch(e){c.debug("sap.ui.vbm.Adapter: attempt to load invalid JSON string.");return this;}}else if(typeof d==='object'){o=d;}if(!o){c.debug("sap.ui.vbm.Adapter: nothing to load.");return this;}if(!o.SAPVB){c.debug("sap.ui.vbm.Adapter:invalid object supplied for load.");return this;}if(o.SAPVB.Config){this._processConfiguration(o.SAPVB.Config);}if(o.SAPVB.Resources){this._processResources(o.SAPVB.Resources);}if(o.SAPVB.DataTypes){this._processDataTypes(o.SAPVB.DataTypes);}if(o.SAPVB.Clustering){this._processClusters(o.SAPVB.Clustering);}return(o.SAPVB.MapProviders?this._processMapProviders(o.SAPVB.MapProviders):Promise.resolve()).then(function(){if(o.SAPVB.MapLayerStacks){this._processMapLayerStacks(o.SAPVB.MapLayerStacks);}if(o.SAPVB.Scenes){this._processScenes(o.SAPVB.Scenes);}if(o.SAPVB.Data){this._processData(o.SAPVB.Data);}if(o.SAPVB.Actions){this._processActions(o.SAPVB.Actions);}if(o.SAPVB.Automation&&o.SAPVB.Automation.Call){this._processAutomation(o.SAPVB.Automation,o.SAPVB.Menus);}if(o.SAPVB.Windows){this._processDetailWindows(o);}}.bind(this));};A.prototype._processConfiguration=function(a){return this;};A.prototype._processResources=function(r){if(r.Set){var g=this._map();g.destroyResources();[].concat(r.Set.Resource).forEach(function(a){g.addResource(new sap.ui.vbm.Resource({"name":a.name,"value":a.value}));},this);}return this;};A.prototype._processDataTypes=function(d){if(d.Set){if(d.Set.name&&d.Set.type&&(d.Set.type==="N")){[].concat(d.Set.N).foreach(function(a){this._dataTypes.forEach(function(_){if(_.name==a.name){_=a;}});});}else{this._dataTypes=[].concat(d.Set.N);}}return this;};A.prototype._processData=function(b){var g=function(a,n){var e=sap.ui.vbm.findInArray(this._dataTypes,function(_){return _.name==n;});if((e==null)||!(e.A)){return undefined;}else{var o=sap.ui.vbm.findInArray(e.A,function(_){return _.alias==a;});if(o!=null){return o.name;}else{return undefined;}}};var h=function(n){if(n.name&&n.E){this._data[n.name]=[].concat(n.E).map(function(e){var d={};for(var a in e){if((a!=="xmlns:VB")&&(a!=="n.name")&&e.hasOwnProperty(a)){if(a==="VB:c"){d["changeable"]=e[a];}else if(a==="VB:s"){d["select"]=e[a];}else{var s=g.call(this,a,n.name);if((s!=null)&&(s!=="")){d[s]=e[a];}else{d[a]=e[a];}}}}return d;},this);}};var u=function(e){var d={};for(var a in e){if((a!=="xmlns:VB")&&(a!=="n.name")&&e.hasOwnProperty(a)){if(a==="VB:c"){d["changeable"]=e[a];}else if(a==="VB:s"){d["select"]=e[a];}else{var s=g.call(this,a,e["n.name"]);if((s!=null)&&(s!=="")){d[s]=e[a];}else{d[a]=e[a];}}}}if(!this._data[e["n.name"]]){this._data[e["n.name"]]=[];}if(this._data[e["n.name"]].some(function(_){return _.Key==e.K;})){var i=sap.ui.vbm.findIndexInArray(this._data[e["n.name"]],function(_){return _.Key===e.K;});if(i!==-1){this._data[e["n.name"]][i]=d;}}else{this._data[e["n.name"]].push(d);}};if(b.Remove){[].concat(b.Remove).filter(function(r){return(r.N&&r.N.E);}).forEach(function(r){[].concat(r.N.E).forEach(function(e){var i=sap.ui.vbm.findIndexInArray(this._data[r.name],function(_){return _.Key===e.K;});if(i!==-1){this._data[r.name].splice(i,1);}},this);},this);}if(b.Set&&(typeof b.Set==='object')&&!(jQuery.isEmptyObject(b.Set))){if(!Array.isArray(b.Set)&&!(b.Set.name)&&!(b.Set.type)){this._data={};if(b.Set.N!==null){[].concat(b.Set.N).forEach(h,this);}}else{[].concat(b.Set).filter(function(s){return(s.name)&&(s.type);}).map(function(s){return[].concat(s.N);}).reduce(function(a,B){return a.concat(B);}).map(function(n){var e=n.hasOwnProperty("E")&&n.E?[].concat(n.E):[];return e.map(function(_){_["n.name"]=n.name;return _;});}).reduce(function(a,B){return a.concat(B);}).forEach(u,this);}}this._map().getModel().setData(this._data,false);return this;};A.prototype._processMapProviders=function(p){if(p.Set&&p.Set.MapProvider){var m=[].concat(p.Set.MapProvider).map(function(a){return{name:a.name,tileX:a.tileX,tileY:a.tileY,minLOD:a.minLOD,maxLOD:a.maxLOD,copyright:a.copyright,MapBase:a.MapBase,copyrightImage:a.copyrightImage,copyrightLink:a.copyrightLink,description:a.description,projection:a.projection,resolution:a.resolution,retries:a.retries,type:a.type,Source:a.Source?[].concat(a.Source).map(function(s){return{id:s.id,url:s.url};}):a.Source};});var d=function(s){return s&&s.url&&s.url.indexOf("google")!==-1;};var G=m.map(function(P){return[].concat(P.Source);}).reduce(function(a,b){return a.concat(b);}).filter(d);if(G.length>0){var e=[];var o=G.reduce(function(g,a){var b=a.url.split("key=")[1];g[b]=g[b]||[];if(sap.ui.vbm.findIndexInArray(e,function(k){return k===b;})===-1){e.push(b);}g[b].push(a);return g;},{});var h=function(a){return new Promise(function(r,b){var x=new XMLHttpRequest();x.open("POST",'https://www.googleapis.com/tile/v1/createSession?key='+a,true);x.setRequestHeader("Content-Type","application/json");x.onreadystatechange=function(){if(x.readyState==4){if(x.status==200){r(JSON.parse(x.responseText));}else{b(new Error(x.statusText));}}};var g={"mapType":"terrain","language":"en-NZ","region":"nz","layerTypes":["layerRoadmap"],"overlay":false,"scale":"scaleFactor1x"};x.send(JSON.stringify(g));}).then(function(r){if(r&&r.session){o[a].forEach(function(s){s.url=s.url+"&session="+r.session;});}},function(s){c.debug(s);});};return Promise.all(e.map(h)).then(function(){this._mapConfiguration.MapProvider=m;this._updateMapconfiguration();}.bind(this));}else{this._mapConfiguration.MapProvider=m;this._updateMapconfiguration();return Promise.resolve();}}return this;};A.prototype._processMapLayerStacks=function(s){if(s.Set&&s.Set.MapLayerStack){this._mapConfiguration.MapLayerStacks=[];[].concat(s.Set.MapLayerStack).forEach(function(a){var b={name:a.name},d="true";if(a.MapLayer){b.MapLayer=[];[].concat(a.MapLayer).forEach(function(i){var e={name:i.name,refMapProvider:i.refMapProvider,opacity:i.opacity,colBkgnd:i.colBkgnd,singleBMP:i.singleBMP||"false"};d=e.singleBMP!=="true"?"false":d;b.MapLayer.push(e);});b.singleBMP=a.singleBMP||d;}this._mapConfiguration.MapLayerStacks.push(b);},this);this._updateMapconfiguration();}return this;};A.prototype._updateMapconfiguration=function(){if(this._mapConfiguration.MapProvider&&this._mapConfiguration.MapLayerStacks){this._map().setMapConfiguration(this._mapConfiguration);}return this;};A.prototype._ui5Id=function(i){return this._map().getId()+"-"+i;};A.prototype._processScenes=function(s){if(s.Set&&s.Set.SceneGeo){var m=this._map();if(s.Set.SceneGeo.initialStartPosition){m.setCenterPosition(s.Set.SceneGeo.initialStartPosition);}if(s.Set.SceneGeo.initialZoom){m.setZoomlevel(Math.floor(s.Set.SceneGeo.initialZoom));}if(s.Set.SceneGeo.refMapLayerStack){m.setRefMapLayerStack(s.Set.SceneGeo.refMapLayerStack);}var v=s.Set.SceneGeo.VO;m.destroyVos();if(!v){return this;}v.forEach(function(d){if(this._clusterVOs.has(d.id)){return;}var a,b,e=[],g={};function p(n,o){for(var q in d){var r=q.indexOf('.bind');var t=r!==-1?q.substring(0,r):q;if(n.indexOf(t)!==-1){t=o.get(t)||t;var u=d[q];if(r!==-1){u=d[q].substring(d[q].indexOf('.')+1);e.push(u);}g[t]=r!==-1?"{"+u+"}":u;}}}function h(){if(d.DragSource&&b.getMetadata().hasAggregation("dragSource")){[].concat(d.DragSource.DragItem).forEach(function(n){b.addDragSource(new sap.ui.vbm.DragSource({type:n.type}));});}if(d.DropTarget&&b.getMetadata().hasAggregation("dropTarget")){[].concat(d.DropTarget.DropItem).forEach(function(n){b.addDropTarget(new sap.ui.vbm.DropTarget({type:n.type}));});}}switch(d.type){case"{00100000-2012-0004-B001-64592B8DB964}":p(this._spotProperties,this._propsAnomalies);a=new sap.ui.vbm.Spot(g);b=new sap.ui.vbm.Spots(this._ui5Id(d.id));h();break;case"{00100000-2012-0004-B001-C46BD7336A1A}":p(this._routeProperties,this._propsAnomalies);a=new sap.ui.vbm.Route(g);b=new sap.ui.vbm.Routes(this._ui5Id(d.id));h();break;case"{00100000-2012-0004-B001-F311DE491C77}":case"{00100000-2013-0004-B001-7EB3CCC039C4}":case"{00100000-2013-0004-B001-686F01B57873}":case"{00100000-2012-0004-B001-BFED458C3076}":case"{00100000-2012-0004-B001-383477EA1DEB}":case"{388951f5-a66b-4423-a5ad-e0ee13c2246f}":case"ExtLink":case"ExtArea":default:c.debug("unsupported VO type: "+d.type);return;}var i=sap.ui.vbm.findIndexInArray(this._dataTypes,function(_){return _.name===d.datasource;});if(i!==-1){var j=this._dataTypes[i];a.bindProperty("key",{path:j.key});e.push(j.key);var k=[];j.A.forEach(function(n){if(e.indexOf(n.name)===-1){k.push(n.name);var o=new sap.ui.core.CustomData({key:n.name,value:"{"+n.name+"}"});a.addCustomData(o);}});if(k.length){b.setCustomProperties(k);}b.bindAggregation("items",{path:"/"+d.datasource+"",template:a});}else{b.addItem(a);}m.addVo(b);}.bind(this));}else if(s.Merge&&s.Merge.SceneGeo&&s.Merge.SceneGeo.refMapLayerStack){this._map().setRefMapLayerStack(s.Merge.SceneGeo.refMapLayerStack);}return this;};function f(d,a){Object.assign(this,d);this._adapter=a;if(!this.refVO){this.refVO="General";}}f.prototype.attach=function(){var a=false;this._listener=this._adapter;this._handler=this._adapter._handler;if(this.refVO==="Map"||this.refVO==="General"){this._target=this._adapter._map();}else{var i=this._adapter._ui5Id(this.refVO);this._target=sap.ui.vbm.findInArray(this._adapter._map().getVos(),function(v){return v.getId()===i;});if(!this._target){this._target=this._adapter._clusterVOs.get(this.refVO);a=!!this._target;}}if(!this._target){c.warning("unable to attach action: "+this.id);return false;}switch(this.refEvent){case"Click":this._event="click";if(a){this._listener=this;this._handler=function(e){this._adapter._handler(e,this);};}break;case"ContextMenu":this._event="contextMenu";if(a){this._listener=this;this._handler=function(e){this._adapter._handler(e,this);};}break;case"DoubleClick":this._event="click";this._handler=this._adapter._clickHandler;if(a){this._listener=this;this._handler=function(e){this._adapter._clickHandler(e,this);};}break;case"Drop":this._event="drop";break;case"Select":this._event="select";break;case"KeyPress":if(this._target!==this._adapter._map()){return false;}this._event="keyDown";this._target.setKeyEventDelay(250);this._target.setAllowKeyEventRepeat(false);this._handler=this._adapter._getKeyboardHandler(this.name);break;default:return false;}this._target.attachEvent(this._event,this._handler,this._listener);this._target.invalidate();return true;};f.prototype.detach=function(){if(this._target&&this._event&&this._handler&&this._listener){this._target.detachEvent(this._event,this._handler,this._listener);this._target.invalidate();this._target=this._event=this._handler=this._listener=undefined;}};A.prototype._removeAction=function(i){var r=this._actions[i];r.detach();this._actions.splice(i,1);if(r.refEvent==="DoubleClick"){var a=sap.ui.vbm.findInArray(this._actions,function(b){return b.refVO===r.refVO&&b.refEvent==="Click";});if(a){a.attach();}}};A.prototype._addAction=function(d){var a=new f(d,this);if(d.refEvent==="Click"){if(this._actions.some(function(a){return a.refVO===d.refVO&&a.refEvent==="DoubleClick";},this)){this._actions.push(a);return;}}else if(d.refEvent==="DoubleClick"){var b=sap.ui.vbm.findInArray(this._actions,function(a){return a.refVO===d.refVO&&a.refEvent==="Click";},this);if(b){b.detach();}}if(a.attach()){this._actions.push(a);}else{c.info("unable to attach action: "+d.id);}};A.prototype._processActions=function(a){var b,i;if(a.Remove){if(a.Remove.Action){b=[].concat(a.Remove.Action);}else{b=[].concat(a.Remove);}b.forEach(function(d){i=sap.ui.vbm.findIndexInArray(this._actions,function(e){return e.id===d.id});if(i!==-1){this._removeAction(i);}else{c.info("remove of nonexistent action: "+d.id);}},this);}if(a.Set){if(a.Set.Action){b=[].concat(a.Set.Action);}else{b=[].concat(a.Set);}b.forEach(function(d){i=sap.ui.vbm.findIndexInArray(this._actions,function(e){return e.id===d.id});if(i!==-1){this._removeAction(i);}this._addAction(d);},this);}return this;};A.prototype._getKeyboardHandler=function(n){return function(e){var p=e.mParameters;if(p.key=="Shift"||p.code==16||p.key=="Control"||p.code==17||p.key=="Alt"||p.code==18||p.key=="Meta"||p.code==91){return;}var d={"version":"2.0","xmlns:VB":"VB","Action":{"name":n,"Params":{"Param":[{"name":"code","#":p.code},{"name":"shift","#":p.shift},{"name":"ctrl","#":p.ctrl},{"name":"alt","#":p.alt},{"name":"meta","#":p.meta}]}}};this.fireSubmit({data:JSON.stringify(d)});};};A.prototype.idKeyMapGenerator=function(){this._map().getVos().map(function(a){return a.getItems();}).reduce(function(a,b){return a.concat(b);}).forEach(function(i){this._idKeyMap[i.getUniqueId()]=i.getKey();},this);return this;};A.prototype._processAutomation=function(d,m){var g={};if(d.Call.handler==="CONTEXTMENUHANDLER"){var t=this;var h=this._map();if(d.Call.instance&&d.Call.instance.split('.').length==2){var v=this._map().getVos().map(function(V){return V.getItems();}).reduce(function(V,o){return V.concat(o);}).filter(function(V){return V.getKey()===d.Call.instance.split('.')[1];});if(v.length>0){h=v[0];d.Call.instance=h.getUniqueId();d.Call.object=t._ui5Id(d.Call.object);}}if(m.Set.Menu){[].concat(m.Set.Menu).forEach(function(M){t._attachHandler.call(h,M.action,function(o){var p;if(o.oSource===t._map()){p=o.getParameters();if(jQuery.sap.startsWith(p.Action.object,this._map().getId())){p.Action.object=p.Action.object.substr(this._map().getId().length+1)}if(p.id&&p.hasOwnProperty("id")){delete p.id;}}else{p=o.getParameters().data;if(jQuery.sap.startsWith(p.Action.object,this._map().getId())){p.Action.object=p.Action.object.substr(this._map().getId().length+1)}p.Action.instance=p.Action.object+'.'+o.oSource.getKey();}if((p.Data)&&(p.Data.Merge)&&(p.Data.Merge.N)){[].concat(p.Data.Merge.N).forEach(function(n){if(n.name&&jQuery.sap.startsWith(n.name,this._map().getId())){n.name=n.name.substr(this._map().getId().length+1)}},this);var i=p.Data.Merge.N.map(function(n){return n.E;}).reduce(function(a,b){return a.concat(b);}).map(function(e){return e.K;});if(jQuery.isEmptyObject(this._idKeyMap)){this.idKeyMapGenerator();}if(i.some(function(u){return!this._idKeyMap.hasOwnProperty(u);},this)){this.idKeyMapGenerator();}var j=function(e){e.K=this._idKeyMap[e.K];};[].concat(p.Data.Merge.N).map(function(n){return n.E;}).reduce(function(a,b){return a.concat(b);}).forEach(j,this);}this.fireSubmit({data:JSON.stringify(p)});},t);});}}g["Automation"]=d;g["Menus"]=m;var L={};L["SAPVB"]=g;this._map().load(L);return this;};A.prototype._processClusters=function(a){this._clusterVOs.clear();if(a.Set){var m=this._map();m.destroyClusters();[].concat(a.Set.Cluster).forEach(function(i){var b=null;switch(i.type){case"distance":b=new sap.ui.vbm.ClusterDistance(i.id);if(i.distance){b.setDistance(parseFloat(i.distance));}break;case"grid":b=new sap.ui.vbm.ClusterGrid(i.id);if(i.limit){b.setLimit(parseInt(i.limit,10));}if(i.limitOnSum){b.setLimitTotal(parseInt(i.limitOnSum,10));}if(i.order){b.setOrderIndex(parseInt(i.order,10));}if(i.areabordersize){b.setCellSpacing(-parseInt(i.areabordersize,10));}if(i.distanceX&&i.distanceY){b.setGridSize(i.distanceX+";"+i.distanceY);}if(i.offsetX&&i.offsetY){b.setOffset(i.offsetX+";"+i.offsetY);}break;case"tree":b=new sap.ui.vbm.ClusterTree(i.id,{});break;default:c.debug("sap.ui.vbm.Adapter: unsupported clustering type \""+i.type+"\"");break;}if(b){if(i.rule){b.setRule(i.rule);}b.setTextSettings({textcolor:i.textcolor,textfont:i.textfont,textfontsize:i.textfontsize,textoffset:i.textoffset,textoffsetY:i.textoffsetY});b.setVizTemplate(new sap.ui.vbm.Cluster());m.addCluster(b);}this._clusterVOs.set(i.VO,b);},this);}return this;};A.prototype._processDetailWindows=function(o){var g=this._map();var t=this;if(o.SAPVB.Windows.Set.name){var b=function(p,n){return function(d){return d[p]===n;};};var w=[].concat(o.SAPVB.Windows.Set).map(function(a){var m=g.getModel().getData();var W=a;for(var s in a.Window){if(a.Window.hasOwnProperty(s)){if(jQuery.sap.endsWith(s,".bind")){if(jQuery.sap.startsWith(s,"pos")){var p=a.Window[s].split(".");if(p[0]in m){var i=sap.ui.vbm.findIndexInArray(m[p[0]],b("Key",p[1]));if(i!==-1){var d=m[p[0]][i];if(p[2]in d){delete W.Window[s];W.Window[s.split(".")[0]]=d[p[2]];}}}}}}}return W;},this);o.SAPVB.Windows.Set=w;if(o.SAPVB.Scenes&&o.SAPVB.Scenes.Set&&o.SAPVB.Scenes.Set.name&&o.SAPVB.Scenes.Set.Scene&&o.SAPVB.Scenes.Set.Scene.VO){var V=[].concat(o.SAPVB.Scenes.Set.Scene.VO).map(function(v){var d=v;var e=function(d,h,p){return function(s){if(s.name&&s.type){var D=s[s.type];if(D.name===s.name){var a=sap.ui.vbm.findInArray([].concat(this._dataTypes),b("name",D.name));var i=sap.ui.vbm.findInArray([].concat(sap.ui.vbm.findInArray([].concat(a.N),b("name",p[2])).A),b("name",p[4])).alias;var j=[].concat(D.E)[p[1]];var S=[].concat(sap.ui.vbm.findInArray([].concat(j.N),b("name",p[2])).E)[p[3]];d[h.split(".")[0]]=S[i];delete d[h];}}};};for(var h in v){if(v.hasOwnProperty(h)){if(jQuery.sap.endsWith(h,".bind")){var p=v[h].split(".");if(o.SAPVB.Data&&o.SAPVB.Data.Set){[].concat(o.SAPVB.Data.Set).forEach(e(d,h,p),this);}}}}if(o.SAPVB.Actions&&o.SAPVB.Actions.Set){[].concat(o.SAPVB.Actions.Set).filter(function(a){return a.Action.refVO===d.id;}).forEach(function(a){t._attachHandler.call(g,a.Action.name,t._handler,t);});}return d;},this);o.SAPVB.Scenes.Set.Scene.VO=V;}g.load(o);}return this;};A.prototype._handler=function(d,g){if(d.oSource instanceof sap.ui.vbm.ClusterBase){var k=d.getParameters().instance.getKey();var s=d.getParameters().event;var h=this._map().mVBIContext.GetMainScene();if(k&&s&&h){var p=h.GetEventVPCoords(s);var i=h.GetPosFromVPPoint([p[0],p[1],0]);var j=this._map().getInfoForCluster(k,sap.ui.vbm.ClusterInfoType.NodeInfo);d.getParameters().data={"version":"2.0","xmlns:VB":"VB","id":d.oSource.getId(),"Action":{"id":g.id,"name":g.name,"object":g.refVO,"instance":k,"Params":{"Param":[{"name":"x","#":p[0].toString()},{"name":"y","#":p[1].toString()}]},"AddActionProperties":{"AddActionProperty":[{"name":"pos","#":i[0].toString()+";"+i[1].toString()+";0.0"},{"name":"vos","#":j.cnt}]}}};this.fireSubmit({data:JSON.stringify(d.getParameters().data)});}}else{var P=d.getParameters();var o=P.data?P.data:P;if(jQuery.sap.startsWith(o.Action.object,this._map().getId())){o.Action.object=o.Action.object.substr(this._map().getId().length+1)}if(o.Action&&o.Action.object){if(o.Action.object==="Route"){o.Action.object="Link";}var m=sap.ui.vbm.findInArray(this._actions,function(g){return o.Action.object===g.refVO&&o.Action.name.toLowerCase()===g.refEvent.toLowerCase();});if(m){o.Action.id=m.id;o.Action.name=m.name;if(o.Action.instance){o.Action.instance=o.Action.object+"."+P.instance.getKey();}var q=[];if(o.Action.Params){o.Action.Params.Param.forEach(function(a){if(a.name==="strSource"){q.push(a);}});if(q.length){if(jQuery.isEmptyObject(this._idKeyMap)){this.idKeyMapGenerator();}else if(q.some(function(a){return!this._idKeyMap.hasOwnProperty(a["#"].split(".")[1]);},this)){this.idKeyMapGenerator();}q.forEach(function(a){var b=a["#"].split(".");a["#"]=b[0]+"."+this._idKeyMap[b[1]];},this);}}if((o.Data)&&(o.Data.Merge)&&(o.Data.Merge.N)){[].concat(o.Data.Merge.N).forEach(function(n){if(n.name&&jQuery.sap.startsWith(n.name,this._map().getId())){n.name=n.name.substr(this._map().getId().length+1)}},this);var r=o.Data.Merge.N.map(function(n){return n.E;}).reduce(function(a,b){return a.concat(b);}).map(function(e){return e.K;});if(jQuery.isEmptyObject(this._idKeyMap)){this.idKeyMapGenerator();}if(r.some(function(u){return!this._idKeyMap.hasOwnProperty(u);},this)){this.idKeyMapGenerator();}var t=function(e){e.K=this._idKeyMap[e.K];};[].concat(o.Data.Merge.N).map(function(n){return n.E;}).reduce(function(a,b){return a.concat(b);}).forEach(t,this);}[].concat(m.AddActionProperty||[]).forEach(function(a){var b=o.Action.AddActionProperties.AddActionProperty||[];var e=sap.ui.vbm.findInArray([].concat(b),function(n){return n.name===a.name;});if(!e){switch(a.name){case"zoom":b.push({"name":a.name,"#":this._map().getZoomlevel()});break;case"centerpoint":b.push({"name":a.name,"#":this._map().getCenterPosition()});break;case"pitch":b.push({"name":a.name,"#":"0.0"});break;case"yaw":b.push({"name":a.name,"#":"0.0"});break;default:break;}}},this);this.fireSubmit({data:JSON.stringify(o)});}}}this.timeout=undefined;};A.prototype._clickHandler=function(e,a){if(this.timeout){clearTimeout(this.timeout);if(!a){e.getParameters().data.Action.name="doubleclick";}this._handler(e,a);}else{var b=a?sap.ui.vbm.findInArray(this._actions,function(d){return d.refVO===a.refVO&&d.refEvent==="Click";}):undefined;this.oEvent=jQuery.extend(true,{},e);this.timeout=setTimeout(this._handler.bind(this,this.oEvent,b),500);}};return A;});
