/*
 * ! SAP UI development toolkit for HTML5 (SAPUI5) (c) Copyright 2009-2012 SAP AG. All rights reserved
 */
sap.ui.define(['./VBI','./library'],function(V,l){"use strict";
/**
	 * Constructor for a new GeoMap.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 * @class Map control with the option to position multiple visual objects on top of a map. The GeoMap control shows an image based map loaded from
	 *        one or more configurable external providers. Per default a map from <a href="http://www.mapquest.com">MapQuest</a> is used. Other map
	 *        providers can be configured via property <i>mapConfiguration</i>. Multiple maps can be mashed up into one map layer stack. If multiple
	 *        map layer stacks are provided via configuration it is possible to switch between them during runtime. The control supports the display
	 *        of copyright information for the visible maps.<br>
	 *        On top of the map the GeoMap control provides a navigation control, a scale, and a legend. Each of them can be switched off separately.<br>
	 *        It is possible to set the initial position and zoom for the map display. Further the control allows to restrict the potentially visible
	 *        map area and zoom range.<br>
	 *        Different visual objects can be placed on the map. Visual objects are grouped in VO aggregations and an arbitrary number of VO
	 *        aggregations can be assigned to the <i>vos</i> aggregation.<br>
	 *        The second aggregation <i>featureCollections</i> allows the use of GeoJSON as source for visual objects.
	 * @extends sap.ui.vbm.VBI
	 * @constructor
	 * @public
	 * @alias sap.ui.vbm.GeoMap
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
var G=V.extend("sap.ui.vbm.GeoMap",{metadata:{library:"sap.ui.vbm",properties:{mapConfiguration:{type:"object",group:"Misc",defaultValue:null},legendVisible:{type:"boolean",group:"Appearance",defaultValue:true},scaleVisible:{type:"boolean",group:"Appearance",defaultValue:true},navcontrolVisible:{type:"boolean",group:"Appearance",defaultValue:true},initialPosition:{type:"string",group:"Behavior",defaultValue:"0;0;0"},initialZoom:{type:"string",group:"Behavior",defaultValue:"2"},centerPosition:{type:"string",group:"Behavior",defaultValue:"0;0"},zoomlevel:{type:"int",group:"Behavior",defaultValue:2},refMapLayerStack:{type:"string",group:"Appearance",defaultValue:"Default"},visualFrame:{type:"object",group:"Behavior",defaultValue:null},clustering:{type:"object",group:"Behavior",defaultValue:null},disableZoom:{type:"boolean",group:"Behavior",defaultValue:false},disablePan:{type:"boolean",group:"Behavior",defaultValue:false},enableAnimation:{type:"boolean",group:"Behavior",defaultValue:false},ariaLabel:{type:"string",group:"Misc"}},defaultAggregation:"vos",aggregations:{vos:{type:"sap.ui.vbm.VoAbstract",multiple:true,singularName:"vo"},geoJsonLayers:{type:"sap.ui.vbm.GeoJsonLayer",multiple:true,singularName:"geoJsonLayer"},featureCollections:{type:"sap.ui.vbm.FeatureCollection",multiple:true,singularName:"featureCollection"},resources:{type:"sap.ui.vbm.Resource",multiple:true,singularName:"resource"},legend:{type:"sap.ui.vbm.Legend",multiple:false},clusters:{type:"sap.ui.vbm.ClusterBase",multiple:true,singularName:"cluster"}},events:{click:{parameters:{pos:{type:"string"}}},contextMenu:{parameters:{clientX:{type:"int"},clientY:{type:"int"},pos:{type:"string"}}},drop:{parameters:{pos:{type:"string"}}},select:{},zoomChanged:{parameters:{centerPoint:{type:"string"},viewportBB:{type:"object"},zoomLevel:{type:"int"}}},centerChanged:{parameters:{centerPoint:{type:"string"},viewportBB:{type:"object"},zoomLevel:{type:"int"}}},keyDown:{parameters:{key:{type:"string"},code:{type:"int"},shift:{type:"boolean"},ctrl:{type:"boolean"},alt:{type:"boolean"},meta:{type:"boolean"}}},keyPress:{parameters:{key:{type:"string"},code:{type:"int"},shift:{type:"boolean"},ctrl:{type:"boolean"},alt:{type:"boolean"},meta:{type:"boolean"}}},keyUp:{parameters:{key:{type:"string"},code:{type:"int"},shift:{type:"boolean"},ctrl:{type:"boolean"},alt:{type:"boolean"},meta:{type:"boolean"}}}}}});G.bEncodedSpotImagesAvailable=false;G.bEncodeSpotImageData=null;G.oBaseApp={SAPVB:{version:"2.0",MapProviders:{Set:{MapProvider:{name:"404",type:"",description:"",tileX:"256",tileY:"256",maxLOD:"19",copyright:"Map Provider is not configured, please read this {LINK|SCN Article} to configure your own Map Provider.",copyrightLink:"//scn.sap.com/docs/DOC-74221",copyrightImage:"",Source:[{id:"s1",url:"data:image/png;base64,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"}]}}},MapLayerStacks:{Set:{MapLayerStack:{name:"Default",MapLayer:{name:"layer1",refMapProvider:"404",opacity:"1.0",colBkgnd:"rgb(255,255,255)"}}}}}};G.prototype.exit=function(){V.prototype.exit.apply(this,arguments);this.detachSubmit(this.onGeoMapSubmit,this);this.detachContainerCreated(this.onGeoMapContainerCreated,this);this.detachContainerDestroyed(this.onGeoMapContainerDestroyed,this);this.detachCloseWindow(this.onGeoMapWindowClosed,this);};function d(){this.m_bActionsDirty=true;this.m_bSceneDirty=true;this.invalidate(this);}G.prototype.attachEvent=function(){V.prototype.attachEvent.apply(this,arguments);d.apply(this);};G.prototype.detachEvent=function(){V.prototype.detachEvent.apply(this,arguments);d.apply(this);};G.prototype.destroyResources=function(){this.m_bResourcesDirty=true;return this.destroyAggregation("resources");};G.prototype.addResource=function(o){this.m_bResourcesDirty=true;return this.addAggregation("resources",o);};G.prototype.insertResource=function(o,i){this.m_bResourcesDirty=true;return this.insertAggregation("resources",o,i);};G.prototype.removeResource=function(o){this.m_bResourcesDirty=true;return this.removeAggregation("resources",o);};G.prototype.removeAllResources=function(o){this.m_bResourcesDirty=true;return this.removeAllAggregation("resources");};G.prototype.destroyVos=function(){this.m_bVosDirty=true;return this.destroyAggregation("vos");};G.prototype.addVo=function(o){if(this.indexOfVo(o)<0){this.m_bVosDirty=true;this.addAggregation("vos",o);o.m_bAggRenew=true;}return this;};G.prototype.insertVo=function(o,i){this.m_bVosDirty=true;this.insertAggregation("vos",o,i);o.m_bAggRenew=true;return this;};G.prototype.removeVo=function(o){this.m_bVosDirty=true;return this.removeAggregation("vos",o);};G.prototype.removeAllVos=function(o){this.m_bVosDirty=true;return this.removeAllAggregation("vos");};G.prototype.destroyGeoJsonLayers=function(){this.m_bGJLsDirty=true;return this.destroyAggregation("geoJsonLayers");};G.prototype.addGeoJsonLayer=function(o){this.m_bGJLsDirty=true;return this.addAggregation("geoJsonLayers",o);};G.prototype.insertGeoJsonLayer=function(o,i){this.m_bGJLsDirty=true;return this.insertAggregation("geoJsonLayers",o,i);};G.prototype.removeGeoJsonLayer=function(o){this.m_bGJLsDirty=true;return this.removeAggregation("geoJsonLayers",o);};G.prototype.removeAllGeoJsonLayers=function(o){this.m_bGJLsDirty=true;return this.removeAllAggregation("geoJsonLayers");};G.prototype.destroyFeatureCollections=function(){this.m_bFCsDirty=true;return this.destroyAggregation("featureCollections");};G.prototype.addFeatureCollection=function(o){this.m_bFCsDirty=true;return this.addAggregation("featureCollections",o);};G.prototype.insertFeatureCollection=function(o,i){this.m_bFCsDirty=true;return this.insertAggregation("featureCollections",o,i);};G.prototype.removeFeatureCollection=function(o){this.m_bFCsDirty=true;return this.removeAggregation("featureCollections",o);};G.prototype.removeAllFeatureCollections=function(o){this.m_bFCsDirty=true;return this.removeAllAggregation("featureCollections");};G.prototype.destroyClusters=function(){this.m_bClustersDirty=true;return this.destroyAggregation("clusters");};G.prototype.addCluster=function(o){this.m_bClustersDirty=true;return this.addAggregation("clusters",o);};G.prototype.insertCluster=function(o,i){this.m_bClustersDirty=true;return this.insertAggregation("clusters",o,i);};G.prototype.removeCluster=function(o){this.m_bClustersDirty=true;return this.removeAggregation("clusters",o);};G.prototype.removeAllClusters=function(o){this.m_bClustersDirty=true;return this.removeAllAggregation("clusters");};
/**
	 * Set Map configuration data. Map Configurations contain a set of Map Providers and Map Layer Stacks refering to those providers. The GeoMap
	 * property refMapLayerStack defines, which Map Layer Stack becomes visible.
	 *
	 * @param {object} oMapConfiguration Map Configuration object
	 * @param {array} oMapConfiguration.MapProvider Array of Map Provider definitions.
	 * @param {string} oMapConfiguration.MapProvider.name Name for the provider. Needed in Map Layer Stack as reference.
	 * @param {string} oMapConfiguration.MapProvider.tileX X-pixel dimension of map tile. Typical 256.
	 * @param {string} oMapConfiguration.MapProvider.tileY Y-pixel dimension of map tile. Typical 256.
	 * @param {string} oMapConfiguration.MapProvider.minLOD Minimal supported Level Of Detail.
	 * @param {string} oMapConfiguration.MapProvider.maxLOD Maximal supported Level Of Detail.
	 * @param {string} oMapConfiguration.MapProvider.copyright Copyright Information to be shown with the map.
	 * @param {array} oMapConfiguration.MapProvider.Source Array of source definitions. At least on Source has to be given. Multiple sources can be
	 *        used for load distribution.
	 * @param {string} oMapConfiguration.MapProvider.Source.id Source id.
	 * @param {string} oMapConfiguration.MapProvider.Source.url Source URL for map tile service. URL includes place holders for variable informations
	 *        set at runtime, e.g. {LOD}.
	 * @param {array} oMapConfiguration.MapLayerStacks Array of Map Layer Stacks
	 * @param {string} oMapConfiguration.MapLayerStacks.name Name of Map Layer Stack. Use with the GeoMap refMapLayerStack property.
	 * @param {string} oMapConfiguration.MapLayerStacks.previewPosition.latitude Latitude position to use when creating image tile
	 * @param {string} oMapConfiguration.MapLayerStacks.previewPosition.longitude Longitude position to use when creating image tile
	 * @param {string} oMapConfiguration.MapLayerStacks.previewPosition.lod Lod position to use when creating image tile
	 * @param {array} oMapConfiguration.MapLayerStacks.MapLayer Array of Map Layers. Each Layer refers to a Map Proveride. Map Layers get overlayed in
	 *        the given sequence.
	 * @param {string} oMapConfiguration.MapLayerStacks.MapLayer.name Name of Map Layer.
	 * @param {string} oMapConfiguration.MapLayerStacks.MapLayer.refMapProvider Name of referenced Map Provider.
	 * @param {string} oMapConfiguration.MapLayerStacks.MapLayer.opacity Opacity of Map Layer. Value range 0 to 1.
	 * @param {sap.ui.core.CSSColor} oMapConfiguration.MapLayerStacks.colBkgnd Background color for Map Layer. Only meaningful if opacity is
	 *        below 1.
	 * @returns {sap.ui.vbm.GeoMap} This allows method chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
G.prototype.setMapConfiguration=function(o){this.m_bMapConfigurationDirty=true;if(o.MapLayerStacks&&o.MapProvider){this.m_bMapLayerStacksDirty=true;this.m_bMapProvidersDirty=true;this.setProperty("mapConfiguration",o).invalidate();}return this;};G.prototype.setClustering=function(c){this.m_bClusteringDirty=true;this.setProperty("clustering",c);return this;};G.prototype.setRefMapLayerStack=function(o){if(o===this.getRefMapLayerStack()){return this;}this.m_bRefMapLayerStackDirty=this.m_bSceneDirty=true;this.setProperty("refMapLayerStack",o).invalidate();return this;};G.prototype.setVisualFrame=function(v){this.m_bVisualFrameDirty=true;this.setProperty("visualFrame",v);return this;};G.prototype.setRectangularSelection=function(s){V.prototype.setRectangularSelection.apply(this,arguments);return this;};G.prototype.setLassoSelection=function(s){V.prototype.setLassoSelection.apply(this,arguments);return this;};G.prototype.setRectZoom=function(s){V.prototype.setRectZoom.apply(this,arguments);return this;};G.prototype.getPositionInteractive=function(p,c){var i;if(!this.mIACreateCB&&c&&typeof c==="function"){this.mIACreateCB=c;var t=p?"POSARRAY":"POS";var L={"SAPVB":{"Automation":{"Call":{"handler":"OBJECTCREATIONHANDLER","name":"CreateObject","object":"MainScene","scene":"MainScene","instance":"","Param":{"name":"data","#":"{"+t+"}"}}}}};this.load(L);i=true;}else{i=false;}return i;};G.prototype.getCenterPosition=function(){var s=this.mVBIContext.GetMainScene(),c;if(s){var C=window.VBI.MathLib.RadToDeg(s.GetCenterPos());c=C[0]+";"+C[1];}else{c=this.getProperty("centerPosition");}return c;};G.prototype.isNumeric=function(n){return!isNaN(parseFloat(n))&&isFinite(n);};G.prototype.setCenterPosition=function(p){var c=p?p.split(";"):undefined;if(!c||c.length<=1||!this.isNumeric(c[0])||!this.isNumeric(c[1])){jQuery.sap.log.error(sap.ui.vbm.getResourceBundle().getText("GEOMAP_INVALID_CENTER_POSITION")+":'"+p+"'","setCenterPosition","sap.ui.vbm.GeoMap");}else{var P=c[0]+";"+c[1]+";0";this.setProperty("centerPosition",P);if(this.isRendered()){c=P.split(";");this.zoomToGeoPosition(c[0],c[1],this.getZoomlevel());}}return this;};G.prototype.setInitialPosition=function(p){this.setCenterPosition(p);};G.prototype.getZoomlevel=function(){var s=this.mVBIContext.GetMainScene();if(s){return parseInt(s.GetCurrentZoomlevel(),10);}return this.getProperty("zoomlevel");};G.prototype.setZoomlevel=function(z){if(!this.getDisableZoom()){if(z>=0){if(this.isRendered()){var c=this.getCenterPosition().split(";");if(this.getEnableAnimation()){var s=this.mVBIContext.GetMainScene();s.AnimateZoomToGeo(s.GetCenterPos(),z,5);}else{this.zoomToGeoPosition(c[0],c[1],z);}}this.setProperty("zoomlevel",z);}else{jQuery.sap.log.error(sap.ui.vbm.getResourceBundle().getText("GEOMAP_INVALID_ZOOM_LEVEL")+": "+z.toString(),"setZoomlevel","sap.ui.vbm.GeoMap");}}};G.prototype.setInitialZoom=function(z){this.setZoomlevel(parseInt(z,10));};G.prototype.openDetailWindow=function(p,P){this.mDTWindowCxt.key="";this.mDTWindowCxt.open=true;this.mDTWindowCxt.bUseClickPos=true;this.mDTWindowCxt.params=P?P:null;this.mDTWindowCxt.src={mClickGeoPos:p};this.invalidate(this);this.m_bWindowsDirty=true;};G.prototype.goToStartPosition=function(){if(this.isRendered()){this.mVBIContext.GetMainScene().GoToInitialStart();}};G.prototype.closeAnyDetailWindow=function(){this.mDTWindowCxt.open=false;this.invalidate(this);this.m_bWindowsDirty=true;};G.prototype.getVoByInternalId=function(v){var a=null;var s=v.split(/\./);var A=this.getAggregatorContainer(s[0]);if(A&&A.findInstance){a=A.findInstance(s[1]);}return a;};G.prototype.getClusteredSpots=function(c){var s=this.getInfoForCluster(c.getKey(),sap.ui.vbm.ClusterInfoType.ContainedVOs),a=s.map(function(b){return this.getVoByInternalId(b);}.bind(this));return a;};G.prototype.setSelectionPropFireSelect=function(a){var n=a.N;for(var b=0;b<n.length;++b){var A=n[b];var e=A.E;var c;if((c=this.getAggregatorContainer(A.name))&&c.handleSelectEvent){c.handleSelectEvent(e);}}};G.prototype.onGeoMapSubmit=function(e){var a=JSON.parse(e.mParameters.data);if(a.Data&&a.Data.Merge){this.handleChangedData(a.Data.Merge.N);}var c;if((c=this.getAggregatorContainer(a.Action.object))){c.handleEvent(a);if(a.Action.name=="click"&&a.Data&&a.Data.Merge){this.setSelectionPropFireSelect(a.Data.Merge);}}else{switch(a.Action.name){case"click":this.fireClick({pos:a.Action.AddActionProperties.AddActionProperty[0]['#']});break;case"contextMenu":this.fireContextMenu({clientX:a.Action.Params.Param[0]['#'],clientY:a.Action.Params.Param[1]['#'],pos:a.Action.AddActionProperties.AddActionProperty[0]['#'],data:a});break;case"drop":this.fireDrop({pos:a.Action.AddActionProperties.AddActionProperty[0]['#']});break;case"zoomChanged":this.fireZoomChanged({zoomLevel:a.Action.AddActionProperties.AddActionProperty[0]['#'],centerPoint:a.Action.AddActionProperties.AddActionProperty[1]['#'],viewportBB:{upperLeft:a.Action.Params.Param[3]['#'],lowerRight:a.Action.Params.Param[4]['#']}});break;case"centerChanged":this.fireCenterChanged({zoomLevel:a.Action.AddActionProperties.AddActionProperty[0]['#'],centerPoint:a.Action.AddActionProperties.AddActionProperty[1]['#'],viewportBB:{upperLeft:a.Action.Params.Param[3]['#'],lowerRight:a.Action.Params.Param[4]['#']}});break;case"select":if(a.Data&&a.Data.Merge.N){var s=this.getSelectedItems(a.Data.Merge.N);this.fireSelect({selected:s,data:a});this.setSelectionPropFireSelect(a.Data.Merge);}break;case"GetPosComplete":if(this.mIACreateCB){try{this.mIACreateCB(a.Action.Params.Param[0]['#']);this.mIACreateCB=null;}catch(b){this.mIACreateCB=null;throw b;}}break;case"keydown":if(!this.fireEvent("keyDown",{key:a.Action.Params.Param[0]['#'],code:a.Action.Params.Param[1]['#'],shift:a.Action.Params.Param[2]['#'],ctrl:a.Action.Params.Param[3]['#'],alt:a.Action.Params.Param[4]['#'],meta:a.Action.Params.Param[5]['#']},true)){e.preventDefault();}break;case"keypress":if(!this.fireEvent("keyPress",{key:a.Action.Params.Param[0]['#'],code:a.Action.Params.Param[1]['#'],shift:a.Action.Params.Param[2]['#'],ctrl:a.Action.Params.Param[3]['#'],alt:a.Action.Params.Param[4]['#'],meta:a.Action.Params.Param[5]['#']},true)){e.preventDefault();}break;case"keyup":if(!this.fireEvent("keyUp",{key:a.Action.Params.Param[0]['#'],code:a.Action.Params.Param[1]['#'],shift:a.Action.Params.Param[2]['#'],ctrl:a.Action.Params.Param[3]['#'],alt:a.Action.Params.Param[4]['#'],meta:a.Action.Params.Param[5]['#']},true)){e.preventDefault();}break;default:this.fireEvent(a.Action.name,a);break;}}};G.prototype.onGeoMapContainerCreated=function(e){var a=e.getParameter("contentarea");if(a.m_ID){var c;if((c=this.getAggregatorContainer(a.m_ID))&&c.handleContainerCreated){c.handleContainerCreated(e);}}};G.prototype.onGeoMapContainerDestroyed=function(e){var a=e.getParameter("contentarea");if(a.m_ID){var c;if((c=this.getAggregatorContainer(a.m_ID))&&c.handleContainerDestroyed){c.handleContainerDestroyed(e);}}if(this.mDTWindowCxt.open&&e.getParameter("id")==="Detail"){this.mDTWindowCxt.open=false;this.mDTWindowCxt.src=null;this.m_bWindowsDirty=true;}};G.prototype.onGeoMapWindowClosed=function(e){if(this.mDTWindowCxt.open&&e.getParameter("id")==="Detail"){this.mDTWindowCxt.open=false;this.mDTWindowCxt.src=null;}};G.prototype.init=function(){this.attachSubmit(this.onGeoMapSubmit,this);this.attachContainerCreated(this.onGeoMapContainerCreated,this);this.attachContainerDestroyed(this.onGeoMapContainerDestroyed,this);this.attachCloseWindow(this.onGeoMapWindowClosed,this);this.m_bVosDirty=true;this.m_bFCsDirty=true;this.m_bGJLsDirty=true;this.m_bClustersDirty=true;this.m_bMapConfigurationDirty=true;this.m_bClusteringDirty=true;this.m_bVisualFrameDirty=true;this.m_bRefMapLayerStackDirty=true;this.m_bResourcesDirty=true;this.m_bMapProvidersDirty=true;this.m_bMapLayerStacksDirty=true;this.m_bWindowsDirty=true;this.m_bMapconfigDirty=true;this.m_bLegendDirty=true;this.m_bSceneDirty=true;this.m_bActionsDirty=true;this.mbForceDataUpdate=false;this.bDataDeltaUpdate=false;this.bHandleChangedDataActive=false;this.mDTWindowCxt={open:false,src:null,key:"",params:null};V.prototype.init.apply(this,arguments);};G.prototype.getSelectedItems=function(a){var c,C,s=[];if(!a){return null;}if(jQuery.type(a)==="object"){c=this.getAggregatorContainer(a.name);C=c.findSelected(true,a.E);s=s.concat(C);}else if(jQuery.type(a)==="array"){for(var n=0;n<a.length;++n){c=this.getAggregatorContainer(a[n].name);C=c.findSelected(true,a[n].E);if(C&&C.length){s=s.concat(C);}}}return s;};G.prototype.getWindowsObject=function(){var w={"Set":[{"name":"Main","Window":{"id":"Main","caption":"MainWindow","type":"geo","refParent":"","refScene":"MainScene","modal":"true"}}],"Remove":[]};var L=this.getLegend();if(L){var a;if((a=this.getDomRef(L.getId()))){this.m_curLegendPos={right:parseInt(a.style.right,10),top:parseInt(a.style.top,10)};}var o=L.getTemplateObject();if(o.Set){w.Set=w.Set.concat(o.Set);}if(o.Remove){w.Remove=w.Remove.concat(o.Remove);}}if(this.mDTWindowCxt.src){var r,D;r=[{"name":"Detail"}];if(this.mDTWindowCxt.key){var c=this.getChildByKey(this.mDTWindowCxt.src,this.mDTWindowCxt.key);if(!c){this.mDTWindowCxt.open=false;this.mDTWindowCxt.src=null;this.mDTWindowCxt.key="";this.mDTWindowCxt.params=null;}else{this.mDTWindowCxt.src=c;}}if(this.mDTWindowCxt.open){D={"Set":[{"name":"Detail","Window":{"id":"Detail","type":"callout","refParent":"Main","refScene":"","modal":"true","caption":this.mDTWindowCxt.params.caption?this.mDTWindowCxt.params.caption:"","offsetX":this.mDTWindowCxt.params.offsetX?this.mDTWindowCxt.params.offsetX:"0","offsetY":this.mDTWindowCxt.params.offsetY?this.mDTWindowCxt.params.offsetY:"0"}}]};if(this.mDTWindowCxt.bUseClickPos==true&&this.mDTWindowCxt.src.mClickGeoPos){D.Set[0].Window.pos=this.mDTWindowCxt.src.mClickGeoPos;}else{D.Set[0].Window['pos.bind']=this.mDTWindowCxt.src.getParent().sId+"."+this.mDTWindowCxt.src.UniqueId+".P";}w.Set=w.Set.concat(D.Set);}w.Remove=w.Remove.concat(r);}return w;};G.prototype.getActionArray=function(){var a=[];if(this.mEventRegistry["click"]){a.push({"id":"GMap1","name":"click","refScene":"MainScene","refVO":"Map","refEvent":"Click","AddActionProperty":[{"name":"pos"}]});}if(this.mEventRegistry["contextMenu"]){a.push({"id":"GMap2","name":"contextMenu","refScene":"MainScene","refVO":"Map","refEvent":"ContextMenu","AddActionProperty":[{"name":"pos"}]});}if(this.mEventRegistry["drop"]){a.push({"id":"GMap3","name":"drop","refScene":"MainScene","refVO":"Map","refEvent":"Drop","AddActionProperty":[{"name":"pos"}]});}if(this.mEventRegistry["zoomChanged"]){a.push({"id":"GMap4","name":"zoomChanged","refScene":"MainScene","refVO":"Map","refEvent":"ZoomChanged","AddActionProperty":[{"name":"zoom"},{"name":"centerpoint"},{"name":"pos"}]});}if(this.mEventRegistry["centerChanged"]){a.push({"id":"GMap5","name":"centerChanged","refScene":"MainScene","refVO":"Map","refEvent":"CenterChanged","AddActionProperty":[{"name":"zoom"},{"name":"centerpoint"},{"name":"pos"}]});}if(this.mEventRegistry["select"]){a.push({"id":"GMap6","name":"select","refScene":"MainScene","refVO":"General","refEvent":"Select"});}a.push({"id":"GMap7","name":"GetPosComplete","refScene":"MainScene","refVO":"General","refEvent":"CreateComplete"});if(this.mEventRegistry["keyDown"]){a.push({"id":"GMap8","name":"keydown","refScene":"MainScene","refVO":"","refEvent":"KeyDown"});}if(this.mEventRegistry["keyPress"]){a.push({"id":"GMap9","name":"keypress","refScene":"MainScene","refVO":"","refEvent":"KeyPress"});}if(this.mEventRegistry["keyUp"]){a.push({"id":"GMap10","name":"keyup","refScene":"MainScene","refVO":"","refEvent":"KeyUp"});}return a;};G.prototype.getSceneVOdelta=function(c,n){var v=[];var r=[];var o={};for(var a=0,b=c.length;a<b;++a){o[c[a].id]=c[a];}for(var e=0;e<n.length;++e){if(o[n[e].id]){if(JSON.stringify(n[e])!=JSON.stringify(o[n[e].id])){r.push({"id":n[e].id,"type":"VO"});v.push(n[e]);}}else{v.push(n[e]);}delete o[n[e].id];}for(var i in o){r.push({"id":i,"type":"VO"});}var f={"Merge":{"name":"MainScene","type":"SceneGeo","SceneGeo":{"id":"MainScene","refMapLayerStack":this.getRefMapLayerStack()}}};if(r.length){f.Merge.SceneGeo.Remove=r;}if(v.length){f.Merge.SceneGeo.VO=v;}return f;};G.prototype.minimizeApp=function(a){var t,s;s=null;if(!this.m_bWindowsDirty){(t=a)&&(t=t.SAPVB)&&(t=t.Windows)&&(s=JSON.stringify(t))&&(s==this.m_curWindows)&&(delete a.SAPVB.Windows)||(this.m_curWindows=s?s:this.m_curWindows);}else{this.m_bWindowsDirty=false;}s=null;(t=a)&&(t=t.SAPVB)&&(t=t.Scenes)&&(s=JSON.stringify(t))&&(s==this.m_curScenes)&&(delete a.SAPVB.Scenes)||(this.m_curScenes=s?s:this.m_curScenes);s=null;(t=a)&&(t=t.SAPVB)&&(t=t.Actions)&&(s=JSON.stringify(t))&&(s==this.m_curActions)&&(delete a.SAPVB.Actions)||(this.m_curActions=s?s:this.m_curActions);s=null;(t=a)&&(t=t.SAPVB)&&(t=t.DataTypes)&&(s=JSON.stringify(t))&&(s==this.m_curDataTypes)&&(delete a.SAPVB.DataTypes)||(this.m_curDataTypes=s?s:this.m_curDataTypes);if(!this.mbForceDataUpdate){s=null;(t=a)&&(t=t.SAPVB)&&(t=t.Data)&&(s=JSON.stringify(t))&&(s==this.m_curData)&&(delete a.SAPVB.Data)||(this.m_curData=s?s:this.m_curData);}else{this.mbForceDataUpdate=false;}return a;};G.prototype.getAggregatorContainer=function(i){if(i!=="MainScene"){var c=this.getClusters();for(var n=0;n<c.length;++n){if(c[n].sId===i){return c[n];}}var v=this.getVos();for(var a=0,b=v.length;a<b;++a){if(v[a].sId===i){return v[a];}}var g=this.getGeoJsonLayers();for(var e=0;e<g.length;++e){if(i.indexOf(g[e].sId)===0){return g[e];}}var f=this.getFeatureCollections();for(var h=0;h<f.length;++h){if(i.indexOf(f[h].sId)===0){return f[h];}}var j=this.getLegend();if(j&&j.sId==i){return j;}}return null;};G.prototype.update=function(){var a=jQuery.extend(true,{},G.oBaseApp);if(this.m_bResourcesDirty){this.updateResourceData(a);}var c={};if(this.m_bClusteringDirty||this.m_bClustersDirty){this.updateClustering(a,c);this.mCurClusterRefVOs=jQuery.extend(true,{},c);}else{c=jQuery.extend(true,{},this.mCurClusterRefVOs);}if(this.m_bSceneDirty){this.updateScene(a,c);}if(this.m_bResourcesDirty){this.updateResourceData(a);}if(this.m_bMapConfigurationDirty){this.updateMapConfiguration(a);}this.updateMapProviders(a);this.updateMapLayerStacks(a);this.updateWindows(a);var b;if((b=this.getLegend())){if(a.SAPVB.Actions){Array.prototype.push.apply(a.SAPVB.Actions.Set.Action,b.getActionArray());}}if(this.m_bActionsDirty&&!a.SAPVB.Actions){this.m_bActionsDirty=false;((a.SAPVB.Actions={}).Set={}).Action=[];}if(a.SAPVB.Actions){this.m_bActionsDirty=false;Array.prototype.push.apply(a.SAPVB.Actions.Set.Action,this.getActionArray());}return this.minimizeApp(a);};G.prototype.updateMapProviders=function(a){if(!this.m_bMapProvidersDirty){delete a.SAPVB.MapProviders;}this.m_bMapProvidersDirty=false;};G.prototype.updateMapLayerStacks=function(a){if(!this.m_bMapLayerStacksDirty){delete a.SAPVB.MapLayerStacks;}this.m_bMapLayerStacksDirty=false;};G.prototype.updateWindows=function(a){a.SAPVB.Windows=this.getWindowsObject();};G.prototype.updateScene=function(a,c){var s=[];var b=(c.Data)?c.Data:[];var e=[];var f=[];var g=(c.Actions)?c.Actions:[];var u=!this.m_bFCsDirty&&!this.m_bGJLsDirty&&!this.m_bVosDirty;this.updateGJLData(s,b,e,f,g,u);this.updateFCData(s,b,e,f,g,u);this.updateVOData(s,b,e,f,g,u);if(c.VO){s=s.concat(c.VO);}if(this.m_bLegendDirty){var L=this.getLegend();if(L){e.push({name:L.sId,type:"N"});b.push(L.getDataObject());f.push(L.getTypeObject());}}var _=JSON.stringify(s);var m=true;if(!this.m_saVO){((((a.SAPVB.Scenes={}).Set={}).SceneGeo={"id":"MainScene","refMapLayerStack":this.getRefMapLayerStack(),"initialZoom":this.getProperty("zoomlevel"),"initialStartPosition":this.getProperty("centerPosition"),"scaleVisible":this.getScaleVisible().toString(),"navControlVisible":this.getNavcontrolVisible().toString(),"rectSelect":this.getRectangularSelection().toString(),"lassoSelect":this.getLassoSelection().toString(),"rectZoom":this.getRectZoom().toString(),"VisualFrame":this.getVisualFrame(),"NavigationDisablement":{"zoom":this.getDisableZoom().toString(),"move":this.getDisablePan().toString()},"ariaLabel":this.getAriaLabel()}).VO=s);}else if(this.m_bRefMapLayerStackDirty||!(this.m_saVO===_)){(a.SAPVB.Scenes=this.getSceneVOdelta(JSON.parse(this.m_saVO),s));}else{m=false;}this.m_saVO=_;if(!this.isRendered()&&a.SAPVB.Scenes&&a.SAPVB.Scenes.Merge){if(a.SAPVB.Scenes.Merge.SceneGeo.initialStartPosition!==this.getProperty("centerPosition")){a.SAPVB.Scenes.Merge.SceneGeo.initialStartPosition=this.getProperty("centerPosition");}if(a.SAPVB.Scenes.Merge.SceneGeo.initialZoom!==this.getProperty("zoomlevel")){a.SAPVB.Scenes.Merge.SceneGeo.initialZoom=this.getProperty("zoomlevel");}}var n;if(this.bDataDeltaUpdate){a.SAPVB.Data={};a.SAPVB.Data.Set=[];for(n=0;n<b.length;++n){a.SAPVB.Data.Set.push({name:b[n].name,type:"N",N:b[n]});}}else{a.SAPVB.Data={};if(e.length){a.SAPVB.Data.Remove=[];for(n=0;n<e.length;++n){a.SAPVB.Data.Remove.push(e[n]);}}a.SAPVB.Data.Set=[];for(n=0;n<b.length;++n){a.SAPVB.Data.Set.push({name:b[n].name,type:"N",N:b[n]});}}if(m){(((a.SAPVB.DataTypes={}).Set={}).N=f);}(((a.SAPVB.Actions={}).Set={}).Action=g);this.resetDirtyStates();};G.prototype.resetDirtyStates=function(){this.m_bRefMapLayerStackDirty=this.m_bSceneDirty=this.m_bFCsDirty=this.m_bGJLsDirty=this.m_bVosDirty=false;};G.prototype.updateMapConfiguration=function(a){if(!this.m_bMapConfigurationDirty){return;}this.m_bMapConfigurationDirty=false;var c=this.getMapConfiguration();if(c){a.SAPVB.MapProviders={Set:{MapProvider:c.MapProvider}};a.SAPVB.MapLayerStacks={Set:{MapLayerStack:c.MapLayerStacks}};}return;};G.prototype.updateClustering=function(a,c){var C=this.getClusters();var o=null;if(C.length){o={Cluster:[]};c.VO=[];c.Actions=[];c.Data=[];for(var n=0,b;n<C.length;++n){b=C[n];c.VO.push(b.getTemplateObject());c.Actions=c.Actions.concat(b.getActionArray());o.Cluster.push(b.getClusterDefinition());}}else if(this.m_bClusteringDirty){o=this.getClustering();}if(o){a.SAPVB.Clustering={Set:o};}else if(this.mCurClusterRefVOs&&this.mCurClusterRefVOs.VO&&this.mCurClusterRefVOs.VO.length>0){a.SAPVB.Clustering={Set:[]};}this.m_bClusteringDirty=this.m_bClustersDirty=false;};G.prototype.updateResourceData=function(a){if(!this.m_bResourcesDirty){return;}this.m_bResourcesDirty=false;var r=this.getResources();((a.SAPVB.Resources={}).Set={}).Resource=[];function R(){var a=this.update();this.load(a);}var f=function(c){if(!c.m_Img){return;}if(!c.m_Img.complete){return;}var e=document.createElement('canvas');e.width=c.m_Img.width;e.height=c.m_Img.height;var g=e.getContext('2d');g.drawImage(c.m_Img,0,0);c.mProperties.value=e.toDataURL();delete c.m_Img;this.m_bResourcesDirty=true;window.setTimeout(R.bind(this),10);};for(var n=0,b=r.length;n<b;++n){var c=r[n];if(!c.mProperties.value&&c.mProperties.src){var i=document.createElement('img');i.crossOrigin='anonymous';c.m_Img=i;i.onload=f.bind(this,c);i.src=c.mProperties.src;}else{a.SAPVB.Resources.Set.Resource.push({"name":(c.mProperties.name?c.mProperties.name:c.sId),"value":c.mProperties.value});}}return;};G.prototype.updateVOData=function(s,a,b,c,e,u){var v=this.getVos();for(var n=0,f=v.length;n<f;++n){var o=v[n];var D=o.aDiff;s.push(o.getTemplateObject());c.push(o.getTypeObject());Array.prototype.push.apply(e,o.getActionArray());if(D&&D.length&&o.m_bAggChange&&u){var g=o.getDataDeltaObject(D);if(g.oData&&g.oData.E&&g.oData.E.length){a.push(g.oData);}if(g.aRemoveData){for(var h=0;h<g.aRemoveData.length;++h){b.push(g.aRemoveData[h]);}}}else if(!u||o.m_bAggRenew){b.push(o.getDataRemoveObject());if(o instanceof sap.ui.vbm.VoAggregation){o.resetIndices();}a.push(o.getDataObject());}if(o instanceof sap.ui.vbm.VoAggregation){o.aDiff=[];o.updateIdxArray();o.m_bAggRenew=o.m_bAggChange=false;}}};G.prototype.updateGJLData=function(s,a,b,c,e,u){var L=this.getGeoJsonLayers();for(var n=0,f=L.length;n<f;++n){var o=L[n];Array.prototype.push.apply(s,o.getTemplateObjects());Array.prototype.push.apply(c,o.getTypeObjects());Array.prototype.push.apply(e,o.getActionArray());Array.prototype.push.apply(b,o.getDataRemoveObjects());Array.prototype.push.apply(a,o.getDataObjects());}};G.prototype.updateFCData=function(s,a,b,c,e,u){var f=this.getFeatureCollections();for(var n=0,g=f.length;n<g;++n){var F=f[n];Array.prototype.push.apply(s,F.getTemplateObjects());Array.prototype.push.apply(c,F.getTypeObjects());Array.prototype.push.apply(e,F.getActionArray());Array.prototype.push.apply(b,F.getDataRemoveObjects());Array.prototype.push.apply(a,F.getDataObjects());}};G.prototype.invalidate=function(s){this.m_bSceneDirty=true;if(s instanceof sap.ui.vbm.VoAggregation){this.m_bWindowsDirty=true;this.bDataDeltaUpdate=this.bHandleChangedDataActive;}else if(s instanceof sap.ui.vbm.Legend){this.m_bLegendDirty=true;}else if(s instanceof sap.ui.vbm.GeoJsonLayer){if(s instanceof sap.ui.vbm.FeatureCollection){this.m_bFCsDirty=true;}else{this.m_bGJLsDirty=true;}}else if(s instanceof sap.ui.vbm.ClusterBase){this.m_bClustersDirty=true;}sap.ui.core.Control.prototype.invalidate.apply(this,arguments);};G.prototype.openContextMenu=function(t,i,m){if(m&&m.vbi_data&&m.vbi_data.VBIName=="DynContextMenu"){if(!this.mVBIContext.m_Menus){this.mVBIContext.m_Menus=new window.VBI.Menus();}this.mVBIContext.m_Menus.m_menus.push(m);var a={"SAPVB":{"version":"2.0","Automation":{"Call":{"earliest":"0","handler":"CONTEXTMENUHANDLER","instance":i.sId,"name":"SHOW","object":t,"refID":"CTM","Param":[{"name":"x","#":i.mClickPos[0]},{"name":"y","#":i.mClickPos[1]},{"name":"scene","#":"MainScene"}]}}}};this.loadHtml(a);}};G.prototype.addResourceIfNeeded=function(r){var R=this.getResources();for(var n=0,a=R.length;n<a;++n){if(R[n].getName()===r){return;}}if(G.bEncodedSpotImagesAvailable==false){var p=sap.ui.resource("sap.ui.vbm","themes/base/img/Pin_images.json");var o=jQuery.sap.syncGetJSON(p);G.bEncodedSpotImageData=o.data;G.bEncodedSpotImagesAvailable=true;}if(G.bEncodedSpotImageData){for(var k in G.bEncodedSpotImageData){if(r==k){this.addResource(new sap.ui.vbm.Resource({name:k,value:G.bEncodedSpotImageData[k]}));}}}else{this.addResource(new sap.ui.vbm.Resource({name:r,src:sap.ui.resource("sap.ui.vbm","themes/base/img/"+r)}));}this.m_bResourcesDirty=true;};G.prototype.handleChangedData=function(n){try{this.bHandleChangedDataActive=true;if(n&&n.length){for(var a=0,N,c;a<n.length;++a){N=n[a];c=this.getAggregatorContainer(N.name);if(c){c.handleChangedData(N.E);}}}this.bHandleChangedDataActive=false;}catch(e){this.bHandleChangedDataActive=false;throw e;}};G.prototype.getChildByKey=function(c,k){var a,C=null;if((a=c.getParent())){if(a instanceof sap.ui.vbm.VoAggregation){if((this.getAggregatorContainer(a.getId()))){C=a.findInstanceByKey(k);}}else{C=a.findInstance(k);}}return C;};G.prototype.zoomToAreasById=function(u,c){if(c===undefined||c===null){c=0.9999;}u=[].concat(u);var a=this.getVos().filter(function(v){return v instanceof sap.ui.vbm.Areas;});var b=a.reduce(function(p,f){return p.concat(f.getItems());},[]);var e=b.map(function(f){if(u.indexOf(f.getId())!==-1){return f.UniqueId;}else{return null;}});e=e.filter(function(f){return f?f:false;});var s=this.mVBIContext.GetMainScene();s.ZoomTo(e,c);return this;};return G;},true);
