/*
 * ! SAP UI development toolkit for HTML5 (SAPUI5) (c) Copyright 2009-2012 SAP AG. All rights reserved
 */
sap.ui.define(["sap/ui/core/Control","jquery.sap.global","sap/ui/core/ResizeHandler","./adapter3d/thirdparty/three","./adapter3d/thirdparty/OrbitControls","./adapter3d/Utilities","./ViewportRenderer","./library"],function(C,q,R,T,O,U,V,l){"use strict";var t="sap.ui.vbm.Viewport";var a=q.sap.log;var b=C.extend("sap.ui.vbm.Viewport",{metadata:{library:"sap.ui.vbm",properties:{width:{type:"sap.ui.core.CSSSize",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",defaultValue:"100%"},cameraHistoryLength:{type:"int",defaultValue:0},cameraHistoryPos:{type:"int"}},events:{cameraChange:{parameters:{historyPos:{type:"int"},historyLength:{type:"int"}}}}}});var E=0.000001;var F=0.6;var M=50000.0;var c=85.0;var d=b.getMetadata().getParent().getClass().prototype;b.prototype.init=function(){if(d.init){d.init.call(this);}this._resizeListenerId=null;this._renderLoopRequestId=0;this._renderLoopFunction=this._renderLoop.bind(this);this._renderer=new T.WebGLRenderer({antialias:true});this._renderer.setPixelRatio(window.devicePixelRatio);this._renderer.shadowMap.enabled=true;this._renderer.domElement.tabIndex=-1;this._renderer.domElement.id=this.getId()+"-canvas";this._scene=new T.Scene();this._root=new T.Group();this._root.scale.set(-1,1,1);this._root.rotateX(T.Math.degToRad(90));this._root.matrixAutoUpdate=false;this._root.updateMatrix();this._scene.add(this._root);this._mapPlane=new T.Mesh(new T.PlaneGeometry(M,M,1,1),new T.MeshBasicMaterial({color:0x207bad,side:T.DoubleSide}));this._mapPlane.name="MapPlane";this._mapPlane.layers.set(2);this._mapPlane.visible=false;this._mapPlane.matrixAutoUpdate=false;this._mapPlane.updateMatrix();this._root.add(this._mapPlane);this._scene.background=new T.Color('white');this._scene.add(new T.AmbientLight(0x202020,1));var i=new T.DirectionalLight(0x333333,1);i.position.set(0,0,-1);i.matrixAutoUpdate=false;i.updateMatrix();this._scene.add(i);var j=new T.DirectionalLight(0x51515b,1);j.position.set(-2,-1.1,2.5);j.matrixAutoUpdate=false;j.updateMatrix();this._scene.add(j);var k=new T.DirectionalLight(0x5b5b5b,2);k.position.set(2,1.5,0.5);k.matrixAutoUpdate=false;k.updateMatrix();this._scene.add(k);this._light=new T.DirectionalLight(0xEEEEEE,1);this._lightPos=new T.Vector3(0,0,0);this._scene.add(this._light);this._camera=new T.PerspectiveCamera(30,window.innerWidth/window.innerHeight,0.1,2000);this._camera.layers.enable(0);this._camera.layers.enable(1);this._scene.add(this._camera);this._camera.position.set(0,30,30);this._camera.lookAt(new T.Vector3(0,0,0));this._cameraHome;this._flyToRequestId;this._resetTimerId;this._cameraHistory=[];this._cameraChangeEvent={};this._bbox=new T.Box3();this._cameraController=new O(this._camera,this._renderer.domElement);this._cameraController.addEventListener("end",this._cameraEnd.bind(this));this._cameraController.addEventListener("change",this._cameraUpdate.bind(this));this._cameraController.update();};b.prototype.exit=function(){if(this._resizeListenerId){R.deregister(this._resizeListenerId);this._resizeListenerId=null;}this._stopRenderLoop();this._scene=null;this._camera=null;this._renderer=null;if(d.exit){d.exit.call(this);}};b.prototype.getRoot=function(){return this._root;};b.prototype.getScene=function(){return this._scene;};b.prototype.getCamera=function(){return this._camera;};b.prototype.getCameraHistoryLength=function(){return this._cameraHistory.length;};b.prototype.setCameraHistoryLength=function(){a.error("cameraHistoryLength is read only property",t);return this;};b.prototype.setCameraHistoryPos=function(p){if(this._cameraHistory.length>0&&p>=0&&p<this._cameraHistory.length){if(p!==this.getCameraHistoryPos()){this.setProperty("cameraHistoryPos",p,true);delete this._cameraHistory[p].tag;this._fireCameraChange();this._flyTo(this._cameraController.saveState(),this._cameraHistory[p],F);}}return this;};b.prototype.applyCameraHome=function(i){if(this._cameraHome){this._applyCamera(this._cameraHome,i);}};b.prototype.worldToScreen=function(p){var i=this.getDomRef();if(!i){return undefined;}var j=i.getBoundingClientRect();var k=this.getCamera();var m=new T.Matrix4().multiplyMatrices(k.projectionMatrix,new T.Matrix4().getInverse(k.matrixWorld));var s=p.clone().applyMatrix4(m);var x=Math.floor((+s.x*0.5+0.5)*j.width+0.5);var y=Math.floor((-s.y*0.5+0.5)*j.height+0.5);return new T.Vector2(x,y);};b.prototype.onBeforeRendering=function(){if(this._resizeListenerId){R.deregister(this._resizeListenerId);this._resizeListenerId=null;}this._stopRenderLoop();};b.prototype.onAfterRendering=function(){var i=this.getDomRef();i.appendChild(this._renderer.domElement);this._resizeListenerId=R.register(this,this._handleResize.bind(this));this._handleResize({size:{width:i.clientWidth,height:i.clientHeight}});this._startRenderLoop();};b.prototype._handleResize=function(i){if(!this._camera||!this._renderer){return false;}var w=i.size.width;var j=i.size.height;if(this._camera){this._camera.aspect=w/j;this._camera.updateProjectionMatrix();}this._renderer.setSize(w,j,false);};b.prototype._startRenderLoop=function(){if(!this._renderLoopRequestId){this._renderLoopRequestId=window.requestAnimationFrame(this._renderLoopFunction);}return this;};b.prototype._stopRenderLoop=function(){if(this._renderLoopRequestId){window.cancelAnimationFrame(this._renderLoopRequestId);this._renderLoopRequestId=0;}return this;};b.prototype._renderLoop=function(){this._cameraController.update();this._camera.getWorldDirection(this._lightPos);this._lightPos.negate();this._light.position.copy(this._lightPos);this._renderer.render(this._scene,this._camera);this._renderLoopRequestId=window.requestAnimationFrame(this._renderLoopFunction);};function e(i,s,j,k){return s+j*((i=i/k-1)*i*i+1);}function f(i){var j=Math.min((Date.now()-i.when)/1000,i.length);var k=i.tempTarget;k.x=e(j,i.from.target.x,i.to.target.x-i.from.target.x,i.length);k.y=e(j,i.from.target.y,i.to.target.y-i.from.target.y,i.length);k.z=e(j,i.from.target.z,i.to.target.z-i.from.target.z,i.length);var m=e(j,i.distanceFrom,i.distanceTo-i.distanceFrom,i.length);var n=e(j,0,i.angle,i.length);var p=i.tempPos.copy(i.dir).applyAxisAngle(i.axis,n).multiplyScalar(m).add(k);this._cameraController.reset({position:p,target:k,zoom:1.0});if(j<i.length){this._flyToRequestId=window.requestAnimationFrame(f.bind(this,i));}else{this._flyToRequestId=undefined;}}b.prototype._flyTo=function(i,j,k){var m=j.position.clone().sub(j.target);var n=i.position.clone().sub(i.target);var o=m.length();var p=n.length();var s=Math.acos(U.clamp(n.dot(m)/(o*p),-1,1));var u={to:j,from:i,when:Date.now(),length:k,angle:s,axis:n.clone().cross(m).normalize(),distanceTo:o,distanceFrom:p,dir:n.normalize(),tempPos:new T.Vector3(),tempTarget:new T.Vector3()};if(this._flyToRequestId){window.cancelAnimationFrame(this._flyToRequestId);}this._flyToRequestId=window.requestAnimationFrame(f.bind(this,u));};b.prototype._cameraEnd=function(i){var s=this._cameraController.saveState();var p=this.getCameraHistoryPos();var j=p>=0?this._cameraHistory[p]:undefined;if(j==undefined||s.target.distanceToSquared(j.target)>E||s.position.distanceToSquared(j.position)>E){this._pushCameraChange(s);}};function r(){if(this._cameraHistory.length>0){delete this._cameraHistory[this._cameraHistory.length-1].tag;}this._resetTimerId=undefined;}b.prototype._cameraUpdate=function(i){if(i.tag){if(this._resetTimerId){window.clearTimeout(this._resetTimerId);}this._resetTimerId=window.setTimeout(r.bind(this),500);var s=this._cameraController.saveState();var p=this.getCameraHistoryPos();s.tag=i.tag;var j=p>=0?this._cameraHistory[p]:{};if(s.tag&&s.tag===j.tag){this._cameraHistory[p]=s;}else{this._pushCameraChange(s);}}this._updateCamera();this._updateController();};b.prototype._fireCameraChange=function(){this._cameraChangeEvent.historyPos=this.getCameraHistoryPos();this._cameraChangeEvent.historyLength=this._cameraHistory.length;this.fireCameraChange(this._cameraChangeEvent);};b.prototype._pushCameraChange=function(s){var p=this.getCameraHistoryPos();this._cameraHistory.splice(p>=0?p+1:0,this._cameraHistory.length);this._cameraHistory.push(s);this.setProperty("cameraHistoryPos",this._cameraHistory.length-1,true);this._fireCameraChange();};b.prototype._setCameraHome=function(s){this._cameraHome=s;};b.prototype._applyCamera=function(s,i){var j=this._cameraController.saveState();if(s.target.distanceToSquared(j.target)>E||s.position.distanceToSquared(j.position)>E){this._pushCameraChange(s);if(i){this._flyTo(this._cameraController.saveState(),s,F);}else{this._cameraController.reset(s);}}};b.prototype._getCameraState=function(){return this._cameraController.saveState();};b.prototype._intersectMapPlane=function(i){i.layers.set(2);var o=i.intersectObjects([this._mapPlane],false);return o;};var _=new T.Box3(),g=new T.Matrix4();function h(o,j){var i,k=o.geometry;o.updateWorldMatrix(false,false);if(o.visible&&k){if(!k.boundingBox){k.computeBoundingBox();}if(o.isInstancedMesh){for(i=0;i<o.count;++i){o.getMatrixAt(i,g);_.copy(k.boundingBox);_.applyMatrix4(g);j.union(_);}}else{_.copy(k.boundingBox);_.applyMatrix4(o.matrixWorld);j.union(_);}}var m=o.children;for(i=0;i<m.length;++i){h(m[i],j);}}b.prototype._resetBBox=function(){this._bbox.makeEmpty();};b.prototype._getBBox=function(){if(this._bbox.isEmpty()){h(this.getScene(),this._bbox);}return this._bbox;};b.prototype._updateCamera=function(){var i=this._getBBox();if(!i.isEmpty()){var s=new T.Sphere();i.getBoundingSphere(s);if(s.radius===0){s.radius=1;}this._camera.updateMatrixWorld(false);s.center.applyMatrix4(this._camera.matrixWorldInverse);var n=U.clamp(-s.center.z-s.radius,s.radius*0.001,-s.center.z-s.radius);var j=n+s.radius*2,k=false;if(Math.abs(this._camera.near-n)>=this._camera.near*0.03){this._camera.near=n;k=true;}if(Math.abs(this._camera.far-j)>=this._camera.far*0.03){this._camera.far=j;k=true;}if(k){this._camera.updateProjectionMatrix();}}};b.prototype._updateController=function(){var i=this._cameraController.target.clone().sub(this._camera.position).normalize();var n=new T.Vector3(0,this._camera.position.y>0?1:-1,0);var p=new T.Plane(n),j=new T.Vector3();var k=new T.Ray(this._camera.position,i);if(k.intersectPlane(p,j)){if(T.Math.radToDeg(this._camera.position.clone().sub(j).angleTo(n))<c){this._cameraController.target.copy(j);}}};return b;});
