//@ui5-bundle sap/ui/vbm/library-preload.js
/*
 * ! SAP UI development toolkit for HTML5 (SAPUI5) (c) Copyright 2009-2012 SAP AG. All rights reserved
 */
sap.ui.predefine('sap/ui/vbm/Adapter',["sap/ui/core/Element","./library"],function(E,l){"use strict";var c=jQuery.sap.log;
var A=E.extend("sap.ui.vbm.Adapter",{metadata:{library:"sap.ui.vbm",associations:{map:{type:"sap.ui.vbm.GeoMap"}},events:{submit:{parameters:{data:{type:"string"}}}}}});
A.prototype.init=function(){this._eventHandlers=[];this._actions=[];this._mapConfiguration={};this._clusterVOs=new Map();this._dataTypes={};this._data={};this._idKeyMap={};this._propsAnomalies=new Map();this._propsAnomalies.set("pos","position");this._propsAnomalies.set("posarray","position");this._propsAnomalies.set("dragdata","dragData");this._routeProperties=["color","colorBorder","directionIndicator","dotcolor","dotwidth","dragdata","end","hotDeltaColor","labelBgColor","labelPos","labelText","lineDash","linewidth","posarray","selectColor","start","tooltip"];this._spotProperties=["alignment","contentOffset","dragdata","fxdir","fxsize","hotDeltaColor","icon","image","labelBgColor","labelPos","labelText","pos","selectColor","tooltip","semanticType"];};
A.prototype.exit=function(){this._actions.forEach(function(a){a.detach();});this._detachHandlers();};
A.prototype.setMap=function(m){var o=this._map()||null;var n=sap.ui.getCore().byId(m instanceof sap.ui.vbm.GeoMap?m.getId():m);if((o!=n)&&(o!=null)){this._detachHandlers();this.init();}this.setAssociation("map",m,true);if(n!=null){var M=new sap.ui.model.json.JSONModel();M.setSizeLimit(100000);n.setModel(M);}};
A.prototype._map=function(){return sap.ui.getCore().byId(this.getMap());};
A.prototype._attachHandler=function(e,h,a){if((e in this.mEventRegistry)&&(this.mEventRegistry[e].length>0)){return this;}else{if(!a._eventHandlers.some(function(b){return b===h;})){a._eventHandlers.push(h);}this.attachEvent(e,h,a);return this;}};
A.prototype._detachHandlers=function(){var t=this;var d=function(s){if(this.hasListeners(s)){var b=this.mEventRegistry[s];for(var i=0,L=b.length;i<L;i++){var h=t._eventHandlers.indexOf(b[i].fFunction);if(h!==-1){this.detachEvent(s,b[i].fFunction,b[i].oListener);}}}};var g=this._map();if(g!=null){var m=g.mEventRegistry;for(var e in m){if(m.hasOwnProperty(e)){d.call(g,e);}}var a=function(v){var V=v.mEventRegistry;for(var b in V){if(V.hasOwnProperty(b)){d.call(v,b);}}};g.getVos().forEach(a);}return this;};
A.prototype.load=function(d){var o=null;if(typeof d==='string'){try{o=JSON.parse(d);}catch(e){c.debug("sap.ui.vbm.Adapter: attempt to load invalid JSON string.");return this;}}else if(typeof d==='object'){o=d;}if(!o){c.debug("sap.ui.vbm.Adapter: nothing to load.");return this;}if(!o.SAPVB){c.debug("sap.ui.vbm.Adapter:invalid object supplied for load.");return this;}if(o.SAPVB.Config){this._processConfiguration(o.SAPVB.Config);}if(o.SAPVB.Resources){this._processResources(o.SAPVB.Resources);}if(o.SAPVB.DataTypes){this._processDataTypes(o.SAPVB.DataTypes);}if(o.SAPVB.Clustering){this._processClusters(o.SAPVB.Clustering);}return(o.SAPVB.MapProviders?this._processMapProviders(o.SAPVB.MapProviders):Promise.resolve()).then(function(){if(o.SAPVB.MapLayerStacks){this._processMapLayerStacks(o.SAPVB.MapLayerStacks);}if(o.SAPVB.Scenes){this._processScenes(o.SAPVB.Scenes);}if(o.SAPVB.Data){this._processData(o.SAPVB.Data);}if(o.SAPVB.Actions){this._processActions(o.SAPVB.Actions);}if(o.SAPVB.Automation&&o.SAPVB.Automation.Call){this._processAutomation(o.SAPVB.Automation,o.SAPVB.Menus);}if(o.SAPVB.Windows){this._processDetailWindows(o);}}.bind(this));};
A.prototype._processConfiguration=function(a){return this;};
A.prototype._processResources=function(r){if(r.Set){var g=this._map();g.destroyResources();[].concat(r.Set.Resource).forEach(function(a){g.addResource(new sap.ui.vbm.Resource({"name":a.name,"value":a.value}));},this);}return this;};
A.prototype._processDataTypes=function(d){if(d.Set){if(d.Set.name&&d.Set.type&&(d.Set.type==="N")){[].concat(d.Set.N).foreach(function(a){this._dataTypes.forEach(function(_){if(_.name==a.name){_=a;}});});}else{this._dataTypes=[].concat(d.Set.N);}}return this;};
A.prototype._processData=function(b){var g=function(a,n){var e=sap.ui.vbm.findInArray(this._dataTypes,function(_){return _.name==n;});if((e==null)||!(e.A)){return undefined;}else{var o=sap.ui.vbm.findInArray(e.A,function(_){return _.alias==a;});if(o!=null){return o.name;}else{return undefined;}}};var h=function(n){if(n.name&&n.E){this._data[n.name]=[].concat(n.E).map(function(e){var d={};for(var a in e){if((a!=="xmlns:VB")&&(a!=="n.name")&&e.hasOwnProperty(a)){if(a==="VB:c"){d["changeable"]=e[a];}else if(a==="VB:s"){d["select"]=e[a];}else{var s=g.call(this,a,n.name);if((s!=null)&&(s!=="")){d[s]=e[a];}else{d[a]=e[a];}}}}return d;},this);}};var u=function(e){var d={};for(var a in e){if((a!=="xmlns:VB")&&(a!=="n.name")&&e.hasOwnProperty(a)){if(a==="VB:c"){d["changeable"]=e[a];}else if(a==="VB:s"){d["select"]=e[a];}else{var s=g.call(this,a,e["n.name"]);if((s!=null)&&(s!=="")){d[s]=e[a];}else{d[a]=e[a];}}}}if(!this._data[e["n.name"]]){this._data[e["n.name"]]=[];}if(this._data[e["n.name"]].some(function(_){return _.Key==e.K;})){var i=sap.ui.vbm.findIndexInArray(this._data[e["n.name"]],function(_){return _.Key===e.K;});if(i!==-1){this._data[e["n.name"]][i]=d;}}else{this._data[e["n.name"]].push(d);}};if(b.Remove){[].concat(b.Remove).filter(function(r){return(r.N&&r.N.E);}).forEach(function(r){[].concat(r.N.E).forEach(function(e){var i=sap.ui.vbm.findIndexInArray(this._data[r.name],function(_){return _.Key===e.K;});if(i!==-1){this._data[r.name].splice(i,1);}},this);},this);}if(b.Set&&(typeof b.Set==='object')&&!(jQuery.isEmptyObject(b.Set))){if(!Array.isArray(b.Set)&&!(b.Set.name)&&!(b.Set.type)){this._data={};if(b.Set.N!==null){[].concat(b.Set.N).forEach(h,this);}}else{[].concat(b.Set).filter(function(s){return(s.name)&&(s.type);}).map(function(s){return[].concat(s.N);}).reduce(function(a,B){return a.concat(B);}).map(function(n){var e=n.hasOwnProperty("E")&&n.E?[].concat(n.E):[];return e.map(function(_){_["n.name"]=n.name;return _;});}).reduce(function(a,B){return a.concat(B);}).forEach(u,this);}}this._map().getModel().setData(this._data,false);return this;};
A.prototype._processMapProviders=function(p){if(p.Set&&p.Set.MapProvider){var m=[].concat(p.Set.MapProvider).map(function(a){return{name:a.name,tileX:a.tileX,tileY:a.tileY,minLOD:a.minLOD,maxLOD:a.maxLOD,copyright:a.copyright,MapBase:a.MapBase,copyrightImage:a.copyrightImage,copyrightLink:a.copyrightLink,description:a.description,projection:a.projection,resolution:a.resolution,retries:a.retries,type:a.type,Source:a.Source?[].concat(a.Source).map(function(s){return{id:s.id,url:s.url};}):a.Source};});var d=function(s){return s&&s.url&&s.url.indexOf("google")!==-1;};var G=m.map(function(P){return[].concat(P.Source);}).reduce(function(a,b){return a.concat(b);}).filter(d);if(G.length>0){var e=[];var o=G.reduce(function(g,a){var b=a.url.split("key=")[1];g[b]=g[b]||[];if(sap.ui.vbm.findIndexInArray(e,function(k){return k===b;})===-1){e.push(b);}g[b].push(a);return g;},{});var h=function(a){return new Promise(function(r,b){var x=new XMLHttpRequest();x.open("POST",'https://www.googleapis.com/tile/v1/createSession?key='+a,true);x.setRequestHeader("Content-Type","application/json");x.onreadystatechange=function(){if(x.readyState==4){if(x.status==200){r(JSON.parse(x.responseText));}else{b(new Error(x.statusText));}}};var g={"mapType":"terrain","language":"en-NZ","region":"nz","layerTypes":["layerRoadmap"],"overlay":false,"scale":"scaleFactor1x"};x.send(JSON.stringify(g));}).then(function(r){if(r&&r.session){o[a].forEach(function(s){s.url=s.url+"&session="+r.session;});}},function(s){c.debug(s);});};return Promise.all(e.map(h)).then(function(){this._mapConfiguration.MapProvider=m;this._updateMapconfiguration();}.bind(this));}else{this._mapConfiguration.MapProvider=m;this._updateMapconfiguration();return Promise.resolve();}}return this;};
A.prototype._processMapLayerStacks=function(s){if(s.Set&&s.Set.MapLayerStack){this._mapConfiguration.MapLayerStacks=[];[].concat(s.Set.MapLayerStack).forEach(function(a){var b={name:a.name},d="true";if(a.MapLayer){b.MapLayer=[];[].concat(a.MapLayer).forEach(function(i){var e={name:i.name,refMapProvider:i.refMapProvider,opacity:i.opacity,colBkgnd:i.colBkgnd,singleBMP:i.singleBMP||"false"};d=e.singleBMP!=="true"?"false":d;b.MapLayer.push(e);});b.singleBMP=a.singleBMP||d;}this._mapConfiguration.MapLayerStacks.push(b);},this);this._updateMapconfiguration();}return this;};
A.prototype._updateMapconfiguration=function(){if(this._mapConfiguration.MapProvider&&this._mapConfiguration.MapLayerStacks){this._map().setMapConfiguration(this._mapConfiguration);}return this;};
A.prototype._ui5Id=function(i){return this._map().getId()+"-"+i;};
A.prototype._processScenes=function(s){if(s.Set&&s.Set.SceneGeo){var m=this._map();if(s.Set.SceneGeo.initialStartPosition){m.setCenterPosition(s.Set.SceneGeo.initialStartPosition);}if(s.Set.SceneGeo.initialZoom){m.setZoomlevel(Math.floor(s.Set.SceneGeo.initialZoom));}if(s.Set.SceneGeo.refMapLayerStack){m.setRefMapLayerStack(s.Set.SceneGeo.refMapLayerStack);}var v=s.Set.SceneGeo.VO;m.destroyVos();if(!v){return this;}v.forEach(function(d){if(this._clusterVOs.has(d.id)){return;}var a,b,e=[],g={};function p(n,o){for(var q in d){var r=q.indexOf('.bind');var t=r!==-1?q.substring(0,r):q;if(n.indexOf(t)!==-1){t=o.get(t)||t;var u=d[q];if(r!==-1){u=d[q].substring(d[q].indexOf('.')+1);e.push(u);}g[t]=r!==-1?"{"+u+"}":u;}}}function h(){if(d.DragSource&&b.getMetadata().hasAggregation("dragSource")){[].concat(d.DragSource.DragItem).forEach(function(n){b.addDragSource(new sap.ui.vbm.DragSource({type:n.type}));});}if(d.DropTarget&&b.getMetadata().hasAggregation("dropTarget")){[].concat(d.DropTarget.DropItem).forEach(function(n){b.addDropTarget(new sap.ui.vbm.DropTarget({type:n.type}));});}}switch(d.type){case"{00100000-2012-0004-B001-64592B8DB964}":p(this._spotProperties,this._propsAnomalies);a=new sap.ui.vbm.Spot(g);b=new sap.ui.vbm.Spots(this._ui5Id(d.id));h();break;case"{00100000-2012-0004-B001-C46BD7336A1A}":p(this._routeProperties,this._propsAnomalies);a=new sap.ui.vbm.Route(g);b=new sap.ui.vbm.Routes(this._ui5Id(d.id));h();break;case"{00100000-2012-0004-B001-F311DE491C77}":case"{00100000-2013-0004-B001-7EB3CCC039C4}":case"{00100000-2013-0004-B001-686F01B57873}":case"{00100000-2012-0004-B001-BFED458C3076}":case"{00100000-2012-0004-B001-383477EA1DEB}":case"{388951f5-a66b-4423-a5ad-e0ee13c2246f}":case"ExtLink":case"ExtArea":default:c.debug("unsupported VO type: "+d.type);return;}var i=sap.ui.vbm.findIndexInArray(this._dataTypes,function(_){return _.name===d.datasource;});if(i!==-1){var j=this._dataTypes[i];a.bindProperty("key",{path:j.key});e.push(j.key);var k=[];j.A.forEach(function(n){if(e.indexOf(n.name)===-1){k.push(n.name);var o=new sap.ui.core.CustomData({key:n.name,value:"{"+n.name+"}"});a.addCustomData(o);}});if(k.length){b.setCustomProperties(k);}b.bindAggregation("items",{path:"/"+d.datasource+"",template:a});}else{b.addItem(a);}m.addVo(b);}.bind(this));}else if(s.Merge&&s.Merge.SceneGeo&&s.Merge.SceneGeo.refMapLayerStack){this._map().setRefMapLayerStack(s.Merge.SceneGeo.refMapLayerStack);}return this;};
function f(d,a){Object.assign(this,d);this._adapter=a;if(!this.refVO){this.refVO="General";}}
f.prototype.attach=function(){var a=false;this._listener=this._adapter;this._handler=this._adapter._handler;if(this.refVO==="Map"||this.refVO==="General"){this._target=this._adapter._map();}else{var i=this._adapter._ui5Id(this.refVO);this._target=sap.ui.vbm.findInArray(this._adapter._map().getVos(),function(v){return v.getId()===i;});if(!this._target){this._target=this._adapter._clusterVOs.get(this.refVO);a=!!this._target;}}if(!this._target){c.warning("unable to attach action: "+this.id);return false;}switch(this.refEvent){case"Click":this._event="click";if(a){this._listener=this;this._handler=function(e){this._adapter._handler(e,this);};}break;case"ContextMenu":this._event="contextMenu";if(a){this._listener=this;this._handler=function(e){this._adapter._handler(e,this);};}break;case"DoubleClick":this._event="click";this._handler=this._adapter._clickHandler;if(a){this._listener=this;this._handler=function(e){this._adapter._clickHandler(e,this);};}break;case"Drop":this._event="drop";break;case"Select":this._event="select";break;case"KeyPress":if(this._target!==this._adapter._map()){return false;}this._event="keyDown";this._target.setKeyEventDelay(250);this._target.setAllowKeyEventRepeat(false);this._handler=this._adapter._getKeyboardHandler(this.name);break;default:return false;}this._target.attachEvent(this._event,this._handler,this._listener);this._target.invalidate();return true;};
f.prototype.detach=function(){if(this._target&&this._event&&this._handler&&this._listener){this._target.detachEvent(this._event,this._handler,this._listener);this._target.invalidate();this._target=this._event=this._handler=this._listener=undefined;}};
A.prototype._removeAction=function(i){var r=this._actions[i];r.detach();this._actions.splice(i,1);if(r.refEvent==="DoubleClick"){var a=sap.ui.vbm.findInArray(this._actions,function(b){return b.refVO===r.refVO&&b.refEvent==="Click";});if(a){a.attach();}}};
A.prototype._addAction=function(d){var a=new f(d,this);if(d.refEvent==="Click"){if(this._actions.some(function(a){return a.refVO===d.refVO&&a.refEvent==="DoubleClick";},this)){this._actions.push(a);return;}}else if(d.refEvent==="DoubleClick"){var b=sap.ui.vbm.findInArray(this._actions,function(a){return a.refVO===d.refVO&&a.refEvent==="Click";},this);if(b){b.detach();}}if(a.attach()){this._actions.push(a);}else{c.info("unable to attach action: "+d.id);}};
A.prototype._processActions=function(a){var b,i;if(a.Remove){if(a.Remove.Action){b=[].concat(a.Remove.Action);}else{b=[].concat(a.Remove);}b.forEach(function(d){i=sap.ui.vbm.findIndexInArray(this._actions,function(e){return e.id===d.id});if(i!==-1){this._removeAction(i);}else{c.info("remove of nonexistent action: "+d.id);}},this);}if(a.Set){if(a.Set.Action){b=[].concat(a.Set.Action);}else{b=[].concat(a.Set);}b.forEach(function(d){i=sap.ui.vbm.findIndexInArray(this._actions,function(e){return e.id===d.id});if(i!==-1){this._removeAction(i);}this._addAction(d);},this);}return this;};
A.prototype._getKeyboardHandler=function(n){return function(e){var p=e.mParameters;if(p.key=="Shift"||p.code==16||p.key=="Control"||p.code==17||p.key=="Alt"||p.code==18||p.key=="Meta"||p.code==91){return;}var d={"version":"2.0","xmlns:VB":"VB","Action":{"name":n,"Params":{"Param":[{"name":"code","#":p.code},{"name":"shift","#":p.shift},{"name":"ctrl","#":p.ctrl},{"name":"alt","#":p.alt},{"name":"meta","#":p.meta}]}}};this.fireSubmit({data:JSON.stringify(d)});};};
A.prototype.idKeyMapGenerator=function(){this._map().getVos().map(function(a){return a.getItems();}).reduce(function(a,b){return a.concat(b);}).forEach(function(i){this._idKeyMap[i.getUniqueId()]=i.getKey();},this);return this;};
A.prototype._processAutomation=function(d,m){var g={};if(d.Call.handler==="CONTEXTMENUHANDLER"){var t=this;var h=this._map();if(d.Call.instance&&d.Call.instance.split('.').length==2){var v=this._map().getVos().map(function(V){return V.getItems();}).reduce(function(V,o){return V.concat(o);}).filter(function(V){return V.getKey()===d.Call.instance.split('.')[1];});if(v.length>0){h=v[0];d.Call.instance=h.getUniqueId();d.Call.object=t._ui5Id(d.Call.object);}}if(m.Set.Menu){[].concat(m.Set.Menu).forEach(function(M){t._attachHandler.call(h,M.action,function(o){var p;if(o.oSource===t._map()){p=o.getParameters();if(jQuery.sap.startsWith(p.Action.object,this._map().getId())){p.Action.object=p.Action.object.substr(this._map().getId().length+1)}if(p.id&&p.hasOwnProperty("id")){delete p.id;}}else{p=o.getParameters().data;if(jQuery.sap.startsWith(p.Action.object,this._map().getId())){p.Action.object=p.Action.object.substr(this._map().getId().length+1)}p.Action.instance=p.Action.object+'.'+o.oSource.getKey();}if((p.Data)&&(p.Data.Merge)&&(p.Data.Merge.N)){[].concat(p.Data.Merge.N).forEach(function(n){if(n.name&&jQuery.sap.startsWith(n.name,this._map().getId())){n.name=n.name.substr(this._map().getId().length+1)}},this);var i=p.Data.Merge.N.map(function(n){return n.E;}).reduce(function(a,b){return a.concat(b);}).map(function(e){return e.K;});if(jQuery.isEmptyObject(this._idKeyMap)){this.idKeyMapGenerator();}if(i.some(function(u){return!this._idKeyMap.hasOwnProperty(u);},this)){this.idKeyMapGenerator();}var j=function(e){e.K=this._idKeyMap[e.K];};[].concat(p.Data.Merge.N).map(function(n){return n.E;}).reduce(function(a,b){return a.concat(b);}).forEach(j,this);}this.fireSubmit({data:JSON.stringify(p)});},t);});}}g["Automation"]=d;g["Menus"]=m;var L={};L["SAPVB"]=g;this._map().load(L);return this;};
A.prototype._processClusters=function(a){this._clusterVOs.clear();if(a.Set){var m=this._map();m.destroyClusters();[].concat(a.Set.Cluster).forEach(function(i){var b=null;switch(i.type){case"distance":b=new sap.ui.vbm.ClusterDistance(i.id);if(i.distance){b.setDistance(parseFloat(i.distance));}break;case"grid":b=new sap.ui.vbm.ClusterGrid(i.id);if(i.limit){b.setLimit(parseInt(i.limit,10));}if(i.limitOnSum){b.setLimitTotal(parseInt(i.limitOnSum,10));}if(i.order){b.setOrderIndex(parseInt(i.order,10));}if(i.areabordersize){b.setCellSpacing(-parseInt(i.areabordersize,10));}if(i.distanceX&&i.distanceY){b.setGridSize(i.distanceX+";"+i.distanceY);}if(i.offsetX&&i.offsetY){b.setOffset(i.offsetX+";"+i.offsetY);}break;case"tree":b=new sap.ui.vbm.ClusterTree(i.id,{});break;default:c.debug("sap.ui.vbm.Adapter: unsupported clustering type \""+i.type+"\"");break;}if(b){if(i.rule){b.setRule(i.rule);}b.setTextSettings({textcolor:i.textcolor,textfont:i.textfont,textfontsize:i.textfontsize,textoffset:i.textoffset,textoffsetY:i.textoffsetY});b.setVizTemplate(new sap.ui.vbm.Cluster());m.addCluster(b);}this._clusterVOs.set(i.VO,b);},this);}return this;};
A.prototype._processDetailWindows=function(o){var g=this._map();var t=this;if(o.SAPVB.Windows.Set.name){var b=function(p,n){return function(d){return d[p]===n;};};var w=[].concat(o.SAPVB.Windows.Set).map(function(a){var m=g.getModel().getData();var W=a;for(var s in a.Window){if(a.Window.hasOwnProperty(s)){if(jQuery.sap.endsWith(s,".bind")){if(jQuery.sap.startsWith(s,"pos")){var p=a.Window[s].split(".");if(p[0]in m){var i=sap.ui.vbm.findIndexInArray(m[p[0]],b("Key",p[1]));if(i!==-1){var d=m[p[0]][i];if(p[2]in d){delete W.Window[s];W.Window[s.split(".")[0]]=d[p[2]];}}}}}}}return W;},this);o.SAPVB.Windows.Set=w;if(o.SAPVB.Scenes&&o.SAPVB.Scenes.Set&&o.SAPVB.Scenes.Set.name&&o.SAPVB.Scenes.Set.Scene&&o.SAPVB.Scenes.Set.Scene.VO){var V=[].concat(o.SAPVB.Scenes.Set.Scene.VO).map(function(v){var d=v;var e=function(d,h,p){return function(s){if(s.name&&s.type){var D=s[s.type];if(D.name===s.name){var a=sap.ui.vbm.findInArray([].concat(this._dataTypes),b("name",D.name));var i=sap.ui.vbm.findInArray([].concat(sap.ui.vbm.findInArray([].concat(a.N),b("name",p[2])).A),b("name",p[4])).alias;var j=[].concat(D.E)[p[1]];var S=[].concat(sap.ui.vbm.findInArray([].concat(j.N),b("name",p[2])).E)[p[3]];d[h.split(".")[0]]=S[i];delete d[h];}}};};for(var h in v){if(v.hasOwnProperty(h)){if(jQuery.sap.endsWith(h,".bind")){var p=v[h].split(".");if(o.SAPVB.Data&&o.SAPVB.Data.Set){[].concat(o.SAPVB.Data.Set).forEach(e(d,h,p),this);}}}}if(o.SAPVB.Actions&&o.SAPVB.Actions.Set){[].concat(o.SAPVB.Actions.Set).filter(function(a){return a.Action.refVO===d.id;}).forEach(function(a){t._attachHandler.call(g,a.Action.name,t._handler,t);});}return d;},this);o.SAPVB.Scenes.Set.Scene.VO=V;}g.load(o);}return this;};
A.prototype._handler=function(d,g){if(d.oSource instanceof sap.ui.vbm.ClusterBase){var k=d.getParameters().instance.getKey();var s=d.getParameters().event;var h=this._map().mVBIContext.GetMainScene();if(k&&s&&h){var p=h.GetEventVPCoords(s);var i=h.GetPosFromVPPoint([p[0],p[1],0]);var j=this._map().getInfoForCluster(k,sap.ui.vbm.ClusterInfoType.NodeInfo);d.getParameters().data={"version":"2.0","xmlns:VB":"VB","id":d.oSource.getId(),"Action":{"id":g.id,"name":g.name,"object":g.refVO,"instance":k,"Params":{"Param":[{"name":"x","#":p[0].toString()},{"name":"y","#":p[1].toString()}]},"AddActionProperties":{"AddActionProperty":[{"name":"pos","#":i[0].toString()+";"+i[1].toString()+";0.0"},{"name":"vos","#":j.cnt}]}}};this.fireSubmit({data:JSON.stringify(d.getParameters().data)});}}else{var P=d.getParameters();var o=P.data?P.data:P;if(jQuery.sap.startsWith(o.Action.object,this._map().getId())){o.Action.object=o.Action.object.substr(this._map().getId().length+1)}if(o.Action&&o.Action.object){if(o.Action.object==="Route"){o.Action.object="Link";}var m=sap.ui.vbm.findInArray(this._actions,function(g){return o.Action.object===g.refVO&&o.Action.name.toLowerCase()===g.refEvent.toLowerCase();});if(m){o.Action.id=m.id;o.Action.name=m.name;if(o.Action.instance){o.Action.instance=o.Action.object+"."+P.instance.getKey();}var q=[];if(o.Action.Params){o.Action.Params.Param.forEach(function(a){if(a.name==="strSource"){q.push(a);}});if(q.length){if(jQuery.isEmptyObject(this._idKeyMap)){this.idKeyMapGenerator();}else if(q.some(function(a){return!this._idKeyMap.hasOwnProperty(a["#"].split(".")[1]);},this)){this.idKeyMapGenerator();}q.forEach(function(a){var b=a["#"].split(".");a["#"]=b[0]+"."+this._idKeyMap[b[1]];},this);}}if((o.Data)&&(o.Data.Merge)&&(o.Data.Merge.N)){[].concat(o.Data.Merge.N).forEach(function(n){if(n.name&&jQuery.sap.startsWith(n.name,this._map().getId())){n.name=n.name.substr(this._map().getId().length+1)}},this);var r=o.Data.Merge.N.map(function(n){return n.E;}).reduce(function(a,b){return a.concat(b);}).map(function(e){return e.K;});if(jQuery.isEmptyObject(this._idKeyMap)){this.idKeyMapGenerator();}if(r.some(function(u){return!this._idKeyMap.hasOwnProperty(u);},this)){this.idKeyMapGenerator();}var t=function(e){e.K=this._idKeyMap[e.K];};[].concat(o.Data.Merge.N).map(function(n){return n.E;}).reduce(function(a,b){return a.concat(b);}).forEach(t,this);}[].concat(m.AddActionProperty||[]).forEach(function(a){var b=o.Action.AddActionProperties.AddActionProperty||[];var e=sap.ui.vbm.findInArray([].concat(b),function(n){return n.name===a.name;});if(!e){switch(a.name){case"zoom":b.push({"name":a.name,"#":this._map().getZoomlevel()});break;case"centerpoint":b.push({"name":a.name,"#":this._map().getCenterPosition()});break;case"pitch":b.push({"name":a.name,"#":"0.0"});break;case"yaw":b.push({"name":a.name,"#":"0.0"});break;default:break;}}},this);this.fireSubmit({data:JSON.stringify(o)});}}}this.timeout=undefined;};
A.prototype._clickHandler=function(e,a){if(this.timeout){clearTimeout(this.timeout);if(!a){e.getParameters().data.Action.name="doubleclick";}this._handler(e,a);}else{var b=a?sap.ui.vbm.findInArray(this._actions,function(d){return d.refVO===a.refVO&&d.refEvent==="Click";}):undefined;this.oEvent=jQuery.extend(true,{},e);this.timeout=setTimeout(this._handler.bind(this,this.oEvent,b),500);}};
return A;});
sap.ui.predefine('sap/ui/vbm/Adapter3D',["jquery.sap.global","./library","sap/ui/core/Element","sap/ui/base/ManagedObjectObserver","sap/ui/unified/Menu","sap/ui/unified/MenuItem","sap/m/ResponsivePopover","sap/ui/vbm/Viewport","./adapter3d/ObjectFactory","./adapter3d/VBIJSONParser","./adapter3d/SceneBuilder","./adapter3d/Utilities","sap/m/HBox","sap/m/VBox","sap/m/Link","sap/m/Button","sap/m/Text","sap/m/Image","./adapter3d/thirdparty/three"],function(q,l,E,O,M,c,P,V,d,e,S,U,H,f,L,B,T,I,h){"use strict";var t="sap.ui.vbm.adapter3d.Adapter3D";var j=q.sap.log;var k;
var A=E.extend("sap.ui.vbm.Adapter3D",{metadata:{library:"sap.ui.vbm",associations:{viewport:{type:"sap.ui.vbm.Viewport"}},events:{submit:{parameters:{data:{type:"string"}}}}}});
var n=A.getMetadata().getParent().getClass().prototype;
A.prototype.init=function(){if(n.init){n.init.call(this);}this._viewport=null;this._context={resources:new Map(),dataTypes:[],data:{},windows:[],scenes:[],actions:[],voQueues:{toAdd:new Map(),toUpdate:new Map(),toRemove:new Map(),clear:function(){this.toAdd.clear();this.toUpdate.clear();this.toRemove.clear();}},sceneQueues:{toAdd:[],toUpdate:[],toRemove:[],clear:function(){this.toAdd.length=0;this.toUpdate.length=0;this.toRemove.length=0;}},windowQueues:{toAdd:[],toUpdate:[],toRemove:[],clear:function(){this.toAdd.length=0;this.toUpdate.length=0;this.toRemove.length=0;}},setupView:undefined};this._update=Promise.resolve();this._parser=null;this._sceneBuilder=null;this._hoverInstance=null;this._hoverTimeOutId=null;this._clickTimerId=null;this._mouseDown=false;this._lastXY={x:0,y:0};this._viewportObserver=new O(this._observeChanges.bind(this));this._detail={popover:undefined,anchor:undefined,pending:undefined};this._raycaster=new h.Raycaster();};
A.prototype.exit=function(){if(this._clickTimerId){clearTimeout(this._clickTimerId);this._clickTimerId=null;}if(this._hoverTimeOutId){clearTimeout(this._hoverTimeOutId);this._hoverTimeOutId=null;}this._disconnectViewport();this._viewportObserver.disconnect();this._viewportObserver=null;if(this._sceneBuilder){this._sceneBuilder.destroy();this._sceneBuilder=null;}if(this._parser){this._parser.destroy();this._parser=null;}this._context=null;if(n.exit){n.exit.call(this);}};
A.prototype.setViewport=function(v){this.setAssociation("viewport",v,true);this._configureViewport();};
A.prototype._configureViewport=function(){var a=sap.ui.getCore().byId(this.getViewport())||null;if(a!==this._viewport){this._disconnectViewport();this._viewport=a;this._connectViewport();}};
A.prototype._connectViewport=function(){if(this._viewport){this._viewportObserver.observe(this._viewport,{destroy:true});this._viewport.addEventDelegate(k,this);}};
A.prototype._disconnectViewport=function(){if(this._viewport){this._viewport.removeEventDelegate(k);k.onBeforeRendering.call(this);this._viewportObserver.unobserve(this._viewport,{destroy:true});this._viewport=null;}};
A.prototype._observeChanges=function(a){if(a.type==='destroy'&&a.object===this._viewport){this._disconnectViewport();}};
A.prototype.load=function(a){var b=this;b._configureViewport();if(!b._viewport){return Promise.reject();}var p=null;if(!b._parser){b._parser=new e(b._context);}if(!b._sceneBuilder){b._sceneBuilder=new S(b._context,b._viewport);}if(typeof a==="string"){try{p=JSON.parse(a);}catch(g){j.error("sap.ui.vbm.Adapter: attempt to load invalid JSON string.");return Promise.resolve();}}else if(typeof a==="object"){p=a;}if(!(p&&p.SAPVB)){j.error("sap.ui.vbm.Adapter3D: attempt to load null.");return Promise.resolve();}b._viewport.setBusy(true);b._update=b._update.then(function(){b._parser.loadVBIJSON(p);return b._sceneBuilder.synchronize();}).then(function(){b._processAutomation(p);b._processDetailWindow();b._context.voQueues.toRemove.forEach(function(i){i.forEach(function(m){if(b._hoverInstance===m){b._hoverInstance=null;}},b);},b);b._context.voQueues.clear();b._context.sceneQueues.clear();b._context.windowQueues.clear();b._viewport._resetBBox();b._viewport._updateCamera();b._viewport.setBusy(false);});return b._update;};
A.prototype._processDetailWindow=function(p){var w=sap.ui.vbm.findInArray(this._context.windowQueues.toAdd,function(w){return w.type==="callout";});var s=w&&sap.ui.vbm.findInArray(this._context.scenes,function(s){return s.id===w.refScene;});if(w&&s){this._closeDetailWindow();var a=this._createDetailWindow(w);this._fillDetailWindow(a,s);this._openDetailWindow(a,w);}};
A.prototype._closeDetailWindow=function(){if(this._detail.popover){this._detail.popover.close();this._detail.popover.destroy();this._detail.popover=undefined;}if(this._detail.anchor){this._detail.anchor.style.visibility="hidden";}};
A.prototype._createDetailWindow=function(w){var a;if(w.caption!==""){var b=new sap.m.Text({width:"100%",textAlign:sap.ui.core.TextAlign.Center,text:w.caption,tooltip:w.caption});a=new sap.m.Bar({contentLeft:[b]});}var p=new sap.m.ResponsivePopover({placement:sap.m.PlacementType.Auto,showCloseButton:true,verticalScrolling:true,contentWidth:w.width+"px"});p.addStyleClass("sapUiVbmDetailWindow");if(a){p.setCustomHeader(a);}return p;};
A.prototype._getAnchor=function(x,y){if(!this._detail.anchor){var a=document.createElement("div");a.setAttribute("role",sap.ui.core.AccessibleRole.Note);a.classList.add("sapUiVbmDetailWindowAnchor");this._viewport.getDomRef().appendChild(a);this._detail.anchor=a;}this._detail.anchor.style.left=x+"px";this._detail.anchor.style.top=y+"px";return this._detail.anchor;};
A.prototype._openDetailWindow=function(p,a){var b=a.pos.split(";");var w=new h.Vector3(parseFloat(b[0]),parseFloat(b[1]),parseFloat(b[2]));if(!this._viewport.getDomRef()){if(this._detail.pending){this._detail.pending.popover.destroy();}this._detail.pending={world:w,popover:p};}else{var g=this._viewport.getDomRef().getBoundingClientRect();var s=this._viewport.worldToScreen(U.vbToThreeJs(w));s.x=U.clamp(s.x,5,g.width-5);s.y=U.clamp(s.y,5,g.height-5);p.openBy(this._getAnchor(s.x,s.y));p.attachAfterClose(function(){this._closeDetailWindow();}.bind(this));this._detail.popover=p;}};
A.prototype._openDetailPending=function(){if(this._detail.pending&&this._viewport.getDomRef()){var s=this._viewport.worldToScreen(U.vbToThreeJs(this._detail.pending.world));this._detail.pending.popover.openBy(this._getAnchor(s.x,s.y));this._detail.popover=this._detail.pending.popover;this._detail.pending=undefined;}};
A.prototype._fillDetailWindow=function(p,s){var m=function(a){var b;switch(a){case"1":b=sap.m.FlexJustifyContent.Start;break;case"2":b=sap.m.FlexJustifyContent.Center;break;case"4":b=sap.m.FlexJustifyContent.End;break;default:b=sap.m.FlexJustifyContent.Inherit;break;}return b;};var u=function(i){var a;switch(i.type){case"{00100000-2013-1000-1100-50059A6A47FA}":a=new T({text:i.vo.text,tooltip:i.vo.tooltip});a.addStyleClass("sapUiVbmDetailWindowBase sapUiVbmDetailWindowCaption");if(i.vo.level==="3"){a.addStyleClass("sapUiVbmDetailWindowCaption3");}break;case"{00100000-2013-1000-3700-AD84DDBBB31B}":a=new T({text:i.vo.text,tooltip:i.vo.tooltip});a.addStyleClass("sapUiVbmDetailwindowBase");break;case"{00100000-2013-1000-2400-D305F7942B98}":a=new L({text:i.vo.text,tooltip:i.vo.tooltip,href:i.vo.autoexecute?i.vo.reference:""});a.addStyleClass("sapUiVbmDetailWindowBase");break;case"{00100000-2013-1000-1200-855B919BB0E9}":a=new B({text:i.vo.text,tooltip:i.vo.tooltip});break;case"{00100000-2013-1000-2200-6B060A330B2C}":if(i.vo.image&&i.vo.image!==""){a=new I({src:U.makeDataUri(this._context.resources.get(i.vo.image)),tooltip:i.vo.tooltip});}break;default:j.error("sap.ui.vbm.Adapter3D: attempt to create unknown element of detail window: "+i.type);}return a;};var w=s.voGroups.map(function(a){return a.vos.map(function(v){return{type:a.type,vo:v};});}).reduce(function(a,b){return a.concat(b);}).sort(function(a,b){return parseInt(a.vo.top,10)-parseInt(b.vo.top,10);}).reduce(function(g,a){var b=a.vo.top?a.vo.top:"0";g[b]=g[b]||[];g[b].push(a);return g;},{});var x=new f();for(var y in w){if(w.hasOwnProperty(y)){var z=new H({width:Math.max.apply(null,w[y].map(function(i){return parseInt(i.vo.right,10);}))+"px"});var C=0;w[y].sort(function(a,b){return parseInt(a.vo.left,10)-parseInt(b.vo.left,10);}).map(function(i){var a=[];if((parseInt(i.vo.left,10)-C)>1){a.push(new H({width:(parseInt(i.vo.left,10)-C)+"px"}));}var b=new H({width:(parseInt(i.vo.right,10)-parseInt(i.vo.left,10))+"px",justifyContent:m(i.vo.align)});C=parseInt(i.vo.right,10);b.addItem(u.bind(this)(i));a.push(b);return a;},this).reduce(function(a,b){return a.concat(b);}).forEach(z.addItem,z);x.addItem(z);}}p.addContent(x);};
A.prototype._processAutomation=function(a){var b=this;var g=function(m,p,z,C,v){var D=new c({text:p.text,enabled:p.disabled==="X"?false:true,startsSection:v,select:b._menuItemSelectionHandler.bind(b,p.id,z.instance,C,z.object)});if(p.MenuItem){var F=new M();v=false;[].concat(p.MenuItem).forEach(function(G){if(G.hasOwnProperty("Separator")){v=true;}else{g(F,G,z,C,v);v=false;}});D.setSubmenu(F);}m.addItem(D);};if(a&&a.SAPVB&&a.SAPVB.Automation&&a.SAPVB.Automation.Call&&a.SAPVB.Automation.Call){if(a.SAPVB.Automation.Call.handler&&a.SAPVB.Automation.Call.handler==="CONTEXTMENUHANDLER"){var x=[].concat(a.SAPVB.Automation.Call.Param).filter(function(p){return p.name==="x";});var y=[].concat(a.SAPVB.Automation.Call.Param).filter(function(p){return p.name==="y";});var i;if(x.length>0&&y.length>0){i=x[0]["#"]+" "+y[0]["#"];}if(a.SAPVB&&a.SAPVB.Menus&&a.SAPVB.Menus.Set){var s=[].concat(a.SAPVB.Menus.Set).filter(function(m){return m.Menu.id===a.SAPVB.Automation.Call.refID;});if(s.length>0){var u=new M();var v=false;[].concat(s[0].Menu.MenuItem).forEach(function(m){if(m.hasOwnProperty("Separator")){v=true;}else{g(u,m,a.SAPVB.Automation.Call,s[0].Menu.action,v);v=false;}});var w=sap.ui.core.Popup.Dock;u.open(false,this._viewport,w.BeginTop,w.BeginTop,this._viewport,i,"fit fit");}}}}};
A.prototype._menuItemSelectionHandler=function(i,a,b,v){var p={version:"2.0","xmlns:VB":"VB",Action:{id:i,instance:a,name:b,object:v}};this.fireSubmit({data:JSON.stringify(p)});};
A.prototype._genericEventHandler=function(a,b){var i=b.instance;var g=i?i.voGroup.id:b.voGroupId;var m=sap.ui.vbm.findInArray(this._context.actions,function(v){return v.refVO===g&&v.refEvent===a;});if(m){var p=[];var s={version:"2.0","xmlns:VB":"VB",Action:{id:m.id,name:m.name,object:m.refVO,instance:i&&i.id?i.voGroup.datasource+"."+i.id:"",Params:{Param:p}}};if(m.name==="KEY_PRESS"){if(b.keyCode==72){this._viewport.applyCameraHome(false);}if(b.key=="Shift"||b.code==16||b.key=="Control"||b.code==17||b.key=="Alt"||b.code==18||b.key=="Meta"||b.code==91){return;}else{p.push({"name":"code","#":b.keyCode},{"name":"shift","#":b.shiftKey},{"name":"ctrl","#":b.ctrlKey},{"name":"alt","#":b.altKey},{"name":"meta","#":b.metaKey});}}else if(b&&b.cursor){p.push({name:"x","#":b.cursor.x},{name:"y","#":b.cursor.y});}if(m.AddActionProperty){var u=[];[].concat(m.AddActionProperty).forEach(function(v){switch(v.name){case"pos":if(b.hitPoint){var w=U.threeJsToVb(b.hitPoint);u.push({name:v.name,"#":w.x.toFixed(5)+";"+w.y.toFixed(5)+";"+w.z.toFixed(5)});}break;case"zoom":var x=this._viewport._getCameraState();var z=this._sceneBuilder._getZoomFactor(x.position,x.target);u.push({name:v.name,"#":z.toFixed(5)});break;default:break;}},this);if(u.length>0){s.Action.AddActionProperties={AddActionProperty:u};}}if(i&&a==="Click"&&b.selectionChanges){s.Data={Merge:{N:[{name:i.voGroup.datasource,E:b.selectionChanges.selected.map(function(i){return{K:i?i.id:"","VB:s":"true"};}).concat(b.selectionChanges.deselected.map(function(i){return{K:i?i.id:"","VB:s":"false"};}))}]}};}this.fireSubmit({data:JSON.stringify(s)});}};
A.prototype._propagateClick=function(a){this._genericEventHandler("Click",a);};
A.prototype._propagateDoubleClick=function(a){this._genericEventHandler("DoubleClick",a);};
A.prototype._propagateContextMenu=function(a){this._genericEventHandler("ContextMenu",a);};
A.prototype._propagateKeyPress=function(a){this._genericEventHandler("KeyPress",a);};
A.prototype._propogateHoverChange=function(a){this._genericEventHandler("HoverChange",a);};
A.prototype._handleClick=function(a){var i=a.instance;j.trace("click","x: "+a.cursor.x+", y: "+a.cursor.y+", instance: "+(i?i.id:"")+", tooltip: "+(i?i.tooltip:""),t);this._extendEventWithSelection(a);if(a.selectionChanges){this._sceneBuilder.updateSelection(a.selectionChanges.selected,a.selectionChanges.deselected);}this._propagateClick(a);};
A.prototype._handleDoubleClick=function(a){var i=a.instance;j.trace("double click","x: "+a.cursor.x+", y: "+a.cursor.y+", instance: "+(i?i.id:"")+", tooltip: "+(i?i.tooltip:""),t);this._propagateDoubleClick(a);};
A.prototype._handleContextMenu=function(a){var i=a.instance;if(!i){a.voGroupId="Scene";}j.trace("context menu","x: "+a.cursor.x+", y: "+a.cursor.y+", instance: "+(i?i.id:"")+", tooltip: "+(i?i.tooltip:""),t);this._propagateContextMenu(a);};
A.prototype._handleHover=function(a){var b;var i=a.instance||null;j.trace("hover","x: "+a.cursor.x+", y: "+a.cursor.y+", instance: "+(i?i.id:"")+", tooltip: "+(i?i.tooltip:""),t);if(i){b=i.tooltip;if(!b){b=i.text;}}var g=this._viewport.getDomRef();if(g){if(b){g.setAttribute("title",b);}else{g.removeAttribute("title");}}if(i!==this._hoverInstance){clearTimeout(this._hoverTimeOutId);this._hoverTimeOutId=setTimeout(function(){this._propogateHoverChange(a);this._hoverTimeOutId=undefined;}.bind(this),500);this._hoverInstance=i;this._sceneBuilder.updateHotInstance(this._hoverInstance);}};
A.prototype._handleKeyPress=function(a){j.trace("keypress",a.key,t);this._propagateKeyPress(a);};
A.prototype._getXY=function(a){var b=this._viewport.getDomRef().getBoundingClientRect();return{x:(a.pageX||a.originalEvent.pageX)-window.pageXOffset-b.left,y:(a.pageY||a.originalEvent.pageY)-window.pageYOffset-b.top};};
A.prototype._hitTest=function(a){var s=this._viewport.getScene();var b=this._viewport.getCamera();var p=a.cursor||this._getXY(a);var g=this._viewport.getDomRef().getBoundingClientRect();var i=new h.Vector2(p.x/g.width*2-1,-p.y/g.height*2+1);this._raycaster.layers.set(0);this._raycaster.setFromCamera(i,b);var m=this._raycaster.intersectObjects(s.children,true);if(m&&m.length>0){var u=m[0],v=u.object,w=null;if(v){if(v._instanceHitTest instanceof Function){w=v._instanceHitTest(u);}else{w=u.object._sapInstance;}return{info:u,point:u.point,instance:w};}}else if(this._context.scene){m=this._viewport._intersectMapPlane(this._raycaster);if(m&&m.length>0){return{instance:null,info:m[0],point:m[0].point};}}return undefined;};
A.prototype._extendEventWithCursor=function(a){a.cursor=a.cursor||this._getXY(a);};
A.prototype._extendEventWithInstance=function(a){this._extendEventWithCursor(a);var b=this._hitTest(a);if(b){a.instance=b.instance;a.hitPoint=b.point;}else{a.instance=null;}};
var o=3;k={onkeydown:function(a){if(!a.originalEvent.repeat){this._handleKeyPress(a);}},oncontextmenu:function(a){this._extendEventWithInstance(a);if(this._skipClick){this._skipClick=false;this._handleHover(a);}else{this._handleContextMenu(a);}},onmousedown:function(a){if(this._hoverTimeOutId){clearTimeout(this._hoverTimeOutId);this._hoverTimeOutId=null;}this._mouseDown=true;this._extendEventWithCursor(a);j.trace("mousedown","x: "+a.cursor.x+", y: "+a.cursor.y,t);this._lastXY.x=a.cursor.x;this._lastXY.y=a.cursor.y;},onmouseup:function(a){this._mouseDown=false;},onhover:function(a){if(this._mouseDown){this._extendEventWithCursor(a);j.trace("hover","x: "+a.cursor.x+", y: "+a.cursor.y,t);if(Math.abs(this._lastXY.x-a.cursor.x)>o||Math.abs(this._lastXY.y-a.cursor.y)>o){this._skipClick=true;}}else{this._extendEventWithInstance(a);this._handleHover(a);}},onmouseout:function(a){this._extendEventWithInstance(a);delete a.instance;this._handleHover(a);},onBeforeRendering:function(a){if(this._onhoverProxy){this._viewport.$().off(sap.ui.Device.browser.msie||sap.ui.Device.browser.edge?"pointermove":"mousemove",this._onhoverProxy);}if(this._onpointerdownProxy){this._viewport.$().off("pointerdown",this._onpointerdownProxy);}if(this._onpointerupProxy){this._viewport.$().off("pointerup",this._onpointerupProxy);}},onAfterRendering:function(a){if(!this._onhoverProxy){this._onhoverProxy=k.onhover.bind(this);}this._viewport.$().on(sap.ui.Device.browser.msie||sap.ui.Device.browser.edge?"pointermove":"mousemove",this._onhoverProxy);if(sap.ui.Device.browser.msie||sap.ui.Device.browser.edge){if(!this._onpointerdownProxy){this._onpointerdownProxy=k.onmousedown.bind(this);}this._viewport.$().on("pointerdown",this._onpointerdownProxy);if(!this._onpointerupProxy){this._onpointerupProxy=k.onmouseup.bind(this);}this._viewport.$().on("pointerup",this._onpointerupProxy);}if(this._detail.anchor){this._viewport.getDomRef().appendChild(this._detail.anchor);}this._openDetailPending();}};k[sap.ui.Device.browser.msie||sap.ui.Device.browser.edge?"onclick":"ontap"]=function(a){j.trace("onclick","",t);this._extendEventWithInstance(a);if(this._skipClick){this._skipClick=false;this._handleHover(a);}else if(this._clickTimerId){clearTimeout(this._clickTimerId);this._clickTimerId=null;this._handleDoubleClick(a);}else{this._clickTimerId=setTimeout(function(){this._clickTimerId=null;this._handleClick(a);}.bind(this),200);}};var r=sap.ui.Device.os.macintosh?"metaKey":"ctrlKey";
A.prototype._extendEventWithSelection=function(a){var i=a.instance;if(i){if(a.originalEvent.type==="click"){if(!(a[r]&&a.shiftKey)){var b;var g;if(a[r]){b="toggle";g=false;}else if(a.shiftKey){b="select";g=false;}else{b="select";g=true;}a.selectionChanges=this._changeSelection(i,b,g);}}else{a.selectionChanges=this._changeSelection(i,"toggle",false);}}};
A.prototype._changeSelection=function(i,a,b){var s=[];var g=[];var m=i.voGroup;var w=U.toBoolean(i["VB:s"]);var p;if(a==="select"){if(m.maxSel!=="0"){if(w){if(b){p=m.selected.indexOf(i);g=m.selected.splice(p+1).concat(m.selected.splice(0,p));}}else{if(b||m.maxSel==="1"){g=m.selected.splice(0);}m.selected.push(i);s=[i];}}}else if(a==="toggle"){if(w){if(m.minSel==="0"||m.selected.length>1){p=m.selected.indexOf(i);g=m.selected.splice(p,1);}}else if(m.maxSel!=="0"){if(m.maxSel==="1"){g=m.selected.splice(0);}m.selected.push(i);s=[i];}}s.forEach(function(i){i["VB:s"]="true";});g.forEach(function(i){i["VB:s"]="false";});return{selected:s,deselected:g};};
return A;});
sap.ui.predefine('sap/ui/vbm/AnalyticMap',['sap/ui/core/theming/Parameters','./GeoMap','./library','./VoBase'],function(P,G,l,V){"use strict";
var A=G.extend("sap.ui.vbm.AnalyticMap",{metadata:{library:"sap.ui.vbm",properties:{},aggregations:{regions:{type:"sap.ui.vbm.Region",multiple:true,singularName:"region"}},events:{regionClick:{parameters:{code:{type:"string"}}},regionContextMenu:{parameters:{code:{type:"string"}}},regionSelect:{},regionDeselect:{}}}});
A.DefaultABAPGeoJSONURL="/sap/bc/vbi/geojson/L0.json";A.DefaultGeoJSONURL="media/analyticmap/L0.json";A.DefaultRegionColor=(P&&P.get("_sap_ui_vbm_shared_ChoroplethRegionBG"))?P.get("_sap_ui_vbm_shared_ChoroplethRegionBG"):"rgb(213,218,221)";A.DefaultRegionColorBorder=(P&&P.get("_sap_ui_vbm_shared_ChoroplethRegionBorder"))?P.get("_sap_ui_vbm_shared_ChoroplethRegionBorder"):"rgb(255,255,255)";A.DefaultRegionSelectColor="RHLSA(0;1;1;1)";A.DefaultHotDeltaColor="RHLSA(0;1;1;1.0)";A.AltBorderColor=(P&&P.get("_sap_ui_vbm_shared_ChartDataPointBorderHoverSelectedColor"))?P.get("_sap_ui_vbm_shared_ChartDataPointBorderHoverSelectedColor"):"#676767";var n=(P&&P.get("_sap_ui_vbm_shared_ChartDataPointNotSelectedBackgroundOpacity")?P.get("_sap_ui_vbm_shared_ChartDataPointNotSelectedBackgroundOpacity"):"0.6");A.DefaultRegionNonSelectColor="RHLSA(0;1;1;"+n+")";
A.prototype.exit=function(){G.prototype.exit.apply(this,arguments);this.detachEvent('submit',A.prototype.onAnalyticsSubmit,this);};
A.prototype.onAfterRendering=function(){sap.ui.vbm.VBI.prototype.onAfterRendering.apply(this,arguments);};
A.prototype.destroyRegions=function(){this.mbRegionsDirty=true;this.destroyAggregation("regions");};
A.prototype.addRegion=function(o){this.mbRegionsDirty=true;this.addAggregation("regions",o);};
A.prototype.removeRegion=function(o){this.mbRegionsDirty=true;this.removeAggregation("regions",o);};
A.prototype.insertRegion=function(o,i){this.mbRegionsDirty=true;this.insertAggregation("regions",o,i);};
A.prototype.removeAllRegions=function(){this.mbRegionsDirty=true;this.removeAllAggregation("regions");};
A.prototype.destroyLegend=function(){this.mbLegendDirty=true;this.destroyAggregation("legend");};
A.prototype.setLegend=function(o){this.mbLegendDirty=true;this.setAggregation("legend",o);};
A.prototype.onAnalyticsSubmit=function(e){var d=JSON.parse(e.mParameters.data);var c,o,p;switch(d.Action.name){case"RGN_CONTEXTMENU":c=d.Action.instance.split(".")[1];p={code:c};if((o=this.findRegionInAggregation(c))){o.fireContextMenu(p);}this.fireRegionContextMenu(p);break;case"RGN_CLICK":c=d.Action.instance.split(".")[1];p={code:c};if((o=this.findRegionInAggregation(c))){o.fireClick(p);}this.fireRegionClick(p);if(d.Data&&d.Data.Merge){this.setSelectionPropFireSelect(d.Data.Merge);}break;default:break;}};
A.prototype.init=function(){this.mProperties.scaleVisible=false;G.prototype.init.apply(this,arguments);this.mbRegionsDirty=false;this.mbLegendDirty=false;this.mbThemingDirty=true;this.attachEvent('submit',A.prototype.onAnalyticsSubmit,this);this.createRegions();};
A.prototype.createRegions=function(){var c=this.mColC=A.DefaultRegionColor;var a=this.mColCB=A.DefaultRegionColorBorder;function _(K,L,M,N,O,Q,R){var S={};S.K=K;S.P=[];S.T=Q;S.C=N;S.CB=O;S.HDC=A.DefaultHotDeltaColor;S.ACB=S.CB;S.G=R;S.S="false";var T,U,W;for(var F=0,X=L.length;F<X;++F){U=L[F];W=[];for(var q=0,Y=U.length;q<Y;++q){T="";for(var H=0,Z=U[q].length;H<Z;++H){if(H){(T+=";");}T+=U[q][H];}W.push(T);}S.P.push(W);}return S;}var d=null,p=[],r,s="";p[0]=A.GeoJSONURL;var u=window.URI(A.DefaultABAPGeoJSONURL);u.addQuery("sap-language",sap.ui.getCore().getConfiguration().getLanguage());p[1]=u.toString();p[2]=sap.ui.resource("sap.ui.vbm",A.DefaultGeoJSONURL);for(var i=0;i<3;++i){s=p[i];if(!d&&s){r=jQuery.sap.syncGetJSON(s);if(r.statusCode===200&&r.data&&!r.error){d=r.data;break;}}}if(!d){jQuery.sap.log.error("The GeoJSON file at location "+s+" is invalid or could not be parsed.\r\nPlease contact your Administrator.");return;}var E=[];this.mRegionApplicationTable=E;this.mRegionBox=[];this.mNames=[];this.mRegionProps=[];var m,b,e,g;var h=d.features,t='',v;var j;var k;var o;for(var q=0,w=h.length;q<w;++q){v=[];k=[];o=[];j=[];var f=h[q];if(f.id2==="AQ"){continue;}if(!f.id2){f.id2=f.id;}t=(f.properties&&f.properties.name)?f.properties.name:"";this.mNames[f.id2]=t;this.mRegionProps[f.id2]=f.properties;var z=f.geometry.coordinates;var B,x,y,C,D;var F,H;switch(f.geometry.type){case"Polygon":e=Number.MAX_VALUE;g=-Number.MAX_VALUE;m=Number.MAX_VALUE;b=-Number.MAX_VALUE;D=z.length;for(F=0;F<D;++F){B=z[F];v=[];for(H=0;H<B.length;++H){C=B[H];if(!F){if((x=C[0])<m){m=x;}if(x>b){b=x;}if((y=C[1])<e){e=y;}if(y>g){g=y;}}v.push(C[0],C[1],"0");}o.push(v);}k.push(o);j.push([m,b,e,g]);break;case"MultiPolygon":for(var I=0,J=z.length;I<J;++I){e=Number.MAX_VALUE;g=-Number.MAX_VALUE;m=Number.MAX_VALUE;b=-Number.MAX_VALUE;o=[];D=z[I].length;for(F=0;F<D;++F){B=z[I][F];v=[];for(H=0;H<B.length;++H){C=B[H];if(!F){if((x=C[0])<m){m=x;}if(x>b){b=x;}if((y=C[1])<e){e=y;}if(y>g){g=y;}}v.push(C[0],C[1],"0");}o.push(v);}j.push([m,b,e,g]);k.push(o);}break;default:continue;}E.push(_(f.id2,k,f.geometry.type,c,a,t,f.id2));this.mRegionBox[f.id2]=window.VBI.MathLib.GetSurroundingBox(j);}};
A.prototype.getRegionsTemplateObject=function(){return{"id":"Region","type":"{00100000-2012-0004-B001-F311DE491C77}","entity.bind":"Regions.Entity","datasource":"Regions","posarraymulti.bind":"Regions.PosList","color.bind":"Regions.Color","selectColor":A.DefaultRegionSelectColor,"nonSelectColor":A.DefaultRegionNonSelectColor,"colorBorder.bind":"Regions.BorderColor","tooltip.bind":"Regions.ToolTip","hotDeltaColor.bind":"Regions.HotDeltaColor","altBorderDeltaColor.bind":"Regions.AltBorderColor","select.bind":"Regions.VB:s","labelText.bind":"Regions.LT","labelPos.bind":"Regions.LP","labelBgColor.bind":"Regions.LBC","labelBorderColor.bind":"Regions.LBBC","labelArrow.bind":"Regions.AR","labelType.bind":"Regions.LabelType"};};
A.prototype.getRegionsTypeObject=function(){var a=[{"name":"Key","alias":"K","type":"string"},{"name":"PosList","alias":"P","type":"vectorarraymulti"},{"name":"ToolTip","alias":"T","type":"string"},{"name":"Color","alias":"C","type":"color"},{"name":"BorderColor","alias":"CB","type":"color"},{"name":"HotDeltaColor","alias":"HDC","type":"string"},{"name":"AltBorderColor","alias":"ACB","type":"color"},{"name":"Entity","alias":"G","type":"string"},{"name":"VB:s","alias":"S","type":"boolean"},{"name":"LT","alias":"LT","type":"string"},{"name":"LP","alias":"LP","type":"string"},{"name":"LBC","alias":"LBC","type":"color"},{"name":"LBBC","alias":"LBBC","type":"color"},{"name":"AR","alias":"AR","type":"boolean"},{"name":"LabelType","alias":"LabelType","type":"string"}];return{"name":"Regions","minSel":"0","maxSel":"-1","key":"Key","A":a};};
A.prototype.getRegionsDataObjects=function(){var e=[];var E=[];var a=[];var b=[];jQuery.extend(true,e,this.mRegionApplicationTable);if(!e.length){return null;}var r=this.getRegionMap();for(var c=0,d=e.length,R,i,t;c<d;++c){i=e[c];if((R=r[i.K])){i.HDC="RHLSA(0;1.0;1.0;0.4)";i.ACB=A.AltBorderColor;if((t=R.getColor())){i.C=(this.getPlugin())?window.VBI.Utilities.String2VBColor(t):t;}if((t=R.getTooltip())){i.T=t;}i.LT=R.getLabelText();i.S=R.getSelect();i.LP="0";i.LBC=R.getLabelBgColor();i.LBBC=R.getLabelBorderColor();i.AR=R.getLabelArrow();var f=R.getLabelType();var o=V.prototype.getLabelProps(f);if(o&&i.LT){if(o.LBC){i.LBC=o.LBC;}if(o.LBBC){i.LBBC=o.LBBC;}if(o.LIC){i.LIC=o.LIC;}if(o.LICC){i.LICC=o.LICC;}if(o.LICTC){i.LICTC=o.LICTC;}}if(!i.LBC){i.LBC="rgba(255,255,255,1.0)";}if(i.LBBC==""){i.LBBC=i.LBC;}E.push(i);}else{a.push(i);}}b=a.concat(E);return{"name":"Regions","type":"N","E":b};};
A.prototype.addRegionsActions=function(a){a.push({"id":"AMap1","name":"RGN_CLICK","refScene":"MainScene","refVO":"Region","refEvent":"Click"});a.push({"id":"AMap2","name":"RGN_CONTEXTMENU","refScene":"MainScene","refVO":"Region","refEvent":"ContextMenu"});return a;};
A.prototype.findSelected=function(s,d){var c=this.getRegions();if(!c){return null;}var S=[];if(jQuery.type(d)=='object'){if(d.S==(s?"true":"false")){for(var a=0;a<c.length;++a){if(c[a].sId==d.K){S.push(c[a]);}}}}else if(jQuery.type(d)=='array'){for(var b=0;b<d.length;++b){if(d[b].S==(s?"true":"false")){for(var e=0;e<c.length;++e){if(c[e].mProperties.code===d[b].K){S.push(c[e]);}}}}}return S;};
A.prototype.setSelectionPropFireSelect=function(d){var g={};g.N=[];var N=d.N;for(var a=0;a<N.length;++a){var o=N[a];var e=o.E;var c,C;var b=false;if(o.name=="Regions"){c=[];C=[];var r=this.getRegionMap();for(var f=0;f<e.length;++f){var E=e[f];var h=(E.S=="true"?true:false);var R=r[E.K];if(R){var m=R.getSelect();if(h!=m){R.setProperty("select",h,true);if(h&&this.mEventRegistry["regionSelect"]){c.push(R);}else if(!h&&this.mEventRegistry["regionDeselect"]){C.push(R);}}}else{b=true;}}if(C.length){this.fireRegionDeselect({deselected:C});}if(c.length){this.fireRegionSelect({selected:c});}if(b){this.invalidate();this.mbForceDataUpdate=true;}}else{g.N.push(o);}}if(g.N.length){G.prototype.setSelectionPropFireSelect.call(this,g);}};
A.prototype.getSelectedItems=function(d){var s=[];if(!d){return null;}for(var a=0;a<d.length;++a){if(d[a].name==="Regions"){var r=this.findSelected(true,d[a].E);if(r&&r.length){s=s.concat(r);}}else{var c=this.getAggregatorContainer(d[a].name);var C=c.findSelected(true,d[a].E);if(C&&C.length){s=s.concat(C);}}}return s;};
A.prototype.findRegionInAggregation=function(c){var C=this.getRegions();if(C){for(var a=0,b=C.length;a<b;++a){if(C[a].mProperties.code===c){return C[a];}}}return null;};
A.prototype.updateVOData=function(s,a,b,c,d){if(this.mbThemingDirty){this.applyTheming(this.mRegionApplicationTable);}s.push(this.getRegionsTemplateObject());c.push(this.getRegionsTypeObject());b.push({name:"Regions",type:"N"});a.push(this.getRegionsDataObjects());G.prototype.updateVOData.apply(this,arguments);this.addRegionsActions(d);};
A.prototype.resetDirtyStates=function(){G.prototype.resetDirtyStates.apply(this,arguments);this.mbRegionsDirty=false;};
A.prototype.minimizeApp=function(a){G.prototype.minimizeApp.apply(this,arguments);var t,r;if(!this.getMapConfiguration()){(t=a)&&(t=t.SAPVB)&&(t=t.Scenes)&&((r=t.Set)||(r=t.Merge))&&(t=r.SceneGeo)&&(t.refMapLayerStack)&&(t.refMapLayerStack="");}return a;};
A.prototype.invalidate=function(s){if(s instanceof sap.ui.vbm.Region){this.mbRegionsDirty=true;}G.prototype.invalidate.apply(this,arguments);};
A.prototype.getRegionMap=function(){var r={};var c=this.getRegions();for(var a=0,b=c?c.length:0,i;a<b;++a){i=c[a];r[i.getCode()]=i;}return r;};
A.prototype.zoomToRegions=function(c,C){if(C==undefined){C=0.9999;}var a=[];for(var b=0,d=c.length;b<d;++b){var r=this.mRegionBox[c[b]];if(r!=undefined){a.push(r);}}if(!a.length){return;}var s=null;if((s=this.mVBIContext.GetMainScene())){s.ZoomToAreas(a,C);}};
A.prototype.getRegionsInfo=function(c){var r=[];for(var a=0,b=c.length,d;a<b;++a){d=c[a];r[d]={};r[d].BBox=this.mRegionBox[d];r[d].Midpoint=[(this.mRegionBox[d][0]+this.mRegionBox[d][1])/2,(this.mRegionBox[d][2]+this.mRegionBox[d][3])/2];r[d].Name=this.mNames[d];r[d].Properties=this.mRegionProps[d];}return r;};
A.prototype.onThemeChanged=function(e){this.mbThemingDirty=true;this.invalidate();};
A.prototype.applyTheming=function(r){if(sap.ui.core.theming&&P){var c=A.DefaultRegionColor;if(P.get("_sap_ui_vbm_shared_ChoroplethRegionBG")!=undefined){c=A.DefaultRegionColor=P.get("_sap_ui_vbm_shared_ChoroplethRegionBG");}var C=A.DefaultRegionColorBorder;if(P.get("_sap_ui_vbm_shared_ChoroplethRegionBorder")!=undefined){C=A.DefaultRegionColorBorder=P.get("_sap_ui_vbm_shared_ChoroplethRegionBorder");}if(this.getPlugin()){c=window.VBI.Utilities.String2VBColor(c);C=window.VBI.Utilities.String2VBColor(C);}if(c!=this.mColC||C!=this.mColCB){for(var i=0;i<r.length;++i){if(r[i].C===this.mColC){r[i].C=c;}if(r[i].CB===this.mColCB){r[i].CB=C;}}this.mColC=c;this.mColCB=C;}this.mbThemingDirty=false;}};
A.prototype.isRegionSubscribed=function(e,r){if(r){var i=this.findRegionInAggregation(r);return i&&i.hasListeners(e);}return false;};
return A;});
sap.ui.predefine('sap/ui/vbm/AnalyticMapRenderer',['./GeoMapRenderer'],function(G){"use strict";var A={};
A.render=function(r,c){c.addStyleClass("sapUiVbmAnalyticMap");G.render(r,c);};
return A;},true);
sap.ui.predefine('sap/ui/vbm/Area',['./VoBase','./library'],function(V,l){"use strict";
var A=V.extend("sap.ui.vbm.Area",{metadata:{library:"sap.ui.vbm",properties:{position:{type:"string",group:"Misc",defaultValue:null},color:{type:"string",group:"Misc",defaultValue:null},colorBorder:{type:"string",group:"Misc"},borderDash:{type:"string",group:"Misc"}},events:{edgeClick:{edge:{type:"int"}},edgeContextMenu:{edge:{type:"int"}}}}});
A.prototype.openDetailWindow=function(c,o,O){this.oParent.openDetailWindow(this,{caption:c,offsetX:o,offsetY:O},true);};
A.prototype.openContextMenu=function(m){this.oParent.openContextMenu("Area",this,m);};
A.prototype.getDataElement=function(){var e=V.prototype.getDataElement.apply(this,arguments);var b=this.oParent.mBindInfo;if(b.C){e.C=this.getColor();}if(b.CB){var c=this.getColorBorder();if(c!=undefined&&c!=""){e.CB=c;}}if(b.BD){var a=this.getBorderDash();if(a!=undefined&&a!=""){e.BD=a;}}var p=this.getPosition();if(p.substring(0,1)==="["){p=p.replace(/\'/g,"\"");e.PM=JSON.parse(p);}else{e.P=p;}return e;};
A.prototype.handleChangedData=function(e){if(e.P){this.setPosition(e.P);}if(e.PM){jQuery.sap.log.error("sap.ui.vbm.Area: Change of areas with multiple parts not supported");}};
return A;});
sap.ui.predefine('sap/ui/vbm/Areas',['./VoAggregation','./library'],function(V,l){"use strict";
var A=V.extend("sap.ui.vbm.Areas",{metadata:{library:"sap.ui.vbm",properties:{posChangeable:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.vbm.Area",multiple:true,singularName:"item"}},events:{edgeClick:{parameters:{instance:{type:"sap.ui.vbm.Area"},edge:{type:"int"}}},edgeContextMenu:{parameters:{instance:{type:"sap.ui.vbm.Area"},edge:{type:"int"}}}}}});
A.prototype.getBindInfo=function(){var b=V.prototype.getBindInfo.apply(this,arguments);var t=this.getTemplateBindingInfo();b.C=(t)?t.hasOwnProperty("color"):true;b.CB=(t)?t.hasOwnProperty("colorBorder"):true;b.BD=(t)?t.hasOwnProperty("borderDash"):true;return b;};
A.prototype.getTemplateObject=function(){var t=V.prototype.getTemplateObject.apply(this,arguments);var b=this.mBindInfo=this.getBindInfo();var v=(b.hasTemplate)?this.getBindingInfo("items").template:null;t["type"]="{00100000-2012-0004-B001-F311DE491C77}";if(b.C){t["color.bind"]=t.id+".C";}else{t.color=v.getColor();}if(b.CB){t["colorBorder.bind"]=t.id+".CB";}else{t.colorBorder=v.getColorBorder();}if(b.BD){t["borderDash.bind"]=t.id+".BD";}else{t.borderDash=v.getBorderDash();}var a=this.getItems();if(a.length){if(a[0].getPosition().substring(0,1)==="["){t["posarraymulti.bind"]=t.id+".PM";}else{t["posarray.bind"]=t.id+".P";}}else{jQuery.sap.log.warning("sap.ui.vbm.Areas: items aggregation must not be empty!");}return t;};
A.prototype.getTypeObject=function(){var t=V.prototype.getTypeObject.apply(this,arguments);var b=this.mBindInfo;var p=this.getPosChangeable().toString();t.A=t.A.concat([{"changeable":p,"name":"P","alias":"P","type":"vectorarray"},{"changeable":p,"name":"PM","alias":"PM","type":"vectorarraymulti"}]);if(b.C){t.A.push({"name":"C","alias":"C","type":"color"});}if(b.CB){t.A.push({"name":"CB","alias":"CB","type":"string"});}if(b.BD){t.A.push({"name":"BD","alias":"BD","type":"string"});}return t;};
A.prototype.getActionArray=function(){var a=V.prototype.getActionArray.apply(this,arguments);var i=this.getId();if(this.mEventRegistry["click"]||this.isEventRegistered("click")){a.push({"id":i+"1","name":"click","refScene":"MainScene","refVO":i,"refEvent":"Click","AddActionProperty":[{"name":"pos"}]});}if(this.mEventRegistry["contextMenu"]||this.isEventRegistered("contextMenu")){a.push({"id":i+"2","name":"contextMenu","refScene":"MainScene","refVO":i,"refEvent":"ContextMenu"});}if(this.mEventRegistry["drop"]||this.isEventRegistered("drop")){a.push({"id":i+"3","name":"drop","refScene":"MainScene","refVO":i,"refEvent":"Drop"});}if(this.mEventRegistry["edgeClick"]||this.isEventRegistered("edgeClick")){a.push({"id":i+"7","name":"edgeClick","refScene":"MainScene","refVO":i,"refEvent":"EdgeClick"});}if(this.mEventRegistry["edgeContextMenu"]||this.isEventRegistered("edgeContextMenu")){a.push({"id":i+"8","name":"edgeContextMenu","refScene":"MainScene","refVO":i,"refEvent":"EdgeContextMenu"});}return a;};
A.prototype.handleEvent=function(e){var s=e.Action.name;if(s=="edgeContextMenu"||s=="edgeClick"){var f="fire"+s[0].toUpperCase()+s.slice(1);var a;if((a=this.findInstance(e.Action.instance))){var b={data:e,edge:parseInt(e.Action.Params.Param['2']['#'],10)};if(s=="edgeContextMenu"){a.mClickPos=[e.Action.Params.Param[0]['#'],e.Action.Params.Param[1]['#']];sap.ui.getCore().loadLibrary("sap.ui.unified");if(this.oParent.mVBIContext.m_Menus){this.oParent.mVBIContext.m_Menus.deleteMenu("DynContextMenu");}var m=new sap.ui.unified.Menu();m.vbi_data={};m.vbi_data.menuRef="CTM";m.vbi_data.VBIName="DynContextMenu";b.menu=m;}if(a.mEventRegistry[s]){a[f](b);}if(this.mEventRegistry[s]){b.instance=a;this[f](b);}}else{jQuery.sap.log.error("Instance for event not found");}}else{V.prototype.handleEvent.apply(this,arguments);}};
return A;});
sap.ui.predefine('sap/ui/vbm/Box',['./VoBase','./library'],function(V,l){"use strict";
var B=V.extend("sap.ui.vbm.Box",{metadata:{library:"sap.ui.vbm",properties:{position:{type:"string",group:"Misc",defaultValue:'0;0;0'},scale:{type:"string",group:"Misc",defaultValue:'1;1;1'},color:{type:"string",group:"Misc",defaultValue:'RGB(255;0;0)'},colorBorder:{type:"string",group:"Misc",defaultValue:'RGB(255;0;0)'}},events:{}}});
B.prototype.openDetailWindow=function(c,o,O){this.oParent.openDetailWindow(this,{caption:c,offsetX:o,offsetY:O},true);};
B.prototype.openContextMenu=function(m){this.oParent.openContextMenu("Box",this,m);};
B.prototype.getDataElement=function(){var e=V.prototype.getDataElement.apply(this,arguments);var b=this.oParent.mBindInfo;if(b.P){e.P=this.getPosition();}if(b.S){e.S=this.getScale();}if(b.C){e.C=this.getColor();}if(b.CB){e.CB=this.getColorBorder();}return e;};
B.prototype.handleChangedData=function(e){if(e.P){this.setPosition(e.P);}if(e.S){this.setScale(e.S);}};
return B;});
sap.ui.predefine('sap/ui/vbm/Boxes',['./VoAggregation','./library'],function(V,l){"use strict";
var B=V.extend("sap.ui.vbm.Boxes",{metadata:{library:"sap.ui.vbm",properties:{posChangeable:{type:"boolean",group:"Misc",defaultValue:true},scaleChangeable:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.vbm.Box",multiple:true,singularName:"item"}},events:{}}});
B.prototype.getBindInfo=function(){var b=V.prototype.getBindInfo.apply(this,arguments);var t=this.getTemplateBindingInfo();b.C=(t)?t.hasOwnProperty("color"):true;b.CB=(t)?t.hasOwnProperty("colorBorder"):true;b.P=(t)?t.hasOwnProperty("position"):true;b.S=(t)?t.hasOwnProperty("scale"):true;return b;};
B.prototype.getTemplateObject=function(){var t=V.prototype.getTemplateObject.apply(this,arguments);var b=this.mBindInfo=this.getBindInfo();var v=(b.hasTemplate)?this.getBindingInfo("items").template:null;t["type"]="{00100000-2012-0004-B001-BFED458C3076}";if(b.P){t["pos.bind"]=t.id+".P";}else{t.pos=v.getPosition();}if(b.S){t["scale.bind"]=t.id+".S";}else{t.scale=v.getScale();}if(b.C){t["color.bind"]=t.id+".C";}else{t.color=v.getColor();}if(b.CB){t["colorBorder.bind"]=t.id+".CB";}else{t.colorBorder=v.getColorBorder();}return t;};
B.prototype.getTypeObject=function(){var t=V.prototype.getTypeObject.apply(this,arguments);var b=this.mBindInfo;if(b.P){t.A.push({"changeable":this.getPosChangeable().toString(),"name":"P","alias":"P","type":"vector"});}if(b.S){t.A.push({"changeable":this.getScaleChangeable().toString(),"name":"S","alias":"S","type":"vector"});}if(b.C){t.A.push({"name":"C","alias":"C","type":"color"});}if(b.CB){t.A.push({"name":"CB","alias":"CB","type":"color"});}return t;};
B.prototype.getActionArray=function(){var a=V.prototype.getActionArray.apply(this,arguments);var i=this.getId();if(this.mEventRegistry["click"]||this.isEventRegistered("click")){a.push({"id":i+"1","name":"click","refScene":"MainScene","refVO":i,"refEvent":"Click","AddActionProperty":[{"name":"pos"}]});}if(this.mEventRegistry["contextMenu"]||this.isEventRegistered("contextMenu")){a.push({"id":i+"2","name":"contextMenu","refScene":"MainScene","refVO":i,"refEvent":"ContextMenu"});}if(this.mEventRegistry["drop"]||this.isEventRegistered("drop")){a.push({"id":i+"3","name":"drop","refScene":"MainScene","refVO":i,"refEvent":"Drop"});}return a;};
return B;});
sap.ui.predefine('sap/ui/vbm/Circle',['./VoBase','./library'],function(V,l){"use strict";
var C=V.extend("sap.ui.vbm.Circle",{metadata:{library:"sap.ui.vbm",properties:{position:{type:"string",group:"Misc",defaultValue:'0;0;0'},radius:{type:"string",group:"Misc",defaultValue:'20'},color:{type:"string",group:"Misc",defaultValue:'RGBA(0,0,128,128)'},colorBorder:{type:"string",group:"Misc",defaultValue:'RGB(0,0,0)'},slices:{type:"string",group:"Misc",defaultValue:null}},events:{}}});
C.prototype.openContextMenu=function(m){this.oParent.openContextMenu("Circle",this,m);};
C.prototype.getDataElement=function(){var e=V.prototype.getDataElement.apply(this,arguments);var b=this.oParent.mBindInfo;if(b.P){e.P=this.getPosition();}if(b.R){e.R=this.getRadius();}if(b.C){e.C=this.getColor();}if(b.CB){e.CB=this.getColorBorder();}if(b.NS){e.NS=this.getSlices();}return e;};
C.prototype.handleChangedData=function(e){if(e.P){this.setPosition(e.P);}if(e.R){this.setRadius(e.R);}};
return C;});
sap.ui.predefine('sap/ui/vbm/Circles',['./VoAggregation','./library'],function(V,l){"use strict";
var C=V.extend("sap.ui.vbm.Circles",{metadata:{library:"sap.ui.vbm",properties:{posChangeable:{type:"boolean",group:"Misc",defaultValue:true},radiusChangeable:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.vbm.Circle",multiple:true,singularName:"item"}},events:{}}});
C.prototype.getBindInfo=function(){var b=V.prototype.getBindInfo.apply(this,arguments);var t=this.getTemplateBindingInfo();b.C=(t)?t.hasOwnProperty("color"):true;b.CB=(t)?t.hasOwnProperty("colorBorder"):true;b.P=(t)?t.hasOwnProperty("position"):true;b.NS=(t)?t.hasOwnProperty("slices"):true;b.R=(t)?t.hasOwnProperty("radius"):true;return b;};
C.prototype.getTemplateObject=function(){var t=V.prototype.getTemplateObject.apply(this,arguments);var b=this.mBindInfo=this.getBindInfo();var v=(b.hasTemplate)?this.getBindingInfo("items").template:null;t["type"]="{00100000-2013-0004-B001-7EB3CCC039C4}";if(b.P){t["pos.bind"]=t.id+".P";}else{t.pos=v.getPosition();}if(b.NS){t["slices.bind"]=t.id+".NS";}else{t.slices=v.getSlices();}if(b.C){t["color.bind"]=t.id+".C";}else{t.color=v.getColor();}if(b.CB){t["colorBorder.bind"]=t.id+".CB";}else{t.colorBorder=v.getColorBorder();}if(b.R){t["radius.bind"]=t.id+".R";}else{t.radius=v.getRadius();}return t;};
C.prototype.getTypeObject=function(){var t=V.prototype.getTypeObject.apply(this,arguments);var b=this.mBindInfo;if(b.P){t.A.push({"changeable":this.getPosChangeable().toString(),"name":"P","alias":"P","type":"vector"});}if(b.R){t.A.push({"changeable":this.getRadiusChangeable().toString(),"name":"R","alias":"R","type":"double"});}if(b.C){t.A.push({"name":"C","alias":"C","type":"color"});}if(b.CB){t.A.push({"name":"CB","alias":"CB","type":"color"});}if(b.NS){t.A.push({"name":"NS","alias":"NS","type":"long"});}return t;};
C.prototype.getActionArray=function(){var a=V.prototype.getActionArray.apply(this,arguments);var i=this.getId();if(this.mEventRegistry["click"]||this.isEventRegistered("click")){a.push({"id":i+"1","name":"click","refScene":"MainScene","refVO":i,"refEvent":"Click","AddActionProperty":[{"name":"pos"}]});}if(this.mEventRegistry["contextMenu"]||this.isEventRegistered("contextMenu")){a.push({"id":i+"2","name":"contextMenu","refScene":"MainScene","refVO":i,"refEvent":"ContextMenu"});}if(this.mEventRegistry["drop"]||this.isEventRegistered("drop")){a.push({"id":i+"3","name":"drop","refScene":"MainScene","refVO":i,"refEvent":"Drop"});}return a;};
return C;});
sap.ui.predefine('sap/ui/vbm/Cluster',['jquery.sap.global','./library','sap/ui/core/Control'],function(q,l,C){"use strict";
var b=C.extend("sap.ui.vbm.Cluster",{metadata:{library:"sap.ui.vbm",properties:{color:{type:"sap.ui.core.CSSColor",group:"Misc",defaultValue:null},icon:{type:"string",group:"Misc",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:null},type:{type:"sap.ui.vbm.SemanticType",group:"Behavior",defaultValue:sap.ui.vbm.SemanticType.None}}}});
b.prototype.exit=function(){};
b.prototype.init=function(){};
b.prototype.onAfterRendering=function(){if(this.$oldContent.length>0){this.$().append(this.$oldContent);}if(this.getColor()&&(this.getType()===sap.ui.vbm.SemanticType.None)){var a=this.getId()+"-"+"backgroundcircle",i=a+"-"+"innercircle";var c=document.getElementById(a),d=document.getElementById(i);var e=q(c).css("border-bottom-color");var r=this.string2rgba(e);r="rgba("+r[0]+","+r[1]+","+r[2]+","+0.5+")";c.style.borderColor=r;d.style.borderColor=r;}};
b.prototype.onBeforeRendering=function(){this.$oldContent=sap.ui.core.RenderManager.findPreservedContent(this.getId());};
b.prototype.string2rgba=function(a){var c;if((c=/^rgb\(([\d]+)[,;]\s*([\d]+)[,;]\s*([\d]+)\)/.exec(a))){return[+c[1],+c[2],+c[3],1.0,0];}else{return[94,105,110];}};
return b;});
sap.ui.predefine('sap/ui/vbm/ClusterBase',['sap/ui/core/Element','./library','sap/ui/core/theming/Parameters','./ClusterContainer'],function(E,l,P,C){"use strict";
var a=E.extend("sap.ui.vbm.ClusterBase",{metadata:{library:"sap.ui.vbm",properties:{areaAlwaysVisible:{type:"boolean",group:"Appearance",defaultValue:false},areaColor:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:"rgba(200,0,0,0.2)"},areaColorBorder:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:"rgba(220,220,220,0.5)"},textProperty:{type:"string",group:"Misc",defaultValue:"text"},textSettings:{type:"object",group:"Appearance"},rule:{type:"string",group:"Misc",defaultValue:null}},defaultAggregation:"vizTemplate",aggregations:{vizTemplate:{type:"sap.ui.core.Control",multiple:false},vizVo:{type:"sap.ui.vbm.Spot",multiple:false},clusterVos:{type:"sap.ui.core.Control",multiple:true,visiblity:"hidden",singularName:"clusterVo"},clusterContainers:{type:"sap.ui.vbm.ClusterContainer",multiple:true,visiblity:"hidden",singularName:"clusterContainer"}},events:{click:{parameters:{clusterID:{type:"string"}}},contextMenu:{parameters:{clusterID:{type:"string"},menu:{type:"sap.ui.unified.Menu"}}}}}});
a.prototype.openDetailWindow=function(s,p){var o=this.getParent();o.mDTWindowCxt.bUseClickPos=true;o.mDTWindowCxt.open=true;o.mDTWindowCxt.src=s;o.mDTWindowCxt.key=s.getKey();o.mDTWindowCxt.params=p;o.m_bWindowsDirty=true;o.invalidate();};
a.prototype.openContextMenu=function(t,c,m){this.oParent.openContextMenu(t,c,m);};
a.prototype.init=function(){this.mVizObjMap={};this.mContObjMap={};var d=P.get("sapUiFontFamily");this.setProperty("textSettings",{textcolor:"#000000",textfont:(d)?d:"Arial, Helvetica, sans-serif",textfontsize:"10"},true);};
a.prototype.exit=function(){this.mVizObjMap=null;this.mContObjMap=null;if(this.oSpotAggr){this.oSpotAggr.destroy();this.oSpotAggr=null;}};
a.prototype.setTextSettings=function(s){var n=this.getTextSettings();jQuery.extend(n,s);return this.setProperty("textSettings",n);};
a.prototype.getTemplateObject=function(){var t={};var i=this.getId();if(this.getVizTemplate()){t={id:i,type:"{00100000-2012-0004-B001-2297943F0CE6}",datasource:i};}else if(this.getVizVo()){this.oSpotAggr=new sap.ui.vbm.Spots({items:{path:"/",template:this.getVizVo()}});t=this.oSpotAggr.getTemplateObject();t.id=i;}else{jQuery.sap.log.error("No visualization object given for cluster");}return t;};
a.prototype.getActionArray=function(){if(this.oSpotAggr){var A=this.oSpotAggr.getActionArray(true);for(var i=0;i<A.length;++i){A[i].refVO=this.getId();}return A;}else{return[];}};
a.prototype.getClusterDefinition=function(){return jQuery.extend(this.getTextSettings(),{id:this.getId(),VO:this.getId(),rule:this.getRule(),areapermanent:this.getAreaAlwaysVisible().toString(),areabordersize:"2",areafillcol:this.getAreaColor(),areabordercol:this.getAreaColorBorder()});};
a.prototype.handleContainerCreated=function(e){var c=e.mParameters.id;var i=this._getVizObjInst(c);if(i){var n=this.getParent().getInfoForCluster(c,sap.ui.vbm.ClusterInfoType.NodeInfo);if(!i.getBindingInfo("text")){i.setProperty(this.getTextProperty(),n.cnt.toString(),true);}if(!this.oDOMHandler){this.oDOMHander=new a._DOMHandler(this);}var d=e.getParameter("contentarea");d.addEventListener("click",this.oDOMHander);d.addEventListener("contextmenu",this.oDOMHander);d.addEventListener("touchstart",this.oDOMHander);d.addEventListener("touchend",this.oDOMHander);d.addEventListener("touchcancel",this.oDOMHander);var p;if((p=this.getParent())){var b=d.id;p.addRenderItem(i,b);}}};
a.prototype.handleContainerDestroyed=function(e){var d=e.getParameter("contentarea");d.removeEventListener("click",this.oDOMHander);d.removeEventListener("contextmenu",this.oDOMHander);d.removeEventListener("touchstart",this.oDOMHander);d.removeEventListener("touchend",this.oDOMHander);d.removeEventListener("touchcancel",this.oDOMHander);this._removeVizObjInst(e.mParameters.id);};
a.prototype.handleEvent=function(e){var n=e.Action.name;var f="fire"+n[0].toUpperCase()+n.slice(1);var v;if((v=this.getVizVo())){var b={data:e};var c=this.getParent().getInfoForCluster(e.Action.instance,sap.ui.vbm.ClusterInfoType.NodeInfo);v.setProperty("key",e.Action.instance,true);v.setProperty("position",c.pos[0]+";"+c.pos[1]+";0",true);switch(n){case"click":v.mClickGeoPos=e.Action.AddActionProperties.AddActionProperty[0]['#'];break;case"contextMenu":v.mClickPos=[e.Action.Params.Param[0]['#'],e.Action.Params.Param[1]['#']];sap.ui.getCore().loadLibrary("sap.ui.unified");if(this.oParent.mVBIContext.m_Menus){this.oParent.mVBIContext.m_Menus.deleteMenu("DynContextMenu");}var m=new sap.ui.unified.Menu();m.vbi_data={};m.vbi_data.menuRef="CTM";m.vbi_data.VBIName="DynContextMenu";b.menu=m;break;case"drop":var s=e.Action.Params.Param[0]['#'].split("|");var d=s[1];var i=s[2].split(".")[1];var D=this.getParent().getAggregatorContainer(d).findInstanceByKey(i);b.oDragSource=D;break;default:break;}v[f](b);b.instance=v;this[f](b);}else{jQuery.sap.log.error("Instance for event not found");}};
a.prototype.findInstance=function(k){if(this.oSpotAggr){return this.getVizVo();}else{return this._getContainer(k);}};
a.prototype._getVizObjInst=function(k){var r=this.mVizObjMap[k];if(!r){var v=this.getVizTemplate();if(v){r=this.mVizObjMap[k]=v.clone();r.mClusterId=k;this.addAggregation("clusterVos",r,true);}}return r;};
a.prototype._removeVizObjInst=function(k){var r=this.mVizObjMap[k];if(r){this.removeAggregation("clusterVos",r,true);this.mVizObjMap[k]=null;}};
a.prototype._getContainer=function(k){var r=this.mContObjMap[k];if(!r){r=this.mContObjMap[k]=new C({key:k});if(!this.oSpotAggr){r.setItem(this._getVizObjInst(k));}this.addAggregation("clusterContainers",r,true);}return r;};
a.prototype._removeContainer=function(k){var r=this.mContObjMap[k];if(r){this.removeAggregation("clusterContainers",r,true);this.mContObjMap[k]=null;}};
a.prototype._handleDOMEvent=function(e){var c=e.currentTarget.m_Key;var o=this.parent._getContainer(c);switch(e.type){case"click":this.parent.fireClick({instance:o,event:e});break;case"contextmenu":this.parent._onContextMenu(e,o);break;case"touchstart":o.touch=true;o.touchTime=Date.now();break;case"touchend":if(o.touch){o.touch=false;var t=(Date.now()-o.touchTime)/1000;if(t<1.0){this.parent.fireClick({instance:o,event:e});}else{this.parent._onContextMenu(e,o);}}break;case"touch cancel":o.touch=false;break;default:break;}};
a.prototype._onContextMenu=function(o,c){var b={};var m=this.oParent.getDomRef();c.mClickPos=[o.clientX-m.offsetLeft,o.clientY-m.offsetTop];sap.ui.getCore().loadLibrary("sap.ui.unified");try{if(this.oParent.mVBIContext.m_Menus){this.oParent.mVBIContext.m_Menus.deleteMenu("DynContextMenu");}var M=new sap.ui.unified.Menu();M.vbi_data={};M.vbi_data.menuRef="CTM";M.vbi_data.VBIName="DynContextMenu";b.menu=M;o.preventDefault();b.instance=c;b.event=o;this.fireContextMenu(b);}catch(e){}};
a._DOMHandler=function(p){this.parent=p;this.handleEvent=p._handleDOMEvent;return this;};
return a;});
sap.ui.predefine('sap/ui/vbm/ClusterContainer',['./Container','./library'],function(C,l){"use strict";
var a=C.extend("sap.ui.vbm.ClusterContainer",{metadata:{library:"sap.ui.vbm",properties:{},aggregations:{},events:{}}});
a.prototype.init=function(){this._oItem=null;};
a.prototype.getPosition=function(){var m=this.getParent().getParent();var n=m.getInfoForCluster(this.getKey(),sap.ui.vbm.ClusterInfoType.NodeInfo);return n.pos[0]+";"+n.pos[1]+";0";};
a.prototype.setPosition=function(){};
a.prototype.getAlignment=function(){return 0;};
a.prototype.setAlignment=function(){};
a.prototype.getItem=function(){return this._oItem;};
a.prototype.setItem=function(c){this._oItem=c;return this;};
a.prototype.getDataElement=function(){};
a.prototype.handleChangedData=function(e){};
return a;});
sap.ui.predefine('sap/ui/vbm/ClusterDistance',['./ClusterBase','./library'],function(C,l){"use strict";
var a=C.extend("sap.ui.vbm.ClusterDistance",{metadata:{library:"sap.ui.vbm",properties:{distance:{type:"int",group:"Behaviour",defaultValue:"128"}},aggregations:{},events:{}}});
a.prototype.getClusterDefinition=function(){var d=C.prototype.getClusterDefinition.apply(this,arguments);d.type="distance";d.distance=this.getDistance().toString();return d;};
return a;});
sap.ui.predefine('sap/ui/vbm/ClusterGrid',['./ClusterBase','./library'],function(C,l){"use strict";
var a=C.extend("sap.ui.vbm.ClusterGrid",{metadata:{library:"sap.ui.vbm",properties:{gridSize:{type:"string",group:"Behaviour",defaultValue:"256;256"},limit:{type:"int",group:"Behaviour",defaultValue:2},limitTotal:{type:"int",group:"Behaviour",defaultValue:2},orderIndex:{type:"int",group:"Behaviour",defaultValue:null},offset:{type:"string",group:"Appearance",defaultValue:"0;0"},cellSpacing:{type:"int",group:"Appearance",defaultValue:"4"}},aggregations:{},events:{}}});
a.prototype.getClusterDefinition=function(){var d=C.prototype.getClusterDefinition.apply(this,arguments);d.type="grid";d.limit=this.getLimit().toString();d.limitOnSum=this.getLimitTotal().toString();d.order=this.getOrderIndex().toString();d.areabordersize=-this.getCellSpacing().toString();var g=this.getGridSize().split(";");d.distanceX=g[0];d.distanceY=g[1];var o=this.getOffset().split(";");d.offsetX=o[0];d.offsetY=o[1];return d;};
return a;});
sap.ui.predefine('sap/ui/vbm/ClusterRenderer',function(){"use strict";var C={};
C.render=function(r,c){r.write("<div align='center'");r.writeControlData(c);r.addClass("sapUiVbicluster-main");r.writeClasses(c);r.writeStyles();r.write(">");var I=c.getId()+"-"+"backgroundcircle";var a=I+"-"+"innercircle";var b=c.getColor();var t=c.getType();sap.ui.core.IconPool.insertFontFaceStyle();var i=c.getIcon();var d,e;if(i){e=sap.ui.core.IconPool.getIconInfo(i);}else if(t==sap.ui.vbm.SemanticType.Error){e=sap.ui.core.IconPool.getIconInfo("status-negative");}else if(t==sap.ui.vbm.SemanticType.Warning){e=sap.ui.core.IconPool.getIconInfo("status-critical");}else if(t==sap.ui.vbm.SemanticType.Success){e=sap.ui.core.IconPool.getIconInfo("status-positive");}else{e=sap.ui.core.IconPool.getIconInfo("status-inactive");}if(e){d=e.content;}var f,g,h,j;if(t==sap.ui.vbm.SemanticType.Error){f="class = 'sapUiVbicluster-backgroundcircle sapUiVbicluster-border-error'";g="class = 'sapUiVbicluster-innercircle sapUiVbicluster-background-error'";j="class = 'sapUiVbicluster-icon sapUiVbicluster-iconLight'";h="class = 'sapUiVbicluster-textbox sapUiVbicluster-textbox-error'";}else if(t==sap.ui.vbm.SemanticType.Warning){f="class = 'sapUiVbicluster-backgroundcircle sapUiVbicluster-border-warning'";g="class = 'sapUiVbicluster-innercircle sapUiVbicluster-background-warning'";j="class = 'sapUiVbicluster-icon sapUiVbicluster-iconLight'";h="class = 'sapUiVbicluster-textbox sapUiVbicluster-textbox-warning'";}else if(t==sap.ui.vbm.SemanticType.Success){f="class = 'sapUiVbicluster-backgroundcircle sapUiVbicluster-border-success'";g="class = 'sapUiVbicluster-innercircle sapUiVbicluster-background-success sapUiVbicluster-inner-light'";j="class = 'sapUiVbicluster-icon sapUiVbicluster-iconSuccess'";h="class = 'sapUiVbicluster-textbox sapUiVbicluster-textbox-success'";}else if(t==sap.ui.vbm.SemanticType.None&&b){f="class = 'sapUiVbicluster-backgroundcircle' style = 'border-color: "+b+"'";g="class = 'sapUiVbicluster-innercircle sapUiVbicluster-inner-light' style = 'border-color: "+b+"'";j="class = 'sapUiVbicluster-icon' style = 'color: "+b+"'";h="class = 'sapUiVbicluster-textbox' style = 'border-color: "+b+"'";}else{f="class = 'sapUiVbicluster-backgroundcircle sapUiVbicluster-border-default'";g="class = 'sapUiVbicluster-innercircle sapUiVbicluster-background-default sapUiVbicluster-inner-light'";j="class = 'sapUiVbicluster-icon sapUiVbicluster-iconDefault'";h="class = 'sapUiVbicluster-textbox sapUiVbicluster-textbox-default'";}r.write("<div id= "+I+" "+f+">");r.write("<div id= "+a+" "+g+">");if(d){var k=c.getId()+"-"+"icon";r.write("<span id= "+k+" "+j+">");r.writeEscaped(d);r.write("</span>");}r.write("</div>");if((c.getText())){var l=c.getId()+"-"+"textbox";r.write("<div id= "+l+" "+h+">");r.write("<div>");r.writeEscaped(c.getText());r.write("</div>");r.write("</div>");}r.write("</div>");r.write("</div>");};
return C;},true);
sap.ui.predefine('sap/ui/vbm/ClusterTree',['./ClusterBase','./library'],function(C,l){"use strict";
var a=C.extend("sap.ui.vbm.ClusterTree",{metadata:{library:"sap.ui.vbm",properties:{animateClusterSplit:{type:"boolean",group:"Behaviour",defaultValue:true}},aggregations:{},events:{}}});
a.prototype.getClusterDefinition=function(){var d=C.prototype.getClusterDefinition.apply(this,arguments);d.type="tree";d.animation=this.getAnimateClusterSplit().toString();return d;};
return a;});
sap.ui.predefine('sap/ui/vbm/Container',['./VoBase','./library'],function(V,l){"use strict";
var C=V.extend("sap.ui.vbm.Container",{metadata:{library:"sap.ui.vbm",properties:{position:{type:"string",group:"Misc",defaultValue:null},alignment:{type:"string",group:"Misc",defaultValue:'0'}},aggregations:{item:{type:"sap.ui.core.Control",multiple:false}},events:{}}});
C.prototype.openContextMenu=function(m){this.getParent().openContextMenu("Container",this,m);};
C.prototype.getDataElement=function(){var e=V.prototype.getDataElement.apply(this,arguments);var b=this.oParent.mBindInfo;e.IK=this.getUniqueId();if(b.P){e.P=this.getPosition();}if(b.AL){e.AL=this.getAlignment();}return e;};
C.prototype.handleChangedData=function(e){if(e.P){this.setPosition(e.P);}};
return C;});
sap.ui.predefine('sap/ui/vbm/Containers',['./VoAggregation','./library'],function(V,l){"use strict";
var C=V.extend("sap.ui.vbm.Containers",{metadata:{library:"sap.ui.vbm",defaultAggregation:"items",aggregations:{items:{type:"sap.ui.vbm.Container",multiple:true,singularName:"item"}},events:{}}});
C.prototype.getBindInfo=function(){var b=V.prototype.getBindInfo.apply(this,arguments);var t=this.getTemplateBindingInfo();b.P=(t)?t.hasOwnProperty("position"):true;b.AL=(t)?t.hasOwnProperty("alignment"):true;return b;};
C.prototype.getTemplateObject=function(){var t=V.prototype.getTemplateObject.apply(this,arguments);var b=this.mBindInfo=this.getBindInfo();var v=(b.hasTemplate)?this.getBindingInfo("items").template:null;t["type"]="{00100000-2012-0004-B001-2297943F0CE6}";t["key.bind"]=t.id+".IK";if(b.P){t["pos.bind"]=t.id+".P";}else{t.pos=v.getPosition();}if(b.AL){t["alignment.bind"]=t.id+".AL";}else{t.alignment=v.getAlignment();}return t;};
C.prototype.getTypeObject=function(){var t=V.prototype.getTypeObject.apply(this,arguments);var b=this.mBindInfo;t.A.push({"name":"IK","alias":"IK","type":"key"});if(b.P){t.A.push({"changeable":"true","name":"P","alias":"P","type":"vector"});}if(b.AL){t.A.push({"name":"AL","alias":"AL","type":"string"});}return t;};
C.prototype.getActionArray=function(){var a=V.prototype.getActionArray.apply(this,arguments);var i=this.getId();if(this.mEventRegistry["click"]||this.isEventRegistered("click")){a.push({"id":i+"1","name":"click","refScene":"MainScene","refVO":i,"refEvent":"Click","AddActionProperty":[{"name":"pos"}]});}if(this.mEventRegistry["contextMenu"]||this.isEventRegistered("contextMenu")){a.push({"id":i+"2","name":"contextMenu","refScene":"MainScene","refVO":i,"refEvent":"ContextMenu"});}return a;};
C.prototype.handleContainerCreated=function(e){var c=this.findInstance(e.mParameters.id);var i=c.getItem();if(i){var d=e.getParameter("contentarea");d.addEventListener("click",this,false);d.addEventListener("contextmenu",this,false);var p;if((p=this.getParent())){var a=d.id;p.addRenderItem(i,a);}}};
C.prototype.handleContainerDestroyed=function(e){var d=e.getParameter("contentarea");d.removeEventListener("click",this,false);d.removeEventListener("contextmenu",this,false);};
C.prototype.findInstance=function(k){var v=this.getItems();if(!v){return false;}for(var n=0,a=this.aUniqueIdx.length;n<a;++n){if(this.aUniqueIdx[n]===k){return v[n];}}return null;};
C.prototype.handleEvent=function(E){var c=E.currentTarget.m_Key;var o=this.findInstance(c);switch(E.type){case"click":o.fireClick();this.fireClick({instance:o});break;case"contextmenu":var a={};var m=this.oParent.getDomRef().getBoundingClientRect();o.mClickPos=[E.clientX-m.left,E.clientY-m.top];sap.ui.getCore().loadLibrary("sap.ui.unified");try{if(this.oParent.mVBIContext.m_Menus){this.oParent.mVBIContext.m_Menus.deleteMenu("DynContextMenu");}var M=new sap.ui.unified.Menu();M.vbi_data={};M.vbi_data.menuRef="CTM";M.vbi_data.VBIName="DynContextMenu";a.menu=M;E.preventDefault();o.fireContextMenu(a);a.instance=o;this.fireContextMenu(a);}catch(e){}break;}};
return C;});
sap.ui.predefine('sap/ui/vbm/DragSource',['sap/ui/core/Element','./library'],function(E,l){"use strict";
var D=E.extend("sap.ui.vbm.DragSource",{metadata:{library:"sap.ui.vbm",properties:{type:{type:"string",group:"Misc",defaultValue:null}}}});
return D;});
sap.ui.predefine('sap/ui/vbm/DropTarget',['sap/ui/core/Element','./library'],function(E,l){"use strict";
var D=E.extend("sap.ui.vbm.DropTarget",{metadata:{library:"sap.ui.vbm",properties:{type:{type:"string",group:"Misc",defaultValue:null}}}});
return D;});
sap.ui.predefine('sap/ui/vbm/Feature',['sap/ui/core/Element','./library'],function(E,l){"use strict";
var F=E.extend("sap.ui.vbm.Feature",{metadata:{library:"sap.ui.vbm",properties:{color:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:null},featureId:{type:"string",group:"Misc",defaultValue:null}},events:{click:{},contextMenu:{parameters:{menu:{type:"sap.ui.unified.Menu"}}}}}});
F.prototype.openDetailWindow=function(c,o,O){this.oParent.openDetailWindow(this,{caption:c,offsetX:o,offsetY:O});};
F.prototype.openContextMenu=function(m){this.oParent.openContextMenu(this,m);};
F.prototype.handleChangedData=function(e){};
return F;});
sap.ui.predefine('sap/ui/vbm/FeatureCollection',['sap/ui/core/theming/Parameters','./GeoJsonLayer','./library'],function(P,G,l){"use strict";
var F=G.extend("sap.ui.vbm.FeatureCollection",{metadata:{library:"sap.ui.vbm",properties:{},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.vbm.Feature",multiple:true,singularName:"item"}},events:{click:{parameters:{featureId:{type:"string"}}},contextMenu:{parameters:{featureId:{type:"string"}}}}}});
F.prototype.getDataObjects=function(){if(this.mbGeoJSONDirty){this._triggerFeatureCreation();}var e=[],p=[],L=[],a=[];jQuery.extend(e,this.mFeatureColl);var o={};if(e.length){var O=this.getItems();for(var n=0,b=O?O.length:0,i;n<b;++n){i=O[n];o[i.getFeatureId()]=i;}}for(var c=0,E,d,t;c<e.length;++c){E=e[c];if((d=o[E.K])){var C={};jQuery.extend(C,E);E=e[c]=C;E.C=d.getColor();if((t=d.getTooltip())){E.TT=t;}}switch(E.type){case"Polygon":case"MultiPolygon":p.push(E);break;case"LineString":case"MultiLineString":L.push(E);break;case"Point":case"MultiPoint":a.push(E);break;default:jQuery.sap.log.error("FeatureCollection: Unknown feature type: "+E.type);}}return[{"name":this.getId()+"_Polys","type":"N","E":p},{"name":this.getId()+"_Lines","type":"N","E":L},{"name":this.getId()+"_Points","type":"N","E":a}];};
F.prototype.getDataRemoveObjects=function(){return[{"name":this.getId()+"_Polys","type":"N"},{"name":this.getId()+"_Lines","type":"N"},{"name":this.getId()+"_Points","type":"N"}];};
F.prototype.getFeaturesInfo=function(f){var r=[];for(var n=0,a=f.length,b;n<a;++n){b=f[n];r[b]={};r[b].BBox=this.mFeatureBBox[b];r[b].Midpoint=[(this.mFeatureBBox[b][0]+this.mFeatureBBox[b][1])/2,(this.mFeatureBBox[b][2]+this.mFeatureBBox[b][3])/2];r[b].Name=this.mNames[b];r[b].Properties=this.mFeatureProps[b];}return r;};
return F;});
sap.ui.predefine('sap/ui/vbm/GeoCircle',['./VoBase','./library'],function(V,l){"use strict";
var G=V.extend("sap.ui.vbm.GeoCircle",{metadata:{library:"sap.ui.vbm",properties:{position:{type:"string",group:"Misc",defaultValue:'0;0;0'},colorBorder:{type:"string",group:"Misc",defaultValue:'RGB(0,0,0)'},radius:{type:"string",group:"Misc",defaultValue:'10000'},color:{type:"string",group:"Misc",defaultValue:'RGB(0,0,0)'},slices:{type:"string",group:"Misc",defaultValue:'20'}},events:{}}});
G.prototype.openDetailWindow=function(c,o,O){this.oParent.openDetailWindow(this,{caption:c,offsetX:o,offsetY:O},true);};
G.prototype.openContextMenu=function(m){this.oParent.openContextMenu("GeoCircle",this,m);};
G.prototype.getDataElement=function(){var e=V.prototype.getDataElement.apply(this,arguments);var b=this.oParent.mBindInfo;if(b.P){e.P=this.getPosition();}if(b.R){e.R=this.getRadius();}if(b.C){e.C=this.getColor();}if(b.CB){e.CB=this.getColorBorder();}if(b.NS){e.NS=this.getSlices();}return e;};
G.prototype.handleChangedData=function(e){if(e.P){this.setPosition(e.P);}if(e.R){this.setRadius(e.R);}};
return G;});
sap.ui.predefine('sap/ui/vbm/GeoCircles',['./VoAggregation','./library'],function(V,l){"use strict";
var G=V.extend("sap.ui.vbm.GeoCircles",{metadata:{library:"sap.ui.vbm",properties:{posChangeable:{type:"boolean",group:"Misc",defaultValue:true},radiusChangeable:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.vbm.GeoCircle",multiple:true,singularName:"item"}},events:{}}});
G.prototype.getBindInfo=function(){var b=V.prototype.getBindInfo.apply(this,arguments);var t=this.getTemplateBindingInfo();b.C=(t)?t.hasOwnProperty("color"):true;b.CB=(t)?t.hasOwnProperty("colorBorder"):true;b.P=(t)?t.hasOwnProperty("position"):true;b.NS=(t)?t.hasOwnProperty("slices"):true;b.R=(t)?t.hasOwnProperty("radius"):true;return b;};
G.prototype.getTemplateObject=function(){var t=V.prototype.getTemplateObject.apply(this,arguments);var b=this.mBindInfo=this.getBindInfo();var v=(b.hasTemplate)?this.getBindingInfo("items").template:null;t["type"]="{00100000-2013-0004-B001-686F01B57873}";if(b.P){t["midpoint.bind"]=t.id+".P";}else{t.pos=v.getPosition();}if(b.NS){t["slices.bind"]=t.id+".NS";}else{t.slices=v.getSlices();}if(b.C){t["color.bind"]=t.id+".C";}else{t.color=v.getColor();}if(b.CB){t["colorBorder.bind"]=t.id+".CB";}else{t.colorBorder=v.getColorBorder();}if(b.R){t["radius.bind"]=t.id+".R";}else{t.radius=v.getRadius();}return t;};
G.prototype.getTypeObject=function(){var t=V.prototype.getTypeObject.apply(this,arguments);var b=this.mBindInfo;if(b.P){t.A.push({"changeable":this.getPosChangeable().toString(),"name":"P","alias":"P","type":"vector"});}if(b.R){t.A.push({"changeable":this.getRadiusChangeable().toString(),"name":"R","alias":"R","type":"double"});}if(b.C){t.A.push({"name":"C","alias":"C","type":"color"});}if(b.CB){t.A.push({"name":"CB","alias":"CB","type":"color"});}if(b.NS){t.A.push({"name":"NS","alias":"NS","type":"long"});}return t;};
G.prototype.getActionArray=function(){var a=V.prototype.getActionArray.apply(this,arguments);var i=this.getId();if(this.mEventRegistry["click"]||this.isEventRegistered("click")){a.push({"id":i+"1","name":"click","refScene":"MainScene","refVO":i,"refEvent":"Click","AddActionProperty":[{"name":"pos"}]});}if(this.mEventRegistry["contextMenu"]||this.isEventRegistered("contextMenu")){a.push({"id":i+"2","name":"contextMenu","refScene":"MainScene","refVO":i,"refEvent":"ContextMenu"});}if(this.mEventRegistry["drop"]||this.isEventRegistered("drop")){a.push({"id":i+"3","name":"drop","refScene":"MainScene","refVO":i,"refEvent":"Drop"});}return a;};
return G;});
sap.ui.predefine('sap/ui/vbm/GeoJsonLayer',['sap/ui/core/theming/Parameters','sap/ui/core/Element','./library'],function(P,E,l){"use strict";
var G=E.extend("sap.ui.vbm.GeoJsonLayer",{metadata:{library:"sap.ui.vbm",properties:{srcURL:{type:"string",defaultValue:null},data:{type:"object",defaultValue:null},defaultLineWidth:{type:"int",group:"Appearance",defaultValue:5},defaultFillColor:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:"rgba(186, 193, 196, 0.5)"},defaultBorderColor:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:"rgba(255, 255, 255, 1.0)"}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.vbm.Feature",multiple:true,singularName:"item"}},events:{click:{parameters:{featureId:{type:"string"}}},contextMenu:{parameters:{featureId:{type:"string"}}}}}});
G.prototype.init=function(){this.mbGeoJSONDirty=true;this.mbSrcLoadPending=false;this._aGeoJsonObjects=[];};
G.prototype.setSrcURL=function(s){this.mbGeoJSONDirty=true;return this.setProperty("srcURL",s);};
G.prototype.setData=function(d){this.mbGeoJSONDirty=true;this._aGeoJsonObjects=d;return this.setProperty("data",d);};
G.prototype.addData=function(d){this.mbGeoJSONDirty=true;if(jQuery.type(d)==="array"){this._aGeoJsonObjects=this._aGeoJsonObjects.concat(d);}else{this._aGeoJsonObjects.push(d);}this.setProperty("data",this._aGeoJsonObjects);this.getParent().invalidate(this);};
G.prototype._createFeatures=function(d){var a=this.getDefaultFillColor();var b=this.getDefaultBorderColor();var g=this._aGeoJsonObjects;if(d){g.push(d);}this.mFeatureColl=[];this.mFeatureBBox={};this.mNames={};this.mFeatureProps={};for(var n=0;n<g.length;++n){var e=g[n];switch(e.type){case"FeatureCollection":for(var c=0,f;c<e.features.length;++c){f=e.features[c];this._processType(f.id,f.geometry.type,f.geometry.coordinates,f.properties,a,b);}break;case"Feature":this._processType(e.id,e.geometry.type,e.geometry.coordinates,e.properties,a,b);break;case"GeometryCollection":for(var h=0,o;h<e.geometries.length;++h){o=e.geometries[h];this._processType(null,o.type,o.coordinates,null,a,b);}break;case"Polygon":case"MultiPolygon":case"LineString":case"MultiLineString":case"Point":case"MultiPoint":this._processType(null,e.type,e.coordinates,null,a,b);break;default:jQuery.sap.log.error("GeoJsonLayer: Unsupported GeoJSON object type "+g[n].type);continue;}}this.mbGeoJSONDirty=false;};
G.prototype._processType=function(i,t,c,p,f,b){var x,y,m=Number.MAX_VALUE,a=-Number.MAX_VALUE,d=Number.MAX_VALUE,e=-Number.MAX_VALUE;var g='',h;var C;var j;var n,k;var o=[];var q=[];var B=[];g=(p&&p.name)?p.name:"";this.mFeatureProps[i]=p;switch(t){case"Polygon":for(n=0;n<c.length;++n){j=c[n];C=[];for(k=0;k<j.length;++k){h=j[k];if(!n){if((x=h[0])<m){m=x;}if(x>a){a=x;}if((y=h[1])<d){d=y;}if(y>e){e=y;}}C.push(h[0],h[1],"0");}q.push(C);}o.push(q);B.push([m,a,d,e]);break;case"MultiPolygon":for(var r=0,s,u=c.length;r<u;++r){q=[];s=c[r].length;for(n=0;n<s;++n){j=c[r][n];C=[];for(k=0;k<j.length;++k){h=j[k];if(!n){if((x=h[0])<m){m=x;}if(x>a){a=x;}if((y=h[1])<d){d=y;}if(y>e){e=y;}}C.push(h[0],h[1],"0");}q.push(C);}o.push(q);B.push([m,a,d,e]);}break;case"LineString":C=[];for(n=0;n<c.length;++n){h=c[n];if((x=h[0])<m){m=x;}if(x>a){a=x;}if((y=h[1])<d){d=y;}if(y>e){e=y;}C.push(h[0],h[1],0);}q.push(C);o.push(q);B.push([m,a,d,e]);break;case"Point":d=e=c[1];m=a=c[0];C=[c[0],c[1],0];q.push(C);o.push(q);B.push([m,a,d,e]);break;default:jQuery.sap.log.error("GeoJsonLayer: Unsupported geometry type "+t);return;}this.mFeatureColl.push(this._createDataElement(i,o,t,f,b,g,i));this.mFeatureBBox[i]=window.VBI.MathLib.GetSurroundingBox(B);};
G.prototype._createDataElement=function(i,a,t,c,b,d,e){var f={K:i,P:[],TT:d,C:c,CB:b,type:t};f["VB:s"]=false;var n,g,h;var s,j,k,m,o;switch(t){case"Polygon":case"MultiPolygon":var p,q;o=a.length;for(h=0;h<o;++h){p=a[h];q=[];m=p.length;for(g=0;g<m;++g){s="";k=p[g].length;for(n=0;n<k;++n){if(n){(s+=";");}s+=p[g][n];}q.push(s);}f.P.push(q);}break;case"LineString":s="";j=a[0][0];k=j.length;for(n=0;n<k;++n){if(n){(s+=";");}s+=j[n];}f.P=s;break;case"Point":s="";j=a[0][0];k=j.length;for(n=0;n<k;++n){if(n){(s+=";");}s+=j[n];}f.P=s;break;}return f;};
G.prototype._triggerFeatureCreation=function(){var p=null;if((p=this.getSrcURL())){if(!this.mbSrcLoadPending){this.mbSrcLoadPending=true;jQuery.getJSON(p,function(d){this._createFeatures(d);this.mbSrcLoadPending=false;var o;if((o=this.getParent())){o.invalidate();}}.bind(this)).fail(function(){jQuery.sap.log.error("GeoJsonLayer: The path or the GeoJSON file at location "+p+" is invalid.");});}}else{this._createFeatures(null);}};
G.prototype.getTemplateObjects=function(){var t,r=[];t={id:this.getId()+"_Polys",type:"{00100000-2012-0004-B001-F311DE491C77}",hotDeltaColor:"RHLSA(0;1;1;1.5)",altBorderDeltaColor:(P)?P.get("_sap_ui_vbm_shared_ChartDataPointBorderHoverSelectedColor"):"#666"};t.datasource=t.id;t['posarraymulti.bind']=t.id+".P";t['color.bind']=t.id+".C";t['colorBorder.bind']=t.id+".CB";t['tooltip.bind']=t.id+".TT";r.push(t);t={id:this.getId()+"_Lines",type:"{00100000-2012-0004-B001-C46BD7336A1A}",hotDeltaColor:"RHLSA(0;1;1;1.5)",altBorderDeltaColor:(P)?P.get("_sap_ui_vbm_shared_ChartDataPointBorderHoverSelectedColor"):"#666"};t.datasource=t.id;t['posarray.bind']=t.id+".P";t['color.bind']=t.id+".C";t['colorBorder.bind']=t.id+".CB";t['tooltip.bind']=t.id+".TT";r.push(t);t={id:this.getId()+"_Points",type:"{00100000-2012-0004-B001-64592B8DB964}",hotDeltaColor:"RHLSA(0;1;2;1)"};t.datasource=t.id;t['pos.bind']=t.id+".P";t['tooltip.bind']=t.id+".TT";r.push(t);return r;};
G.prototype.getTypeObjects=function(){var t={},r=[];var T={key:"K",minSel:"0",maxSel:"0",A:[{"name":"K","alias":"K","type":"string"},{"name":"C","alias":"C","type":"color"},{"name":"CB","alias":"CB","type":"string"},{"name":"TT","alias":"TT","type":"string"}]};jQuery.extend(true,t,T);t.name=this.getId()+"_Polys";t.A.push({"name":"P","alias":"P","type":"vectorarraymulti"});r.push(t);t={};jQuery.extend(true,t,T);t.name=this.getId()+"_Lines";t.A.push({"name":"P","alias":"P","type":"vectorarray"});r.push(t);t={};jQuery.extend(true,t,T);t.name=this.getId()+"_Points";t.A.push({"name":"P","alias":"P","type":"vector"});r.push(t);return r;};
G.prototype.getDataObjects=function(){if(this.mbGeoJSONDirty){this._triggerFeatureCreation();}var e=[],p=[],L=[],a=[];jQuery.extend(true,e,this.mFeatureColl);var o={};if(e.length){var O=this.getItems();for(var n=0,b=O?O.length:0,i;n<b;++n){i=O[n];o[i.getFeatureId()]=i;}}for(var c=0,d,f,t;c<e.length;++c){d=e[c];if((f=o[d.K])){d.C=f.getColor();if((t=f.getTooltip())){d.TT=t;}}switch(d.type){case"Polygon":case"MultiPolygon":p.push(d);break;case"LineString":case"MultiLineString":L.push(d);break;case"Point":case"MultiPoint":a.push(d);break;default:jQuery.sap.log.error("GeoJsonLayer: Unknown object type: "+d.type);}}return[{"name":this.getId()+"_Polys","type":"N","E":p},{"name":this.getId()+"_Lines","type":"N","E":L},{"name":this.getId()+"_Points","type":"N","E":a}];};
G.prototype.getDataRemoveObjects=function(){return[{"name":this.getId()+"_Polys","type":"N"},{"name":this.getId()+"_Lines","type":"N"},{"name":this.getId()+"_Points","type":"N"}];};
G.prototype.getActionArray=function(){var a=[];var i=this.getId();if(this.mEventRegistry["click"]||this.isEventRegistered("click")){a.push({"id":i+"Polys1","name":"click","refScene":"MainScene","refVO":i+"_Polys","refEvent":"Click","AddActionProperty":[{"name":"pos"}]});a.push({"id":i+"Lines1","name":"click","refScene":"MainScene","refVO":i+"_Lines","refEvent":"Click","AddActionProperty":[{"name":"pos"}]});a.push({"id":i+"Points1","name":"click","refScene":"MainScene","refVO":i+"_Points","refEvent":"Click","AddActionProperty":[{"name":"pos"}]});}if(this.mEventRegistry["contextMenu"]||this.isEventRegistered("contextMenu")){a.push({"id":i+"_Polys2","name":"contextMenu","refScene":"MainScene","refVO":i+"_Polys","refEvent":"ContextMenu"});a.push({"id":i+"_Lines2","name":"contextMenu","refScene":"MainScene","refVO":i+"_Lines","refEvent":"ContextMenu"});a.push({"id":i+"_Points2","name":"contextMenu","refScene":"MainScene","refVO":i+"_Points","refEvent":"ContextMenu"});}return a;};
G.prototype.getFeaturesInfo=function(f){var r=[];for(var n=0,a=f.length,b;n<a;++n){b=f[n];r[b]={};r[b].BBox=this.mFeatureBBox[b];r[b].Midpoint=[(this.mFeatureBBox[b][0]+this.mFeatureBBox[b][1])/2,(this.mFeatureBBox[b][2]+this.mFeatureBBox[b][3])/2];r[b].Name=this.mNames[b];r[b].Properties=this.mFeatureProps[b];}return r;};
G.prototype.handleEvent=function(e){var s=e.Action.name;var f="fire"+s[0].toUpperCase()+s.slice(1);var o,i=e.Action.instance;if((o=this.findInstance(i))){if(o.mEventRegistry[s]){if(s==="click"){o.mClickGeoPos=e.Action.AddActionProperties.AddActionProperty[0]['#'];}if(s==="contextMenu"){o.mClickPos=[e.Action.Params.Param[0]['#'],e.Action.Params.Param[1]['#']];sap.ui.getCore().loadLibrary("sap.ui.unified");if(this.oParent.mVBIContext.m_Menus){this.oParent.mVBIContext.m_Menus.deleteMenu("DynContextMenu");}var m=new sap.ui.unified.Menu();m.vbi_data={};m.vbi_data.menuRef="CTM";m.vbi_data.VBIName="DynContextMenu";o.fireContextMenu({menu:m});}else if(s==="handleMoved"){o[f]({data:e});}else{o[f]({});}}}if(this.mEventRegistry[s]){this[f]({featureId:i.split(".")[1]});}};
G.prototype.openDetailWindow=function(f,p){var o=this.getParent();o.mDTWindowCxt.bUseClickPos=true;o.mDTWindowCxt.open=true;o.mDTWindowCxt.src=f;o.mDTWindowCxt.key=f.getFeatureId();o.mDTWindowCxt.params=p;o.m_bWindowsDirty=true;o.invalidate(this);};
G.prototype.openContextMenu=function(f,m){this.oParent.openContextMenu("Area",f,m);};
G.prototype.handleChangedData=function(e){if(e&&e.length){for(var n=0,o,i;n<e.length;++n){o=e[n];i=(o.K)?this.findInstance(o.K):null;if(i){i.handleChangedData(o);}}}};
G.prototype.isEventRegistered=function(n){var o=this.getItems();if(!o){return false;}for(var a=0,b=o.length;a<b;++a){if(o[a].mEventRegistry[n]){return true;}}return false;};
G.prototype.findInstance=function(n){var o=this.getItems();if(!o){return null;}switch(jQuery.type(n)){case"string":var k=(n.indexOf(".")!==-1)?n.split(".")[1]:n;for(var a=0,b=o.length;a<b;++a){if(o[a].getFeatureId()===k){return o[a];}}break;case"number":break;default:jQuery.sap.log.error("GeoJsonLayer: Unextected instance name type "+jQuery.type(n));break;}return null;};
return G;});
sap.ui.predefine('sap/ui/vbm/GeoMapRenderer',['./VBIRenderer'],function(V){"use strict";var G={};
G.render=function(r,c){c.addStyleClass("sapUiVbmGeoMap");V.render(r,c);var a;if((a=c.update())){c.load(a);}};
return G;},true);
sap.ui.predefine('sap/ui/vbm/HeatPoint',['./VoBase','./library'],function(V,l){"use strict";
var H=V.extend("sap.ui.vbm.HeatPoint",{metadata:{library:"sap.ui.vbm",properties:{position:{type:"string",group:"Misc",defaultValue:null},value:{type:"string",group:"Misc",defaultValue:null},radius:{type:"string",group:"Misc",defaultValue:'5'}},events:{}}});
H.prototype.openDetailWindow=function(c,o,O){this.oParent.openDetailWindow(this,{caption:c,offsetX:o,offsetY:O},true);};
H.prototype.getDataElement=function(){var e=V.prototype.getDataElement.apply(this,arguments);var b=this.oParent.mBindInfo;if(b.P){e.P=this.getPosition();}if(b.V){e.V=this.getValue();}if(b.R){e.R=this.getRadius();}return e;};
H.prototype.handleChangedData=function(e){if(e.P){this.setPosition(e.P);}if(e.V){this.setScale(e.V);}if(e.R){this.setRadius(e.R);}};
H.prototype.getUniqueId=function(){return(this.getId());};
return H;});
sap.ui.predefine('sap/ui/vbm/Heatmap',['./VoAbstract','./library'],function(V,l){"use strict";
var H=V.extend("sap.ui.vbm.Heatmap",{metadata:{library:"sap.ui.vbm",properties:{gradient:{type:"array",group:"Misc",defaultValue:null},opacity:{type:"string",group:"Misc",defaultValue:'0.5'},behavior:{type:"string",group:"Misc",defaultValue:'2'},valueScale:{type:"string",group:"Misc",defaultValue:'1.0'},radiusScale:{type:"string",group:"Misc",defaultValue:'1.0'},alphaExponent:{type:"string",group:"Misc",defaultValue:'1.0'},colorExponent:{type:"string",group:"Misc",defaultValue:'1.0'}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.vbm.HeatPoint",multiple:true,singularName:"item"}},events:{}}});
H.prototype.getBindInfo=function(){var b=V.prototype.getBindInfo.apply(this,arguments);var t=this.getTemplateBindingInfo();b.P=(t)?t.hasOwnProperty("position"):true;b.V=(t)?t.hasOwnProperty("value"):true;b.R=(t)?t.hasOwnProperty("radius"):true;return b;};
H.prototype.getTemplateObject=function(){var t=V.prototype.getTemplateObject.apply(this,arguments);var b=this.mBindInfo=this.getBindInfo();var v=(b.hasTemplate)?this.getBindingInfo("items").template:null;t["type"]="{00100000-2012-0004-B001-E180770E8A12}";if(b.P){t["pos.bind"]=t.id+".P";}else{t.pos=v.getPosition();}if(b.R){t["radius.bind"]=t.id+".R";}else{t.radius=v.getRadius();}if(b.V){t["value.bind"]=t.id+".V";}else{t.value=v.getValue();}t.gradient=this.getGradient();t.opacity=this.getOpacity();t.behavior=this.getBehavior();t.radiusScale=this.getRadiusScale();t.valueScale=this.getValueScale();t.alphaExponent=this.getAlphaExponent();t.colorExponent=this.getColorExponent();return t;};
H.prototype.getTypeObject=function(){var t=V.prototype.getTypeObject.apply(this,arguments);var b=this.mBindInfo;if(b.P){t.A.push({"name":"P","alias":"P","type":"vector"});}if(b.V){t.A.push({"name":"V","alias":"V","type":"string"});}if(b.R){t.A.push({"name":"R","alias":"R","type":"string"});}return t;};
H.prototype.handleEvent=function(e){};
H.prototype.getActionArray=function(){var a=V.prototype.getActionArray.apply(this,arguments);return a;};
return H;});
sap.ui.predefine('sap/ui/vbm/Legend',['sap/ui/core/Element','./library'],function(E,l){"use strict";
var L=E.extend("sap.ui.vbm.Legend",{metadata:{library:"sap.ui.vbm",properties:{caption:{type:"string",group:"Misc",defaultValue:sap.ui.getCore().getLibraryResourceBundle("sap.ui.vbm.i18n").getText("CAPTION_LEGEND")}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.vbm.LegendItem",multiple:true,singularName:"item"}},events:{click:{parameters:{data:{type:"object"},row:{type:"int"},ctrlKey:{type:"boolean"},shiftKey:{type:"boolean"},metaKey:{type:"boolean"},altKey:{type:"boolean"}}}}}});
L.prototype.init=function(){};
L.prototype.getTemplateObject=function(){var i=this.getId();var w={};if(this.getParent().getLegendVisible()){w={"Set":[{"name":i,"Window":{"id":i,"type":"legend","caption":this.getCaption(),"refParent":"Main","refScene":"","modal":"true","datasource":i,"colors.bind":i+".C","images.bind":i+".I","texts.bind":i+".T","tooltips.bind":i+".TT"}}]};if(this.getParent().m_curLegendPos){w.Set[0].Window.right=this.getParent().m_curLegendPos.right.toString();w.Set[0].Window.top=this.getParent().m_curLegendPos.top.toString();}}else{w={"Remove":[{"name":i}]};}return w;};
L.prototype.getTypeObject=function(){return{"name":this.getId(),"A":[{"name":"C","alias":"C","type":"color"},{"name":"I","alias":"I","type":"string"},{"name":"T","alias":"T","type":"string"},{"name":"TT","alias":"TT","type":"string"}]};};
L.prototype.getDataObject=function(){var d={};d['name']=this.getId();d.E=[];var v=this.getItems();for(var n=0,a=v.length;n<a;++n){d.E.push(v[n].getDataElement());}return d;};
L.prototype.handleEvent=function(e){var s=e.Action.name;var f="fire"+s[0].toUpperCase()+s.slice(1);var p={data:e,ctrlKey:e.Action.Params.Param[1]['#'],shiftKey:e.Action.Params.Param[2]['#'],metaKey:e.Action.Params.Param[3]['#'],altKey:e.Action.Params.Param[4]['#']};var a;if((a=this.findInstance(e.Action.Params.Param[0]['#']))){if(a.mEventRegistry[s]){if(s=="click"){a[f](p);}}}p.row=parseInt(e.Action.Params.Param[0]['#'],10);this[f](p);};
L.prototype.getActionArray=function(){var i=this.getId();var a=[];if(this.mEventRegistry["click"]||this.isEventRegistered("click")){a.push({"id":i+"1","name":"click","refScene":"MainScene","refVO":i,"refEvent":"Click"});}return a;};
L.prototype.isEventRegistered=function(n){var v=this.getItems();if(!v){return false;}for(var a=0,b=v.length;a<b;++a){var i=v[a];if(i.mEventRegistry[n]){return true;}}return false;};
L.prototype.findInstance=function(k){var v=this.getItems();(v[0].sId).lastIndexOf('-');v=this.getItems();if(!v){return false;}for(var n=0,a=v.length;n<a;++n){var i=v[n].sId;var b=i.lastIndexOf('-');var r=i.substring(b+1);if(r===k){return v[n];}}return null;};
return L;});
sap.ui.predefine('sap/ui/vbm/LegendItem',['sap/ui/core/Element','./library'],function(E,l){"use strict";
var L=E.extend("sap.ui.vbm.LegendItem",{metadata:{library:"sap.ui.vbm",properties:{color:{type:"string",group:"Misc",defaultValue:''},image:{type:"string",group:"Misc",defaultValue:null},semanticSpotType:{type:"sap.ui.vbm.SemanticType",group:"Behavior",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:null}},events:{click:{parameters:{data:{type:"object"},ctrlKey:{type:"boolean"},shiftKey:{type:"boolean"},metaKey:{type:"boolean"},altKey:{type:"boolean"}}}}}});
L.prototype.getDataElement=function(){var e={};var c,i,t,a,b;if((c=this.getColor())){e.C=c;}if((i=this.getImage())){e.I=i;}if((t=this.getSemanticSpotType())){switch(t){case sap.ui.vbm.SemanticType.Hidden:e.I="Pin_Hidden.png";break;case sap.ui.vbm.SemanticType.Error:e.I="Pin_Red.png";break;case sap.ui.vbm.SemanticType.Warning:e.I="Pin_Orange.png";break;case sap.ui.vbm.SemanticType.Success:e.I="Pin_Green.png";break;case sap.ui.vbm.SemanticType.Inactive:e.I="Pin_Grey.png";break;case sap.ui.vbm.SemanticType.Default:e.I="Pin_Blue.png";break;default:break;}if(e.I){this.getParent().getParent().addResourceIfNeeded(e.I);}}if((a=this.getText())){e.T=a;}if((b=this.getTooltip())){e.TT=b;}return e;};
return L;});
sap.ui.predefine('sap/ui/vbm/Pie',['./VoBase','./library'],function(V,l){"use strict";
var P=V.extend("sap.ui.vbm.Pie",{metadata:{library:"sap.ui.vbm",properties:{position:{type:"string",group:"Misc",defaultValue:null},scale:{type:"string",group:"Misc",defaultValue:null}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.vbm.PieItem",multiple:true,singularName:"item"}},events:{}}});
P.prototype.openContextMenu=function(m){this.oParent.openContextMenu("Pie",this,m);};
P.prototype.getDataElement=function(){var s=[];var p=this.getItems();for(var n=0,a=p.length;n<a;++n){var i=p[n];s.push({"T":i.getName(),"V":i.getValue(),"C":i.getColor()});}var e=V.prototype.getDataElement.apply(this,arguments);var b=this.oParent.mBindInfo;if(b.P){e.P=this.getPosition();}if(b.S){e.S=this.getScale();}e.N={"name":"Series","E":s};return e;};
P.prototype.handleChangedData=function(e){if(e.P){this.setPosition(e.P);}if(e.S){this.setScale(e.S);}};
return P;});
sap.ui.predefine('sap/ui/vbm/PieItem',['sap/ui/core/Element','./library'],function(E,l){"use strict";
var P=E.extend("sap.ui.vbm.PieItem",{metadata:{library:"sap.ui.vbm",properties:{name:{type:"string",group:"Misc",defaultValue:''},value:{type:"string",group:"Misc",defaultValue:null},color:{type:"string",group:"Misc",defaultValue:null}},events:{click:{}}}});
return P;});
sap.ui.predefine('sap/ui/vbm/Pies',['./VoAggregation','./library'],function(V,l){"use strict";
var P=V.extend("sap.ui.vbm.Pies",{metadata:{library:"sap.ui.vbm",properties:{posChangeable:{type:"boolean",group:"Misc",defaultValue:true},scaleChangeable:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.vbm.Pie",multiple:true,singularName:"item"}},events:{}}});
P.prototype.getBindInfo=function(){var b=V.prototype.getBindInfo.apply(this,arguments);var t=this.getTemplateBindingInfo();b.P=(t)?t.hasOwnProperty("position"):true;b.S=(t)?t.hasOwnProperty("scale"):true;return b;};
P.prototype.getTemplateObject=function(){var t=V.prototype.getTemplateObject.apply(this,arguments);var b=this.mBindInfo=this.getBindInfo();var v=(b.hasTemplate)?this.getBindingInfo("items").template:null;t["type"]="{00100000-2012-0004-B001-383477EA1DEB}";if(b.P){t["pos.bind"]=t.id+".P";}else{t.pos=v.getPosition();}if(b.S){t["scale.bind"]=t.id+".S";}else{t.scale=v.getScale();}t["series.bind"]=t.id+".Series";t["text.bind"]=t.id+".Series.T";t["value.bind"]=t.id+".Series.V";t["slicecolor.bind"]=t.id+".Series.C";return t;};
P.prototype.getTypeObject=function(){var t=V.prototype.getTypeObject.apply(this,arguments);var b=this.mBindInfo;if(b.P){t.A.push({"changeable":this.getPosChangeable().toString(),"name":"P","alias":"P","type":"vector"});}if(b.S){t.A.push({"changeable":this.getScaleChangeable().toString(),"name":"S","alias":"S","type":"vector"});}t.N={"name":"Series","A":[{"name":"V","alias":"V","type":"float"},{"name":"T","alias":"T","type":"string"},{"name":"C","alias":"C","type":"string"}]};return t;};
P.prototype.getActionArray=function(){var a=V.prototype.getActionArray.apply(this,arguments);var i=this.getId();if(this.mEventRegistry["click"]||this.isEventRegistered("click")){a.push({"id":i+"1","name":"click","refScene":"MainScene","refVO":i,"refEvent":"Click","AddActionProperty":[{"name":"pos"},{"name":"pieitem"}]});}if(this.mEventRegistry["contextMenu"]||this.isEventRegistered("contextMenu")){a.push({"id":i+"2","name":"contextMenu","refScene":"MainScene","refVO":i,"refEvent":"ContextMenu","AddActionProperty":[{"name":"pieitem"}]});}if(this.mEventRegistry["drop"]||this.isEventRegistered("drop")){a.push({"id":i+"3","name":"drop","refScene":"MainScene","refVO":i,"refEvent":"Drop"});}return a;};
return P;});
sap.ui.predefine('sap/ui/vbm/Region',['sap/ui/core/Element','./library'],function(E,l){"use strict";
var R=E.extend("sap.ui.vbm.Region",{metadata:{library:"sap.ui.vbm",properties:{color:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:null},code:{type:"string",group:"Misc",defaultValue:null},select:{type:"boolean",group:"Misc",defaultValue:false},labelText:{type:"string",group:"Misc",defaultValue:null},labelType:{type:"sap.ui.vbm.SemanticType",group:"Behavior",defaultValue:sap.ui.vbm.SemanticType.None},labelBgColor:{type:"string",group:"Misc",defaultValue:'RGB(255;255;255)'},labelBorderColor:{type:"string",group:"Misc",defaultValue:null},labelArrow:{type:"boolean",group:"Misc",defaultValue:false}},events:{click:{parameters:{code:{type:"string"}}},contextMenu:{parameters:{code:{type:"string"}}}}}});
R.prototype.getInfo=function(){return this.getParent().getRegionsInfo([this.getCode()])[0];};
return R;});
sap.ui.predefine('sap/ui/vbm/Resource',['sap/ui/core/Element','./library'],function(E,l){"use strict";
var R=E.extend("sap.ui.vbm.Resource",{metadata:{library:"sap.ui.vbm",properties:{value:{type:"string",group:"Misc",defaultValue:null},src:{type:"string",group:"Misc",defaultValue:""},name:{type:"string",group:"Misc",defaultValue:null}}}});
return R;});
sap.ui.predefine('sap/ui/vbm/Route',['./VoBase','./library'],function(V,l){"use strict";
var R=V.extend("sap.ui.vbm.Route",{metadata:{library:"sap.ui.vbm",properties:{position:{type:"string",group:"Misc",defaultValue:null},color:{type:"string",group:"Misc",defaultValue:'RGB(0;0;0)'},start:{type:"string",group:"Misc",defaultValue:'0'},end:{type:"string",group:"Misc",defaultValue:'0'},linewidth:{type:"string",group:"Misc",defaultValue:'3'},dotcolor:{type:"string",group:"Misc",defaultValue:'RGB(0;0;0)'},dotbordercolor:{type:"string",group:"Misc",defaultValue:'RGB(0;0;0)'},colorBorder:{type:"string",group:"Misc"},lineDash:{type:"string",group:"Misc"},dotwidth:{type:"string",group:"Misc",defaultValue:'0'},routetype:{type:"sap.ui.vbm.RouteType",group:"Misc",defaultValue:'Straight'},directionIndicator:{type:"boolean",group:"Misc",defaultValue:false}},aggregations:{dragSource:{type:"sap.ui.vbm.DragSource",multiple:true,singularName:"dragSource"},dropTarget:{type:"sap.ui.vbm.DropTarget",multiple:true,singularName:"dropTarget"}},events:{}}});
R.prototype.openContextMenu=function(m){this.oParent.openContextMenu("Route",this,m);};
R.prototype.getDataElement=function(){var e=V.prototype.getDataElement.apply(this,arguments);var b=this.oParent.mBindInfo;if(b.P){if(this.getRoutetype()=='Geodesic'){var p=this.getPosition().split(";");var a=p.length;var g=p.slice(0,3);var c=p.slice(a-3,a);var r=this.calcGeodesicRoute(g,c);e.P=g[0]+';'+g[1]+';0.0;'+r+c[0]+';'+c[1]+';0.0';}else{e.P=this.getPosition();}}if(b.C){e.C=this.getColor();}if(b.ST){e.ST=this.getStart();}if(b.ED){e.ED=this.getEnd();}if(b.LW){e.LW=this.getLinewidth();}if(b.DC){e.DC=this.getDotcolor();}if(b.DBC){e.DBC=this.getDotbordercolor();}if(b.CB){var d=this.getColorBorder();if(d!=undefined&&d!=""){e.CB=d;}}if(b.LD){var f=this.getLineDash();if(f!=undefined&&f!=""){e.LD=f;}}if(b.DW){e.DW=this.getDotwidth();}if(b.DS||b.DT){e.N=this.getDragDropDefs();}if(b.DI){e.DI=this.getDirectionIndicator();}return e;};
R.prototype.handleChangedData=function(e){if(e.P){this.setPosition(e.P);}};
R.prototype.dot=function(a,b){var c=0;c=a[1]*b[1]+a[2]*b[2]+a[3]*b[3];return c;};
R.prototype.cross=function(a,b){var c=new Array(4);c[1]=a[2]*b[3]-a[3]*b[2];c[2]=a[3]*b[1]-a[1]*b[3];c[3]=a[1]*b[2]-a[2]*b[1];return c;};
R.prototype.radians=function(d){return d*Math.PI/180;};
R.prototype.degrees=function(r){return r*180/Math.PI;};
R.prototype.calcGeodesicRoute=function(g,a){var x=new Array(4);var b=new Array(4);var u=new Array(4);var c=new Array(4);var v=new Array(4);x[1]=Math.cos(this.radians(g[1]))*Math.cos(this.radians(g[0]));x[2]=Math.cos(this.radians(g[1]))*Math.sin(this.radians(g[0]));x[3]=Math.sin(this.radians(g[1]));b[1]=Math.cos(this.radians(a[1]))*Math.cos(this.radians(a[0]));b[2]=Math.cos(this.radians(a[1]))*Math.sin(this.radians(a[0]));b[3]=Math.sin(this.radians(a[1]));u=this.cross(x,b);var d=Math.sqrt(this.dot(u,u));c[1]=u[1]/d;c[2]=u[2]/d;c[3]=u[3]/d;v=this.cross(c,x);var f=new Array(101);var e=new Array(201);var i;for(i=0;i<=100;i++){f[i]=new Array(4);e[i]=new Array(4);}var h=Math.acos(this.dot(x,b));var r="";for(i=0;i<=100;i++){var t=i/100*h;f[i][0]=0;f[i][1]=Math.cos(t)*x[1]+Math.sin(t)*v[1];f[i][2]=Math.cos(t)*x[2]+Math.sin(t)*v[2];f[i][3]=Math.cos(t)*x[3]+Math.sin(t)*v[3];e[i][0]=0;e[i][1]=this.degrees(Math.atan2(f[i][2],f[i][1]));e[i][2]=this.degrees(Math.asin(f[i][3]));r+=e[i][1]+';'+e[i][2]+'; 0 '+';';}return r;};
return R;});
sap.ui.predefine('sap/ui/vbm/Routes',['./VoAggregation','./library'],function(V,l){"use strict";
var R=V.extend("sap.ui.vbm.Routes",{metadata:{library:"sap.ui.vbm",properties:{posChangeable:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.vbm.Route",multiple:true,singularName:"item"},dragSource:{type:"sap.ui.vbm.DragSource",multiple:true,singularName:"dragSource"},dropTarget:{type:"sap.ui.vbm.DropTarget",multiple:true,singularName:"dropTarget"}},events:{click:{},contextMenu:{},drop:{}}}});
R.prototype.getBindInfo=function(){var b=V.prototype.getBindInfo.apply(this,arguments);var t=this.getTemplateBindingInfo();b.P=(t)?t.hasOwnProperty("position"):true;b.C=(t)?t.hasOwnProperty("color"):true;b.ST=(t)?t.hasOwnProperty("start"):true;b.ED=(t)?t.hasOwnProperty("end"):true;b.LW=(t)?t.hasOwnProperty("linewidth"):true;b.DC=(t)?t.hasOwnProperty("dotcolor"):true;b.DW=(t)?t.hasOwnProperty("dotwidth"):true;b.DBC=(t)?t.hasOwnProperty("dotbordercolor"):true;b.CB=(t)?t.hasOwnProperty("colorBorder"):true;b.LD=(t)?t.hasOwnProperty("lineDash"):true;b.DI=(t)?t.hasOwnProperty("directionIndicator"):true;return b;};
R.prototype.getTemplateObject=function(){var t=V.prototype.getTemplateObject.apply(this,arguments);var b=this.mBindInfo=this.getBindInfo();var v=(b.hasTemplate)?this.getBindingInfo("items").template:null;t["type"]="{00100000-2012-0004-B001-C46BD7336A1A}";if(b.P){t["posarray.bind"]=t.id+".P";}else{t.posarray=v.getPosition();}if(b.C){t["color.bind"]=t.id+".C";}else{t.color=v.getColor();}if(b.ST){t["start.bind"]=t.id+".ST";}else{t.start=v.getStart();}if(b.ED){t["end.bind"]=t.id+".ED";}else{t.end=v.getEnd();}if(b.LW){t["linewidth.bind"]=t.id+".LW";}else{t.linewidth=v.getLinewidth();}if(b.DC){t["dotcolor.bind"]=t.id+".DC";}else{t.dotcolor=v.getDotcolor();}if(b.DBC){t["dotbordercolor.bind"]=t.id+".DBC";}else{t.dotbordercolor=v.getDotbordercolor();}if(b.CB){t["colorBorder.bind"]=t.id+".CB";}else{t.colorBorder=v.getColorBorder();}if(b.LD){t["lineDash.bind"]=t.id+".LD";}else{t.lineDash=v.getLineDash();}if(b.DW){t["dotwidth.bind"]=t.id+".DW";}else{t.dotwidth=v.getDotwidth();}if(b.DI){t["directionIndicator.bind"]=t.id+".DI";}else{t.directionIndicator=v.getDirectionIndicator();}t["DragSource"]={"DragItem":this.getDragItemTemplate(t.id)};t["DropTarget"]={"DropItem":this.getDropItemTemplate(t.id)};return t;};
R.prototype.getTypeObject=function(){var t=V.prototype.getTypeObject.apply(this,arguments);var b=this.mBindInfo;if(b.P){t.A.push({"changeable":this.getPosChangeable().toString(),"name":"P","alias":"P","type":"vector"});}if(b.C){t.A.push({"name":"C","alias":"C","type":"color"});}if(b.ST){t.A.push({"name":"ST","alias":"ST","type":"long"});}if(b.ED){t.A.push({"name":"ED","alias":"ED","type":"long"});}if(b.LW){t.A.push({"name":"LW","alias":"LW","type":"float"});}if(b.DC){t.A.push({"name":"DC","alias":"DC","type":"color"});}if(b.DBC){t.A.push({"name":"DBC","alias":"DBC","type":"color"});}if(b.CB){t.A.push({"name":"CB","alias":"CB","type":"color"});}if(b.LD){t.A.push({"name":"LD","alias":"LD","type":"string"});}if(b.DW){t.A.push({"name":"DW","alias":"DW","type":"float"});}if(b.DI){t.A.push({"name":"DI","alias":"DI","type":"boolean"});}return t;};
R.prototype.getActionArray=function(){var a=V.prototype.getActionArray.apply(this,arguments);var i=this.getId();if(this.mEventRegistry["click"]||this.isEventRegistered("click")){a.push({"id":i+"1","name":"click","refScene":"MainScene","refVO":i,"refEvent":"Click","AddActionProperty":[{"name":"pos"}]});}if(this.mEventRegistry["contextMenu"]||this.isEventRegistered("contextMenu")){a.push({"id":i+"2","name":"contextMenu","refScene":"MainScene","refVO":i,"refEvent":"ContextMenu"});}if(this.mEventRegistry["drop"]||this.isEventRegistered("drop")){a.push({"id":i+"3","name":"drop","refScene":"MainScene","refVO":i,"refEvent":"Drop"});}return a;};
return R;});
sap.ui.predefine('sap/ui/vbm/Spot',['sap/ui/core/theming/Parameters','./VoBase','./library'],function(P,V,l){"use strict";
var S=V.extend("sap.ui.vbm.Spot",{metadata:{library:"sap.ui.vbm",properties:{position:{type:"string",group:"Misc",defaultValue:'0;0;0'},text:{type:"string",group:"Misc",defaultValue:null},image:{type:"string",group:"Misc",defaultValue:null},alignment:{type:"string",group:"Misc",defaultValue:'5'},scale:{type:"string",group:"Misc",defaultValue:'1;1;1'},imageSelected:{type:"string",group:"Misc",defaultValue:null},icon:{type:"string",group:"Misc",defaultValue:null},contentColor:{type:"string",group:"Misc",defaultValue:null},contentOffset:{type:"string",group:"Misc",defaultValue:'0;0'},contentFont:{type:"string",group:"Misc",defaultValue:'arial'},contentSize:{type:"string",group:"Misc",defaultValue:null},type:{type:"sap.ui.vbm.SemanticType",group:"Behavior",defaultValue:null}},aggregations:{dragSource:{type:"sap.ui.vbm.DragSource",multiple:true,singularName:"dragSource"},dropTarget:{type:"sap.ui.vbm.DropTarget",multiple:true,singularName:"dropTarget"}},events:{}}});
S.prototype.init=function(){this.mProperties.contentColor="#000000";this.mProperties.contentSize=(P)?P.get("sapMFontMediumSize"):null;};
S.prototype.openContextMenu=function(m){this.getParent().openContextMenu("Spot",this,m);};
S.prototype.getImageProps=function(t,a,h){var e={};if(t!==sap.ui.vbm.SemanticType.None){if(t===sap.ui.vbm.SemanticType.Hidden){e.I="Pin_Hidden.png";}else{if(t===sap.ui.vbm.SemanticType.Error){e.I="Pin_Red_";}if(t===sap.ui.vbm.SemanticType.Warning){e.I="Pin_Orange_";}if(t===sap.ui.vbm.SemanticType.Success){e.I="Pin_Green_";}if(t===sap.ui.vbm.SemanticType.Inactive){e.I="Pin_Grey_";}if(t===sap.ui.vbm.SemanticType.Default){e.I="Pin_Blue_";}if(a){if(a>3){e.I+="5-digit_space.png";e.CO="15;-3";}else if(a>1){e.I+="3-digit_space.png";e.CO="9;-3";}else{e.I+="1-digit.png";e.CO="0;-3";}}else if(e.I){e.I+=(h)?"1_Icon.png":"0_Icon.png";if(h){e.CO="0;-5";}}}if(e.I){this.getParent().getParent().addResourceIfNeeded(e.I);}}return e;};
S.prototype.getDataElement=function(){var e=V.prototype.getDataElement.apply(this,arguments);var b=this.oParent.mBindInfo;if(b.P){e.P=this.getPosition();}if(b.S){e.S=this.getScale();}if(b.T){e.T=this.getText();}if(b.I){e.I=this.getImage();}if(b.IS){e.IS=this.getImageSelected();}if(b.AL){e.AL=this.getAlignment();}if(b.IC){e.IC=this.getIcon();}if(b.CC){e.CC=this.getContentColor();}if(b.CO){e.CO=this.getContentOffset();}if(b.CF){e.CF=this.getContentFont();}if(b.CS){e.CS=this.getContentSize();}if(b.DS||b.DT){e.N=this.getDragDropDefs();}var t=this.getText();var a=t?t.length:0;var i=this.getIcon();var h=(i.length>0)?true:false;var E=this.getImageProps(this.getType(),a,h);if(E.I){e.I=E.I;}if(E.CO){e.CO=E.CO;}return e;};
S.prototype.handleChangedData=function(e){if(e.P){this.setPosition(e.P);}if(e.S){this.setScale(e.S);}};
return S;});
sap.ui.predefine('sap/ui/vbm/Spots',['./VoAggregation','./library'],function(V,l){"use strict";
var S=V.extend("sap.ui.vbm.Spots",{metadata:{library:"sap.ui.vbm",properties:{posChangeable:{type:"boolean",group:"Misc",defaultValue:true},scaleChangeable:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.vbm.Spot",multiple:true,singularName:"item"},dragSource:{type:"sap.ui.vbm.DragSource",multiple:true,singularName:"dragSource"},dropTarget:{type:"sap.ui.vbm.DropTarget",multiple:true,singularName:"dropTarget"}},events:{}}});
S.prototype.getBindInfo=function(){var b=V.prototype.getBindInfo.apply(this,arguments);var t=this.getTemplateBindingInfo();b.S=(t)?t.hasOwnProperty("scale"):true;b.I=(t)?t.hasOwnProperty("image"):true;b.IS=(t)?t.hasOwnProperty("imageSelected"):true;b.P=(t)?t.hasOwnProperty("position"):true;b.T=(t)?t.hasOwnProperty("text"):true;b.AL=(t)?t.hasOwnProperty("alignment"):true;b.IC=(t)?t.hasOwnProperty("icon"):true;b.CC=(t)?t.hasOwnProperty("contentColor"):true;b.CO=(t)?t.hasOwnProperty("contentOffset"):true;b.CF=(t)?t.hasOwnProperty("contentFont"):true;b.CS=(t)?t.hasOwnProperty("contentSize"):true;b.Type=(t)?t.hasOwnProperty("type"):true;return b;};
S.prototype.getTemplateObject=function(){var t=V.prototype.getTemplateObject.apply(this,arguments);var b=this.mBindInfo=this.getBindInfo();var v=(b.hasTemplate)?this.getBindingInfo("items").template:null;if(b.Type||v.mProperties["type"]!==sap.ui.vbm.SemanticType.None){b.T=b.I=b.CO=b.CC=true;}t["type"]="{00100000-2012-0004-B001-64592B8DB964}";if(b.P){t["pos.bind"]=t.id+".P";}else{t.pos=v.getPosition();}if(b.IC){t["icon.bind"]=t.id+".IC";}else{t.icon=v.getIcon();}if(b.S){t["scale.bind"]=t.id+".S";}else{t.scale=v.getScale();}if(b.IS){t["imageSelected.bind"]=t.id+".IS";}else{t.imageSelected=v.getImageSelected();}if(b.AL){t["alignment.bind"]=t.id+".AL";}else{t.alignment=v.getAlignment();}if(b.CF){t["contentFont.bind"]=t.id+".CF";}else{t.contentFont=v.getContentFont();}if(b.CS){t["contentSize.bind"]=t.id+".CS";}else{t.contentSize=v.getContentSize();}if(b.T){t["text.bind"]=t.id+".T";}else{t.text=v.getText();}if(b.I){t["image.bind"]=t.id+".I";}else{t.image=v.getImage();}if(b.CO){t["contentOffset.bind"]=t.id+".CO";}else{t.contentOffset=v.getContentOffset();}if(b.CC){t["contentColor.bind"]=t.id+".CC";}else{t.contentColor=v.getContentColor();}t["DragSource"]={"DragItem":this.getDragItemTemplate(t.id)};t["DropTarget"]={"DropItem":this.getDropItemTemplate(t.id)};return t;};
S.prototype.getTypeObject=function(){var t=V.prototype.getTypeObject.apply(this,arguments);var b=this.mBindInfo;if(b.P){t.A.push({"changeable":this.getPosChangeable().toString(),"name":"P","alias":"P","type":"vector"});}if(b.S){t.A.push({"changeable":this.getScaleChangeable().toString(),"name":"S","alias":"S","type":"vector"});}if(b.T){t.A.push({"name":"T","alias":"T","type":"string"});}if(b.I){t.A.push({"name":"I","alias":"I","type":"string"});}if(b.IS){t.A.push({"name":"IS","alias":"IS","type":"string"});}if(b.AL){t.A.push({"name":"AL","alias":"AL","type":"string"});}if(b.IC){t.A.push({"name":"IC","alias":"IC","type":"string"});}if(b.CC){t.A.push({"name":"CC","alias":"CC","type":"string"});}if(b.CO){t.A.push({"name":"CO","alias":"CO","type":"string"});}if(b.CF){t.A.push({"name":"CF","alias":"CF","type":"string"});}if(b.CF){t.A.push({"name":"CS","alias":"CS","type":"string"});}return t;};
S.prototype.getActionArray=function(f){var a=V.prototype.getActionArray.apply(this,arguments);var i=this.getId();if(f||this.mEventRegistry["click"]||this.isEventRegistered("click")){a.push({"id":i+"1","name":"click","refScene":"MainScene","refVO":i,"refEvent":"Click","AddActionProperty":[{"name":"pos"}]});}if(f||this.mEventRegistry["contextMenu"]||this.isEventRegistered("contextMenu")){a.push({"id":i+"2","name":"contextMenu","refScene":"MainScene","refVO":i,"refEvent":"ContextMenu"});}if(f||this.mEventRegistry["drop"]||this.isEventRegistered("drop")){a.push({"id":i+"3","name":"drop","refScene":"MainScene","refVO":i,"refEvent":"Drop"});}return a;};
return S;});
sap.ui.predefine('sap/ui/vbm/VBIRenderer',function(){"use strict";var V={};
V.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("vbi-main");r.writeClasses(c);r.addStyle("width",c.getWidth());r.addStyle("height",c.getHeight());r.writeStyles();r.write(">");var i=c.getId();if(c.getPlugin()){if(c.$oldContent.length===0){if((navigator.appName=="Microsoft Internet Explorer")||/(trident)\/[\w.]+;.*rv:([\w.]+)/i.test(navigator.userAgent)){r.write("<object id='VBI"+i+"'"+" data-sap-ui-preserve='"+i+"' CLASSID='CLSID:00100000-2011-0070-2000-FC7214A1CD7B' "+"width='"+c.getWidth()+"' "+"height='"+c.getHeight()+"' "+">");r.write("<a href='http://scn.sap.com/community/visual-business' > Get the Visual Business PlugIn.</a>");r.write("</object>");}else{r.write("<embed id='VBI"+i+"'"+" data-sap-ui-preserve='"+i+"' type='application/x-visualbusiness' "+"width='"+c.getWidth()+"' "+"height='"+c.getHeight()+"' "+">");}}}r.write("<div class='vbi-hidden'>");this.renderDependants(r,c.m_renderList);r.write("</div>");c.m_renderList=[];r.write("</div>");};
V.renderDependants=function(r,l){for(var i=0,e;i<l.length;++i){e=l[i];if(!e.control.getDomRef()){r.write("<div data='"+e.data+"'>");r.renderControl(e.control);r.write("</div>");}}};
return V;},true);
sap.ui.predefine('sap/ui/vbm/Viewport',["sap/ui/core/Control","jquery.sap.global","sap/ui/core/ResizeHandler","./adapter3d/thirdparty/three","./adapter3d/thirdparty/OrbitControls","./adapter3d/Utilities","./ViewportRenderer","./library"],function(C,q,R,T,O,U,V,l){"use strict";var t="sap.ui.vbm.Viewport";var a=q.sap.log;
var b=C.extend("sap.ui.vbm.Viewport",{metadata:{library:"sap.ui.vbm",properties:{width:{type:"sap.ui.core.CSSSize",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",defaultValue:"100%"},cameraHistoryLength:{type:"int",defaultValue:0},cameraHistoryPos:{type:"int"}},events:{cameraChange:{parameters:{historyPos:{type:"int"},historyLength:{type:"int"}}}}}});
var E=0.000001;var F=0.6;var M=50000.0;var c=85.0;var d=b.getMetadata().getParent().getClass().prototype;
b.prototype.init=function(){if(d.init){d.init.call(this);}this._resizeListenerId=null;this._renderLoopRequestId=0;this._renderLoopFunction=this._renderLoop.bind(this);this._renderer=new T.WebGLRenderer({antialias:true});this._renderer.setPixelRatio(window.devicePixelRatio);this._renderer.shadowMap.enabled=true;this._renderer.domElement.tabIndex=-1;this._renderer.domElement.id=this.getId()+"-canvas";this._scene=new T.Scene();this._root=new T.Group();this._root.scale.set(-1,1,1);this._root.rotateX(T.Math.degToRad(90));this._root.matrixAutoUpdate=false;this._root.updateMatrix();this._scene.add(this._root);this._mapPlane=new T.Mesh(new T.PlaneGeometry(M,M,1,1),new T.MeshBasicMaterial({color:0x207bad,side:T.DoubleSide}));this._mapPlane.name="MapPlane";this._mapPlane.layers.set(2);this._mapPlane.visible=false;this._mapPlane.matrixAutoUpdate=false;this._mapPlane.updateMatrix();this._root.add(this._mapPlane);this._scene.background=new T.Color('white');this._scene.add(new T.AmbientLight(0x202020,1));var i=new T.DirectionalLight(0x333333,1);i.position.set(0,0,-1);i.matrixAutoUpdate=false;i.updateMatrix();this._scene.add(i);var j=new T.DirectionalLight(0x51515b,1);j.position.set(-2,-1.1,2.5);j.matrixAutoUpdate=false;j.updateMatrix();this._scene.add(j);var k=new T.DirectionalLight(0x5b5b5b,2);k.position.set(2,1.5,0.5);k.matrixAutoUpdate=false;k.updateMatrix();this._scene.add(k);this._light=new T.DirectionalLight(0xEEEEEE,1);this._lightPos=new T.Vector3(0,0,0);this._scene.add(this._light);this._camera=new T.PerspectiveCamera(30,window.innerWidth/window.innerHeight,0.1,2000);this._camera.layers.enable(0);this._camera.layers.enable(1);this._scene.add(this._camera);this._camera.position.set(0,30,30);this._camera.lookAt(new T.Vector3(0,0,0));this._cameraHome;this._flyToRequestId;this._resetTimerId;this._cameraHistory=[];this._cameraChangeEvent={};this._bbox=new T.Box3();this._cameraController=new O(this._camera,this._renderer.domElement);this._cameraController.addEventListener("end",this._cameraEnd.bind(this));this._cameraController.addEventListener("change",this._cameraUpdate.bind(this));this._cameraController.update();};
b.prototype.exit=function(){if(this._resizeListenerId){R.deregister(this._resizeListenerId);this._resizeListenerId=null;}this._stopRenderLoop();this._scene=null;this._camera=null;this._renderer=null;if(d.exit){d.exit.call(this);}};
b.prototype.getRoot=function(){return this._root;};
b.prototype.getScene=function(){return this._scene;};
b.prototype.getCamera=function(){return this._camera;};
b.prototype.getCameraHistoryLength=function(){return this._cameraHistory.length;};
b.prototype.setCameraHistoryLength=function(){a.error("cameraHistoryLength is read only property",t);return this;};
b.prototype.setCameraHistoryPos=function(p){if(this._cameraHistory.length>0&&p>=0&&p<this._cameraHistory.length){if(p!==this.getCameraHistoryPos()){this.setProperty("cameraHistoryPos",p,true);delete this._cameraHistory[p].tag;this._fireCameraChange();this._flyTo(this._cameraController.saveState(),this._cameraHistory[p],F);}}return this;};
b.prototype.applyCameraHome=function(i){if(this._cameraHome){this._applyCamera(this._cameraHome,i);}};
b.prototype.worldToScreen=function(p){var i=this.getDomRef();if(!i){return undefined;}var j=i.getBoundingClientRect();var k=this.getCamera();var m=new T.Matrix4().multiplyMatrices(k.projectionMatrix,new T.Matrix4().getInverse(k.matrixWorld));var s=p.clone().applyMatrix4(m);var x=Math.floor((+s.x*0.5+0.5)*j.width+0.5);var y=Math.floor((-s.y*0.5+0.5)*j.height+0.5);return new T.Vector2(x,y);};
b.prototype.onBeforeRendering=function(){if(this._resizeListenerId){R.deregister(this._resizeListenerId);this._resizeListenerId=null;}this._stopRenderLoop();};
b.prototype.onAfterRendering=function(){var i=this.getDomRef();i.appendChild(this._renderer.domElement);this._resizeListenerId=R.register(this,this._handleResize.bind(this));this._handleResize({size:{width:i.clientWidth,height:i.clientHeight}});this._startRenderLoop();};
b.prototype._handleResize=function(i){if(!this._camera||!this._renderer){return false;}var w=i.size.width;var j=i.size.height;if(this._camera){this._camera.aspect=w/j;this._camera.updateProjectionMatrix();}this._renderer.setSize(w,j,false);};
b.prototype._startRenderLoop=function(){if(!this._renderLoopRequestId){this._renderLoopRequestId=window.requestAnimationFrame(this._renderLoopFunction);}return this;};
b.prototype._stopRenderLoop=function(){if(this._renderLoopRequestId){window.cancelAnimationFrame(this._renderLoopRequestId);this._renderLoopRequestId=0;}return this;};
b.prototype._renderLoop=function(){this._cameraController.update();this._camera.getWorldDirection(this._lightPos);this._lightPos.negate();this._light.position.copy(this._lightPos);this._renderer.render(this._scene,this._camera);this._renderLoopRequestId=window.requestAnimationFrame(this._renderLoopFunction);};
function e(i,s,j,k){return s+j*((i=i/k-1)*i*i+1);}
function f(i){var j=Math.min((Date.now()-i.when)/1000,i.length);var k=i.tempTarget;k.x=e(j,i.from.target.x,i.to.target.x-i.from.target.x,i.length);k.y=e(j,i.from.target.y,i.to.target.y-i.from.target.y,i.length);k.z=e(j,i.from.target.z,i.to.target.z-i.from.target.z,i.length);var m=e(j,i.distanceFrom,i.distanceTo-i.distanceFrom,i.length);var n=e(j,0,i.angle,i.length);var p=i.tempPos.copy(i.dir).applyAxisAngle(i.axis,n).multiplyScalar(m).add(k);this._cameraController.reset({position:p,target:k,zoom:1.0});if(j<i.length){this._flyToRequestId=window.requestAnimationFrame(f.bind(this,i));}else{this._flyToRequestId=undefined;}}
b.prototype._flyTo=function(i,j,k){var m=j.position.clone().sub(j.target);var n=i.position.clone().sub(i.target);var o=m.length();var p=n.length();var s=Math.acos(U.clamp(n.dot(m)/(o*p),-1,1));var u={to:j,from:i,when:Date.now(),length:k,angle:s,axis:n.clone().cross(m).normalize(),distanceTo:o,distanceFrom:p,dir:n.normalize(),tempPos:new T.Vector3(),tempTarget:new T.Vector3()};if(this._flyToRequestId){window.cancelAnimationFrame(this._flyToRequestId);}this._flyToRequestId=window.requestAnimationFrame(f.bind(this,u));};
b.prototype._cameraEnd=function(i){var s=this._cameraController.saveState();var p=this.getCameraHistoryPos();var j=p>=0?this._cameraHistory[p]:undefined;if(j==undefined||s.target.distanceToSquared(j.target)>E||s.position.distanceToSquared(j.position)>E){this._pushCameraChange(s);}};
function r(){if(this._cameraHistory.length>0){delete this._cameraHistory[this._cameraHistory.length-1].tag;}this._resetTimerId=undefined;}
b.prototype._cameraUpdate=function(i){if(i.tag){if(this._resetTimerId){window.clearTimeout(this._resetTimerId);}this._resetTimerId=window.setTimeout(r.bind(this),500);var s=this._cameraController.saveState();var p=this.getCameraHistoryPos();s.tag=i.tag;var j=p>=0?this._cameraHistory[p]:{};if(s.tag&&s.tag===j.tag){this._cameraHistory[p]=s;}else{this._pushCameraChange(s);}}this._updateCamera();this._updateController();};
b.prototype._fireCameraChange=function(){this._cameraChangeEvent.historyPos=this.getCameraHistoryPos();this._cameraChangeEvent.historyLength=this._cameraHistory.length;this.fireCameraChange(this._cameraChangeEvent);};
b.prototype._pushCameraChange=function(s){var p=this.getCameraHistoryPos();this._cameraHistory.splice(p>=0?p+1:0,this._cameraHistory.length);this._cameraHistory.push(s);this.setProperty("cameraHistoryPos",this._cameraHistory.length-1,true);this._fireCameraChange();};
b.prototype._setCameraHome=function(s){this._cameraHome=s;};
b.prototype._applyCamera=function(s,i){var j=this._cameraController.saveState();if(s.target.distanceToSquared(j.target)>E||s.position.distanceToSquared(j.position)>E){this._pushCameraChange(s);if(i){this._flyTo(this._cameraController.saveState(),s,F);}else{this._cameraController.reset(s);}}};
b.prototype._getCameraState=function(){return this._cameraController.saveState();};
b.prototype._intersectMapPlane=function(i){i.layers.set(2);var o=i.intersectObjects([this._mapPlane],false);return o;};
var _=new T.Box3(),g=new T.Matrix4();
function h(o,j){var i,k=o.geometry;o.updateWorldMatrix(false,false);if(o.visible&&k){if(!k.boundingBox){k.computeBoundingBox();}if(o.isInstancedMesh){for(i=0;i<o.count;++i){o.getMatrixAt(i,g);_.copy(k.boundingBox);_.applyMatrix4(g);j.union(_);}}else{_.copy(k.boundingBox);_.applyMatrix4(o.matrixWorld);j.union(_);}}var m=o.children;for(i=0;i<m.length;++i){h(m[i],j);}}
b.prototype._resetBBox=function(){this._bbox.makeEmpty();};
b.prototype._getBBox=function(){if(this._bbox.isEmpty()){h(this.getScene(),this._bbox);}return this._bbox;};
b.prototype._updateCamera=function(){var i=this._getBBox();if(!i.isEmpty()){var s=new T.Sphere();i.getBoundingSphere(s);if(s.radius===0){s.radius=1;}this._camera.updateMatrixWorld(false);s.center.applyMatrix4(this._camera.matrixWorldInverse);var n=U.clamp(-s.center.z-s.radius,s.radius*0.001,-s.center.z-s.radius);var j=n+s.radius*2,k=false;if(Math.abs(this._camera.near-n)>=this._camera.near*0.03){this._camera.near=n;k=true;}if(Math.abs(this._camera.far-j)>=this._camera.far*0.03){this._camera.far=j;k=true;}if(k){this._camera.updateProjectionMatrix();}}};
b.prototype._updateController=function(){var i=this._cameraController.target.clone().sub(this._camera.position).normalize();var n=new T.Vector3(0,this._camera.position.y>0?1:-1,0);var p=new T.Plane(n),j=new T.Vector3();var k=new T.Ray(this._camera.position,i);if(k.intersectPlane(p,j)){if(T.Math.radToDeg(this._camera.position.clone().sub(j).angleTo(n))<c){this._cameraController.target.copy(j);}}};
return b;});
sap.ui.predefine('sap/ui/vbm/VoAbstract',['sap/ui/core/Element','./library'],function(E,l){"use strict";
var V=E.extend("sap.ui.vbm.VoAbstract",{metadata:{library:"sap.ui.vbm",properties:{},events:{}}});
V.prototype.isEventRegistered=function(n){var v=this.getItems();if(!v){return false;}for(var a=0,b=v.length;a<b;++a){var i=v[a];if(i.mEventRegistry[n]){return true;}}return false;};
V.prototype.findInstance=function(n){var v=this.getItems();if(!v){return false;}var k=(n.indexOf(".")!==-1)?n.split(".")[1]:n;for(var a=0,b=v.length;a<b;++a){if(v[a].sId===k){return v[a];}}return null;};
V.prototype.findInstanceByKey=function(n){var v=this.getItems();if(!v){return false;}var k=(n.indexOf(".")!==-1)?n.split(".")[1]:n;for(var a=0,b=v.length;a<b;++a){if(v[a].sId===k||v[a].getKey()===k){return v[a];}}return null;};
V.prototype.getActionArray=function(){var a=[];return a;};
V.prototype.getTemplateBindingInfo=function(){var b=this.getBindingInfo("items");if(b&&b.template){return b.template.mBindingInfos;}};
V.prototype.getBindInfo=function(){var b={};var t=this.getTemplateBindingInfo();b.hasTemplate=(t)?true:false;return b;};
V.prototype.getTemplateObject=function(){var t={};t['id']=this.getId();t['datasource']=t.id;return t;};
V.prototype.getTypeObject=function(){var t={};t['name']=this.getId();t['key']='K';t.A=[{"name":"K","alias":"K","type":"string"},{"name":"VB:s","alias":"VB:s","type":"boolean"}];return t;};
V.prototype.getDataDeltaObject=function(d){var D={};var r=[];var I=this.getItems();D['name']=this.getId();D.E=[];for(var n=0;n<d.length;++n){if(d[n].type=="delete"){r.push(d[n].object);}else if(d[n].type=="insert"){var i=d[n].idx;D.E.push(I[i].getDataElement());}}return{oData:D,aRemoveData:r};};
V.prototype.getDataRemoveObject=function(){var d={name:this.getId(),type:"N"};return d;};
V.prototype.getDataObject=function(){var d={};d['name']=this.getId();d.E=[];var v=this.getItems();for(var n=0,a=v.length;n<a;++n){d.E.push(v[n].getDataElement());}return d;};
V.prototype.openContextMenu=function(t,v,m){this.oParent.openContextMenu(t,v,m);};
return V;});
sap.ui.predefine('sap/ui/vbm/VoAggregation',['./VoAbstract','./library'],function(V,l){"use strict";
var b=V.extend("sap.ui.vbm.VoAggregation",{metadata:{library:"sap.ui.vbm",properties:{minSel:{type:"string",group:"Misc",defaultValue:"0"},maxSel:{type:"string",group:"Misc",defaultValue:"n"},customProperties:{type:"string[]",group:"Misc"}},events:{handleMoved:{parameters:{instance:{type:"sap.ui.vbm.VoBase"},handle:{type:"int"}}},handleContextMenu:{parameters:{instance:{type:"sap.ui.vbm.VoBase"},menu:{type:"sap.ui.unified.Menu"},handle:{type:"int"}}},handleClick:{parameters:{instance:{type:"sap.ui.vbm.VoBase"},handle:{type:"int"}}},select:{parameters:{selected:{type:"array"}}},deselect:{parameters:{deselected:{type:"array"}}},click:{parameters:{instance:{type:"sap.ui.vbm.VoBase"}}},contextMenu:{parameters:{instance:{type:"sap.ui.vbm.VoBase"},menu:{type:"sap.ui.unified.Menu"}}},drop:{parameters:{instance:{type:"sap.ui.vbm.Spot"},dragSource:{type:"sap.ui.vbm.VoBase"}}}}}});
b.prototype.init=function(){this.aDiff=[];this.aUniqueIdx=[];this.currentIdx=1000;this.setProperty("customProperties",[],true);this.bUseExtendedChangeDetection=true;};
b.prototype.handleSelectEvent=function(e){var s=[];var d=[];for(var n=0;n<e.length;++n){var E=e[n];var v=this.getItems();if(v){for(var a=0,c=v.length;a<c;++a){if(v[a].UniqueId==E.K){var f=(E["VB:s"]=="true"?true:false);var m=v[a].getSelect();if(f!=m){if(f){v[a].setProperty("select",true,true);if(this.mEventRegistry["select"]){s.push(v[a]);}}else{v[a].setProperty("select",false,true);if(this.mEventRegistry["deselect"]){d.push(v[a]);}}}}}}}if(d.length){this.fireDeselect({deselected:d});}if(s.length){this.fireSelect({selected:s});}};
b.prototype.isEventRegistered=function(n){var v=this.getItems();if(!v){return false;}for(var a=0,c=v.length;a<c;++a){var i=v[a];if(i.mEventRegistry[n]){return true;}}return false;};
b.prototype.findSelected=function(s,d){var v=this.getItems();if(!v){return null;}var S=[];if(jQuery.type(d)=='object'){if(d["VB:s"]==(s?"true":"false")){for(var n=0;n<v.length;++n){if(v[n].UniqueId==d["K"]){S.push(v[n]);}}}}else if(jQuery.type(d)=='array'){for(var a=0;a<d.length;++a){if(d[a]["VB:s"]==(s?"true":"false")){for(var c=0;c<v.length;++c){if(v[c].UniqueId==d[a]["K"]){S.push(v[c]);}}}}}return S;};
b.prototype.findInstance=function(n){var v=this.getItems();if(!v){return false;}var k=(n.indexOf(".")!==-1)?n.split(".")[1]:n;for(var a=0,c=this.aUniqueIdx.length;a<c;++a){if(this.aUniqueIdx[a]===k){return v[a];}}return null;};
b.prototype.findInstanceByKey=function(n){var v=this.getItems();if(!v){return false;}var k=(n.indexOf(".")!==-1)?n.split(".")[1]:n;for(var a=0,c=v.length;a<c;++a){if(v[a].sId===k||v[a].getKey()===k){return v[a];}}return null;};
b.prototype.getActionArray=function(){var i=this.getId();var a=[];if(this.mEventRegistry["handleMoved"]||this.isEventRegistered("handleMoved")){a.push({"id":i+"4","name":"handleMoved","refScene":"MainScene","refVO":i,"refEvent":"HandleMoved"});}if(this.mEventRegistry["handleContextMenu"]||this.isEventRegistered("handleContextMenu")){a.push({"id":i+"5","name":"handleContextMenu","refScene":"MainScene","refVO":i,"refEvent":"HandleContextMenu"});}if(this.mEventRegistry["handleClick"]||this.isEventRegistered("handleClick")){a.push({"id":i+"6","name":"handleClick","refScene":"MainScene","refVO":i,"refEvent":"HandleClick"});}var t;var s=((t=this.getTemplateBindingInfo()))?t.hasOwnProperty("select"):false;if((this.mEventRegistry["select"]||this.mEventRegistry["deselect"]||s)&&!this.isEventRegistered("click")){a.push({"id":i+"9","name":"click","refScene":"MainScene","refVO":i,"refEvent":"Click"});}return a;};
b.prototype.getBindInfo=function(){var B=V.prototype.getBindInfo.apply(this,arguments);var t=this.getTemplateBindingInfo();B.HS=(t)?t.hasOwnProperty("hotScale"):true;B.HDC=(t)?t.hasOwnProperty("hotDeltaColor"):true;B.SC=(t)?t.hasOwnProperty("selectColor"):true;B.FS=(t)?t.hasOwnProperty("fxsize"):true;B.FD=(t)?t.hasOwnProperty("fxdir"):true;B.ET=(t)?t.hasOwnProperty("entity"):true;B.LT=(t)?t.hasOwnProperty("labelText"):true;B.LBC=(t)?t.hasOwnProperty("labelBgColor"):true;B.LBBC=(t)?t.hasOwnProperty("labelBorderColor"):true;B.AR=(t)?t.hasOwnProperty("labelArrow"):true;B.LP=(t)?t.hasOwnProperty("labelPos"):true;B.TT=(t)?t.hasOwnProperty("tooltip"):true;B.DD=(t)?t.hasOwnProperty("dragData"):true;B.M=(t)?t.hasOwnProperty("changeable"):true;B.DS=(t)?t.hasOwnProperty("dragSource"):true;B.DT=(t)?t.hasOwnProperty("dropTarget"):true;B.LabelType=(t)?t.hasOwnProperty("labelType"):true;return B;};
b.prototype.getTemplateObject=function(){var t=V.prototype.getTemplateObject.apply(this,arguments);var B=this.mBindInfo=this.getBindInfo();var v=(B.hasTemplate)?this.getBindingInfo("items").template:null;this.bHasType=B.LabelType||(v.mProperties["labelType"]!==sap.ui.vbm.SemanticType.None);if(B.HS){t['hotScale.bind']=t.id+".HS";}else{t.hotScale=v.getHotScale();}if(B.HDC){t['hotDeltaColor.bind']=t.id+".HDC";}else{t.hotDeltaColor=v.getHotDeltaColor();}if(B.SC){t['selectColor.bind']=t.id+".SC";}else{t.selectColor=v.getSelectColor();}if(B.FS){t['fxsize.bind']=t.id+".FS";}else{t.fxsize=v.getFxsize();}if(B.FD){t['fxdir.bind']=t.id+".FD";}else{t.fxdir=v.getFxdir();}if(B.ET){t['entity.bind']=t.id+".ET";}else{t.entity=v.getEntity();}if(B.LT){t['labelText.bind']=t.id+".LT";}else{t.labelText=v.getLabelText();}if(this.bHasType){t['labelIcon.bind']=t.id+".LIC";t['labelIconBgrdCol.bind']=t.id+".LICC";t['labelIconTextCol.bind']=t.id+".LICTC";t['labelBgColor.bind']=t.id+".LBC";t['labelBorderColor.bind']=t.id+".LBBC";}else{if(B.LBC){t['labelBgColor.bind']=t.id+".LBC";}else{t.labelBgColor=v.getLabelBgColor();}if(B.LBBC){t['labelBorderColor.bind']=t.id+".LBBC";}else{t.labelBorderColor=v.getLabelBorderColor();}}if(B.AR){t['labelArrow.bind']=t.id+".AR";}else{t.labelArrow=v.getLabelArrow();}if(B.LP){t['labelPos.bind']=t.id+".LP";}else{t.labelPos=v.getLabelPos();}if(B.TT){t['tooltip.bind']=t.id+".TT";}else{t.tooltip=v.getTooltip();}if(B.DD){t['dragdata.bind']=t.id+".DD";}else{t.dragdata=v.getDragData();}if(!B.M){t['VB:c']=v.getChangeable();}t.altBorderDeltaColor='#676767';return t;};
b.prototype.getTypeObject=function(){var t=V.prototype.getTypeObject.apply(this,arguments);var m=this.getMinSel();if(m!="0"&&m!="1"){m="0";}var M=this.getMaxSel();if(M!="0"&&M!="1"&&M!="n"||M=="n"){M="-1";}t['minSel']=m;t['maxSel']=M;var B=this.mBindInfo;if(B.HS){t.A.push({"name":"HS","alias":"HS","type":"vector"});}if(B.HDC){t.A.push({"name":"HDC","alias":"HDC","type":"string"});}if(B.SC){t.A.push({"name":"SC","alias":"SC","type":"string"});}if(B.FS){t.A.push({"name":"FS","alias":"FS","type":"boolean"});}if(B.ET){t.A.push({"name":"ET","alias":"ET","type":"string"});}if(B.LT){t.A.push({"name":"LT","alias":"LT","type":"string"});}if(this.bHasType){t.A.push({"name":"LBC","alias":"LBC","type":"color"});t.A.push({"name":"LBBC","alias":"LBBC","type":"color"});t.A.push({"name":"LIC","alias":"LIC","type":"string"});t.A.push({"name":"LICC","alias":"LICC","type":"color"});t.A.push({"name":"LICTC","alias":"LICTC","type":"color"});}else{if(B.LBC){t.A.push({"name":"LBC","alias":"LBC","type":"color"});}if(B.LBBC){t.A.push({"name":"LBBC","alias":"LBBC","type":"color"});}}if(B.AR){t.A.push({"name":"AR","alias":"AR","type":"boolean"});}if(B.LIC){t.A.push({"name":"LIC","alias":"LIC","type":"string"});}if(B.LP){t.A.push({"name":"LP","alias":"LP","type":"long"});}if(B.TT){t.A.push({"name":"TT","alias":"TT","type":"string"});}if(B.DD){t.A.push({"name":"DD","alias":"DD","type":"string"});}if(B.DS||B.DT){t.N=[];if(B.DS){t.N.push({"name":"DS","A":{"name":"DGT","alias":"A","type":"string"}});}if(B.DT){t.N.push({"name":"DT","A":{"name":"DPT","alias":"A","type":"string"}});}}var p=this.getCustomProperties();for(var i=0;i<p.length;++i){t.A.push({"name":p[i],"alias":p[i],"type":"string"});}return t;};
b.prototype.getDragItemTemplate=function(i){var B=this.mBindInfo;var d=this.getDragSource();var D=[];for(var n=0,a=d.length;n<a;++n){D.push({"type":d[n].getType()});}if(B.DS){D.push({"datasource":i+".DS","type.bind":i+".DS.DGT"});}return D;};
b.prototype.getDropItemTemplate=function(i){var B=this.mBindInfo;var d=this.getDropTarget();var D=[];for(var n=0,a=d.length;n<a;++n){D.push({"type":d[n].getType()});}if(B.DT){D.push({"datasource":i+".DT","type.bind":i+".DT.DPT"});}return D;};
b.prototype.openDetailWindow=function(v,p,u){var P=this.getParent();P.mDTWindowCxt.bUseClickPos=u;P.mDTWindowCxt.open=true;P.mDTWindowCxt.src=v;P.mDTWindowCxt.key=v.getKey();P.mDTWindowCxt.params=p;P.m_bWindowsDirty=true;P.invalidate(this);};
b.prototype.handleChangedData=function(e){if(e&&e.length){for(var n=0,E,i;n<e.length;++n){E=e[n];i=this.findInstance(E.K);if(i){i.handleChangedData(E);}}}};
b.prototype.handleEvent=function(e){var n=e.Action.name;var f="fire"+n[0].toUpperCase()+n.slice(1);var v;if((v=this.findInstance(e.Action.instance))){var a={data:e};if(n.indexOf("handle")===0){a.handle=e.Action.Params.Param[2]['#'];}switch(n){case"click":if(e.Action.AddActionProperties&&e.Action.AddActionProperties.AddActionProperty.length&&e.Action.AddActionProperties.AddActionProperty[0].name=='pos'){v.mClickGeoPos=e.Action.AddActionProperties.AddActionProperty[0]['#'];}break;case"contextMenu":case"handleContextMenu":v.mClickPos=[e.Action.Params.Param[0]['#'],e.Action.Params.Param[1]['#']];sap.ui.getCore().loadLibrary("sap.ui.unified");if(this.oParent.mVBIContext.m_Menus){this.oParent.mVBIContext.m_Menus.deleteMenu("DynContextMenu");}var m=new sap.ui.unified.Menu();m.vbi_data={};m.vbi_data.menuRef="CTM";m.vbi_data.VBIName="DynContextMenu";a.menu=m;break;case"drop":var s=e.Action.Params.Param[0]['#'].split("|");var c=s[1];var i=s[2].split(".")[1];var d=this.getParent().getAggregatorContainer(c).findInstanceByKey(i);a.oDragSource=d;break;default:break;}if(v.mEventRegistry[n]){if(f in v){v[f](a);}else{v.fireEvent(n,a);}}if(this.mEventRegistry[n]){a.instance=v;this[f](a);}}else{jQuery.sap.log.error("Instance for event not found");}};
b.prototype.getChangeType=function(d){var c=0;var i=0;var e=0;var f=this.getItems().length;var a=[];var n,g;for(n=0;n<f;++n){a.push(2);}var h,j,F;for(g=0;g<d.length;++g){if(d[g].type=="delete"){F=false;j=0;h=0;while(!F){if(j==d[g].index&&a[h]!=0){a[h]=0;c++;break;}else if(a[h]!=0){j++;}h++;}}else if(d[g].type=="insert"){if(d[g].index>=f){i++;}else{F=false;j=0;h=0;while(!F){if(j==d[g].index&&a[h]==0){a[h]=2;e++;break;}else if(a[h]!=0){j++;}h++;}}}}if(d.length&&e==c&&c==d.length/2){return 1;}if(c==d.length){return 2;}if(i==d.length){return 3;}return 0;};
b.prototype.unbindAggregation=function(n){if(n==="items"){this.m_bAggRenew=true;}V.prototype.unbindAggregation.apply(this,arguments);};
b.prototype.updateAggregation=function(n){var B=this.mBindingInfos['items'],a=B&&B.binding||null;V.prototype.updateAggregation.apply(this,arguments);if(n==="items"&&a){var v=this.getItems();var i=this.sId;var K="0";var c=a.getCurrentContexts();if(c.diff&&!this.m_bAggChange&&!this.m_bAggRenew){var d=this.getChangeType(c.diff);if(d==2){for(var e=0;e<c.diff.length;++e){var f=c.diff[e].index;K=this.aUniqueIdx[f];var E={K:K};var N={name:i,E:E};var o={name:i,type:"E",N:N};this.aDiff.push({type:"delete",object:o});this.aUniqueIdx.splice(f,1);for(var g=0;g<v.length-1;++g){v[g].UniqueId=this.aUniqueIdx[g];}}this.m_bAggChange=true;}else if(d==3||d==1){for(var h=0;h<c.diff.length;++h){if(c.diff[h].type=="insert"){this.aDiff.push({type:"insert",idx:c.diff[h].index});}}this.m_bAggChange=true;}else{this.m_bAggRenew=true;}}}};
b.prototype.invalidate=function(s){var i;if(!this.m_bAggRenew){this.m_bAggRenew=true;if(s&&this.getParent()){i=this.aUniqueIdx.indexOf(s.UniqueId);if(i>-1){var f=false;for(var n=0;n<this.aDiff.length&&!f;++n){if(this.aDiff[n].type=="insert"&&this.aDiff[n].idx==i){f=true;}}if(!f){this.aDiff.push({type:"insert",idx:i});}this.m_bAggChange=true;this.m_bAggRenew=false;}}}sap.ui.core.Control.prototype.invalidate.apply(this,arguments);};
b.prototype.resetIndices=function(){var v=this.getItems();for(var n=0;n<v.length;++n){v[n].UniqueId=undefined;}};
b.prototype.getUniqueIdx=function(){return(this.currentIdx++);};
b.prototype.updateIdxArray=function(){this.aUniqueIdx=[];var v=this.getItems();for(var n=0;n<v.length;++n){this.aUniqueIdx.push(v[n].UniqueId);}};
b.prototype.addUnique=function(U){this.aUniqueIdx.push(U);};
b.prototype.setCustomProperties=function(p){this._oCPMap=null;return this.setProperty("customProperties",p);};
b.prototype.getCustomPropertiesMap=function(){if(!this._oCPMap){this._oCPMap={};var p=this.getCustomProperties();for(var i=0;i<p.length;++i){this._oCPMap[p[i]]=true;}}return this._oCPMap;};
b.prototype.isSelectable=function(){return this.getMaxSel()!=="0";};
b.prototype.isSubscribed=function(e,i){if(this.hasListeners(e)){return true;}if(i){var a=this.getItems()[i];return a&&a.hasListeners(e);}return false;};
return b;});
sap.ui.predefine('sap/ui/vbm/VoBase',['sap/ui/core/theming/Parameters','sap/ui/core/Element','./library'],function(P,E,l){"use strict";
var V=E.extend("sap.ui.vbm.VoBase",{metadata:{library:"sap.ui.vbm",properties:{key:{type:"string",group:"Misc",defaultValue:null},hotScale:{type:"string",group:"Misc",defaultValue:'1.0;1.0;1.0'},hotDeltaColor:{type:"string",group:"Misc",defaultValue:'RHLSA(0;1.3;1.0;1.0)'},selectColor:{type:"string",group:"Misc",defaultValue:'RHLSA(0.0;1.0;1.0;1.0)'},fxsize:{type:"string",group:"Misc",defaultValue:'true'},fxdir:{type:"string",group:"Misc",defaultValue:'true'},entity:{type:"string",group:"Misc",defaultValue:null},labelText:{type:"string",group:"Misc",defaultValue:null},labelType:{type:"sap.ui.vbm.SemanticType",group:"Behavior",defaultValue:sap.ui.vbm.SemanticType.None},labelBgColor:{type:"string",group:"Misc",defaultValue:'RGB(255;255;255)'},labelBorderColor:{type:"string",group:"Misc",defaultValue:null},labelArrow:{type:"boolean",group:"Misc",defaultValue:false},labelPos:{type:"string",group:"Misc",defaultValue:null},changeable:{type:"boolean",group:"Misc",defaultValue:false},dragData:{type:"string",group:"Misc",defaultValue:null},select:{type:"boolean",group:"Misc",defaultValue:false}},events:{click:{},contextMenu:{parameters:{menu:{type:"sap.ui.unified.Menu"}}},handleMoved:{parameters:{handle:{type:"int"}}},handleContextMenu:{parameters:{handle:{type:"int"},menu:{type:"sap.ui.unified.Menu"}}},handleClick:{parameters:{handle:{type:"int"}}},drop:{parameters:{dragSource:{type:"sap.ui.vbm.VoBase"}}}}}});
V.prototype.openDetailWindow=function(c,o,O){this.oParent.openDetailWindow(this,{caption:c,offsetX:o,offsetY:O},false);};
V.prototype.openContextMenu=function(m){jQuery.sap.log.warning("Implementation missing");};
V.prototype.DefaultColorBad=(P)?P.get("_sap_ui_vbm_shared_ChartBad"):"rgb(211, 32, 48)";V.prototype.DefaultColorCritical=(P)?P.get("_sap_ui_vbm_shared_ChartCritical"):"rgb(225, 123, 36)";V.prototype.DefaultColorGood=(P)?P.get("_sap_ui_vbm_shared_ChartGood"):"rgb(97, 166, 86)";V.prototype.DefaultColorNeutral=(P)?P.get("_sap_ui_vbm_shared_ChartNeutral"):"rgb(132, 143, 148)";
V.prototype.getDataElement=function(){var e={};var t=this.getLabelType();var b=this.oParent.mBindInfo;e.K=this.getUniqueId();if(b.M){e['VB:c']=this.getChangeable();}if(b.HS){e.HS=this.getHotScale();}if(b.HDC){e.HDC=this.getHotDeltaColor();}if(b.SC){e.SC=this.getSelectColor();}if(b.FS){e.FS=this.getFxsize();}if(b.FD){e.FD=this.getFxdir();}if(b.ET){e.ET=this.getEntity();}if(t!=sap.ui.vbm.SemanticType.Hidden){if(b.LT){e.LT=this.getLabelText();}if(b.LBC){e.LBC=this.getLabelBgColor();}if(b.LP){e.LP=this.getLabelPos();}if(b.LBBC){e.LBBC=this.getLabelBorderColor();}if(b.AR){e.AR=this.getLabelArrow();}}if(b.DD){e.DD=this.getDragData();}e['VB:s']=this.getSelect();var a=this.getTooltip();if(a instanceof sap.ui.core.TooltipBase){e.TT="rtt#"+e.K;sap.ui.vbm.VBI.RttMap[e.K]=a;}else{e.TT=(a)?a:"";}var o=this.getLabelProps(t);if(o&&e.LT){if(o.LBC){e.LBC=o.LBC;}if(o.LBBC){e.LBBC=o.LBBC;}if(o.LIC){e.LIC=o.LIC;}if(o.LICC){e.LICC=o.LICC;}if(o.LICTC){e.LICTC=o.LICTC;}}if(!e.LBC){e.LBC="rgba(255,255,255,1.0)";}if(e.LBBC==""){e.LBBC=e.LBC;}var c;if((c=this.getCustomData())){var C,p=this.getParent();if(p.getCustomPropertiesMap&&(C=p.getCustomPropertiesMap())){for(var i=0;i<c.length;++i){var k=c[i].getKey();if(C[k]){e[k]=c[i].getValue();}}}}return e;};
V.prototype.handleChangedData=function(e){};
V.prototype.getDragDropDefs=function(){var b=this.oParent.mBindInfo;var d=[];if(b.DS){var D=this.getDragSource(),s=[];for(var n=0,a=D.length;n<a;++n){s.push({"VB:ix":n,"A":D[n].getType()});}if(s.length){d.push({"name":"DS","E":s});}}if(b.DT){var c=this.getDropTarget(),e=[];for(var f=0,g=c.length;f<g;++f){e.push({"VB:ix":f,"A":c[f].getType()});}if(e.length){d.push({"name":"DT","E":e});}}return d;};
V.prototype.getLabelProps=function(t){var e={};if(t==sap.ui.vbm.SemanticType.None||t==sap.ui.vbm.SemanticType.Default||t==sap.ui.vbm.SemanticType.Hidden){return null;}e.LBC=e.LICTC="rgba(255,255,255,1.0)";switch(t){case sap.ui.vbm.SemanticType.Warning:e.LBBC=e.LICC=this.DefaultColorCritical;e.LIC="message-warning";break;case sap.ui.vbm.SemanticType.Error:e.LBBC=e.LICC=this.DefaultColorBad;e.LIC="message-error";break;case sap.ui.vbm.SemanticType.Success:e.LBBC=e.LICC=this.DefaultColorGood;e.LIC="accept";break;case sap.ui.vbm.SemanticType.Inactive:e.LBBC=e.LICC=this.DefaultColorNeutral;e.LIC="hint";break;default:break;}return e;};
V.prototype.getKey=function(){var k=this.getProperty("key");if(!k){k=this.getUniqueId();}return k;};
V.prototype.invalidate=function(){sap.ui.core.Control.prototype.invalidate.apply(this,arguments);};
V.prototype.getUniqueId=function(){if(this.UniqueId==undefined||this.UniqueId==0){var i=this.getId();var n=i;var m=i.match(/\d+/g);if(m&&m.length){n=i.substring(0,i.lastIndexOf(m[m.length-1]));}this.UniqueId=n+this.getParent().getUniqueIdx();}return this.UniqueId;};
return V;});
sap.ui.predefine('sap/ui/vbm/adapter3d/ModelHandler',["jquery.sap.global","sap/ui/base/Object","./Utilities","./thirdparty/three","./thirdparty/ColladaLoader"],function(q,B,U,T,C){"use strict";var t="sap.ui.vbm.ModelHandler";var l=q.sap.log;var a=T.Box3;var M=T.Matrix4;var p=U.propertyAdded;var b=U.propertyChanged;var u=U.updateProperty;var c=U.addRef;var s=U.subRef;
var d=B.extend("sap.ui.vbm.adapter3d.ModelHandler",{constructor:function(r,f,g,h){B.call(this);this._resources=r;this._textures=f;this._scene=g;this._root=h;this._root.updateWorldMatrix(false,false);this._hotInstance=null;this._instances=new Map();this._models=new Map();this._meshes=new Map();this._colladaLoader=null;this._glTFLoader=null;}});
var e=4000;
d.prototype.destroy=function(){this._resources=null;this._textures=null;this._scene=null;this._root=null;this._meshes.forEach(function(m){m.objects3D.forEach(function(o){this._deleteObject3D(o);},this);},this);this._instances.forEach(function(i){if(i.texture){s(i.texture);}});this._models.forEach(function(m,r){this._deleteModel(m);},this);this._meshes.clear();this._instances.clear();this._models.clear();B.prototype.destroy.call(this);};
d.prototype.addInstance=function(i){this._instances.set(i,{instance:i,world:new M(),matrices:[],model:null,texture:null,key:null,mesh:null});this.updateInstance(i);};
d.prototype.updateInstance=function(i){var f=this._instances.get(i),g=false,h=this._hotInstance&&this._hotInstance===i;if(f){var n=U.toBoolean(i.normalize);if(b(i,"model")){if(!p(i,"model")){this._removeInstanceFromMesh(f);s(f.model);}f.model=this._models.get(i.model);if(!f.model){l.error("Removing broken instance with unknown model",i.model,t);this.removeInstance(i);return;}c(f.model);f.matrices.length=0;g=true;}if(b(i,"texture")){if(!p(i,"texture")){if(f.texture){s(f.texture);f.texture=null;}}if(i.texture){f.texture=this._textures.get(i.texture)||null;if(f.texture){c(f.texture);}else{l.error("Failed to apply texture on model, texture not found",i.texture,t);}}g=true;}if(b(i,["normalize","model"])){this._updateModel(f.model,n);f.matrices.length=0;g=true;}if(b(i,["pos","rot","scale"])){U.getInstanceMatrix(i,f.world,n?f.model.normalized.bbox:f.model.bbox);f.matrices.length=0;g=true;}var k=this._getInstanceKey(i,h);if(!f.key||k!==f.key){this._removeInstanceFromMesh(f);f.key=k;g=true;}u(i,["model","normalize","pos","rot","scale","texture","color","selectColor","hotDeltaColor","VB:s"]);if(f.matrices.length===0){var w=this._root.matrixWorld.clone();w.multiply(f.world);if(n){w.multiply(f.model.normalized.world);}f.model.root.children.forEach(function(j){f.matrices.push(new M().multiplyMatrices(w,j.matrixWorld));});}if(g){this._requestUpdate(f);}}else{l.error("Unable to find model instance data","",t);}};
d.prototype.removeInstance=function(i){var f=this._instances.get(i);if(f){if(this._hotInstance===i){this._hotInstance=null;}this._instances.delete(i);this._removeInstanceFromMesh(f);i._last={};if(f.model){s(f.model);}if(f.texture){s(f.texture);}}else{l.error("Unable to find model instance data","",t);}};
d.prototype.update=function(){var f=[];this._meshes.forEach(function(g,k){for(var i=0;i<g.length;){if(g[i].dirty){var j,h,m=0,n=g[i];n.objects3D.forEach(function(o){this._deleteObject3D(o);},this);n.objects3D.length=n.hitInfo.length=0;if(n.instances.size){n.model.root.children.forEach(function(o){var r=new T.InstancedMesh(o.geometry,U.cloneMaterials(o.material),n.instances.size);r.matrixAutoUpdate=false;r.layers.set(0);r._instanceHitTest=this._instanceHitTest.bind(n);this._scene.add(r);n.objects3D.push(r);},this);n.instances.forEach(function(v){h=v;n.hitInfo.push(h);for(j=0;j<n.objects3D.length;++j){n.objects3D[j].setMatrixAt(m,h.matrices[j]);}m++;});U.applyColor(h.instance,h.instance.color,n.objects3D,this._hotInstance===h.instance,h.texture);}n.dirty=false;}if(g[i].objects3D.length!==0){i++;}else{g.splice(i,1);}}if(!g.length){f.push(k);}},this);f.forEach(function(k){this._meshes.delete(k);},this);this._models.forEach(function(m,r){if(U.refCountableDispose(m)){this._deleteModel(m);this._models.delete(r);}},this);};
d.prototype.updateHotInstance=function(i){var f;if(this._hotInstance){f=this._instances.get(this._hotInstance);f.key=this._getInstanceKey(this._hotInstance,false);this._removeInstanceFromMesh(f);this._requestUpdate(f);}if(i&&i.isModel){f=this._instances.get(i);f.key=this._getInstanceKey(i,true);this._removeInstanceFromMesh(f);this._requestUpdate(f);}this._hotInstance=(i&&i.isModel)?i:null;};
d.prototype.addModel=function(i){if(i.isModel&&i.model&&!this._models.has(i.model)){this._models.set(i.model,{root:null,bbox:null,normalized:null});}};
d.prototype.loadModels=function(){var f=[];this._models.forEach(function(g,r){if(!g.root){f.push(this._loadModel(r,g));}},this);return Promise.all(f);};
d.prototype._loadModel=function(r,f){var g=this;var h=this._resources.get(r);if(!h){l.error("Failed to get model from context",r,t);this._models.delete(r);return Promise.resolve();}return new Promise(function(i,j){if(atob(h.slice(0,6)).startsWith("glTF")){try{g._getGlTFLoader().parse(U.base64ToArrayBuffer(h),"",function(m){g._postprocess(m,f);i();});}catch(k){g._models.delete(r);l.error("Failed to load glb model",r,t);i();}}else{try{g._postprocess(g._getColladaLoader().parse(atob(h)),f);i();}catch(k){try{g._getGlTFLoader().parse(atob(h),"",function(m){g._postprocess(m,f);i();});}catch(k){g._models.delete(r);l.error("Failed to load collada/gltf model",r,t);i();}}}});};
d.prototype._postprocess=function(m,f){m.scene.scale.set(1,1,-1);var g=[],h=new Set(),i="_sapUsed";m.scene.traverse(function(o){o.updateWorldMatrix(false,false);var j=o.isMesh&&o.visible;if(j){g.push(o);}else if(o.geometry){o.geometry.dispose();}U.toArray(o.material).forEach(function(k){if(j||!k[i]){k[i]=j;}h.add(k);});});h.forEach(function(j){if(!j[i]){for(var k in j){if(k instanceof T.Texture){k.dispose();}}j.dispose();}});f.root=new T.Group();g.forEach(function(j){j.remove(j.children);f.root.add(j);j.matrixWorld.decompose(j.position,j.quaternion,j.scale);});};
d.prototype._requestUpdate=function(f){if(f.mesh){f.mesh.dirty=true;}else{var m=this._meshes.get(f.key);if(!m){m=[];this._meshes.set(f.key,m);}for(var i=0;i<m.length;++i){if(m[i].instances.size<e){f.mesh=m[i];break;}}if(!f.mesh){f.mesh={dirty:true,model:f.model,hitInfo:[],objects3D:[],instances:new Set()};m.push(f.mesh);}f.mesh.instances.add(f);f.mesh.dirty=true;}};
d.prototype._updateModel=function(m,n){if(n){if(!m.normalized){m.normalized={bbox:new a(),world:new M()};U.normalizeObject3D(m.root,m.normalized.world,m.normalized.bbox);}}else if(!m.bbox){m.bbox=new a().setFromObject(m.root);}};
d.prototype._deleteModel=function(m){m.root.children.forEach(function(f){f.geometry.dispose();U.toArray(f.material).forEach(function(g){for(var h in g){if(h instanceof T.Texture){h.dispose();}}g.dispose();});},this);};
d.prototype._removeInstanceFromMesh=function(f){if(f.mesh){if(f.mesh.instances.delete(f)){f.mesh.dirty=true;f.mesh=null;}else{l.error("Unable to find instance data in polygon mesh data","",t);}}};
d.prototype._deleteObject3D=function(o){if(o){if(o.parent){o.parent.remove(o);}U.toArray(o.material).forEach(function(m){m.dispose();});}};
d.prototype._getInstanceKey=function(i,h){var f=U.toBoolean(i["VB:s"]);var k=i.texture?"_texture_"+i.texture:"";var g="_color_"+i.color.toLowerCase();var j=f?"_selected_"+i.selectColor.toLowerCase():"";var m=h?"_hot_"+i.hotDeltaColor.toLowerCase():"";return i.model+k+g+j+m;};
d.prototype.getTarget=function(i){var f=this._instances.get(i);if(f){var m=new T.Mesh(f.model.root.children[0].geometry.clone());var w=f.world.clone();if(f.model.normalized){w.multiply(f.model.normalized.world);}w.multiply(f.model.root.children[0].matrixWorld);w.decompose(m.position,m.quaternion,m.scale);m.updateMatrix();this._root.add(m);return m;}return null;};
d.prototype._instanceHitTest=function(h){if(h.instanceId>=0){var f=this.hitInfo[h.instanceId];h.world=f.matrices[h.instanceId];return f.instance;}return null;};
d.prototype._getColladaLoader=function(){return this._colladaLoader||(this._colladaLoader=new T.ColladaLoader());};
d.prototype._getGlTFLoader=function(){return this._glTFLoader||(this._glTFLoader=new T.GLTFLoader());};
return d;});
sap.ui.predefine('sap/ui/vbm/adapter3d/PolygonHandler',["jquery.sap.global","sap/ui/base/Object","./Utilities","./thirdparty/three"],function(q,B,U,T){"use strict";var t="sap.ui.vbm.PolygonHandler";var l=q.sap.log;var V=T.Vector3;var M=T.Matrix4;var p=U.propertyAdded;var a=U.propertyRemoved;var b=U.propertyChanged;var u=U.updateProperty;var g=U.getColor;var r=U.rgbaToString;var e=U.equalsRGBA;var c=U.createMaterial;var d=U.createLineMaterial;
var P=B.extend("sap.ui.vbm.adapter3d.PolygonHandler",{constructor:function(i){B.call(this);this._root=i;this._hotInstance=null;this._instances=new Map();this._meshes=new Map();this._borders=new Map();}});
var f=2000;var h=2000;
P.prototype.destroy=function(){this._root=null;this._instances.clear();this._meshes.forEach(function(k,i){i.forEach(function(m){this._deleteObject3D(m.object3D);},this);},this);this._borders.forEach(function(k,i){i.forEach(function(j){this._deleteObject3D(j.object3D);},this);},this);this._meshes.clear();this._borders.clear();B.prototype.destroy.call(this);};
P.prototype.update=function(){var i=this._updateMeshes()||false;i=this._updateBorders()||i;if(this._hotInstance&&i){this._updateHot(this._hotInstance,true);}};
P.prototype.addInstance=function(i){this._instances.set(i,{instance:i,indices:[],vertices:[],normal:null,lines:null,matrix:new M(),color:null,colorHot:null,colorBorder:null,colorBorderHot:null,mesh:null,border:null});this.updateInstance(i);};
P.prototype.updateInstance=function(i){var j=this._instances.get(i),k=false,m=false;if(j){if(b(i,["pos","rot","scale"])){U.getInstanceMatrix(i,j.matrix);k=m=true;}if(b(i,"OuterNormal")){j.normal=U.toVector3(i.OuterNormal||"0;0;1").normalize();k=true;}if(b(i,"posarray")){this._getGeometry(i,j.indices,j.vertices);k=m=true;}if(b(i,["color","selectColor","VB:s"])){var n=g(i,i.color,false);if(!j.color||!e(n,j.color)){this._removeInstanceFromMesh(j);j.color=n;j.colorHot=g(i,i.color,true);k=true;}}if(a(i,"colorBorder")){this._removeInstanceFromBorder(j);j.lines=j.colorBorder=j.colorBorderHot=null;}else if(i.colorBorder){if(p(i,"colorBorder")||b(i,"posarray")){j.lines=this._getBorderGeometry(j.indices,j.vertices);m=true;}if(b(i,["colorBorder","selectColor,","VB:s"])){var o=g(i,i.colorBorder,false);if(!j.colorBorder||!e(o,j.colorBorder)){this._removeInstanceFromBorder(j);j.colorBorder=o;j.colorBorderHot=g(i,i.colorBorder,true);m=true;}}}if(b(i,"hotDeltaColor")){j.colorHot=g(i,i.color,true);if(j.colorBorder){j.colorBorderHot=g(i,i.colorBorder,true);}}u(i,["pos","rot","scale","OuterNormal","posarray","color","colorBorder","selectColor","hotDeltaColor","VB:s"]);if(k){this._requestMeshUpdate(j);}if(i.colorBorder){if(m){this._requestBorderUpdate(j);}}}else{l.error("Unable to find polygon instance data","",t);}};
P.prototype.removeInstance=function(i){var j=this._instances.get(i);if(j){if(this._hotInstance===i){this._hotInstance=null;}this._instances.delete(i);this._removeInstanceFromMesh(j);this._removeInstanceFromBorder(j);i._last={};}else{l.error("Unable to find polygon instance data","",t);}};
P.prototype.updateHotInstance=function(i){if(this._hotInstance){this._updateHot(this._hotInstance,false);}if(i&&i.isPolygon){this._updateHot(i,true);}this._hotInstance=(i&&i.isPolygon)?i:null;};
P.prototype._updateHot=function(i,j){var k=this._instances.get(i),m,o,n,s;if(k){if(k.mesh){m=k.mesh.material;o=k.mesh.object3D;n=o.geometry;if(n.groups.length){n.groups=[];o.material=o.material[0];}if(j){s=k.mesh.instances.get(k);m.color.copy(k.colorHot.rgb);m.opacity=k.colorHot.opacity;m.transparent=m.opacity<1;m.needsUpdate=true;o.material=[o.material,m];n.addGroup(s.start,k.indices.length,1);if(s.start!==0){n.addGroup(0,s.start,0);}if(s.start+k.indices.length<n.index.count){n.addGroup(s.start+k.indices.length,n.index.count-s.start-k.indices.length,0);}}}if(k.border){m=k.border.material;o=k.border.object3D;n=o.geometry;var v=n.getAttribute("position");if(n.groups.length){n.groups=[];o.material=o.material[0];}if(j){s=k.border.instances.get(k);m.color.copy(k.colorBorderHot.rgb);m.opacity=k.colorBorderHot.opacity;m.transparent=m.opacity<1;m.needsUpdate=true;o.material=[o.material,m];var w=k.lines.length/3;n.addGroup(s.start,w,1);if(s.start!==0){n.addGroup(0,s.start,0);}if(s.start+w<v.count){n.addGroup(s.start+w,v.count-s.start-w,0);}}}}else{l.error("Unable to find polygon instance data","",t);}};
P.prototype._getGeometry=function(j,k,v){var i,m=[],n=j.posarray.split(";");v.length=k.length=0;for(i=0;i<n.length/3;++i){var x=parseFloat(n[i*3+0]);var y=parseFloat(n[i*3+1]);var z=parseFloat(n[i*3+2]);m.push(new T.Vector2(x,y));v.push(x,y,z);}var o=T.ShapeUtils.triangulateShape(m,[]);for(i=0;i<o.length;++i){k.push(o[i][0],o[i][1],o[i][2]);}};
P.prototype._getBorderGeometry=function(i,v){var j=new T.BufferGeometry();j.setIndex(i);j.setAttribute("position",new T.Float32BufferAttribute(v,3));var k=new T.EdgesGeometry(j);var m=k.getAttribute("position").array;k.dispose();j.dispose();return m;};
P.prototype._updateMeshes=function(){var k=[],m=false,n=this._hotInstance?this._instances.get(this._hotInstance):null;this._meshes.forEach(function(o,s){for(var i=0;i<o.length;){if(o[i].dirty){var j,v,w,x=[],y=[],z=[],A=o[i];this._deleteObject3D(A.object3D);A.object3D=null;A.hitInfo.length=0;A.instances.forEach(function(E,F){v=F;E.start=x.length;for(j=0,w=y.length/3;j<v.indices.length;++j){x.push(w+v.indices[j]);}var G=v.indices.length/3;A.hitInfo.length+=G;A.hitInfo.fill(v.instance,A.hitInfo.length-G,A.hitInfo.length);if(v.matrix._identity){for(j=0;j<v.vertices.length/3;++j){y.push(v.vertices[j*3],v.vertices[j*3+1],v.vertices[j*3+2]);z.push(v.normal.x,v.normal.y,v.normal.z);}}else{var H=new V();for(j=0;j<v.vertices.length/3;++j){H.set(v.vertices[j*3],v.vertices[j*3+1],v.vertices[j*3+2]);H.applyMatrix4(v.matrix);y.push(H.x,H.y,H.z);z.push(v.normal.x,v.normal.y,v.normal.z);}}});if(x.length){var C=new T.BufferGeometry();C.setIndex(x);C.setAttribute("position",new T.Float32BufferAttribute(y,3));C.setAttribute("normal",new T.Float32BufferAttribute(z,3));C.computeBoundingBox();C.computeBoundingSphere();var D=c(true);D.color.copy(v.color.rgb);D.opacity=v.color.opacity;D.transparent=D.opacity<1;D.needsUpdate=true;A.object3D=new T.Mesh(C,D);A.object3D.matrixAutoUpdate=false;A.object3D.layers.set(0);this._root.add(A.object3D);A.object3D._instanceHitTest=this._instanceHitTest.bind(A);A.triangleCount=x.length/3;}if(n&&A.instances.has(n)){m=true;}A.dirty=false;}if(o[i].object3D){i++;}else{o.splice(i,1);}}if(!o.length){k.push(s);}},this);k.forEach(function(i){this._meshes.delete(i);},this);return m;};
P.prototype._updateBorders=function(){var k=[],m=false,n=this._hotInstance?this._instances.get(this._hotInstance):null;this._borders.forEach(function(o,s){for(var i=0;i<o.length;){if(o[i].dirty){var j,v,w=[],x=o[i];this._deleteObject3D(x.object3D);x.object3D=null;x.instances.forEach(function(A,C){v=C;A.start=w.length/3;if(v.matrix._identity){for(j=0;j<v.lines.length;++j){w.push(v.lines[j]);}}else{var D=new V();for(j=0;j<v.lines.length/3;++j){D.set(v.lines[j*3],v.lines[j*3+1],v.lines[j*3+2]);D.applyMatrix4(v.matrix);w.push(D.x,D.y,D.z);}}});if(w.length){var y=new T.BufferGeometry();y.setAttribute("position",new T.Float32BufferAttribute(w,3));y.computeBoundingBox();var z=d();z.color.copy(v.colorBorder.rgb);z.opacity=v.colorBorder.opacity;z.transparent=z.opacity<1;z.needsUpdate=true;x.object3D=new T.LineSegments(y,z);x.object3D.matrixAutoUpdate=false;x.object3D.layers.set(1);this._root.add(x.object3D);x.lineCount=w.length/6;}if(n&&x.instances.has(n)){m=true;}x.dirty=false;}if(o[i].object3D){i++;}else{o.splice(i,1);}}if(!o.length){k.push(s);}},this);k.forEach(function(i){this._borders.delete(i);},this);return m;};
P.prototype._requestMeshUpdate=function(j){if(j.mesh){j.mesh.dirty=true;}else{var k=r(j.color);var m=this._meshes.get(k);if(!m){m=[];this._meshes.set(k,m);}for(var i=0;i<m.length;++i){if(m[i].triangleCount+j.indices.length/3<=f){j.mesh=m[i];break;}}if(!j.mesh){j.mesh={dirty:true,object3D:null,material:c(true),triangleCount:0,hitInfo:[],instances:new Map()};m.push(j.mesh);}j.mesh.instances.set(j,{start:0});j.mesh.dirty=true;j.mesh.triangleCount+=j.indices.length/3;}};
P.prototype._requestBorderUpdate=function(j){if(j.border){j.border.dirty=true;}else{var k=r(j.colorBorder);var m=this._borders.get(k);if(!m){m=[];this._borders.set(k,m);}for(var i=0;i<m.length;++i){if(m[i].lineCount+j.lines.length/6<=h){j.border=m[i];break;}}if(!j.border){j.border={dirty:true,object3D:null,material:d(),lineCount:0,instances:new Map()};m.push(j.border);}j.border.instances.set(j,{start:0});j.border.dirty=true;j.border.lineCount+=j.lines.length/6;}};
P.prototype._removeInstanceFromMesh=function(i){if(i.mesh){if(i.mesh.instances.delete(i)){i.mesh.triangleCount-=i.indices.length/3;i.mesh.dirty=true;i.mesh=null;}else{l.error("Unable to find instance data in polygon mesh data","",t);}}};
P.prototype._removeInstanceFromBorder=function(i){if(i.border){if(i.border.instances.delete(i)){i.border.lineCount-=i.lines.length/6;i.border.dirty=true;i.border=null;}else{l.error("Unable to find instance data in polygon border data","",t);}}};
P.prototype._deleteObject3D=function(o){if(o){if(o.parent){o.parent.remove(o);}if(o.geometry){o.geometry.dispose();}U.toArray(o.material).forEach(function(m){m.dispose();});}};
P.prototype._instanceHitTest=function(i){return i.faceIndex>=0?this.hitInfo[i.faceIndex]:null;};
return P;});
sap.ui.predefine('sap/ui/vbm/adapter3d/VBIJSONParser',["jquery.sap.global","sap/ui/base/Object","./Utilities","./ObjectFactory","./../library"],function(q,B,U,O,l){"use strict";var a=q.sap.log;var t="sap.ui.vbm.VBIJSONParser";var b=U.toArray;
var V=B.extend("sap.ui.vbm.adapter3d.VBIJSONParser",{constructor:function(e){B.call(this);this._context=e;this._factory=new O();}});
V.prototype.loadVBIJSON=function(p){if(p&&p.SAPVB){if(p.SAPVB.Resources){this._processResources(p.SAPVB.Resources);}if(p.SAPVB.DataTypes){this._processDataTypes(p.SAPVB.DataTypes);}if(p.SAPVB.Data){this._processData(p.SAPVB.Data);}if(p.SAPVB.Scenes){this._processScenes(p.SAPVB.Scenes);}if(p.SAPVB.Windows){this._processWindows(p.SAPVB.Windows);}if(p.SAPVB.Actions){this._processActions(p.SAPVB.Actions);}if(p.SAPVB.Automation){this._processAutomation(p.SAPVB.Automation);}if(p.SAPVB.Data||p.SAPVB.Scenes){this._refreshVisualObjects();}}return this;};
var c=function(e,s,f,g){g=b(g);for(var i=0,h=f.length;i<h;++i){var j=f[i];var k=g.length>i?g[i]:j;if(s.hasOwnProperty(j)){e[k]=s[j];}}return e;};
V.prototype._processResources=function(r){b(r.Set.Resource).forEach(function(e){this._context.resources.set(e.name,e.value);},this);return this;};
V.prototype._processDataTypes=function(e){if(e&&e.Set&&!Array.isArray(e.Set)&&!e.Set.name){this._context.dataTypes.splice(0);var f=function(g){var h=c(this._factory.createDataType(),g,["name","key","minSel","maxSel"]);b(g.A).forEach(function(i){h.attributes.push(c(this._factory.createDataTypeAttribute(),i,["name","alias","type"]));},this);b(g.N).forEach(function(i){h.dataTypes.push(f(i));});return h;}.bind(this);b(e.Set.N).forEach(function(g){this._context.dataTypes.push(f(g));},this);}else{a.error("DataTypes: only the Set verb with no type attribute is supported.","",t);}return this;};
V.prototype._findDataTypeByPath=function(p){var f=function(e,g){if(g>p.length){return undefined;}var h=p[g-1];for(var i=0,j=e.length;i<j;++i){var k=e[i];if(k.name===h){if(g===p.length){return k;}else{return f(k.dataTypes,g+1);}}}return undefined;};return f(this._context.dataTypes,1);};
V.prototype._findDataTypeByDataNodePath=function(e){var f=[];for(var i=0,g=(e.length+1)/2;i<g;++i){f.push(e[i*2]);}return this._findDataTypeByPath(f);};
V.prototype._processData=function(e){b(e.Remove).forEach(function(r){if(r.type!=="E"){a.error("Data: the Remove verb is supported for the 'E' type only.",r.type,t);return;}if(!r.name){a.error("Data: the Remove verb must have the non-empty name attribute.","",t);return;}var g=this._findDataTypeByPath(r.name.split("."));if(!g){a.error("Data: the Remove verb is supported for data nodes with data types only.",r.name,t);return;}var k=g.getKeyAttribute();if(!k){a.error("Data: the Remove verb is supported for data types with keys only.",r.name,t);return;}var h=b(r.N.E).map(function(j){return j[k.alias];});var i=this._findDataNodeByPath(r.name.split("."));if(!i){if(h.length>0){a.warning("Data: unknown data node.",r.name,t);}return;}this._removeDataInstancesByKey(i,k.name,h);},this);var f=function(g,n,h){var i=this._findDataTypeByPath(h);var k=i&&i.getKeyAttribute();b(n.E).forEach(function(j,m){var o=k?sap.ui.vbm.findInArray(g,function(o){return o[k.name]===j[k.alias];}):g[m];if(!o){o=this._factory.createDataInstance();if(k){g.push(o);}else{g[m]=o;}}o.isDirty=true;for(var p in j){if(p==="N"){if(j.N.name){f(o[j.N.name]||(o[j.N.name]=this._factory.createDataNode()),j.N,h.concat(j.N.name));}else{a.error("Data: child data nodes must have names.","",t);}}else{var r=i.getAttributeByAlias(p);if(r){o[r.name]=j[p];}else{o[p]=j[p];}}}},this);}.bind(this);var s=b(e.Set);if(s.length===1&&!s[0].name){this._removeAllDataNodes();b(s.N).forEach(function(n){f((this._context.data[n.name]=this._factory.createDataInstance()),n,[n.name]);},this);}else if(s.length>0){if(s.some(function(g){return!g.name;})){a.error("Data: if there are multiple Set verbs then all Set verbs must have the non-empty name attribute.","",t);return this;}if(s.some(function(g){return!g.N||b(g.N).length>1;})){a.error("Data: all Set verbs with the name attribute must have the single N element.","",t);return this;}s.forEach(function(g){var n=g.name.split(".");f(this._findDataNodeByPath(n)||(this._context.data[g.name]=this._factory.createDataNode()),g.N,[n[0]]);},this);}return this;};
V.prototype._findDataNodeByPath=function(p){if(p.length>1){a.error("Compound paths for data nodes are not supported yet.",p,t);return undefined;}return this._context.data[p[0]];};
V.prototype._getDataValueByPath=function(p){if(p.length%2!==1){a.error("The absolute path to data value must contain an odd number of elements.",p.join("."),t);return undefined;}var e;var f;for(var i=0,g=p.length;i<g;++i){var h=p[i];if(i%2===0){if(i===g-1){return f&&f[h];}else{e=(i==0?this._context.data:f)[h];if(e===undefined){return undefined;}}}else{f=e[h];if(f===undefined){return undefined;}}}return undefined;};
V.prototype._removeAllDataNodes=function(){for(var e in this._context.data){this._clearDataNode(this._context.data[e]);delete this._context.data[e];}return this;};
V.prototype._clearDataNode=function(e){e.splice(0).forEach(this._clearDataInstance,this);return this;};
V.prototype._clearDataInstance=function(e){if(e.visualObject){this._removeVisualObject(e.visualObject);}for(var p in e){if(Array.isArray(e[p])){this._clearDataNode(e[p]);delete e[p];}}return this;};
V.prototype._removeDataInstancesByKey=function(e,f,g){for(var i=e.length-1;i>=0&&g.length>0;--i){var h=e[i];var j=h[f];for(var k=g.length-1;k>=0;--k){if(j===g[k]){this._clearDataInstance(h);e.splice(i,1);g.splice(k,1);break;}}}return this;};
V.prototype._processScenes=function(e){var f=function(g,h){c(g,h,["id","type","initialStartPosition","initialPitch","initialYaw","initialZoom"],["id","type","position","pitch","yaw","zoom"]);if(g.position||g.zoom||g.pitch||g.yaw){this._context.setupView={position:g.position,zoom:g.zoom,pitch:g.pitch,yaw:g.yaw,home:true,flyTo:false};}b(h.VO).forEach(function(v){var i=g.getVisualObjectGroupById(v.id);if(!i){i=this._factory.createVisualObjectGroup(g);for(var p in v){switch(p){case"id":case"datasource":case"type":i[p]=v[p];break;case"DragSource":case"DropTarget":break;default:if(p.endsWith(".bind")){i.isDataBound=true;var j=p.split(".")[0];var k=v[p].split(".");if(v["datasource"]){k.shift();}i.template[j]={path:k};}else{i.template[p]={value:v[p]};}break;}}}else{a.warning("Scenes: cannot modify existing VO group.",v.id,t);}},this);return g;}.bind(this);if(e.Remove){this._removeScenes(b(e.Remove).map(function(r){return r.name;}));}if(e.Set){var s=b(e.Set);if(s.length===1&&!s[0].name){this._removeScenes(this._context.scenes.map(function(g){return g.id;}));}else if(s.length>0){if(s.some(function(g){return!g.name;})){a.error("Scenes: if there are multiple Set verbs then all Set verbs must have the non-empty name attribute.","",t);return this;}if(s.some(function(g){return!g.Scene||b(g.Scene).length>1;})){a.error("Scene: all Set verbs with the name attribute must have the single Scene element.","",t);return this;}if(s.some(function(g){return g.name!==g.Scene.id;})){a.error("Scene: the Set's attribute 'name' must equal the Set.Scene's attribute 'id'.","",t);return this;}this._removeScenes(s.map(function(g){return g.name;}));}s.forEach(function(g){b(g.Scene||g.SceneGeo).forEach(function(h){var i=this._factory.createScene(!!g.SceneGeo);f(i,h);this._context.scenes.push(i);this._context.sceneQueues.toAdd.push(i);},this);},this);}if(e.Merge){var m=b(e.Merge);if(m.length>0){if(m.some(function(g){return!g.name;})){a.error("Scenes: all Merge elements must have the name attribute.","",t);return this;}if(m.some(function(g){return!g.Scene||b(g.Scene).length>1;})){a.error("Scenes: all Merge verbs must have the single Scene element.","",t);return this;}if(m.some(function(g){return g.name!==g.Scene.id;})){a.error("Scenes: the Merge's attribute 'name' must equal the Merge.Scene's attribute 'id'.","",t);return this;}m.forEach(function(g){b(g.Scene||g.SceneGeo).forEach(function(h){var i=this._findSceneById(g.name);if(i){f(i,h);this._context.sceneQueues.toUpdate.push(i);}},this);},this);}}return this;};
V.prototype._findSceneById=function(e){for(var i=0,f=this._context.scenes.length;i<f;++i){var s=this._context.scenes[i];if(s.id===e){return s;}}return undefined;};
V.prototype._removeScenes=function(e){for(var i=this._context.scenes.length-1;i>=0&&e.length>0;--i){var s=this._context.scenes[i];var f=s.id;for(var k=e.length-1;k>=0;--k){if(e[k]===f){this._context.sceneQueues.toRemove.push(s);this._context.scenes.splice(i,1);e.splice(k,1);s.voGroups.forEach(function(v){for(var i=v.vos.length-1;i>=0;--i){this._removeVisualObject(v.vos[i]);}},this);break;}}}return this;};
V.prototype._processVisualObjectGroup=function(v){if(v.isDataBound&&v.datasource){var e=v.datasource.split(".");var f=this._findDataNodeByPath(e);if(f){var g=this._findDataTypeByDataNodePath(e);if(g){v.maxSel=g.maxSel;v.minSel=g.minSel;var k=g.getKeyAttribute();if(k){v.keyAttributeName=k.name;}}f.forEach(function(h){if(h.visualObject){if(h.isDirty||v.isDirty){this._queueVisualObjectToUpdate(v.scene,this._populateVisualObject(h.visualObject,h));}}else{this._queueVisualObjectToAdd(v.scene,this._populateVisualObject(this._factory.createVisualObject(v),h));}},this);}}else if(v.vos.length===0){this._queueVisualObjectToAdd(v.scene,this._populateVisualObject(this._factory.createVisualObject(v)));}else if(v.vos.length===1){this._queueVisualObjectToUpdate(v.scene,this._populateVisualObject(v.vos[0]));}return this;};
V.prototype._removeVisualObject=function(v){var g=v.voGroup.vos;var i=g.indexOf(v);if(i>=0){g.splice(i,1);}var e=v.voGroup.selected;var s=e.indexOf(v);if(s>=0){e.splice(s,1);}var f=v.voGroup.scene;v.voGroup=null;if(v.dataInstance){v.dataInstance.visualObject=null;v.dataInstance=null;}this._queueVisualObjectToRemove(f,v);return this;};
V.prototype._populateVisualObject=function(v,e){var f=v.voGroup;var g=f.template;for(var h in g){var i=g[h],j;if("path"in i){if(e){j=e[i.path[0]];if(j!==undefined){v[h]=j;}}else{j=this._getDataValueByPath(i.path);if(j!=undefined){v[h]=j;}}}else{v[h]=i.value;}}if(e){if(f.keyAttributeName){v.id=e[f.keyAttributeName];}e.visualObject=v;v.dataInstance=e;var w=v["VB:s"]&&v["VB:s"]!=="false"?true:false;var k=e["VB:s"]&&e["VB:s"]!=="false"?true:false;if(w!==k){if(w){if(f.minSel==="0"||f.selected.length>1){f.selected.splice(f.selected.indexOf(v),1);v["VB:s"]="false";}}else if(f.maxSel!=="0"){if(f.maxSel==="1"){f.selected.splice(0).forEach(function(m){m["VB:s"]="false";this._queueVisualObjectToUpdate(f.scene,m);},this);}f.selected.push(v);v["VB:s"]="true";}}}return v;};
var d=function(e,s,v){if(e.has(s)){e.get(s).push(v);}else{e.set(s,[v]);}return v;};
V.prototype._queueVisualObjectToAdd=function(s,v){d(this._context.voQueues.toAdd,s,v);return this;};
V.prototype._queueVisualObjectToUpdate=function(s,v){d(this._context.voQueues.toUpdate,s,v);return this;};
V.prototype._queueVisualObjectToRemove=function(s,v){d(this._context.voQueues.toRemove,s,v);return this;};
V.prototype._refreshVisualObjects=function(){this._context.scenes.forEach(function(s){s.voGroups.forEach(this._processVisualObjectGroup,this);},this);this._resetDirtyFlag();return this;};
V.prototype._processWindows=function(e){var f=function(g){for(var i=0,h=this._context.windows.length;i<h;++i){var w=this._context.windows[i];if(w.id===g){return{window:w,index:i};}}return{};}.bind(this);if(e.Remove){b(e.Remove).forEach(function(r){var g=f(r.name);if(g.window){this._context.windows.splice(g.index,1);this._context.windowQueues.toRemove.push(g.window);}},this);}if(e.Set){var s=b(e.Set);if(s.length===1&&!s[0].name){this._context.windows.splice(0).forEach(function(w){this._context.windowQueues.toRemove.push(w);},this);}else if(s.length>0){if(s.some(function(g){return!g.name;})){a.error("Windows: if there are multiple Set verbs then all Set verbs must have the non-empty name attribute.","",t);return this;}if(s.some(function(g){return!g.Window||b(g.Window).length>1;})){a.error("Window: all Set verbs with the name attribute must have the single Window element.","",t);return this;}if(s.some(function(g){return g.name!==g.Window.id;})){a.error("Window: the Set's attribute 'name' must equal the Set.Window's attribute 'id'.","",t);return this;}}s.forEach(function(g){b(g.Window).forEach(function(w){var h=f(w.id).window;if(h){this._context.windowQueues.toUpdate.push(h);}else{h=this._factory.createWindow();this._context.windows.push(h);this._context.windowQueues.toAdd.push(h);}c(h,w,["id","type","caption","refScene","refParent","width","height","modal"]);if("pos.bind"in w){h.pos=this._getDataValueByPath(w["pos.bind"]);}else if("pos"in w){h.pos=w.pos;}},this);},this);}return this;};
V.prototype._processActions=function(e){if(e&&e.Set&&e.Set.Action){Array.prototype.push.apply(this._context.actions,b(e.Set.Action));}return this;};
V.prototype._processAutomation=function(e){if(e&&e.Call){b(e.Call).forEach(function(f){switch(f.handler){case"FLYTOHANDLER":var g=b(f.Param);var h=sap.ui.vbm.findInArray(this._context.scenes,function(s){return s.id===(sap.ui.vbm.findInArray(g,function(p){return p.name==="scene";})||{})["#"]||"";});if(h){var i=(sap.ui.vbm.findInArray(g,function(p){return p.name==="x";})||{})["#"]||"0";var o=(sap.ui.vbm.findInArray(g,function(p){return p.name==="y";})||{})["#"]||"0";var j=(sap.ui.vbm.findInArray(g,function(p){return p.name==="z";})||{})["#"]||"0";h.position=i+";"+o+";"+j;h.zoom=(sap.ui.vbm.findInArray(g,function(p){return p.name==="lod";})||{})["#"]||"0";h.pitch=(sap.ui.vbm.findInArray(g,function(p){return p.name==="pitch";})||{})["#"]||"0";h.yaw=(sap.ui.vbm.findInArray(g,function(p){return p.name==="yaw";})||{})["#"]||"0";this._context.setupView={position:h.position,zoom:h.zoom,pitch:h.pitch,yaw:h.yaw,flyTo:true};}break;default:break;}},this);}return this;};
V.prototype._resetDirtyFlag=function(){for(var p in this._context.data){(function traverseDataNode(n){n.forEach(function(i){i.isDirty=false;for(var p in i){if(Array.isArray(i[p])){traverseDataNode(i[p]);}}});})(this._context.data[p]);}this._context.scenes.forEach(function(s){s.voGroups.forEach(function(v){v.isDirty=false;});});return this;};
return V;});
sap.ui.predefine('sap/ui/vbm/library',['sap/ui/core/Core','sap/ui/core/library'],function(C,L){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.vbm",dependencies:["sap.ui.core"],types:["sap.ui.vbm.ClusterInfoType","sap.ui.vbm.SemanticType"],interfaces:[],controls:["sap.ui.vbm.AnalyticMap","sap.ui.vbm.GeoMap","sap.ui.vbm.VBI","sap.ui.vbm.Cluster","sap.ui.vbm.Viewport"],elements:["sap.ui.vbm.Area","sap.ui.vbm.Areas","sap.ui.vbm.Box","sap.ui.vbm.Boxes","sap.ui.vbm.Circle","sap.ui.vbm.Circles","sap.ui.vbm.Container","sap.ui.vbm.Containers","sap.ui.vbm.DragSource","sap.ui.vbm.DropTarget","sap.ui.vbm.Feature","sap.ui.vbm.FeatureCollection","sap.ui.vbm.GeoJsonLayer","sap.ui.vbm.GeoCircle","sap.ui.vbm.GeoCircles","sap.ui.vbm.Legend","sap.ui.vbm.LegendItem","sap.ui.vbm.Pie","sap.ui.vbm.PieItem","sap.ui.vbm.Pies","sap.ui.vbm.Region","sap.ui.vbm.Resource","sap.ui.vbm.Route","sap.ui.vbm.Routes","sap.ui.vbm.Spot","sap.ui.vbm.Spots","sap.ui.vbm.VoAggregation","sap.ui.vbm.VoBase","sap.ui.vbm.ClusterBase","sap.ui.vbm.ClusterTree","sap.ui.vbm.ClusterGrid","sap.ui.vbm.ClusterDistance","sap.ui.vbm.Heatmap","sap.ui.vbm.HeatPoint","sap.ui.vbm.ClusterContainer","sap.ui.vbm.Adapter","sap.ui.vbm.Adapter3D"],version:"1.71.11"});jQuery.sap.registerModuleShims({"sap/ui/vbm/adapter3d/thirdparty/three":{amd:true,exports:"THREE"},"sap/ui/vbm/adapter3d/thirdparty/ColladaLoader":{exports:"THREE.ColladaLoader",deps:["sap/ui/vbm/adapter3d/thirdparty/three"]},"sap/ui/vbm/adapter3d/thirdparty/OrbitControls":{exports:"THREE.OrbitControls",deps:["sap/ui/vbm/adapter3d/thirdparty/three"]},"sap/ui/vbm/adapter3d/thirdparty/DecalGeometry":{exports:"DecalGeometry",deps:["sap/ui/vbm/adapter3d/thirdparty/three"]},"sap/ui/vbm/adapter3d/thirdparty/html2canvas":{amd:true,exports:"html2canvas"}});sap.ui.vbm.SemanticType={None:"None",Error:"Error",Warning:"Warning",Success:"Success",Default:"Default",Inactive:"Inactive",Hidden:"Hidden"};sap.ui.vbm.ClusterInfoType={ContainedVOs:0,ChildCluster:1,ParentNode:2,NodeInfo:10,Edges:11};sap.ui.vbm.RouteType={Straight:"Straight",Geodesic:"Geodesic"};
sap.ui.vbm.getResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.vbm.i18n");};
sap.ui.vbm.findInArray=function(s,p){if(!Array.isArray(s)||typeof p!=="function"){return undefined;}for(var i=0,c=s.length;i<c;i++){var v=s[i];if(p(v)){return v;}}return undefined;};
sap.ui.vbm.findIndexInArray=function(s,p){if(!Array.isArray(s)||typeof p!=="function"){return-1;}for(var i=0,c=s.length;i<c;i++){var v=s[i];if(p(v)){return i;}}return-1;};
return sap.ui.vbm;},false);
/*!
* SAP UI development toolkit for HTML5 (SAPUI5) (c) Copyright 2009-2012 SAP AG. All rights reserved
*/
sap.ui.predefine('sap/ui/vbm/ViewportRenderer',["jquery.sap.global"],function(q){"use strict";var V={};
V.render=function(r,c){r.write("<div");r.writeControlData(c);r.writeAttribute("tabindex",0);r.addStyle("width",c.getWidth());r.addStyle("height",c.getHeight());r.writeStyles();r.addClass("sapUiVbmViewport");r.writeClasses();r.write(">");r.write("</div>");};
return V;},true);
sap.ui.predefine('sap/ui/vbm/adapter3d/ObjectFactory',["sap/ui/base/Object"],function(B){"use strict";var w={id:undefined,type:"default",caption:undefined,refScene:undefined,refParent:undefined,width:"0",height:"0",modal:"true",pos:"0;0;0"};var s={id:undefined,type:"default",voGroups:undefined,getVisualObjectGroupById:function(o){for(var i=0,q=this.voGroups.length;i<q;++i){var r=this.voGroups[i];if(r.id===o){return r;}}return undefined;}};var v={id:undefined,type:undefined,datasource:undefined,scene:undefined,vos:undefined,maxSel:"-1",minSel:"0",keyAttributeName:undefined,template:undefined,isDataBound:false,isDirty:true};var t=Object.create(Object.prototype);t["VB:c"]="false";t["VB:s"]="false";t.color="RGB(128,128,128)";t.fxdir="false";t.fxsize="false";t.hotDeltaColor="RHLSA(0;1.1;1;1)";t.opacity="1";t.pos="0;0;0";t.rot="0;0;0";t.scale="1;1;1";t.selectColor="RGBA(178;127;0;255)";t.zsort="false";t.dragSource=undefined;t.dropTarget=undefined;var b=Object.create(t);b.isBox=true;b.object3D=undefined;b.type="{00100000-2012-0004-B001-BFED458C3076}";b.colorBorder=undefined;b.texture=undefined;b.texture6="false";b.normalize="false";b.tooltip=undefined;var c=Object.create(t);c.object3D=undefined;c.isCylinder=true;c.type="{00100000-2012-0004-AFC0-5FDB345FC47E}";c.colorBorder=undefined;c.texture=undefined;c.textureCap=undefined;c.isOpen=false;c.normalize="false";c.tooltip=undefined;var p=Object.create(t);p.isPolygon=true;p.type="{00100000-2014-0004-BDA8-87B904609063}";p.OuterNormal="0;0;1";p.colorBorder=undefined;p.tooltip=undefined;var m=Object.create(t);m.isModel=true;m.type="{00100000-2012-0070-1000-35762CF28B6B}";m.model=undefined;m.text=undefined;m.texture=undefined;m.normalize="false";m.tooltip=undefined;var d={object3D:undefined,isDecal:true,type:"{388951f5-a66b-4423-a5ad-e0ee13c2246f}",position:"0;0;0",direction:"0;0;0",size:"0;0;0",rotation:"0",texture:undefined,text:undefined,target:undefined,planeOrigin:undefined,planeNormal:undefined};var a=Object.create(Object.prototype);a.left="0";a.top="0";a.right="0";a.bottom="0";a.align="0";a.tooltip=undefined;var e=Object.create(a);e.isCaption=true;e.type="{00100000-2013-1000-1100-50059A6A47FA}";e.level="0";e.text=undefined;var l=Object.create(a);l.isLabel=true;l.type="{00100000-2013-1000-3700-AD84DDBBB31B}";l.text=undefined;var f=Object.create(a);f.isImage=true;f.type="{00100000-2013-1000-2200-6B060A330B2C}";f.image=undefined;var g=Object.create(a);g.isButton=true;g.type="{00100000-2013-1000-1200-855B919BB0E9}";g.text=undefined;var h=Object.create(a);h.isLink=true;h.type="{00100000-2013-1000-2400-D305F7942B98}";h.href=undefined;h.text=undefined;var j=new Map();j.set(b.type,b);j.set(c.type,c);j.set(m.type,m);j.set(p.type,p);j.set(d.type,d);j.set(e.type,e);j.set(l.type,l);j.set(f.type,f);j.set(g.type,g);j.set(h.type,h);var k={name:undefined,key:undefined,minSel:"-1",maxSel:"0",attributes:undefined,dataTypes:undefined,getKeyAttribute:function(){return this.key?this.getAttributeByName(this.key):undefined;},getAttributeByAlias:function(o){for(var i=0,q=this.attributes.length;i<q;++i){var r=this.attributes[i];if(r.alias===o){return r;}}return undefined;},getAttributeByName:function(o){for(var i=0,q=this.attributes.length;i<q;++i){var r=this.attributes[i];if(r.name===o){return r;}}return undefined;},getDataTypeByName:function(o){for(var i=0,q=this.dataTypes.length;i<q;++i){var r=this.dataTypes[i];if(r.name===o){return r;}}return undefined;}};var n={name:undefined,alias:undefined,type:"string"};
var O=B.extend("sap.ui.vbm.adapter3d.ObjectFactory",{});
O.prototype.createVisualObject=function(i){var o=j.get(i.type);var q=o&&Object.create(o,{voGroup:{writable:true},dataInstance:{writable:true}});if(q){q._last={};q.voGroup=i;i.vos.push(q);}return q;};
O.prototype.createVisualObjectGroup=function(i){var o=Object.create(v);o.scene=i;i.voGroups.push(o);o.template={};o.vos=[];o.selected=[];return o;};
O.prototype.createScene=function(i){var o=Object.create(s);o.voGroups=[];o.sceneGeo=i;return o;};
O.prototype.createWindow=function(){return Object.create(w);};
O.prototype.createDataType=function(){var i=Object.create(k);i.attributes=[];i.dataTypes=[];return i;};
O.prototype.createDataTypeAttribute=function(){return Object.create(n);};
O.prototype.createDataNode=function(){return[];};
O.prototype.createDataInstance=function(){return Object.create(Object.prototype,{isDirty:{writable:true},visualObject:{writable:true}});};
return O;});
sap.ui.predefine('sap/ui/vbm/adapter3d/SceneBuilder',["jquery.sap.global","sap/ui/base/Object","./Utilities","./PolygonHandler","./ModelHandler","./thirdparty/three","./thirdparty/DecalGeometry","./thirdparty/html2canvas"],function(q,B,U,P,M,T,D,h){"use strict";var t="sap.ui.vbm.adapter3d.SceneBuilder";var l=q.sap.log;var F=T.Face3;var a=T.Matrix4;var V=T.Vector2;var b=T.Vector3;var d=T.Math.degToRad;var c=U.toArray;var e=U.toBoolean;var f=U.toVector3;var g=U.createMaterial;var p=U.propertyChanged;var j=U.propertyRemoved;var k=U.propertyAdded;var u=U.updateProperty;var r=U.refCountableDispose;var m;var n;
var S=B.extend("sap.ui.vbm.adapter3d.SceneBuilder",{constructor:function(i,v){B.call(this);this._context=i;this._viewport=v;this._root=v.getRoot();this._scene=v.getScene();this._hotInstance=null;this._decalHelper=null;this._targets=new Map();this._textures=new Map();this._box4=null;this._box6=null;this._cylinder=null;this._cylinderCaps=null;this._polygonHandler=new P(this._root);this._modelHandler=new M(this._context.resources,this._textures,this._scene,this._root);this._textureLoader=null;}});
S.prototype.destroy=function(){this._root=null;this._scene=null;this._viewport=null;this._context=null;if(this._box4){this._box.dispose();}if(this._box6){this._box6.dispose();}if(this._cylinder){this._cylinder.dispose();}if(this._cylinderCaps){this._cylinderCaps.dispose();}if(this._decalHelper){this._decalHelper.material.dispose();this._decalHelper.geometry.dispose();this._scene.remove(this._decalHelper);}this._polygonHandler.destroy();this._modelHandler.destroy();this._textures.forEach(function(i){i.dispose();});B.prototype.destroy.call(this);};
S.prototype.synchronize=function(){var i=this;function o(s){var v=i._textures.get(s);if(!v){i._textures.set(s,null);}}return new Promise(function(s,v){var w=sap.ui.vbm.findInArray(i._context.windows,function(w){return w.type==="default";});var x=w&&sap.ui.vbm.findInArray(i._context.scenes,function(x){return x.id===w.refScene;});if(!x){s();return;}i._context.scene=x;if(i._context.setupView){var y=i._context.setupView;i._setupView(y.position,y.zoom,y.pitch,y.yaw,y.home,y.flyTo);i._context.setupView=undefined;}var z=[];var A=[],C=[];var E=i._context.voQueues.toAdd.get(x)||[];var G=i._context.voQueues.toUpdate.get(x)||[];var H=i._context.voQueues.toRemove.get(x)||[];[].concat(E,G).forEach(function(I){if(I.isModel){i._modelHandler.addModel(I);}if(I.texture&&p(I,"texture")){o(I.texture);}if(I.textureCap&&p(I,"textureCap")){o(I.textureCap);}if(I.isDecal&&I.text&&p(I,["text","size"])){z.push(I);}});i._loadTextures().then(function(){return i._modelHandler.loadModels();}).then(function(){return i._renderTexts(z);}).then(function(){H.forEach(i._removeInstance.bind(i));G.forEach(i._updateInstance.bind(i,C));E.forEach(i._addInstance.bind(i,A));i._polygonHandler.update();i._modelHandler.update();i._scene.updateMatrixWorld(true);C.forEach(i._updateInstance.bind(i,null));A.forEach(i._addInstance.bind(i,null));i._cleanupCache();s();}).catch(function(I){v(I);});});};
S.prototype._findMesh=function(i){var o=null;i.traverse(function(s){if(!o&&s.isMesh){o=s;}});return o;};
S.prototype._getGeometrySize=function(){return 2.0;};
S.prototype._getZoomFactor=function(i,o){var s=new b();s.subVectors(o,i);return(this._getGeometrySize()*2)/s.length();};
S.prototype._setupView=function(i,z,o,y,s,v){i=f(i||"0;0;0");z=parseFloat(z||"1");if(z===0){z=1;}else if(z<0){z=0.1;}var w=this._getGeometrySize()*2/z;o=parseFloat(o||"0");y=parseFloat(y||"0");o=(o%180===0?o+1:o);var x=new a();x.makeRotationX(d(o+180));var A=new a();A.makeRotationZ(d(-(y+180)));var C=new a();C.multiplyMatrices(A,x);var E=new b(0,0,-5);var G=new b(0,0,0);var H=new b();H.subVectors(G,E).normalize();H.multiplyScalar(w);H.applyMatrix4(C);H.add(i);G.add(i);var I={zoom:1.0,target:new b(-G.x,-G.z,G.y),position:new b(-H.x,-H.z,H.y)};if(s){this._viewport._setCameraHome(I);this._viewport._applyCamera(I,v);}else{this._viewport._applyCamera(I,v);}};
S.prototype._getDecalTextKey=function(i){return i.size+";"+i.text;};
S.prototype._renderTexts=function(i){var o=[];i.forEach(function(s){if(!this._textures.has(this._getDecalTextKey(s))){o.push(this._renderText(s));}},this);return Promise.all(o);};
S.prototype._renderText=function(i){var o=this;return new Promise(function(s,v){var w=f(i.size);if(w.length()<1E-6){l.error("Unable render text to html: decal size is invalid","",t);s();}else{var x=512;var y=w.x/w.y;var z=Math.ceil(y>=1?x:x*y);var A=Math.ceil(y<=1?x:x/y);var C=document.createElement("iframe");C.style.visibility="hidden";C.width=z;C.height=A;document.body.appendChild(C);var E=C.contentDocument||C.contentWindow.document;E.open();E.close();E.body.innerHTML=i.text;var G=document.createElement("canvas");G.width=C.width*window.devicePixelRatio;G.height=C.height*window.devicePixelRatio;G.style.width=C.width+"px";G.style.height=C.height+"px";var H=G.getContext("2d");H.scale(window.devicePixelRatio,window.devicePixelRatio);h(E.body,{canvas:G,width:z,height:A,backgroundColor:null}).then(function(I){if(I.width>0&&I.height>0){var J=new T.Texture(I);J.needsUpdate=true;U.addRef(J);o._textures.set(o._getDecalTextKey(i),J);}else{l.error("Failed render text to html","",t);}document.body.removeChild(C);s();});}});};
S.prototype._loadTextures=function(){var i=[];this._textures.forEach(function(o,s){if(!o){i.push(this._loadTexture(s));}},this);return Promise.all(i);};
S.prototype._loadTexture=function(i){var o=this;var s=this._context.resources.get(i);if(!s){this._textures.delete(i);l.error("Failed to get texture from context",i,t);return Promise.resolve();}return new Promise(function(v,w){o._getTextureLoader().load(U.makeDataUri(s),function(x){x.flipY=false;o._textures.set(i,x);v();},null,function(x){o._textures.delete(i);l.error("Failed to load texture from Data URI: "+i,"status: "+x.status+", status text: "+x.statusText,t);v();});});};
S.prototype._cleanupCache=function(){this._textures.forEach(function(i){if(r(i)){i.dispose();this._textures.delete(i);}},this);if(this._box4&&r(this._box4)){this._box4.dispose();this._box4=null;}if(this._box6&&r(this._box6)){this._box6.dispose();this._box6=null;}if(this._cylinder&&r(this._cylinder)){this._cylinder.dispose();this._cylinder=null;}if(this._cylinderCaps&&r(this._cylinderCaps)){this._cylinderCaps.dispose();this._cylinderCaps=null;}};
S.prototype._addInstance=function(i,o){if(!o.isDecal){this._updateInstanceKeys(o);}if(o.isPolygon){this._polygonHandler.addInstance(o);}else if(o.isModel){this._modelHandler.addInstance(o);}else if(o.isBox||o.isCylinder){o.object3D=new T.Group();o.object3D.matrixAutoUpdate=false;this._root.add(o.object3D);if(o.isBox){this._assignBoxProperties(o);}else{this._assignCylinderProperties(o);}}else if(o.isDecal){if(i){i.push(o);}else{this._assignDecalProperties(o);}}else{l.error("Unable to add instance: instance type is unknown","",t);}};
S.prototype._updateInstance=function(i,o){if(!o.isDecal){this._updateInstanceKeys(o);}if(o.isPolygon){this._polygonHandler.updateInstance(o);}else if(o.isModel){this._modelHandler.updateInstance(o);}else if(o.isBox){this._assignBoxProperties(o,o===this._hotInstance);}else if(o.isCylinder){this._assignCylinderProperties(o,o===this._hotInstance);}else if(o.isDecal){if(i){i.push(o);}else{this._assignDecalProperties(o);}}else{l.error("Unable to update instance: instance type is unknown","",t);}};
S.prototype._removeInstance=function(i){if(!i.isDecal){this._removeInstanceKeys(i);}if(i.isPolygon){this._polygonHandler.removeInstance(i);}else if(i.isModel){this._modelHandler.removeInstance(i);}else if(i.isBox||i.isCylinder||i.isDecal){if(i.object3D){this._deleteObject3D(i.object3D);i.object3D=null;i._last={};}else{l.error("Unable to remove instance: object3D is missing","",t);}}else{l.error("Unable to remove instance: instance type is unknown","",t);}if(this._hotInstance===i){this._hotInstance=null;}};
S.prototype.updateSelection=function(s,i){s.concat(i).forEach(function(o){if(o.isPolygon){this._polygonHandler.updateInstance(o);}else if(o.isModel){this._modelHandler.updateInstance(o);}else if(o.isBox){this._assignBoxProperties(o,o===this._hotInstance);}else if(o.isCylinder){this._assignCylinderProperties(o,o===this._hotInstance);}},this);this._polygonHandler.update();this._modelHandler.update();};
S.prototype._updateHotStatus=function(i,o){if(i.isBox){this._assignBoxProperties(i,o);}else if(i.isCylinder){this._assignCylinderProperties(i,o);}};
S.prototype.updateHotInstance=function(i){this._polygonHandler.updateHotInstance(i);this._modelHandler.updateHotInstance(i);this._polygonHandler.update();this._modelHandler.update();if(this._hotInstance){this._updateHotStatus(this._hotInstance,false);}if(i){this._updateHotStatus(i,true);}this._hotInstance=i;};
S.prototype._assignBoxProperties=function(i,o){var s=i.object3D.children.length===0?null:i.object3D.children[0];if(!s||p(i,"texture6")){var v=this._getBoxGeometry(e(i.texture6));U.addRef(v);if(s){U.subRef(s.geometry);s.geometry=v;}else{s=new T.Mesh(v,g(false));s.matrixAutoUpdate=false;s.layers.set(0);s._sapInstance=i;i.object3D.add(s);}}u(i,"texture6");this._assignProperties(i,o);};
S.prototype._assignCylinderProperties=function(i,o){var s,v=false,w=e(i.isOpen),x=i.object3D.children.length===0?null:i.object3D.children[0];if(!x||p(i,"isOpen")){var y=this._getCylinderGeometry(w);U.addRef(y);if(x){U.subRef(x.geometry);x.geometry=y;if(w){s=x.material[1];if(s.map){U.subRef(s.map);s.dispose();}x.material=x.material[0];x.material.side=T.DoubleSide;x.material.needsUpdate=true;}else{s=x.material.clone();s.map=null;x.material=[x.material,s];x.material.forEach(function(z){z.needsUpdate=true;z.side=T.FrontSide;});v=true;}}else{x=new T.Mesh(y,w?g(true):[g(false),g(false)]);x.matrixAutoUpdate=false;x.layers.set(0);x._sapInstance=i;i.object3D.add(x);}}if(p(i,"textureCap")||v){s=Array.isArray(x.material)?x.material[1]:null;if(s){if(s.map){U.subRef(s.map);s.map=null;s.needsUpdate=true;}if(i.textureCap){s.map=this._textures.get(i.textureCap);if(s.map){s.needsUpdate=true;U.addRef(s.map);}else{l.error("Unable to apply cap texture on cylinder, texture not found",i.textureCap,t);}}}}u(i,["isOpen","testureCap"]);this._assignProperties(i,o);};
S.prototype._assignProperties=function(i,o){var s,v,w=i.object3D.children[0];if(p(i,"texture")){v=Array.isArray(w.material)?w.material[0]:w.material;if(v.map){U.subRef(v.map);v.map=null;v.needsUpdate=true;}if(i.texture){v.map=this._textures.get(i.texture);if(v.map){v.needsUpdate=true;U.addRef(v.map);}else{l.error("Unable to apply texture, texture not found",i.texture,t);}}}if(p(i,["color","selectColor","VB:s"])||o!==undefined){s=U.getColor(i,i.color,o);U.toArray(w.material).forEach(function(z){z.color.copy(s.rgb);z.opacity=s.opacity;z.transparent=z.opacity<1;z.needsUpdate=true;});}var x=w.children.length===0?null:w.children[0];if(j(i,"colorBorder")){x.material.dispose();x.geometry.dispose();w.remove(x);}else if(i.colorBorder){if(k(i,"colorBorder")){var y=i.isBox?new T.EdgesGeometry(w.geometry):new T.EdgesGeometry(w.geometry,60);x=new T.LineSegments(y,U.createLineMaterial());x.matrixAutoUpdate=false;x.layers.set(1);w.add(x);}if(p(i,["colorBorder","selectColor,","VB:s"])||o!==undefined){v=x.material;s=U.getColor(i,i.colorBorder,o);v.color.copy(s.rgb);v.opacity=s.opacity;v.transparent=v.opacity<1;v.needsUpdate=true;}}if(p(i,"normalize")){if(e(i.normalize)){U.normalizeObject3D(w);w.updateMatrix();}else{w.position.set(0,0,0);w.rotation.set(0,0,0);w.scale.set(1,1,1);}}if(p(i,["pos","rot","scale"])){U.getInstanceTransform(i,i.object3D.position,i.object3D.rotation,i.object3D.scale);i.object3D.updateMatrix();}u(i,["texture","color","selectColor","VB:s","colorBorder","normalize","pos","rot","scale"]);};
S.prototype._assignDecalProperties=function(i){var o=false,s;if(p(i,["position","direction","size","rotation","target"])){o=true;}if(!i.target&&p(i,["planeOrigin","planeNormal"])){o=true;}if(o){if(i.object3D){s=i.object3D.material.clone();this._deleteObject3D(i.object3D);i.object3D=null;}var v=this._getDecalTarget(i);if(!v){l.error("Unable to create decal","target is missing",t);return;}var w=this._createDecal(i,v,s);this._disposeDecalTarget(i,v);if(!w){return;}}if(p(i,["texture","text"])){s=i.object3D.material;if(s.map){U.subRef(s.map);s.map=null;}s.map=this._textures.get(i.text?this._getDecalTextKey(i):i.texture);if(s.map){s.map.flipY=true;s.needsUpdate=true;U.addRef(s.map);}else{l.error("Unable to apply texture, texture not found",i.texture,t);}}u(i,["position","direction","size","rotation","target","texture","text","planeOrigin","planeNormal"]);};
S.prototype._createDecal=function(i,o,s){this._root.updateMatrixWorld(true);var v=f(i.position);var w=f(i.direction).normalize();if(w.length()<1E-6){l.error("Unable create decal: direction is invalid","",t);return false;}var x=d(U.toFloat(i.rotation));var y=f(i.size);if(y.length()<1E-6){l.error("Unable create decal: size is invalid","",t);return false;}v.applyMatrix4(o.matrixWorld);w.transformDirection(o.matrixWorld);var z=new T.Raycaster(v,w);var A=z.intersectObject(o);if(!A.length){l.error("Unable create decal: cannot project decal to plane","",t);return false;}if(!this._decalHelper){this._decalHelper=new T.Mesh(new T.BoxBufferGeometry(1,1,5));this._decalHelper.visible=false;this._decalHelper.layers.set(1);this._decalHelper.up.set(0,1,0);this._scene.add(this._decalHelper);}var C=A[0];var E=C.point;var G=w.clone().negate();var H=new T.Box3().setFromObject(o);var I=H.max.clone().sub(H.min).length();G.multiplyScalar(I);G.add(E);this._decalHelper.position.copy(E);this._decalHelper.lookAt(G);this._decalHelper.rotation.z+=x;s=s||new T.MeshPhongMaterial({specular:0x444444,shininess:0,transparent:true,depthTest:true,depthWrite:false,polygonOffset:true,polygonOffsetUnits:0.1,polygonOffsetFactor:-1});i.object3D=new T.Mesh(new T.DecalGeometry(o,E,this._decalHelper.rotation,y),s);i.object3D.matrixAutoUpdate=false;i.object3D.layers.set(1);this._scene.add(i.object3D);return true;};
S.prototype._createPlane=function(i,o){var s=f(i.planeOrigin);var v=f(i.planeNormal).normalize();if(v.length()<1E-6){l.error("Unable to create plane for decal: normal is invalid","",t);return null;}var w=new b(v.x===0?10:-v.x,v.y===0?-10:v.y,v.z===0?10:-v.z);var x=s.clone(s).add(w);x.sub(v.clone().multiplyScalar(v.dot(x.clone().sub(s))));var y=10000;w=x.clone().sub(s).normalize();var z=v.clone().cross(w).normalize();w.multiplyScalar(y);z.multiplyScalar(y);var A=s.clone().add(w);var C=s.clone().sub(w);var E=s.clone().add(z);var G=s.clone().sub(z);var H=new T.Geometry();H.vertices.push(A,E,C,G);H.faces.push(new F(0,1,2,v),new F(2,3,0,v));var I=new T.Mesh(H);o.add(I);return I;};
S.prototype._getDecalTarget=function(i){if(i.target){var o=this._targets.get(i.target);if(o){if(o.isBox||o.isCylinder){return o.object3D.children[0];}else if(o.isPolygon){return this._polygonHandler.getTarget(o);}else if(o.isModel){return this._modelHandler.getTarget(o);}else{l.error("Unable to get decal's target","target instance type is unknown",t);return null;}}}else if(i.planeOrigin&&i.planeNormal){return this._createPlane(i,this._root);}else{l.error("Unable to get/create decal's target","missing parameters",t);return null;}};
S.prototype._disposeDecalTarget=function(i,o){if(i.target){var s=this._targets.get(i.target);if(s){if(s.isPolygon||s.isModel){this._deleteObject3D(o);}}else{l.error("Unable to dispose decal's target","target not found",t);}}else{this._deleteObject3D(o);}};
S.prototype._updateInstanceKeys=function(i){var v=this._getInstanceKeys(i);if(v){this._targets.set(v.key,i);this._targets.set(v.group,i);}};
S.prototype._removeInstanceKeys=function(i){var v=this._getInstanceKeys(i);if(v){this._targets.delete(v.key);this._targets.delete(v.group);}};
S.prototype._getInstanceKeys=function(i){if(i.dataInstance){var o=i.voGroup.keyAttributeName;if(o){var v=i.dataInstance[o];if(v){return{key:v,group:i.voGroup.id+"."+v};}}}return null;};
S.prototype._deleteObject3D=function(o){o.traverse(function(i){if(i.geometry){if(U.refCountable(i.geometry)){U.subRef(i.geometry);}else{i.geometry.dispose();}}c(i.material).forEach(function(s){if(s.map){U.subRef(s.map);}s.dispose();});});o.parent.remove(o);};
S.prototype._getBoxGeometry=function(s){if(s){return this._box6||(this._box6=m(s));}else{return this._box4||(this._box4=m(s));}};
S.prototype._getCylinderGeometry=function(o){if(o){return this._cylinder||(this._cylinder=n(o));}else{return this._cylinderCaps||(this._cylinderCaps=n(o));}};
S.prototype._getTextureLoader=function(){return this._textureLoader||(this._textureLoader=new T.TextureLoader());};
m=function(s){var i=new T.Geometry();var o=0.1;i.vertices.push(new b(o,o,-o),new b(o,-o,-o),new b(-o,-o,-o),new b(-o,o,-o),new b(o,o,o),new b(-o,o,o),new b(-o,-o,o),new b(o,-o,o),new b(o,o,-o),new b(o,o,o),new b(o,-o,o),new b(o,-o,-o),new b(o,-o,-o),new b(o,-o,o),new b(-o,-o,o),new b(-o,-o,-o),new b(-o,-o,-o),new b(-o,-o,o),new b(-o,o,o),new b(-o,o,-o),new b(o,o,o),new b(o,o,-o),new b(-o,o,-o),new b(-o,o,o));var v=new T.Color(0.5,0.5,0.5);i.faces.push(new F(0,2,3,new b(0,0,-1),v),new F(0,1,2,new b(0,0,-1),v),new F(4,5,6,new b(0,0,1),v),new F(4,6,7,new b(0,0,1),v),new F(8,10,11,new b(1,0,0),v),new F(8,9,10,new b(1,0,0),v),new F(12,14,15,new b(0,-1,0),v),new F(12,13,14,new b(0,-1,0),v),new F(16,18,19,new b(-1,0,0),v),new F(16,17,18,new b(-1,0,0),v),new F(20,22,23,new b(0,1,0),v),new F(20,21,22,new b(0,1,0),v));var w;if(s){w=[new V(2/3,0.5),new V(1.0,0.5),new V(1.0,1.0),new V(2/3,1.0),new V(2/3,0.5),new V(2/3,0.0),new V(1.0,0.0),new V(1.0,0.5),new V(2/3,0.5),new V(2/3,1.0),new V(1/3,1.0),new V(1/3,0.5),new V(2/3,0.0),new V(2/3,0.5),new V(1/3,0.5),new V(1/3,0.0),new V(1/3,0.5),new V(1/3,1.0),new V(0.0,1.0),new V(0.0,0.5),new V(0.0,0.5),new V(0.0,0.0),new V(1/3,0.0),new V(1/3,0.5)];}else{w=[new V(0.5,0.5),new V(1.0,0.5),new V(1.0,1.0),new V(0.5,1.0),new V(0.5,0.5),new V(1.0,0.5),new V(1.0,1.0),new V(0.5,1.0),new V(0.5,0.5),new V(0.5,1.0),new V(0.0,1.0),new V(0.0,0.5),new V(0.5,0.5),new V(0.5,0.0),new V(1.0,0.0),new V(1.0,0.5),new V(0.5,0.5),new V(0.5,1.0),new V(0.0,1.0),new V(0.0,0.5),new V(0.0,0.5),new V(0.0,0.0),new V(0.5,0.0),new V(0.5,0.5)];}i.faceVertexUvs[0].push([w[0],w[2],w[3]],[w[0],w[1],w[2]],[w[5],w[6],w[7]],[w[5],w[7],w[4]],[w[8],w[10],w[11]],[w[8],w[9],w[10]],[w[12],w[14],w[15]],[w[12],w[13],w[14]],[w[16],w[18],w[19]],[w[16],w[17],w[18]],[w[20],w[22],w[23]],[w[20],w[21],w[22]]);return i;};n=function(o){var s=0.1;var v=new T.CylinderGeometry(s,s,2*s,32,1,o);if(!o){for(var i=0;i<v.faces.length;++i){var w=v.faces[i];if(w.normal.y!==0){v.faceVertexUvs[0][i][0].u=(v.vertices[w.a].x+s/2)/s;v.faceVertexUvs[0][i][0].v=(v.vertices[w.a].z+s/2)/s;v.faceVertexUvs[0][i][1].u=(v.vertices[w.b].x+s/2)/s;v.faceVertexUvs[0][i][1].v=(v.vertices[w.b].z+s/2)/s;v.faceVertexUvs[0][i][2].u=(v.vertices[w.c].x+s/2)/s;v.faceVertexUvs[0][i][2].v=(v.vertices[w.c].z+s/2)/s;w.materialIndex=1;}else{w.materialIndex=0;}}}return v;};return S;});
sap.ui.predefine('sap/ui/vbm/adapter3d/Utilities',["jquery.sap.global","sap/ui/base/Object","./thirdparty/three"],function(q,B,T){"use strict";var t="sap.ui.vbm.adapter3d.Utilities";var l=q.sap.log;var C=T.Color;var V=T.Vector3;var M=T.Matrix4;var d=T.Math.degToRad;
var U=B.extend("sap.ui.vbm.adapter3d.Utilities",{});
U.refCountPropertyName="_sapRefCount";
U.refCountable=function(o){return o.hasOwnProperty(U.refCountPropertyName);};
U.refCountableDispose=function(o){return o.hasOwnProperty(U.refCountPropertyName)&&o[U.refCountPropertyName]===0;};
U.addRef=function(o){if(!o.hasOwnProperty(U.refCountPropertyName)){o[U.refCountPropertyName]=0;}o[U.refCountPropertyName]+=1;};
U.subRef=function(o){if(o.hasOwnProperty(U.refCountPropertyName)){o[U.refCountPropertyName]-=1;return o[U.refCountPropertyName]===0;}return false;};
U.toArray=function(i){return i===undefined?[]:[].concat(i);};
U.toBoolean=function(v){var f=v.charAt(0);return f==="t"||f!==""&&f!=="f"&&f!==" "&&f!=="0";};
U.toFloat=function(v){return parseFloat(v);};
U.toVector3=function(v,o){var a=v.split(";");if(a.length!==3){return o?o.set(0,0,0):new V(0,0,0);}var x=parseFloat(a[0]),y=parseFloat(a[1]),z=parseFloat(a[2]);return o?o.set(x,y,z):new V(x,y,z);};
U.threeJsToVb=function(p){return new V(-p.x,p.z,-p.y);};
U.vbToThreeJs=function(p){return new V(-p.x,-p.z,p.y);};
U.toColor=(function(){var a="\\s*(\\d+)\\s*";var h="\\s*(?:0[xX])([\\da-fA-F]+)\\s*";var b=a+"(,|;)"+a+"\\2"+a;var f=a+"(,|;)"+a+"\\2"+a+"\\2"+a;var c=h+"(,|;)"+h+"\\2"+h;var e=h+"(,|;)"+h+"\\2"+h+"\\2"+h;var r=new RegExp("^\\s*RGB\\("+b+"\\)\\s*$");var g=new RegExp("^\\s*RGB\\("+c+"\\)\\s*$");var i=new RegExp("^\\s*RGBA\\("+f+"\\)\\s*$");var j=new RegExp("^\\s*RGBA\\("+e+"\\)\\s*$");var k=new RegExp("^\\s*ARGB\\("+f+"\\)\\s*$");var n=new RegExp("^\\s*ARGB\\("+e+"\\)\\s*$");var o=new RegExp("^\\s*HLS\\("+b+"\\)\\s*$");var p=new RegExp("^\\s*HLS\\("+c+"\\)\\s*$");var s=new RegExp("^\\s*HLSA\\("+f+"\\)\\s*$");var u=new RegExp("^\\s*HLSA\\("+e+"\\)\\s*$");var v=new RegExp("^"+a+"$");var w=new RegExp("^"+h+"$");return function(x){var m;var y;var z=1;if((m=x.match(r))){y=new C(parseInt(m[1],10)/255,parseInt(m[3],10)/255,parseInt(m[4],10)/255);}else if((m=x.match(g))){y=new C(parseInt(m[1],16)/255,parseInt(m[3],16)/255,parseInt(m[4],16)/255);}else if((m=x.match(i))){y=new C(parseInt(m[1],10)/255,parseInt(m[3],10)/255,parseInt(m[4],10)/255);z=m[5]/255;}else if((m=x.match(j))){y=new C(parseInt(m[1],16)/255,parseInt(m[3],16)/255,parseInt(m[4],16)/255);z=m[5]/255;}else if((m=x.match(k))){y=new C(parseInt(m[3],10)/255,parseInt(m[4],10)/255,parseInt(m[5],10)/255);z=m[1]/255;}else if((m=x.match(n))){y=new C(parseInt(m[3],16)/255,parseInt(m[4],16)/255,parseInt(m[5],16)/255);z=m[1]/255;}else{l.warning("Cannot convert color, use default",x,t);y=new C(0.5,0.5,0.5);}return{rgb:y,opacity:z};};})();U.toColorDelta=(function(){var f="\\s*([-+]?\\d*\\.?\\d+(?:[eE][-+]?\\d+)?)\\s*";var r=new RegExp("^\\s*RHLS\\("+f+";"+f+";"+f+"\\)\\s*$");var a=new RegExp("^\\s*RHLSA\\("+f+";"+f+";"+f+";"+f+"\\)\\s*$");return function(b){var m;var h;var o=1;if((m=b.match(r))){h=new V(parseFloat(m[1]),parseFloat(m[2]),parseFloat(m[3]));}else if((m=b.match(a))){h=new V(parseFloat(m[1]),parseFloat(m[2]),parseFloat(m[3]));o=parseFloat(m[4]);}else{l.warning("Cannot convert color delta, use default",b,t);h=new V(1,1,1);}return{hls:h,opacity:o};};})();
U.multiplyColors=function(x,y,o){o.r=U.clamp(x.r*y.r,0.0,1.0);o.g=U.clamp(x.g*y.g,0.0,1.0);o.b=U.clamp(x.b*y.b,0.0,1.0);};
U.isColorDelta=function(v){return v.startsWith("RHLS");};
U.applyDeltaHLS=function(c,h){var a=c.getHSL({});a.h=a.h+h.x;a.s=U.clamp(a.s*h.z,0.0,1.0);a.l=U.clamp(a.l*h.y,0.0,1.0);c.setHSL(a.h,a.s,a.l);};
U.rgbaToString=function(c){return c.rgb.getHexString()+Math.round(c.opacity*255).toString(16);};
U.equalsRGBA=function(a,r){return a.rgb.equals(r.rgb)&&a.opacity===r.opacity;};
U.getColor=function(i,s,h){var c=U.toColor(s);var a=U.toBoolean(i["VB:s"]);if(a){var b=U.isColorDelta(i.selectColor);var e=b?U.toColorDelta(i.selectColor):U.toColor(i.selectColor);if(b){U.applyDeltaHLS(c.rgb,e.hls);c.opacity=U.clamp(c.opacity*e.opacity,0.0,1.0);}else{c.rgb.copy(e.rgb);c.opacity=e.opacity;}}if(h){var f=U.isColorDelta(i.hotDeltaColor);var g=f?U.toColorDelta(i.hotDeltaColor):U.toColor(i.hotDeltaColor);if(f){U.applyDeltaHLS(c.rgb,g.hls);c.opacity=U.clamp(c.opacity*g.opacity,0.0,1.0);}else{c.rgb.copy(g.rgb);c.opacity=g.opacity;}}return c;};
U.applyColor=function(i,s,o,h,a){var c=U.toColor(s);var b=U.toBoolean(i["VB:s"]);var e,f,g,j;if(b){e=U.isColorDelta(i.selectColor);f=e?U.toColorDelta(i.selectColor):U.toColor(i.selectColor);}if(h){g=U.isColorDelta(i.hotDeltaColor);j=g?U.toColorDelta(i.hotDeltaColor):U.toColor(i.hotDeltaColor);}var r="_sapReference";U.toArray(o).forEach(function(k){k.traverse(function(n){U.toArray(n.material).forEach(function(m){if(a!==undefined){m.map=a;}var p=m[r]||(m[r]={rgb:m.color.clone(),opacity:m.opacity});U.multiplyColors(p.rgb,c.rgb,m.color);m.opacity=U.clamp(p.opacity*c.opacity,0.0,1.0);if(b){if(e){U.applyDeltaHLS(m.color,f.hls);m.opacity=U.clamp(m.opacity*f.opacity,0.0,1.0);}else{m.color.copy(f.rgb);m.opacity=f.opacity;}}if(h){if(g){U.applyDeltaHLS(m.color,j.hls);m.opacity=U.clamp(m.opacity*j.opacity,0.0,1.0);}else{m.color.copy(j.rgb);m.opacity=j.opacity;}}m.transparent=m.opacity<1;});});});};
U.clamp=function(v,m,a){if(v<m){return m;}if(v>a){return a;}return v;};
U.swap=function(o,a,b){var c=o[a];o[a]=o[b];o[b]=c;};
U.makeDataUri=function(a){return a&&"data:text/plain;base64,"+a;};
U.base64ToArrayBuffer=function(s){var a=atob(s);var b=new Uint8Array(a.length);for(var i=0;i<a.length;++i){b[i]=a.charCodeAt(i);}return b.buffer;};
U.getInstanceTransform=function(i,p,r,s,b){U.toVector3(i.pos,p);U.toVector3(i.scale,s);var a=U.toVector3(i.rot);r.set(d(a.x),d(a.y),d(a.z),"YXZ");var c;if(i.isPolygon){c=new V(0,0,0);}else if(i.isBox||i.isCylinder){c=new V(0,0,-1);}else if(i.isModel){c=new V(0,0,-1.0*(b.min.z>0?b.min.z:b.max.z));}else{l.error("Unsupported instance type","",t);}if(r.x!==0||r.y!==0||r.z!==0||s.x!==1||s.y!==1||s.z!==1){var m=new M();m.makeRotationFromEuler(r);var o=new M();o.makeScale(s.x,s.y,s.z);o.multiply(m);c.applyMatrix4(o);}c.z=-c.z;p.sub(c);};
U.getInstanceMatrix=function(i,m,b){var p=new V(),r=new T.Euler(),s=new V();U.getInstanceTransform(i,p,r,s,b);if(p.x!==0||p.y!==0||p.z!==0||r.x!==0||r.y!==0||r.z!==0||s.x!==1||s.y!==1||s.z!==1){var a=new T.Quaternion();a.setFromEuler(r,false);m.compose(p,a,s);m._identity=false;}else{m.identity();m._identity=true;}};
U.createMaterial=function(a){return new T.MeshPhongMaterial({color:0xffffff,opacity:1.0,shininess:1,specular:0x101009,side:a?T.DoubleSide:T.FrontSide});};
U.createLineMaterial=function(){return new T.LineBasicMaterial({color:0xffffff,opacity:1.0,linewidth:1});};
U.propertyAdded=function(i,p){return i[p]&&!i._last[p];};
U.propertyRemoved=function(i,p){return!i[p]&&i._last[p];};
U.propertyChanged=function(a,p){if(Array.isArray(p)){for(var i=0;i<p.length;++i){if(a[p[i]]!==a._last[p[i]]){return true;}}return false;}else{return a[p]!==a._last[p];}};
U.updateProperty=function(i,p){if(Array.isArray(p)){p.forEach(function(a){i._last[a]=i[a];});}else{i._last[p]=i[p];}};
U.normalizeObject3D=function(r,m,b){var a=new T.Box3().setFromObject(r);var c=a.getCenter(new V());a.min.sub(new V(c.x,c.y,-c.z));a.max.sub(new V(c.x,c.y,-c.z));var s=Math.max(Math.abs(a.min.x),Math.abs(a.min.y),Math.abs(a.min.z),Math.abs(a.max.x),Math.abs(a.max.y),Math.abs(a.max.z));if(s){s=1/s;}a.min.set(a.min.x*s,a.min.y*s,-a.min.z*s);a.max.set(a.max.x*s,a.max.y*s,-a.max.z*s);U.swap(a,"min","max");if(b){b.copy(a);}var e=new M().makeScale(s,s,s);var f=new M().makeTranslation(-c.x,-c.y,-c.z);r.updateMatrix();e.multiply(f);e.multiply(r.matrix);if(m){m.copy(e);}else{e.decompose(r.position,r.quaternion,r.scale);}};
U.cloneMaterials=function(m){if(m){if(Array.isArray(m)){return m.map(function(a){return a.clone();});}return m.clone();}return m;};
return U;});
/*
 * ! SAP UI development toolkit for HTML5 (SAPUI5) (c) Copyright 2009-2012 SAP AG. All rights reserved
 */
sap.ui.predefine('sap/ui/vbm/GeoMap',['./VBI','./library'],function(V,l){"use strict";
/**
	 * Constructor for a new GeoMap.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 * @class Map control with the option to position multiple visual objects on top of a map. The GeoMap control shows an image based map loaded from
	 *        one or more configurable external providers. Per default a map from <a href="http://www.mapquest.com">MapQuest</a> is used. Other map
	 *        providers can be configured via property <i>mapConfiguration</i>. Multiple maps can be mashed up into one map layer stack. If multiple
	 *        map layer stacks are provided via configuration it is possible to switch between them during runtime. The control supports the display
	 *        of copyright information for the visible maps.<br>
	 *        On top of the map the GeoMap control provides a navigation control, a scale, and a legend. Each of them can be switched off separately.<br>
	 *        It is possible to set the initial position and zoom for the map display. Further the control allows to restrict the potentially visible
	 *        map area and zoom range.<br>
	 *        Different visual objects can be placed on the map. Visual objects are grouped in VO aggregations and an arbitrary number of VO
	 *        aggregations can be assigned to the <i>vos</i> aggregation.<br>
	 *        The second aggregation <i>featureCollections</i> allows the use of GeoJSON as source for visual objects.
	 * @extends sap.ui.vbm.VBI
	 * @constructor
	 * @public
	 * @alias sap.ui.vbm.GeoMap
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */

var G=V.extend("sap.ui.vbm.GeoMap",{metadata:{library:"sap.ui.vbm",properties:{mapConfiguration:{type:"object",group:"Misc",defaultValue:null},legendVisible:{type:"boolean",group:"Appearance",defaultValue:true},scaleVisible:{type:"boolean",group:"Appearance",defaultValue:true},navcontrolVisible:{type:"boolean",group:"Appearance",defaultValue:true},initialPosition:{type:"string",group:"Behavior",defaultValue:"0;0;0"},initialZoom:{type:"string",group:"Behavior",defaultValue:"2"},centerPosition:{type:"string",group:"Behavior",defaultValue:"0;0"},zoomlevel:{type:"int",group:"Behavior",defaultValue:2},refMapLayerStack:{type:"string",group:"Appearance",defaultValue:"Default"},visualFrame:{type:"object",group:"Behavior",defaultValue:null},clustering:{type:"object",group:"Behavior",defaultValue:null},disableZoom:{type:"boolean",group:"Behavior",defaultValue:false},disablePan:{type:"boolean",group:"Behavior",defaultValue:false},enableAnimation:{type:"boolean",group:"Behavior",defaultValue:false},ariaLabel:{type:"string",group:"Misc"}},defaultAggregation:"vos",aggregations:{vos:{type:"sap.ui.vbm.VoAbstract",multiple:true,singularName:"vo"},geoJsonLayers:{type:"sap.ui.vbm.GeoJsonLayer",multiple:true,singularName:"geoJsonLayer"},featureCollections:{type:"sap.ui.vbm.FeatureCollection",multiple:true,singularName:"featureCollection"},resources:{type:"sap.ui.vbm.Resource",multiple:true,singularName:"resource"},legend:{type:"sap.ui.vbm.Legend",multiple:false},clusters:{type:"sap.ui.vbm.ClusterBase",multiple:true,singularName:"cluster"}},events:{click:{parameters:{pos:{type:"string"}}},contextMenu:{parameters:{clientX:{type:"int"},clientY:{type:"int"},pos:{type:"string"}}},drop:{parameters:{pos:{type:"string"}}},select:{},zoomChanged:{parameters:{centerPoint:{type:"string"},viewportBB:{type:"object"},zoomLevel:{type:"int"}}},centerChanged:{parameters:{centerPoint:{type:"string"},viewportBB:{type:"object"},zoomLevel:{type:"int"}}},keyDown:{parameters:{key:{type:"string"},code:{type:"int"},shift:{type:"boolean"},ctrl:{type:"boolean"},alt:{type:"boolean"},meta:{type:"boolean"}}},keyPress:{parameters:{key:{type:"string"},code:{type:"int"},shift:{type:"boolean"},ctrl:{type:"boolean"},alt:{type:"boolean"},meta:{type:"boolean"}}},keyUp:{parameters:{key:{type:"string"},code:{type:"int"},shift:{type:"boolean"},ctrl:{type:"boolean"},alt:{type:"boolean"},meta:{type:"boolean"}}}}}});
G.bEncodedSpotImagesAvailable=false;G.bEncodeSpotImageData=null;G.oBaseApp={SAPVB:{version:"2.0",MapProviders:{Set:{MapProvider:{name:"404",type:"",description:"",tileX:"256",tileY:"256",maxLOD:"19",copyright:"Map Provider is not configured, please read this {LINK|SCN Article} to configure your own Map Provider.",copyrightLink:"//scn.sap.com/docs/DOC-74221",copyrightImage:"",Source:[{id:"s1",url:"data:image/png;base64,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"}]}}},MapLayerStacks:{Set:{MapLayerStack:{name:"Default",MapLayer:{name:"layer1",refMapProvider:"404",opacity:"1.0",colBkgnd:"rgb(255,255,255)"}}}}}};
G.prototype.exit=function(){V.prototype.exit.apply(this,arguments);this.detachSubmit(this.onGeoMapSubmit,this);this.detachContainerCreated(this.onGeoMapContainerCreated,this);this.detachContainerDestroyed(this.onGeoMapContainerDestroyed,this);this.detachCloseWindow(this.onGeoMapWindowClosed,this);};
function d(){this.m_bActionsDirty=true;this.m_bSceneDirty=true;this.invalidate(this);}
G.prototype.attachEvent=function(){V.prototype.attachEvent.apply(this,arguments);d.apply(this);};
G.prototype.detachEvent=function(){V.prototype.detachEvent.apply(this,arguments);d.apply(this);};
G.prototype.destroyResources=function(){this.m_bResourcesDirty=true;return this.destroyAggregation("resources");};
G.prototype.addResource=function(o){this.m_bResourcesDirty=true;return this.addAggregation("resources",o);};
G.prototype.insertResource=function(o,i){this.m_bResourcesDirty=true;return this.insertAggregation("resources",o,i);};
G.prototype.removeResource=function(o){this.m_bResourcesDirty=true;return this.removeAggregation("resources",o);};
G.prototype.removeAllResources=function(o){this.m_bResourcesDirty=true;return this.removeAllAggregation("resources");};
G.prototype.destroyVos=function(){this.m_bVosDirty=true;return this.destroyAggregation("vos");};
G.prototype.addVo=function(o){if(this.indexOfVo(o)<0){this.m_bVosDirty=true;this.addAggregation("vos",o);o.m_bAggRenew=true;}return this;};
G.prototype.insertVo=function(o,i){this.m_bVosDirty=true;this.insertAggregation("vos",o,i);o.m_bAggRenew=true;return this;};
G.prototype.removeVo=function(o){this.m_bVosDirty=true;return this.removeAggregation("vos",o);};
G.prototype.removeAllVos=function(o){this.m_bVosDirty=true;return this.removeAllAggregation("vos");};
G.prototype.destroyGeoJsonLayers=function(){this.m_bGJLsDirty=true;return this.destroyAggregation("geoJsonLayers");};
G.prototype.addGeoJsonLayer=function(o){this.m_bGJLsDirty=true;return this.addAggregation("geoJsonLayers",o);};
G.prototype.insertGeoJsonLayer=function(o,i){this.m_bGJLsDirty=true;return this.insertAggregation("geoJsonLayers",o,i);};
G.prototype.removeGeoJsonLayer=function(o){this.m_bGJLsDirty=true;return this.removeAggregation("geoJsonLayers",o);};
G.prototype.removeAllGeoJsonLayers=function(o){this.m_bGJLsDirty=true;return this.removeAllAggregation("geoJsonLayers");};
G.prototype.destroyFeatureCollections=function(){this.m_bFCsDirty=true;return this.destroyAggregation("featureCollections");};
G.prototype.addFeatureCollection=function(o){this.m_bFCsDirty=true;return this.addAggregation("featureCollections",o);};
G.prototype.insertFeatureCollection=function(o,i){this.m_bFCsDirty=true;return this.insertAggregation("featureCollections",o,i);};
G.prototype.removeFeatureCollection=function(o){this.m_bFCsDirty=true;return this.removeAggregation("featureCollections",o);};
G.prototype.removeAllFeatureCollections=function(o){this.m_bFCsDirty=true;return this.removeAllAggregation("featureCollections");};
G.prototype.destroyClusters=function(){this.m_bClustersDirty=true;return this.destroyAggregation("clusters");};
G.prototype.addCluster=function(o){this.m_bClustersDirty=true;return this.addAggregation("clusters",o);};
G.prototype.insertCluster=function(o,i){this.m_bClustersDirty=true;return this.insertAggregation("clusters",o,i);};
G.prototype.removeCluster=function(o){this.m_bClustersDirty=true;return this.removeAggregation("clusters",o);};
G.prototype.removeAllClusters=function(o){this.m_bClustersDirty=true;return this.removeAllAggregation("clusters");};
/**
	 * Set Map configuration data. Map Configurations contain a set of Map Providers and Map Layer Stacks refering to those providers. The GeoMap
	 * property refMapLayerStack defines, which Map Layer Stack becomes visible.
	 *
	 * @param {object} oMapConfiguration Map Configuration object
	 * @param {array} oMapConfiguration.MapProvider Array of Map Provider definitions.
	 * @param {string} oMapConfiguration.MapProvider.name Name for the provider. Needed in Map Layer Stack as reference.
	 * @param {string} oMapConfiguration.MapProvider.tileX X-pixel dimension of map tile. Typical 256.
	 * @param {string} oMapConfiguration.MapProvider.tileY Y-pixel dimension of map tile. Typical 256.
	 * @param {string} oMapConfiguration.MapProvider.minLOD Minimal supported Level Of Detail.
	 * @param {string} oMapConfiguration.MapProvider.maxLOD Maximal supported Level Of Detail.
	 * @param {string} oMapConfiguration.MapProvider.copyright Copyright Information to be shown with the map.
	 * @param {array} oMapConfiguration.MapProvider.Source Array of source definitions. At least on Source has to be given. Multiple sources can be
	 *        used for load distribution.
	 * @param {string} oMapConfiguration.MapProvider.Source.id Source id.
	 * @param {string} oMapConfiguration.MapProvider.Source.url Source URL for map tile service. URL includes place holders for variable informations
	 *        set at runtime, e.g. {LOD}.
	 * @param {array} oMapConfiguration.MapLayerStacks Array of Map Layer Stacks
	 * @param {string} oMapConfiguration.MapLayerStacks.name Name of Map Layer Stack. Use with the GeoMap refMapLayerStack property.
	 * @param {string} oMapConfiguration.MapLayerStacks.previewPosition.latitude Latitude position to use when creating image tile
	 * @param {string} oMapConfiguration.MapLayerStacks.previewPosition.longitude Longitude position to use when creating image tile
	 * @param {string} oMapConfiguration.MapLayerStacks.previewPosition.lod Lod position to use when creating image tile
	 * @param {array} oMapConfiguration.MapLayerStacks.MapLayer Array of Map Layers. Each Layer refers to a Map Proveride. Map Layers get overlayed in
	 *        the given sequence.
	 * @param {string} oMapConfiguration.MapLayerStacks.MapLayer.name Name of Map Layer.
	 * @param {string} oMapConfiguration.MapLayerStacks.MapLayer.refMapProvider Name of referenced Map Provider.
	 * @param {string} oMapConfiguration.MapLayerStacks.MapLayer.opacity Opacity of Map Layer. Value range 0 to 1.
	 * @param {sap.ui.core.CSSColor} oMapConfiguration.MapLayerStacks.colBkgnd Background color for Map Layer. Only meaningful if opacity is
	 *        below 1.
	 * @returns {sap.ui.vbm.GeoMap} This allows method chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */

G.prototype.setMapConfiguration=function(o){this.m_bMapConfigurationDirty=true;if(o.MapLayerStacks&&o.MapProvider){this.m_bMapLayerStacksDirty=true;this.m_bMapProvidersDirty=true;this.setProperty("mapConfiguration",o).invalidate();}return this;};
G.prototype.setClustering=function(c){this.m_bClusteringDirty=true;this.setProperty("clustering",c);return this;};
G.prototype.setRefMapLayerStack=function(o){if(o===this.getRefMapLayerStack()){return this;}this.m_bRefMapLayerStackDirty=this.m_bSceneDirty=true;this.setProperty("refMapLayerStack",o).invalidate();return this;};
G.prototype.setVisualFrame=function(v){this.m_bVisualFrameDirty=true;this.setProperty("visualFrame",v);return this;};
G.prototype.setRectangularSelection=function(s){V.prototype.setRectangularSelection.apply(this,arguments);return this;};
G.prototype.setLassoSelection=function(s){V.prototype.setLassoSelection.apply(this,arguments);return this;};
G.prototype.setRectZoom=function(s){V.prototype.setRectZoom.apply(this,arguments);return this;};
G.prototype.getPositionInteractive=function(p,c){var i;if(!this.mIACreateCB&&c&&typeof c==="function"){this.mIACreateCB=c;var t=p?"POSARRAY":"POS";var L={"SAPVB":{"Automation":{"Call":{"handler":"OBJECTCREATIONHANDLER","name":"CreateObject","object":"MainScene","scene":"MainScene","instance":"","Param":{"name":"data","#":"{"+t+"}"}}}}};this.load(L);i=true;}else{i=false;}return i;};
G.prototype.getCenterPosition=function(){var s=this.mVBIContext.GetMainScene(),c;if(s){var C=window.VBI.MathLib.RadToDeg(s.GetCenterPos());c=C[0]+";"+C[1];}else{c=this.getProperty("centerPosition");}return c;};
G.prototype.isNumeric=function(n){return!isNaN(parseFloat(n))&&isFinite(n);};
G.prototype.setCenterPosition=function(p){var c=p?p.split(";"):undefined;if(!c||c.length<=1||!this.isNumeric(c[0])||!this.isNumeric(c[1])){jQuery.sap.log.error(sap.ui.vbm.getResourceBundle().getText("GEOMAP_INVALID_CENTER_POSITION")+":'"+p+"'","setCenterPosition","sap.ui.vbm.GeoMap");}else{var P=c[0]+";"+c[1]+";0";this.setProperty("centerPosition",P);if(this.isRendered()){c=P.split(";");this.zoomToGeoPosition(c[0],c[1],this.getZoomlevel());}}return this;};
G.prototype.setInitialPosition=function(p){this.setCenterPosition(p);};
G.prototype.getZoomlevel=function(){var s=this.mVBIContext.GetMainScene();if(s){return parseInt(s.GetCurrentZoomlevel(),10);}return this.getProperty("zoomlevel");};
G.prototype.setZoomlevel=function(z){if(!this.getDisableZoom()){if(z>=0){if(this.isRendered()){var c=this.getCenterPosition().split(";");if(this.getEnableAnimation()){var s=this.mVBIContext.GetMainScene();s.AnimateZoomToGeo(s.GetCenterPos(),z,5);}else{this.zoomToGeoPosition(c[0],c[1],z);}}this.setProperty("zoomlevel",z);}else{jQuery.sap.log.error(sap.ui.vbm.getResourceBundle().getText("GEOMAP_INVALID_ZOOM_LEVEL")+": "+z.toString(),"setZoomlevel","sap.ui.vbm.GeoMap");}}};
G.prototype.setInitialZoom=function(z){this.setZoomlevel(parseInt(z,10));};
G.prototype.openDetailWindow=function(p,P){this.mDTWindowCxt.key="";this.mDTWindowCxt.open=true;this.mDTWindowCxt.bUseClickPos=true;this.mDTWindowCxt.params=P?P:null;this.mDTWindowCxt.src={mClickGeoPos:p};this.invalidate(this);this.m_bWindowsDirty=true;};
G.prototype.goToStartPosition=function(){if(this.isRendered()){this.mVBIContext.GetMainScene().GoToInitialStart();}};
G.prototype.closeAnyDetailWindow=function(){this.mDTWindowCxt.open=false;this.invalidate(this);this.m_bWindowsDirty=true;};
G.prototype.getVoByInternalId=function(v){var a=null;var s=v.split(/\./);var A=this.getAggregatorContainer(s[0]);if(A&&A.findInstance){a=A.findInstance(s[1]);}return a;};
G.prototype.getClusteredSpots=function(c){var s=this.getInfoForCluster(c.getKey(),sap.ui.vbm.ClusterInfoType.ContainedVOs),a=s.map(function(b){return this.getVoByInternalId(b);}.bind(this));return a;};
G.prototype.setSelectionPropFireSelect=function(a){var n=a.N;for(var b=0;b<n.length;++b){var A=n[b];var e=A.E;var c;if((c=this.getAggregatorContainer(A.name))&&c.handleSelectEvent){c.handleSelectEvent(e);}}};
G.prototype.onGeoMapSubmit=function(e){var a=JSON.parse(e.mParameters.data);if(a.Data&&a.Data.Merge){this.handleChangedData(a.Data.Merge.N);}var c;if((c=this.getAggregatorContainer(a.Action.object))){c.handleEvent(a);if(a.Action.name=="click"&&a.Data&&a.Data.Merge){this.setSelectionPropFireSelect(a.Data.Merge);}}else{switch(a.Action.name){case"click":this.fireClick({pos:a.Action.AddActionProperties.AddActionProperty[0]['#']});break;case"contextMenu":this.fireContextMenu({clientX:a.Action.Params.Param[0]['#'],clientY:a.Action.Params.Param[1]['#'],pos:a.Action.AddActionProperties.AddActionProperty[0]['#'],data:a});break;case"drop":this.fireDrop({pos:a.Action.AddActionProperties.AddActionProperty[0]['#']});break;case"zoomChanged":this.fireZoomChanged({zoomLevel:a.Action.AddActionProperties.AddActionProperty[0]['#'],centerPoint:a.Action.AddActionProperties.AddActionProperty[1]['#'],viewportBB:{upperLeft:a.Action.Params.Param[3]['#'],lowerRight:a.Action.Params.Param[4]['#']}});break;case"centerChanged":this.fireCenterChanged({zoomLevel:a.Action.AddActionProperties.AddActionProperty[0]['#'],centerPoint:a.Action.AddActionProperties.AddActionProperty[1]['#'],viewportBB:{upperLeft:a.Action.Params.Param[3]['#'],lowerRight:a.Action.Params.Param[4]['#']}});break;case"select":if(a.Data&&a.Data.Merge.N){var s=this.getSelectedItems(a.Data.Merge.N);this.fireSelect({selected:s,data:a});this.setSelectionPropFireSelect(a.Data.Merge);}break;case"GetPosComplete":if(this.mIACreateCB){try{this.mIACreateCB(a.Action.Params.Param[0]['#']);this.mIACreateCB=null;}catch(b){this.mIACreateCB=null;throw b;}}break;case"keydown":if(!this.fireEvent("keyDown",{key:a.Action.Params.Param[0]['#'],code:a.Action.Params.Param[1]['#'],shift:a.Action.Params.Param[2]['#'],ctrl:a.Action.Params.Param[3]['#'],alt:a.Action.Params.Param[4]['#'],meta:a.Action.Params.Param[5]['#']},true)){e.preventDefault();}break;case"keypress":if(!this.fireEvent("keyPress",{key:a.Action.Params.Param[0]['#'],code:a.Action.Params.Param[1]['#'],shift:a.Action.Params.Param[2]['#'],ctrl:a.Action.Params.Param[3]['#'],alt:a.Action.Params.Param[4]['#'],meta:a.Action.Params.Param[5]['#']},true)){e.preventDefault();}break;case"keyup":if(!this.fireEvent("keyUp",{key:a.Action.Params.Param[0]['#'],code:a.Action.Params.Param[1]['#'],shift:a.Action.Params.Param[2]['#'],ctrl:a.Action.Params.Param[3]['#'],alt:a.Action.Params.Param[4]['#'],meta:a.Action.Params.Param[5]['#']},true)){e.preventDefault();}break;default:this.fireEvent(a.Action.name,a);break;}}};
G.prototype.onGeoMapContainerCreated=function(e){var a=e.getParameter("contentarea");if(a.m_ID){var c;if((c=this.getAggregatorContainer(a.m_ID))&&c.handleContainerCreated){c.handleContainerCreated(e);}}};
G.prototype.onGeoMapContainerDestroyed=function(e){var a=e.getParameter("contentarea");if(a.m_ID){var c;if((c=this.getAggregatorContainer(a.m_ID))&&c.handleContainerDestroyed){c.handleContainerDestroyed(e);}}if(this.mDTWindowCxt.open&&e.getParameter("id")==="Detail"){this.mDTWindowCxt.open=false;this.mDTWindowCxt.src=null;this.m_bWindowsDirty=true;}};
G.prototype.onGeoMapWindowClosed=function(e){if(this.mDTWindowCxt.open&&e.getParameter("id")==="Detail"){this.mDTWindowCxt.open=false;this.mDTWindowCxt.src=null;}};
G.prototype.init=function(){this.attachSubmit(this.onGeoMapSubmit,this);this.attachContainerCreated(this.onGeoMapContainerCreated,this);this.attachContainerDestroyed(this.onGeoMapContainerDestroyed,this);this.attachCloseWindow(this.onGeoMapWindowClosed,this);this.m_bVosDirty=true;this.m_bFCsDirty=true;this.m_bGJLsDirty=true;this.m_bClustersDirty=true;this.m_bMapConfigurationDirty=true;this.m_bClusteringDirty=true;this.m_bVisualFrameDirty=true;this.m_bRefMapLayerStackDirty=true;this.m_bResourcesDirty=true;this.m_bMapProvidersDirty=true;this.m_bMapLayerStacksDirty=true;this.m_bWindowsDirty=true;this.m_bMapconfigDirty=true;this.m_bLegendDirty=true;this.m_bSceneDirty=true;this.m_bActionsDirty=true;this.mbForceDataUpdate=false;this.bDataDeltaUpdate=false;this.bHandleChangedDataActive=false;this.mDTWindowCxt={open:false,src:null,key:"",params:null};V.prototype.init.apply(this,arguments);};
G.prototype.getSelectedItems=function(a){var c,C,s=[];if(!a){return null;}if(jQuery.type(a)==="object"){c=this.getAggregatorContainer(a.name);C=c.findSelected(true,a.E);s=s.concat(C);}else if(jQuery.type(a)==="array"){for(var n=0;n<a.length;++n){c=this.getAggregatorContainer(a[n].name);C=c.findSelected(true,a[n].E);if(C&&C.length){s=s.concat(C);}}}return s;};
G.prototype.getWindowsObject=function(){var w={"Set":[{"name":"Main","Window":{"id":"Main","caption":"MainWindow","type":"geo","refParent":"","refScene":"MainScene","modal":"true"}}],"Remove":[]};var L=this.getLegend();if(L){var a;if((a=this.getDomRef(L.getId()))){this.m_curLegendPos={right:parseInt(a.style.right,10),top:parseInt(a.style.top,10)};}var o=L.getTemplateObject();if(o.Set){w.Set=w.Set.concat(o.Set);}if(o.Remove){w.Remove=w.Remove.concat(o.Remove);}}if(this.mDTWindowCxt.src){var r,D;r=[{"name":"Detail"}];if(this.mDTWindowCxt.key){var c=this.getChildByKey(this.mDTWindowCxt.src,this.mDTWindowCxt.key);if(!c){this.mDTWindowCxt.open=false;this.mDTWindowCxt.src=null;this.mDTWindowCxt.key="";this.mDTWindowCxt.params=null;}else{this.mDTWindowCxt.src=c;}}if(this.mDTWindowCxt.open){D={"Set":[{"name":"Detail","Window":{"id":"Detail","type":"callout","refParent":"Main","refScene":"","modal":"true","caption":this.mDTWindowCxt.params.caption?this.mDTWindowCxt.params.caption:"","offsetX":this.mDTWindowCxt.params.offsetX?this.mDTWindowCxt.params.offsetX:"0","offsetY":this.mDTWindowCxt.params.offsetY?this.mDTWindowCxt.params.offsetY:"0"}}]};if(this.mDTWindowCxt.bUseClickPos==true&&this.mDTWindowCxt.src.mClickGeoPos){D.Set[0].Window.pos=this.mDTWindowCxt.src.mClickGeoPos;}else{D.Set[0].Window['pos.bind']=this.mDTWindowCxt.src.getParent().sId+"."+this.mDTWindowCxt.src.UniqueId+".P";}w.Set=w.Set.concat(D.Set);}w.Remove=w.Remove.concat(r);}return w;};
G.prototype.getActionArray=function(){var a=[];if(this.mEventRegistry["click"]){a.push({"id":"GMap1","name":"click","refScene":"MainScene","refVO":"Map","refEvent":"Click","AddActionProperty":[{"name":"pos"}]});}if(this.mEventRegistry["contextMenu"]){a.push({"id":"GMap2","name":"contextMenu","refScene":"MainScene","refVO":"Map","refEvent":"ContextMenu","AddActionProperty":[{"name":"pos"}]});}if(this.mEventRegistry["drop"]){a.push({"id":"GMap3","name":"drop","refScene":"MainScene","refVO":"Map","refEvent":"Drop","AddActionProperty":[{"name":"pos"}]});}if(this.mEventRegistry["zoomChanged"]){a.push({"id":"GMap4","name":"zoomChanged","refScene":"MainScene","refVO":"Map","refEvent":"ZoomChanged","AddActionProperty":[{"name":"zoom"},{"name":"centerpoint"},{"name":"pos"}]});}if(this.mEventRegistry["centerChanged"]){a.push({"id":"GMap5","name":"centerChanged","refScene":"MainScene","refVO":"Map","refEvent":"CenterChanged","AddActionProperty":[{"name":"zoom"},{"name":"centerpoint"},{"name":"pos"}]});}if(this.mEventRegistry["select"]){a.push({"id":"GMap6","name":"select","refScene":"MainScene","refVO":"General","refEvent":"Select"});}a.push({"id":"GMap7","name":"GetPosComplete","refScene":"MainScene","refVO":"General","refEvent":"CreateComplete"});if(this.mEventRegistry["keyDown"]){a.push({"id":"GMap8","name":"keydown","refScene":"MainScene","refVO":"","refEvent":"KeyDown"});}if(this.mEventRegistry["keyPress"]){a.push({"id":"GMap9","name":"keypress","refScene":"MainScene","refVO":"","refEvent":"KeyPress"});}if(this.mEventRegistry["keyUp"]){a.push({"id":"GMap10","name":"keyup","refScene":"MainScene","refVO":"","refEvent":"KeyUp"});}return a;};
G.prototype.getSceneVOdelta=function(c,n){var v=[];var r=[];var o={};for(var a=0,b=c.length;a<b;++a){o[c[a].id]=c[a];}for(var e=0;e<n.length;++e){if(o[n[e].id]){if(JSON.stringify(n[e])!=JSON.stringify(o[n[e].id])){r.push({"id":n[e].id,"type":"VO"});v.push(n[e]);}}else{v.push(n[e]);}delete o[n[e].id];}for(var i in o){r.push({"id":i,"type":"VO"});}var f={"Merge":{"name":"MainScene","type":"SceneGeo","SceneGeo":{"id":"MainScene","refMapLayerStack":this.getRefMapLayerStack()}}};if(r.length){f.Merge.SceneGeo.Remove=r;}if(v.length){f.Merge.SceneGeo.VO=v;}return f;};
G.prototype.minimizeApp=function(a){var t,s;s=null;if(!this.m_bWindowsDirty){(t=a)&&(t=t.SAPVB)&&(t=t.Windows)&&(s=JSON.stringify(t))&&(s==this.m_curWindows)&&(delete a.SAPVB.Windows)||(this.m_curWindows=s?s:this.m_curWindows);}else{this.m_bWindowsDirty=false;}s=null;(t=a)&&(t=t.SAPVB)&&(t=t.Scenes)&&(s=JSON.stringify(t))&&(s==this.m_curScenes)&&(delete a.SAPVB.Scenes)||(this.m_curScenes=s?s:this.m_curScenes);s=null;(t=a)&&(t=t.SAPVB)&&(t=t.Actions)&&(s=JSON.stringify(t))&&(s==this.m_curActions)&&(delete a.SAPVB.Actions)||(this.m_curActions=s?s:this.m_curActions);s=null;(t=a)&&(t=t.SAPVB)&&(t=t.DataTypes)&&(s=JSON.stringify(t))&&(s==this.m_curDataTypes)&&(delete a.SAPVB.DataTypes)||(this.m_curDataTypes=s?s:this.m_curDataTypes);if(!this.mbForceDataUpdate){s=null;(t=a)&&(t=t.SAPVB)&&(t=t.Data)&&(s=JSON.stringify(t))&&(s==this.m_curData)&&(delete a.SAPVB.Data)||(this.m_curData=s?s:this.m_curData);}else{this.mbForceDataUpdate=false;}return a;};
G.prototype.getAggregatorContainer=function(i){if(i!=="MainScene"){var c=this.getClusters();for(var n=0;n<c.length;++n){if(c[n].sId===i){return c[n];}}var v=this.getVos();for(var a=0,b=v.length;a<b;++a){if(v[a].sId===i){return v[a];}}var g=this.getGeoJsonLayers();for(var e=0;e<g.length;++e){if(i.indexOf(g[e].sId)===0){return g[e];}}var f=this.getFeatureCollections();for(var h=0;h<f.length;++h){if(i.indexOf(f[h].sId)===0){return f[h];}}var j=this.getLegend();if(j&&j.sId==i){return j;}}return null;};
G.prototype.update=function(){var a=jQuery.extend(true,{},G.oBaseApp);if(this.m_bResourcesDirty){this.updateResourceData(a);}var c={};if(this.m_bClusteringDirty||this.m_bClustersDirty){this.updateClustering(a,c);this.mCurClusterRefVOs=jQuery.extend(true,{},c);}else{c=jQuery.extend(true,{},this.mCurClusterRefVOs);}if(this.m_bSceneDirty){this.updateScene(a,c);}if(this.m_bResourcesDirty){this.updateResourceData(a);}if(this.m_bMapConfigurationDirty){this.updateMapConfiguration(a);}this.updateMapProviders(a);this.updateMapLayerStacks(a);this.updateWindows(a);var b;if((b=this.getLegend())){if(a.SAPVB.Actions){Array.prototype.push.apply(a.SAPVB.Actions.Set.Action,b.getActionArray());}}if(this.m_bActionsDirty&&!a.SAPVB.Actions){this.m_bActionsDirty=false;((a.SAPVB.Actions={}).Set={}).Action=[];}if(a.SAPVB.Actions){this.m_bActionsDirty=false;Array.prototype.push.apply(a.SAPVB.Actions.Set.Action,this.getActionArray());}return this.minimizeApp(a);};
G.prototype.updateMapProviders=function(a){if(!this.m_bMapProvidersDirty){delete a.SAPVB.MapProviders;}this.m_bMapProvidersDirty=false;};
G.prototype.updateMapLayerStacks=function(a){if(!this.m_bMapLayerStacksDirty){delete a.SAPVB.MapLayerStacks;}this.m_bMapLayerStacksDirty=false;};
G.prototype.updateWindows=function(a){a.SAPVB.Windows=this.getWindowsObject();};
G.prototype.updateScene=function(a,c){var s=[];var b=(c.Data)?c.Data:[];var e=[];var f=[];var g=(c.Actions)?c.Actions:[];var u=!this.m_bFCsDirty&&!this.m_bGJLsDirty&&!this.m_bVosDirty;this.updateGJLData(s,b,e,f,g,u);this.updateFCData(s,b,e,f,g,u);this.updateVOData(s,b,e,f,g,u);if(c.VO){s=s.concat(c.VO);}if(this.m_bLegendDirty){var L=this.getLegend();if(L){e.push({name:L.sId,type:"N"});b.push(L.getDataObject());f.push(L.getTypeObject());}}var _=JSON.stringify(s);var m=true;if(!this.m_saVO){((((a.SAPVB.Scenes={}).Set={}).SceneGeo={"id":"MainScene","refMapLayerStack":this.getRefMapLayerStack(),"initialZoom":this.getProperty("zoomlevel"),"initialStartPosition":this.getProperty("centerPosition"),"scaleVisible":this.getScaleVisible().toString(),"navControlVisible":this.getNavcontrolVisible().toString(),"rectSelect":this.getRectangularSelection().toString(),"lassoSelect":this.getLassoSelection().toString(),"rectZoom":this.getRectZoom().toString(),"VisualFrame":this.getVisualFrame(),"NavigationDisablement":{"zoom":this.getDisableZoom().toString(),"move":this.getDisablePan().toString()},"ariaLabel":this.getAriaLabel()}).VO=s);}else if(this.m_bRefMapLayerStackDirty||!(this.m_saVO===_)){(a.SAPVB.Scenes=this.getSceneVOdelta(JSON.parse(this.m_saVO),s));}else{m=false;}this.m_saVO=_;if(!this.isRendered()&&a.SAPVB.Scenes&&a.SAPVB.Scenes.Merge){if(a.SAPVB.Scenes.Merge.SceneGeo.initialStartPosition!==this.getProperty("centerPosition")){a.SAPVB.Scenes.Merge.SceneGeo.initialStartPosition=this.getProperty("centerPosition");}if(a.SAPVB.Scenes.Merge.SceneGeo.initialZoom!==this.getProperty("zoomlevel")){a.SAPVB.Scenes.Merge.SceneGeo.initialZoom=this.getProperty("zoomlevel");}}var n;if(this.bDataDeltaUpdate){a.SAPVB.Data={};a.SAPVB.Data.Set=[];for(n=0;n<b.length;++n){a.SAPVB.Data.Set.push({name:b[n].name,type:"N",N:b[n]});}}else{a.SAPVB.Data={};if(e.length){a.SAPVB.Data.Remove=[];for(n=0;n<e.length;++n){a.SAPVB.Data.Remove.push(e[n]);}}a.SAPVB.Data.Set=[];for(n=0;n<b.length;++n){a.SAPVB.Data.Set.push({name:b[n].name,type:"N",N:b[n]});}}if(m){(((a.SAPVB.DataTypes={}).Set={}).N=f);}(((a.SAPVB.Actions={}).Set={}).Action=g);this.resetDirtyStates();};
G.prototype.resetDirtyStates=function(){this.m_bRefMapLayerStackDirty=this.m_bSceneDirty=this.m_bFCsDirty=this.m_bGJLsDirty=this.m_bVosDirty=false;};
G.prototype.updateMapConfiguration=function(a){if(!this.m_bMapConfigurationDirty){return;}this.m_bMapConfigurationDirty=false;var c=this.getMapConfiguration();if(c){a.SAPVB.MapProviders={Set:{MapProvider:c.MapProvider}};a.SAPVB.MapLayerStacks={Set:{MapLayerStack:c.MapLayerStacks}};}return;};
G.prototype.updateClustering=function(a,c){var C=this.getClusters();var o=null;if(C.length){o={Cluster:[]};c.VO=[];c.Actions=[];c.Data=[];for(var n=0,b;n<C.length;++n){b=C[n];c.VO.push(b.getTemplateObject());c.Actions=c.Actions.concat(b.getActionArray());o.Cluster.push(b.getClusterDefinition());}}else if(this.m_bClusteringDirty){o=this.getClustering();}if(o){a.SAPVB.Clustering={Set:o};}else if(this.mCurClusterRefVOs&&this.mCurClusterRefVOs.VO&&this.mCurClusterRefVOs.VO.length>0){a.SAPVB.Clustering={Set:[]};}this.m_bClusteringDirty=this.m_bClustersDirty=false;};
G.prototype.updateResourceData=function(a){if(!this.m_bResourcesDirty){return;}this.m_bResourcesDirty=false;var r=this.getResources();((a.SAPVB.Resources={}).Set={}).Resource=[];function R(){var a=this.update();this.load(a);}var f=function(c){if(!c.m_Img){return;}if(!c.m_Img.complete){return;}var e=document.createElement('canvas');e.width=c.m_Img.width;e.height=c.m_Img.height;var g=e.getContext('2d');g.drawImage(c.m_Img,0,0);c.mProperties.value=e.toDataURL();delete c.m_Img;this.m_bResourcesDirty=true;window.setTimeout(R.bind(this),10);};for(var n=0,b=r.length;n<b;++n){var c=r[n];if(!c.mProperties.value&&c.mProperties.src){var i=document.createElement('img');i.crossOrigin='anonymous';c.m_Img=i;i.onload=f.bind(this,c);i.src=c.mProperties.src;}else{a.SAPVB.Resources.Set.Resource.push({"name":(c.mProperties.name?c.mProperties.name:c.sId),"value":c.mProperties.value});}}return;};
G.prototype.updateVOData=function(s,a,b,c,e,u){var v=this.getVos();for(var n=0,f=v.length;n<f;++n){var o=v[n];var D=o.aDiff;s.push(o.getTemplateObject());c.push(o.getTypeObject());Array.prototype.push.apply(e,o.getActionArray());if(D&&D.length&&o.m_bAggChange&&u){var g=o.getDataDeltaObject(D);if(g.oData&&g.oData.E&&g.oData.E.length){a.push(g.oData);}if(g.aRemoveData){for(var h=0;h<g.aRemoveData.length;++h){b.push(g.aRemoveData[h]);}}}else if(!u||o.m_bAggRenew){b.push(o.getDataRemoveObject());if(o instanceof sap.ui.vbm.VoAggregation){o.resetIndices();}a.push(o.getDataObject());}if(o instanceof sap.ui.vbm.VoAggregation){o.aDiff=[];o.updateIdxArray();o.m_bAggRenew=o.m_bAggChange=false;}}};
G.prototype.updateGJLData=function(s,a,b,c,e,u){var L=this.getGeoJsonLayers();for(var n=0,f=L.length;n<f;++n){var o=L[n];Array.prototype.push.apply(s,o.getTemplateObjects());Array.prototype.push.apply(c,o.getTypeObjects());Array.prototype.push.apply(e,o.getActionArray());Array.prototype.push.apply(b,o.getDataRemoveObjects());Array.prototype.push.apply(a,o.getDataObjects());}};
G.prototype.updateFCData=function(s,a,b,c,e,u){var f=this.getFeatureCollections();for(var n=0,g=f.length;n<g;++n){var F=f[n];Array.prototype.push.apply(s,F.getTemplateObjects());Array.prototype.push.apply(c,F.getTypeObjects());Array.prototype.push.apply(e,F.getActionArray());Array.prototype.push.apply(b,F.getDataRemoveObjects());Array.prototype.push.apply(a,F.getDataObjects());}};
G.prototype.invalidate=function(s){this.m_bSceneDirty=true;if(s instanceof sap.ui.vbm.VoAggregation){this.m_bWindowsDirty=true;this.bDataDeltaUpdate=this.bHandleChangedDataActive;}else if(s instanceof sap.ui.vbm.Legend){this.m_bLegendDirty=true;}else if(s instanceof sap.ui.vbm.GeoJsonLayer){if(s instanceof sap.ui.vbm.FeatureCollection){this.m_bFCsDirty=true;}else{this.m_bGJLsDirty=true;}}else if(s instanceof sap.ui.vbm.ClusterBase){this.m_bClustersDirty=true;}sap.ui.core.Control.prototype.invalidate.apply(this,arguments);};
G.prototype.openContextMenu=function(t,i,m){if(m&&m.vbi_data&&m.vbi_data.VBIName=="DynContextMenu"){if(!this.mVBIContext.m_Menus){this.mVBIContext.m_Menus=new window.VBI.Menus();}this.mVBIContext.m_Menus.m_menus.push(m);var a={"SAPVB":{"version":"2.0","Automation":{"Call":{"earliest":"0","handler":"CONTEXTMENUHANDLER","instance":i.sId,"name":"SHOW","object":t,"refID":"CTM","Param":[{"name":"x","#":i.mClickPos[0]},{"name":"y","#":i.mClickPos[1]},{"name":"scene","#":"MainScene"}]}}}};this.loadHtml(a);}};
G.prototype.addResourceIfNeeded=function(r){var R=this.getResources();for(var n=0,a=R.length;n<a;++n){if(R[n].getName()===r){return;}}if(G.bEncodedSpotImagesAvailable==false){var p=sap.ui.resource("sap.ui.vbm","themes/base/img/Pin_images.json");var o=jQuery.sap.syncGetJSON(p);G.bEncodedSpotImageData=o.data;G.bEncodedSpotImagesAvailable=true;}if(G.bEncodedSpotImageData){for(var k in G.bEncodedSpotImageData){if(r==k){this.addResource(new sap.ui.vbm.Resource({name:k,value:G.bEncodedSpotImageData[k]}));}}}else{this.addResource(new sap.ui.vbm.Resource({name:r,src:sap.ui.resource("sap.ui.vbm","themes/base/img/"+r)}));}this.m_bResourcesDirty=true;};
G.prototype.handleChangedData=function(n){try{this.bHandleChangedDataActive=true;if(n&&n.length){for(var a=0,N,c;a<n.length;++a){N=n[a];c=this.getAggregatorContainer(N.name);if(c){c.handleChangedData(N.E);}}}this.bHandleChangedDataActive=false;}catch(e){this.bHandleChangedDataActive=false;throw e;}};
G.prototype.getChildByKey=function(c,k){var a,C=null;if((a=c.getParent())){if(a instanceof sap.ui.vbm.VoAggregation){if((this.getAggregatorContainer(a.getId()))){C=a.findInstanceByKey(k);}}else{C=a.findInstance(k);}}return C;};
G.prototype.zoomToAreasById=function(u,c){if(c===undefined||c===null){c=0.9999;}u=[].concat(u);var a=this.getVos().filter(function(v){return v instanceof sap.ui.vbm.Areas;});var b=a.reduce(function(p,f){return p.concat(f.getItems());},[]);var e=b.map(function(f){if(u.indexOf(f.getId())!==-1){return f.UniqueId;}else{return null;}});e=e.filter(function(f){return f?f:false;});var s=this.mVBIContext.GetMainScene();s.ZoomTo(e,c);return this;};
return G;},true);
/*
 * ! SAP UI development toolkit for HTML5 (SAPUI5) (c) Copyright 2009-2012 SAP AG. All rights reserved
 */
sap.ui.predefine('sap/ui/vbm/VBI',['jquery.sap.global','./library','sap/ui/core/Control','./lib/sapvbi'],function(q,l,C,s){"use strict";
var V=C.extend("sap.ui.vbm.VBI",{metadata:{library:"sap.ui.vbm",properties:{width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'800px'},height:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'600px'},config:{type:"object",group:"Misc",defaultValue:null},plugin:{type:"boolean",group:"Misc",defaultValue:false},rectangularSelection:{type:"boolean",group:"Misc",defaultValue:false},lassoSelection:{type:"boolean",group:"Misc",defaultValue:false},rectZoom:{type:"boolean",group:"Misc",defaultValue:false},allowKeyEventRepeat:{type:"boolean",group:"Behavior",defaultValue:true},keyEventDelay:{type:"int",group:"Behavior",defaultValue:250},enableOverlappingTest:{type:"boolean",group:"Behavior",defaultValue:true}},events:{submit:{parameters:{data:{type:"string"}}},thumbnailClick:{parameters:{pos:{type:"string"},zoomLevel:{type:"int"}}},render:{parameters:{canvas:{type:"object"}}},changeTrackingMode:{parameters:{mode:{type:"int"},bSet:{type:"boolean"}}},zoom:{parameters:{canvas:{type:"object"}}},move:{parameters:{canvas:{type:"object"}}},openWindow:{parameters:{contentarea:{type:"object"},id:{type:"string"}}},closeWindow:{parameters:{contentarea:{type:"object"},id:{type:"string"}}},containerCreated:{parameters:{contentarea:{type:"object"},id:{type:"string"}}},containerDestroyed:{parameters:{contentarea:{type:"object"},id:{type:"string"}}}}}});
V.RttMap={};
V.prototype.exit=function(){if(this.getPlugin()){var p=this.getPlugInControl();if(p){p.OnSubmit=null;}}else if(this.mVBIContext){this.mVBIContext.clear();}if(this.resizeID!=""){sap.ui.core.ResizeHandler.deregister(this.resizeID);this.resizeID="";}};
V.prototype.resize=function(e){var c=(this.oControl!=undefined)?this.oControl:this;var a=c.mVBIContext;if(a){var b=a.GetMainScene();if(b){b.resizeCanvas(e);}if(a.m_Windows){a.m_Windows.NotifyResize();}}};
V.prototype.init=function(){this.m_aLoadQueue=null;if(!this.getPlugin()){this.mVBIContext=new VBI.VBIContext(this);}this.resizeID="";this.m_renderList=[];};
V.prototype.loadNative=function(d){var a=this.getId();var b=document.getElementById('VBI'+a);if(!b){return;}var c=function(f){try{var D;if((D=JSON.parse(f))){var v=D.SAPVB;var t=JSON.stringify(v,null,'  ');this.fireSubmit({data:t});}}catch(e){if(VBI.m_bTrace){VBI.Trace("Error submitting plugin event");}}};if(q.type(d)=='object'){var t=JSON.stringify(d,null,'  ');try{b.Load(t);b.OnSubmit=c.bind(this);}catch(e){}}else if(q.type(d)=='string'){try{b.Load(d);b.OnSubmit=c.bind(this);}catch(e){}}};
V.prototype.loadHtml=function(d){var a=this.getId();var b=null;if(typeof d==='string'){b=JSON.parse(d.indexOf('{')?d.substr(d.indexOf('{')):d);}else if(typeof d==='object'){b=d;}if(!b){return;}if(!b["SAPVB"]){var m;if(this.mVBIContext&&(m=(new VBI.Adaptor(this.mVBIContext)).CreateLoadData(b))){this.loadHtml(m);return;}else{return;}}var M=false;var c=false;var e=false;var f=false;var g=false;var h=false;if(q.type(b)==='object'){if(b.SAPVB){if(b.SAPVB.Config){this.mVBIContext.GetConfig().load(b.SAPVB.Config,this.mVBIContext);}if(b.SAPVB.Resources){this.mVBIContext.GetResources().load(b.SAPVB.Resources,this.mVBIContext);f=true;}if(b.SAPVB.DataTypes){if(!this.mVBIContext.m_DataTypeProvider){this.mVBIContext.m_DataTypeProvider=new VBI.DataTypeProvider();}this.mVBIContext.m_DataTypeProvider.load(b.SAPVB.DataTypes,this.mVBIContext);}if(b.SAPVB.Data){if(!this.mVBIContext.m_DataProvider){this.mVBIContext.m_DataProvider=new VBI.DataProvider();}this.mVBIContext.m_DataProvider.load(b.SAPVB.Data,this.mVBIContext);M=true;}if(b.SAPVB.MapProviders){if(!this.mVBIContext.m_MapProviders){this.mVBIContext.m_MapProviders=new VBI.MapProviders();}this.mVBIContext.m_MapProviders.load(b.SAPVB.MapProviders,this.mVBIContext);h=true;}if(b.SAPVB.MapLayerStacks){if(!this.mVBIContext.m_MapLayerStackManager){this.mVBIContext.m_MapLayerStackManager=new VBI.MapLayerStackManager(this.mVBIContext);}this.mVBIContext.m_MapLayerStackManager.load(b.SAPVB.MapLayerStacks,this.mVBIContext);h=true;}if(b.SAPVB.Windows){if(!this.mVBIContext.m_Windows){this.mVBIContext.m_Windows=new VBI.Windows();}this.mVBIContext.m_Windows.load(b.SAPVB.Windows,this.mVBIContext);e=true;}if(b.SAPVB.Actions){if(!this.mVBIContext.m_Actions){this.mVBIContext.m_Actions=new VBI.Actions();}this.mVBIContext.m_Actions.load(b.SAPVB.Actions,this.mVBIContext);}if(b.SAPVB.Automation){if(!this.mVBIContext.m_Automations){this.mVBIContext.m_Automations=new VBI.Automations();}this.mVBIContext.m_Automations.load(b.SAPVB.Automation,this.mVBIContext);}if(b.SAPVB.Menus){if(!this.mVBIContext.m_Menus){this.mVBIContext.m_Menus=new VBI.Menus();}this.mVBIContext.m_Menus.load(b.SAPVB.Menus,this.mVBIContext);}if(b.SAPVB.Clustering){if(!this.mVBIContext.m_Clustering){this.mVBIContext.m_Clustering=new VBI.Clustering();}this.mVBIContext.m_Clustering.load(b.SAPVB.Clustering,this.mVBIContext);g=true;}if(b.SAPVB.Scenes){if(!this.mVBIContext.m_SceneManager){this.mVBIContext.m_SceneManager=new VBI.SceneManager();}this.mVBIContext.m_SceneManager.load(b.SAPVB.Scenes,this.mVBIContext);c=true;}else if(h){var j=this.mVBIContext.m_SceneManager.m_SceneArray;for(var i=0;i<j.length;++i){if(j[i].RefreshMapLayerStack){j[i].RefreshMapLayerStack();}}}}if(M){if(this.mVBIContext.m_Windows){this.mVBIContext.m_Windows.NotifyDataChange();}}if(c||e){if(this.mVBIContext.m_Windows){this.mVBIContext.m_Windows.Awake(a);}}if(c||M||g||f){if(this.mVBIContext.m_Windows){this.mVBIContext.m_Windows.RenderAsync();}}}};
V.prototype.load=function(d){if(!d){return;}if(!this.isRendered()){if(!this.m_aLoadQueue){this.m_aLoadQueue=[];}if(d.SAPVB&&d.SAPVB.Scenes&&d.SAPVB.Scenes.Merge&&d.SAPVB.Scenes.Merge.SceneGeo){var p=d.SAPVB.Scenes.Merge.SceneGeo.initialStartPosition;var z=d.SAPVB.Scenes.Merge.SceneGeo.initialZoom;if(p||z){var a=this.m_aLoadQueue;for(var i=0;i<a.length;++i){if(a[i].SAPVB&&a[i].SAPVB.Scenes&&a[i].SAPVB.Scenes.Set&&a[i].SAPVB.Scenes.Set.SceneGeo){var e=a[i].SAPVB.Scenes.Set.SceneGeo;e.initialStartPosition=p||e.initialStartPosition;e.initialZoom=z||e.initialZoom;break;}}}}this.m_aLoadQueue.push(d);return;}if(this.getPlugin()){this.loadNative(d);}else{this.loadHtml(d);}if(this.resizeID==""&&this.mVBIContext.GetMainScene()){this.resize();this.resizeID=sap.ui.core.ResizeHandler.register(this,this.resize);}};
/**
	 * Returns a Screenshot of the Overlay. Please note that the map cannot be included due to browser restrictions. Function returns the visible part
	 * of the Canvas excluding map, copyright info, navigation control, scaler, legend, detail windows, container elements. Analytic Maps are returned
	 * as they are not treated as "maps" internally. Modes 2 & 3 are experimental, trying to load the map (this may work on inhouse servers with
	 * adapted settings, standard configurations should fail)
	 *
	 * @param {int} [iMode] 0: Overlay only; 1 (default) and 3: include Labels; 2 and 3: try to include maps (will return "" if not possible)
	 * @returns {string} Base64 encoded picture (PNG format) on success, "" otherwise
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */

V.prototype.getPicOfOverlay=function(m){var a=this.mVBIContext.GetMainScene();if(!(a&&a.GetOverlayPicture)){return"";}return a.GetOverlayPicture(m);};
V.prototype.minimize=function(n,N,f,F,a,b,c,t){var v=this.mVBIContext;if(!v.moThumbnail){v.moThumbnail={bThumbnailed:false};}var d=v.moThumbnail;d.nThumbWidth=n;d.nThumbHeight=N;d.strFont=a;d.strCol=b;d.nFontPos=c;d.strText=t;if(f){d.nFullWidth=f;}if(F){d.nFullHeight=F;}var e=v.GetMainScene();if(e){v.DoMinimize(e);}};
V.prototype.maximize=function(f,F){var a=this.mVBIContext.GetMainScene();if(a&&this.mVBIContext.moThumbnail){var n,b;if(f){n=String(f)+"px";}else{n=this.mVBIContext.moThumbnail.strOrgWidth?this.mVBIContext.moThumbnail.strOrgWidth:this.getWidth();}if(F){b=String(F)+"px";}else{b=this.mVBIContext.moThumbnail.strOrgHeight?this.mVBIContext.moThumbnail.strOrgHeight:this.getHeight();}this.mVBIContext.m_bThumbnail=false;this.setWidth(n);this.setHeight(b);a.m_Ctx.moThumbnail=undefined;a.resizeCanvas(0);}};
V.prototype.zoomToGeoPosition=function(L,f,i){var a=null;if((a=this.mVBIContext.GetMainScene())){if(q.type(L)=='array'&&q.type(f)=='array'){if(L.length>1&&f.length>1){a.ZoomToMultiplePositions(L,f);}else{a.ZoomToGeoPosition(VBI.MathLib.DegToRad([parseFloat(L[0]),parseFloat(f[0])]),parseFloat(i));}}else{a.ZoomToGeoPosition(VBI.MathLib.DegToRad([parseFloat(L),parseFloat(f)]),parseFloat(i));}}};
V.prototype.zoomToAreas=function(a,c){var b=null;if((b=this.mVBIContext.GetMainScene())){b.ZoomToAreas(a,c);}};
V.prototype.getInfoForCluster=function(i,t){var a=null;if((a=this.mVBIContext.GetMainScene())){return a.getInfoForCluster(i,t);}return null;};
V.prototype.setRectangularSelection=function(S){var a=this.mVBIContext.GetMainScene();if(a){if(!(S&&a.m_nInputMode==window.VBI.InputModeRectSelect)){a.endTrackingMode();if(S){this.setProperty("lassoSelection",false,true);this.setProperty("rectZoom",false,true);new a.RectSelection();a.m_Ctx.onChangeTrackingMode(VBI.InputModeRectSelect,true);}}}this.setProperty("rectangularSelection",S,true);return this;};
V.prototype.setLassoSelection=function(S){var a=this.mVBIContext.GetMainScene();if(a){if(!(S&&a.m_nInputMode==window.VBI.InputModeLassoSelect)){a.endTrackingMode();if(S){this.setProperty("rectangularSelection",false,true);this.setProperty("rectZoom",false,true);new a.LassoSelection();a.m_Ctx.onChangeTrackingMode(VBI.InputModeLassoSelect,true);}}}this.setProperty("lassoSelection",S,true);return this;};
V.prototype.setRectZoom=function(S){var a=this.mVBIContext.GetMainScene();if(a){if(!(S&&a.m_nInputMode==window.VBI.InputModeRectZoom)){a.endTrackingMode();if(S){this.setProperty("lassoSelection",false,true);this.setProperty("rectangularSelection",false,true);new a.RectangularZoom();a.m_Ctx.onChangeTrackingMode(VBI.InputModeRectZoom,true);}}}this.setProperty("rectZoom",S,true);return this;};
V.prototype.onAfterRendering=function(){if(this.$oldContent.length>0){this.$().append(this.$oldContent);}if(this.m_aLoadQueue){var n;for(n=0;n<this.m_aLoadQueue.length;++n){this.load(this.m_aLoadQueue[n]);}this.m_aLoadQueue=null;}if(this.resizeID==""&&this.mVBIContext.GetMainScene()){this.resize();this.resizeID=sap.ui.core.ResizeHandler.register(this,this.resize);}var a=this.getId();if(this.mVBIContext.m_Windows){this.mVBIContext.m_Windows.Awake(a);}var e=q(this.getDomRef()).children(".vbi-hidden").children();for(var i=0,E;i<e.length;++i){E=e[i];var d=document.getElementById(E.attributes.getNamedItem("data").nodeValue);if(d){d.appendChild(E.firstChild);E.parentNode.removeChild(E);}}};
V.prototype.onBeforeRendering=function(){this.$oldContent=sap.ui.core.RenderManager.findPreservedContent(this.getId());};
V.prototype.isRendered=function(){return this.getDomRef()?true:false;};
V.prototype.getPlugInControl=function(){var a=this.getId();var e=document.getElementById('VBI'+a);return e?e:null;};
V.prototype.setConfig=function(c){if(c){return this.load(c);}};
V.prototype.setWidth=function(v){if(typeof v==='number'){this.setProperty("width",parseInt(v,10).toString()+"px");}else{this.setProperty("width",v);}};
V.prototype.setHeight=function(v){if(typeof v==='number'){this.setProperty("height",parseInt(v,10).toString()+"px");}else{this.setProperty("height",v);}};
V.prototype.addRenderItem=function(c,t){this.m_renderList.push({control:c,data:t});this.invalidate();};
return V;});
sap.ui.require.preload({
	"sap/ui/vbm/manifest.json":'{"_version":"1.9.0","sap.app":{"id":"sap.ui.vbm","type":"library","embeds":[],"applicationVersion":{"version":"1.71.11"},"title":"SAP UI library: sap.ui.vbm","description":"SAP UI library: sap.ui.vbm","ach":"CA-GTF-VBZ","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_belize","sap_belize_plus","sap_bluecrystal","sap_fiori_3","sap_fiori_3_dark","sap_fiori_3_hcb","sap_fiori_3_hcw","sap_hcb","sap_mvi"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.71","libs":{"sap.ui.core":{"minVersion":"1.71.34"},"sap.ui.commons":{"minVersion":"1.71.34","lazy":true},"sap.ui.unified":{"minVersion":"1.71.34","lazy":true}}},"library":{"i18n":false,"content":{"controls":["sap.ui.vbm.AnalyticMap","sap.ui.vbm.GeoMap","sap.ui.vbm.VBI","sap.ui.vbm.Cluster","sap.ui.vbm.Viewport"],"elements":["sap.ui.vbm.Area","sap.ui.vbm.Areas","sap.ui.vbm.Box","sap.ui.vbm.Boxes","sap.ui.vbm.Circle","sap.ui.vbm.Circles","sap.ui.vbm.Container","sap.ui.vbm.Containers","sap.ui.vbm.DragSource","sap.ui.vbm.DropTarget","sap.ui.vbm.Feature","sap.ui.vbm.FeatureCollection","sap.ui.vbm.GeoJsonLayer","sap.ui.vbm.GeoCircle","sap.ui.vbm.GeoCircles","sap.ui.vbm.Legend","sap.ui.vbm.LegendItem","sap.ui.vbm.Pie","sap.ui.vbm.PieItem","sap.ui.vbm.Pies","sap.ui.vbm.Region","sap.ui.vbm.Resource","sap.ui.vbm.Route","sap.ui.vbm.Routes","sap.ui.vbm.Spot","sap.ui.vbm.Spots","sap.ui.vbm.VoAggregation","sap.ui.vbm.VoBase","sap.ui.vbm.ClusterBase","sap.ui.vbm.ClusterTree","sap.ui.vbm.ClusterGrid","sap.ui.vbm.ClusterDistance","sap.ui.vbm.Heatmap","sap.ui.vbm.HeatPoint","sap.ui.vbm.ClusterContainer","sap.ui.vbm.Adapter","sap.ui.vbm.Adapter3D"],"types":["sap.ui.vbm.ClusterInfoType","sap.ui.vbm.SemanticType"],"interfaces":[]}}}}',
	"sap/ui/vbm/lib/sapactions.js":function(){
/* the subsequent text seems not to contain a copyright or license statement */

VBI.Actions=function(){"use strict";var b={};b.m_actions=[];b.clear=function(){for(var n=0;n<b.m_actions.length;++n){b.m_actions[n].clear();}b.m_actions=[];};b.Set=function(d,i,c){if(i){var a;if((a=b.findById(i))){a.load(d,c);}else{a=new VBI.Actions.Action();a.load(d,c);b.m_actions.push(a);}return;}};b.Remove=function(d,i,c){if(i){var a;if((a=b.findById(i))){b.m_actions.splice(a.m_nArrayIndex,1);}return;}};b.load=function(d,c){var n;if(d.Remove){if(jQuery.type(d.Remove)=='array'){for(n=0;n<d.Remove.length;++n){b.Remove(d.Remove[n],d.Remove[n].id,c);}}}if(d.Set){if(jQuery.type(d.Set)=='array'){for(n=0;n<d.Set.length;++n){b.Set(d.Set[n].Action,d.Set[n].id,c);}return;}if(!d.Set.id){b.clear();}if(jQuery.type(d.Set.Action)=='object'){b.Set(d.Set.Action,d.Set.Action.id,c);}else if(jQuery.type(d.Set.Action)=='array'){for(n=0;n<d.Set.Action.length;++n){b.Set(d.Set.Action[n],d.Set.Action[n].id,c);}}}};b.findById=function(i){var A=b.m_actions,l=A.length;for(var n=0;n<l;++n){var a=A[n];if(a&&(a.m_id==i)){a.m_nArrayIndex=n;return a;}}};b.findAction=function(e,s,v,a){var i=null;if(jQuery.type(v)=='object'){i=v.m_ID;}else if(jQuery.type(v)=='string'){i=v;}var t,l=b.m_actions.length;for(var n=0;n<l;++n){t=b.m_actions[n];if((e?(t.m_refEvent==e):true)&&(s?(t.m_refScene==s.m_ID):true)&&(v?(t.m_refVO==i):true)&&(a?(t.m_id==a):true)){return t;}}return null;};VBI.Actions.Action=function(){var a={};a.m_id=0;a.m_name=null;a.m_refScene=null;a.m_refVO=null;a.m_refEvent=null;a.m_additionalProperties=[];a.clear=function(){a.m_addProperties=null;};a.load=function(d,c){a.m_id=d.id;a.m_name=d.name;a.m_refScene=d.refScene;a.m_refVO=d.refVO;a.m_refEvent=d.refEvent;a.m_additionalProperties=[];if(d.AddActionProperty){if(jQuery.type(d.AddActionProperty)=='object'){a.m_additionalProperties.push(d.AddActionProperty.name);}else if(jQuery.type(d.AddActionProperty)=='array'){for(var n=0;n<d.AddActionProperty.length;++n){a.m_additionalProperties.push(d.AddActionProperty[n].name);}}}};return a;};return b;};
},
	"sap/ui/vbm/lib/sapautomations.js":function(){
VBI.Automations=function(){"use strict";var a={};a.m_automations=[];a.clear=function(){for(var n=0;n<a.m_automations.length;++n){a.m_automations[n].clear();}a.m_automations=[];};a.load=function(d,c){if(d.Call){var b={};if(jQuery.type(d.Call)=='object'){b=new VBI.Automations.Automation();b.load(d.Call,c);a.m_automations.push(b);}else if(jQuery.type(d.Call)=='array'){for(var n=0;n<d.Call.length;++n){b=new VBI.Automations.Automation();b.load(d.Call[n],c);a.m_automations.push(b);}}}};VBI.Automations.Automation=function(){var b={};b.m_additionalProperties=[];b.clear=function(){b.m_addProperties=null;};b.createHandler=function(d,h){switch(h){case"CONTEXTMENUHANDLER":return new VBI.ContextMenuHandler(d);case"FLYTOHANDLER":return new VBI.FlyToHandler(d);case"OBJECTCREATIONHANDLER":return new VBI.ObjectCreationHandler(d);case"LOOPBACKHANDLER":return new VBI.LoopBackHandler(d);default:return undefined;}};b.getMainScene=function(c){if(c.m_SceneManager.m_SceneArray.length==1){return c.m_SceneManager.m_SceneArray[0].m_ID;}return undefined;};b.load=function(d,c){b.m_handlerName=d.handler;b.m_handler=b.createHandler(d.Param,d.handler);if(!b.m_handler){return;}b.m_handler.m_Ctx=c;b.m_name=d.name;if(b.m_handler.m_scene==undefined){b.m_handler.m_scene=(d.scene==undefined?b.getMainScene(c):d.scene);}b.m_delay=(d.delay==undefined?1:d.delay);b.m_earliest=(d.earliest==undefined?1:d.earliest);b.m_retryAfterMS=(d.retryAfterMS==undefined?0:d.retryAfterMS);b.m_reattempts=(d.reattempts==undefined?-1:d.reattempts);b.m_handler.m_refID=(d.refID==undefined?"":d.refID);b.m_handler.m_refObj=(d.object==undefined?"":d.object);b.m_handler.m_refInstance=(d.object==undefined?"":d.instance);b.m_handler.m_Name=d.name;b.m_nAttempts=0;var n=new Date();var r=n.getTime()-c.m_StartupTime;var e=b.m_delay;if(r<b.m_earliest){e=Math.max(e,b.m_earliest-r);}b.m_AnimZoomTimer=window.setInterval(b.startAutomation,e);};b.startAutomation=function(){window.clearInterval(b.m_AnimZoomTimer);if(!b.m_handler.start()&&b.m_retryAfterMS){b.m_nAttempts++;if((b.m_reattempts==-1)||(b.m_nAttempts<b.m_reattempts)){b.m_AnimZoomTimer=window.setInterval(b.startAutomation,b.m_retryAfterMS);}}};return b;};return a;};
VBI.FlyToHandler=function(d){"use strict";var f={};f.cnt=0;for(var i=0;i<d.length;++i){if(d[i].name==="x"){f.m_x=d[i]["#"];}if(d[i].name==="y"){f.m_y=d[i]["#"];}if(d[i].name==="lod"){f.m_lod=d[i]["#"];}if(d[i].name==="mode"){f.m_mode=d[i]["#"];}if(d[i].name==="velocity"){f.m_velocity=d[i]["#"];}if(d[i].name==="basetime"){f.m_basetime=d[i]["#"];}if(d[i].name==="scene"){f.m_scene=d[i]["#"];}if(d[i].name==="zoomToAll"){f.m_zoomToAll=d[i]["#"];}}f.start=function(){if(VBI.m_bTrace){VBI.m_bTrace&&VBI.Trace("FlyTo triggered to "+f.m_x+","+f.m_y+","+f.m_lod+" on scene "+f.m_scene);}if(f.m_scene==undefined||f.m_x==undefined||f.m_y==undefined||f.m_lod==undefined){return true;}var s=f.m_Ctx.m_SceneManager.GetSceneByName(f.m_scene);if(s){if(f.m_zoomToAll){s.ZoomToAll();}else{var l=f.m_lod;var a=VBI.MathLib.DegToRad([parseFloat(f.m_x),parseFloat(f.m_y)]);s.ZoomToGeoPosition(a,l);}}return true;};return f;};
VBI.ContextMenuHandler=function(d){"use strict";var c={};c.cnt=0;for(var i=0;i<d.length;++i){if(d[i].name==="x"){c.m_x=parseInt(d[i]["#"],10);}if(d[i].name==="y"){c.m_y=parseInt(d[i]["#"],10);}if(d[i].name==="scene"){c.m_scene=d[i]["#"];}}c.start=function(){var s=c.m_Ctx.m_SceneManager.GetSceneByName(c.m_scene);var a=c.m_Ctx;var m=a.m_Menus.findMenuByID(c.m_refID);if(!s){return true;}m.vbi_data.scene=c.m_scene;m.vbi_data.object=c.m_refObj;m.vbi_data.instance=c.m_refInstance;if(a.m_strOpenMenu){a.m_Menus.findMenuByID(a.m_strOpenMenu).close();}if(a.m_HitMenu){a.m_HitMenu.close();a.m_HitMenu.destroy();}a.m_strOpenMenu=c.m_refID;m.open(true,0,"begin top","begin top",s.m_Div,""+c.m_x+" "+c.m_y+"","fit");};return c;};
VBI.ObjectCreationHandler=function(d){"use strict";var h={};h.cnt=0;h.m_Ctx=null;h.m_Name=null;if(jQuery.type(d)=='object'){if(d.name==="data"){h.m_data=d["#"];}}else if(jQuery.type(d)=='array'){for(var i=0,l=d.length;i<l;++i){if(d[i].name==="data"){h.m_data=d[i]["#"];}}}h.start=function(){var s=null;if((s=h.m_Ctx.m_SceneManager.GetSceneByName(h.m_scene))){if(h.m_Name=="CreateObject"){var a=null,b=s.m_Ctx.m_Actions;if(b){a=s.m_Ctx.m_Actions.findAction("CreateComplete",s,"General");}var f=null;if(a){f=function(c){var p={data:c};s.m_Ctx.FireAction(a,s,"General",null,p);};}else{f=s.m_Ctx.m_Control.load.bind(s.m_Ctx.m_Control);}s.DesignCreateObject(h.m_data,null,f);}}};return h;};
VBI.LoopBackHandler=function(d){"use strict";var h={};h.cnt=0;h.m_Ctx=null;h.m_Name=null;if(jQuery.type(d)=='object'){if(d.name==="ActionID"){h.m_ActionID=d["#"];}}else if(jQuery.type(d)=='array'){for(var i=0,l=d.length;i<l;++i){if(d[i].name==="ActionID"){h.m_ActionID=d[i]["#"];}}}h.start=function(){if(h.m_Name=="TriggerAction"){var a;if((a=h.m_Ctx.m_Actions)){var b;if((b=a.findAction(null,null,null,h.m_ActionID))){var s;if((s=h.m_Ctx.m_SceneManager.GetSceneByName(b.m_refScene))){var v=s.BaseGetVO(b.m_refVO);h.m_Ctx.FireAction(b,s,v?v:b.m_refVO,null,null);}}}}};return h;};
},
	"sap/ui/vbm/lib/sapconfig.js":function(){
VBI.Configurations=function(){"use strict";var c={};c.m_configdata=[];c.clear=function(){c.m_configdata=[];};c.load=function(d,a){if(d.Set){c.clear();var r=d.Set.P;if(jQuery.type(r)=='object'){c.m_configdata[r.name]=r.value;}else if(jQuery.type(r)=='array'){for(var n=0,l=r.length;n<l;++n){c.m_configdata[r[n].name]=r[n].value;}}}};c.GetData=function(n){return c.m_configdata[n];};return c;};
},
	"sap/ui/vbm/lib/sapdataprovider.js":function(){
VBI.isInt=function(i){"use strict";return((i-0)==i&&i%1==0);};
VBI.IndexOf=function(a,e){"use strict";var l=a.length;for(var n=0;n<l;++n){if(e==a[n]){return n;}}return-1;};
VBI.Types={st_unknown:0,st_vector:1,st_string:2,st_vectorarray:3,st_float:4,st_color:5,st_long:6,st_bool:7,st_vectorarraymulti:8,string2bool:function(a){"use strict";if(typeof a=="boolean"){return a;}if(typeof a=="number"){return a?true:false;}var t=a.slice(0,1);return(t=='t'||t=='1'||t=='X')?true:false;},string2vector:function(a){"use strict";var e=false;var b=a.split(';');for(var n=0,l=b.length;n<l;++n){b[n]=parseFloat(b[n]);if(!e&&(isNaN(b[n])||!isFinite(b[n]))){e=true;jQuery.sap.log.error("The string contains invalid numbers");}}return b;},stringarray2vectorarray:function(a){"use strict";var r=[];for(var n=0,l=a.length;n<l;++n){var p=[];for(var b=0,c=a[n].length;b<c;++b){p.push(this.string2vector(a[n][b]));}r.push(p);}return r;},string2rgba:function(a){"use strict";var c,r;if((c=/^rgba\(([\d]+)[,;]\s*([\d]+)[,;]\s*([\d]+)[,;]\s*([\d]+|[\d]*.[\d]+)\)/.exec(a))){return[+c[1],+c[2],+c[3],+c[4],1];}else if((c=/^rgba\(([\d]+)\%[,;]\s*([\d]+)\%[,;]\s*([\d]+)\%[,;]\s*([\d]+|[\d]*.[\d]+)\)/.exec(a))){return[+Math.round(c[1]*2.55),+Math.round(c[2]*2.55),+Math.round(c[3]*2.55),+c[4],1];}else if((c=/^rgb\(([\d]+)[,;]\s*([\d]+)[,;]\s*([\d]+)\)/.exec(a))){return[+c[1],+c[2],+c[3],1.0,0];}else if((c=/^rgb\(([\d]+)\%[,;]\s*([\d]+)\%[,;]\s*([\d]+)\%\)/.exec(a))){return[+Math.round(c[1]*2.55),+Math.round(c[2]*2.55),+Math.round(c[3]*2.55),1.0,0];}else if(a.charAt(0)==="#"){var C;if(a.length<7){C=a.substring(0,2)+a.substring(1,2)+a.substring(2,3)+a.substring(2,3)+a.substring(3,4)+a.substring(3,4);}else{C=a;}return[parseInt(C.substring(1,3),16),parseInt(C.substring(3,5),16),parseInt(C.substring(5,7),16),1.0,1];}else if((c=/^hsla\(([\d]+)[,]\s*([\d]+)\%[,]\s*([\d]+)\%[,]\s*([\d]+|[\d]*.[\d]+)\)/.exec(a))){c=[+c[1],+c[2],+c[3],+c[4]];r=VBI.Utilities.HLS2RGB(c[0]/360.0,c[2]/100.0,c[1]/100.0);return[r[0],r[1],r[2],c[3],1];}else if((c=/^hsl\(([\d]+)[,]\s*([\d]+)\%[,]\s*([\d]+)\%\)/.exec(a))){c=[+c[1],+c[2],+c[3]];r=VBI.Utilities.HLS2RGB(c[0]/360.0,c[2]/100.0,c[1]/100.0);return[r[0],r[1],r[2],1.0,0];}else if((c=/^RGBA\(([\d]+)[,;]([\d]+)[,;]([\d]+)[,;]([\d]+|[\d]*.[\d]+)\)/.exec(a))){return[+c[1],+c[2],+c[3],parseFloat(+c[4])/255.0,1];}else if((c=/^RGB\(([\d]+)[,;]([\d]+)[,;]([\d]+)\)/.exec(a))){return[+c[1],+c[2],+c[3],1.0,0];}else if((c=/^ARGB\((0[xX][0-9A-Fa-f]+)[,;](0[xX][0-9A-Fa-f]+)[,;](0[xX][0-9A-Fa-f]+)[,;](0[xX][0-9A-Fa-f]+)\)/.exec(a))){return[parseInt(c[2],16),parseInt(c[3],16),parseInt(c[4],16),parseFloat(+c[1])/255.0,1];}else if((c=/^ARGB\(([\d]+)[,;]([\d]+)[,;]([\d]+)[,;]([\d]+)\)/.exec(a))){return[+c[2],+c[3],+c[4],parseFloat(+c[1])/255.0,1];}else if((c=/^HLSA\(([\d]+)[,;]([\d]+)[,;]([\d]+)[,;]([\d]+)\)/.exec(a))){c=[+c[1],+c[2],+c[3],+c[4]];r=VBI.Utilities.HLS2RGB(c[0]/600.0,c[1]/600.0,c[2]/600.0);return[r[0],r[1],r[2],c[3]/255,1];}else if((c=/^HLS\(([\d]+)[,;]([\d]+)[,;]([\d]+)\)/.exec(a))){c=[+c[1],+c[2],+c[3]];r=VBI.Utilities.HLS2RGB(c[0]/600.0,c[1]/600.0,c[2]/600.0);return[r[0],r[1],r[2],1.0,0];}return[255,0,0,1.0,0];},string2color:function(a){"use strict";var r=this.string2rgba(a);return"rgba("+r[0]+","+r[1]+","+r[2]+","+r[3]+")";},string2rhls:function(a){"use strict";var c;if((c=/^RHLS\(([\d]+|[\d]*.[\d]+)[,;]([\d]+|[\d]*.[\d]+)[,;]([\d]+|[\d]*.[\d]+)\)/.exec(a))){return[parseFloat(+c[1])/360.0,parseFloat(+c[2]),parseFloat(+c[3]),1.0];}else if((c=/^RHLSA\(([\d]+|[\d]*.[\d]+)[,;]([\d]+|[\d]*.[\d]+)[,;]([\d]+|[\d]*.[\d]+)[,;]([\d]+|[\d]*.[\d]+)\)/.exec(a))){return[parseFloat(+c[1])/360.0,parseFloat(+c[2]),parseFloat(+c[3]),parseFloat(+c[4])];}return null;},color2array:function(a){"use strict";var c;if((c=/^rgba\(([\d]+)[,]([\d]+)[,]([\d]+)[,]([\d]+|[\d]*.[\d]+)\)/.exec(a))){c=[parseInt(+c[1],10),parseInt(+c[2],10),parseInt(+c[3],10),parseFloat(+c[4])];return c;}return null;},string2long:function(a){"use strict";if(typeof a=="boolean"){return a?1:0;}return parseInt(a,10);},string2float:function(a){"use strict";if(typeof a=="boolean"){return a?1.0:0.0;}return parseFloat(a);},float2string:function(a){"use strict";return a.toString();},vector2string:function(a){"use strict";var t="";for(var n=0;n<a.length;++n){t+=a[n];if((n+1)<a.length){t+=";";}}return t;},color2string:function(a){"use strict";var r;if((r=/^rgba\(([\d]+),([\d]+),([\d]+),([\d]+|[\d]*.[\d]+)\)/.exec(a))){r=[+r[1],+r[2],+r[3],parseInt(parseFloat(+r[4])*255.0,10)];return"RGBA("+r[0]+","+r[1]+","+r[2]+","+r[3]+")";}return null;},long2float:function(a){"use strict";return parseFloat(a,10);},float2long:function(a){"use strict";return parseInt(a,10);}};
VBI.DataTypeProvider=function(){"use strict";var d={};d.m_datatypenodes=[];d.vbiclass="DataTypeProvider";d.isParentOf=function(p,c){if(!c){return false;}var t=c;while((t=t.m_Parent)){if(t==p){return true;}}return false;};d.clear=function(){var o,n=this.m_datatypenodes.length;for(var a=0;a<n;++a){if((o=this.m_datatypenodes[a])){o.clear();}}this.m_datatypenodes=[];};d.set=function(a,c){if(a.type&&a.name){if((a.type=="N")){if(jQuery.type(a.N)=='object'){var b;if((b=d.GetTypeNode(a.name,true))){b.load(a.N);return;}}}}else{this.clear();}var e;if(jQuery.type(a.N)=='object'){this.m_datatypenodes.push(e=new VBI.DataTypeProvider.DataTypeNode(this,this.m_datatypenodes.length));if(a.name){e.m_Name=a.name;}if(a.N.key){e.m_Key=a.N.key;}e.load(a.N);}else if(jQuery.type(a.N)=='array'){for(var i=0,l=a.N.length;i<l;++i){this.m_datatypenodes.push(e=new VBI.DataTypeProvider.DataTypeNode(this,this.m_datatypenodes.length));if(a.N[i].name){e.m_Name=a.N[i].name;}if(a.N[i].key){e.m_Key=a.N[i].key;}e.load(a.N[i]);}}};d.load=function(a,c){if(a.Set){if(jQuery.type(a.Set)=='object'){d.set(a.Set,c);}else if(jQuery.type(a.Set)=='array'){for(var i=0,l=a.Set.length;i<l;++i){d.set(a.Set[i],c);}}}};d.GetTypeNode=function(n,b){for(var i=0;i<this.m_datatypenodes.length;++i){if(this.m_datatypenodes[i].m_Name==n){return this.m_datatypenodes[i];}}if(!b){return null;}var a;this.m_datatypenodes.push(a=new VBI.DataTypeProvider.DataTypeNode(null,this.m_datatypenodes.length));a.m_Name=n;return a;};d.FindTypeRefs=function(){var r=[];for(var i=0,l=this.m_datatypenodes.length;i<l;++i){var a=this.m_datatypenodes[i].m_Ref;if(a){r.push({m_Ref:a,m_DTN:this.m_datatypenodes[i]});}}return r;};d.FindTypeNodeFromPath=function(p){var n,a=this.GetTypeNode(p[0],false);for(var b=1;b<p.length;++b){if(!(n=a.GetTypeNode(p[b],false))){continue;}a=n;}return a;};d.FindTypeAttributeFromPath=function(p){var n=[];for(var a=0;a<(p.length-1);++a){n.push(p[a]);}var b=this.FindTypeNodeFromPath(n);return b?b.GetTypeAttribute(p[p.length-1]):null;};VBI.DataTypeProvider.DataTypeNode=function(p,a){var b={};b.m_datatypenodes=[];b.m_datatypeattributes=[];b.m_nArrayIndex=a;b.m_Name="";b.m_Key=null;b.m_Ref=null;b.m_Parent=p;b.m_MinSelect=1;b.m_MaxSelect=1;b.clear=function(){var o,n,c;b.m_Parent=null;c=b.m_datatypenodes.length;for(n=0;n<c;++n){if((o=b.m_datatypenodes[n])){o.clear();}}b.m_datatypenodes=[];c=b.m_datatypeattributes.length;for(n=0;n<c;++n){if((o=b.m_datatypeattributes[n])){o.clear();}}b.m_datatypeattributes=[];};b.load=function(c){if(c.name){b.m_Name=c.name;}if(c.key){b.m_Key=c.key;}if(c.ref){b.m_Ref=c.ref;}if(c.minSel){b.m_MinSelect=parseInt(c.minSel,10);}if(c.maxSel){b.m_MaxSelect=parseInt(c.maxSel,10);}var i;if(c.A){var t;if(jQuery.type(c.A)=='array'){for(i=0;i<c.A.length;++i){t=b.GetTypeAttribute(c.A[i].name,true);t.load(c.A[i]);}}else if(jQuery.type(c.A)=='object'){t=b.GetTypeAttribute(c.A.name,true);t.load(c.A);}}if(c.N){var e;if(jQuery.type(c.N)=='array'){for(i=0;i<c.N.length;++i){b.m_datatypenodes.push(e=new VBI.DataTypeProvider.DataTypeNode(this,b.m_datatypenodes.length));e.load(c.N[i]);}}else if(jQuery.type(c.N)=='object'){b.m_datatypenodes.push(e=new VBI.DataTypeProvider.DataTypeNode(this,b.m_datatypenodes.length));e.load(c.N);}}};b.GetTypeNode=function(n,c){var e=b.m_datatypenodes;for(var i=0,l=e.length;i<l;++i){if(e[i].m_Name==n){return e[i];}}if(!c){return null;}var f;e.push(f=new VBI.DataTypeProvider.DataTypeNode(this,e.length));f.m_Name=n;return f;};b.GetKeyTypeAttribute=function(){if(b.m_Key){return b.GetTypeAttribute(b.m_Key,true);}else{return b.GetTypeAttribute("VB:ix",true);}return null;};b.GetSelectTypeAttribute=function(c){return b.GetTypeAttribute("VB:s",c);};b.GetPath=function(){var n=[];var c=this;do{n.splice(0,0,c.m_Name);}while((c=c.m_Parent)&&c['m_Name']);return n;};b.GetTypeAttribute=function(n,c){var e=b.m_datatypeattributes;for(var i=0,l=e.length;i<l;++i){var f=e[i];if(f.m_Alias==n||f.m_Name==n){return f;}}if(c){var g;e.push(g=new VBI.DataTypeProvider.DataTypeAttribute(e.length));g.m_Name=n;g.m_Parent=this;g.m_Type=(n=="VB:s")?VBI.Types.st_bool:VBI.Types.st_string;return g;}return null;};return b;};VBI.DataTypeProvider.DataTypeAttribute=function(a){var b={};b.m_Name="";b.m_Alias="";b.m_bChangeable=false;b.m_Type=VBI.Types.st_unknown;b.m_nArrayIndex=a;b.m_Parent=null;b.clear=function(){b.m_Parent=null;};b.load=function(c){if(c.name){b.m_Name=c.name;}if(c.alias){b.m_Alias=c.alias;}if(c.changeable){b.m_bChangeable=VBI.Types.string2bool(c.changeable);}if(c.type){switch(c.type){case"vectorarraymulti":b.m_Type=VBI.Types.st_vectorarraymulti;break;case"vectorarray":b.m_Type=VBI.Types.st_vectorarray;break;case"vector":b.m_Type=VBI.Types.st_vector;break;case"long":b.m_Type=VBI.Types.st_long;break;case"string":b.m_Type=VBI.Types.st_string;break;case"color":b.m_Type=VBI.Types.st_color;break;case"boolean":b.m_Type=VBI.Types.st_bool;break;case"float":b.m_Type=VBI.Types.st_float;break;default:b.m_Type=VBI.Types.st_string;break;}}};return b;};return d;};
VBI.DataProvider=function(){"use strict";var d={};var N=0,E=1,A=2;d.vbiclass="DataProvider";d.m_datanodes=[];d.m_dtp=null;d.m_Ctx=null;d.clear=function(){var o,n=d.m_datanodes.length;for(var a=0;a<n;++a){if((o=d.m_datanodes[a])){o.clear();}}d.m_datanodes=[];d.m_Ctx=null;d.m_dtp=null;};d.set=function(a,c){var b=c.m_DataTypeProvider;if(!b){jQuery.sap.log.error("Data types are not available");return;}if(a.type&&a.name){if((a.type=="N")){if(jQuery.type(a.N)=='object'){var e;var p=a.name.split(".");if((e=this.FindNodeFromPath(p))){if(a.name!=a.N.name){jQuery.sap.log.error("Node loading delta operation failed");return;}e.load(a.N,b.FindTypeNodeFromPath(p));return;}}}}else{this.clear();}if(a.N){var f,n,g;if(jQuery.type(a.N)=='object'){f=b.GetTypeNode(g=a.N.name,true);this.m_datanodes[f.m_nArrayIndex]=(n=new VBI.DataProvider.DataNode());n.m_Parent=this;n.m_Name=g;n.load(a.N,f);}else if(jQuery.type(a.N)=='array'){for(var i=0;i<a.N.length;++i){f=b.GetTypeNode(g=a.N[i].name,true);this.m_datanodes[f.m_nArrayIndex]=(n=new VBI.DataProvider.DataNode());n.m_Parent=this;n.m_Name=g;n.load(a.N[i],f);}}}};d.remove=function(i,c){var a,n;if(i.type=="N"&&(n=i.name)){if((a=this.FindNodeFromPath(n.split(".")))){a.m_Parent.RemoveNode(a);}}else if(i.type=="E"&&(n=i.name)){if((a=this.FindNodeFromPath(n.split(".")))){a.RemoveElements(i.N);}}};d.load=function(a,c){var b=c.m_DataTypeProvider;if(a.Remove){if(jQuery.type(a.Remove)=='object'){this.remove(a.Remove,c);}else if(jQuery.type(a.Remove)=='array'){for(var n=0,l=a.Remove.length;n<l;++n){this.remove(a.Remove[n],c);}}}if(a.Set){if(jQuery.type(a.Set)=='object'){d.set(a.Set,c);}else if(jQuery.type(a.Set)=='array'){for(var i=0;i<a.Set.length;++i){d.set(a.Set[i],c);}}}d.m_dtp=b;d.m_Ctx=c;};d.store=function(a){if(this.IsModified()){a.Data={};a.Data.Merge={};var n=a.Data.Merge.N=[];var t;for(var b=0;b<this.m_datanodes.length;++b){if((t=this.m_datanodes[b])&&t.IsModified()){var c={};n.push(c);t.store(c);}}}};d.OnAttributeChanged=function(a){var b;if((b=d.m_Ctx.m_Actions)){var c;if((c=b.findAction("AttributeChanged",null,null))){var i=a.m_Parent.GetPath()+"."+a.m_dta.m_Name;d.m_Ctx.FireAction(c,null,null,null,null,i);}}};d.OnNodeChanged=function(n){var a;if((a=d.m_Ctx.m_Actions)){var b;if((b=a.findAction("NodeChanged",null,null))){var p=null;if(n.m_Parent&&n.m_Parent.GetPath){p=n.m_Parent.GetPath()+".";}else{p="";}d.m_Ctx.FireAction(b,null,null,null,null,p+n.m_dtn.m_Name);}}};d.OnElementChanged=function(e){var a;if((a=d.m_Ctx.m_Actions)){var b;if((b=a.findAction("ElementChanged",null,null))){d.m_Ctx.FireAction(b,null,null,null,null,e.GetPath());}}};d.IsModified=function(){var t;for(var n=0;n<this.m_datanodes.length;++n){if((t=this.m_datanodes[n])&&t.IsModified()){return true;}}return false;};d.RemoveNode=function(n){var a=n.m_dtn.m_nArrayIndex;this.m_datanodes[a].clear();this.m_datanodes[a]=null;};d.FindFromPathEx=function(p,s,t,e,n){var P=false,c=null,a=null,b=null;if(n){P=true;b=n;c=n.m_dtn;}else if(e){a=e;c=e.m_Parent.m_dtn;}for(var f=s,l=p.length;f<l;++f){if(P){if(c.m_Key){if((a=b.FindElementByKey(p[f]))){P=false;continue;}}else if(VBI.isInt(p[f])){a=b.m_dataelements[parseInt(p[f],10)];P=false;continue;}else{if(b.m_dataelements.length){a=b.m_dataelements[0];}if(!a){VBI.m_bTrace&&VBI.Trace("Error: invalid lead selected element");}}}if(t==A&&(f+1)==l){var g;if((g=c.GetTypeAttribute(p[f],false))){return a.m_dataattributes[g.m_nArrayIndex];}}c=c.GetTypeNode(p[f],true);if(!a){VBI.m_bTrace&&VBI.Trace("Error: Invalid Binding Path "+p);return false;}b=a.m_datanodes[c.m_nArrayIndex];P=true;}if(t==A||t==E){return null;}return b;};d.FindFromPath=function(p,t){if(!d.m_dtp){return null;}var c=d.m_dtp.GetTypeNode(p[0],false);if(!c){return null;}var a=d.m_datanodes[c.m_nArrayIndex];if(!a){return null;}return d.FindFromPathEx(p,1,t,null,a);};d.FindAttributeFromPath=function(p){return d.FindFromPath(p,A);};d.FindNodeFromPath=function(p){return d.FindFromPath(p,N);};d.SetSelection=function(s,c){var t,n=d.m_datanodes;for(var a=0,l=n.length;a<l;++a){if((t=n[a])){t.SetSelection(s,c);}}};VBI.DataProvider.DataNode=function(){var a={};a.m_Name="";a.m_dataelements=[];a.m_Parent=null;a.m_dtn=null;a.m_bModified=false;a.clear=function(){a.m_dtn=null;for(var n=0;n<a.m_dataelements.length;++n){a.m_dataelements[n].clear();a.m_dataelements[n].m_Parent=null;}a.m_dataelements=[];a.m_Parent=null;};a.IsModifiedSelection=function(){return a.m_bModified?true:false;};a.IsModifiedElements=function(){var e=a.m_dataelements;for(var n=0;n<e.length;++n){if(e[n].IsModified()){return true;}}return false;};a.IsModified=function(){if(a.IsModifiedSelection()||a.IsModifiedElements()){return true;}return false;};a.store=function(b){b.name=a.m_dtn.m_Name;if(a.IsModifiedElements()){b.E=[];for(var n=0;n<a.m_dataelements.length;++n){if(a.m_dataelements[n].IsModified()){var e={};b.E.push(e);a.m_dataelements[n].store(e);}}}};a.RemoveNode=function(n){var b=n.m_dtn.m_nArrayIndex;a.m_datanodes[b].clear();a.m_datanodes[b]=null;};a.RemoveElements=function(b){var k=a.m_dtn.GetKeyTypeAttribute();var c=a.GetElementKeyMap(k);if(b.E){if(jQuery.type(b.E)=='object'){a.InternalFindAndRemoveExistingElement(b.E,0,k,c);}else if(jQuery.type(b.E)=='array'){for(var i=0;i<b.E.length;++i){a.InternalFindAndRemoveExistingElement(b.E[i],i,k,c);}}}};a.GetElementKeyMap=function(k){var t,b=[];var c=k?k:a.m_dtn.GetKeyTypeAttribute();for(var n=0;n<a.m_dataelements.length;++n){b[(t=a.m_dataelements[n]).m_dataattributes[c.m_nArrayIndex].m_Value]=t;}return b;};a.FindElementByKey=function(k,b,c){var t;if(c){return(t=c[k])?t:null;}var e=b?b:a.m_dtn.GetKeyTypeAttribute();var f,g=this.m_dataelements;for(var n=0,l=g.length;n<l;++n){if((f=g[n])){if(f.m_dataattributes[e.m_nArrayIndex].m_Value==k){return f;}}}return null;};a.FindElementByIndex=function(i){return this.m_dataelements[i];};a.InternalFindAndRemoveExistingElement=function(b,i,k,c){var e=null,f=null;if(k.m_Alias&&(e=b[k.m_Alias])){f=this.FindElementByKey(e,k,c);}else if(k.m_Name&&(e=b[k.m_Name])){f=this.FindElementByKey(e,k,c);}else{f=this.FindElementByKey(e=i,k,c);}if(f){this.m_dataelements.splice(VBI.IndexOf(this.m_dataelements,f),1);if(c){c.splice(e,1);}f.clear();}};a.InternalFindOrCreateExistingElement=function(b,i,k,c){var e=null,f=null;if(k.m_Alias&&(e=b[k.m_Alias])){f=a.FindElementByKey(e,k,c);}else if(k.m_Name&&(e=b[k.m_Name])){f=a.FindElementByKey(e,k,c);}else{f=a.FindElementByKey(e=i,k,c);}if(f){return f;}f=new VBI.DataProvider.DataElement();a.m_dataelements.push(f);if(c){c[e]=f;}return f;};a.load=function(b,c){a.m_dtn=c;var k=a.m_dtn.GetKeyTypeAttribute();var e=a.GetElementKeyMap(k);if(b.E){var f,g;if(jQuery.type(b.E)=='object'){g=a.InternalFindOrCreateExistingElement(b.E,0,k,e);g.m_Parent=a;g.load(b.E,c);if(g.m_dataattributes[k.m_nArrayIndex]==null){f=new VBI.DataProvider.DataAttribute(k,null,g);f.m_Value=0;g.m_dataattributes[k.m_nArrayIndex]=f;}}else if(jQuery.type(b.E)=='array'){for(var i=0,l=b.E.length;i<l;++i){g=a.InternalFindOrCreateExistingElement(b.E[i],i,k,e);g.m_Parent=a;g.load(b.E[i],c);if(g.m_dataattributes[k.m_nArrayIndex]==null){f=new VBI.DataProvider.DataAttribute(k,null,g);f.m_Value=i;g.m_dataattributes[k.m_nArrayIndex]=f;}}}}};a.GetName=function(){return this.m_Name;};a.GetPath=function(){return this.m_dtn.GetPath();};a.SetModified=function(){this.m_bModified=true;var p=this;while(p.m_Parent){p=p.m_Parent;}if(p){p.OnNodeChanged(this);}};a.GetSelectedElements=function(){var s=[];var e=this.m_dataelements;var k=this.m_dtn.GetTypeAttribute("VB:s",true);for(var n=0,l=e.length;n<l;++n){if(e[n].IsSelected(k)){s.push(e[n]);}}return s;};a.GetNumOfSelectedElements=function(){return(a.m_NumSelectedEltes!=undefined)?a.m_NumSelectedEltes:a.GetSelectedElements().length;};a.SetNumOfSelectedElements=function(){a.m_NumSelectedEltes=a.GetSelectedElements().length;};a.UnSetNumOfSelectedElements=function(){a.m_NumSelectedEltes=undefined;};a.SetSelection=function(s,c){var e=this.m_dataelements;var t=null,k=this.m_dtn.GetTypeAttribute("VB:s",true);if(!s&&c){this.SetNumOfSelectedElements();}for(var n=0,l=e.length;n<l;++n){if((t=e[n])){if(c){t.Select(s);}else{t.SetElementSelectionState(s,k);}}}this.UnSetNumOfSelectedElements();return null;};return a;};VBI.DataProvider.DataElement=function(){this.m_dataattributes=[];this.m_datanodes=[];this.m_Parent=null;this.m_bChangeable=false;};VBI.DataProvider.DataElement.prototype={m_dataattributes:null,m_datanodes:null,m_Parent:null,m_nModified:0,m_bChangeable:false,clear:function(){var n,t;for(n=0;n<this.m_datanodes.length;++n){if((t=this.m_datanodes[n])){t.clear();t.m_Parent=null;}}this.m_datanodes=[];for(n=0;n<this.m_dataattributes.length;++n){if((t=this.m_dataattributes[n])){t.clear();t.m_Parent=null;}}this.m_dataattributes=[];},load:function(b,c){var m=false;this.m_nModified=0;if(b["VB:m"]){if((m=VBI.Types.string2bool(b["VB:m"]))){this.m_nModified=7;}delete b["VB:m"];}if(b["VB:c"]){this.m_bChangeable=VBI.Types.string2bool(b["VB:c"]);delete b["VB:c"];}for(var a in b){if(!b.hasOwnProperty(a)){continue;}if(a=="N"&&!(typeof b[a]=='string')){var l,n;if(jQuery.type(b[a])=='object'){l=c.GetTypeNode(b.N.name,true);this.m_datanodes[l.m_nArrayIndex]=(n=new VBI.DataProvider.DataNode());n.m_Parent=this;n.m_Name=b.N.name;n.load(b[a],l);}else if(jQuery.type(b[a])=='array'){var e=b[a];for(var f=0;f<e.length;++f){var g=e[f];l=c.GetTypeNode(g.name,true);this.m_datanodes[l.m_nArrayIndex]=(n=new VBI.DataProvider.DataNode());n.m_Parent=this;n.m_Name=g.name;n.load(g,l);}}}else{var h=c.GetTypeAttribute(a,true);this.m_dataattributes[h.m_nArrayIndex]=new VBI.DataProvider.DataAttribute(h,b[a],this,m);}}},IsModified:function(a){if(this.m_nModified){return true;}var n,l,t;for(n=0,l=this.m_dataattributes.length;n<l;++n){if((t=this.m_dataattributes[n])&&t.IsModified()){return true;}}for(n=0,l=this.m_datanodes.length;n<l;++n){if((t=this.m_datanodes[n])&&t.IsModified()){return true;}}return false;},IsChangeable:function(){return this.m_bChangeable;},IsSelected:function(k){var i,a=k?k:this.m_Parent.m_dtn.GetSelectTypeAttribute(false);if(a&&((i=a.m_nArrayIndex)<this.m_dataattributes.length)){var t;if((t=this.m_dataattributes[i])){if(a.m_Type==VBI.Types.st_string){return VBI.Types.string2bool(t.m_Value);}else{return(t.m_Value?true:false);}}}return false;},SetModified:function(){this.m_nModified|=1;var p=this;while(p.m_Parent){p=p.m_Parent;}if(p){p.OnElementChanged(this);}},store:function(a){var k=this.m_Parent.m_dtn.GetKeyTypeAttribute();var b=k.m_Alias?k.m_Alias:k.m_Name;a[b]=this.m_dataattributes[k.m_nArrayIndex].GetStringValue();if(this.m_nModified&2){a["VB:c"]=this.m_bChangeable?"true":"false";}if(this.m_nModified&4){a["VB:m"]="true";}var n,l,t;for(n=0,l=this.m_dataattributes.length;n<l;++n){if((t=this.m_dataattributes[n])&&t.IsModified()){var c=t.m_dta.m_Alias?t.m_dta.m_Alias:t.m_dta.m_Name;a[c]=t.GetStringValue();}}for(n=0,l=this.m_datanodes.length;n<l;++n){if((t=this.m_datanodes[n])&&t.IsModified()){t.store(a["N"]={});}}},GetKeyValue:function(){var k;if(this.m_Parent&&(k=this.m_Parent.m_dtn.GetKeyTypeAttribute())){return this.m_dataattributes[k.m_nArrayIndex].m_Value;}return null;},GetPath:function(){var p=null;var c=this;while(c){var k=c.GetKeyValue();if(p){p=k+"."+p;}else{p=k;}var n;if((n=this.m_Parent)){p=this.m_Parent.m_dtn.m_Name+"."+p;}else{break;}if(n.m_Parent&&n.m_Parent.m_Parent){c=n.m_Parent?n.m_Parent:null;}else{break;}}return p;},SetElementSelectionState:function(s,t){var k=t;if(!k){k=t?t:this.m_Parent.m_dtn.GetTypeAttribute("VB:s",true);k.m_Type=VBI.Types.st_bool;}var i=k.m_nArrayIndex;if(this.m_dataattributes[i]==null){this.m_dataattributes[i]=new VBI.DataProvider.DataAttribute(k,null,this);}var S,a=this.m_dataattributes[i];if((S=(a.m_Value!=(s?true:false)))){a.m_Value=s?true:false;a.m_bModified=true;}if(S){this.SetModified();return true;}return false;},GlobalSingleSelect:function(){var a=this.m_Parent.m_dtn;if(a.m_MaxSelect==0){return 0;}this.m_Parent.SetSelection(false,false);this.Select(true);return 1;},Select:function(s,o){var a=this.m_Parent.m_dtn;if(!o){o=0;}var n;if(s){if(a.m_MaxSelect==0){return 0;}if(a.m_MaxSelect<0){n=this.SetElementSelectionState(true)?1:0;return o+n;}if(a.m_MaxSelect==1){this.m_Parent.SetSelection(false,false);this.SetElementSelectionState(true);return 1;}}else{if(((a.m_MinSelect==1)&&(this.m_Parent.GetNumOfSelectedElements()>1))||(a.m_MinSelect==0)){n=this.SetElementSelectionState(false)?1:0;return o-n;}}},FindNodeFromPath:function(p){return d.FindFromPathEx(p,0,N,this,null);},FindAttributeFromPath:function(p){return d.FindFromPathEx(p,0,A,this,null);}};VBI.DataProvider.DataAttribute=function(a,v,p,m){this.m_dta=a;this.m_Parent=p;if(m){this.m_bModified=true;}if(v===null){return;}var b=VBI.Types;if(a.m_Type==b.st_vectorarraymulti){this.m_Value=b.stringarray2vectorarray(v);}else if(a.m_Type==b.st_vectorarray||a.m_Type==b.st_vector){this.m_Value=b.string2vector(v);}else if(a.m_Type==b.st_long){this.m_Value=b.string2long(v);}else if(a.m_Type==b.st_float){this.m_Value=b.string2float(v);}else if(a.m_Type==b.st_bool){this.m_Value=b.string2bool(v);}else if(a.m_Type==b.st_color){this.m_Value=b.string2color(v);}else if(a.m_Type==b.st_string){this.m_Value=v;}else{this.m_Value=v;}};VBI.DataProvider.DataAttribute.prototype={m_dta:null,m_Value:null,m_Parent:null,m_bModified:false,clear:function(){this.m_Parent=null;this.m_dta=null;},store:function(a){},set:function(v){if(v!=this.m_Value){this.SetModified();}this.m_Value=v;},SetModified:function(){this.m_bModified=true;var p=this;while(p.m_Parent){p=p.m_Parent;}if(p){p.OnAttributeChanged(this);}},IsModified:function(){return this.m_bModified;},IsChangeable:function(){return(this.m_dta.m_bChangeable&&this.m_Parent.m_bChangeable);},GetStringValue:function(){var t="";switch(this.m_dta.m_Type){case VBI.Types.st_vectorarray:case VBI.Types.st_vector:return VBI.Types.vector2string(this.m_Value);case VBI.Types.st_long:t+=this.m_Value;return t;case VBI.Types.st_float:t+=this.m_Value;return t;case VBI.Types.st_string:return this.m_Value;case VBI.Types.st_bool:return this.m_Value?"true":"false";case VBI.Types.st_color:var c;if((c=/^rgba\(([\d]+),([\d]+),([\d]+),([\d]+|[\d]*.[\d]+)\)/.exec(this.m_Value))){c=[+c[1],+c[2],+c[3],parseInt(parseFloat(+c[4])*255.0,10)];return"RGBA("+c[0]+","+c[1]+","+c[2]+","+c[3]+")";}break;default:return this.m_Value;}}};return d;};
VBI.Adaptor=function(c){"use strict";var C=c;this.RecursiveLoadElement=function(d,o,a){var n;for(n=0;n<a.m_datatypeattributes.length;++n){var b=a.m_datatypeattributes[n];var e=o[b.m_Name];if(e===undefined){continue;}if((b.m_Type==VBI.Types.st_vector)&&jQuery.type(e)=="array"){d[b.m_Alias]=""+e[0]+";"+e[1]+";0";}else{d[b.m_Alias]=e.toString();}}if(a.m_datatypenodes.length){var f=d.N=[];for(n=0;n<a.m_datatypenodes.length;++n){var g=f[n]={};var h=a.m_datatypenodes[n];var i=o[h.m_Name];if(i){this.RecursiveLoad(g,i,h);}}}};this.RecursiveLoad=function(d,o,a){d.name=a.m_Name;d.E=[];var b;if(jQuery.type(o)=='array'){for(var n=0;n<o.length;++n){b=d.E[n]={};this.RecursiveLoadElement(b,o[n],a);}}else{b=d.E[0]={};this.RecursiveLoadElement(b,o,a);}};this.LoadFindRefNode=function(d){var r=C.m_DataTypeProvider.FindTypeRefs();for(var n=0,l=r.length;n<l;++n){var s=d;var p=r[n].m_Ref.split(".");for(var a=0,b=p.length;a<b;++a){s=s[p[a]];if(s&&((a+1)==b)){r[n].m_Root=s;return r[n];}if(!s){break;}}}return null;};this.CreateLoadData=function(d){if(!C.m_DataTypeProvider){return null;}var r=null;if(!(r=this.LoadFindRefNode(d))){return null;}var a=r.m_DTN;var b=r.m_Root;var v={SAPVB:{"version":"2.0","Data":{"Remove":{"type":"N","name":a.m_Name},"Set":{"type":"N","name":a.m_Name,"N":{}}}}};var o=b;var e=v.SAPVB.Data.Set.N;this.RecursiveLoad(e,o,a);return v;};};
},
	"sap/ui/vbm/lib/sapevents.js":function(){
VBI.ScenePointerEvents=function(s,e){"use strict";s.m_Gesture=null;this.m_Events=["msgesturehold","msgesturestart","msgestureend","msgesturechange","msgestureinertiastart","gesturehold","gesturestart","gestureend","gesturechange","gestureinertiastart","pointerdown","pointermove","pointerup","mspointerdown","mspointermove","mspointerup"];this.clear=function(){for(var n=0,a=this.m_Events.length;n<a;++n){e["on"+this.m_Events[n]]=null;}};this.subscribe=function(){var a=this.m_Events;for(var n=0,b=a.length;n<b;++n){var h;if(a[n].slice(0,2)=="ms"){h="process"+a[n].slice(2);}else{h="process"+a[n];}if(!s[h]){if(VBI.m_bTrace){VBI.Trace("Error: Handler "+h+" not defined");}}e["on"+a[n]]=s[h];}};s.processgesturehold=function(a){if(VBI.m_bTrace){VBI.Trace("processgesturehold");}s.DispatchEvent(a,"sapsecclick");a.preventDefault();};s.processgesturestart=function(a){if(VBI.m_bTrace){VBI.Trace("processgesturestart");}};s.processgestureend=function(a){if(VBI.m_bTrace){VBI.Trace("processgestureend");}if(s.m_Gesture){s.m_Gesture.target=null;}s.m_Gesture=null;};s.processgesturechange=function(a){if(VBI.m_bTrace){VBI.Trace("processgesturechange mode: "+s.m_nInputMode);}if((s.m_nInputMode!=VBI.InputModeDefault)&&(s.m_nInputMode!=VBI.InputModeTrackMap)){s.DispatchEvent(a,"sapmove");return;}if(VBI.m_bTrace){VBI.Trace("processgesturechange");VBI.Trace("rotation:"+a.rotation);VBI.Trace("scale:"+a.scale);VBI.Trace("trans:"+a.translationX+","+a.translationY);}var g=a.gestureObject;var b=Math.round(g.tx)-g.txdone;var c=Math.round(g.ty)-g.tydone;var i=Math.round(a.translationX)+b;var d=Math.round(a.translationY)+c;g.tx+=a.translationX;g.ty+=a.translationY;g.txdone+=i;g.tydone+=d;if(VBI.m_bTrace){VBI.Trace("done:"+g.txdone+","+g.tydone);VBI.Trace("calc:"+g.tx+","+g.ty);}if(i||d){if(VBI.m_bTrace){VBI.Trace("scene.processgesturechange move");}s.MoveMap(i,d);}if(a.scale!=1.0){s.ZoomMap(a.scale,a.offsetX,a.offsetY);s.TriggerReRenderTimer(400);}a.stopPropagation();a.preventDefault();return true;};s.processgestureinertiastart=function(a){if(VBI.m_bTrace){VBI.Trace("processgestureinertiastart");}a.preventDefault();};s.processpointerdown=function(a){if(VBI.m_bTrace){VBI.Trace("scene.processpointerdown ");}s.onsapdown(a);var g=s.m_Gesture;if(g&&(a.pointerType!=g.pointerType)){if(VBI.m_bTrace){VBI.Trace("processpointerdown gesture pointer type mismatch or gesture hasn't been started");}s.m_Gesture.target=null;g=s.m_Gesture=null;}if(!g){if(VBI.m_bTrace){VBI.Trace("processpointerdown create gesture");}g=s.m_Gesture=new window.MSGesture();g.pointerCount=0;g.target=a.srcElement;g.pointerType=a.pointerType;g.tx=0;g.ty=0;g.txdone=0;g.tydone=0;}if(a.pointerType==g.pointerType){g.addPointer(a.pointerId);g.pointerCount++;}return;};s.processpointerup=function(a){if(VBI.m_bTrace){VBI.Trace("processpointerup");}if(s.m_Gesture){s.m_Gesture.pointerCount--;if(!s.m_Gesture.pointerCount){s.m_Gesture.target=null;s.m_Gesture=null;}}return s.onsapup(a);};s.processpointermove=function(a){if(VBI.m_bTrace){VBI.Trace("scene.processpointermove");}s.m_currentMouseX=a.clientX;s.m_currentMouseY=a.clientY;s.onsapmove(a);return;};this.subscribe();};
VBI.SceneTouchEvents=function(s,a){"use strict";var i=s.m_SuppressedNavigation.move&&s.m_SuppressedNavigation.zoom;this.m_Events=["touchstart","touchend","touchmove","touchcancel"];this.clear=function(){for(var n=0,b=this.m_Events.length;n<b;++n){a["on"+this.m_Events[n]]=null;}};this.subscribe=function(){var b=this.m_Events;for(var n=0,c=b.length;n<c;++n){var h;if(b[n].slice(0,2)=="ms"){h="process"+b[n].slice(2);}else{h="process"+b[n];}if(!s[h]){if(VBI.m_bTrace){VBI.Trace("Error: Handler "+h+" not defined");}}a["on"+b[n]]=s[h];}};s.processtouchstart=function(e){var h=false;var c=s.m_Ctx;if(c.m_strOpenMenu){c.m_Menus.findMenuByID(c.m_strOpenMenu).close();c.m_strOpenMenu=undefined;}if(c.m_HitMenu){c.m_HitMenu.close();c.m_HitMenu.destroy();}if(VBI.m_bTrace){VBI.Trace("processtouchstart");}if(s.m_TapTimer){window.clearInterval(s.m_TapTimer);}if(s.DispatchEvent(e,"sapdown")==true){return;}s.m_Touches.push(e);s.m_TouchStarted=true;s.m_Touches.m_bMoveWasDone=false;if(e.touches.length==1&&!s.m_SuppressedNavigation.move){s.SetInputMode(VBI.InputModeDefault);var t=e.touches[0];s.m_currentMouseX=t.clientX;s.m_currentMouseY=t.clientY;if(VBI.m_bTrace){VBI.Trace("processtouchstart"+"X:"+s.m_currentMouseX+"Y:"+s.m_currentMouseY);}s.RestartContextMenuTimer(e,t,700);h=true;}else if(e.touches.length==2){s.SetInputMode(VBI.InputModeDefault);var b=e.touches[0];var d=e.touches[1];var f=(d.clientX+b.clientX)/2;var g=(d.clientY+b.clientY)/2;s.m_currentMouseX=f;s.m_currentMouseY=g;s.m_midPointX=f;s.m_midPointY=g;var j=Math.sqrt(Math.pow(b.clientX-d.clientX,2)+Math.pow(b.clientY-d.clientY,2));s.m_currentTouchDistance=j;if(VBI.m_bTrace){VBI.Trace("processtouchstart"+"X1:"+b.clientX+"Y1:"+b.clientY+"X2:"+d.clientX+"Y2:"+d.clientY);}h=true;}if(h&&!i){e.preventDefault();return false;}};s.RestartContextMenuTimer=function(e,t,d){if(s.m_ContextMenuTimer){window.clearInterval(s.m_ContextMenuTimer);}s.m_ContextMenuTimer=window.setInterval(function(){window.clearInterval(s.m_ContextMenuTimer);s.m_ContextMenuTimer=null;s.onPseudoRightClick(e,t);},d);};s.onPseudoRightClick=function(e,t){s.SetInputMode(VBI.InputModeDefault);if(VBI.m_bTrace){VBI.Trace("Pseudo Right Click");}if(s.DispatchEvent(e,"sapsecclick")==true){s.m_Touches=[];return;}var b;if((b=s.m_Ctx.m_Actions.findAction("ContextMenu",s,"Map"))){s.m_Touches=[];var r=s.GetInternalDivClientRect();s.m_Ctx.FireAction(b,s,"Map",null,{x:t.clientX-r.left,y:t.clientY-r.top,scene:s.m_ID});}};s.IsDoubleTap=function(e){if(e.length<4){return null;}var b=e.length-4;var c=e.length-2;if(e[b].type=="touchstart"&&e[b].touches.length!=1){return null;}if(e[c].type=="touchstart"&&e[c].touches.length!=1){return null;}var d=e[b].touches[0].clientX-e[c].touches[0].clientX;var f=e[b].touches[0].clientY-e[c].touches[0].clientY;if((d*d+f*f)>1000){return null;}var g=e.length-3;var h=e.length-1;var j=e[h].timeStamp-e[g].timeStamp;if(j>300){return null;}return[e[c].touches[0].clientX,e[c].touches[0].clientY];};s.IsTwoFingerTap=function(e){if((e.length<2)||(e.m_bMoveWasDone)){return null;}var b=e.length-2;var c=e.length-1;if(e[b].type!="touchstart"||e[b].touches.length!=2){return null;}var d=e[c].timeStamp-e[b].timeStamp;if(d>300){return null;}var t=e[b].touches;return[(t[0].clientX+t[1].clientX)/2,(t[0].clientY+t[1].clientY)/2];};s.IsSingleTap=function(e){if(e.length!=2||(e.m_bMoveWasDone)){return null;}var b=e.length-2;var c=e.length-1;if(e[b].type!="touchstart"||e[b].touches.length!=1){return null;}if(e[c].type!="touchend"){return null;}var r=[e[b].touches[0].clientX,e[b].touches[0].clientY];r.timeTouchDown=e[c].timeStamp-e[b].timeStamp;return r;};s.processtouchend=function(e){if(s.m_DesignVO){if(s.DispatchEvent(e,"sapup")==true){return;}}if(!s.m_Touches.length){return;}if(e.m_delayedExamination){s.m_Touches.pop();}if(VBI.m_bTrace){VBI.Trace("touchend");}window.clearInterval(s.m_ContextMenuTimer);s.m_ContextMenuTimer=null;if(s.DispatchEvent(e,"sapup")==true){s.m_Touches=[];return;}var r=s.GetInternalDivClientRect();if((r.width!=s.m_nDivWidth)||(r.height!=s.m_nDivHeight)){s.resizeCanvas(0);}s.m_Touches.push(e);var x;if((x=s.IsDoubleTap(s.m_Touches))){if(s.DispatchEvent(e,"sapdblclick")==true){s.m_Touches=[];e.stopPropagation();return;}if(!s.m_SuppressedNavigation.zoom){s.AnimateZoom(true,x[0],x[1],5);}s.m_Touches=[];}else if((x=s.IsTwoFingerTap(s.m_Touches))){if(!s.m_SuppressedNavigation.zoom){s.AnimateZoom(false,x[0],x[1],5);}s.m_Touches=[];}else{if(!(s.m_nInputMode==VBI.InputModeTrackMap)){s.InternalRenderLayer(s.m_Canvas[s.m_nOverlayIndex],false,true,true,s.m_Canvas[0].m_nExactLOD);}}if(s.m_Touches.length>2){s.m_Touches.splice(0,s.m_Touches.length-2);}s.SetInputMode(VBI.InputModeDefault);if((x=s.IsSingleTap(s.m_Touches))){if(x.timeTouchDown<300&&!e.m_delayedExamination){s.m_TapTimer=window.setInterval(function(){e.m_delayedExamination=true;s.processtouchend(e);window.clearInterval(s.m_TapTimer);},300);}else{if(s.DispatchEvent(e,"sapclick")){s.m_Touches=[];e.stopPropagation();return;}var b,c=s.m_Ctx.m_Actions;if(c){if((b=c.findAction("Click",s,"Map"))){var d=s.GetInternalDivClientRect();s.m_Ctx.FireAction(b,s,"Map",null,{x:x[0]-d.left,y:x[1]-d.top});}}s.m_Touches=[];}}if(!i){e.preventDefault();}};s.processtouchcancel=function(e){if(VBI.m_bTrace){VBI.Trace("touchcancel");}if(s.DispatchEvent(e,"sapup")==true){return;}s.SetInputMode(VBI.InputModeDefault);if(!i){e.preventDefault();}};s.processtouchmove=function(e){if(VBI.m_bTrace){VBI.Trace("touchmove");}if(s.m_DesignVO){if(s.DispatchEvent(e,"sapmove")==true){return;}}if(!s.m_Touches.length||!s.m_currentMouseX){return;}var d,b,t={},c;if(e.touches.length==1){t=e.touches[0];d=t.clientX-s.m_currentMouseX;b=t.clientY-s.m_currentMouseY;if(s.m_TouchStarted){var f=sap.ui.Device.support.retina?4:2;if(Math.abs(d)<f||Math.abs(b)<f){e.stopPropagation();return true;}else{s.m_TouchStarted=false;s.m_currentMouseX=t.clientX;s.m_currentMouseY=t.clientY;}}}if(VBI.m_bIsAndroid&&(e.touches.length==2)){var g=e.touches[0];c=e.touches[1];d=g.clientX+c.clientX-2*s.m_currentMouseX;b=g.clientY+c.clientY-2*s.m_currentMouseY;if((d==0)&&(b==0)){e.stopPropagation();return true;}}s.m_Touches.m_bMoveWasDone=true;window.clearInterval(s.m_ContextMenuTimer);s.m_ContextMenuTimer=null;var h=false;s.m_nTapCount=0;s.SetInputMode(VBI.InputModeTrackMap);if(e.touches.length==1){s.RestartContextMenuTimer(e,t,1100);if(VBI.m_bTrace){VBI.Trace("ontouchmove "+"X1:"+t.pageX+"Y1:"+t.pageY);}s.m_currentMouseX=t.clientX;s.m_currentMouseY=t.clientY;s.MoveMap(d,b);h=true;}else if(e.touches.length==2&&!s.m_SuppressedNavigation.zoom){var r=s.GetInternalDivClientRect();if((r.width!=s.m_nDivWidth)||(r.height!=s.m_nDivHeight)){s.resizeCanvas(0);}c=e.touches[0];var j=e.touches[1];var k=c.clientX+(j.clientX-c.clientX)/2;var l=c.clientY+(j.clientY-c.clientY)/2;var m=s.m_Canvas[0].getBoundingClientRect();k-=m.left;l-=m.top;var n=Math.sqrt(Math.pow(c.clientX-j.clientX,2)+Math.pow(c.clientY-j.clientY,2));if(Math.abs(s.m_currentTouchDistance-n)>10){var z=(n>s.m_currentTouchDistance)?true:false;s.m_currentTouchDistance=n;if(VBI.m_bTrace){VBI.Trace("ontouchmove "+" X1:"+c.pageX+" Y1:"+c.pageY+" X2:"+j.pageX+" Y2:"+j.pageY);}s.ZoomMap(z?s.m_nLodFactorZoomIn:s.m_nLodFactorZoomOut,k,l,s.m_nTicksInALod);s.TriggerReRenderTimer(400);}h=true;}if(h&&!i){e.stopPropagation();return true;}};s.SetInputModeTrackMap=function(S){if(!S){s.m_currentMouseX=0;s.m_currentMouseY=0;}};this.subscribe();};
VBI.SceneEvent=function(s,a){"use strict";this.m_DeviceHandlers=[];VBI.m_bMouseSupported=false;this.m_Events=["mousedown","mouseup","mousemove","mousewheel","wheel","mouseout","click","dblclick","contextmenu","selectstart","dragstart","dragenter","dragover","dragleave","drop","dragend","keydown","keypress","keyup"];a.dropzone="true";if(sap.ui.Device.support.pointer&&navigator.msMaxTouchPoints){this.m_DeviceHandlers.push(new VBI.ScenePointerEvents(s,a));}this.clear=function(){var n;for(n=0;n<this.m_DeviceHandlers.length;++n){this.m_DeviceHandlers[n].clear();}this.m_DeviceHandlers=[];for(n=0;n<this.m_Events.length;++n){var b="on"+this.m_Events[n];if(a[b]){a[b]=null;}}};this.subscribe=function(){var b=this.m_Events;for(var n=0,c=b.length;n<c;++n){var h;if(b[n].slice(0,2)=="ms"){h="process"+b[n].slice(2);}else if(s.m_SuppressedNavigation.zoom&&(b[n]==="wheel"||b[n]==="mousewheel")){continue;}else{h="process"+b[n];}if(!s[h]){jQuery.sap.log.error("Handler "+h+" not defined");}a["on"+b[n]]=s[h];}};if(sap.ui.Device.support.touch&&!(sap.ui.Device.support.pointer&&navigator.msMaxTouchPoints)){this.m_DeviceHandlers.push(new VBI.SceneTouchEvents(s,a));if(!sap.ui.Device.system.desktop){return;}}VBI.m_bMouseSupported=true;s.SetInputModeTrackMap=function(S){if(S){document.addEventListener('mouseup',s.processmouseup,true);document.addEventListener('mousemove',s.processmousemove,true);}else{s.m_currentMouseX=0;s.m_currentMouseY=0;document.removeEventListener('mouseup',s.processmouseup,true);document.removeEventListener('mousemove',s.processmousemove,true);}};s.onsapdown=function(e){if(VBI.m_bTrace){VBI.Trace("scene.onsapdown");}s.m_currentMouseDownX=e.clientX;s.m_currentMouseDownY=e.clientY;s.m_currentMouseX=e.clientX;s.m_currentMouseY=e.clientY;if(s.DispatchEvent(e,"sapdown")==true){return true;}};s.onsapup=function(e){if(VBI.m_bTrace){VBI.Trace("scene.onsapup");}if(s.DispatchEvent(e,"sapup")==true){return;}if(s.vbiclass=="3DScene"){return;}s.SetInputMode(VBI.InputModeDefault);e.preventDefault();return false;};s.onsapclick=function(e){if(VBI.m_bTrace){VBI.Trace("scene.onsapclick");}var d=s.m_currentMouseDownX-e.clientX;var b=s.m_currentMouseDownY-e.clientY;if((d*d+b*b)<=5){if(VBI.m_bTrace){VBI.Trace("process click dispatch");}if(s.DispatchEvent(e,"sapclick")==true){if(VBI.m_bTrace){VBI.Trace("process click handled in dispatch");}return;}if(s.Click){var r=s.m_Canvas[s.m_nOverlayIndex].getBoundingClientRect();e.m_clientX=e.clientX-r.left;e.m_clientY=e.clientY-r.top;if(s.Click(e)){return;}}var c,f=s.m_Ctx.m_Actions;if(f){if((c=f.findAction("Click",s,"Map"))){s.m_Ctx.FireAction(c,s,"Map",null,s.GetEventVPCoordsObj(e));}e.preventDefault();}}};s.onsapmove=function(e){if(VBI.m_bTrace){VBI.Trace("scene.onsapmove");}if(s.DispatchEvent(e,"sapmove")==true){return true;}if(s.vbiclass=="3DScene"){return true;}s.SetToolTip("");s.SetCursor('default');s.InternalSetHotItem(null,null);return false;};s.processmousedown=function(e){if(VBI.m_bTrace){VBI.Trace("scene.processmousedown");}if(s.m_Gesture){return;}if(s.onsapdown(e)){return;}if(s.vbiclass=="3DScene"){return;}if(!s.m_SuppressedNavigation.move&&(e.type.indexOf("pointer")<0)&&(!sap.ui.Device.os.macintosh||e.which==1)){if(VBI.m_bTrace){VBI.Trace("set input mode track map");}s.SetInputMode(VBI.InputModeTrackMap);s.m_Canvas[s.m_nLabelIndex].focus({preventScroll:true});}};s.BuildKeyEventParams=function(e){return{key:e.key,code:e.keyCode,shift:e.shiftKey,ctrl:e.ctrlKey,alt:e.altKey,meta:e.metaKey};};s.processkeyup=function(e){if(VBI.m_bTrace){VBI.Trace("scene.processkeyup");}if(e.code==undefined){e.code=e.keyCode;}var d=s.m_KeysDown.indexOf(e.code);var u=s.m_KeysSkipUp.indexOf(e.code);var p=s.m_KeysSkipPress.indexOf(e.code);if(d!=-1){s.m_KeysDown.splice(d,1);}if(p!=-1){s.m_KeysSkipPress.splice(p,1);}if(u!=-1){s.m_KeysSkipUp.splice(u,1);return;}if(s.m_Ctx.m_Actions){var b=s.m_Ctx.m_Actions.findAction("KeyUp",s);if(b){s.m_Ctx.FireAction(b,s,this,null,s.BuildKeyEventParams(e));}}};s.processkeypress=function(e){if(VBI.m_bTrace){VBI.Trace("scene.processkeypress");}if(e.code==undefined){e.code=e.keyCode;}var p=s.m_KeysSkipPress.indexOf(e.code);if(p!=-1){s.m_KeysSkipPress.splice(p,1);return;}if(s.m_KeysDown.indexOf(e.code)==-1){return;}if(s.m_Ctx.m_Actions){var b=s.m_Ctx.m_Actions.findAction("KeyPress",s);if(b){s.m_Ctx.FireAction(b,s,this,null,s.BuildKeyEventParams(e));}}};s.processkeydown=function(e){if(VBI.m_bTrace){VBI.Trace("scene.processkeydown");}if(s.DispatchEvent(e,"sapkeydown")==true){return;}e.m_Repeat=e.repeat;if(e.code==undefined){e.code=e.keyCode;}if(s.m_KeysDown.indexOf(e.code)!=-1){e.m_Repeat=true;}else{s.m_KeysDown.push(e.code);}if(e.m_Repeat&&!s.m_Ctx.m_Control.getAllowKeyEventRepeat()){if(s.m_KeysSkipPress.indexOf(e.code)==-1){s.m_KeysSkipPress.push(e.code);}return;}if(e.code==s.m_lastKey&&s.m_lastKeyDown!=null&&(Date.now()-s.m_lastKeyDown)<s.m_Ctx.m_Control.getKeyEventDelay()){if(s.m_KeysSkipPress.indexOf(e.code)==-1){s.m_KeysSkipPress.push(e.code);}if(!e.m_Repeat){if(s.m_KeysSkipUp.indexOf(e.code)==-1){s.m_KeysSkipUp.push(e.code);}}return;}s.m_lastKey=e.code;s.m_lastKeyDown=Date.now();var r=s.GetInternalDivClientRect();if((r.width!=s.m_nDivWidth)||(r.height!=s.m_nDivHeight)){s.resizeCanvas(0);}var d=true;if(s.m_Ctx.m_Actions){var b=s.m_Ctx.m_Actions.findAction("KeyDown",s);if(b){d=s.m_Ctx.FireAction(b,s,this,null,s.BuildKeyEventParams(e),null,true);}}if(d){var h=false;switch(e.keyCode){case 72:s.GoToInitialStart();h=true;break;case 90:s.endTrackingMode();new s.RectangularZoom();s.m_Ctx.onChangeTrackingMode(VBI.InputModeRectZoom,true);h=true;break;case 82:s.endTrackingMode();new s.RectSelection();s.m_Ctx.onChangeTrackingMode(VBI.InputModeRectSelect,true);h=true;break;case 65:s.endTrackingMode();new s.LassoSelection();s.m_Ctx.onChangeTrackingMode(VBI.InputModeLassoSelect,true);h=true;break;}if(!s.m_SuppressedNavigation.zoom){var z=0;switch(e.keyCode){case 107:case 171:case 187:z=1;break;case 109:case 173:case 189:z=-1;break;}if(z!=0){var c=s.GetCenterPos();var n=s.getCanvas().m_nExactLOD;var m=s.GetMinLOD();if(z>0&&n==m&&n!=Math.ceil(n)){n=Math.ceil(n);}else{n+=z;}s.AnimateZoomToGeo(c,Math.round(n),5);h=true;}}if(!s.m_SuppressedNavigation.move){var f=20;switch(e.keyCode){case 37:s.MoveMap(f,0);h=true;break;case 39:s.MoveMap(-f,0);h=true;break;case 38:s.MoveMap(0,f);h=true;break;case 40:s.MoveMap(0,-f);h=true;break;}}if(h){e.preventDefault();}}};s.processcontextmenu=function(e){if(e.target!=s.m_Canvas[s.m_nLabelIndex]){return;}if(VBI.m_bTrace){VBI.Trace("scene.processcontextmenu");}if(s.DispatchEvent(e,"sapsecclick")==true){return;}var b,c=s.m_Ctx.m_Actions;if(c){if((b=c.findAction("ContextMenu",s,"Map"))){s.m_Ctx.FireAction(b,s,"Map",null,s.GetEventVPCoordsObjWithScene(e));}e.preventDefault();}};s.processmouseout=function(e){if(VBI.m_bTrace){VBI.Trace("scene.processmouseout");}if(s.DispatchEvent(e,"sapout")==true){return;}s.InternalSetHotItem(null,null);return false;};s.processdblclick=function(e){if(VBI.m_bTrace){VBI.Trace("scene.processdblclick");}if(s.DispatchEvent(e,"sapdblclick")==true){return;}return;};s.processclick=function(e){if(e.target!=s.m_Canvas[s.m_nLabelIndex]){return;}if(VBI.m_bTrace){VBI.Trace("scene.processclick");}if(s.m_Gesture){return;}return s.onsapclick(e);};s.processmouseup=function(e){if(VBI.m_bTrace){VBI.Trace("scene.processmouseup");}s.dragclear();return s.onsapup(e);};s.processmousemove=function(e){if(VBI.m_bTrace){VBI.Trace("scene.processmousemove");}if(s.m_DragInfo){if(s.m_DragInfo.bDragStart){return false;}return;}var d=e.clientX-s.m_currentMouseX;var b=e.clientY-s.m_currentMouseY;s.m_currentMouseX=e.clientX;s.m_currentMouseY=e.clientY;if(s.m_Gesture){return;}if(s.onsapmove(e)){return;}if(s.m_nInputMode==VBI.InputModeTrackMap){if(!(e.buttons==1||e.which==1)){s.SetInputMode(VBI.InputModeDefault);return false;}if(d||b){s.MoveMap(d,b);}return false;}e.preventDefault();};s.processmousewheel=function(e){s.processcommonwheel(e,e.wheelDelta);return false;};s.processwheel=function(e){s.processcommonwheel(e,-e.deltaY);return false;};s.processcommonwheel=function(e,d){var r=s.m_Canvas[s.m_nLabelIndex].getBoundingClientRect();e.m_OffsetX=e.clientX-r.left;e.m_OffsetY=e.clientY-r.top;e.m_Delta=d;var t=Date.now();if((s.m_LastCWEvent!=undefined)&&(t-s.m_LastCWEvent<200)){return;}s.m_LastCWEvent=t;if(VBI.m_bTrace){VBI.Trace("processcommonwheel");}if(s.DispatchEvent(e)==true){return;}if(s.vbiclass=="3DScene"){e.preventDefault();}else if(!s.m_SuppressedNavigation.zoom&&e.m_Delta){var r=s.GetInternalDivClientRect();if((r.width!=s.m_nDivWidth)||(r.height!=s.m_nDivHeight)){s.resizeCanvas(0);}if(s.m_nZoomMode){var b=s.m_Canvas[0].getBoundingClientRect();s.AnimateZoom(e.m_Delta>0,e.m_OffsetX+b.left,e.m_OffsetY+b.top,5,e);}else{s.ZoomMap(e.m_Delta>0?s.m_nLodFactorZoomIn:s.m_nLodFactorZoomOut,e.m_OffsetX,e.m_OffsetY,s.m_nTicksInALod);}e.preventDefault();}return;};s.dragclear=function(e){var i=document.getElementById(s.m_Target.id+"-transparentImg");if(i){s.m_Div.removeChild(i);}s.m_DragInfo=null;VBI.m_DndTarget=null;};s.processdragleave=function(e){return;};s.processdragend=function(e){e.preventDefault();e.stopPropagation();s.dragclear();return true;};s.processselectstart=function(e){if(e.target.dragDrop&&s.m_DragInfo){e.target.dragDrop();}e.preventDefault();return true;};s.processdragstart=function(e){if(s.m_DragInfo){if(s.m_DragInfo.strExtData){e.dataTransfer.setData('text',s.m_DragInfo.strExtData);}else{e.dataTransfer.setData('text',"");}e.dataTransfer.effectAllowed='copy';s.m_DragInfo.bDragStart=true;VBI.m_DndTarget=e.target;if(e.dataTransfer.setDragImage||VBI.Utilities.SetDragImage){var i=VBI.Utilities.GetTransparentImage();i.id=s.m_Target.id+"-transparentImg";s.m_Div.appendChild(i);if(e.dataTransfer.setDragImage){e.dataTransfer.setDragImage(i,0,0);}else{VBI.Utilities.SetDragImage(i,0,0);}}if(s.m_Gesture){s.m_Gesture.target=null;s.m_Gesture=null;}return true;}return false;};s.processdragenter=function(e){if(!e.dataTransfer){return false;}if(e.dataTransfer){try{e.dataTransfer.dropEffect='copy';}catch(b){jQuery.sap.log.warning("scene.processdragenter exception occured: "+b.message);}}e.preventDefault();return true;};s.processdragover=function(e){if(!e.dataTransfer){return false;}if(s.m_Gesture){return;}if(s.m_DragInfo&&s.m_DragInfo.bDragStart){s.DispatchEvent(e,"sapdrag");}else{e.preventDefault();}return;};s.DesignCreateObject=function(d,p,f){var b=null;if(typeof d=='string'){b=d;}else{b=JSON.stringify(d);}if(b.indexOf("{POS}")>=0){if(p){var c=""+p[0]+";"+p[1]+";"+"0.0";var t=b.replace(/{POS}/g,c);f(t);}else{new s.DesignPositionArray(null,b,f,"{POS}",1);}}else if(b.indexOf("{POSARRAY}")>=0){new s.DesignPositionArray(p?[p[0],p[1],0.0]:null,b,f,"{POSARRAY}",null);}else{f(d);}return;};s.processdrop=function(e){if(!e.dataTransfer){s.dragclear();return false;}if(s.m_DragInfo&&s.m_DragInfo.bDragStart){s.DispatchEvent(e,"sapdrop");e.preventDefault();e.stopPropagation();s.dragclear();return true;}var d=e.dataTransfer.getData('text');var r=s.m_Canvas[0].getBoundingClientRect();var p=s.GetPosFromPoint([e.clientX-r.left,e.clientY-r.top,0.0]);var b=null,c=s.m_Ctx.m_Actions;if(c){b=s.m_Ctx.m_Actions.findAction("Drop",s,"Map");}var f=null;if(b){f=function(g){var h=s.GetEventVPCoordsObj(e);h.content=g;s.m_Ctx.FireAction(b,s,"Map",null,h);};}else{f=s.m_Ctx.m_Control.load.bind(s.m_Ctx.m_Control);}s.DesignCreateObject(d,p,f);e.preventDefault();e.stopPropagation();s.dragclear();return true;};s.DesignTrack=function(o){this.m_Tcx=o;this.onsapkeydown=function(e){if(e.keyCode==27){this.UnHook(false);e.preventDefault();return true;}};this.onsapclick=function(e){if(VBI.m_bTrace){VBI.Trace("Track sapclick");}this.UnHook();return false;};this.onsapdown=function(e){if(VBI.m_bTrace){VBI.Trace("Track sapdown");}e.preventDefault();return true;};this.onsapmove=function(e){if(VBI.m_bTrace){VBI.Trace("Track sapmove");}var t=this.m_Tcx;t.m_ClientX=e.offsetX;t.m_ClientY=e.offsetY;if(t.m_CBDrag){if(VBI.m_bTrace){VBI.Trace("Track sapmove: orig type "+e.type);}t.m_CBDrag(t,e);}e.preventDefault();e.stopPropagation();return true;};this.onsapup=function(e){if(VBI.m_bTrace){VBI.Trace("Track sapup");}var t=this.m_Tcx;t.m_ClientX=e.offsetX;t.m_ClientY=e.offsetY;if(t.m_CBDrop){t.m_CBDrop(t,e);}if(t.m_CBEnd){t.m_CBEnd(t,e);}this.UnHook();e.preventDefault();e.stopPropagation();return true;};this.Hook=function(){s.SetInputMode(VBI.InputModeTrackObject);s.m_DesignVO=this;};this.UnHook=function(){if(s.m_DesignVO!=this){return;}if(s.m_nInputMode==VBI.InputModeTrackObject){s.SetInputMode(VBI.InputModeDefault);}else{jQuery.sap.log.error("Wrong InputMode in UnHook: "+s.m_nInputMode);}s.m_DesignVO=null;this.m_Tcx=null;s.RenderAsync(true);};this.Render=function(c,d){return;};this.Hook();};s.DesignPositionArray=function(p,l,f,b,m){this.m_PosArray=p?p:[];this.m_PosMove=null;this.m_Func=f;this.m_PlaceHolder=b;s.SetCursor('crosshair');this.onsapkeydown=function(e){if(e.keyCode==27){this.UnHook(false);e.preventDefault();return true;}};this.onsapclick=function(e){if(VBI.m_bTrace){VBI.Trace("this.onsapclick "+e.type);}var r=s.m_Canvas[s.m_nOverlayIndex].getBoundingClientRect();var p=s.GetPosFromPoint([e.clientX-r.left,e.clientY-r.top,0]);var t=[p[0],p[1],0.0];var c=this.m_PosArray.length;var n=c/3;if((n>=1)&&(this.m_PosArray[c-3]==t[0])&&(this.m_PosArray[c-2]==t[1])&&(this.m_PosArray[c-1]==t[2])){return true;}for(var d=0,g=t.length;d<g;++d){this.m_PosArray.push(t[d]);}n=this.m_PosArray.length/3;s.RenderAsync(true);e.preventDefault();if(m&&n>=m){this.UnHook(true);}return true;};this.onsapdown=function(e){e.preventDefault();return true;};this.onsapmove=function(e){jQuery.sap.log.debug("this.onsapmove");jQuery.sap.log.error("Wrong InputMode in onsapmove: "+s.m_nInputMode);var r=s.m_Canvas[0].getBoundingClientRect();this.m_PosMove=s.GetPosFromPoint([e.clientX-r.left,e.clientY-r.top,0]);s.RenderAsync(true);e.preventDefault();return true;};this.onsapdblclick=function(e){this.UnHook(true);return true;};this.Hook=function(){s.SetInputMode(VBI.InputModeTrackDesign);s.m_DesignVO=this;};this.UnHook=function(A){if(s.m_nInputMode==VBI.InputModeTrackDesign){s.SetInputMode(VBI.InputModeDefault);}else{jQuery.sap.log.error("Wrong InputMode in UnHook: "+s.m_nInputMode);}this.m_PosMove=null;var c=VBI.Types.vector2string(this.m_PosArray);var t=l.replace(new RegExp(this.m_PlaceHolder,'g'),c);s.m_DesignVO=null;s.RenderAsync(true);if(A&&this.m_Func){this.m_Func(t);}};this.Render=function(c,d){var x,e=1.0;if(!this.m_PosArray.length){return;}var S=false;var C=this.m_PosArray.concat(this.m_PosMove);var g=s.GetNearestPosArray(C);var h=s.GetPointArrayFromPosArray(g,false);d.strokeStyle="rgba( 255, 0, 20, 0.5 )";d.lineWidth=e;var i=e*e/2;d.beginPath();var t=[h[0],h[1]];d.moveTo(h[0],h[1]);for(var n=0,j,k;n<h.length/3;++n){x=[h[n*3],h[n*3+1],0.0];if(((j=(t[0]-x[0]))*j+(k=(t[1]-x[1]))*k)<i){continue;}S=true;d.lineTo(x[0],x[1]);t=x;}if(S){d.stroke();}};this.Hook();};this.subscribe();};
VBI.ThumbnailEvent=function(s,a){"use strict";this.m_DeviceHandlers=[];this.m_Events=["click","contextmenu"];if(sap.ui.Device.support.touch&&!(sap.ui.Device.support.pointer&&navigator.msMaxTouchPoints)){var t=["touchstart","touchend"];if(!sap.ui.Device.system.desktop){this.m_Events=t;}else{this.m_Events=this.m_Events.concat(t);}}this.clear=function(){var n;for(n=0;n<this.m_DeviceHandlers.length;++n){this.m_DeviceHandlers[n].clear();}this.m_DeviceHandlers=[];for(n=0;n<this.m_Events.length;++n){var b="on"+this.m_Events[n];if(a[b]){a[b]=null;}}};this.subscribe=function(){var b=this.m_Events;for(var n=0,c=b.length;n<c;++n){var h;if(b[n].slice(0,2)=="ms"){h="process"+b[n].slice(2);}else{h="process"+b[n];}if(!s[h]){jQuery.sap.log.error("Handler "+h+" not defined");}a["on"+b[n]]=s[h];}};s.processclick=function(e){if(VBI.m_bTrace){VBI.Trace("thumbnail.processclick");}var b,c=s.m_Ctx.m_Actions;if(c){if((b=c.findAction("Click",s,"Thumbnail"))){s.m_Ctx.FireAction(b,s,"Thumbnail",null,s.GetEventVPCoordsObj(e));}e.preventDefault();}};s.processcontextmenu=function(e){if(VBI.m_bTrace){VBI.Trace("thumbnail.processcontextMenu");}var b,c=s.m_Ctx.m_Actions;if(c){if((b=c.findAction("ContextMenu",s,"Thumbnail"))){s.m_Ctx.FireAction(b,s,"Thumbnail",null,s.GetEventVPCoordsObj(e));}e.preventDefault();}};s.onPseudoThumbRightClick=function(e,b){if(VBI.m_bTrace){VBI.Trace("Pseudo Right Click");}var c;if((c=s.m_Ctx.m_Actions.findAction("ContextMenu",s,"Thumbnail"))){s.m_Touches=[];var r=s.GetInternalDivClientRect();s.m_Ctx.FireAction(c,s,"Thumbnail",null,{x:b.clientX-r.left,y:b.clientY-r.top,scene:s.m_ID});}};s.RestartThumbnailCMTimer=function(e,b,d){if(s.m_ContextMenuTimer){window.clearInterval(s.m_ContextMenuTimer);}s.m_ContextMenuTimer=window.setInterval(function(){window.clearInterval(s.m_ContextMenuTimer);s.m_ContextMenuTimer=null;s.onPseudoThumbRightClick(e,b);},d);};s.processtouchstart=function(e){var h=true;if(VBI.m_bTrace){VBI.Trace("processtouchstart");}s.m_Touches.push(e);if(e.touches.length==1){var b=e.touches[0];s.m_currentMouseX=b.clientX;s.m_currentMouseY=b.clientY;s.RestartThumbnailCMTimer(e,b,700);h=true;}if(h){e.preventDefault();e.stopPropagation();return false;}};s.IsSingleTapOnThumb=function(e){if(e.length!=2){return null;}var i=e.length-2;var b=e.length-1;if(e[i].type!="touchstart"||e[i].touches.length!=1){return null;}if(e[b].type!="touchend"){return null;}var r=[e[i].touches[0].clientX,e[i].touches[0].clientY];r.timeTouchDown=e[b].timeStamp-e[i].timeStamp;return r;};s.processtouchend=function(e){if(!s.m_Touches.length){return;}if(VBI.m_bTrace){VBI.Trace("touchend");}window.clearInterval(s.m_ContextMenuTimer);s.m_ContextMenuTimer=null;s.m_Touches.push(e);var x,b,c=s.m_Ctx.m_Actions;if((x=s.IsSingleTapOnThumb(s.m_Touches))&&c){if((b=c.findAction("Click",s,"Thumbnail"))){var r=s.GetInternalDivClientRect();s.m_Ctx.FireAction(b,s,"Thumbnail",null,{x:x[0]-r.left,y:x[1]-r.top});}}s.m_Touches=[];e.stopPropagation();e.preventDefault();};this.subscribe();};
},
	"sap/ui/vbm/lib/sapgeolocation.js":function(){
VBI.GeoLocation=function(){"use strict";var g={};g.vbiclass="GeoLocation";g.m_coords={};g.m_bValid=false;g.m_coords.latiude=0;g.m_coords.longitude=0;g.m_coords.altitude=0;g.m_coords.accuracy=0;g.m_coords.altiudeAccuracy=0;g.m_coords.heading=0;g.m_coords.speed=0;g.m_timestamp=0;g.m_watch=null;g.OnError=function(m){jQuery.sap.log.debug("GeoLocation.OnError: "+(typeof m=='string'?m:"unknown"));};g.OnPosition=function(p){g.m_coords.latiude=p.coords.latitude*Math.PI/180;g.m_coords.longitude=p.coords.longitude*Math.PI/180;g.m_coords.altitude=p.coords.altitude;g.m_coords.accuracy=p.coords.accuracy;g.m_coords.altiudeAccuracy=p.coords.altiudeAccuracy;g.m_coords.heading=p.coords.heading;g.m_coords.speed=p.coords.speed;g.m_timestamp=p.timestamp;g.m_bValid=true;g.OnPositionChanged(g);};g.StartWatch=function(){if(g.watch){return;}if(!navigator){return;}g.m_watch=navigator.geolocation.watchPosition(g.OnPosition,g.OnError);return;};g.StopWatch=function(){if(g.watch){navigator.geolocation.clearWatch(g.watch);}g.watch=null;};g.GetWifiScan=function(l,a){var w=VBI.Utilities.CreateWifiObject();if(w){return w.ScanWifi("Scan "+a+","+l,0);}return null;};g.OnPositionChanged=null;return g;};
},
	"sap/ui/vbm/lib/sapgeomath.js":function(){VBI.MathLib=(function(){"use strict";var m={};m.min_longitude=-Math.PI;m.max_longitude=Math.PI;m.min_latitude=(-85.05112878*2*Math.PI)/360.0;m.max_latitude=(85.05112878*2*Math.PI)/360.0;m.mercator_for_max_latitude=3.1415942;m.div_mercator_for_max_latitude=(0.5/m.mercator_for_max_latitude);m.div_max_longitude=(1.0/m.max_longitude);m.earthradius=6378137;m.piDiv180=Math.PI/180.0;m.One180DivPi=1/m.piDiv180;m.stdWorldBorder=-180;m.CreateGUID=function(){var s=[];for(var n=0;n<8;++n){s[n]=(((Math.random()+1)*0x10000)|0).toString(16).substring(1);}return(s[0]+s[1]+"-"+s[2]+"-"+s[3]+"-"+s[4]+"-"+s[5]+s[6]+s[7]);};m.DegToRad=function(l){return[l[0]*m.piDiv180,l[1]*m.piDiv180];};m.RadToDeg=function(l){return[l[0]*m.One180DivPi,l[1]*m.One180DivPi];};m.LonLatToUCS=function(l,u){var n=u[0];var a=u[1];var L=l[0];var f=l[1];if(f<m.min_latitude){f=m.min_latitude;}else if(f>m.max_latitude){f=m.max_latitude;}u[0]=L*m.div_max_longitude;u[0]=(u[0]+1.0)*n*0.5;var s=Math.sin(f);u[1]=(Math.log((1.0+s)/(1.0-s))*m.div_mercator_for_max_latitude);u[1]=0.5*a*(1.0-u[1]);return u;};m.UCSToLonLat=function(u,l){l[0]=u[0]*Math.PI;l[1]=Math.atan(m.sinh(-u[1]*m.mercator_for_max_latitude));return l;};m.sinh=function(v){var a=Math.pow(Math.E,v);var b=Math.pow(Math.E,-v);return(a-b)/2.0;};m.Distance=function(l,b){var R=m.earthradius;var e=l[1];var f=l[0];var g=b[1];var h=b[0];var L=g-e;var i=h-f;var a=Math.sin(L/2)*Math.sin(L/2)+Math.cos(e)*Math.cos(g)*Math.sin(i/2)*Math.sin(i/2);var c=2*Math.atan2(Math.sqrt(a),Math.sqrt(1-a));var d=R*c;return d;};m.EquidistantLonLat=function(l,d,s){var r=[];s=s||64;var b,y,x;var a=d/m.earthradius;var c=l[0];var e=l[1];var f=Math.sin(a);var g=Math.cos(a);var h=Math.sin(e);var i=Math.cos(e);var j=c,k=c;var n=e,o=e;for(var p=0;p<s;++p){b=p*2*Math.PI/s;y=Math.asin(h*g+i*f*Math.cos(b));x=c+Math.atan2(Math.sin(b)*f*i,g-h*Math.sin(y));if(j>x){j=x;}if(k<x){k=x;}if(n>y){n=y;}if(o<y){o=y;}r.push([x,y]);}r.m_MinX=j;r.m_MaxX=k;r.m_MinY=n;r.m_MaxY=o;return r;};m.GetSurroundingBox=function(c,d,e,C,f){var g=100;var w=m.stdWorldBorder;if(d==undefined){d=360;}var p=(c[0].length==2);var h=0,j=1,k=2,l=3;if(p){j=0;k=l=1;}var n=Number.MAX_VALUE,o=-Number.MAX_VALUE;var q,r,s,t,i;for(i=0;i<c.length;++i){s=c[i];if(((q=s[h])<-180)||(q>180)){t=Math.floor((q+180)/360);q=(s[h]-=360*t);s[j]-=360*t;}if((r=s[j])<q){t=Math.ceil((q-r)/360);r=(s[j]+=360*t);}if(s[k]<n){n=s[k];}if(s[l]>o){o=s[l];}}c.sort(function(a,b){return a[0]-b[0];});var u=-1,v=-1;var x=-1,y=-1;var z,A;var B=c[0];var D,E=B[j],F=B[h];var G,H;for(i=1;i<c.length;++i){B=c[i];F=B[h];D=B[j];if(F<E){if(D>E){E=D;}}else{if((F-E)>u){z=E;u=F-E;x=i;}if((F-E)>v){G=Math.abs(((F-w+540)%360)-180);H=Math.abs(((E-w+540)%360)-180);if((G<g)||(H<g)){A=E;v=F-E;y=i;}}E=D;}}B=c[0];F=B[h];var I=F-E+360;if(I>v){G=Math.abs(((F-w+540)%360)-180);H=Math.abs(((E-w+540)%360)-180);if((G<g)||(H<g)){A=E;v=I;y=0;}}if(I>u){u=I;z=E;}else{if(x<0){return[w,w+360,n,o,false];}B=c[x];}z-=360*Math.floor((z+180)/360);var J=Math.floor(e)+1;var K=(e==undefined)?0:360/Math.pow(2,J-e);var L=1000;if(d==0){d=K;if(C!=undefined){L=Math.floor(C(n,o));}}var M=z-B[h]+360*(z<B[h]);var S=false;if(e!=undefined){var N=Math.floor(J+Math.log(K/(360-u))/Math.LN2);if((M>d)||Math.min(N,L)<=e+f){return[w,w+360,n,o,false];}if(K&&(v>=0)){var O=Math.floor(J+Math.log(K/(360-v))/Math.LN2);S=((N==O)||(N<=O));}if(S){B=c[y];z=A-360*Math.floor((A+180)/360);}}return[B[h],z,n,o];};return m;})();
},
	"sap/ui/vbm/lib/sapgeotool.js":function(){
VBI.QuadTree=function(m,b,r){"use strict";var L=0,R=1,c=2,d=3,O=4;var q=function(e,f,m,b){var g=[];var i=[];return{quc:function(r,a){var t;for(var n=0,l=i.length;n<l;++n){t=i[n];if(t[0]>r[2]||t[2]<r[0]||t[1]>r[3]||t[3]<r[1]){continue;}a(t);}if(g.length){this.calcIntersectingNodes(r,a);}},qua:function(r,a){this.quc(r,function(h){a.push(h);});},calcIntersectingNodes:function(r,a){var l=e[0],t=e[1],w=(e[2]-l)/2.0,h=(e[3]-t)/2.0;if(r[0]<l+w){if(r[1]<t+h){g[L].quc(r,a);}if(r[3]>=t+h){g[c].quc(r,a);}}if(r[2]>=l+w){if(r[1]<t+h){g[R].quc(r,a);}if(r[3]>=t+h){g[d].quc(r,a);}}},calcQuadrant:function(r){var l,t,w=((e[2]-(l=e[0]))/2.0),h=((e[3]-(t=e[1]))/2.0);if(r[2]<l+w){if(r[3]<t+h){return L;}if(r[1]>=t+h){return c;}return O;}if(r[0]>=l+w){if(r[3]<t+h){return R;}if(r[1]>=t+h){return d;}return O;}return O;},subdivide:function(){var a=e[0];var h=e[1];var w=((e[2]-a)/2.0),j=((e[3]-h)/2.0);var k=++this.m_D;var l,t;g[L]=q([l=a,t=h,l+w,t+j],k,m,b);g[R]=q([l=a+w,t=h,l+w,t+j],k,m,b);g[c]=q([l=a,t=h+j,l+w,t+j],k,m,b);g[d]=q([l=a+w,t=h+j,l+w,t+j],k,m,b);var n=i;i=[];for(var o=0,p=n.length;o<p;++o){this.insert(n[o]);}},insert:function(r){var a;if(g.length){if((a=this.calcQuadrant(r))==O){i.push(r);}else{g[a].insert(r);}}else{i.push(r);if(i.length>m&&this.m_D<b){this.subdivide();}}},clear:function(){for(var n=0,l=g.length;n<l;++n){g[n].clear();}i.length=0;g.length=0;},getNodes:function(){return g.length?g:null;},m_R:e,m_D:f};};return{insertArray:function(i){for(var n=0,l=i.length;n<l;++n){this.m_Root.insert(i[n]);}},insert:function(r){this.m_Root.insert(r);},queryArray:function(r,a){return this.m_Root.qua(r,a);},queryCallback:function(r,a){return this.m_Root.quc(r,a);},clear:function(){this.m_Root.clear();},m_Root:(function(){return q(r,0,m,b);})()};};
},
	"sap/ui/vbm/lib/sapheatmap.js":function(){VBI.Tex=null;VBI.Shader=null;VBI.FB=null;VBI.Vals=null;VBI.Ro=null;VBI.Hm=null;VBI.Hook=(function(){"use strict";if(window.WebGLRenderingContext){var g=WebGLRenderingContext.prototype.getExtension;WebGLRenderingContext.prototype.getExtension=function(n){var v=['','MS','WEBKIT','MOZ','O'];var e,a;if((e=g.call(this,n))===null){for(var b=0,l=v.length;b<l;++b){a=v[b];if((e=g.call(this,a+'_'+n))!==null){return e;}}return null;}else{return e;}};WebGLRenderingContext.prototype.getExtensions=function(s){return this.getExtension('OES_texture_float');};}})();VBI.Shader=(function(){"use strict";function S(g,v,f){this.m_GL=g;this.m_UL={};this.m_Prog=this.m_GL.createProgram();this.m_VS=this.m_GL.createShader(this.m_GL.VERTEX_SHADER);this.m_FS=this.m_GL.createShader(this.m_GL.FRAGMENT_SHADER);this.m_GL.attachShader(this.m_Prog,this.m_VS);this.Compile(this.m_VS,v);this.m_GL.attachShader(this.m_Prog,this.m_FS);this.Compile(this.m_FS,f);this.Link();}S.prototype.getShaderVar=function(n){return this.m_GL.getAttribLocation(this.m_Prog,n);};S.prototype.Compile=function(s,a){this.m_GL.shaderSource(s,a);this.m_GL.compileShader(s);if(!this.m_GL.getShaderParameter(s,this.m_GL.COMPILE_STATUS)){jQuery.sap.log.error("Shader Compilation Error");jQuery.sap.log.error(this.m_GL.getShaderInfoLog(s));}};S.prototype.Link=function(){this.m_GL.linkProgram(this.m_Prog);if(!this.m_GL.getProgramParameter(this.m_Prog,this.m_GL.LINK_STATUS)){jQuery.sap.log.error("Shader Link Error");jQuery.sap.log.error(this.m_GL.getProgramInfoLog(this.m_Prog));}};S.prototype.Apply=function(){this.m_GL.useProgram(this.m_Prog);return this;};S.prototype.getLoc=function(n){var l=this.m_UL[n];if(typeof(l)==="undefined"){l=this.m_UL[n]=this.m_GL.getUniformLocation(this.m_Prog,n);}return l;};S.prototype.SetInt=function(n,v){this.m_GL.uniform1i(this.getLoc(n),v);return this;};return S;})();VBI.FB=(function(){"use strict";function F(g){this.m_GL=g;this.m_FB=this.m_GL.createFramebuffer();}F.prototype.destroy=function(){return this.m_GL.deleteFramebuffer(this.m_FB);};F.prototype.BindFB=function(){this.m_GL.bindFramebuffer(this.m_GL.FRAMEBUFFER,this.m_FB);return this;};F.prototype.UnBindFB=function(){this.m_GL.bindFramebuffer(this.m_GL.FRAMEBUFFER,null);return this;};F.prototype.SetTex=function(t){this.m_GL.framebufferTexture2D(this.m_GL.FRAMEBUFFER,this.m_GL.COLOR_ATTACHMENT0,this.m_GL.TEXTURE_2D,t.m_Tex,0);var s=this.m_GL.checkFramebufferStatus(this.m_GL.FRAMEBUFFER);if(s!==this.m_GL.FRAMEBUFFER_COMPLETE){return null;}return this;};return F;})();VBI.Tex=(function(){"use strict";function T(g,p){var t;this.m_GL=g;p=p?p:{};this.m_colFmt=this.m_GL[((t=p.colfmt)!=null?t:'rgba').toUpperCase()];if(typeof p.type==='number'){this.type=p.type;}else{this.type=this.m_GL[((t=p.type)!=null?t:'unsigned_byte').toUpperCase()];}this.m_Tex=this.m_GL.createTexture();}T.prototype.destroy=function(){return this.m_GL.deleteTexture(this.m_Tex);};T.prototype.BindTex=function(s){if(s==null){s=0;}this.m_GL.activeTexture(this.m_GL.TEXTURE0+s);this.m_GL.bindTexture(this.m_GL.TEXTURE_2D,this.m_Tex);return this;};T.prototype.AdjustSize=function(w,h){this.m_W=w;this.m_H=h;this.m_GL.texImage2D(this.m_GL.TEXTURE_2D,0,this.m_colFmt,w,h,0,this.m_colFmt,this.type,null);return this;};T.prototype.SetImage=function(d){this.m_W=d.width;this.m_H=d.height;this.m_GL.texImage2D(this.m_GL.TEXTURE_2D,0,this.m_colFmt,this.m_colFmt,this.type,d);return this;};T.prototype.SetFilterNearest=function(){this.m_GL.texParameteri(this.m_GL.TEXTURE_2D,this.m_GL.TEXTURE_MAG_FILTER,this.m_GL.NEAREST);this.m_GL.texParameteri(this.m_GL.TEXTURE_2D,this.m_GL.TEXTURE_MIN_FILTER,this.m_GL.NEAREST);return this;};T.prototype.SetWrapEdge=function(){this.m_GL.texParameteri(this.m_GL.TEXTURE_2D,this.m_GL.TEXTURE_WRAP_S,this.m_GL.CLAMP_TO_EDGE);this.m_GL.texParameteri(this.m_GL.TEXTURE_2D,this.m_GL.TEXTURE_WRAP_T,this.m_GL.CLAMP_TO_EDGE);return this;};return T;})();VBI.Ro=(function(){"use strict";function R(g,w,h){this.m_GL=g;this.m_W=w;this.m_H=h;var e=this.m_GL.getExtensions();var t=null;if(e){t=this.m_GL.FLOAT;}this.m_Tex=new VBI.Tex(this.m_GL,{type:t});this.m_Tex.BindTex(0);this.m_Tex.AdjustSize(w,h);this.m_Tex.SetFilterNearest();this.m_Tex.SetWrapEdge();this.m_FB=new VBI.FB(this.m_GL);this.m_FB.BindFB();if(!this.m_FB.SetTex(this.m_Tex)){this.m_FB.UnBindFB();this.m_Tex=new VBI.Tex(this.m_GL,{type:null});this.m_Tex.BindTex(0);this.m_Tex.AdjustSize(w,h);this.m_Tex.SetFilterNearest();this.m_Tex.SetWrapEdge();this.m_FB=new VBI.FB(this.m_GL);this.m_FB.BindFB();this.m_FB.SetTex(this.m_Tex);this.m_FB.UnBindFB();}else{this.m_FB.UnBindFB();}}R.prototype.Apply=function(){return this.m_FB.BindFB();};R.prototype.BindRo=function(s){return this.m_Tex.BindTex(s);};R.prototype.UnBindRo=function(){this.m_FB.UnBindFB();};R.prototype.AdjustSize=function(w,h){this.m_W=w;this.m_H=h;return this.m_Tex.BindTex(0).AdjustSize(w,h);};return R;})();VBI.Vals=(function(){"use strict";function V(g,w,h){this.m_GL=g;this.m_nPointChunk=10240;this.m_nVertexSize=8;this.m_W=w;this.m_H=h;this.m_Shader=new VBI.Shader(this.m_GL,"uniform vec4 uTM;"+"attribute vec4 aPos;"+"attribute float aValue;"+"varying vec3 vData;"+"void main(){"+"  gl_Position = vec4(aPos.xy * uTM.xy + uTM.zw, 0.0, 1.0);"+"  vData.xy = aPos.zw;"+"  vData.z = aValue;"+"}","#ifdef GL_FRAGMENT_PRECISION_HIGH\n"+"  precision highp int;"+"  precision highp float;\n"+"#else\n"+"  precision mediump int;"+"  precision mediump float;\n"+"#endif\n"+"varying vec3 vData;"+"void main(){"+"  float f = smoothstep(1.0, 0.0, length(vData.xy)) * vData.z;"+"  gl_FragColor = vec4(f);"+"}");this.m_Shader.aPos=this.m_Shader.getShaderVar('aPos');this.m_Shader.aValue=this.m_Shader.getShaderVar('aValue');this.m_Shader.uTM=this.m_Shader.getLoc('uTM');this.m_Ro=new VBI.Ro(this.m_GL,this.m_W,this.m_H);this.m_VB=this.m_GL.createBuffer();this.m_vBuf=new Float32Array(this.m_nPointChunk*this.m_nVertexSize*6);this.m_IB=this.m_GL.createBuffer();var e=new Uint16Array(this.m_nPointChunk*6);for(var i=0,j=0;i<e.length;j+=4){e[i++]=j;e[i++]=j+1;e[i++]=j+2;e[i++]=j+2;e[i++]=j+1;e[i++]=j+3;}this.m_GL.bindBuffer(this.m_GL.ELEMENT_ARRAY_BUFFER,this.m_IB);this.m_GL.bufferData(this.m_GL.ELEMENT_ARRAY_BUFFER,e,this.m_GL.STATIC_DRAW);this.m_nIdx=0;this.m_nPoints=0;}V.prototype.AdjustSize=function(w,h){this.m_W=w;this.m_H=h;this.m_Ro.AdjustSize(this.m_W,this.m_H);return;};V.prototype.Render=function(){if(this.m_nPoints>0){var g=this.m_GL;g.enable(g.BLEND);this.m_Ro.Apply();g.bindBuffer(g.ELEMENT_ARRAY_BUFFER,this.m_IB);g.bindBuffer(g.ARRAY_BUFFER,this.m_VB);g.bufferData(g.ARRAY_BUFFER,this.m_vBuf,g.STREAM_DRAW);this.m_Shader.Apply();g.enableVertexAttribArray(1);g.vertexAttribPointer(this.m_Shader.aPos,4,g.FLOAT,false,20,0);g.vertexAttribPointer(this.m_Shader.aValue,1,g.FLOAT,false,20,16);g.uniform4f(this.m_Shader.uTM,2/this.m_W,2/this.m_H,-1,-1);g.drawElements(g.TRIANGLES,this.m_nPoints*6,g.UNSIGNED_SHORT,0);g.disableVertexAttribArray(1);this.m_Ro.UnBindRo();g.disable(g.BLEND);this.m_nPoints=0;this.m_nIdx=0;}};V.prototype.Clear=function(){this.m_Ro.Apply();this.m_GL.clearColor(0.0,0.0,0.0,0.0);this.m_GL.clear(this.m_GL.COLOR_BUFFER_BIT);return this.m_Ro.UnBindRo();};V.prototype.AddPoint=function(x,y,v,s){if((this.m_nPoints+1)>=this.m_nPointChunk){this.Render();}y=this.m_H-y;this.PushVertex(x-s,y-s,-1,-1,v);this.PushVertex(x+s,y-s,+1,-1,v);this.PushVertex(x-s,y+s,-1,+1,v);this.PushVertex(x+s,y+s,+1,+1,v);this.m_nPoints+=1;return this.m_nPoints;};V.prototype.PushVertex=function(x,y,b,c,v){var a=this.m_vBuf;var d=this.m_nIdx;a[d++]=x;a[d++]=y;a[d++]=b;a[d++]=c;a[d++]=v;this.m_nIdx=d;};return V;})();VBI.Hm=(function(){"use strict";function H(a){var c;var b;var s=a.scene;if(typeof(a.alphaBounds=='undefined')){a.alphaBounds=[0.0,1.0];}if(typeof(a.alpha=='undefined')){a.alpha=true;}this.m_Canv=a.canvas;this.m_W=a.width;this.m_H=a.height;this.m_aFunc=a.aFunc.toFixed(8);this.m_cFunc=a.cFunc.toFixed(8);if(!this.m_Canv){this.m_Canv=document.createElement("canvas");}var A={depth:false,antialias:false,alpha:true};if(!this.m_GL){this.m_GL=this.m_Canv.getContext("experimental-webgl",A);}if(!this.m_GL){this.m_GL=this.m_Canv.getContext("webgl",A);}if(!this.m_GL){jQuery.sap.log.error("WebGL not supported");return;}this.m_GL.blendFunc(this.m_GL.ONE,this.m_GL.ONE);this.m_GL.enableVertexAttribArray(0);if(a.colorTexture){this.m_ColorTexture=new VBI.Tex(this.m_GL,{colfmt:"rgba"});this.m_ColorTexture.BindTex(0);this.m_ColorTexture.SetFilterNearest();this.m_ColorTexture.SetWrapEdge();this.m_ColorTexture.AdjustSize(2,2);this.m_ColorTexture.BindTex(0);this.m_ColorTexture.SetImage(a.colorTex);if(!a.colorTex.IsLoaded){s.RenderAsync(false);}b="uniform sampler2D colTex; "+"vec3 calcCol( float g ){ "+"  return texture2D( colTex, vec2( g, 0.5 )).rgb; "+"}";}else{b="vec3 calcCol( float g ){ "+"  return smoothstep( vec3( 0.0, 0.0, 1.0 ), vec3( 1.0, 1.0, 0.0 ), vec3( g ) ); "+"}";}if(a.alpha){c="vec4 calcAlpha(vec3 c,float i){ "+"  float a = smoothstep("+(a.alphaBounds[0].toFixed(8))+","+(a.alphaBounds[1].toFixed(8))+", pow(i, 1.0)); "+"  return vec4( c*a, a); "+"}";}else{c="vec4 calcAlpha(vec3 c, float i){ "+"  return vec4(c, 1.0);"+"}";}var f="#ifdef GL_FRAGMENT_PRECISION_HIGH \n"+"  precision highp int;"+"  precision highp float; \n"+"#else \n"+"  precision mediump int;"+"  precision mediump float; \n"+"#endif \n"+"uniform sampler2D src;"+"varying vec2 txy;";var d="void main(){ "+"  float f = clamp( texture2D(src, txy).r, 0.0, 1.0 ); "+"  vec3 color = calcCol(pow(f, "+(this.m_cFunc)+")); "+"  gl_FragColor = calcAlpha(color, pow(f, "+(this.m_aFunc)+")); "+"}";this.m_Shader=new VBI.Shader(this.m_GL,"attribute vec4 pos; "+"varying vec2 txy; "+"void main(){ "+"  txy = pos.xy * 0.5 + 0.5; "+"  gl_Position = pos; "+"}",f+b+"\n"+c+d);if(this.m_W==null){this.m_W=this.m_Canv.offsetWidth||2;}if(this.m_H==null){this.m_H=this.m_Canv.offsetHeight||2;}this.m_Canv.width=this.m_W;this.m_Canv.height=this.m_H;var g=new Float32Array([-1,-1,0,1,1,-1,0,1,-1,1,0,1,1,1,0,1]);this.m_Geo=this.m_GL.createBuffer();this.m_GL.viewport(0,0,this.m_W,this.m_H);this.m_GL.bindBuffer(this.m_GL.ARRAY_BUFFER,this.m_Geo);this.m_GL.bufferData(this.m_GL.ARRAY_BUFFER,g,this.m_GL.STATIC_DRAW);this.m_GL.bindBuffer(this.m_GL.ARRAY_BUFFER,null);this.m_V=new VBI.Vals(this.m_GL,this.m_W,this.m_H);}H.prototype.AdjustSize=function(){if(!this.m_GL){return;}var c=this.m_Canv.offsetHeight||2;var a=this.m_Canv.offsetWidth||2;if(this.m_W!==a||this.m_H!==c){this.m_GL.viewport(0,0,a,c);this.m_Canv.width=a;this.m_Canv.height=c;this.m_W=a;this.m_H=c;this.m_V.AdjustSize(this.m_W,this.m_H);}};H.prototype.RenderColors=function(){if(!this.m_GL){return;}this.m_GL.bindBuffer(this.m_GL.ARRAY_BUFFER,this.m_Geo);this.m_GL.vertexAttribPointer(0,4,this.m_GL.FLOAT,false,0,0);this.m_V.m_Ro.BindRo(0);if(this.m_ColorTexture){this.m_ColorTexture.BindTex(1);}this.m_Shader.Apply();this.m_Shader.SetInt("src",0);this.m_Shader.SetInt("colTex",1);this.m_GL.drawArrays(this.m_GL.TRIANGLE_STRIP,0,4);return;};H.prototype.RenderValues=function(){if(!this.m_GL){return;}if(this.m_V){this.m_V.Render();}};H.prototype.Render=function(){this.RenderValues();this.RenderColors();};H.prototype.Clear=function(){return this.m_V?this.m_V.Clear():null;};H.prototype.AddPoint=function(x,y,v,s){return this.m_V?this.m_V.AddPoint(x,y,v,s):null;};return H;})();
VBI.CreateHM=function(p){"use strict";return new VBI.Hm(p);};
},
	"sap/ui/vbm/lib/saplabels.js":function(){
VBI.addSceneLabelFunctions=function(s){"use strict";s.InternalDrawLabelTexts=function(d,l,t,a){for(var n=0;n<l.m_Pos.length;++n){for(var b=0;b<l.m_Pos[n].length;b++){var h=Math.round(l.m_Height);var w=Math.round(l.m_Width);var c=Math.round(l.m_Pos[n][b][0]);var e=Math.round(l.m_Pos[n][b][1]);var f=l.m_Arrow?l.m_Align:0;var r=l.m_Rounded?h/2:10;var g;d.beginPath();d.lineWidth=2;d.moveTo(c+r,e);if(f==5){l.m_Pos[n][b].tri=[[c+w/2-3,e],[c+w/2,e-5],[c+w/2+3,e]];for(g=0;g<3;++g){d.lineTo(l.m_Pos[n][b].tri[g][0],l.m_Pos[n][b].tri[g][1]);}}d.lineTo(c+w-r,e);d.arcTo(c+w,e,c+w,e+r,r);if(f==7&&!l.m_Rounded){l.m_Pos[n][b].tri=[[c+w,e+h/2-3],[c+w+5,e+h/2],[c+w,e+h/2+3]];for(g=0;g<3;++g){d.lineTo(l.m_Pos[n][b].tri[g][0],l.m_Pos[n][b].tri[g][1]);}}d.lineTo(c+w,e+h-r);d.arcTo(c+w,e+h,c+w-r,e+h,r);if(f==1){l.m_Pos[n][b].tri=[[c+w/2+3,e+h],[c+w/2,e+h+5],[c+w/2-3,e+h]];for(g=0;g<3;++g){d.lineTo(l.m_Pos[n][b].tri[g][0],l.m_Pos[n][b].tri[g][1]);}}d.lineTo(c+r,e+h);d.arcTo(c,e+h,c,e+h-r,r);if(f==3&&!l.m_Rounded){l.m_Pos[n][b].tri=[[c,e+h/2+3],[c-5,e+h/2],[c,e+h/2-3]];for(g=0;g<3;++g){d.lineTo(l.m_Pos[n][b].tri[g][0],l.m_Pos[n][b].tri[g][1]);}}d.lineTo(c,e+r);d.arcTo(c,e,c+r,e,r);d.fillStyle=l.m_BgColor;d.fill();if(l.m_BrdrCol){d.strokeStyle=l.m_BrdrCol;}else{d.strokeStyle=l.m_BgColor;}d.stroke();var i=t.length==1?VBI.Utilities.RemToPixel(0.75):VBI.Utilities.RemToPixel(0.75)+1;var j=0;for(var k=0;k<t.length;++k){d.fillStyle=t[k];var m=0;for(g=0;g<a.length;g++){m=l.m_Padding[1]+i*g;d.fillText(a[g],c+l.m_Padding[0]+j,e+m+j+7);}j++;}if(l.m_Icon){l.m_IcInfo=sap.ui.core.IconPool.getIconInfo(l.m_Icon);if(l.m_IcInfo){var o=(l.m_Align==7&&l.m_Arrow)?c:c+w;d.fillStyle=l.m_IcBgrdCol;d.fillRect(o-7,e+h-7,14,14);l.m_Pos[n][b].rc=[o-7,e+h-7,o-7+14,e+h-7+14];}}}}};s.InternalDrawLabels=function(d,l,t,a){for(var n=0;n<l.m_Pos.length;++n){for(var b=0;b<l.m_Pos[n].length;b++){VBI.Utilities.SetTextAttributes(d,VBI.Utilities.RemToPixel(0.75)+"px 'Lucida Sans Unicode',sans-serif",undefined,undefined,"start","middle");var h=Math.round(l.m_Height);var w=Math.round(l.m_Width);var c=Math.round(l.m_Pos[n][b][0]);var e=Math.round(l.m_Pos[n][b][1]);var f=l.m_Arrow?l.m_Align:0;var r=l.m_Rounded?h/2:6;var g;d.beginPath();d.lineWidth=2;d.moveTo(c+r,e);if(f==5){l.m_Pos[n][b].tri=[[c+w/2-3,e],[c+w/2,e-5],[c+w/2+3,e]];for(g=0;g<3;++g){d.lineTo(l.m_Pos[n][b].tri[g][0],l.m_Pos[n][b].tri[g][1]);}}d.lineTo(c+w-r,e);d.arcTo(c+w,e,c+w,e+r,r);if(f==7&&!l.m_Rounded){l.m_Pos[n][b].tri=[[c+w,e+h/2-3],[c+w+5,e+h/2],[c+w,e+h/2+3]];for(g=0;g<3;++g){d.lineTo(l.m_Pos[n][b].tri[g][0],l.m_Pos[n][b].tri[g][1]);}}d.lineTo(c+w,e+h-r);d.arcTo(c+w,e+h,c+w-r,e+h,r);if(f==1){l.m_Pos[n][b].tri=[[c+w/2+3,e+h],[c+w/2,e+h+5],[c+w/2-3,e+h]];for(g=0;g<3;++g){d.lineTo(l.m_Pos[n][b].tri[g][0],l.m_Pos[n][b].tri[g][1]);}}d.lineTo(c+r,e+h);d.arcTo(c,e+h,c,e+h-r,r);if(f==3&&!l.m_Rounded){l.m_Pos[n][b].tri=[[c,e+h/2+3],[c-5,e+h/2],[c,e+h/2-3]];for(g=0;g<3;++g){d.lineTo(l.m_Pos[n][b].tri[g][0],l.m_Pos[n][b].tri[g][1]);}}d.lineTo(c,e+r);d.arcTo(c,e,c+r,e,r);d.fillStyle=l.m_BgColor;d.fill();d.strokeStyle=(l.m_BrdrCol?l.m_BrdrCol:l.m_BgColor);d.stroke();var i=t.length==1?VBI.Utilities.RemToPixel(0.75):VBI.Utilities.RemToPixel(0.75)+1;var j=0;for(var k=0;k<t.length;++k){d.fillStyle=t[k];var m=0;for(g=0;g<a.length;g++){m=l.m_Padding[1]+i*g;d.fillText(a[g],(VBI.m_bIsRtl)?(c+w-l.m_Padding[0]+j):(c+l.m_Padding[0]+j),e+m+j+7);}j++;}if(l.m_Icon){l.m_IcInfo=sap.ui.core.IconPool.getIconInfo(l.m_Icon);if(l.m_IcInfo){var o=(l.m_Align==7&&l.m_Arrow)?c:c+w;d.fillStyle=l.m_IcBgrdCol;d.fillRect(o-7,e+h-7,14,14);l.m_Pos[n][b].rc=[o-7,e+h-7,o-7+14,e+h-7+14];VBI.Utilities.SetTextAttributes(d,"12px SAP-icons",undefined,undefined,"center","middle");d.fillStyle=l.GetLabelIconColor();d.fillText(l.m_IcInfo.content,o,e+h);}}}}};s.InternalDrawLabelIcons=function(d,l){var h=Math.round(l.m_Height);var w=Math.round(l.m_Width);for(var n=0;n<l.m_Pos.length;++n){for(var a=0;a<l.m_Pos[n].length;a++){var b=Math.round(l.m_Pos[n][a][0]);var c=Math.round(l.m_Pos[n][a][1]);if(l.m_Icon&&l.m_IcInfo){d.fillStyle=l.GetLabelIconColor();var i=(l.m_Align==7&&l.m_Arrow)?b:b+w;d.fillText(l.m_IcInfo.content,i,c+h);}}}};s.InternalRenderLabels=function(c,d){var v=s.m_VOS;for(var n=0,l=v.length;n<l;++n){var L=v[n].getLabelData(true);for(var a=0;a<L.length;++a){var b=L[a];VBI.Utilities.SetTextAttributes(d,VBI.Utilities.RemToPixel(0.75)+"px 'Lucida Sans Unicode',sans-serif",undefined,undefined,"start","middle");b.SetDimensions(d);b.AlignLabel();var t=b.GetLabelTextColor();var e=b.m_Text.split(/\r\n/);var f=s.GetViewport();for(var i=0;i<b.m_Pos.length;i++){for(var j=0;j<b.m_Pos[i].length;j++){var g=b.m_PosArray.pa,h=b.m_Pos[i][j];if(g.length!==3||g[0]>f[0]&&g[0]<f[2]){if(h[0]-f[0]<5){h[0]=f[0]+5;}else if(h[0]+b.m_Width>f[2]-5){h[0]=f[2]-b.m_Width-5;}if(h[1]-f[1]<5){h[1]=f[1]+5;}else if(h[1]+b.m_Height>f[3]-5){h[1]=f[3]-b.m_Height-5;}}else{if(h[0]+(b.m_aIO[1]||0)-f[0]<5){h[0]=f[0]+5;}else if(h[0]+(b.m_aIO[1]||0)+b.m_Width>f[2]-5){h[0]=f[2]-b.m_Width-5;}else{h[0]+=b.m_aIO[1]||0;}if(h[1]-f[1]<5){h[1]=f[1]+5;}else if(h[1]+b.m_Height>f[3]-5){h[1]=f[3]-b.m_Height-5;}}}}s.InternalDrawLabels(d,b,t,e);}}};};
VBI.Label=function(l,n,r,p,a,i){"use strict";this.m_bAligned=false;this.mIndex=n;this.m_aIO=i;this.m_rcBox=a;this.m_Text=l.text;this.m_BgColor=l.bgColor;this.m_BrdrCol=l.brdrCol;this.m_Icon=l.icon;this.m_IcBgrdCol=l.icColor;this.m_IcTextCol=l.icTextColor;this.m_Arrow=l.arrow;this.m_Rounded=l.rounded;this.m_Align=l.Align;this.m_Offset=l.offset;this.m_Padding=[7,5];this.m_ArrowHeight=5;this.m_ArrowWidth=3;this.m_LineWidth=2;this.m_LabelIconColor=null;this.m_PosArray=p;this.m_Pos=[];this.m_Width=0;this.m_Height=0;this.m_LabelTextColor=[];if(!r){var b=Math.floor(this.m_PosArray.pa.length/3)*3;for(var c=0;c<i.length;c++){var t=[];for(var d=0;d<b;d+=3){var e=[this.m_PosArray.pa[d]+i[c],this.m_PosArray.pa[d+1]];t.push(e);}this.m_Pos.push(t);}}this.CalculateLabelPos=r;this.getContrastCol=function(f){var g=(299*250+587*250+114*250)/1000.0;var h=(299*f[0]+587*f[1]+114*f[2])/1000.0;return(Math.abs(h-g)<=125.0?"#000000":"#FAFAFA");};this.GetLabelTextColor=function(){if(!this.m_LabelTextColor.length){var f=VBI.Types.string2rgba(this.m_BgColor);if(f[3]==0&&f[4]==1){this.m_LabelTextColor[0]="#FFFFFF";this.m_LabelTextColor[1]="#000000";}else{this.m_LabelTextColor[0]=this.getContrastCol(f);}}return this.m_LabelTextColor;};this.GetLabelIconColor=function(){if(!this.m_LabelIconColor){if(this.m_IcTextCol){this.m_LabelIconColor=this.m_IcTextCol;}else{var f=VBI.Types.string2rgba(this.m_IcBgrdCol);this.m_LabelIconColor=((f[3]==0&&f[4]==1)?"#000000":this.getContrastCol(f));}}return this.m_LabelIconColor;};this.SetDimensions=function(f){if(!this.m_Width||!this.m_Height){var s=this.m_Text.split(/\r\n/);var g=0;var h=0;var j=VBI.Utilities.RemToPixel(0.75);for(var k=0;k<s.length;k++){var m=s[k].length;if(m>g){g=m;h=k;}}this.m_Width=f.measureText(s[h]).width+this.m_Padding[0]*2;this.m_Height=j*s.length+this.m_Padding[1]*2;}};this.AlignLabel=function(){if(!this.m_bAligned){var f=[0,0,0,0];var e;var g=this.m_ArrowHeight+this.m_LineWidth;if(this.m_rcBox){f=this.m_rcBox;}for(var d=0;d<this.m_Pos.length;d++){for(var h=0;h<this.m_Pos[d].length;h++){e=(this.m_rcBox?[this.m_rcBox[0]+(this.m_rcBox[2]-this.m_rcBox[0])/2,this.m_rcBox[1]+(this.m_rcBox[3]-this.m_rcBox[1])/2]:this.m_Pos[d][h]);switch(this.m_Align){case 0:e[0]-=this.m_Width/2;e[1]-=this.m_Height/2;break;case 1:e[0]-=this.m_Width/2;e[1]-=(f[3]-f[1])/2+this.m_Height;if(this.m_Arrow){e[1]-=g;}break;case 2:e[0]+=(f[2]-f[0])/2;e[1]-=(f[3]-f[1])/2+this.m_Height;break;case 3:e[0]+=(f[2]-f[0])/2;e[1]-=this.m_Height/2;if(this.m_Arrow&&!this.m_Rounded){e[0]+=g;}break;case 4:e[0]+=(f[2]-f[0])/2;e[1]+=(f[3]-f[1])/2;break;case 5:e[0]-=(this.m_Width/2);e[1]+=(f[3]-f[1])/2;if(this.m_Arrow){e[1]+=g;}break;case 6:e[0]-=(f[2]-f[0])/2+this.m_Width;e[1]+=(f[3]-f[1])/2;break;case 7:e[0]-=(f[2]-f[0])/2+this.m_Width;e[1]-=this.m_Height/2;if(this.m_Arrow&&!this.m_Rounded){e[0]-=g;}break;case 8:e[0]-=(f[2]-f[0])/2+this.m_Width;e[1]-=(f[3]-f[1])/2+this.m_Height;break;default:if(VBI.m_bIsRtl){e[0]-=this.m_Width;}e[1]+=(f[3]-f[1])/2;break;}if(!this.CalculateLabelPos){e[0]+=this.m_aIO[d];}e[0]+=this.m_Offset[0];e[1]+=this.m_Offset[1];this.m_Pos[d][h]=e;}}}this.m_bAligned=true;};this.clear=function(){this.CalculateLabelPos=null;this.m_Pos=null;this.m_PosArray=null;this.m_rcBox=null;this.m_aIO=null;this.m_LabelTextColor=null;this.m_LabelIconColor=null;};return this;};
},
	"sap/ui/vbm/lib/saplassotrack.js":function(){
VBI.addSceneLassoTrackingFunctions=function(s){"use strict";s.LassoTracking=function(){this.m_PosMoves=[];this.m_bTrack=false;this.m_keycode=0;};s.LassoTracking.prototype.onsapkeydown=function(e){if(e.keyCode==this.m_keycode){this.ExitMode();e.preventDefault();return true;}};s.LassoTracking.prototype.onsapdown=function(e){var r=s.m_Canvas[s.m_nOverlayIndex].getBoundingClientRect();var z=s.GetStretchFactor4Mode();this.m_PosMoves.push([(e.clientX-r.left)/z[0],(e.clientY-r.top)/z[1]]);this.m_bTrack=true;if(e.type=="mousedown"){document.addEventListener('mouseup',this,true);}else if(e.type=="touchstart"){document.addEventListener('touchend',this,true);}else if(e.type=="pointerdown"){document.addEventListener('pointerup',this,true);}e.preventDefault();s.m_Canvas[s.m_nLabelIndex].focus({preventScroll:true});return true;};s.LassoTracking.prototype.handleEvent=function(e){if(e.type=="mouseup"){document.removeEventListener('mouseup',this,true);}else if(e.type=="touchend"){document.removeEventListener('touchend',this,true);}else if(e.type=="pointerup"){document.removeEventListener('pointerup',this,true);if(s.m_Gesture){s.m_Gesture.pointerCount--;if(!s.m_Gesture.pointerCount){s.m_Gesture.target=null;s.m_Gesture=null;}}}this.TrackEnd(e);};s.LassoTracking.prototype.TrackEnd=function(e){if(!this.m_bTrack){return false;}if(this.m_PosMoves.length>2){this.execute(e);}this.m_PosMoves=[];this.m_bTrack=false;s.RenderAsync(true);e.preventDefault();e.stopPropagation();return true;};s.LassoTracking.prototype.onsapmove=function(e){if(this.m_bTrack){var z=s.GetStretchFactor4Mode();var r=s.m_Canvas[s.m_nOverlayIndex].getBoundingClientRect();this.m_PosMoves.push([(e.clientX-r.left)/z[0],(e.clientY-r.top)/z[1]]);}s.SetCursor('crosshair');s.RenderAsync(true);e.preventDefault();return true;};s.LassoTracking.prototype.onsapout=function(e){};s.LassoTracking.prototype.execute=function(e){};s.LassoTracking.prototype.Hook=function(){s.SetInputMode(VBI.InputModeLassoSelect);s.m_Ctx.m_Control.setLassoSelection(true);s.m_DesignVO=this;s.SetCursor('crosshair');s.RenderAsync(true);};s.LassoTracking.prototype.UnHook=function(){if(s.m_nInputMode==VBI.InputModeLassoSelect){s.m_Ctx.onChangeTrackingMode(s.m_nInputMode,false);s.SetInputMode(VBI.InputModeDefault);s.m_Ctx.m_Control.setLassoSelection(false);}else{jQuery.sap.log.error("Wrong InputMode in UnHook: "+s.m_nInputMode);}this.m_PosMoves=[];this.m_bTrack=false;s.m_DesignVO=null;s.RenderAsync(true);};s.LassoTracking.prototype.ExitMode=function(){this.UnHook();s.SetCursor('default');s.RenderAsync(true);};s.LassoSelection=function(){s.LassoTracking.call(this);this.m_keycode=65;this.Hook();};s.LassoSelection.prototype=Object.create(s.LassoTracking.prototype);s.LassoSelection.prototype.constructor=s.LassoSelection;s.LassoSelection.prototype.execute=function(e){s.PerFormMultiSelect(e,this);};s.LassoSelection.prototype.Render=function(c,d){if(!this.m_bTrack){return false;}if(this.m_PosMoves.length){VBI.Utilities.DrawTrackingLasso(d,this.m_PosMoves);}};};
},
	"sap/ui/vbm/lib/sapmaplayer.js":function(){
VBI.MapLayerStackManager=function(){"use strict";var m={};m.vbiclass="MapLayerStackManager";m.m_MapLayerStackArray=[];m.clear=function(){for(var n=0;n<m.m_MapLayerStackArray.length;++n){m.m_MapLayerStackArray[n].clear();}m.m_MapLayerStackArray=[];};m.load=function(d,c){if(d.Set){m.clear();var a;if(jQuery.type(d.Set.MapLayerStack)=='object'){a=new VBI.MapLayerStack();a.load(d.Set.MapLayerStack,c);m.Add(a);}else if(jQuery.type(d.Set.MapLayerStack)=='array'){for(var n=0;n<d.Set.MapLayerStack.length;++n){a=new VBI.MapLayerStack();a.load(d.Set.MapLayerStack[n],c);m.Add(a);}}}};m.Add=function(a){this.m_MapLayerStackArray.push(a);};m.GetMapLayerStack=function(n){for(var i=0;i<this.m_MapLayerStackArray.length;++i){if(this.m_MapLayerStackArray[i].m_Name==n){return this.m_MapLayerStackArray[i];}}return null;};return m;};
VBI.MapLayerStacks=VBI.MapLayerStackManager();
VBI.MapLayerStack=function(n,d){"use strict";var m={};m.vbiclass="MapLayerStack";m.m_MapLayerArray=[];m.m_Name=n;m.m_Description=d;m.m_nMaxSquare=0;m.m_colBkgnd=null;m.clear=function(){for(var a=0;a<m.m_MapLayerArray.length;++a){m.m_MapLayerArray[a].clear();}m.m_MapLayerArray=[];};m.load=function(a,c){if(a.name){m.m_Name=a.name;}if(a.description){m.m_Description=a.description;}if(a.copyright){m.m_Copyright=a.copyright;}if(a.copyrightLink){m.m_CopyrightLink=a.copyrightLink;}if(a.copyrightImage){m.m_CopyrightImage=a.copyrightImage;}if(a.maxSquare){m.m_nMaxSquare=a.maxSquare;}if(a.previewPosition){m.m_PreviewPosition=a.previewPosition;}if(a.colBkgnd){m.m_colBkgnd=a.colBkgnd;}m.m_bSingleBMP=(a.singleBMP&&a.singleBMP=="true");var b;if(a.MapLayer){if(jQuery.type(a.MapLayer)=='object'){b=new VBI.MapLayer();b.load(a.MapLayer,c);m.Add(b);}else if(jQuery.type(a.MapLayer)=='array'){for(var e=0;e<a.MapLayer.length;++e){b=new VBI.MapLayer();b.load(a.MapLayer[e],c);m.Add(b);}}}};m.Add=function(a){this.m_MapLayerArray.push(a);};m.GetMaxLOD=function(){var a,b=0;var c=this.m_MapLayerArray;for(var i=0;i<c.length;++i){a=parseInt(c[i].GetMaxLOD(),10);if(a>b){b=a;}}return b;};m.GetMinLOD=function(){var a,b=Number.MAX_VALUE;var c=this.m_MapLayerArray;for(var i=0;i<c.length;++i){a=c[i].GetMinLOD();if(a<b){b=a;}}return b;};m.GetCopyright=function(){if(this.m_Copyright){return VBI.Utilities.AssembleCopyrightString(this.m_Copyright,this.m_CopyrightLink,this.m_CopyrightImage);}var c=null;for(var a=0;a<this.m_MapLayerArray.length;a++){var b=this.m_MapLayerArray[a].GetMapProvider();if(!c){c=b.GetCopyright();}else{c=c+", "+b.GetCopyright();}}return c;};return m;};
VBI.MapLayer=function(){"use strict";var m={};m.vbiclass="MapLayer";m.m_Name=null;m.m_refMapProvider=null;m.m_fOpacity=1.0;m.clear=function(){m.m_refMapProvider=null;};m.load=function(d,c){if(d.name){m.m_Name=d.name;}if(d.opacity){m.m_fOpacity=d.opacity;}if(d.refMapProvider){if(c.m_MapProviders){m.m_refMapProvider=c.m_MapProviders.GetMapProviderByName(d.refMapProvider);}}if(!m.m_refMapProvider){jQuery.sap.log.error("MapLayer: no valid mapprovider specified");}};m.GetMinLOD=function(){if(m.m_refMapProvider){return m.m_refMapProvider.GetMinLOD();}};m.GetMaxLOD=function(){if(m.m_refMapProvider){return m.m_refMapProvider.GetMaxLOD();}};m.GetMapProvider=function(){if(m.m_refMapProvider){return m.m_refMapProvider;}return null;};return m;};
},
	"sap/ui/vbm/lib/sapmapmanager.js":function(){VBI.MapManager=(function(){"use strict";var m={};m.vbiclass="MapManager";m.m_nRequest=0;m.m_tileWidth=256;m.m_tileHeight=256;m.m_runningRequests=0;m.m_limitRequests=12;m.m_requestQueue=[];m.m_renderQueue=[];m.m_renderRequestID=0;m.m_failedSendTimer=0;m.m_renderJunksize=100;m.onAbort=function(e){var i=e.srcElement;if(VBI.m_bTrace){VBI.Trace("onAbort "+i.src);}m.CheckReqQueue();m.UnlinkImage(i);m.CheckTmpCanvas(i.m_Target,i.m_nRequest,i.m_nLayersAbove);};m.onFailedSend=function(o){if(VBI.m_bTrace){VBI.Trace("onFailedSend "+o.src);}m.m_runningRequests--;m.m_bRequestError=true;if(!m.m_failedSendTimer){m.m_failedSendTimer=setInterval(function(){m.RetrySending();},750);}};m.onError=function(e){var i=e.srcElement;if(VBI.m_bTrace){VBI.Trace("onError "+i.src);}m.CheckReqQueue();var a=null;if(i.m_Next!=null){i.m_Next.m_FillStyle=i.m_FillStyle;}if(i.m_Prev==null&&i.m_Next!=null&&i.m_Next.complete==true){a=i.m_Next;}m.UnlinkImage(i);if(a!=null){m.m_renderQueue.push(a);if(!m.m_renderRequestID){m.m_renderRequestID=window.requestAnimationFrame(m.RenderTiles);}}else{m.CheckTmpCanvas(i.m_Target,i.m_nRequest,i.m_nLayersAbove);}};m.onLoad=function(e){var i=e.target;if(!i.complete){return;}if(VBI.m_bTrace){VBI.Trace("VBI.MapManager: onLoad  "+i.src);}m.CheckReqQueue();var c=true;var a;for(a=i.m_Prev;a!=null;a=a.m_Prev){c&=a.complete;}for(a=i.m_Next;a!=null;a=a.m_Next){c&=a.complete;}if(!c){if(VBI.m_bTrace){VBI.Trace("VBI.MapManager: onLoad skip as there is a a not yet loaded tile ");}return;}m.m_renderQueue.push(i);if(!m.m_renderRequestID){m.m_renderRequestID=window.requestAnimationFrame(m.RenderTiles);}};m.RetrySending=function(){clearInterval(m.m_failedSendTimer);m.m_failedSendTimer=0;m.m_bRequestError=false;m.m_runningRequests++;m.CheckReqQueue();};m.CheckReqQueue=function(){while((m.m_requestQueue.length)&&(!m.m_bRequestError)){var i=m.m_requestQueue.shift();var t=i.m_Target;if(i.m_nLOD!=t.m_nCurrentLOD||t.m_bInvalid){m.UnlinkImage(i);m.CheckTmpCanvas(t,i.m_nRequest,i.m_nLayersAbove);}else{try{i.src=i.src2execute;}catch(e){m.m_requestQueue.unshift(i);m.onFailedSend(i);}return;}}m.m_runningRequests--;};m.RenderTiles=function(){var n=Math.min(m.m_renderQueue.length,m.m_renderJunksize);for(var i=0;i<n;++i){m.RenderTile(m.m_renderQueue.shift());}m.m_renderRequestID=m.m_renderQueue.length>0?window.requestAnimationFrame(m.RenderTiles):0;};m.RenderTile=function(i){if(!i.bRendered){var t=i.m_Target;if((t.m_CanvasRedirect!=undefined)&&(t.m_CanvasRedirRequest==i.m_nRequest)){t=t.m_CanvasRedirect;}var c=t.m_Scene;if(!c){return;}var a=t.getPixelWidth();var b=t.getPixelHeight();t.m_nAppliedRequest=Math.max(t.m_nAppliedRequest,i.m_nRequest);var d=t.getContext('2d');var n=(1<<d.canvas.m_nCurrentLOD);var e=((i.m_nReqX-d.canvas.m_nCurrentX)%n+n)%n;if(n<c.m_nTilesX){e=i.m_nCol+i.m_nXOrigin-d.canvas.m_nCurrentX;}var f=i.m_nReqY-d.canvas.m_nCurrentY;if(i.m_bOutdated||(e<0)||(f<0)||(e>=i.m_numCol)||(f>=i.m_numRow)||(i.m_nLOD!=t.m_nCurrentLOD||t.m_bInvalid)){m.UnlinkImage(i);if(VBI.m_bTrace){VBI.Trace("VBI.MapManager: RenderTile  "+i.src+" is outdated");}m.CheckTmpCanvas(t,i.m_nRequest,i.m_nLayersAbove);return;}if(VBI.m_bTrace){VBI.Trace("VBI.MapManager: RenderTile  "+i.src);}var g=c.m_nWidthCanvas;var h=c.m_nHeightCanvas;t.setPixelWidth(g);t.setPixelHeight(h);var j=g/c.m_nTilesX;var k=h/c.m_nTilesY;var l=e*j;var o=f*k;var p=i.m_nXExpansion*j;var q=i.m_nYExpansion*k;var r=i;var s;while(r.m_Prev!=null){r=r.m_Prev;}while(r!=null&&r.complete==true){if(r.m_FillStyle!=null){if(VBI.m_bTrace){VBI.Trace("RenderTile fillRect "+r.src);}s=d.fillStyle;d.fillStyle=r.m_FillStyle;d.fillRect(l,o,p,q);d.fillStyle=s;}if(VBI.m_bTrace){VBI.Trace("RenderTile drawImage "+r.src);}d.globalAlpha=r.m_Opacity;d.drawImage(r,l,o,p,q);r.bRendered=true;if(r.m_Next!=null){r.m_Next.m_Prev=null;}r=r.m_Next;}if(VBI.m_bTrace){s=d.fillStyle;d.fillStyle="#FF0000";d.font="18px Arial";d.fillText(i.m_nRequest+"."+i.m_nCount+":"+i.m_nLOD+"/"+i.m_nReqX+"/"+i.m_nReqY+"@("+(l/256)+","+(o/256)+")",l+10,o+30);d.fillStyle=s;}t.setPixelWidth(a);t.setPixelHeight(b);if(t.onTileLoaded){t.onTileLoaded(i);}d.globalAlpha=1.0;m.CheckTmpCanvas(t,i.m_nRequest,0);if(c.m_Ctx.moThumbnail){c.Copy2Thumbnail();}}};m.CheckTmpCanvas=function(t,i,n){if((t.m_nTilesBefSwitch!=undefined)&&(t.m_nRequest==i)&&!n){t.m_nTilesBefSwitch--;if(!t.m_nTilesBefSwitch){t.m_Scene.SwitchTmpCanvasToActive();}}};m.RequestTiles=function(t,a,x,y,n,b,l,c,r,d,f,g){m.m_bRequestError=false;if(f<0){return false;}var h=t.m_Scene;if(!a||((h.AnimZoomTarget)&&(Math.abs(h.AnimZoomTarget-f)>h.m_nMaxAnimLodDiff))){t.m_nCurrentX=x;t.m_nCurrentY=y;t.m_nCurrentLOD=f;return false;}var j=0;var o=(1<<f);var p=h.m_Proj.m_nXYRatio;var q=o*p;var T=2.0/o;if(g){var u=t.getContext("2d");u.fillStyle='white';u.clearRect(0,0,u.canvas.width,u.canvas.height);}var v=a.m_MapLayerArray;t.m_nRequest=m.m_nRequest++;t.m_bInvalid=false;t.m_nCurrentX=x;t.m_nCurrentY=y;t.m_nCurrentLOD=f;var w,z,A,B=1;var C=y;if(a.m_bSingleBMP){z=1;C=Math.max(0,y);A=Math.min(b-c-d,o-C);}else{z=b-c-d;A=1;}var D=v.length;w=n-l-r;for(var i=0;i<w;++i){B--;if(!B){for(var k=0;k<z;++k){j++;var E=null;var F=null;var G=(x+l+i)%q;if(G<0){G=q+G;}var H=C+c+k;if((H+A)<=0||H>=o){if((t.m_nTilesBefSwitch!=undefined)&&(t.m_nTilesBefSwitch>0)){t.m_nTilesBefSwitch--;}continue;}B=a.m_bSingleBMP?Math.min(q-G,w-i):1;for(var s=0;s<D;++s){var I=v[s];if(a.fillStyle){F=a.fillStyle;}else if(a.m_colBkgnd){F=a.m_colBkgnd;}if((I.GetMinLOD()>f)||(I.GetMaxLOD()<f)){continue;}var J=new Image();J.m_nLayersAbove=D-s-1;J.m_nXOrigin=x;J.m_nYOrigin=y;J.m_nCol=i+l;J.m_nRow=k+c;J.m_numCol=n;J.m_numRow=b;J.m_Target=t;J.m_nRequest=t.m_nRequest;J.m_Opacity=I.m_fOpacity;J.m_bOutdated=false;J.m_Prev=E;if(E!=null){E.m_Next=J;}if(J.m_Prev==null){J.m_FillStyle=F;}J.m_nReqX=G;J.m_nReqY=H;J.m_nXExpansion=B;J.m_nYExpansion=A;J.m_nLOD=f;var K=I.GetMapProvider();var L;if(K.m_bPosRequired){var M=[G*T/p-1,H*T-1];var N=[(G+B)*T/p-1,(H+A)*T-1];L=K.CombineUrlWPos(G,H,f,T,M,N,B,A,m.m_requestTileWidth,m.m_requestTileHeight);}else{L=K.CombineUrl(G,H,f);}J.onload=m.onLoad;J.onerror=m.onError;J.onabort=m.onAbort;if((m.m_runningRequests<m.m_limitRequests)&&(!m.m_bRequestError)){m.m_runningRequests++;try{J.src=L;}catch(e){J.src2execute=L;m.m_requestQueue.push(J);m.onFailedSend(J);}}else{J.src2execute=L;m.m_requestQueue.push(J);}J.m_nCount=j;if(VBI.m_bTrace){VBI.Trace("RequestTiles "+L);}E=J;}}}}return true;};m.UnlinkImage=function(i){var a;for(a=i.m_Prev;a;a=a.m_Prev){a.m_bOutdated=true;}for(a=i.m_Next;a;a=a.m_Next){a.m_bOutdated=true;}var c=i.m_Prev;var b=i.m_Next;if(c!=null){i.m_Prev.m_Next=b;i.m_Prev=null;}if(b!=null){i.m_Next.m_Prev=c;i.m_Next=null;}};m.GetPreviewImage=function(l,a,b,c,s,d){if(!d||!c||!l||!b||!a||!s){return;}var e=Math.min(Math.max(b,s.GetMinLOD()),s.GetMaxLOD());b=Math.floor(e);var t=s.m_MapManager.m_tileWidth;var f=s.m_MapManager.m_tileHeight;var g=s.m_Proj.m_nXYRatio;var h=(1<<b);var j=2.0/h;var k=VBI.MathLib.DegToRad([parseFloat(l),parseFloat(a)]);var u=[h*t,h*f];s.m_Proj.LonLatToUCS(k,u);var x=Math.floor(u[0]/t);var y=Math.floor(u[1]/f);var n=c.m_MapLayerArray;var o={m_Callback:d,m_Images:[],m_ImagesRemain:n.length,m_MapLayerStack:c,compose:function(){this.m_ImagesRemain-=1;if(this.m_ImagesRemain<=0){var E=document.createElement('canvas');o=E.getContext('2d');var F=this.m_MapLayerStack.m_colBkgnd;o.fillStyle=F;o.fillRect(0,0,E.width,E.height);for(var i=0;i<this.m_Images.length;++i){if(this.m_Images[i]){o.globalAlpha=this.m_Images[i].m_Opacity;var G=0;var H=0;var I=this.m_Images[i].width;var J=this.m_Images[i].height;var K=0;var L=0;var M=E.width;var N=E.height;o.drawImage(this.m_Images[i],G,H,I,J,K,L,M,N);}}var O=new Image();O.src=E.toDataURL();d(O);}}};var p=function(E){if(VBI.m_bTrace){VBI.Trace("onLoad "+E.target.src);}var C=E.target;C.m_Context.compose();};var q=function(E){if(VBI.m_bTrace){VBI.Trace("onAbort "+E.target.src);}var C=E.target;C.m_Context.m_Images[C.m_Index]=null;C.m_Context.compose();};var r=function(E){if(VBI.m_bTrace){VBI.Trace("onError "+E.target.src);}var C=E.target;C.m_Context.m_Images[C.m_Index]=null;C.m_Context.compose();};for(var i=0;i<n.length;++i){var v=n[i];var w=v.GetMapProvider();if(v.GetMinLOD()>b||v.GetMaxLOD()<b){continue;}var z;if(w.m_bPosRequired){var A=[x*j/g-1,y*j-1];var B=[(x+1)*j/g-1,(y+1)*j-1];z=w.CombineUrlWPos(x,y,b,j,A,B,1,1,t,f);}else{z=w.CombineUrl(x,y,b);}var C=new Image();C.setAttribute('crossOrigin','anonymous');o.m_Images[i]=C;C.m_Index=i;C.m_Context=o;if(v.m_fOpacity){C.m_Opacity=v.m_fOpacity;}C.onload=p;C.onabort=q;C.onerror=r;try{C.src=z;}catch(D){if(VBI.m_bTrace){VBI.Trace("GetPreviewImage "+D);}C.m_Context.m_Images[C.m_Index]=null;C.m_Context.compose();}}};return m;})();
},
	"sap/ui/vbm/lib/sapmapprovider.js":function(){
VBI.MapProviders=function(){"use strict";var m={};m.vbiclass="MapProviders";m.m_MapProviderArray=[];m.clear=function(){for(var n=0;n<m.m_MapProviderArray.length;++n){m.m_MapProviderArray[n].clear();}m.m_MapProviderArray=[];};m.load=function(d,c){if(d.Set){var a;m.clear();if(d.Set.MapProvider){if(jQuery.type(d.Set.MapProvider)=='object'){a=new VBI.MapProvider();a.load(d.Set.MapProvider);m.Add(a);}else if(jQuery.type(d.Set.MapProvider)=='array'){for(var n=0;n<d.Set.MapProvider.length;++n){a=new VBI.MapProvider();a.load(d.Set.MapProvider[n]);m.Add(a);}}}}};m.Add=function(a){this.m_MapProviderArray.push(a);};m.GetMapProviderByName=function(n){for(var a=0;a<m.m_MapProviderArray.length;++a){if(m.m_MapProviderArray[a].m_Name==n){return m.m_MapProviderArray[a];}}return null;};return m;};
VBI.MapProvider=function(n,d,c,t,a,m,b,f,r,p){"use strict";var e={};e.vbiclass="MapProvider";e.m_SourceArray=[];e.m_Name=n;e.m_Description=d;e.m_Copyright=c;e.m_tileX=typeof t!=='undefined'?t:256;e.m_tileY=typeof a!=='undefined'?a:256;e.m_maxLOD=typeof b!=='undefined'?b:19;e.m_minLOD=typeof m!=='undefined'?m:0;e.m_nResolution=typeof r!='undefined'?r:256;e.m_nProjection=typeof p!='undefined'?p:1;if(f!=null){e.fillStyle=f;}e.clear=function(){for(var g=0;g<e.m_SourceArray.length;++g){e.m_SourceArray[g].clear();}e.m_SourceArray=[];};e.GetCopyright=function(){return VBI.Utilities.AssembleCopyrightString(this.m_Copyright,this.m_CopyrightLink,this.m_CopyrightImage);};e.addMapBase=function(l,g,h,i,j,s){var k={};if(l){k.left=parseFloat(l);}if(g){k.right=parseFloat(g);}if(h){k.top=parseFloat(h);}if(i){k.bottom=parseFloat(i);}k.round=(j!=undefined?parseFloat(j):0);k.xSize=g-l;k.ySize=h-i;if(s!=undefined){k.relXSize=k.xSize/s.xSize;k.relYSize=k.ySize/s.ySize;}return k;};e.addMapBaseBorder=function(g,h,i,j,k){g.leftBorder=h;g.rightBorder=i;g.bottomBorder=j;g.topBorder=k;};e.load=function(g){if(g.name){e.m_Name=g.name;}if(g.description){e.m_Description=g.description;}if(g.copyright){e.m_Copyright=g.copyright;}if(g.copyrightLink){e.m_CopyrightLink=g.copyrightLink;}if(g.copyrightImage){e.m_CopyrightImage=g.copyrightImage;}if(g.tileX){e.m_tileX=g.tileX;}if(g.tileY){e.m_tileY=g.tileY;}if(g.maxLOD){e.m_maxLOD=g.maxLOD;}if(g.minLOD){e.m_minLOD=g.minLOD;}if(g.resolution){e.m_nResolution=g.resolution;}if(g.projection){if(g.projection==="Linear"){e.m_nProjection=2;}else if(g.projection==="Elliptical"){e.m_nProjection=3;}}var h=g.MapBase;e.m_StdMapBase=e.addMapBase(-1,1,1,-1,10);if(g.MapBase){e.m_MapBase=e.addMapBase(h.left,h.right,h.top,h.bottom,h.round,e.m_StdMapBase);e.addMapBaseBorder(e.m_MapBase,h.minX,h.maxX,h.minY,h.maxY);}else{e.m_MapBase=e.addMapBase(-180,180,90,-90,10,e.m_StdMapBase);}if(g.Source){var s;if(jQuery.type(g.Source)=='object'){s=new VBI.Source(null);e.m_bPosRequired=s.load(g.Source);e.Add(s);}else if(jQuery.type(g.Source)=='array'){e.m_bPosRequired=false;for(var i=0;i<g.Source.length;++i){s=new VBI.Source(null);e.m_bPosRequired=(s.load(g.Source[i])||e.m_bPosRequired);e.Add(s);}}}};e.Add=function(s){this.m_SourceArray.push(s);};e.CombineUrlWPos=function(x,y,l,T,g,h,i,j,k,o){var q=1<<l;var s=10;if(e.m_MapBase){var u=e.m_StdMapBase;var v=e.m_MapBase;g[0]=(g[0]-u.left)*v.relXSize+v.left;g[1]=-((g[1]-u.bottom)*v.relYSize+v.bottom);h[0]=(h[0]-u.left)*v.relXSize+v.left;h[1]=-((h[1]-u.bottom)*v.relYSize+v.bottom);s=v.round;}if(this.m_SourceArray.length==0){return null;}return this.m_SourceArray[((y+x*q)%this.m_SourceArray.length)].CombineUrlWPos(x,y,l,T,g,h,i,j,s,Math.min(k,e.m_nResolution),Math.min(o,e.m_nResolution));};e.CombineUrl=function(x,y,l){var g=1<<l;if(x<0||y<0||(x>=g)||(y>=g)){return null;}if(this.m_SourceArray.length==0){return null;}return this.m_SourceArray[((y+x*g)%this.m_SourceArray.length)].CombineUrl(x,y,l);};e.GetMaxLOD=function(){return this.m_maxLOD;};e.GetMinLOD=function(){return this.m_minLOD;};return e;};
VBI.Source=function(u){"use strict";var s={};s.vbiclass="Source";s.m_ID=null;s.m_Url=u;s.clear=function(){};s.load=function(d){if(d.url){s.m_Url=d.url;}if(d.id){s.m_ID=d.id;}s.m_bQuadkey=(s.m_Url.indexOf("{QUAD}")>=0);s.m_bNumkey=(s.m_Url.indexOf("{NUM}")>=0);return((s.m_Url.indexOf("LU_LAT")>=0)||(s.m_Url.indexOf("LU_LONG")>=0)||(s.m_Url.indexOf("RL_LAT")>=0)||(s.m_Url.indexOf("RL_LONG")>=0));};s.CombineUrl=function(x,y,l){var t=s.m_Url;t=t.replace("{X}",x);t=t.replace("{Y}",y);t=t.replace("{-Y}",(1<<l)-y-1);t=t.replace("{LOD}",l);if(s.m_bQuadkey){t=t.replace("{QUAD}",this.TileXYToQuadKey(x,y,l));}if(s.m_bNumkey){t=t.replace("{NUMT}",this.TileXYToNumKey(x,y,l));}return t;};s.CombineUrlWPos=function(x,y,l,t,a,r,b,c,n,d,e){var f=s.m_Url;var g=Math.pow(10,n);f=f.replace("{X}",x);f=f.replace("{Y}",y);f=f.replace("{-Y}",(1<<l)-y-1);f=f.replace("{LOD}",l);if(s.m_bQuadkey){f=f.replace("{QUAD}",this.TileXYToQuadKey(x,y,l));}if(s.m_bNumkey){f=f.replace("{NUMT}",this.TileXYToNumKey(x,y,l));}f=f.replace("{WIDTH}",d*b);f=f.replace("{HEIGHT}",e*c);f=f.replace("{LU_LONG}",Math.round(a[0]*g)/g);f=f.replace("{LU_LAT}",Math.round(a[1]*g)/g);f=f.replace("{RL_LONG}",Math.round(r[0]*g)/g);f=f.replace("{RL_LAT}",Math.round(r[1]*g)/g);return f;};s.TileXYToQuadKey=function(x,y,l){var q=[];for(var i=l;i>0;--i){var d='0';var m=1<<(i-1);if(x&m){d++;}if(y&m){d++;d++;}q.push(d);}var a=q.join("");return a;};s.TileXYToNumKey=function(x,y,l){var n=0;for(var i=1;i<l;++i){n+=(1<<i)*(1<<i);}n+=(y*(1<<l)+x+1);return n;};return s;};
},
	"sap/ui/vbm/lib/sapnavigation.js":function(){
VBI.NavigationControl=function(S){"use strict";var n={};sap.ui.core.IconPool.insertFontFaceStyle();n.scene=null;n.suppressedVisibility=S;n.m_MinLOD=null;n.m_MaxLOD=null;n.m_lengthScrollLine=94-18;n.m_startScrollPoint=null;n.m_ID=null;n.zoomtimerfrq=40;n.zoomtimer=0;n.movetimer=0;n.bInitDrag=false;n.offsetX=0;n.offsetY=0;n.curMoveX=0;n.curMoveY=0;n.curZoomY=0;n.tint=20;n.midpointForZoom=[0,0];n.timer_mapnav=null;n.m_Div=n.m_Divmapnav=n.m_Divmapscrollarea=n.m_Divmapscrollpoint=n.m_Divmapcursorgrip=n.m_Divmapcursor=n.m_Divmapcursorreset=n.m_Divmapcursorleft=n.m_Divmapcursortop=n.m_Divmapcursorright=n.m_Divmapcursordown=n.m_DivmapmobileHome=n.m_DivmapmobileHomeIcon=n.m_DivmapmobileZoomin=n.m_DivmapmobileZoominIcon=n.m_DivmapmobileZoomout=n.m_DivmapmobileZoomoutIcon=null;n.clear=function(){if(n.timer_mapnav){window.clearInterval(n.timer_mapnav);}n.DetachEvents();n.scene=null;n.m_Div=n.m_Divmapnav=n.m_Divmapscrollarea=n.m_Divmapscrollpoint=n.m_Divmapcursorgrip=n.m_Divmapcursor=n.m_Divmapcursorreset=n.m_Divmapcursorleft=n.m_Divmapcursortop=n.m_Divmapcursorright=n.m_Divmapcursordown=n.m_DivmapmobileHome=n.m_DivmapmobileHomeIcon=n.m_DivmapmobileZoomin=n.m_DivmapmobileZoominIcon=n.m_DivmapmobileZoomout=n.m_DivmapmobileZoomoutIcon=null;};n.getId=function(a,b){return b+'-'+a;};n.DetachEvents=function(){if(VBI.m_bIsMobile){jQuery(n.m_DivmapmobileHome).off();jQuery(n.m_DivmapmobileZoomin).off();jQuery(n.m_DivmapmobileZoomout).off();}else{jQuery(n.m_Divmapnav).off();jQuery(n.m_Divmapscrollpoint).off();jQuery(n.m_Divmapcursorgrip).off();jQuery(n.m_Divmapcursorleft).off();jQuery(n.m_Divmapcursorright).off();jQuery(n.m_Divmapcursortop).off();jQuery(n.m_Divmapcursordown).off();jQuery(n.m_Divmapcursorreset).off();document.removeEventListener('mouseup',n.zoom_processmouseup,true);document.removeEventListener('mousemove',n.zoom_processmousemove,true);}};n.AttachEvents=function(){if(VBI.m_bIsMobile){n.AttachTouchEvents();}else{n.AttachMouseEvents();}};n.AttachTouchEvents=function(){jQuery(n.m_DivmapmobileHome).on("click",function(){if(VBI.m_bTrace){VBI.Trace("Home Button : click");}n.scene.GoToInitialStart();});jQuery(n.m_DivmapmobileHome).on("touchstart",function(){if(VBI.m_bTrace){VBI.Trace("Home Button : touchstart");}n.scene.GoToInitialStart();});jQuery(n.m_DivmapmobileHome).on("touchend",function(e){if(VBI.m_bTrace){VBI.Trace("Home Button : touchend");}e.preventDefault();});jQuery(n.m_DivmapmobileZoomin).on("touchstart",function(){if(VBI.m_bTrace){VBI.Trace("ZoomIn Button : touchstart");}n.StartAnimatedZoom(1);});jQuery(n.m_DivmapmobileZoomin).on("touchend",function(e){if(VBI.m_bTrace){VBI.Trace("ZoomIn Button : touchend");}if(n.zoomtimer){window.clearInterval(n.zoomtimer);n.ZoomToNextIntegerLOD(true);}e.preventDefault();});jQuery(n.m_DivmapmobileZoomin).on("touchleave",function(){if(VBI.m_bTrace){VBI.Trace("ZoomIn Button : touchleave");}if(n.zoomtimer){window.clearInterval(n.zoomtimer);n.ZoomToNextIntegerLOD(true);}});jQuery(n.m_DivmapmobileZoomout).on("touchstart",function(){if(VBI.m_bTrace){VBI.Trace("ZoomOut Button : touchstart");}n.StartAnimatedZoom(-1);});jQuery(n.m_DivmapmobileZoomout).on("touchend",function(e){if(VBI.m_bTrace){VBI.Trace("ZoomOut Button : touchend");}if(n.zoomtimer){window.clearInterval(n.zoomtimer);n.ZoomToNextIntegerLOD(false);}e.preventDefault();});jQuery(n.m_DivmapmobileZoomout).on("touchleave",function(){if(VBI.m_bTrace){VBI.Trace("ZoomOut Button : touchleave");}if(n.zoomtimer){window.clearInterval(n.zoomtimer);n.ZoomToNextIntegerLOD(false);}});};n.AttachMouseEvents=function(){var o=1.0;var t=50;n.timer_mapnav=null;var f=null;if(n.suppressedVisibility.fade){n.m_Divmapnav.style.opacity=1;}jQuery(n.m_Divmapnav).on("mouseenter",function(e){f=e.fromElement;});jQuery(n.m_Divmapnav).on("mouseup",function(){if(f){f.focus({preventScroll:true});}});jQuery(n.m_Divmapnav).on("mouseleave",function(){if(!n.suppressedVisibility.fade){o=1.0;n.timer_mapnav=window.setInterval(function(){if(!n.m_Divmapnav||o<=0.5){window.clearInterval(n.timer_mapnav);}else{o-=0.01;n.m_Divmapnav.style.opacity=o;}},t);}});jQuery(n.m_Divmapnav).on("mouseenter",function(){window.clearInterval(n.timer_mapnav);n.m_Divmapnav.style.opacity=1;});if(!n.suppressedVisibility.zoom){if(n.suppressedVisibility.move){jQuery(n.m_Divmapscrollarea).css('top',10+'px');}jQuery(n.m_Divmapscrollpoint).on("mousedown",function(e){if(e.which==1){n.midpointForZoom=n.scene.GetCenterPos();n.curZoomY=jQuery(n.m_Divmapscrollpoint).position().top;n.offsetY=e.pageY-n.curZoomY;document.addEventListener('mouseup',n.zoom_processmouseup,true);document.addEventListener('mousemove',n.zoom_processmousemove,true);}});jQuery(n.m_Divmapscrollpoint).on("dragstart",function(e){e.preventDefault();});}if(!n.suppressedVisibility.move){jQuery(n.m_Divmapcursorgrip).on("mouseenter",function(){jQuery(n.m_Divmapcursor).css("background-position","-5px 228px");}).on("mouseleave",function(){jQuery(n.m_Divmapcursor).css("background-position","-5px 305px");});var d=10;jQuery(n.m_Divmapcursorleft).on("mousedown",function(e){if(e.which==1){jQuery(this).css("background-position","-134px 194px");window.clearInterval(n.movetimer);n.movetimer=window.setInterval(function(){n.scene.MoveMap(d,0);},n.tint);}}).on("mouseup",function(e){window.clearInterval(n.movetimer);jQuery(this).css("background-position","-134px 211px");}).on("mouseout",function(e){if(n.bInitDrag==false){window.clearInterval(n.movetimer);jQuery(this).css("background-position","-134px 228px");}}).on("mousemove",function(e){if(n.bInitDrag==true){jQuery(this).css("background-position","-134px 177px");}});jQuery(n.m_Divmapcursorright).on("mousedown",function(e){if(e.which==1){jQuery(this).css("background-position","-116px 194px");window.clearInterval(n.movetimer);n.movetimer=window.setInterval(function(){n.scene.MoveMap(-d,0);},n.tint);}}).on("mouseup",function(e){window.clearInterval(n.movetimer);jQuery(this).css("background-position","-116px 211px");}).on("mouseout",function(e){if(n.bInitDrag==false){window.clearInterval(n.movetimer);jQuery(this).css("background-position","-116px 228px");}}).on("mousemove",function(e){if(n.bInitDrag==true){jQuery(this).css("background-position","-116px 177px");}});jQuery(n.m_Divmapcursortop).on("mousedown",function(e){if(e.which==1){jQuery(this).css("background-position","-82px 192px");window.clearInterval(n.movetimer);n.movetimer=window.setInterval(function(){n.scene.MoveMap(0,d);},n.tint);}}).on("mouseup",function(e){window.clearInterval(n.movetimer);jQuery(this).css("background-position","-82px 210px");}).on("mouseout",function(e){if(n.bInitDrag==false){window.clearInterval(n.movetimer);jQuery(this).css("background-position","-82px 228px");}}).on("mousemove",function(e){if(n.bInitDrag==true){jQuery(this).css("background-position","-82px 174px");}});jQuery(n.m_Divmapcursordown).on("mousedown",function(e){if(e.which==1){jQuery(this).css("background-position","-99px 192px");window.clearInterval(n.movetimer);n.movetimer=window.setInterval(function(){n.scene.MoveMap(0,-d);},n.tint);}}).on("mouseup",function(e){window.clearInterval(n.movetimer);jQuery(this).css("background-position","-99px 210px");}).on("mouseout",function(e){if(n.bInitDrag==false){window.clearInterval(n.movetimer);jQuery(this).css("background-position","-99px 228px");}}).on("mousemove",function(e){if(n.bInitDrag==true){jQuery(this).css("background-position","-99px 174px");}});jQuery(n.m_Divmapcursorreset).on("dragstart",function(e){e.preventDefault();});jQuery(n.m_Divmapcursorreset).on("mousedown",function(e){if(e.which==1){n.curMoveX=jQuery(n.m_Divmapcursorreset).position().left;n.curMoveY=jQuery(n.m_Divmapcursorreset).position().top;jQuery(n.m_Divmapcursorleft).css("background-position","-134px 177px");jQuery(n.m_Divmapcursorright).css("background-position","-116px 177px");jQuery(n.m_Divmapcursordown).css("background-position","-99px 174px");jQuery(n.m_Divmapcursortop).css("background-position","-82px 174px");jQuery(this).css("background-position","-222px 263px");n.offsetX=e.pageX-n.curMoveX;n.offsetY=e.pageY-n.curMoveY;window.clearInterval(n.movetimer);n.movetimer=0;n.bInitDrag=true;document.addEventListener('mouseup',n.processmouseup,true);document.addEventListener('mousemove',n.processmousemove,true);}});jQuery(n.m_Divmapcursorreset).css("position","");jQuery(n.m_Divmapcursorreset).on("dblclick",function(){n.scene.GoToInitialStart();});}};n.AppendButton=function(){n.m_Divmapnav=VBI.Utilities.CreateGeoSceneDivCSS(n.getId('vbi-nav',n.m_ID),'vbi-nav');n.m_Divmapnav.m_VBIType="N";n.m_DivmapmobileHome=VBI.Utilities.CreateGeoSceneDivCSS(n.getId('vbi-navmobile-home',n.m_ID),'vbi-navmobile-home');n.m_DivmapmobileHome.innerHTML="\ue070";n.m_Divmapnav.appendChild(n.m_DivmapmobileHome);if(!n.suppressedVisibility.zoom){n.m_DivmapmobileZoomin=VBI.Utilities.CreateGeoSceneDivCSS(n.getId('vbi-navmobile-zoomin',n.m_ID),'vbi-navmobile-zoomin');n.m_DivmapmobileZoomin.innerHTML="+";n.m_Divmapnav.appendChild(n.m_DivmapmobileZoomin);n.m_DivmapmobileZoomout=VBI.Utilities.CreateGeoSceneDivCSS(n.getId('vbi-navmobile-zoomout',n.m_ID),'vbi-navmobile-zoomout');n.m_DivmapmobileZoomout.innerHTML="-";n.m_Divmapnav.appendChild(n.m_DivmapmobileZoomout);}n.scene.m_Div.appendChild(n.m_Divmapnav);};n.AppendDiv=function(){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.vbm.i18n");var t=r.getText("NAVCTL_TITLE_ZOOM",[0]);t=t.substr(0,t.search(/[0-9]/));n.m_Divmapnav=VBI.Utilities.CreateGeoSceneDivCSS(n.getId('vbi-nav',n.m_ID),'vbi-nav');n.m_Divmapnav.m_VBIType="N";n.m_Divmapcursor=VBI.Utilities.CreateGeoSceneDivCSS(n.getId('vbi-cursor',n.m_ID),'vbi-cursor');n.m_Divmapscrollarea=VBI.Utilities.CreateGeoSceneDivCSS(n.getId('vbi-scrollarea',n.m_ID),'vbi-scrollarea');n.m_Divmapcursorgrip=VBI.Utilities.CreateGeoSceneDivCSS(n.getId('vbi-cursor-grip',n.m_ID),'vbi-cursor-grip');var m=VBI.Utilities.CreateGeoSceneDivCSS(n.getId('vbi-cursor-middle',n.m_ID),'vbi-cursor-middle');var a=VBI.Utilities.CreateGeoSceneDivCSS(n.getId('vbi-scrolllineupperending',n.m_ID),'vbi-scrolllineupperending');var b=VBI.Utilities.CreateGeoSceneDivCSS(n.getId('vbi-scrollline',n.m_ID),'vbi-scrollline');var c=VBI.Utilities.CreateGeoSceneDivCSS(n.getId('vbi-scrolllinelowerending',n.m_ID),'vbi-scrolllinelowerending');n.m_Divmapscrollpoint=VBI.Utilities.CreateGeoSceneDivCSS(n.getId('vbi-scrollpoint',n.m_ID),'vbi-scrollpoint',t);n.m_Divmapcursorleft=VBI.Utilities.CreateGeoSceneDivCSS(n.getId('vbi-cursor-left',n.m_ID),'vbi-cursor-left',r.getText("NAVCTL_TITLE_MOVE_LEFT"));n.m_Divmapcursorright=VBI.Utilities.CreateGeoSceneDivCSS(n.getId('vbi-cursor-right',n.m_ID),'vbi-cursor-right',r.getText("NAVCTL_TITLE_MOVE_RIGHT"));n.m_Divmapcursortop=VBI.Utilities.CreateGeoSceneDivCSS(n.getId('vbi-cursor-top',n.m_ID),'vbi-cursor-top',r.getText("NAVCTL_TITLE_MOVE_UP"));n.m_Divmapcursordown=VBI.Utilities.CreateGeoSceneDivCSS(n.getId('vbi-cursor-down',n.m_ID),'vbi-cursor-down',r.getText("NAVCTL_TITLE_MOVE_DOWN"));n.m_Divmapcursorreset=VBI.Utilities.CreateGeoSceneDivCSS(n.getId('vbi-cursor-reset',n.m_ID),'vbi-cursor-reset',r.getText("NAVCTL_TITLE_MOVE"));m.appendChild(n.m_Divmapcursorleft);m.appendChild(n.m_Divmapcursorright);m.appendChild(n.m_Divmapcursortop);m.appendChild(n.m_Divmapcursordown);m.appendChild(n.m_Divmapcursorreset);n.m_Divmapcursorgrip.appendChild(m);n.m_Divmapscrollarea.appendChild(a);n.m_Divmapscrollarea.appendChild(b);n.m_Divmapscrollarea.appendChild(c);n.m_Divmapscrollarea.appendChild(n.m_Divmapscrollpoint);if(!n.suppressedVisibility.zoom){n.m_Divmapnav.appendChild(n.m_Divmapscrollarea);}if(!n.suppressedVisibility.move){n.m_Divmapnav.appendChild(n.m_Divmapcursor);n.m_Divmapnav.appendChild(n.m_Divmapcursorgrip);}n.scene.m_Div.appendChild(n.m_Divmapnav);};n.AdaptMinMaxLOD=function(s){n.m_MinLOD=n.scene.GetMinLOD();n.m_MaxLOD=n.scene.GetMaxLOD();};n.Awake=function(s,t){n.scene=s;n.m_MinLOD=n.scene.GetMinLOD();n.m_MaxLOD=n.scene.GetMaxLOD();var l=jQuery.sap.byId(t);n.m_ID=jQuery(l).attr('id');if(VBI.m_bIsMobile){n.AppendButton();}else{n.AppendDiv();n.m_Divmapnav.style.opacity=0.5;n.m_startScrollPoint=0;}n.AttachEvents();};n.AdjustScrollPoint=function(l){if(VBI.m_bIsMobile){return;}var c;if(l){c=((n.m_lengthScrollLine*(l-n.m_MinLOD))/(n.m_MaxLOD-n.m_MinLOD))+n.m_startScrollPoint;jQuery(n.m_Divmapscrollpoint).css('top',c+'px');}else{var a=n.scene.GetCurrentZoomlevel();c=((n.m_lengthScrollLine*(a-n.m_MinLOD))/(n.m_MaxLOD-n.m_MinLOD))+n.m_startScrollPoint;jQuery(n.m_Divmapscrollpoint).css('top',c+'px');}};n.StopAnimatedMove=function(){window.clearInterval(n.movetimer);n.movetimer=0;jQuery(n.m_Divmapcursorleft).removeAttr("style");jQuery(n.m_Divmapcursorright).removeAttr("style");jQuery(n.m_Divmapcursordown).removeAttr("style");jQuery(n.m_Divmapcursortop).removeAttr("style");jQuery(n.m_Divmapcursorreset).removeAttr("style");jQuery(n.m_Divmapcursorreset).css('top',n.curMoveX+'px');jQuery(n.m_Divmapcursorreset).css('left',n.curMoveY+'px');};n.ZoomToNextIntegerLOD=function(z){var l=n.scene.m_Canvas[0].m_nExactLOD;var a=z?Math.ceil(l):Math.floor(l);if(l!=a){n.scene.AnimateZoomToGeo(n.scene.GetCenterPos(),a,n.zoomtimerfrq);}else{n.scene.InternalOnZoomLayer(n.scene.m_Canvas[n.scene.m_nOverlayIndex]);}};n.StartAnimatedZoom=function(z){var a=n.scene.GetCenterPos();if(n.zoomtimer){window.clearInterval(n.zoomtimer);}n.zoomtimer=window.setInterval(function(){var b=n.scene.GetCurrentZoomlevel()+0.2*z;n.scene.ZoomToZoomlevel(a,b,true);},n.zoomtimerfrq);};n.processmouseup=function(){n.bInitDrag=false;n.StopAnimatedMove();document.removeEventListener('mouseup',n.processmouseup,true);document.removeEventListener('mousemove',n.processmousemove,true);};n.zoom_processmouseup=function(e){document.removeEventListener('mouseup',n.zoom_processmouseup,true);document.removeEventListener('mousemove',n.zoom_processmousemove,true);if(n.bInitDrag){var a=e.pageY-n.offsetY;if(a<0){a=0;}if(a>n.m_lengthScrollLine){a=n.m_lengthScrollLine;}var z=n.m_MinLOD+(((n.m_MaxLOD-n.m_MinLOD)*(a))/n.m_lengthScrollLine);n.scene.AnimateZoomToGeo(n.midpointForZoom,Math.round(z),5);}n.bInitDrag=false;};n.processmousemove=function(e){var s,a;if(n.bInitDrag==true){window.clearInterval(n.movetimer);n.movetimer=0;var b=e.pageX-n.offsetX;var c=e.pageY-n.offsetY;var d=parseInt(Math.sqrt(Math.pow(b-n.curMoveX,2)+Math.pow(c-n.curMoveY,2)),10);var m=17;if(d>m){var f=Math.atan2(b-n.curMoveX,c-n.curMoveY);s=Math.ceil((n.curMoveX+(Math.sin(f)*m)));a=Math.ceil((n.curMoveY+(Math.cos(f)*m)));d=m;}else{s=b;a=c;}jQuery(n.m_Divmapcursorreset).css('top',a+'px');jQuery(n.m_Divmapcursorreset).css('left',s+'px');var g=-(jQuery(n.m_Divmapcursorreset).position().left-n.curMoveX)*(d/m);var h=-(jQuery(n.m_Divmapcursorreset).position().top-n.curMoveY)*(d/m);n.movetimer=window.setInterval(function(){n.scene.MoveMap(g,h);},n.tint);}};n.zoom_processmousemove=function(e){var a=e.pageY-n.offsetY;if(!n.bInitDrag){if(a!=n.curZoomY){n.bInitDrag=true;}}if(n.bInitDrag){if(a<0){a=0;}if(a>n.m_lengthScrollLine){a=n.m_lengthScrollLine;}jQuery(n.m_Divmapscrollpoint).css('top',a+'px');var z=n.m_MinLOD+(((n.m_MaxLOD-n.m_MinLOD)*(a))/n.m_lengthScrollLine);n.scene.ZoomToZoomlevel(n.midpointForZoom,z);}};return n;};
},
	"sap/ui/vbm/lib/sapparsing.js":function(){
VBI.Parser=function(){"use strict";var p={};p.formulas=[];p.fPos=0;p.fCode="";p.fAttributes=[];p.clear=function(){var t;while((t=p.formulas.shift())!=undefined){p.clearExpression(t.dTree);}};p.evaluate=function(v,a,c){p.vo=v;p.voi=a;p.ctx=c;p.pos=undefined;var n=p.formulas.length;for(var i=0;i<n;++i){var f=p.formulas[i];if(p.evalF(f.dTree)){return f.index;}}return-1;};p.evalF=function(n){if((n.operator==false)||(n.operator==true)){return n.operator;}var r;if(n.operator==600){r=p.evalF(n.operand1);return r?p.evalF(n.operand2):false;}if(n.operator==700){r=p.evalF(n.operand1);return r?true:p.evalF(n.operand2);}var o;var v=p.vo;switch(n.operand1){case"text":o=v.m_Text.GetValueString(p.ctx);break;case"itext":o=parseInt(v.m_Text.GetValueString(p.ctx),10);break;case"id":o=v.m_ID;break;case"image":o=v.m_Image.GetValueString(p.ctx);break;case"x":if(!p.pos){p.pos=p.vo.m_Pos.GetValueVector(p.ctx);}o=p.pos[0];break;case"y":if(!p.pos){p.pos=p.vo.m_Pos.GetValueVector(p.ctx);}o=p.pos[1];break;case"tooltip":o=v.m_Tooltip.GetValueString(p.ctx);break;default:var a=p.fAttributes[p.voi];o="";for(var j=0;j<a.length;++j){if(a[j].name==n.operand1){var d=v.m_DataSource.m_CurElement.m_dataattributes[a[j].index];if(d!=undefined){o=d.m_Value;}}}}switch(n.operator){case 50:return o==n.operand2;case 51:return o>=n.operand2;case 52:return o>n.operand2;case 55:return o!=n.operand2;case 56:return o<=n.operand2;case 57:return o<n.operand2;}};p.verifyAttribute=function(n,v,d){if(jQuery.type(n.operand2)=='object'){p.verifyAttribute(n.operand2,v,d);}if(jQuery.type(n.operand1)=='object'){p.verifyAttribute(n.operand1,v,d);}else{var e=n.operand1;if((e!="id")&&(e!="image")&&(e!="x")&&(e!="y")&&(e!="tooltip")){if(!p.fAttributes){p.buildAttributeTable(v);}for(var i=0;i<d.m_datatypenodes.length;++i){var c=d.m_datatypenodes[i];var a=c.m_Name;var b=c.m_datatypeattributes;for(var j=0;j<b.length;++j){var f=b[j];if(f.m_Name==e){for(var k=0;k<p.fAttributes.length;++k){var g=p.fAttributes[k];if(g.m_Name==a){var F=false;for(var l=0;l<g.length;++l){if(g[l].name==e){F=true;}}if(!F){g.push({name:e,index:j});}}}}}}}}};p.buildAttributeTable=function(v){p.fAttributes=[];for(var i=0;i<v.length;++i){var P=[];var d=v[i].m_DataSource;if(d!=undefined){P.m_Name=d.m_NPath[0];p.fAttributes.push(P);}}};p.verifyAttributes=function(v,c){p.fAttributes=undefined;var d=c.m_DataTypeProvider;for(var i=0;i<p.formulas.length;++i){p.verifyAttribute(p.formulas[i].dTree,v,d);}};p.clearExpression=function(m){if(jQuery.type(m)!='object'){return;}p.clearExpression(m.operand1);p.clearExpression(m.operand2);m.operand1=m.operand2=undefined;};p.addFormula=function(i,m){p.formulas.push({index:i,formula:m,dTree:p.buildDecisionTree(m)});return p.formulas.length-1;};p.buildDecisionTree=function(m){p.fPos=0;p.fCode=m;var c={};if(!p.parseExpression(c)){VBI.Trace("Error: "+m+" could not be interpreted");c.operator=false;}return c;};p.parseExpression=function(n){var o=p.scan();if(o==-1){n.operator=true;return(n.operator);}if(o==10){n.operand1={};if(!p.parseExpression(n.operand1)){return false;}if(p.scan()!=20){return false;}n.operator=p.scan();if(p.ttype!=2){return false;}if(p.scan()!=10){return false;}n.operand2={};if(!p.parseExpression(n.operand2)){return false;}if(p.scan()!=20){return false;}return true;}if(o==500){n.operand1=p.token;n.operator=p.scan();if(p.ttype!=1){return false;}p.scan();if(p.ttype!=10){return false;}n.operand2=p.token;return true;}return false;};p.scan=function(){var l;var n=0;if(p.fPos>=p.fCode.length){return-1;}var m=p.fCode.substr(p.fPos,1);switch(true){case m=="(":return p.getToken(m,10,0);case m==")":return p.getToken(m,20,0);case m=="=":return p.getToken(m,50,1);case m=="!":return p.fCode.substr(p.fPos+1,1)=="="?p.getToken("!=",55,1):false;case m=="<":case m==">":n=5*(m=="<");l=p.fCode.substr(p.fPos+1,1);if(l=="="){return p.getToken(m+l,51+n,1);}if(m=="<"&&l==">"){return p.getToken("!=",55,1);}return p.getToken(m,52+n,1);case m=="|":case m=="&":n=100*(m=="|");l=p.fCode.substr(p.fPos+1,1);if(m!=l){l="";}return p.getToken(m+l,600+n,2);case((m>="0")&&(m<="9")):return p.readNumber(m);case(((m>="a")&&(m<="z"))||((m>="A")&&(m<="Z"))):return p.readString(m);default:return-2;}};p.readNumber=function(f){var s=f;var i=1;var n=p.fCode.substr(p.fPos+i,1);while((n>="0")&&(n<="9")){s+=n;i++;n=p.fCode.substr(p.fPos+i,1);}return p.getToken(s,600,10);};p.readString=function(f){var s=f;var i=1;var n=p.fCode.substr(p.fPos+i,1);while((((n>="a")&&(n<="z"))||((n>="A")&&(n<="Z")))||((n>="0")&&(n<="9"))||(n=="_")||(n==".")||(n=="/")||(n=="\\")){s+=n;i++;n=p.fCode.substr(p.fPos+i,1);}return p.getToken(s,500,10);};p.getToken=function(s,i,t){p.fPos+=s.length;p.token=s;p.ttype=t;return i;};return p;};
},
	"sap/ui/vbm/lib/sappositioning.js":function(){
VBI.addScenePositioningFunctions=function(s){"use strict";s.GetNearestPosArray=function(p){var a=p.slice();var n=Math.floor(a.length/3)*3;var b=a[0];var c=a[1];var m=b,d=b;var e=c,f=c;for(var g=3;g<n;g+=3){while(a[g]-b>180){a[g]-=360;}while(b-a[g]>180){a[g]+=360;}b=a[g];c=a[g+1];if(m>b){m=b;}if(d<b){d=b;}if(e>c){e=c;}if(f<c){f=c;}}a.m_MinX=m;a.m_MaxX=d;a.m_MinY=e;a.m_MaxY=f;return a;};s.GetNearestPos=function(a,n){var p=a.slice();var b=n[0];while(p[0]-b>180){p[0]-=360;}while(b-p[0]>180){p[0]+=360;}return p;};s.BuildCacheDataObj=function(){var n={};n.mul=Math.PI/180.0;var c=s.m_Canvas[0];var a=s.m_Canvas[s.m_nOverlayIndex];var l=c.m_nCurrentLOD;n.minLOD=s.GetMinLOD();n.lod=l;n.nMaxLODTiles=(1<<l);n.tilePixelWidth=s.m_nWidthCanvas/s.m_nTilesX;n.tilePixelHeight=s.m_nHeightCanvas/s.m_nTilesY;n.completeX=n.nMaxLODTiles*n.tilePixelWidth;n.completeY=n.nMaxLODTiles*n.tilePixelHeight;n.fx=a.getPixelWidth()/s.m_nWidthCanvas;n.fy=a.getPixelHeight()/s.m_nHeightCanvas;var p=s.m_Proj;n.ucs_min=p.m_nUCSMin*n.completeX;n.ucs_max=p.m_nUCSMax*n.completeX;n.ucs_compl=p.m_nXYRatio*n.completeX;n.ox=c.m_nCurrentX*n.tilePixelWidth+n.ucs_min;n.oy=c.m_nCurrentY*n.tilePixelHeight;n.factX=n.completeX*n.fx;n.factY=n.completeY*n.fy;n.addX=-n.ox*n.fx;n.addY=-n.oy*n.fy;s.m_CacheVars=n;};s.DestroyCacheDataObj=function(){s.m_CacheVars=undefined;};s.FillPositionCache=function(p,u){var n=s.m_CacheVars;var a=[1.0,1.0],c=[];var b=u?0:p[0];var d,e;var m=p[0],f=p[0];var g=p[1],h=p[1];var l=s.m_Proj.LonLatToUCS;var i=n.mul;for(var j=0,k=p.length;j<k;j+=3){d=p[j];e=p[j+1];while(d-b>180){d-=360;}while(b-d>180){d+=360;}if(d<m){m=d;}if(d>f){f=d;}if(e<g){g=e;}if(e>h){h=e;}a=l([i*d,i*e],[1.0,1.0]);c.push(a[0],a[1],0);if(!u){b=d;}}p.cache={data:c,ref:s.m_CacheVars,lt:l([i*m,i*h],[1.0,1.0]),rb:l([i*f,i*g],[1.0,1.0]),minLod:-Math.log(Math.max(f-m,h-g))/Math.log(2)};};s.GetVOExtension=function(p){if(p.cache==undefined){s.FillPositionCache(p);}return p.cache.BB;};s.GetPointArrayFromPosArrayWCache=function(p){if(p.cache==undefined){s.FillPositionCache(p);}return p.cache.data;};s.GetPointFromUCSPoint=function(p){var n=s.m_CacheVars;return[p[0]*n.factX+n.addX,p[1]*n.factY+n.addY];};s.GetPointArrayFromUCSArray=function(p){var n=s.m_CacheVars;var f=n.factX,a=n.factY;var b=n.addX,c=n.addY;var r=[];for(var d=0;d<=p.length-3;d+=3){r.push(p[d]*f+b,p[d+1]*a+c,0.0);}return r;};s.GetShortPointArrayFromUCSArray=function(p){var n=s.m_CacheVars;var f=n.factX,a=n.factY;var b=n.addX,c=n.addY;var r=[];for(var d=0;d<=p.length-3;d+=3){r.push(p[d]*f+b,p[d+1]*a+c);}return r;};s.GetPointArrayFromPosArray=function(p,a,i){var l=[0.0,0.0],r=[];var c=s.m_Canvas[0];var n=(1<<c.m_nCurrentLOD);var t=s.m_nWidthCanvas/s.m_nTilesX;var b=s.m_nHeightCanvas/s.m_nTilesY;var d=n*t;var e=n*b;var f=s.m_Canvas[s.m_nOverlayIndex];var g=i?1:f.getPixelWidth()/s.m_nWidthCanvas;var h=i?1:f.getPixelHeight()/s.m_nHeightCanvas;var j=s.m_Proj.LonLatToUCS;var u=[0,0],m=Math.PI/180.0;var k=s.m_Proj;var o=k.m_nUCSMin*d;var q=k.m_nUCSMax*d;var v=k.m_nXYRatio*d;var w=c.m_nCurrentX*t+o;var z=c.m_nCurrentY*b;var A,B;for(A=0,B=p.length;A<B;A+=3){l[0]=m*p[A];l[1]=m*p[A+1];u[0]=d;u[1]=e;u=j(l,u);u[0]=u[0]-w;u[1]=u[1]-z;if(a){while(u[0]<o){u[0]+=v;}while(u[0]>q){u[0]-=v;}}r.push(u[0]*g,u[1]*h,0.0);}if(B==1&&u){var x,y;r.m_bVisible=(((x=u[0])>0)&&((y=u[1])>0)&&(x<s.m_nWidthCanvas)&&(y<s.m_nHeightCanvas));}return r;};s.GetPointFromGeo=function(l,a){return s.GetPointArrayFromPosArray(VBI.MathLib.RadToDeg(l),a);};s.GetInstanceOffsets=function(r){var a=r.slice();var c=s.m_Canvas[0];var t=s.m_nWidthCanvas/s.m_nTilesX;var b=(1<<c.m_nCurrentLOD)*t*s.m_Proj.m_nXYRatio;var d=[0,0,s.m_nWidthCanvas,s.m_nHeightCanvas];var n=0;while(a[2]>0){--n;VBI.Utilities.RectOffset(a,-b,0);}var o=[];while(a[0]<s.m_nWidthCanvas){n++;VBI.Utilities.RectOffset(a,b,0);if(VBI.Utilities.RectIntersect(a,d)){o.push(n*b);}}return o;};s.GetCorrectedInstanceOffsets=function(r,z){var a=r.slice();var c=s.m_Canvas[0];var t=s.m_nWidthCanvas/s.m_nTilesX;var b=z[0]*(1<<c.m_nCurrentLOD)*t*s.m_Proj.m_nXYRatio;var d=[0,0,z[0]*s.m_nWidthCanvas,z[1]*s.m_nHeightCanvas];var n=0;while(a[2]>0){--n;VBI.Utilities.RectOffset(a,-b,0);}var o=[];while(a[0]<s.m_nWidthCanvas){n++;VBI.Utilities.RectOffset(a,b,0);if(VBI.Utilities.RectIntersect(a,d)){o.push(n*b);}}return o;};s.GetPosFromVPPoint=function(p){var c=s.m_Canvas[s.m_nOverlayIndex];var a=[p[0]-c.getPixelLeft(),p[1]-c.getPixelTop(),0];var t=this.GetGeoFromPoint(a);return VBI.MathLib.RadToDeg(t);};s.GetPosFromPoint=function(p){var t=this.GetGeoFromPoint(p);return VBI.MathLib.RadToDeg(t);};s.GetGeoFromPoint=function(p){var c=s.m_Canvas[0];var n=c.m_nCurrentLOD;var a=(1<<n);var b=p[0]*s.m_nWidthCanvas/c.getPixelWidth();var d=p[1]*s.m_nHeightCanvas/c.getPixelHeight();var t=s.m_nWidthCanvas/s.m_nTilesX;var e=s.m_nHeightCanvas/s.m_nTilesY;var f=c.m_nCurrentX*t;var g=c.m_nCurrentY*e;var h=f+b;var i=g+d;var j=a*t;var k=a*e;var l=[0,0];var u=[h/j*2.0-1.0,i/k*2.0-1.0];return s.m_Proj.UCSToLonLat(u,l);};};
},
	"sap/ui/vbm/lib/sapprojection.js":function(){
VBI.LinearProjection=function(t){"use strict";var p={};p.vbiclass="Projection/Linear";p.m_nXYRatio=2;p.m_nXMin=-2;p.m_nXMax=2;p.m_nGeometrySize=4;p.m_nUCSMin=-0.5;p.m_nUCSMax=1.5;p.m_bIsIsogonal=true;p.LonLatToUCS=function(l,u){var x=u[0];var y=u[1];u[0]=x*(0.5+l[0]/Math.PI);u[1]=y*(0.5-l[1]/Math.PI);return u;};p.UCSToLonLat=function(u,l){l[0]=Math.PI*(p.m_nUCSMin+u[0]/2);l[1]=-Math.PI*(u[1]/2);return l;};return p;};
VBI.MercatorProjection=function(t){"use strict";var p={};p.vbiclass="Projection/Mercator";p.m_nXYRatio=1;p.m_nXMin=-1;p.m_nXMax=1;p.m_nGeometrySize=2;p.m_nUCSMin=0;p.m_nUCSMax=1;p.m_bIsIsogonal=true;p.LonLatToUCS=VBI.MathLib.LonLatToUCS;p.UCSToLonLat=VBI.MathLib.UCSToLonLat;return p;};
VBI.ElliMercatorProjection=function(t){"use strict";var p={};p.vbiclass="Projection/EllipticalMercator";p.m_nXYRatio=1;p.m_nXMin=-1;p.m_nXMax=1;p.m_nGeometrySize=2;p.m_nUCSMin=0;p.m_nUCSMax=1;p.m_bIsIsogonal=true;p.m_rmajor=6378137;p.m_rminor=6356752.3142;var r=p.m_rminor/p.m_rmajor;p.m_eccent=Math.sqrt(1.0-(r*r));p.m_halfEccent=0.5*p.m_eccent;p.m_PI_Div_180=Math.PI/180.0;p.m_PI_Div_2=Math.PI/2;p.m_PI_Div_4=Math.PI/4;p.m_majMultPIDiv180=p.m_PI_Div_180*p.m_rmajor;p.m_tolerance=0.0000000001;p.m_EllipticalBorder=89.5*p.m_PI_Div_180;p.m_PIx2=2.0*Math.PI;p.m_yMax=2.0*Math.PI*p.m_rmajor;p.LonLatToUCS=function(l,u){var a=l[0],b=Math.max(Math.min(l[1],p.m_EllipticalBorder),-p.m_EllipticalBorder);var c=p.m_eccent*Math.sin(b);c=Math.pow((1-c)/(1+c),p.m_halfEccent);var x=0.5+a/p.m_PIx2;var y=0.5+Math.log(Math.tan(p.m_PI_Div_4-b/2)/c)/p.m_PIx2;u[0]=u[0]*x;u[1]=u[1]*y;return u;};p.UCSToLonLat=function(u,l){l[0]=Math.PI*u[0];l[1]=this.CalcPhi(Math.exp(Math.PI*u[1]));return l;};p.CalcPhi=function(a){var j=15,d,c,b=p.m_PI_Div_2-2.0*Math.atan(a);do{c=p.m_eccent*Math.sin(b);d=p.m_PI_Div_2-2.0*Math.atan(a*Math.pow((1.0-c)/(1.0+c),p.m_halfEccent))-b;b+=d;}while(Math.abs(d)>p.m_tolerance&&--j);return b;};return p;};
},
	"sap/ui/vbm/lib/saprecttrack.js":function(){
VBI.addSceneRectangularTrackingFunctions=function(s){"use strict";s.RectangularTracking=function(){this.m_PosStart=null;this.m_PosMove=null;this.m_bTrack=false;this.m_keycode=0;};s.RectangularTracking.prototype.onsapkeydown=function(e){if(e.keyCode==this.m_keycode){this.ExitMode();e.preventDefault();return true;}};s.RectangularTracking.prototype.onsapdown=function(e){var r=s.m_Canvas[s.m_nOverlayIndex].getBoundingClientRect();this.m_PosStart=s.GetPosFromPoint([e.clientX-r.left,e.clientY-r.top,0]);this.m_bTrack=true;if(e.type=="mousedown"){document.addEventListener('mouseup',this,true);}else if(e.type=="touchstart"){document.addEventListener('touchend',this,true);}else if(e.type=="pointerdown"){document.addEventListener('pointerup',this,true);}e.preventDefault();s.m_Canvas[s.m_nLabelIndex].focus({preventScroll:true});return true;};s.RectangularTracking.prototype.handleEvent=function(e){if(e.type=="mouseup"){document.removeEventListener('mouseup',this,true);}else if(e.type=="touchend"){document.removeEventListener('touchend',this,true);}else if(e.type=="pointerup"){document.removeEventListener('pointerup',this,true);if(s.m_Gesture){s.m_Gesture.pointerCount--;if(!s.m_Gesture.pointerCount){s.m_Gesture.target=null;s.m_Gesture=null;}}}this.TrackEnd(e);};s.RectangularTracking.prototype.TrackEnd=function(e){if(!this.m_bTrack){return false;}if(this.m_PosStart&&this.m_PosMove){this.execute(e);}this.m_PosStart=null;this.m_PosMove=null;this.m_bTrack=false;s.RenderAsync(true);e.preventDefault();e.stopPropagation();return true;};s.RectangularTracking.prototype.onsapmove=function(e){if(this.m_bTrack){var r=s.m_Canvas[s.m_nOverlayIndex].getBoundingClientRect();this.m_PosMove=s.GetPosFromPoint([e.clientX-r.left,e.clientY-r.top,0]);}s.SetCursor('crosshair');s.RenderAsync(true);e.preventDefault();return true;};s.RectangularTracking.prototype.onsapout=function(e){};s.RectangularTracking.prototype.execute=function(e){};s.RectangularTracking.prototype.Hook=function(i){s.SetInputMode(i);if(i==VBI.InputModeRectSelect){s.m_Ctx.m_Control.setProperty("rectangularSelection",true,true);}else{s.m_Ctx.m_Control.setProperty("rectZoom",true,true);}s.m_DesignVO=this;s.SetCursor('crosshair');s.RenderAsync(true);};s.RectangularTracking.prototype.UnHook=function(){if(s.m_nInputMode==VBI.InputModeRectSelect||s.m_nInputMode==VBI.InputModeRectZoom){s.m_Ctx.onChangeTrackingMode(s.m_nInputMode,false);if(s.m_nInputMode==VBI.InputModeRectSelect){s.m_Ctx.m_Control.setProperty("rectangularSelection",false,true);}else{s.m_Ctx.m_Control.setProperty("rectZoom",false,true);}s.SetInputMode(VBI.InputModeDefault);}else{jQuery.sap.log.error("Wrong InputMode in UnHook: "+s.m_nInputMode);}this.m_PosStart=null;this.m_PosMove=null;this.m_bTrack=false;s.m_DesignVO=null;s.RenderAsync(true);};s.RectangularTracking.prototype.ExitMode=function(){this.UnHook();s.SetCursor('default');s.RenderAsync(true);};s.RectangularZoom=function(){s.RectangularTracking.call(this);this.m_keycode=90;this.Hook(VBI.InputModeRectZoom);};s.RectangularZoom.prototype=Object.create(s.RectangularTracking.prototype);s.RectangularZoom.prototype.constructor=s.RectangularZoom;s.RectangularZoom.prototype.execute=function(e){var l=[];var a=[];l[0]=this.m_PosStart[0];l[1]=this.m_PosMove[0];a[0]=this.m_PosStart[1];a[1]=this.m_PosMove[1];s.ZoomToMultiplePositions(l,a,1.0);};s.RectangularZoom.prototype.Render=function(c,d){if(!this.m_bTrack){return false;}if(this.m_PosMove&&this.m_PosStart){var p=s.GetPointFromPos(this.m_PosStart,false);var a=s.GetPointFromPos(this.m_PosMove,false);var b=a.slice(0);var C=a[0]-p[0];var e=a[1]-p[1];var r=s.GetInternalDivClientRect();var f=Math.abs(r.width/r.height);var g=Math.abs(C/e);var h=0;var w=0;if(g<f){w=a[0]-p[0];h=w/f;if(a[0]<p[0]&&a[1]>p[1]||a[0]>p[0]&&a[1]<p[1]){b[1]=p[1]-h;}else{b[1]=p[1]+h;}}else{h=a[1]-p[1];w=f*h;if(a[0]<p[0]&&a[1]>p[1]||a[0]>p[0]&&a[1]<p[1]){b[0]=p[0]-w;}else{b[0]=p[0]+w;}}VBI.Utilities.DrawTrackingRect(d,p[0],p[1],b[0],b[1]);var z=s.GetStretchFactor4Mode();b[0]*=z[0];b[1]*=z[1];this.m_PosMove=s.GetPosFromPoint([b[0],b[1]]);}};s.RectSelection=function(){s.RectangularTracking.call(this);this.m_keycode=82;this.Hook(VBI.InputModeRectSelect);};s.RectSelection.prototype=Object.create(s.RectangularTracking.prototype);s.RectSelection.prototype.constructor=s.RectSelection;s.RectSelection.prototype.execute=function(e){var p=s.GetPointFromPos(this.m_PosStart,false);var a=s.GetPointFromPos(this.m_PosMove,false);var b=[];var c=[];var n;for(n=0;n<=1;n++){if(p[n]<a[n]){b[n]=p[n];c[n]=a[n];}else{b[n]=a[n];c[n]=p[n];}}var z=s.GetStretchFactor4Mode();b[0]/=z[0];c[0]/=z[0];b[1]/=z[1];c[1]/=z[1];this.selectionRect=[b[0],b[1],c[0],c[1]];s.PerFormMultiSelect(e,this);};s.RectSelection.prototype.Render=function(c,d){if(!this.m_bTrack){return false;}if(this.m_PosMove&&this.m_PosStart){var p=s.GetPointFromPos(this.m_PosStart,false);var a=s.GetPointFromPos(this.m_PosMove,false);VBI.Utilities.DrawTrackingRect(d,p[0],p[1],a[0],a[1]);}};};
},
	"sap/ui/vbm/lib/sapresources.js":function(){VBI.ResourceManager=(function(){"use strict";var r={};r.m_DummyData="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";return r;})();
VBI.Resources=function(){"use strict";var r={};r.m_resourcedata=[];r.m_resourceinstance=[];r.clear=function(){r.m_resourcedata=[];r.m_resourceinstance=[];};r.load=function(d,c){if(d.Set){r.clear();var a=d.Set.Resource;if(jQuery.type(a)=='object'){r.m_resourcedata[a.name]=a.value;}else if(jQuery.type(a)=='array'){for(var n=0,l=a.length;n<l;++n){r.m_resourcedata[a[n].name]=a[n].value;}}}};r.GetData=function(n){return r.m_resourcedata[n];};r.GetImageBits=function(n,a,b,l){var c,d=n;if(a){d+=a;}if(b){d+=b;}c=r.m_resourceinstance[n];if(c&&c.m_Bits){return([c.m_Bits,c.m_Image.naturalWidth,c.m_Image.naturalHeight]);}var i=r.GetImage(n,null,null,l);if(i){var e=VBI.Utilities.GetImagePixelData(i).data;r.m_resourceinstance[n].m_Bits=e;return([r.m_resourceinstance[n].m_Bits,i.naturalWidth,i.naturalHeight]);}return null;};r.GetImage=function(n,a,b,l){var c,d;var i="";if(n!=undefined){var e=n.lastIndexOf(".");if(e>=0){i="/"+n.substring(e+1);}}var f=n;if(a){f+=a;}if(b){f+=b;}c=r.m_resourceinstance[f];if(c&&c.m_Image){return c.m_Image;}if(c){if(a||b){c.m_Image=VBI.Utilities.CreateDOMColorShiftedImageFromData(r.m_resourcedata[n],i,a,b,l);return(c.m_Image);}c.m_Image=VBI.Utilities.CreateDOMImageFromData(r.m_resourcedata[n],i,l);return(c.m_Image);}else{var R=(d=r.m_resourcedata[n]);if(!R){if(VBI.m_bTrace){VBI.Trace("resource not found; default image loaded");}i='/png';d=VBI.ResourceManager.m_DummyData;}if(a||b){r.m_resourceinstance[f]={m_Image:VBI.Utilities.CreateDOMColorShiftedImageFromData(d,i,a,b,l)};return r.GetImage(n,null,null,l);}return(r.m_resourceinstance[f]={m_Image:VBI.Utilities.CreateDOMImageFromData(d,i,l)}).m_Image;}};return r;};
},
	"sap/ui/vbm/lib/sapscale.js":function(){VBI.SupportedUnitsOfLength=[{RequestedUnit:"km",DisplayUnitDefault:"m",DisplayUnit2:"km",ConvFactor:1000.0,ConvFactorMeter:1.0},{RequestedUnit:"mi",DisplayUnitDefault:"ft",DisplayUnit2:"mi",ConvFactor:5280.0,ConvFactorMeter:0.3048},{RequestedUnit:"nm",DisplayUnitDefault:"ft",DisplayUnit2:"nm",ConvFactor:6076.12,ConvFactorMeter:0.3048}];
VBI.Scale=function(){"use strict";var s={};s.scene=null;s.m_ID=null;s.m_Image=null;s.m_CurrentUnit=null;s.m_DisplayUnit=null;s.m_nDivider=0;s.m_nScalerLength=0;s.m_nDistance=0;s.m_bRtl=false;s.clear=function(){var i=document.getElementById(s.m_canvas.id);if(i){i.parentNode.removeChild(i);}s.m_Image=null;s.scene=null;};s.Awake=function(a,t){s.scene=a;var l=jQuery.sap.byId(t);s.m_ID=jQuery(l).attr('id');s.AppendCanvas();};s.getId=function(a,b){return b+'-'+a;};s.AppendCanvas=function(){s.m_bRtl=(document.dir=='rtl')?true:false;s.m_canvas=document.createElementNS("http://www.w3.org/2000/svg","svg");s.m_canvas.setAttribute("class","vbi-scale");s.m_canvas.setAttribute("id",s.getId('vbi-scale-canvas',s.m_ID));s.m_canvas.m_VBIType="S";s.scene.m_MapDecoDiv.appendChild(s.m_canvas);};s.getConfig=function(){if(s.m_CurrentUnit){return s.m_CurrentUnit;}else{var c=s.scene.m_Ctx;var a,u;if(c){a=c.GetConfig();}if(a){u=a.GetData("UnitOfLength");}if(u){for(var n=0;n<VBI.SupportedUnitsOfLength.length;++n){if(VBI.SupportedUnitsOfLength[n].RequestedUnit==u){s.m_CurrentUnit=VBI.SupportedUnitsOfLength[n];break;}}}}if(!s.m_CurrentUnit){s.m_CurrentUnit=VBI.SupportedUnitsOfLength[0];}return s.m_CurrentUnit;};s.getImage=function(l){if(s.m_Image){return s.m_Image;}var i=new Image();if(l){i.onload=function(){if(typeof l==='function'){l(i);}this.onload=null;};}i.src=sap.ui.resource("sap.ui.vbm","themes/base/img/sapvisualbusiness.png");s.m_Image=i;return i;};s.CalcScaleDimensions=function(){if(s.scene.m_Canvas[0].m_nCurrentLOD<1){return false;}var r=s.scene.GetInternalDivClientRect();var c=s.getConfig();var p=[parseInt(r.width/2-75,10),parseInt(r.height/2,10)];var a=[p[0]+180,p[1]];var d=s.scene.GetDistance(p,a);var b;d=d*(1.0/c.ConvFactorMeter);if(d>=c.ConvFactor){b=parseInt(d/c.ConvFactor,10);s.m_DisplayUnit=c.DisplayUnit2;}else{b=d;s.m_DisplayUnit=c.DisplayUnitDefault;}var l=parseInt(Math.log(b)/Math.LN10,10);b=parseInt(b/Math.pow(10,l),10);if(b<2){b=1;}else if(b<5){b=2;}else if(b<10){b=5;}b=parseInt(b*Math.pow(10,l),10);var e;if(d>=c.ConvFactor){e=b*c.ConvFactor;e=e*c.ConvFactorMeter;}else{e=b*c.ConvFactorMeter;}var f=s.scene.GetTargetPointForDistance(e,p);var g=[f[0]+s.scene.m_Canvas[0].getPixelLeft(),f[1]+s.scene.m_Canvas[0].getPixelTop()];var t=b;var n=0;while(n==0&&t>0){n=t%5;t/=10;}if(n!=2){n=5;}var h=Math.round(g[0]-p[0]);if(h>60&&h<(r.right-r.left)){s.m_nScalerLength=h;s.m_nDistance=b;s.m_nDivider=n;return true;}return false;};s.Update=function(){s.CalcScaleDimensions();var p=(s.m_nScalerLength+s.m_nDivider)/2,d=s.m_nDistance/2;var a=document.getElementById(s.m_canvas.id);if(a){a.setAttribute("height",15);a.setAttribute("width",p+1);jQuery(a).empty();var b=document.createElementNS("http://www.w3.org/2000/svg","path");b.setAttribute("d","M 1 4 V 10 H "+p+" V 4");b.setAttribute("stroke","black");b.setAttribute("stroke-width",2);b.setAttribute("fill","none");a.appendChild(b);var t=document.createElementNS("http://www.w3.org/2000/svg","text");var c;if(document.dir==="rtl"){c=(d.toString().length+s.m_DisplayUnit.length+1)*6+2;}else{c=p-2-(d.toString().length+s.m_DisplayUnit.length+1)*6;}t.setAttribute("x",c);t.setAttribute("y",8);t.setAttribute("font-size",10);t.textContent=d+" "+s.m_DisplayUnit;a.appendChild(t);}};return s;};
},
	"sap/ui/vbm/lib/saputilities.js":function(){VBI.Utilities=VBI.Utilities||{};
HTMLCanvasElement.prototype.getPixelWidth=function(){"use strict";if(this.m_pixelWidth){return this.m_pixelWidth;}if(this.style.pixelWidth!==undefined){return this.style.pixelWidth;}return parseInt(this.style.width,10);};
HTMLCanvasElement.prototype.getPixelHeight=function(){"use strict";if(this.m_pixelHeight){return this.m_pixelHeight;}if(this.style.pixelHeight!==undefined){return this.style.pixelHeight;}return parseInt(this.style.height,10);};
HTMLCanvasElement.prototype.getPixelLeft=function(){"use strict";if(this.m_pixelLeft){return this.m_pixelLeft;}if(this.style.pixelLeft!==undefined){return this.style.pixelLeft;}return parseInt(this.style.left,10);};
HTMLCanvasElement.prototype.getPixelTop=function(){"use strict";if(this.m_pixelTop){return this.m_pixelTop;}if(this.style.pixelTop!==undefined){return this.style.pixelTop;}return parseInt(this.style.top,10);};
HTMLCanvasElement.prototype.setPixelWidth=function(v){"use strict";this.m_pixelWidth=v;if(this.style.pixelWidth!==undefined){this.style.pixelWidth=v;}else{this.style.width=v+'px';}};
HTMLCanvasElement.prototype.setPixelHeight=function(v){"use strict";this.m_pixelHeight=v;if(this.style.pixelHeight!==undefined){this.style.pixelHeight=v;}else{this.style.height=v+'px';}};
HTMLCanvasElement.prototype.setPixelLeft=function(v){"use strict";this.m_pixelLeft=v;if(this.style.pixelLeft!==undefined){this.style.pixelLeft=v;}else{this.style.left=v+'px';}};
HTMLCanvasElement.prototype.setPixelTop=function(v){"use strict";this.m_pixelTop=v;if(this.style.pixelTop!==undefined){this.style.pixelTop=v;}else{this.style.top=v+'px';}};
VBI.Utilities.CreateWifiObject=function(){"use strict";var n=document.createElement('object');if(!n){return null;}n.classid="CLSID:00100000-2013-0070-2000-651572487E69";return n;};
VBI.Utilities.CreateDOMElement=function(t,i,w,h){"use strict";var n=document.createElement(t);n.style.height=w?w:"1px";n.style.width=h?h:"1px";n.id=i;return n;};
VBI.Utilities.GetDOMElement=function(a){"use strict";var e=[];for(var i=0,l=arguments.length;i<l;i++){var b=arguments[i];if(typeof b=='string'){b=document.getElementById(b);}if(arguments.length==1){return b;}e.push(b);}return e;};
VBI.Utilities.CreateDOMVBIDivElement=function(i,w,h){"use strict";var n=document.createElement('div');n.id=i;n.style.height="300x";n.style.width="300px";n.style.overflow="hidden";n.style.position="absolute";n.style.left="0px";n.style.top="0px";return n;};
VBI.Utilities.Create3DSceneDiv=function(i){"use strict";var n=document.createElement('div');n.id=i;n.style.left="0px";n.style.top="0px";n.style.width="100%";n.style.height="100%";n.style.position="relative";n.style.overflow="hidden";return n;};
VBI.Utilities.Create3DSceneCanvas=function(i,w,h,z,t,a){"use strict";var n=document.createElement('canvas');n.id=i;n.m_pixelLeft=n.m_pixelTop=0;n.width=n.m_pixelWidth=w?w:512;n.height=n.m_pixelHeight=h?h:512;n.style.left=n.style.top="0px";n.style.width=n.m_pixelWidth+"px";n.style.height=n.m_pixelHeight+"px";n.style.position="absolute";n.style.zIndex=z;n.style.touchaction="none";n.className="vbi-3Dscenecanvas";n.m_bNotInDOM=(a!=undefined?a:false);n.m_CanvasValid=!n.m_bNotInDOM;if(n.m_bNotInDOM){n.m_nMoveCount=0;}if(t!=undefined){n.tabIndex=t;}return n;};
VBI.Utilities.CreateGeoSceneCanvas=function(i,w,h,t,a,b,c){"use strict";var n=document.createElement('canvas');n.id=i;n.m_pixelLeft=n.m_pixelTop=0;n.width=n.m_pixelWidth=w?w:512;n.height=n.m_pixelHeight=h?h:512;n.style.left=n.style.top="0px";n.style.width=n.m_pixelWidth+"px";n.style.height=n.m_pixelHeight+"px";n.style.position="absolute";n.style.touchaction="none";n.className="vbi-geoscenecanvas";if(b){n.className+=" "+b;}if(c){n.setAttribute("aria-label",c);}n.m_bNotInDOM=(a!=undefined?a:false);n.m_CanvasValid=!n.m_bNotInDOM;n.m_VBIType="L";if(n.m_bNotInDOM){n.m_nMoveCount=0;}if(t!=undefined){n.tabIndex=t;}return n;};
VBI.Utilities.Align=['','left','center','','right'];
VBI.Utilities.CreateCaption=function(i,t,l,a,r,b,c,d,e,f){"use strict";var n=document.createElement('div');n.id=i;n.style.left=l+"px";n.style.top=a+"px";n.style.width=(r-l).toString()+"px";n.style.height=(b-a).toString()+"px";n.style.textAlign=VBI.Utilities.Align[f];n.style.title=c;switch(e){case 3:n.style.fontSize="14px";n.style.fontWeight="bold";break;}n.className="vbi-2d-caption vbi-2d-common";n.innerHTML=t;return n;};
VBI.Utilities.CreateLabel=function(i,t,l,a,r,b,c,d){"use strict";var n=document.createElement('div');n.id=i;n.style.left=l+"px";n.style.top=a+"px";n.style.width=(r-l).toString()+"px";n.style.height=(b-a).toString()+"px";n.style.textAlign=VBI.Utilities.Align[d];n.style.title=c;n.className="vbi-2d-label vbi-2d-common";n.innerHTML=t;return n;};
VBI.Utilities.CreateLink=function(i,t,l,a,r,b,h,c,d){"use strict";var n=document.createElement('a');n.id=i;n.style.left=l+"px";n.style.top=a+"px";n.style.width=(r-l).toString()+"px";n.style.height=(b-a).toString()+"px";n.style.textAlign=VBI.Utilities.Align[d];n.className="vbi-2d-link vbi-2d-common";n.href=h?h:"javascrip"+"t:void(0)";n.title=c;n.innerHTML=t;return n;};
VBI.Utilities.CreateImage=function(i,a,l,t,r,b,c,d){"use strict";var n=a.cloneNode(true);n.id=i;n.style.left=l+"px";n.style.top=t+"px";n.style.width=(r-l).toString()+"px";n.style.height=(b-t).toString()+"px";n.style.textAlign=VBI.Utilities.Align[d];n.className="vbi-2d-image vbi-2d-common";n.title=c;return n;};
VBI.Utilities.CreateButton=function(i,t,l,a,r,b,c,d){"use strict";var n=document.createElement('button');n.id=i;n.style.left=l+"px";n.style.top=a+"px";n.style.width=(r-l).toString()+"px";n.style.height=(b-a).toString()+"px";n.style.textAlign=VBI.Utilities.Align[d];n.className="vbi-2d-button vbi-2d-common";n.innerHTML=t;n.title=c;return n;};
VBI.Utilities.CreateContainer=function(i,k,l,t,w,h,a,o){"use strict";var n=document.createElement('div');n.id=i;n.style.left=l+"px";n.style.top=t+"px";n.title=a;n.style.position="absolute";if(!o){n.className="vbi-container-vo";}n.m_Key=k;return n;};
VBI.Utilities.CreateDetailPhone=function(i,l,t,w,h,a,p){"use strict";var d=document.createElement('div');d.id=i;d.style.left=l+"px";d.style.top=t+"px";var b=12;var s=6;var c=14;b=VBI.Utilities.RemToPixel(0.750);s=VBI.Utilities.RemToPixel(0.375);c=VBI.Utilities.RemToPixel(0.875);if(h){d.style.minHeight=h+c+4+s+2*b+"px";}d.className=".vbi-detail vbi-detail-phone";var e=document.createElement('div');e.id=i+"-window-header";e.className="vbi-detail-header-phone";d.appendChild(e);var f=document.createElement('div');f.id=i+"-window-title";f.className="vbi-detail-title-phone";f.innerHTML=a;e.appendChild(f);var g=document.createElement('div');g.id=i+"-window-close";g.className="vbi-detail-closebutton vbi-detail-closebutton-tablet";e.appendChild(g);var j=document.createElement('div');j.id=i+"-window-content";j.className="vbi-detail-content";j.style.fontSize=VBI.Utilities.RemToPixel(0.875)+"px";d.appendChild(j);return{m_Div:d,m_Content:j,m_CloseButton:g,m_Arrow:null,GetAnchorPoint:null};};
VBI.Utilities.CreateDetail=function(i,l,t,w,h,a,p){"use strict";if(VBI.m_bIsPhone){return(VBI.Utilities.CreateDetailPhone(i,l,t,w,h,a,p));}var d=document.createElement('div');d.id=i;d.style.left=l+"px";d.style.top=t+"px";var P=VBI.m_bIsPhone;if(!P){var b=16;var s=16;var c=16;b=VBI.Utilities.RemToPixel(1);s=VBI.Utilities.RemToPixel(1);c=VBI.Utilities.RemToPixel(1);if(w){d.style.width=w+2*b+"px";}if(h){d.style.minHeight=h+c+4+s+2*b+"px";}}else{var e=12;var f=6;var g=14;e=VBI.Utilities.RemToPixel(0.750);f=VBI.Utilities.RemToPixel(0.375);g=VBI.Utilities.RemToPixel(0.875);if(h){d.style.minHeight=h+g+4+f+2*e+"px";}}d.className="vbi-detail vbi-detail-border";var j=document.createElement('div');j.id=i+"-window-header";j.className="vbi-detail-header";d.appendChild(j);var k=document.createElement('div');k.id=i+"-window-title";k.className="vbi-detail-title";k.innerHTML=a;j.appendChild(k);var m=document.createElement('div');m.id=i+"-window-close";var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.vbm.i18n");m.title=r.getText("WINDOW_CLOSE");m.className="vbi-detail-closebutton vbi-detail-closebutton-"+(VBI.m_bIsMobile?"tablet":"desktop");j.appendChild(m);var n=document.createElement('div');n.id=i+"-window-content";n.className="vbi-detail-content";d.appendChild(n);var o=document.createElement('b');o.className="vbi-detail-arrow vbi-detail-left vbi-detail-border-arrow";if(!P){d.appendChild(o);}var q;q=document.createElement('b');q.className="vbi-detail-arrow vbi-detail-left";if(!P){d.appendChild(q);}return{m_Div:d,m_Content:n,m_CloseButton:m,m_Arrow:q,GetAnchorPoint:function(){if(VBI.m_bIsRtl){return[this.m_Arrow.offsetLeft+this.m_Arrow.offsetWidth+2,this.m_Arrow.offsetTop+this.m_Arrow.offsetHeight/2];}else{return[this.m_Arrow.offsetLeft,this.m_Arrow.offsetTop+this.m_Arrow.offsetHeight/2];}}};};
VBI.Utilities.CreateLegendPhone=function(i,l,t,w,h,a,p){"use strict";};
VBI.Utilities.CreateLegend=function(i,t,a,p,c){"use strict";var l=document.createElement('div');l.id=i;if(VBI.m_bIsRtl){l.style.left="0px";l.style.right="";}else{l.style.right="0px";l.style.left="";}l.style.top=t+"px";l.className="vbi-legend";var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.vbm.i18n");var b=document.createElement('div');b.id=i+"-button-collapse";b.title=r.getText("LEGEND_COLLAPSE");b.className="vbi-legend-button vbi-legend-button-col";l.appendChild(b);var d=document.createElement('div');d.id=i+"-button-expand";d.title=r.getText("LEGEND_EXPAND");d.className="vbi-legend-button vbi-legend-button-exp";l.appendChild(d);d.style.visibility='hidden';var h=document.createElement('div');h.id=i+"-header";h.className="vbi-legend-header";l.appendChild(h);var e=document.createElement('div');e.id=i+"-title";e.className="vbi-legend-title";e.innerHTML=a;h.appendChild(e);var f=document.createElement('div');f.id=i+"-content";f.className="vbi-legend-content";l.appendChild(f);var g=document.createElement('table');g.id=i+"-table";g.className=c?"vbi-legend-table vbi-legend-table-click":"vbi-legend-table";f.appendChild(g);return{m_Div:l,m_Header:h,m_Content:f,m_Table:g,m_ButtonCol:b,m_ButtonExp:d};};
VBI.Utilities.CreateGeoSceneDivCSS=function(i,c,t){"use strict";var n=document.createElement('div');n.id=i;if(c){n.className=c;}if(t){n.title=t;}return n;};
VBI.Utilities.CreateDOMColorShiftedImageFromData=function(d,i,c,e,l){"use strict";var f=null,h=c?VBI.Types.string2rhls(c):null;if(!h){f=c?VBI.Types.string2rgba(c):null;}var j=null,k=e?VBI.Types.string2rhls(e):null;if(!k){j=e?VBI.Types.string2rgba(e):null;}var t=document.createElement('img');var m=document.createElement('img');if(l){t.onload=function(){if(typeof l==='function'){l(t);}this.onload=null;};m.onload=function(){var n=document.createElement("canvas");var o=n.getContext("2d");n.width=m.width;n.height=m.height;o.drawImage(m,0,0,m.naturalWidth,m.naturalHeight,0,0,m.width,m.height);var p=o.getImageData(0,0,m.width,m.height);var d=p.data;function q(d,v,w,x){var r=d[v];var g=d[v+1];var b=d[v+2];var a=d[v+3];if(w){var y=VBI.Utilities.RGB2HLS(r,g,b);var z=VBI.Utilities.HLS2RGB(y[0]+w[0],y[1]*w[1],y[2]*w[2]);d[v]=Math.min(Math.round(z[0]),255);d[v+1]=Math.min(Math.round(z[1]),255);d[v+2]=Math.min(Math.round(z[2]),255);d[v+3]=Math.min(Math.round(w[3]*a),255);}else if(x){d[v]=x[0];d[v+1]=x[1];d[v+2]=x[2];if(d[v+3]){d[v+3]=x[4]?Math.floor(Math.min(x[3]*255,255)):255;}}}for(var s=0,u=(m.width*m.height);s<u;++s){var v=s*4;if(h||f){q(d,v,h,f);}if(k||j){q(d,v,k,j);}}o.putImageData(p,0,0);t.src=n.toDataURL("image/png");this.onload=null;};}m.src=((d.indexOf("data:image")==0)?d:("data:image"+i+";base64,"+d));return t;};
VBI.Utilities.CreateDOMImageFromData=function(d,i,l){"use strict";var a=document.createElement('img');if(l){a.onload=function(){if(typeof l==='function'){l(a);}this.onload=null;};}a.src=((d.indexOf("data:image")==0)?d:("data:image"+i+";base64,"+d));return a;};
VBI.Utilities.GetTransparentImage=function(){"use strict";var t="iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNgYAAAAAMAASsJTYQAAAAASUVORK5CYII=";if(!this.m_TransparentImage){this.m_TransparentImage=VBI.Utilities.CreateDOMImageFromData(t,'/png',null);this.m_TransparentImage.id="TransparentImage";}return this.m_TransparentImage;};
VBI.Utilities.PtOnRect=function(p,r){"use strict";return((p[0]>=r[0])&&(p[0]<=r[2])&&(p[1]>=r[1])&&(p[1]<=r[3]))?true:false;};
VBI.Utilities.PtInRect=function(p,r){"use strict";return((p[0]>r[0])&&(p[0]<r[2])&&(p[1]>r[1])&&(p[1]<r[3]))?true:false;};
VBI.Utilities.RectIntersect=function(r,a){"use strict";return!(a[0]>r[2]||a[2]<r[0]||a[3]<r[1]||a[1]>r[3]);};
VBI.Utilities.RectOffset=function(r,n,a){"use strict";r[0]+=n;r[1]+=a;r[2]+=n;r[3]+=a;};
VBI.Utilities.cImg;
VBI.Utilities.GetImagePixelData=function(i){"use strict";if(!VBI.Utilities.cImg){VBI.Utilities.cImg=document.createElement('canvas');}VBI.Utilities.cImg.width=i.naturalWidth;VBI.Utilities.cImg.height=i.naturalHeight;VBI.Utilities.cImg.style.width=(i.naturalWidth+"px");VBI.Utilities.cImg.style.height=(i.naturalHeight+"px");VBI.Utilities.cImg.style.top="0px";VBI.Utilities.cImg.style.left="0px";VBI.Utilities.cImg.style.position="absolute";var c=VBI.Utilities.cImg.getContext("2d");c.drawImage(i,0,0);var a=c.getImageData(0,0,VBI.Utilities.cImg.width,VBI.Utilities.cImg.height);return a;};
VBI.Utilities.pointOnLine=function(p,x,y,d,c){"use strict";function s(v,e){return((v[0]-e[0])*(v[0]-e[0])+(v[1]-e[1])*(v[1]-e[1]));}var r=-1,n=-1,a=d*d,b=a;var t,v,e;var f=VBI.Utilities.sqDistance;var g,l;for(g=0,l=p.length-1;g<l;++g){v=p[g];e=p[g+1];if((t=f(v[0],v[1],e[0],e[1],x,y))<a){a=t;r=g;}}if(r>=0){if((t=s([x,y],p[r]))<b){b=t;n=r;}if(s([x,y],p[r+1])<b){b=t;n=r+1;}}if(c&&(l>0)){v=p[0];e=p[l];if((t=f(v[0],v[1],e[0],e[1],x,y))<a){a=t;r=g;}if(r>=0){if((t=s([x,y],p[r]))<b){b=t;n=r;}if(s([x,y],p[0])<b){b=t;n=0;}}}return{m_edge:r,m_node:n};};
VBI.Utilities.polyInPolygon=function(o,i,O){"use strict";var h=false,I=false;for(var n=O.length-1;n>=0;--n){var a=O[n];h=false;if((VBI.Utilities.pointInPolygon(o,i[0][0]+a,i[0][1]))){h=true;for(var b=0;b<i.length&&h&&!I;++b){var p=[i[b][0]+a,i[b][1]];var c=(b+1==i.length)?[i[0][0]+a,i[0][1]]:[i[b+1][0]+a,i[b+1][1]];var d,e;I=false;for(var f=0;f<o.length;++f){d=o[f];e=(f+1==o.length)?o[0]:o[f+1];if((VBI.Utilities.LineLineIntersection(p,c,d,e,true))){I=true;}}}}if(h&&!I){break;}}return(h&&!I);};
VBI.Utilities.pointInPolygon=function(p,x,y){"use strict";var v,a,b=p.length;var c,n,l,h,d,e;if(jQuery.type(p[0])=='array'){if(jQuery.type(p[0][0])=='array'){c=this.pointInPolygon(p[0],x,y);if(c){for(h=false,e=1,b=p.length;!h&&e<b;++e){h=this.pointInPolygon(p[e],x,y);if(h){c=false;}}}}else{for(c=false,n=-1,l=b,d=l-1;++n<l;d=n){v=p[n];a=p[d];if(((v[1]<=y&&y<a[1])||(a[1]<=y&&y<v[1]))&&(x<(a[0]-v[0])*(y-v[1])/(a[1]-v[1])+v[0])){c=!c;}}}}else{for(c=false,n=0,l=b,d=l-2;n<=l-2;n+=2){v=[p[n],p[n+1]];a=[p[d],p[d+1]];if(((v[1]<=y&&y<a[1])||(a[1]<=y&&y<v[1]))&&(x<(a[0]-v[0])*(y-v[1])/(a[1]-v[1])+v[0])){c=!c;}d=n;}}return c;};
VBI.Utilities.pointInTriangle=function(t,p){"use strict";var a=t[2][0]-t[0][0];var b=t[2][1]-t[0][1];var c=t[1][0]-t[0][0];var d=t[1][1]-t[0][1];var e=p[0]-t[0][0];var f=p[1]-t[0][1];var g=a*a+b*b;var h=a*c+b*d;var i=a*e+b*f;var j=c*c+d*d;var k=c*e+d*f;var n=1/(g*j-h*h);var u=(j*i-h*k)*n;var v=(g*k-h*i)*n;return((u>=0)&&(v>=0)&&(u+v<1));};
VBI.Utilities.INSIDE=0;VBI.Utilities.LEFT=1;VBI.Utilities.RIGHT=2;VBI.Utilities.BOTTOM=4;VBI.Utilities.TOP=8;
VBI.Utilities.ComputeOutCode=function(x,y,r){"use strict";var a=r[0];var b=r[2];var c=r[1];var d=r[3];var e=VBI.Utilities.INSIDE;if(x<a){e|=VBI.Utilities.LEFT;}else if(x>b){e|=VBI.Utilities.RIGHT;}if(y<c){e|=VBI.Utilities.BOTTOM;}else if(y>d){e|=VBI.Utilities.TOP;}return e;};
VBI.Utilities.LineIntersectRect=function(a,b,c,d,r){"use strict";var R={};var e=r[0];var f=r[2];var g=r[1];var h=r[3];var n=VBI.Utilities.ComputeOutCode(a,b,r);var i=VBI.Utilities.ComputeOutCode(c,d,r);var A=false;var C=true;while(C){if(!(n|i)){A=true;break;}else if(n&i){break;}else{var x,y;var j=n?n:i;if(j&VBI.Utilities.TOP){x=a+(c-a)*(h-b)/(d-b);y=h;}else if(j&VBI.Utilities.BOTTOM){x=a+(c-a)*(g-b)/(d-b);y=g;}else if(j&VBI.Utilities.RIGHT){y=b+(d-b)*(f-a)/(c-a);x=f;}else if(j&VBI.Utilities.LEFT){y=b+(d-b)*(e-a)/(c-a);x=e;}if(j==n){a=x;b=y;n=VBI.Utilities.ComputeOutCode(a,b,r);}else{c=x;d=y;i=VBI.Utilities.ComputeOutCode(c,d,r);}}}R.bReturn=false;if(A){R.x0=a;R.y0=b;R.x1=c;R.y1=d;R.bReturn=true;}return R;};
VBI.Utilities.LineLineIntersection=function(p,a,q,b,s){"use strict";var A=a[1]-p[1];var B=p[0]-a[0];var C=A*p[0]+B*p[1];var c=b[1]-q[1];var d=q[0]-b[0];var e=c*q[0]+d*q[1];var f=A*d-c*B;if(!f){return null;}var n=[(d*C-B*e)/f,(A*e-c*C)/f];if(s){var g=[],h=[],i=[],j=[];for(var k=0;k<=1;++k){if(p[k]<a[k]){g[k]=p[k];h[k]=a[k];}else{g[k]=a[k];h[k]=p[k];}if(q[k]<b[k]){i[k]=q[k];j[k]=b[k];}else{i[k]=b[k];j[k]=q[k];}}if(n[0]>=g[0]&&n[0]<=h[0]&&n[0]>=i[0]&&n[0]<=j[0]&&n[1]>=g[1]&&n[1]<=h[1]&&n[1]>=i[1]&&n[1]<=j[1]){return true;}else{return false;}}return[(d*C-B*e)/f,(A*e-c*C)/f];};
VBI.Utilities.IsClockwise=function(p){"use strict";var l=p.length;if(p.length%2){l-=1;}var x,a,y,b,z;z=0;x=p[l-2];y=p[l-1];for(var n=0;n<l;n+=2){a=p[n];b=p[n+1];z+=(a-x)*(b+y);x=a;y=b;}return(z<0);};
VBI.Utilities.GetClippedPolygon=function(p,X,r){"use strict";var o=X;var a=p.slice(0);var i=[];var b;for(var n=0;n<=3;++n,o=0){i=a.slice(0);a=[];var t=[i[i.length-2],i[i.length-1]];var S=[t[0]+o,t[1]];for(var c=0;c<=i.length-2;c+=2){t=[i[c],i[c+1]];var E=[t[0]+o,t[1]];var e=false;var s=false;var d=[];switch(n){case 0:e=(E[1]>r[1]);s=(S[1]>r[1]);d=[[r[0],r[1]],[r[2],r[1]]];break;case 1:e=(E[0]<r[2]);s=(S[0]<r[2]);d=[[r[2],r[1]],[r[2],r[3]]];break;case 2:e=(E[1]<r[3]);s=(S[1]<r[3]);d=[[r[0],r[3]],[r[2],r[3]]];break;case 3:e=(E[0]>r[0]);s=(S[0]>r[0]);d=[[r[0],r[1]],[r[0],r[3]]];break;default:break;}if(e){if(!s){b=VBI.Utilities.LineLineIntersection(S,E,d[0],d[1],false);if(b){a.push(b[0],b[1]);}}a.push(E[0],E[1]);}else if(s){b=VBI.Utilities.LineLineIntersection(S,E,d[0],d[1],false);if(b){a.push(b[0],b[1]);}}S=[E[0],E[1]];}}return a;};
VBI.Utilities.GetBarycenterForPolygon=function(p,o){"use strict";var a=p.slice(0);var b=[a[0],a[1]];var c=[a[a.length-2],a[a.length-1]];if(b!=c){a.push(a[0],a[1]);}var N=a.length-2;var s=0;var A=0;var d;var e;for(var n=0;n<N;n+=2){s+=((a[n]+o)*a[n+3]-(a[n+2]+o)*a[n+1]);}A=s/2;if(A){s=0;for(var f=0;f<N;f+=2){s+=(a[f]+o+a[f+2]+o)*((a[f]+o)*a[f+3]-(a[f+2]+o)*a[f+1]);}d=s/(A*6);s=0;for(var g=0;g<N;g+=2){s+=(a[g+1]+a[g+3])*((a[g]+o)*a[g+3]-(a[g+2]+o)*a[g+1]);}e=s/(A*6);}if(d&&e){return[d,e];}return null;};
VBI.Utilities.GetMidpointForPolygon=function(p,b,X,r){"use strict";var o=X;var l=[];var a=b[0];var c=b[1];var d=VBI.Utilities.PtInRect([a[0]+o,a[1]],r);var e=VBI.Utilities.PtInRect([c[0]+o,c[1]],r);if(!d||!e){p=VBI.Utilities.GetClippedPolygon(p,o,r);o=0;}var f=VBI.Utilities.GetBarycenterForPolygon(p,o);if(f){var g=VBI.Utilities.getNextPoint(f[0],f[1],p,o);l.push(g);return{max:0,aPos:l};}return null;};
VBI.Utilities.GetClippedPolygons=function(p,o,r){"use strict";var a=[];var b=p.slice(0);var n=b.length;var c=n-2;var z=VBI.Utilities.IsClockwise(p);if(z>0){b.push(r[0],r[1],r[2],r[1],r[2],r[3],r[0],r[3]);}else{b.push(r[0],r[1],r[0],r[3],r[2],r[3],r[2],r[1]);}var d=b.length;var E=[];var L=[];var i=[];var e=[];for(var g=0;g<n;g+=2){i.push(g);}var h,j,k,m;var l;h=[b[c]+o,b[c+1]];for(var q=0;q<=c;q+=2){j=[b[q]+o,b[q+1]];var R=VBI.Utilities.LineIntersectRect(h[0],h[1],j[0],j[1],r);if(R.bReturn==true){if((R.x0!=h[0]||R.y0!=h[1])&&(R.x1!=j[0]||R.y1!=j[1])){if(!(R.x0==R.x1&&R.y0==R.y1)){var f=b.push(R.x0,R.y0);l=b.push(R.x1,R.y1);E.push(f-2);L.push(l-2);var I=i.indexOf(q);i.splice(I,0,f-2,l-2);}}else if(R.x0!=h[0]||R.y0!=h[1]){if(R.x0!=j[0]||R.y0!=j[1]){l=b.push(R.x0,R.y0);E.push(l-2);var s=i.indexOf(q);i.splice(s,0,l-2);}}else if(R.x1!=j[0]||R.y1!=j[1]){l=b.push(R.x1,R.y1);L.push(l-2);var t=i.indexOf(q);i.splice(t,0,l-2);}}h=j;}for(var u=n,v=0;v<4;u+=2,++v){var w=[];e.push(u);k=[b[u],b[u+1]];if(v==3){m=[b[n],b[n+1]];}else{m=[b[u+2],b[u+3]];}var x=(k[0]==m[0])?1:0;var y=x?0:1;for(var A=d;A<=b.length-2;A+=2){if(b[A+y]==k[y]){w.push({pt:b[A+x],idx:A});}}if(v<2){w.sort(VBI.Utilities.StandardSort1);}else{w.sort(VBI.Utilities.StandardSort2);}for(var B=0;B<w.length;++B){e.push(w[B].idx);}k=m;}for(var C=n;C<=b.length-2;C+=2){b[C]-=o;}for(var D=0;D<E.length;++D){var F=[];var G=E[D];var H=i.indexOf(E[D]);var J=i;var K=e;var M=L;var N=E;F.push(b[E[D]],b[E[D]+1]);var O=0;var P=true;while(P){H++;if(H>J.length-1){H=0;}if(J[H]==G){a.push(F);break;}F.push(b[J[H]],b[J[H]+1]);var Q=M.indexOf(J[H]);if(Q>-1){O++;H=K.indexOf(J[H]);var S=J;J=K;K=S;S=M;M=N;N=S;}}}return a;};
VBI.Utilities.StandardSort1=function(a,b){"use strict";return a.pt-b.pt;};
VBI.Utilities.StandardSort2=function(a,b){"use strict";return b.pt-a.pt;};
VBI.Utilities.GetMidpointsForPolygon=function(p,b,X,r){"use strict";var a=[];var o=X;var l=[];var c=b[0];var d=b[1];if(VBI.Utilities.RectIntersect([c[0]+o,c[1],d[0]+o,d[1]],r)){var e=VBI.Utilities.PtOnRect([c[0]+o,c[1]],r);var f=VBI.Utilities.PtOnRect([d[0]+o,d[1]],r);if(!e||!f){a=VBI.Utilities.GetClippedPolygons(p,o,r);if(!a.length){var m=[r[0]+(r[2]-r[0])/2,r[1]+(r[3]-r[1])/2];if(VBI.Utilities.pointInPolygon(p,m[0],m[1])){l.push(m);}}}else{a.push(p);}for(var n=0;n<a.length;++n){var g=VBI.Utilities.GetBarycenterForPolygon(a[n],o);if(g){var h=VBI.Utilities.getNextPoint(g[0],g[1],a[n],o);l.push(h);}}if(l.length>0){return{max:0,aPos:l};}}return null;};
VBI.Utilities.GetMidpointsForLine=function(p,o,r){"use strict";var l=[];var R={};var a=[Number.MAX_VALUE,Number.MAX_VALUE];var O=false;var s;var S=[];if(p.length>5){for(var n=0;n<=p.length-6;n+=3){var x=p[n];var y=p[n+1];var b=p[n+3];var c=p[n+4];R=VBI.Utilities.LineIntersectRect(x+o,y,b+o,c,r);if(R.bReturn==true){if(s&&O&&(R.x0!=a[0]||R.y0!=a[1])){S.push(s);O=false;}if(!O){s=[];s.push(R.x0);s.push(R.y0);O=true;}s.push(R.x1);a[0]=R.x1;s.push(R.y1);a[1]=R.y1;}else if(O){S.push(s);O=false;}}if(O){S.push(s);O=false;}}var m=0;var d=0;for(var e=0;e<S.length;e++){var f=S[e];if(f.length>3){var t=0.0;var L;var v=[];for(var g=0;g<=f.length-4;g+=2){L=Math.sqrt(Math.pow(f[g+2]-f[g],2)+Math.pow(f[g+3]-f[g+1],2));t+=L;v.push(L);}var h=t;var H=t/2;var i=-1;var M=0.0;for(var j=v.length-1;j>=0;j--){t-=v[j];if(t<=H){M=H-t;i=j;break;}}if(i>-1){var k=[f[i*2+2]-f[i*2],f[i*2+3]-f[i*2+1]];var q=Math.sqrt(Math.pow(k[0],2)+Math.pow(k[1],2));var u=[k[0]/q,k[1]/q];var w=[u[0]*M,u[1]*M];l.push([f[i*2]+parseInt(w[0],10),f[i*2+1]+parseInt(w[1],10)]);if(h>m){m=h;d=e;}}}}return{max:d,aPos:l};};
VBI.Utilities.updateBoundRect=function(a,r){"use strict";var x,n=a.length;var m=r[0];var b=r[2];var c=r[1];var d=r[3];for(var e=0;e<n;++e){x=a[e];if(m>x[0]){m=x[0];}if(b<x[0]){b=x[0];}if(c>x[1]){c=x[1];}if(d<x[1]){d=x[1];}}r[0]=m;r[2]=b;r[1]=c;r[3]=d;};
VBI.Utilities.inflateRect=function(r,v){"use strict";r[0]-=v;r[1]-=v;r[2]+=v;r[3]+=v;};
VBI.Utilities.sqDistance=function(x,y,a,b,c,d){"use strict";var p=a-x;var e=b-y;var s=p*p+e*e;if(!s){return(c-x)*(c-x)+(d-y)*(d-y);}var u=((c-x)*p+(d-y)*e)/s;if(u>1){u=1;}else if(u<0){u=0;}var f=x+u*p-c;var g=y+u*e-d;return f*f+g*g;};
VBI.Utilities.getNextPoint=function(x,y,p,o){"use strict";var v,a,b=p.length;var d=[];var e=[];var c=false;for(var n=0,l=b,f=l-2;n<=l-2;n+=2){v=[p[n]+o,p[n+1]];a=[p[f]+o,p[f+1]];var s=0;var r=[];var A=x-v[0];var B=y-v[1];var C=a[0]-v[0];var D=a[1]-v[1];var g=A*C+B*D;var h=C*C+D*D;if(!h){s=(x-v[0])*(x-v[0])+(y-v[1])*(y-v[1]);r=[v[0],v[1]];}else{var i=g/h;if(i<0){r=[v[0],v[1]];}else if(i>1){r=[a[0],a[1]];}else{r=[v[0]+i*C,v[1]+i*D];}var j=x-(v[0]+i*C);var k=y-(v[1]+i*D);s=(j*j+k*k);}d.push(r);e.push(s);if(((v[1]<=y&&y<a[1])||(a[1]<=y&&y<v[1]))&&(x<(a[0]-v[0])*(y-v[1])/(a[1]-v[1])+v[0])){c=!c;}f=n;}if(c){return[x,y];}else{var m=10000;var q=-1;if(e.length){for(var t=0;t<e.length;++t){if(e[t]<m){q=t;m=e[t];}}if(q>-1){return(d[q]);}}return([p[0]+o,p[1]]);}};
VBI.Utilities.DrawSelectIndicator=function(c,p){"use strict";var r=4;c.lineWidth=1;c.strokeStyle='rgba( 0, 0, 0, 1.0 )';c.fillStyle='rgba( 10, 10, 255, 1.0 )';c.beginPath();c.arc(p[0],p[1],r,0,2*Math.PI);c.closePath();c.fill();c.stroke();};
VBI.Utilities.DrawDesignRect=function(c,a,p,b,d,e){"use strict";var x,y,r=3,D=c.setLineDash?true:false;c.save();c.lineWidth=1;c.strokeStyle='rgba( 0, 0, 0, 1.0 )';if(typeof p=='object'){var w=p[2]-p[0];var h=p[3]-p[1];var f=w/2;var g=h/2;if(D){c.setLineDash([1,2]);}c.strokeRect(p[0],p[1],w,h);var i='rgba( 255, 255, 255, 1.0 )';var j='rgba( 128, 128, 128, 1.0 )';if(D){c.setLineDash([0,0]);}c.fillStyle=i;for(x=0;x<3;++x){for(y=0;y<3;++y){c.fillStyle=(a[y*3+x]?i:j);if(x==1&&y==1){continue;}c.beginPath();c.arc(p[0]+x*f,p[1]+y*g,r,0,2*Math.PI);c.closePath();c.fill();c.stroke();}}}else{c.strokeRect(p-1,b-1,d-p,e-b);c.strokeStyle='rgba( 255, 255, 255, 1.0 )';c.strokeRect(p,b,d-p,e-b);}c.restore();};
VBI.Utilities.DrawFrameRect=function(c,a,p,b,d,e){"use strict";c.lineWidth=1;c.strokeStyle=a;if(typeof p=='object'){c.strokeRect(p[0],p[1],p[2]-p[0],p[3]-p[1]);}else{c.strokeRect(p,b,d-p,e-b);}};
VBI.Utilities.AssembleCopyrightString=function(C,a,b){"use strict";var r=/\{LINK\|IMG\}/;var c=/\{IMG\}/;var d=/\{LINK\|([^\}]+)\}/;if(C){var t=C.replace(r,"<a href='"+a+"'><img src='"+b+"' width='10' height='10' border='none'></a>");t=t.replace(c,"<img src='"+b+"' width='10' height='10' border='none' >");return t.replace(d,"<a  href='"+a+"'>$1</a>");}return C;};
VBI.Utilities.DrawTrackingRect=function(c,p,a,b,d){"use strict";c.save();c.strokeStyle='black';c.lineWidth=1;if(c.setLineDash){c.setLineDash([1,2]);}c.beginPath();c.rect(p,a,b-p,d-a);c.stroke();c.fillStyle='rgba( 0, 192, 192, 0.2 )';c.fill();c.restore();};
VBI.Utilities.DrawTrackingLasso=function(c,p){"use strict";c.save();c.strokeStyle='black';c.lineWidth=1;if(c.setLineDash){c.setLineDash([1,2]);}c.beginPath();c.moveTo(p[0][0],p[0][1]);for(var n=1;n<p.length;++n){c.lineTo(p[n][0],p[n][1]);}c.closePath();c.stroke();c.fillStyle='rgba( 0, 192, 192, 0.2 )';c.fill();c.restore();};
VBI.Utilities.RGB2HLS=function(r,g,b){"use strict";r/=255.0;g/=255.0;b/=255.0;var m=Math.max(r,g,b);var a=Math.min(r,g,b);var h=0,s,l=(m+a)/2;if(m==a){h=s=0;}else{var d=m-a;s=l>0.5?d/(2-m-a):d/(m+a);switch(m){case r:h=(g-b)/d+(g<b?6:0);break;case g:h=(b-r)/d+2;break;case b:h=(r-g)/d+4;break;}h/=6;}return[h,l,s];};
VBI.Utilities.HLS2RGB=function(h,l,s){"use strict";var r=0,g=0,b=0;if(s==0){r=g=b=l;}else{var q=l<0.5?l*(1+s):l+s-l*s;var p=2*l-q;r=VBI.Utilities.HUE2RGB(p,q,h+1/3);g=VBI.Utilities.HUE2RGB(p,q,h);b=VBI.Utilities.HUE2RGB(p,q,h-1/3);}return[Math.round(r*255),Math.round(g*255),Math.round(b*255)];};
VBI.Utilities.HUE2RGB=function(p,q,t){"use strict";if(t<0){t+=1;}else if(t>1){t-=1;}if(t<1/6){return p+(q-p)*6*t;}if(t<1/2){return q;}if(t<2/3){return p+(q-p)*(2/3-t)*6;}return p;};
VBI.Utilities.RemToPixel=function(v){"use strict";return v*parseFloat(getComputedStyle(document.documentElement).fontSize);};
VBI.Utilities.ColorHex2rgba=function(h){"use strict";var c=h.charAt(0)==="#"?h.substring(1,7):h;return'rgba('+parseInt(c.substring(0,2),16)+','+parseInt(c.substring(2,4),16)+','+parseInt(c.substring(4,6),16)+',1.0)';};
VBI.Utilities.String2VBColor=function(s){"use strict";var c=VBI.Types.string2rgba(s);if(c[4]===1){return"RGBA("+c[0]+";"+c[1]+";"+c[2]+";"+parseInt(c[3]*255,10)+")";}else{return"RGB("+c[0]+";"+c[1]+";"+c[2]+")";}};
VBI.Utilities.CompToHex=function(c){"use strict";var h=c.toString(16);return h.length==1?"0"+h:h;};
VBI.Utilities.RgbToHex=function(r,g,b){"use strict";return"#"+VBI.Utilities.CompToHex(r)+VBI.Utilities.CompToHex(g)+VBI.Utilities.CompToHex(b);};
},
	"sap/ui/vbm/lib/sapvbcluster.js":function(){
VBI.Clustering=function(t){"use strict";var f={};var D={};var E=1.0/1048576.0;f.m_Clusters=[];f.m_Clustergroups=[];f.m_loadCount=0;f.m_Parser=VBI.Parser();f.m_nClustertypes=5;f.clear=function(){f.m_Clusters=[];};f.load=function(d,c){if(d.Set){f.clear();f.m_Parser.clear();f.m_loadCount++;var a,r=d.Set.Cluster;if(jQuery.type(r)=='object'){a=new VBI.Clustering.Cluster();a.load(r,c,f.m_Clusters.length);f.m_Clusters.push(a);f.UpdateAutomaticClusterGroup(a.m_groupID);}else if(jQuery.type(r)=='array'){var i=f.m_Clusters.length;for(var n=0,l=r.length;n<l;++n){a=new VBI.Clustering.Cluster();a.load(r[n],c,i++);f.m_Clusters.push(a);f.UpdateAutomaticClusterGroup(a.m_groupID);}}for(var b=0;b<f.m_Clustergroups.length;++b){f.m_Clusters.push(f.m_Clustergroups.shift());}}};f.UpdateAutomaticClusterGroup=function(g){if(g==""){return;}var i=f.m_Clusters[f.m_Clusters.length-1];var n,a,e,b;for(var c=0;c<f.m_Clustergroups.length;++c){e=f.m_Clustergroups[c];if(e.m_id==g){n=c;}}if(n!=undefined){b=f.m_Clustergroups[n];b.m_limit=Math.min(i.m_limitOnSum,b.m_limit);i.m_bPartOfGrp=true;}else{for(var d=0,l=f.m_Clusters.length-1;d<l;++d){e=f.m_Clusters[d];if((e.m_type=="grid")&&(e.m_groupID==g)){a=d;}}if(a!=undefined){var o=f.m_Clusters[a];b=new VBI.Clustering.Cluster();b.m_type="clustergroup";b.m_nType=2;b.m_id=g;b.m_dividerX=o.m_dividerX;b.m_dividerY=o.m_dividerY;b.m_limit=Math.min(i.m_limitOnSum,o.m_limitOnSum);b.initializeFunctions();f.m_Clustergroups.push(b);i.m_bPartOfGrp=o.m_bPartOfGrp=true;}}};f.PreassembleDataForVO=function(s,r,i,v,c){var n;var b=r.config.m_BaseLod;var l=f.tw*((b>=0)?(1<<b):1/(1<<-b));if((n=v.m_DataSource.GetCurrentNode(c))){var I=v.m_ID;var m=r.base[i];if(n.m_dataelements.length){v.m_DataSource.Select(0);var e=v.m_DataSource.GetIndexedElement(c,0);var a=e.GetPath();var d=e.GetKeyValue().length;m.strDataPath=a.substring(0,a.length-d);for(var g=0;g<n.m_dataelements.length;++g){var u=[l,l];v.m_DataSource.Select(g);e=v.m_DataSource.GetIndexedElement(c,g);var o=v.m_Pos.GetValueVector(c);s.m_Proj.LonLatToUCS(VBI.MathLib.DegToRad(o),u);var h=f.m_Parser.evaluate(v,i,c);if(h>=0){u.t=f.m_Clusters[h].m_nType;(m.targets[h])++;}else{u.t=-1;}u.h=v.BaseIsHot(g,c);u.hscale=v.GetHotScale(c);u.hcol=v.m_HotDeltaColor.GetValueString(c);if((u.s=v.IsSelected(c))){u.scol=v.m_SelectColor.GetValueString(c);u.simag=v.m_ImageSelected.GetValueString(c);r.m_SelectedVOs.unshift({m_vo:i,m_index:m.length,m_dataIndex:g});}if(u.im==undefined){u.im=v.m_Image.GetValueString(c);}u.ic=v.m_Icon.GetValueString(c);u.tx=v.m_Text.GetValueString(c);u.ctcol=v.m_ContentColor.GetValueString(c);u.ctoffs=v.m_ContentOffset.GetValueVector(c);u.ctfont=v.m_ContentFont.GetValueString(c);u.ctsz=v.m_ContentSize.GetValueLong(c);u.sc=v.m_Scale.GetValueVector(c);u.al=v.m_Alignment.GetValueString(c);u.m_ID=I;u.nI=g;u.b2Ignore=false;u.cI=h;u.vI=i;u.key=e.GetKeyValue();u.label=v.GetLabel(c);m.push(u);}}for(var j=m.targets.length;j--;){var k=f.m_Clusters[j].m_nType;m.targTypes[k]+=m.targets[j];r.base.targTypes[k]+=m.targets[j];}}};f.InitializeResultVector=function(m,n,l,x,y,a,b,c){f.tw=m.m_tileWidth;f.th=m.m_tileHeight;var R={};var d=f.m_Clusters.length;R.base=[];R.hotItem={};var i,j,e;for(i=0;i<n;++i){e=[];e.clusterings=[];e.m_lodOffset=1;e.m_BaseX=x;e.m_BaseY=y;R.base.push(e);e.targets=[];e.targTypes=[];e.hotItem=R.hotItem;for(j=d;j--;){e.targets.push(0);}for(j=f.m_nClustertypes;j--;){e.targTypes.push(0);}e.m_nNumIgnore=0;}R.base.targTypes=[];for(j=f.m_nClustertypes;j--;){R.base.targTypes.push(0);}R.clust=[];for(var g=0;g<d;++g){e=[];e.cI=g;e.m_lodOffset=1;e.m_BaseX=x;e.m_BaseY=y;e.hotItem=R.hotItem;e.m_nRecalcs=0;R.clust.push(e);}R.config={};var h=R.config;h.m_version=f.m_loadCount;h.bNeedsShadowLayer=false;h.m_lod=l;h.m_lodOffset=1;h.m_x=x;h.m_y=y;h.m_nx=a;h.m_ny=b;h.m_nData=c;h.m_calcMode=2;h.m_BaseX=x*f.tw;h.m_BaseY=y*f.tw;h.m_BaseLod=l;R.hotItem={};R.m_SelectedVOs=[];return R;};f.CheckNonClusteredVOs=function(R,C){if(!R.base.targTypes[1]){return;}for(var n=0;n<R.base.length;++n){var v=R.base[n];if(!v.targTypes[1]){continue;}var a,b,c=0;for(a=0,b=v.length;a<b;++a){var e=v[a];if(!e.isCl){if((e.cI!=undefined)&&(e.sq!=undefined)&&(C[e.cI])[e.sq].b2Cluster){v.m_nNumIgnore++;e.b2Ignore=true;}if(!e.b2Ignore){e.bbInd=c;c++;}}}v.m_NumVisVOs=c;}};f.FetchClusterVOData=function(s,v,c){var a=f.m_Clusters;var b=a.length;var r=[];for(var k=0;k<b;++k){r.push({});}var n=v.length;for(var i=0;i<n;++i){for(var j=0;j<b;++j){if(v[i].m_ID==a[j].m_VO){r[j].m_index=i;r[j].m_image=v[i].m_Image!=undefined?v[i].m_Image.GetValueString(c):"";r[j].m_scale=v[i].m_Scale!=undefined?v[i].m_Scale.GetValueVector(c):[1,1,1];r[j].m_hotscale=v[i].m_HotScale!=undefined?v[i].m_HotScale.GetValueVector(c):[1,1,1];r[j].m_hotcol=v[i].m_HotDeltaColor!=undefined?v[i].m_HotDeltaColor.GetValueString(c):"";r[j].m_alignment=v[i].m_Alignment!=undefined?v[i].m_Alignment.GetValueString(c):0;}}}return r;};f.FetchClusterGroupData=function(){var c=f.m_Clusters;var a=c.length;var r=[];for(var i=0;i<a;++i){var s=[];if(c[i].m_type=="clustergroup"){for(var j=0;j<a;++j){if((i!=j)&&(c[i].m_id==c[j].m_groupID)){s.push({index:j,limit:c[j].m_limit});}}}r.push(s);}return r;};f.AdaptOffsets=function(p,a,l,x,y,n,b){p.config.m_calcMode=1;var c=(l-p.config.m_BaseLod);var L=(c>=0)?(1<<c):1/(1<<-c);var e;for(var i=p.base.length-1;i>=0;--i){e=p.base[i];e.m_lodOffset=L;e.m_BaseX=x;e.m_BaseY=y;}for(var j=p.clust.length-1;j>=0;--j){e=p.clust[j];e.m_lodOffset=L;e.m_BaseX=x;e.m_BaseY=y;}p.config.m_lod=l;p.config.m_x=x;p.config.m_y=y;p.config.m_nx=n;p.config.m_ny=b;p.config.m_lodOffset=L;};f.DetermineChanges=function(o,l,x,y,n,a,b){var r={};r.bPosChanged=true;r.bDataChanged=true;r.bClusteringChanged=true;r.lodDiff=0;r.lodFactor=1;r.posDiff=[0,0];if(o!=undefined){var c=o.config;r.lodDiff=l-c.m_lod;if(r.lodDiff==0){r.lodFactor=1<<(r.lodDiff);r.posDiff=[f.tw*(x-r.lodFactor*c.m_x),f.th*(y-r.lodFactor*c.m_y)];}else if(r.lodDiff>0){r.lodFactor=1<<(r.lodDiff);r.posDiff=[f.tw*(x-r.lodFactor*c.m_x),f.th*(y-r.lodFactor*c.m_y)];}else{r.lodFactor=1/(1<<(-r.lodDiff));r.posDiff=[f.tw*(x-r.lodFactor*c.m_x),f.th*(y-r.lodFactor*c.m_y)];}if(c.m_nData==b){r.bDataChanged=false;}if(c.m_version==f.m_loadCount){r.bClusteringChanged=false;}if(!r.lodDiff&&(c.m_x==x)&&(c.m_y==y)&&(c.m_nx==n)&&(c.m_ny==a)){r.bPosChanged=false;}}r.bNothingChanged=!r.bDataChanged&&!r.bPosChanged&&!r.bClusteringChanged;return r;};f.InvalidateOutdatedClustering=function(R,c){var g=c.bDataChanges||c.bClusteringChanged;var s=g;for(var i=0;i<R.base.length;++i){var v=R.base[i];for(var j=v.clusterings.length-1;j>=0;--j){var a=v.clusterings[j];var b=true;switch(a.t){case 0:b=true;break;case 1:b=g||(c.lodDiff!=0);break;case 2:b=g;break;}if(b){v.clusterings.splice(j,1);var m=R.clust[a.i];m.m_nRecalcs++;m.splice(0,m.length);s=true;}}}return s;};f.ClearTreeClusterNode=function(n){if(n.bw){for(var i=n.bw.length;i--;){f.ClearTreeClusterNode(n.bw[i]);}for(var j=n.bw.length;j--;){n.bw[j]=undefined;}n.bw=undefined;}n.e=undefined;n.c=undefined;};f.ClearClusterFromPreData=function(c,i){if(c[i].m_TreeFatherNode!=undefined){f.ClearTreeClusterNode(c[i].m_TreeFatherNode);}c[i]=undefined;};f.ClearPreassembledData=function(s){var p=s.m_PreassembledData;var i;if(p==undefined){return;}for(i=p.clust.length;i--;){f.ClearClusterFromPreData(p.clust,i);}p.clust=undefined;for(i=p.base.length;i--;){p.base[i]=undefined;}s.m_PreassembledData=undefined;};f.getEdge=function(e,a){if(e[1]!=undefined){return e;}var b=a[e];var c=a[e+1];return[[b.c[0],b.c[1]],[c.c[0],c.c[1]]];};f.createEdgeIndex=function(e,a){var i,b=[];var c;for(i=a.length;i--;){c=f.getEdge(a[i],e);c[0].ot=c[1];c[0].i=i;c[1].ot=c[0];c[1].i=-i;var d={};d.i=i;d.c=0;d.p=c[0];c[0].li=d;b.push(d);var g={};g.p=c[1];g.i=-i;g.c=1;c[1].li=g;b.push(g);}b.sort(function(i,j){var x=i.p[0]-j.p[0];return x?x:i.p[1]-j.p[1];});for(i=0;i<b.length;i+=2){b[i].ot=i+1;b[i+1].ot=i;}return b;};f.getTreeClusterIndex=function(n){var m=n;while(m.c!=undefined){m=m.c;}return m.cI;};f.getNodeIdent=function(p,n,c){if(n.bw!=undefined){return f.getClusterIdent(p,c,n.nJ);}else{return p.base[n.vI].strDataPath+n.key;}};f.getClusterIdent=function(p,c,n){if(!p){return"";}var a=p.config;var b=p.clust[c];if(!b){return"";}return"["+a.m_version+","+a.m_nData+","+b.m_nRecalcs+","+c+","+n+"]";};f.getClusterArea=function(s,n){if(!n.bo){return undefined;}var p=s.m_PreassembledData;var x=s.m_Canvas[0].m_nCurrentX*s.m_MapManager.m_tileWidth;var y=s.m_Canvas[0].m_nCurrentY*s.m_MapManager.m_tileHeight;var a=p.config.m_lodOffset;var u=[a*n.bo[0]-x,a*n.bo[1]-y];var b=[a*n.bo[2]-x,a*n.bo[3]-y];var c=VBI.MathLib.RadToDeg(s.GetGeoFromPoint(u));var d=VBI.MathLib.RadToDeg(s.GetGeoFromPoint(b));return c[0].toString()+';'+c[1].toString()+';'+d[0].toString()+';'+d[1].toString();};f.getClusterPosition=function(s,n){var p=s.m_PreassembledData;var x=s.m_Canvas[0].m_nCurrentX*s.m_MapManager.m_tileWidth;var y=s.m_Canvas[0].m_nCurrentY*s.m_MapManager.m_tileHeight;var a=p.config.m_lodOffset;var u=[a*n[0]-x,a*n[1]-y];return VBI.MathLib.RadToDeg(s.GetGeoFromPoint(u));};f.getInfoForCluster=function(p,a,s){var b=s.m_PreassembledData;var c=b.config;var d;var e=b.clust[p[3]];var r=[];if(c.m_version==p[0]&&c.m_nData==p[1]&&e.m_nRecalcs==p[2]){var n=e[p[4]];if(a==10){var g=n.bw?n.bw.length:0;return{pos:f.getClusterPosition(s,n),bb:f.getClusterArea(s,n),image:n.im,lod:n.lod,ulod:n.c?n.c.lod:undefined,cnt:n.cnt,subs:g,type:n.isCl};}if(n.bw){switch(a){case 0:f.collectNodes(r,n,b);break;case 1:d=f.getTreeClusterIndex(n);for(var i=0;i<n.bw.length;++i){r.push(f.getNodeIdent(b,n.bw[i],d));}break;case 2:d=f.getTreeClusterIndex(n);if(n.c){r.push(f.getNodeIdent(b,n.c,d));}break;case 11:d=f.getTreeClusterIndex(n);return f.collectEdges(s,n,b.clust[d].m_edges);}}}r.sort();return r;};f.collectEdges=function(s,n,e){var a=[];if(!n.e||!n.e.length){return[];}var p=f.createEdgeIndex(e,n.e);var b=s.m_PreassembledData;var x=s.m_Canvas[0].m_nCurrentX*s.m_MapManager.m_tileWidth;var y=s.m_Canvas[0].m_nCurrentY*s.m_MapManager.m_tileHeight;var c=b.config.m_lodOffset;var d=p[0].p,g,l,h,j=n.e.length-1;a.push(VBI.MathLib.RadToDeg(s.GetGeoFromPoint([c*d[0]-x,c*d[1]-y])));for(var i=j;i--;){g=d.ot;a.push(VBI.MathLib.RadToDeg(s.GetGeoFromPoint([c*g[0]-x,c*g[1]-y])));h=g.li;l=p[h.ot];d=l.p;}return a;};f.collectNodes=function(r,n,p){if(n.bw!=undefined){for(var i=0;i<n.bw.length;++i){f.collectNodes(r,n.bw[i],p);}}else{var m=p.base[n.vI];r.push(m.strDataPath+n.key);}};f.DoClustering=function(s,l,o,y,n,a,v,c,b,F,d,e){var g=(1<<l);var x=o;while(x<0){x+=g;}while(x>g){x-=g;}var h=f.DetermineChanges(s.m_PreassembledData,l,x,y,n,a,e);var R;if(h.bNothingChanged){s.m_PreassembledData.config.m_calcMode=0;return s.m_PreassembledData;}var i;var j=f.FetchClusterVOData(s,v,c);var k=f.FetchClusterGroupData();f.m_Parser.verifyAttributes(v,c);var C=f.InitializeClusterData(s,l,x,y,n,a);if(h.bDataChanged||h.bClusteringChanged){f.ClearPreassembledData(s);R=f.InitializeResultVector(s.m_MapManager,v.length,l,x,y,n,a,e);for(i=0;i<v.length;++i){var m=v[i];if(m.IsClusterable()){f.PreassembleDataForVO(s,R,i,m,c);}}}else{R=s.m_PreassembledData;f.AdaptOffsets(R,h.posDiff,l,x,y,n,a);if(!f.InvalidateOutdatedClustering(R,h)){return R;}}for(i=0;i<f.m_Clusters.length;++i){f.m_Clusters[i].ClusterPass1(i,R,C,h);}for(i=0;i<f.m_Clusters.length;++i){f.m_Clusters[i].ClusterPass2(i,R,C,k);}for(i=0;i<f.m_Clusters.length;++i){f.m_Clusters[i].DecisionPass(s,i,R,C,j,k,h);}f.CheckNonClusteredVOs(R,C);return R;};f.InitializeClusterData=function(s,l,x,y,n,a){var C=[];var b=(1<<l);C.numTiles=b;C.completeX=b*s.m_nWidthCanvas/s.m_nTilesX;C.completeY=b*s.m_nHeightCanvas/s.m_nTilesY;C.minLOD=s.GetMinLOD();for(var c=0;c<f.m_Clusters.length;++c){var d=f.m_Clusters[c];var e=(n+2)*d.m_dividerX;var g=(a+2)*d.m_dividerY;C.push(d.InitializeClusterData(s,c,x-1,y-1,e,g));}return C;};f.VerifyCurrentSelection=function(v,R,c){for(var i=R.m_SelectedVOs.length-1;i>=0;--i){var s=R.m_SelectedVOs[i];var a=v[s.m_vo];a.m_DataSource.Select(s.m_dataIndex);if(!a.IsSelected(c)){var A=(s.cI!=undefined?R.clust[s.cI]:R.base[s.m_vo]);A[s.m_index].s=false;R.m_SelectedVOs.splice(i,1);}}};f.AddSingle2Selected=function(v,a,i,R,c){var b=a[v];if(b.IsClusterable()){var A=(i.cI!=undefined?R.clust[i.cI]:R.base[v]);var e=A[i.i];b.m_DataSource.Select(e.nI);if(b.IsSelected(c)){R.m_SelectedVOs.unshift({m_vo:v,m_index:i.i,m_dataIndex:e.nI,cI:i.cI});e.scol=b.m_SelectColor.GetValueString(c);e.simag=b.m_ImageSelected.GetValueString(c);e.s=true;}}};f.AddMultiple2Selected=function(i,v,R,c){for(var n=0;n<i.length;++n){var r=i[n];var a=v[n];if(a.IsClusterable()){for(var b=0;b<r.length;++b){f.AddSingle2Selected(n,v,a.GetInternalIndex(r[b]),R,c);}}}};VBI.Clustering.Cluster=function(){var d={};d.m_additionalProperties=[];d.clear=function(){d.m_addProperties=null;};d.load=function(a,c,i){d.m_id=a.id;d.m_type=a.type;d.m_type2=a.type2;d.m_switch=parseInt(a.typeswitch,10);d.m_bPartOfGrp=false;d.m_VO=a.VO;d.m_order=parseInt(a.order,10);d.m_dispOffsetX=parseInt(a.offsetX,10);if(isNaN(d.m_dispOffsetX)){d.m_dispOffsetX=0;}d.m_dispOffsetY=parseInt(a.offsetY,10);if(isNaN(d.m_dispOffsetY)){d.m_dispOffsetY=0;}f.m_Parser.addFormula(i,a.rule==undefined?"":a.rule);d.m_textcolor=a.textcolor;if(d.m_textcolor==undefined){d.m_textcolor="rgba(0,0,0,0.7)";}d.m_textfont=a.textfont;d.m_textfontscale=a.textfontscale;d.m_textfontsize=a.textfontsize;if(isNaN(d.m_textfontscale)){d.m_textfontscale=2.0;}d.m_textoffset=parseInt(a.textoffset,10);d.m_textoffsetY=parseInt(a.textoffsetY,10);if(isNaN(d.m_textoffset)){d.m_textoffset=0;}if(isNaN(d.m_textoffsetY)){d.m_textoffsetY=0;}d.m_spotcol=a.spotcol;d.m_spotsize=parseInt(a.spotsize,10);d.m_bordersize=a.areabordersize?parseInt(a.areabordersize,10):2;d.m_bordercol=a.areabordercol;if(d.m_type=="grid"){d.m_nType=1;d.m_distanceX=((a.distanceX==undefined)||(a.distanceX<=0))?256:a.distanceX;d.m_dividerX=Math.max(1,Math.round(256/d.m_distanceX));d.m_distanceY=((a.distanceY==undefined)||(a.distanceY<=0))?256:a.distanceY;d.m_dividerY=Math.max(1,Math.round(256/d.m_distanceY));d.m_groupID=(a.groupID==undefined?"&":a.groupID)+d.m_dividerX+"_"+d.m_dividerY;d.m_omitEmpties=(a.showEmpties!="true");d.m_fillcol=a.areafillcol;d.m_permanentArea=(a.areapermanent=="true");}if(d.m_type=="distance"){d.m_nType=3;d.m_distance=a.distance;if(d.m_distance==undefined||d.m_distance<=0){d.m_distance=128;}}if(d.m_type=="tree"){d.m_nType=4;d.m_distance=a.distance;if(d.m_distance==undefined||d.m_distance<=0){d.m_distance=16;}d.m_bordercol2=a.areabordercol2;d.m_bordercol3=a.areabordercol3;d.m_fillcol=a.areafillcol;d.m_fillcol2=a.areafillcol2;d.m_fillcol3=a.areafillcol3;d.m_animated=a.animation=="true"?"2":a.animation;d.m_permanentArea=(a.areapermanent=="true");}d.m_limit=parseInt(a.limit,10);d.m_limitOnSum=a.limitOnSum==undefined?999999:parseInt(a.limitOnSum,10);d.initializeFunctions();};d.initializeFunctions=function(){switch(d.m_type){case"grid":d.InitializeClusterData=d.InitializeGridClusterData;d.ClusterPass1=d.gridClusteringCounting;d.ClusterPass2=d.NothingToDo;d.DecisionPass=d.gridBasedDecision;d.CheckClusterData=d.CheckSingleClusterData;break;case"clustergroup":d.InitializeClusterData=d.InitializeGridClusterData;d.ClusterPass1=d.NothingToDo;d.ClusterPass2=d.gridClustergroupCounting;d.DecisionPass=d.gridBasedDecision;d.CheckClusterData=d.CheckGroupClusterData;break;case"distance":d.InitializeClusterData=d.InitializeDistClusterData;d.ClusterPass1=d.NothingToDo;d.ClusterPass2=d.NothingToDo;d.DecisionPass=d.distanceBasedDecision;d.CheckClusterData=d.NothingToDo;break;case"tree":d.InitializeClusterData=d.InitializeTreeClusterData;d.ClusterPass1=d.NothingToDo;d.ClusterPass2=d.NothingToDo;d.DecisionPass=d.treeBasedDecision;d.CheckClusterData=d.NothingToDo;break;}};d.gridClusteringCounting=function(n,R,C,c){var m=C[n];var a=R.clust[n];var x=m.nX;var y=m.nY;var b=d.m_dividerX*C.numTiles/C.completeX;var e=d.m_dividerY*C.numTiles/C.completeX;var g=C.completeX/256;var h,i,j;var k,l;var o=f.th*m.m_BaseX;var p=f.th*m.m_BaseY;var q=a.m_lodOffset;for(var r=0;r<R.base.length;++r){k=R.base[r];for(var s=0;s<k.length;++s){l=k[s];if(l.cI==n){if(l.b2Ignore){k.m_nNumIgnore--;l.b2Ignore=false;}h=Math.floor((q*l[0]-o)*b);if(h<0){h+=g;}i=Math.floor((q*l[1]-p)*e);if((h>=0)&&(h<x)&&(i>=0)&&(i<y)){j=h+x*i;l.sq=j;m[j].numInst++;m[j].bw.push(l);}}}}};d.gridClustergroupCounting=function(n,R,C,g){var m=g[n];var c=m.length;var a=C[n];for(var b=0;b<a.length;++b){var e=0;var h=a[b];h.bLimitExceeded=false;for(var i=0;i<c;++i){var j=m[i].index;var k=C[j];var l=k[b].numInst;e+=l;if(l>=m[i].limit){h.bLimitExceeded=true;}}h.numInst=e;}};d.distanceBasedDecision=function(s,n,R,C,c,g,a){if(a.lodDiff||a.bDataChanged||a.bClusteringChanged){var b=f.m_Clusters[n];var e=d.doDistClustering(n,R,b.m_distance,C.completeX);d.distFillClusterData(s,e,R,c[n],n);}};d.treeBasedDecision=function(s,n,R,C,c,g,a){if(a.bDataChanged||a.bClusteringChanged){var b=f.m_Clusters[n];var e=d.doTreeClustering(n,R,c[n],b.m_distance,C.completeX);d.treeFillClusterData(s,e,R,c[n],n,s.GetMinLOD());}};d.gridBasedDecision=function(s,n,R,C,c,g,a){R.config.bNeedsShadowLayer=d.fillClusterConfig(R.clust[n],R.config,0,false)||R.config.bNeedsShadowLayer;var b=f.m_Clusters[n];if(!b.m_bPartOfGrp){var e=C[n];var m=g[n];if(m.length){for(var i=m.length;i--;){var h=m[i].index;R.base[c[h].m_index].clusterings.push({i:h,t:0});}}else{R.base[c[n].m_index].clusterings.push({i:n,t:0});}for(var x=0;x<e.nX;++x){for(var y=0;y<e.nY;++y){var j=x+e.nX*y;b.CheckClusterData(R,C,e[j],n,j,x,y,c,m);}}}};d.NothingToDo=function(){};d.ReturnFalse=function(){return false;};d.CheckSingleClusterData=function(R,C,c,n,a,x,y,v,b){if(c.numInst>=d.m_limit){var t=C[n];f.m_Clusters[n].FillClusterData(R,t[a],x,y,t,v[n],n,1);return;}c.b2Cluster=false;return;};d.CheckGroupClusterData=function(R,C,c,n,a,x,y,v,b){var i,t,g=1;if(c.bLimitExceeded||(c.numInst>=d.m_limit)){for(i=0;i<b.length;++i){var e=b[i].index;t=C[e];g=f.m_Clusters[e].FillClusterData(R,t[a],x,y,t,v[e],e,g);}}else{c.b2Cluster=false;for(i=0;i<b.length;++i){t=C[b[i].index];t[a].b2Cluster=false;}}return;};d.InitializeGridClusterData=function(s,n,a,b,c,e){var m=[];m.cI=n;m.nX=c;m.nY=e;m.XPerTile=s.m_nWidthCanvas/(s.m_nTilesX*d.m_dividerX);m.YPerTile=s.m_nHeightCanvas/(s.m_nTilesY*d.m_dividerY);var g=0;for(var x=0;x<c;++x){for(var y=0;y<e;++y){var h={};h.numInst=0;h.bw=[];h.sq=g++;m.push(h);}}m.m_BaseX=a;m.m_BaseY=b;return m;};d.InitializeDistClusterData=function(s,n,x,y,a,b){var e={};e.numInst=0;e.type=d.m_type;e.cI=n;return e;};d.InitializeTreeClusterData=function(s,n,x,y,a,b){var e={};e.numInst=0;e.type=d.m_type;return e;};d.FillSquareEdges=function(e,b,s,x,y,a,c){var r=[];r.push([[x,y],[a,y]]);r.push([[a,y],[a,c]]);r.push([[a,c],[x,c]]);r.push([[x,c],[x,y]]);e.e=r;if(b){var g=[];var h=(a-x)/256*Math.abs(s)/2;var i=(c-y)/256*Math.abs(s)/2;g.push([[x+h,y+i],[a-h,y+i]]);g.push([[a-h,y+i],[a-h,c-i]]);g.push([[a-h,c-i],[x+h,c-i]]);g.push([[x+h,c-i],[x+h,y+i]]);e.ei=g;}};d.FillClusterData=function(R,c,x,y,m,v,n,g){var a=R.clust[n];var b=m.XPerTile;var e=m.YPerTile;var h=f.th*m.m_BaseX;var i=f.th*m.m_BaseY;if(d.m_omitEmpties&&!c.numInst){c.b2Cluster=false;return g;}c.b2Cluster=true;var j=y*e;var k=j+e;var l=x*b;var o=l+b;var p=b/2;var q=e/2;var r=[(h+l+p+d.m_dispOffsetX)/a.m_lodOffset,(i+j+q+d.m_dispOffsetY)/a.m_lodOffset,0,0];d.FillSquareEdges(r,a.config.b2Times,a.config.bSize,(h+l)/a.m_lodOffset,(i+j)/a.m_lodOffset,(h+o)/a.m_lodOffset,(i+k)/a.m_lodOffset);r.sq=c.sq;r.cI=m.cI;r.h=r.s=false;r.im=v.m_image;r.sc=v.m_scale;r.hscale=v.m_hotscale;r.hcol=v.m_hotcol;r.al=v.m_alignment;r.cnt=c.numInst;if(d.m_textfont!=undefined){r.f=d.m_textfont;r.fc=d.m_textcolor;r.fs=d.m_textfontscale;r.fz=d.m_textfontsize;r.fo=d.m_textoffset;r.foy=d.m_textoffsetY;}r.isCl=1;r.nJ=a.length;r.grI=g;r.bw=c.bw;a.push(r);return g+1;};d.doDistClustering=function(n,R,o,c){var i,j,a,b,e;var T=[];var g={};var l=R.clust[n].m_lodOffset;var h=o/l;for(i=0;i<R.base.length;++i){g=R.base[i];for(j=0;j<g.length;++j){if(g[j].cI==n){T.push(g[j]);if(g[j].b2Ignore){g.m_nNumIgnore--;g[j].b2Ignore=false;}g[j].isGrouped=false;}}}if(!T.length){return[];}T.sort(function(a,b){return a[0]-b[0];});var k=T.length-1;var G=0;var m=T[0],p=T[k];var q=m[0]-p[0]+c;if(q<=h){for(i=0;i<k;++i){a=T[i];b=T[i+1];e=b[0]-a[0];if(e>h){G=i+1;break;}}}var r=[];var s,u,x,v,w,y;var z=T.length+G;var A=T.length;for(i=G;i<z;++i){w=i%A;a=T[w];if(a.isGrouped){continue;}x=a[0];if(i>A-1){x+=c;}for(j=i+1;j<z;++j){y=j%A;b=T[y];if(b.isGrouped){continue;}v=b[0];if(j>A-1){v+=c;}if(v-x<=h){if(a.isGrouped&&r.length>0){s=r[a.nGrp].minY;u=r[a.nGrp].maxY;}else{s=a[1];u=a[1];}if(Math.abs(b[1]-s)<=h&&Math.abs(b[1]-u)<=h){if(a.isGrouped){r[a.nGrp].push(b);b.isGrouped=true;b.nGrp=a.nGrp;b.b2Ignore=true;R.base[b.vI].m_nNumIgnore++;if(b[1]<r[a.nGrp].minY){r[a.nGrp].minY=b[1];}if(b[1]>r[a.nGrp].maxY){r[a.nGrp].maxY=b[1];}if(v<r[a.nGrp].minX){r[a.nGrp].minX=v;}if(v>r[a.nGrp].maxX){r[a.nGrp].maxX=v;}if(r[a.nGrp].sumX==undefined){r[a.nGrp].sumX=v;}else{r[a.nGrp].sumX+=v;}if(r[a.nGrp].sumY==undefined){r[a.nGrp].sumY=b[1];}else{r[a.nGrp].sumY+=b[1];}}else{var B=[];B.push(a);B.push(b);r.push(B);var C=r.length-1;a.isGrouped=true;a.nGrp=C;a.b2Ignore=true;R.base[a.vI].m_nNumIgnore++;b.isGrouped=true;b.nGrp=C;b.b2Ignore=true;R.base[b.vI].m_nNumIgnore++;if(a[1]<b[1]){r[C].minY=a[1];r[C].maxY=b[1];}else{r[C].minY=b[1];r[C].maxY=a[1];}if(x<v){r[C].minX=x;r[C].maxX=v;}else{r[C].minX=v;r[C].maxX=x;}if(r[C].sumX==undefined){r[C].sumX=x+v;}else{r[C].sumX+=x+v;}if(r[C].sumY==undefined){r[C].sumY=a[1]+b[1];}else{r[C].sumY+=a[1]+b[1];}}}}else{break;}}}return r;};d.distFillClusterData=function(s,a,R,v,c){for(var i=0;i<a.length;++i){var m=a[i];var l=m.length;var x=m.sumX/l;var y=m.sumY/l;var e=[x,y,0,0];e.bo=[m.minX,m.minY,m.maxX,m.maxY];e.h=false;e.hscale=v.m_hotscale;e.hcol=v.m_hotcol;e.al=v.m_alignment;e.s=false;e.im=v.m_image;e.sc=v.m_scale;e.cnt=l;if(d.m_textfont!=undefined){e.f=d.m_textfont;e.fc=d.m_textcolor;e.fs=d.m_textfontscale;e.fz=d.m_textfontsize;e.fo=d.m_textoffset;e.foy=d.m_textoffsetY;}e.bw=m;e.isCl=3;e.nJ=R.clust[c].length;R.clust[c].push(e);e.grI=1;e.cI=c;}R.config.bNeedsShadowLayer=d.fillDistConfig(R.clust[c],R.config,R)||R.config.bNeedsShadowLayer;R.base[v.m_index].clusterings.push({i:c,t:1});return true;};d.AddEdgeChain=function(n){var r=[];var l=n[0],a,b;var c=n.length;for(var i=1;i<c;++i){a=n[i];b=Math.max(Math.abs(l[0]-a[0]),Math.abs(l[1]-a[1]));r.push({s:l[2],d:a[2],l:b,c:undefined});l=a;}return r;};d.doTreeClustering=function(n,R,v,c,e){var T=[];var g={};var i,j;for(i=0;i<R.base.length;++i){g=R.base[i];for(j=0;j<g.length;++j){if(g[j].cI==n){var h=g[j];while(h[0]<0){h[0]+=e;}while(h[0]>e){h[0]-=e;}h.lod=30;h.cnt=1;h.e=[];T.push(h);h.b2Ignore=true;g.m_nNumIgnore++;h.vo=i;}}}var a,k,b;T.sort(function(a,b){return a[0]!=b[0]?a[0]-b[0]:a[1]-b[1];});if(R.m_SelectedVOs.length){for(var l=0;l<T.length;++l){if(T[l].s){for(var m=0;m<R.m_SelectedVOs.length;m++){if(T[l].nI==R.m_SelectedVOs[m].m_dataIndex){R.m_SelectedVOs[m].m_index=l;R.m_SelectedVOs[m].cI=n;}}}}}var o=T.length-1;if(o<0){return[];}var G=0;var p=[];var q=T[0],r=T[o];var s=q[0]-r[0]+e;var u=c*e/f.tw;if(s<u){for(i=0;i<o;++i){a=T[i];b=T[i+1];k=b[0]-a[0];if(k>s){G=i+1;s=k;if(s>u){break;}}}}VBI.Trace("iGap is "+G);var w=T.length;var z=G+w;var A=-1,B;var C=[];var x,y;for(i=G;i<z;++i){if(i>=w){j=i-w;(T[j])[0]+=e;}else{j=i;}a=T[j];a.bo=[a[0],a[1],a[0],a[1]];x=a[0];y=a[1];if(A!=-1&&x===B[0]&&y===B[1]){C.push({s:A,d:j,l:0,z:1,zero:true});}else{p.push([x,y,j]);A=j;B=a;}}var F=D.triangulate(p);var H=F[0];var I=F[1];if(H.length==0){H=d.AddEdgeChain(p);}H.sort(function(a,b){var L=a.l-b.l;if(L){return L;}L=a.s-b.s;if(L){return L;}L=a.d-b.d;return L?L:b.v-a.v;});var J=C.concat(H);var K=(1<<R.config.m_BaseLod);for(j=0;j<T.length;j++){T[j].nJ=j;}d.clcnt=T.length;R.config.m_0ref=d.buildTree(T,n,J,v,c,e);R.config.m_ref=R.config.m_0ref/K;d.determineClusterPositions(T.m_TreeFatherNode);d.assembleAreaInfo(T,J,I);T.m_edges=J;return T;};d.determineClusterPositions=function(n){if(n.isCl){var x=0,y=0,b=n.bw,c;for(var i=b.length;i--;){c=d.determineClusterPositions(b[i]);x+=(c[0]*c[2]);y+=(c[1]*c[2]);}n[0]=x/n.cnt;n[1]=y/n.cnt;}return[n[0],n[1],n.cnt];};d.AddVirtuals=function(n,a,v){var m=v[a];if(m.executed==undefined){var s=m.v0,b;if(s){for(var i=0;i<m.length;++i){b=m[i];n.e.push([[s.c[0],s.c[1]],[b.c[0],b.c[1]]]);}}else{s=m[0];b=m[1];n.e.push([[s.c[0],s.c[1]],[b.c[0],b.c[1]]]);}}};d.AddEdge=function(n,e,a,v,s,b,c){if(!s||!b){n.e.push(c);}if(e.v){if(s){d.AddVirtuals(n,e.s,v);}if(b){d.AddVirtuals(n,e.d,v);}}return n.c;};d.MarkVirtuals=function(s,a,v){v[s].executed=true;v[a].executed=true;};d.assembleAreaInfo=function(n,e,v){var a,b,c,g;var l=e.length-1;for(var i=0;i<=l;++i){var s=false;a=e[i];b=i<l?e[i+1]:undefined;if(a.l&&a.s>=0&&a.d>=0){c=n[a.s];g=n[a.d];if((i<l)&&(a.s===b.s)&&(a.d===b.d)){while(c!=undefined&&s==false){if(c.lod<g.lod){g=d.AddEdge(g,a,b,v,false,true,i);}else if(c.lod>g.lod){c=d.AddEdge(c,a,b,v,true,false,i);}else if(c.nJ===g.nJ){if(a.v){c=d.AddEdge(c,a,b,v,true,true,i);g=g.c;}else{s=true;}}else{c=d.AddEdge(c,a,b,v,true,false,i);g=d.AddEdge(g,a,b,v,false,true,i);}}i++;}}if(a.v){v[a.s].executed=true;v[a.d].executed=true;}}};d.recCheck=function(n,N,e,a,b,c,g,h,v,j,l,k,m){var o=[];var p=[0,0];var q=b[c];var r,s,i,u;var w=d.analyzePath(o,N,e,q,h,l,k);if(w.nLod==h){return p;}var x=N[w.i];if(w.nLod==w.oLod){if(d.NodeMerge(w.nLod,b,c,N,w.i)&&c){p=d.recCheck(n,N,w.i-1,w.i-1,b,c-1,c-1,w.nLod,v,j,l,k,m+1);}}else if(q.lod>w.nLod){d.Merge2NewNode(n,w.nLod,N[w.i],q,N,w.i+1,v);p[1]=1;}else{p=d.recCheck(n,b,c,g,N,w.i,a,q.lod-1,v,j,l,k,m+1);if(o.length>1){var y=w.i+1+p[0];var z=N[y];var A=e+p[0];d.NodeMerge(z.lod,b,c+p[1],N,y);for(i=y;i<=a+p[0];i++){u=N[i];if(i<A){u.bo=o[e+p[0]-i];}else{r=u.bo;s=q.bo;u.bo=[Math.min(r[0],s[0]),Math.min(r[1],s[1]),Math.max(r[2],s[2]),Math.max(r[3],s[3])];}u.cnt+=(q.cnt-x.cnt);}}return[p[1],p[0]];}for(i=w.i;i<=a;i++){u=N[i+p[1]];u.cnt+=q.cnt;if(i<=e){u.bo=o[e-i];}else{r=u.bo;s=q.bo;u.bo=[Math.min(r[0],s[0]),Math.min(r[1],s[1]),Math.max(r[2],s[2]),Math.max(r[3],s[3])];}}return p;};d.buildTree=function(n,c,a,v,b,g){var l=1/Math.log(2);d.dLog2=l;var h=l*Math.log(g/f.tw)+4;var p,s,j,i;var k,m,e,o,q;for(e=0;e<a.length;++e){var r=a[e];if(p&&(r.s==p.s)&&(r.d==p.d)){continue;}p=r;j=r.l;var u=Math.floor(Math.min(24,l*Math.log(b/j)+h));var N=[n[r.s]];for(i=0;N[i].c!=undefined;++i){N[i+1]=N[i].c;}k=N[i];var w=[n[r.d]];for(i=0;w[i].c!=undefined;++i){w[i+1]=w[i].c;}m=w[i];s=false;if((N.length==1)&&(w.length>1)){s=true;}else if(w.length>1){if((m.lod<k.lod)||((m.lod==k.lod)&&(m.cnt>k.cnt))){s=true;}}o=N.length-1;q=w.length-1;var x=-1000;if(k.nJ==m.nJ){do{x=k.lod;k=N[--o];m=w[--q];}while(k.nJ==m.nJ);}if(s){d.recCheck(n,w,q,q,N,o,o,x,v,u,h,b,0);}else{d.recCheck(n,N,o,o,w,q,q,x,v,u,h,b,0);}}if(n.length){var y=n[0];while(y.c!=undefined){y=y.c;}y.cI=c;n.m_TreeFatherNode=y;}return b/(2*Math.exp(-h/l));};d.Merge2NewNode=function(n,l,u,e,N,i,v){var a=u.c;var b=e.c;var c={lod:l,nJ:d.clcnt++,isCl:4,cnt:u.cnt,e:[],h:false,hscale:v.m_hotscale,hcol:v.m_hotcol,s:false,im:v.m_image,sc:v.m_scale,f:d.m_textfont,fc:d.m_textcolor,fs:d.m_textfontscale,fz:d.m_textfontsize,fo:d.m_textoffset,foy:d.m_textoffsetY,al:v.m_alignment,grI:1};c.bw=[u,e];u.c=c;e.c=c;N.splice(i,0,c);if(a!=undefined){c.c=a;d.ReplaceBWE(a.bw,u.nJ,c);}if(b!=undefined){d.RemoveBWE(b.bw,e.nJ);}n.push(c);return c;};d.NodeMerge=function(n,l,a,b,c){var r=false;var e=b[c];var g=l[a];var o=g.c;if(n<g.lod){e.bw.push(g);g.c=e;}else{var h;for(var i=g.bw.length;i--;){h=g.bw[i];h.c=e;e.bw.push(h);g.bw[i]=undefined;}g.bInvalid=true;r=true;}if(o!=undefined){d.RemoveBWE(o.bw,g.nJ);}return r;};d.ReplaceBWE=function(m,o,e){for(var i=m.length;i--;){if(m[i].nJ==o){if(e==-1){m.splice(i,1);}else{m[i]=e;}}}};d.RemoveBWE=function(m,o){for(var i=m.length;i--;){if(m[i].nJ==o){m.splice(i,1);}}};d.analyzePath=function(B,n,i,e,a,l,b){var c=n[i];var g=c.bo,h=e.bo;var j=[Math.min(g[0],h[0]),Math.min(g[1],h[1]),Math.max(g[2],h[2]),Math.max(g[3],h[3])];var m=Math.max(j[2]-j[0],j[3]-j[1]);var k=Math.floor(Math.min(24,d.dLog2*Math.log(b/m)+l));if(k<=a){return{i:i+1,nLod:a,oLod:a};}B.push(j);if(i==0||k<c.lod){return{i:i,nLod:k,oLod:c.lod};}return d.analyzePath(B,n,i-1,e,k,l,b);};d.fillClusterConfig=function(m,b,a,A){var e={};e.bCol=d.m_bordercol;e.bSize=Math.abs(d.m_bordersize);if(d.m_bordersize<0){e.b2Times=true;}e.fCol=d.m_fillcol;e.permArea=d.m_permanentArea;if(d.m_bordercol2){e.bCol2=d.m_bordercol2;}if(d.m_bordercol3){e.bCol3=d.m_bordercol3;}if(d.m_fillcol2){e.fCol2=d.m_fillcol2;}if(d.m_fillcol3){e.fCol3=d.m_fillcol3;}e.sCol=d.m_spotcol;e.sSize=d.m_spotsize;e.anim=(!A)?undefined:d.m_animated;e.animLow=Math.ceil(a);e.baseConf=b;m.config=e;return((e.bCol!=undefined)||(e.sCol&&e.sSize));};d.fillDistConfig=function(m,b,R){var e={};e.baseConf=b;m.config=e;if((d.m_spotsize!=undefined)&&(d.m_spotsize!=0)&&(d.m_spotcol!=undefined)){e.sCol=d.m_spotcol;e.sSize=d.m_spotsize;e.base=R.base;return true;}return false;};d.treeFillClusterData=function(s,a,R,v,n,m){R.clust[n]=a;R.clust[n].hotItem=R.hotItem;R.clust[n].cI=n;R.clust[n].m_lodOffset=1;R.clust[n].m_nRecalcs=0;R.base[v.m_index].clusterings.push({i:n,t:2});R.config.bNeedsShadowLayer=d.fillClusterConfig(R.clust[n],R.config,m,true)||R.config.bNeedsShadowLayer;return true;};return d;};D={supertriangle:function(v){var x=Number.POSITIVE_INFINITY,y=Number.POSITIVE_INFINITY,a=Number.NEGATIVE_INFINITY,b=Number.NEGATIVE_INFINITY,i,d,c,e,g,h;for(i=v.length;i--;){if(v[i][0]<x){x=v[i][0];}if(v[i][0]>a){a=v[i][0];}if(v[i][1]<y){y=v[i][1];}if(v[i][1]>b){b=v[i][1];}}d=a-x;c=b-y;e=Math.max(d,c);g=x+d*0.5;h=y+c*0.5;return[[g-40*e,h-e,-1],[g,h+40*e,-2],[g+40*e,h-e,-3]];},circumcircle:function(v,i,j,k){var x=v[i][0],y=v[i][1],a=v[j][0],b=v[j][1],c=v[k][0],d=v[k][1],e=Math.abs(y-b),g=Math.abs(b-d),h,l,m,n,o,p,q,r,s,u;if(e<E){n=-((c-a)/(d-b));p=(a+c)/2.0;r=(b+d)/2.0;h=(a+x)/2.0;l=n*(h-p)+r;}else if(g<E){m=-((a-x)/(b-y));o=(x+a)/2.0;q=(y+b)/2.0;h=(c+a)/2.0;l=m*(h-o)+q;}else{m=-((a-x)/(b-y));n=-((c-a)/(d-b));o=(x+a)/2.0;p=(a+c)/2.0;q=(y+b)/2.0;r=(b+d)/2.0;h=(m*o-n*p+r-q)/(m-n);l=(e>g)?m*(h-o)+q:n*(h-p)+r;}s=a-h;u=b-l;return{i:i,j:j,k:k,x:h,y:l,r:s*s+u*u};},dedup:function(e){var i,j,a,b,m,n;for(j=e.length;j;){b=e[--j];a=e[--j];for(i=j;i;){n=e[--i];m=e[--i];if((a===m&&b===n)||(a===n&&b===m)){e.splice(j,2);e.splice(i,2);break;}}}},assemble:function(o,a,v,b,n){o.length=0;var i;for(i=a.length;i--;){var d=(a[i].i>=n)+(a[i].j>=n)+(a[i].k>=n);var e=[a[i].i,a[i].j,a[i].k];e.sort();var g=b[e[0]],h=b[e[1]],j=b[e[2]];var k=Math.max(Math.abs(g[0]-h[0]),Math.abs(g[1]-h[1]));var l=Math.max(Math.abs(g[0]-j[0]),Math.abs(g[1]-j[1]));var m=Math.max(Math.abs(j[0]-h[0]),Math.abs(j[1]-h[1]));var c=[a[i].x,a[i].y];var p=(b[e[0]])[2],q=(b[e[1]])[2],r=(b[e[2]])[2];if(p>=0&&q>=0){o.push({s:p,d:q,l:k,c:c,v:d});}if(p>=0&&r>=0){o.push({s:p,d:r,l:l,c:c,v:d});}if(q>=0&&r>=0){o.push({s:q,d:r,l:m,c:c,v:d});}if(d){if(p>=0){this.addToVirtual(v,p,q,r,c,d);}if(q>=0){this.addToVirtual(v,q,p,r,c,d);}if(r>=0){this.addToVirtual(v,r,p,q,c,d);}}}return o;},triangulate:function(v,k){var n=v.length,i,j,d,s,o,e,g,h,l,m,a,b,c;if(n<1){return[];}v=v.slice(0);if(k){for(i=n;i--;){v[i]=v[i][k];}}d=new Array(n);for(i=n;i--;){d[i]=i;}d.sort(function(i,j){return v[j][0]-v[i][0];});s=this.supertriangle(v);v.push(s[0],s[1],s[2]);o=[this.circumcircle(v,n+0,n+1,n+2)];e=[];g=[];h=[];for(i=d.length;i--;g.length=0){c=d[i];for(j=o.length;j--;){l=v[c][0]-o[j].x;if(l>0.0&&l*l>o[j].r){e.push(o[j]);o.splice(j,1);continue;}m=v[c][1]-o[j].y;if(l*l+m*m-o[j].r>E){continue;}g.push(o[j].i,o[j].j,o[j].j,o[j].k,o[j].k,o[j].i);o.splice(j,1);}this.dedup(g);for(j=g.length;j;){b=g[--j];a=g[--j];o.push(this.circumcircle(v,a,b,c));}}for(i=o.length;i--;){e.push(o[i]);}o=this.assemble(o,e,h,v,n);return[o,h];},addToVirtual:function(v,a,b,d,c,n){var e={n1:b,n2:d,c:c,v:n};if(v[a]==undefined){v[a]=[];}if(b<0&&d<0){v[a].v0=e;}else{v[a].push(e);}},contains:function(e,p){if((p[0]<e[0][0]&&p[0]<e[1][0]&&p[0]<e[2][0])||(p[0]>e[0][0]&&p[0]>e[1][0]&&p[0]>e[2][0])||(p[1]<e[0][1]&&p[1]<e[1][1]&&p[1]<e[2][1])||(p[1]>e[0][1]&&p[1]>e[1][1]&&p[1]>e[2][1])){return null;}var a=e[1][0]-e[0][0],b=e[2][0]-e[0][0],c=e[1][1]-e[0][1],d=e[2][1]-e[0][1],i=a*d-b*c;if(i===0.0){return null;}var u=(d*(p[0]-e[0][0])-b*(p[1]-e[0][1]))/i,v=(a*(p[1]-e[0][1])-c*(p[0]-e[0][0]))/i;if(u<0.0||v<0.0||(u+v)>1.0){return null;}return[u,v];}};return f;};
},
	"sap/ui/vbm/lib/sapvbi.js":function(){(function(){"use strict";var i=(typeof VBI=="object")||window.VBI;if(i){return;}window.VBI={m_bIsMyChromeTest:(/chrome/gi).test(navigator.appVersion),m_bIsIDevice:sap.ui.Device.os.ios,m_bIsAndroid:sap.ui.Device.os.android,m_bIsMobile:sap.ui.Device.system.phone||(sap.ui.Device.system.tablet&&!sap.ui.Device.system.combi),m_bIsPhone:jQuery.device.is.phone,m_bIsRtl:(document.dir=="rtl")?true:false,m_ctrlKey:false,m_shiftKey:false,m_dwRefKeyboardHook:0,GetGeoLocationService:function(){if(this.GeoLocationService){return this.GeoLocationService;}this.GeoLocationService=new VBI.GeoLocation();return this.GeoLocationService;},Events:function(){var c={};var h=c.hasOwnProperty;return{subscribe:function(a,b){if(!h.call(c,a)){c[a]=new Set();}c[a].add(b);return{unsubscribe:function(){c[a].delete(b);}};},fire:function(a,d){if(!h.call(c,a)){return;}c[a].forEach(function(a){a(d||{});});}};},m_DndTarget:null,m_Log:"",m_bTrace:(function(){var e=document.getElementById('VBITrace');return(e!=null)?true:false;})(),Trace:function(t){if(typeof console!="undefined"){jQuery.sap.log.info(t+"\r\n");}var a=document.getElementById('VBITrace');if(a==null){return;}VBI.m_Log=VBI.m_Log+t+"<br>";a.innerHTML=VBI.m_Log;},RegisterKeyboardHook:function(){++window.VBI.m_dwRefKeyboardHook;if(window.VBI.m_dwRefKeyboardHook>1){return;}window.VBI.onkeydown=function(e){if(e.keyCode==16){VBI.m_shiftKey=true;}else if(e.keyCode==17){VBI.m_ctrlKey=true;}};window.VBI.onkeyup=function(e){if(e.keyCode==16){VBI.m_shiftKey=false;}else if(e.keyCode==17){VBI.m_ctrlKey=false;}};document.addEventListener('keydown',window.VBI.onkeydown);document.addEventListener('keyup',window.VBI.onkeyup);},UnRegisterKeyboardHook:function(){--window.VBI.m_dwRefKeyboardHook;if(window.VBI.m_dwRefKeyboardHook>0){return;}document.removeEventListener('keydown',window.VBI.onkeydown);document.removeEventListener('keyup',window.VBI.onkeyup);window.VBI.onkeydown=null;window.VBI.onkeyup=null;}};jQuery.sap.require("sap.ui.vbm.lib.saputilities");jQuery.sap.require("sap.ui.vbm.lib.sapvbicontext");jQuery.sap.require("sap.ui.vbm.lib.sapdataprovider");jQuery.sap.require("sap.ui.vbm.lib.sapresources");jQuery.sap.require("sap.ui.vbm.lib.sapgeomath");jQuery.sap.require("sap.ui.vbm.lib.sapmaplayer");jQuery.sap.require("sap.ui.vbm.lib.sapmapprovider");jQuery.sap.require("sap.ui.vbm.lib.sapmapmanager");jQuery.sap.require("sap.ui.vbm.lib.sapvoutils");jQuery.sap.require("sap.ui.vbm.lib.sapvobase");jQuery.sap.require("sap.ui.vbm.lib.sapevents");jQuery.sap.require("sap.ui.vbm.lib.saplabels");jQuery.sap.require("sap.ui.vbm.lib.sappositioning");jQuery.sap.require("sap.ui.vbm.lib.sapscene");jQuery.sap.require("sap.ui.vbm.lib.sapwindow");jQuery.sap.require("sap.ui.vbm.lib.sapactions");jQuery.sap.require("sap.ui.vbm.lib.sapautomations");jQuery.sap.require("sap.ui.vbm.lib.sapgeolocation");jQuery.sap.require("sap.ui.vbm.lib.sapgeotool");jQuery.sap.require("sap.ui.vbm.lib.sapscale");jQuery.sap.require("sap.ui.vbm.lib.sapnavigation");jQuery.sap.require("sap.ui.vbm.lib.sapvbmenu");jQuery.sap.require("sap.ui.vbm.lib.sapprojection");jQuery.sap.require("sap.ui.vbm.lib.sapvbcluster");jQuery.sap.require("sap.ui.vbm.lib.sapparsing");jQuery.sap.require("sap.ui.vbm.lib.sapconfig");jQuery.sap.require("sap.ui.vbm.lib.saplassotrack");jQuery.sap.require("sap.ui.vbm.lib.saprecttrack");jQuery.sap.require("sap.ui.core.IconPool");jQuery.sap.require("sap.ui.core.theming.Parameters");window.VBI.Utilities.GetTransparentImage();})();(function(){"use strict";if(!window.DataTransfer){return;}if(typeof window.DataTransfer.prototype.setDragImage!=='function'){VBI.Utilities.SetDragImage=function(i,o,a){var r,d,b,h,e;r='setdragimage-ie-dragging-'+Math.round(Math.random()*Math.pow(10,5))+'-'+Date.now();d=['.'+r,'{','background: url("'+i.src+'") no-repeat #fff 0 0 !important;','width: '+i.width+'px !important;','height: '+i.height+'px !important;','text-indent: -9999px !important;','border: 0 !important;','outline: 0 !important;','}','.'+r+' * {','display: none !important;','}'];b=document.createElement('style');b.innerText=d.join('');h=document.getElementsByTagName('head')[0];h.appendChild(b);e=VBI.m_DndTarget;e.classList.add(r);setTimeout(function(){h.removeChild(b);e.classList.remove(r);},0);};}})();
},
	"sap/ui/vbm/lib/sapvbicontext.js":function(){
VBI.VBIContext=function(c){"use strict";var v={};v.vbiclass="VBIContext";v.m_bLoaded=false;v.m_Resources=null;v.m_Config=null;v.m_DataTypeProvider=null;v.m_DataProvider=null;v.m_SceneManager=null;v.m_MapProviders=null;v.m_MapLayerStackManager=null;v.m_Windows=null;v.m_Actions=null;v.m_Automations=null;v.m_Menus=null;v.m_Control=c;v.m_deltacolTable=[];var n=new Date();v.m_StartupTime=n.getTime();v.clear=function(){if(v.m_Resources){v.m_Resources.clear();}if(v.m_Config){v.m_Config.clear();}if(v.m_DataTypeProvider){v.m_DataTypeProvider.clear();}if(v.m_DataProvider){v.m_DataProvider.clear();}if(v.m_SceneManager){v.m_SceneManager.clear();}if(v.m_MapProviders){v.m_MapProviders.clear();}if(v.m_MapLayerStackManager){v.m_MapLayerStackManager.clear();}if(v.m_Windows){v.m_Windows.clear();}if(v.m_Actions){v.m_Actions.clear();}if(v.m_Automations){v.m_Automations.clear();}if(v.m_Menus){v.m_Menus.clear();}v.m_Control=null;v.m_Resources=null;v.m_Config=null;v.m_DataTypeProvider=null;v.m_DataProvider=null;v.m_SceneManager=null;v.m_MapProviders=null;v.m_MapLayerStackManager=null;v.m_Windows=null;v.m_Actions=null;v.m_Automations=null;v.m_Menus=null;};v.GetResources=function(){if(!v.m_Resources){v.m_Resources=new VBI.Resources();}return(v.m_Resources);};v.GetConfig=function(){if(!v.m_Config){v.m_Config=new VBI.Configurations();}return(v.m_Config);};v.GetMainScene=function(){if(v.m_Windows){var w=v.m_Windows.GetMainWindow();if(w){var s=w.GetScene();if(s){return s;}}}return null;};v.FireAction=function(b,s,d,e,p,i,f,h){var g=null;if(jQuery.type(d)=='object'){g=d.m_ID;}else if(jQuery.type(d)=='string'){g=d;}var o={};var r=(o["SAPVB"]={});r["version"]="2.0";r["xmlns:VB"]="VB";var A=(r["Action"]={});A.name=b.m_name;A.object=g;A.id=b.m_id;if(i!=undefined){A.instance=i;}else if(e){A.instance=e.GetPath();}var x=0.0;var y=0.0;var m=false;if(p){A.Params={};A.Params.Param=[];for(var a in p){var t={};t["name"]=a;t["#"]=p[a];A.Params.Param.push(t);if(a=='x'){x=p[a];m=true;}if(a=='y'){y=p[a];m=true;}}}if(d=="Thumbnail"){x*=(s.GetInternalDivWidth()/s.m_Div.clientWidth);y*=(s.GetInternalDivHeight()/s.m_Div.clientHeight);}if(v.m_DataProvider){v.m_DataProvider.store(r);}var l;if(b.m_additionalProperties&&(l=b.m_additionalProperties.length)){var j=A.AddActionProperties={};var k=j.AddActionProperty=[];for(var q=0;q<l;++q){var u,w;switch(b.m_additionalProperties[q]){case'zoom':k.push({name:'zoom','#':s.GetCurrentZoomlevel().toString()});break;case'pieitem':if(d instanceof VBI.VisualObjects.Pie&&h){k.push({name:'pieitem','#':h.m_Detail.m_slice});}break;case'centerpoint':u=VBI.MathLib.RadToDeg(s.GetCenterPos());k.push({name:'centerpoint','#':u[0].toString()+';'+u[1].toString()+';0.0'});break;case'vos':k.push({name:'vos','#':e.cnt});break;case'subclusters':w=(e.isCl==4&&e.bw!=undefined?e.bw.length:-1);k.push({name:'subclusters','#':w});break;case'clustersnextlod':if(e.isCl==4&&e.bw!=undefined){w=(s.GetCurrentZoomlevel()==e.lod?e.bw.length:1);}else{w=-1;}k.push({name:'clustersnextlod','#':w});break;case'clusterarea':var z="";if(e.isCl==4&&e.bo!=undefined){z=this.m_Clustering.getClusterArea(s,e);}k.push({name:'clusterarea','#':z});break;case'pos':if(m){u=s.GetPosFromVPPoint([x,y,0]);k.push({name:'pos','#':u[0].toString()+';'+u[1].toString()+';0.0'});}break;case'pitch':k.push({name:'pitch','#':'0.0'});break;case'yaw':k.push({name:'yaw','#':'0.0'});break;default:break;}}}var B=JSON.stringify(r,null,'  ');if(v.m_Control){if(f){return v.m_Control.fireEvent("submit",{data:B},true);}v.m_Control.fireSubmit({data:B});}};v.onRenderLayer=function(a){v.m_Control.fireRender({canvas:a});};v.onMoveLayer=function(a){v.m_Control.fireMove({canvas:a});};v.onZoomLayer=function(a){v.m_Control.fireZoom({canvas:a});};v.onOpenWindow=function(i,d){v.m_Control.fireOpenWindow({id:i,contentarea:d});};v.onCloseWindow=function(i,d){v.m_Control.fireCloseWindow({id:i,contentarea:d});};v.onOpenContainer=function(i,d){v.m_Control.fireContainerCreated({id:i,contentarea:d});};v.onCloseContainer=function(i,d){v.m_Control.fireContainerDestroyed({id:i,contentarea:d});};v.onChangeTrackingMode=function(m,s){v.m_Control.fireChangeTrackingMode({mode:m,bSet:s});};v.DoMinimize=function(s){var t=v.moThumbnail;var a=this.m_Control;var S;if(!t.bThumbnailed){t.strOrgWidth=this.m_Control.getWidth();t.strOrgHeight=this.m_Control.getHeight();t.nOrgWidth=t.nFullWidth?t.nFullWidth:s.m_nDivWidth;t.nOrgHeight=t.nFullHeight?t.nFullHeight:s.m_nDivHeight;t.bThumbnailed=true;S=((t.nThumbWidth===s.m_nDivWidth)&&(t.nThumbHeight===s.m_nDivHeight));}else{S=((t.nThumbWidth===parseInt(a.getWidth(),10))&&(t.nThumbHeight===parseInt(a.getHeight(),10)));if(t.nFullWidth&&t.nOrgWidth!=t.nFullWidth){t.nOrgWidth=t.nFullWidth;S=true;}if(t.nFullHeight&&t.nOrgHeight!=t.nFullHeight){t.nOrgHeight=t.nFullHeight;S=true;}}if(t.nThumbWidth<=0&&t.nOrgHeight>0){t.nThumbWidth=t.nOrgWidth/t.nOrgHeight*t.nThumbHeight;}if(t.nThumbHeight<=0&&t.nOrgWidth>0){t.nThumbHeight=t.nOrgHeight/t.nOrgWidth*t.nThumbWidth;}a.setWidth(t.nThumbWidth);a.setHeight(t.nThumbHeight);if(S){s.resizeCanvas(0);}};return v;};
},
	"sap/ui/vbm/lib/sapvbmenu.js":function(){
VBI.Menus=function(){"use strict";var m={};m.m_menus=[];m.clear=function(){for(var n=m.m_menus.length-1;n>=0;--n){m.m_menus[n].destroy();m.m_menus.pop();}m.m_menus=[];};m.loadMainMenu=function(d,c){var M=new sap.ui.unified.Menu();m.loadMenu(M,d,c,M.getId());M.vbi_data={};M.vbi_data.menuRef=d.id;M.vbi_data.VBIName=d.name;M.attachItemSelect(function(e){var r={};r.refid=e.mParameters.item.vbi_data.refid;r.menu=M;m.OnSelected(r);});m.m_menus.push(M);return M;};m.loadMenu=function(M,d,c,i){var a=jQuery.type(d.MenuItem)=='object';var b=(a?1:d.MenuItem.length);for(var e=0;e<b;++e){var s=(a?d.MenuItem:d.MenuItem[e]);if(s.active=="false"){continue;}var f;f=i+"_"+e;var t=s.Separator==undefined?s.text:"---------------------------";var o=new sap.ui.unified.MenuItem("vbimi_"+f,{text:t});o.vbi_data={};if((s.disabled=="true")||(s.Separator!=undefined)){o.setEnabled(false);}M.addItem(o);if(s.icon){o.setIcon(s.icon);}if(VBI.m_bTrace){VBI.Trace("Adding Menuitem: menuitem_"+f+" with text "+t);}if(s.MenuItem!=undefined){var S=new sap.ui.unified.Menu("vbim_"+f);o.setSubmenu(S);m.loadMenu(S,s,c,f);}else if(s.id!=""){o.vbi_data.refid=s.id;}}};m.deleteMenu=function(a){var i=m.findMenuIdxByName(a);if(i>=0){var l=m.m_menus.length-1;m.m_menus[i].destroy();if(i!=l){m.m_menus[i]=m.m_menus[l];}m.m_menus.pop();return i;}return-1;};m.getMainScene=function(c){if(c.m_SceneManager.m_SceneArray.length==1){return c.m_SceneManager.m_SceneArray[0].m_ID;}return undefined;};m.load=function(d,c){sap.ui.getCore().loadLibrary("sap.ui.unified");m.m_context=c;if(d.Set){if(d.Set.name!=undefined){m.deleteMenu(d.Set.name);}else{m.clear();}if(jQuery.type(d.Set)=='object'){if(d.Set.Menu){m.loadMainMenu(d.Set.Menu,c);}}else if(jQuery.type(d.Set)=='array'){for(var n=0;n<d.Set.length;++n){if(d.Set[n].Menu){m.loadMainMenu(d.Set[n].Menu,c);}}}}};m.findMenuByID=function(a){if(m.m_menus){for(var i=0;i<m.m_menus.length;++i){if(m.m_menus[i].vbi_data.menuRef==a){return m.m_menus[i];}}}return null;};m.findMenuIdxByName=function(a){if(m.m_menus){for(var i=0;i<m.m_menus.length;++i){if(m.m_menus[i].vbi_data.VBIName==a){return i;}}}return-1;};m.OnSelected=function(r){var a=r.menu.vbi_data.object;if(r.refid==undefined){return;}var s=m.m_context.m_SceneManager.GetSceneByName(r.menu.vbi_data.scene);var b=m.m_context.m_Actions;if(b){if(b.findAction("ContextMenu",s,a)){var c=new VBI.Actions.Action();c.m_name="FCODE_SELECT";c.m_id=r.refid;s.m_Ctx.FireAction(c,s,a,null,null,r.menu.vbi_data.instance);}}};return m;};
},
	"sap/ui/vbm/lib/sapvobase.js":function(){
VBI.VisualObjects=function(){"use strict";VBI.EMHandle=0;VBI.EMBox=1;VBI.HTHANDLE=0;VBI.HTBOX=1;VBI.HTBOXHANDLE=2;var v={};v.vbiclass="VisualObjects";v.Factory={"{00100000-2012-0004-B001-64592B8DB964}":function(){return new VBI.VisualObjects.Spot();},"{00100000-2012-0004-B001-C46BD7336A1A}":function(){return new VBI.VisualObjects.Route();},"{00100000-2013-0004-B001-7EB3CCC039C4}":function(){return new VBI.VisualObjects.Circle();},"{00100000-2013-0004-B001-686F01B57873}":function(){return new VBI.VisualObjects.CircleDist();},"{00100000-2012-0004-B001-383477EA1DEB}":function(){return new VBI.VisualObjects.Pie();},"{00100000-2012-0004-B001-BFED458C3076}":function(){return new VBI.VisualObjects.Box();},"{00100000-2012-0004-B001-F311DE491C77}":function(){return new VBI.VisualObjects.Area();},"{00100000-2012-0004-B001-E180770E8A12}":function(){return new VBI.VisualObjects.HeatMap();},"{00100000-2012-0070-1000-35762CF28B6B}":function(){return new VBI.VisualObjects.Dummy();},"{388951f5-a66b-4423-a5ad-e0ee13c2246f}":function(){return new VBI.VisualObjects.Dummy();},"{00100000-2014-0004-B001-9F1B43BE944A}":function(){return new VBI.VisualObjects.Route();},"{00100000-2014-0004-BDA8-87B904609063}":function(){return new VBI.VisualObjects.Area();},"{00100000-2012-0004-B001-2297943F0CE6}":function(){return new VBI.VisualObjects.Container();},"{00100000-2013-1000-1100-50059A6A47FA}":function(){return new VBI.VisualObjects.Caption();},"{00100000-2013-1000-3700-AD84DDBBB31B}":function(){return new VBI.VisualObjects.Label();},"{00100000-2013-1000-2400-D305F7942B98}":function(){return new VBI.VisualObjects.Link();},"{00100000-2013-1000-2200-6B060A330B2C}":function(){return new VBI.VisualObjects.Image();},"{00100000-2013-1000-1200-855B919BB0E9}":function(){return new VBI.VisualObjects.Button();}};v.Factory3D={"{00100000-2012-0004-B001-BFED458C3076}":function(){return new VBI.VisualObjects.Box3D();},"{00100000-2012-0070-1000-35762CF28B6B}":function(){return new VBI.VisualObjects.Dummy();}};v.Factory.CreateInstance=function(c){return v.Factory[c]();};v.Factory3D.CreateInstance=function(c){return v.Factory3D[c]();};VBI.VisualObjects.Base={m_Scene:null,m_BB:[],m_IO:[],m_colorHot:'rgba( 240, 171, 0, 0.5 )',m_defaultColor:'rgba( 255, 0, 0, 1.0 )',m_defaultTooltip:'',m_defaultLabeltext:'',m_defaultLabelBgCol:'rgba(200,200,200,1.0)',m_DH:[],m_szHandle:6,m_Track:null,m_tt:"",m_pos:"",m_clientX:0,m_clientY:0,m_nActiveSelections:0,SetRichTooltip:function(h){var s=this.m_Scene;var c=this.m_Scene.m_Ctx;var p=(this.m_Pos!=null)?this.m_Pos.GetValueVector(c):this.m_PosM.GetValueVector(c);if(this.m_tt instanceof sap.ui.core.TooltipBase){if(h){if(this.m_tt!=""&&this.m_pos==""){s.SetToolTip(this.m_tt,true,this.m_clientX,this.m_clientY);this.m_pos=p;}}else if(JSON.stringify(this.m_pos)==JSON.stringify(p)){s.SetToolTip(this.m_tt,false);this.m_pos="";}}},SetClusteredRichTooltip:function(e){var s=this.m_Scene;var p=[e[0],e[1]];if(this.m_tt instanceof sap.ui.core.TooltipBase){if(e.h){if(this.m_tt!=""&&e.m_pos==undefined){s.SetToolTip(this.m_tt,true,this.m_clientX,this.m_clientY);e.m_pos=p;}}else if(JSON.stringify(e.m_pos)==JSON.stringify(p)){s.SetToolTip(this.m_tt,false);e.m_pos=undefined;}}},LoadDragDropInfo:function(d,c,i){if(d.DragSource&&d.DragSource.DragItem){i.m_DragSourceInfo=new VBI.DnDInfo();i.m_DragSourceInfo.load(d.DragSource.DragItem,c,i);}if(d.DropTarget&&d.DropTarget.DropItem){i.m_DropTargetInfo=new VBI.DnDInfo();i.m_DropTargetInfo.load(d.DropTarget.DropItem,c,i);}},BaseLoad:function(d,c,i){if(VBI.m_bTrace){VBI.Trace("BaseLoad");}i.m_Props.push(i.m_HotScale=new VBI.AttributeProperty(d,'hotScale',i.m_DataSource,c,[1.0,1.0,1.0]));i.m_Props.push(i.m_HotDeltaColor=new VBI.AttributeProperty(d,'hotDeltaColor',i.m_DataSource,c,null));i.m_Props.push(i.m_SelectColor=new VBI.AttributeProperty(d,'selectColor',i.m_DataSource,c,null));i.m_Props.push(i.m_NonSelectColor=new VBI.AttributeProperty(d,'nonSelectColor',i.m_DataSource,c,null));i.m_Props.push(i.m_FxSize=new VBI.AttributeProperty(d,'fxsize',i.m_DataSource,c,true));i.m_Props.push(i.m_FxDir=new VBI.AttributeProperty(d,'fxdir',i.m_DataSource,c));i.m_Props.push(i.m_Entity=new VBI.AttributeProperty(d,'entity',i.m_DataSource,c,null));i.m_Props.push(i.m_Labeltext=new VBI.AttributeProperty(d,'labelText',i.m_DataSource,c,i.m_defaultLabeltext));i.m_Props.push(i.m_LabelBgCol=new VBI.AttributeProperty(d,'labelBgColor',i.m_DataSource,c,i.m_defaultLabelBgCol));i.m_Props.push(i.m_LabelBrdrCol=new VBI.AttributeProperty(d,'labelBorderColor',i.m_DataSource,c,null));i.m_Props.push(i.m_LabelArrow=new VBI.AttributeProperty(d,'labelArrow',i.m_DataSource,c,false));i.m_Props.push(i.m_LabelRounded=new VBI.AttributeProperty(d,'labelRounded',i.m_DataSource,c,false));i.m_Props.push(i.m_LabelPos=new VBI.AttributeProperty(d,'labelPos',i.m_DataSource,c));i.m_Props.push(i.m_LabelOffset=new VBI.AttributeProperty(d,'labelOffset',i.m_DataSource,c,[0,0]));i.m_Props.push(i.m_LabelIcon=new VBI.AttributeProperty(d,'labelIcon',i.m_DataSource,c));i.m_Props.push(i.m_LabelIcBgrdCol=new VBI.AttributeProperty(d,'labelIconBgrdCol',i.m_DataSource,c));i.m_Props.push(i.m_LabelIcTextCol=new VBI.AttributeProperty(d,'labelIconTextCol',i.m_DataSource,c));i.m_Props.push(i.m_DragData=new VBI.AttributeProperty(d,'dragdata',i.m_DataSource,c,null));if(!VBI.m_bIsMobile){this.LoadDragDropInfo(d,c,i);}},BaseMousemove:function(e){if(VBI.m_bTrace){VBI.Trace("BaseMousemove");}if(this.m_Track){return false;}if(!this.GetHitArray){return false;}if(this.m_Scene.vbiclass=="3DScene"){return false;}var h=this.GetHitArray(e.offsetX,e.offsetY);var s=this.m_Scene;if(h.length>0){s.SetCursor('pointer');if(s.InternalSetHotItem(this,h[0])){if(!h[0].m_Design&&this.m_Tooltip){this.m_tt=this.getTooltip(s.m_Ctx,h[0]);if(VBI.m_bIsRtl){var x=s.GetEventVPCoords(e);this.m_clientX=x[0];}else{this.m_clientX=e.clientX;}this.m_clientY=e.clientY;var t=this.m_tt.split("#");if(t[0]=="rtt"){var i=t[1];this.m_tt=sap.ui.vbm.VBI.RttMap[i];}else{s.SetToolTip(this.m_tt);}}var c;if((c=this.DetailCursor(e,h[0]))){s.SetCursor(c);}}if(this.m_DragSourceInfo){s.m_Canvas[s.m_nLabelIndex].draggable=true;}}else if(s.m_Canvas[s.m_nLabelIndex].draggable==true){s.m_Canvas[s.m_nLabelIndex].draggable=false;}return h.length>0?true:false;},BaseContextmenu:function(e){if(VBI.m_bTrace){VBI.Trace("BaseContextmenu");}if(!this.GetHitArray){return false;}var s=this.m_Scene;if(s.vbiclass=="3DScene"){return false;}if(e.hitTests){e.hitTests=e.hitTests.concat(this.GetHitArray(e.offsetX,e.offsetY,true));return e.hitTests.length>0;}var h=e.hitCached?e.hitCached:this.GetHitArray(e.offsetX,e.offsetY,false)[0];if(!h){return false;}var i=this.GetDataIndex(h.m_Index);var a,b=s.m_Ctx.m_Actions;var d;var c=this.m_DataSource.GetIndexedElement(s.m_Ctx,i);if(c){if(b&&h.m_Design&&(h.m_Hit==VBI.HTHANDLE)){if((a=b.findAction("HandleContextMenu",s,this))){var p=s.GetEventVPCoordsObj(e);p.handle=h.m_Handle.toString();s.m_Ctx.FireAction(a,s,this,c,p);e.preventDefault();return true;}}if(this.DetailContextmenu(e,c,h)){e.preventDefault();return true;}}else{var r=this.m_BBRefs[h.m_Index];d=s.m_Ctx.m_Clustering.getClusterIdent(s.m_PreassembledData,r.cI,r.i);c=this.GetPreassembledElement(h.m_Index);}if(b){if((a=b.findAction("ContextMenu",s,this))){s.m_Ctx.FireAction(a,s,this,c,s.GetEventVPCoordsObjWithScene(e),d,null,h);e.preventDefault();return true;}}e.preventDefault();return false;},BaseFindAction:function(n){var s=this.m_Scene,a=s.m_Ctx.m_Actions;return a?a.findAction(n,s,this):null;},BaseClick:function(e){if(VBI.m_bTrace){VBI.Trace("BaseClick");}if(!this.GetHitArray){return false;}var s=this.m_Scene;if(s.vbiclass=="3DScene"){return false;}if(e.hitTests){e.hitTests=e.hitTests.concat(this.GetHitArray(e.offsetX,e.offsetY,true));return e.hitTests.length>0;}var h=e.hitCached?e.hitCached:this.GetHitArray(e.offsetX,e.offsetY,false)[0];if(!h){return false;}var i=this.GetDataIndex(h.m_Index);s.RenderAsync(false);var a;var d;if(i>=0&&(a=this.m_DataSource.GetIndexedElement(s.m_Ctx,i))){this.m_DataSource.Select(i);if((e.type.indexOf("touch")>=0)||(e.type.indexOf("pointer")>=0||((e.ctrlKey||e.metaKey)&&!e.shiftKey))){this.Select(a,s.m_Ctx,this.IsSelected(s.m_Ctx)?false:true);}else if(e.shiftKey){if(!this.IsSelected(s.m_Ctx)){this.Select(a,s.m_Ctx,true);}}else{this.m_nActiveSelections=a.GlobalSingleSelect();}if(s.m_PreassembledData){s.UpdatePreData4Selected(this.m_nPreDataIndex,this.GetInternalIndex(h.m_Index));}if(h.m_Handle>=0){e.preventDefault();return true;}else if(this.IsPosChangeable(s.m_Ctx)){var b=this.m_DataSource.GetEditMode(s.m_Ctx)==VBI.EMHandle?VBI.EMBox:VBI.EMHandle;if(VBI.m_bTrace){VBI.Trace("SetEditMode: "+b);}this.m_DataSource.SetEditMode(s.m_Ctx,b);e.preventDefault();return true;}if(this.DetailClick(e,a,h)){e.preventDefault();return true;}}else{var r=this.m_BBRefs[h.m_Index];d=s.m_Ctx.m_Clustering.getClusterIdent(s.m_PreassembledData,r.cI,r.i);a=this.GetPreassembledElement(h.m_Index);}var c;if((c=s.m_Ctx.m_Actions)){var f;if((f=c.findAction("Click",s,this))){this.m_Scene.m_Ctx.FireAction(f,s,this,a,s.GetEventVPCoordsObj(e),d,null,h);e.preventDefault();return true;}}return false;},GetPreassembledElement:function(i){return undefined;},BaseHitTest:function(n,a,o){var h=[];var b={};if(this.BaseDesignHitTest(n,a,b)){h.push(b);return h;}var m=new Map;var l=this.getLabelData(false);if(l){for(var i=l.length-1;i>=0;--i){var c=l[i];var r=VBI.Types.string2rgba(c.m_BgColor);if(r[3]<0.1&&r[4]==1){continue;}for(var j=0;j<c.m_Pos.length;++j){for(var k=0;k<c.m_Pos[j].length;++k){var p=[n,a];var x=c.m_Pos[j][k][0];var y=c.m_Pos[j][k][1];var t=c.m_Pos[j][k].tri;var d=c.m_Pos[j][k].rc;var e=[x,y,x+c.m_Width,y+c.m_Height];if(VBI.Utilities.PtInRect(p,e)||(t&&VBI.Utilities.pointInTriangle(t,p))||(d&&VBI.Utilities.PtInRect(p,d))){var f={m_Vo:this,m_Index:c.mIndex,m_Entity:this.GetEntity(c.mIndex,this.m_Scene.m_Ctx)};if(o.m_All){m.set(f.m_Index,f);}else{h.push(f);}if(!o.m_All){return h;}}}}}}for(var i=this.m_BB.length-1;i>=0;--i){var g=this.m_BB[i];if(g){for(var j=this.m_IO[i].length-1;j>=0;--j){var q=this.m_IO[i][j];if(!VBI.Utilities.PtInRect([n-q,a],g)){continue;}if(o){var s=o.m_cb(o,i,n-q,a);if(s&&s.m_hit>0){var f={m_Vo:this,m_Index:i,m_Entity:this.GetEntity(i,this.m_Scene.m_Ctx),m_Detail:s,m_IO:q};if(o.m_All){m.set(f.m_Index,f);}else{h.push(f);}if(!o.m_All&&s.m_hit==1){return h;}}}}}}if(o.m_All){m.forEach(function(u){h.push(u);});}return h;},clear:function(){var n;if(this.m_Props){for(n=0;n<this.m_Props.length;++n){this.m_Props[n].clear();}this.m_Props=null;}if(this.m_DragSourceInfo){this.m_DragSourceInfo.clear();this.m_DragSourceInfo=null;}if(this.m_DropTargetInfo){this.m_DropTargetInfo.clear();this.m_DropTargetInfo=null;}this.m_Scene=null;this.m_Track=null;this.m_BB=null;this.m_IO=null;this.m_DH=null;if(this.m_Label){for(n=0;n<this.m_Label.length;++n){this.m_Label[n].clear();}this.m_Label=[];}},load:function(d,c){if(d.id){this.m_ID=d.id;}this.m_Props=[];this.m_DragSourceInfo=null;this.m_DropTargetInfo=null;},NotifyDataChange:function(c){if(this.m_Props){for(var n=0,l=this.m_Props.length;n<l;++n){this.m_Props[n].NotifyDataChange(c);}}this.m_bChanged=true;this.m_nActiveSelections=undefined;},IsPosChangeable:function(c){if(VBI.m_bMouseSupported&&this.m_Pos){return this.m_Pos.IsChangeable(c);}return false;},IsSelected:function(c){if(this.m_DataSource){return this.m_DataSource.IsElementSelected(c);}return false;},GetNumActiveSelections:function(c){if(this.m_nActiveSelections===undefined){this.m_nActiveSelections=0;var a=this.m_DataSource.m_nCurElement;var n=this.m_DataSource.GetCurrentNode(c);if(n){for(var b=0,l=n.m_dataelements.length;b<l;++b){this.m_DataSource.Select(b);if(this.IsSelected(c)){this.m_nActiveSelections++;}}}this.m_DataSource.Select(a);}return this.m_nActiveSelections;},Select:function(e,c,s){this.m_nActiveSelections=e.Select(s,this.GetNumActiveSelections(c));},IsHandleMode:function(){return this.m_DataSource.GetEditMode(this.m_Scene.m_Ctx)==VBI.EMHandle?true:false;},IsBoxMode:function(){return this.m_DataSource.GetEditMode(this.m_Scene.m_Ctx)==VBI.EMBox?true:false;},IsDataAccepted:function(e){var s=this.m_Scene;if(this.m_Track){if(VBI.m_bTrace){VBI.Trace("Error: Track object should be already gone");}return false;}if(!this.GetHitArray){return false;}var h,a=this.GetHitArray(e.offsetX,e.offsetY);if(a.length&&(h=a[0]).m_Design){return false;}if(a.length&&s.m_DragInfo){this.m_DataSource.Select(h.m_Index);if(this.m_DropTargetInfo){var c=s.m_Ctx;var d=this.m_DropTargetInfo.getItemArray(c);var D=s.m_DragInfo.aItems;for(var n=0;n<d.length;++n){if(D.indexOf(d[n])!=-1){try{e.dataTransfer.dropEffect='copy';e.stopPropagation();e.preventDefault();}catch(b){if(VBI.m_bTrace){VBI.Trace("Warning: sapvobase.IsDataAccepted exception occured: "+b.message);}}return h;}}}}return false;},GetEntity:function(n,c){this.m_DataSource.Select(n);return this.m_Entity.GetValueString(c);},IsHot:function(i){var s=this.m_Scene,h=s.m_HotItem;if(h.m_Entity&&h.m_Entity==this.m_Entity.GetValueString(s.m_Ctx)){return true;}if(!h.m_HitObj||h.m_Index!=i){return false;}if(h.m_Design){return false;}if(h.m_VO!=this){return false;}return true;},InternalChangeHotItem:function(o,n){},IsClusterable:function(){return false;},GetDataIndex:function(B){return B;},GetInternalIndex:function(B){return B;},getTooltip:function(c,h){this.m_DataSource.Select(h.m_Index);return this.m_Tooltip.GetValueString(c);},getLabelText:function(c,h){this.m_DataSource.Select(h.m_Index);return this.m_Labeltext.GetValueString(c);},getLabelData:function(r){if(!this.m_Label){return null;}if(r){for(var n=0;n<this.m_Label.length;n++){var l=this.m_Label[n];if(l.CalculateLabelPos&&l.m_PosArray.pa.length>0){l.m_Pos=[];for(var a=0;a<l.m_aIO.length;a++){var p=this.CalculateLabelPos(this.m_Scene,l.m_PosArray,l.m_aIO[a]);if(p&&p.length>0){l.m_Pos.push(p);}}l.m_bAligned=false;}}}return this.m_Label;},SwitchPreDataRendering:function(s){if(this.bUsePreData!=s){this.bUsePreData=s;if(s){this.IsHot=this.PreDataIsHot;this.GetEntity=this.PreDataGetEntity;}else{this.IsHot=this.BaseIsHot;this.GetEntity=this.BaseGetEntity;}}},GetAnimClusterDistance:function(n,e){var s=this.m_Scene;var a=n-e;if(a&&s.m_bNonIntPosStable){var t=1000*a;var b=Date.now()-s.m_bNonIntPosStable;a*=(b<t?(t-b)/t:0);}s.m_bLineAnimationRunning=(a>0);return a;},RenderTree:function(n,e,c,a,b,l,d,f,g,h,x,y,o){var j=[h*n.bo[0]-x,h*n.bo[1]-y,h*n.bo[2]-x,h*n.bo[3]-y];var I=this.m_Scene.GetInstanceOffsets(j);if(I.length){if(n.lod<l){for(var i=0;i<n.bw.length;++i){b=this.RenderTree(n.bw[i],e,c,a,b,l,d,f,g,h,x,y,o);}}else if(n.isCl){if(this.RenderThisInstance(n,e,c,a,b,n.nJ,f,g,l,d,h,x,y,false)){b++;}}else if(!o){var m=this.m_Scene.m_VOS[n.vo];m.RenderThisInstance(n,e,c,a,m.m_BB.length,n.nJ,f,g,l,d,h,x,y,true);m.SetClusteredRichTooltip(n);}}return b;},Init4Render:function(){},StandardInit:function(){this.m_BB=[];this.m_IO=[];this.m_DH=[];},StandardInitWithLPs:function(){this.m_BB=[];this.m_IO=[];this.m_DH=[];this.m_LP=[];},BaseRender:function(c,d){var l=this.m_DH.length;if(!l){return;}var t,a,b;var s=this.m_szHandle,h=s/2,e=1.5*s*s;var f=d.fillStyle;var g='rgba(232,205,30,0.7)';var i='rgba(188,54,24,0.7)';var j='rgba(229, 66, 30, 1.0 )';var k=this.m_Scene.m_HotItem;var H,x,S=false;for(var n=0;n<l;++n){if(!(H=this.m_DH[n])){continue;}for(var m=0,o=this.m_IO[n].length;m<o;++m){d.setTransform(1.0,0.0,0.0,1.0,this.m_IO[n][m],0.0);if(H.m_EditMode==VBI.EMBox){if(H.length==1){x=H[0];VBI.Utilities.DrawDesignRect(d,this.DesignGetActiveBoxHandles(n),x);}}else{d.fillStyle=i;d.lineWidth=1;t=null;if(S){d.fillStyle=i;S=false;}for(var p=0,q=H.length;p<q;++p){x=H[p];var r=(k.m_VO==this&&k.m_Index==n&&k.m_Design&&k.m_HitObj&&k.m_HitObj.m_Handle==p);if(t&&(((a=(t[0]-x[0]))*a)+((b=(t[1]-x[1]))*b))<e){if(!S){S=true;d.fillStyle=r?j:g;d.fill();}continue;}if(S){d.fillStyle=i;S=false;}if(r){d.fillStyle=j;}d.beginPath();d.rect(x[0]-h,x[1]-h,s,s);d.closePath();d.fill();if(r){d.fillStyle=i;}t=x;}}}}d.fillStyle=f;d.setTransform(1.0,0.0,0.0,1.0,0.0,0.0);},BaseDesignHitTest:function(n,a,b){if(VBI.m_bTrace){VBI.Trace("BaseDesignHitTest nsx:"+n+" nsy:"+a+" instance:"+this.m_ID);}var l=this.m_DH.length;if(!l){return false;}var s=this.m_szHandle+2,c=s/2.0;var P=VBI.Utilities.PtInRect;if(b.m_Handle){delete b.m_Handle;}var H,d;for(var e=l;e>=0;--e){if(!(H=this.m_DH[e])){continue;}for(var f=0;f<this.m_IO[e].length;++f){var g=this.m_IO[e][f];if(H.m_EditMode==VBI.EMHandle){if(VBI.m_bTrace){VBI.Trace("BaseDesignHitTest Handle");}for(var i=0,j=H.length;i<j;++i){d=H[i];if(P([n-g,a],[d[0]-c,d[1]-c,d[0]+c,d[1]+c])){if(VBI.m_bTrace){VBI.Trace("BaseDesignHitTest Handle Hit! Index:"+e+" Handle: "+i);}b.m_Index=e;b.m_Design=true;b.m_Hit=VBI.HTHANDLE;b.m_Handle=i;b.m_NsX=n;b.m_NsY=a;b.m_IO=g;return true;}}}else if(H.m_EditMode==VBI.EMBox){if(VBI.m_bTrace&&(H.length>1||H.length==0)){VBI.Trace("Error: Box edit mode must fill one rectangle only");}d=H[0];if(VBI.m_bTrace){VBI.Trace("BaseDesignHitTest Box");}var r=9;var w=d[2]-d[0];var h=d[3]-d[1];var k=w/2;var m=h/2;var o=this.DesignGetActiveBoxHandles(e);for(var x=0;x<3;++x){for(var y=0;y<3;++y){if(x==1&&y==1){continue;}if(!o[y*3+x]){continue;}var p=d[0]+x*k-(n-g);var q=d[1]+y*m-(a);if((p*p+q*q)<r){b.m_Index=e;b.m_Handle=y*3+x;b.m_Design=true;b.m_Hit=VBI.HTBOXHANDLE;b.m_NsX=n;b.m_NsY=a;b.m_IO=g;return true;}}}if(P([n-g,a],d)){if(VBI.m_bTrace){VBI.Trace("BaseDesignHitTest Box Hit! Index:"+e);}b.m_Index=e;b.m_Handle=-1;b.m_Design=true;b.m_Hit=VBI.HTBOX;b.m_NsX=n;b.m_NsY=a;b.m_IO=g;return true;}}}}return false;},DesignHandleDrag:function(o,e){var s=this.m_Scene;if(VBI.m_bTrace){VBI.Trace("DesignHandleDrag");}if(VBI.m_bTrace&&(s.m_nInputMode!=VBI.InputModeTrackObject)){VBI.Trace("Error: DesignHandleDrag wrong input mode: "+s.m_nInputMode);}if(o.m_ClientX!=o.m_ClientStartX||o.m_ClientY!=o.m_ClientStartY){o.m_bDragStart=true;}if(o.m_bDragStart){this.m_DataSource.Select(o.m_Index);var p=s.GetPosFromPoint([o.m_ClientX-o.m_IO,o.m_ClientY,0]);var a=s.GetPosFromPoint([o.m_ClientStartX-o.m_IO,o.m_ClientStartY,0]);if(this.IsPosChangeable(s.m_Ctx)){var b=this.m_Pos.GetValueVector(s.m_Ctx).slice(0);var c=o.m_PosOrig;var i;if(o.hasOwnProperty('m_Handle')){if(VBI.m_bTrace){VBI.Trace("DesignHandleDrag Handle");}if(o.m_Hit==VBI.HTHANDLE){i=o.m_Handle*3;b[i]=p[0];b[i+1]=p[1];this.m_Pos.SetValueVector(s.m_Ctx,b);}else if(o.m_Hit==VBI.HTBOXHANDLE){if(this.DesignBoxSize){this.DesignBoxSize(o);}}else if(o.m_Hit==VBI.HTBOX){if(VBI.m_bTrace){VBI.Trace("DesignHandleDrag Box");}var d=(p[0]-a[0]);var f=(p[1]-a[1]);for(var n=0,l=b.length/3;n<l;++n){i=n*3;b[i]=c[i]+d;b[i+1]=c[i+1]+f;}this.m_Pos.SetValueVector(s.m_Ctx,b);}}}}s.RenderAsync(true);},DesignHandleDrop:function(o,e){var s=this.m_Scene;if(VBI.m_bTrace&&s.m_nInputMode!=VBI.InputModeTrackObject){VBI.Trace("Error: DesignHandleDrop wrong input mode: "+s.m_nInputMode);}var a,b=s.m_Ctx.m_Actions;if(b&&o.m_Design&&o.m_Handle>-1){var r=(o.m_bDragStart)?"HandleMoved":"HandleClick";if((a=b.findAction(r,s,this))){var c;if((c=this.m_DataSource.GetIndexedElement(s.m_Ctx,o.m_Index))){var p=s.GetEventVPCoordsObj(e);p.handle=o.m_Handle.toString();p.mode=o.m_Hit.toString();s.m_Ctx.FireAction(a,s,this,c,p);}}}s.SetInputMode(VBI.InputModeDefault);s.RenderAsync(true);return true;},DesignHandleEnd:function(o,e){this.m_Track.UnHook();this.m_Track=null;},DesignGetActiveBoxHandles:function(i){return[1,1,1,1,0,1,1,1,1];},onsapsecclick:function(e){return this.BaseContextmenu(e);},onsapclick:function(e){return this.BaseClick(e);},onsapmove:function(e){return this.BaseMousemove(e);},onsapup:function(e){if(!this.m_Track){return false;}this.m_Track.UnHook();this.m_Track=null;},onsapdrop:function(e){if(VBI.m_bTrace){VBI.Trace("onsapdrop in base "+e.type);}var h;if((h=this.IsDataAccepted(e))){var s=this.m_Scene;var m=this.GetDataIndex(h.m_Index);var a=this.m_DataSource.GetIndexedElement(s.m_Ctx,m);var b,c=s.m_Ctx.m_Actions;if(c){if((b=c.findAction("Drop",s,this))){this.m_Scene.m_Ctx.FireAction(b,s,this,a,s.GetEventDropObjWithScene(e));e.preventDefault();return true;}}return false;}return false;},onsapdrag:function(e){if(VBI.m_bTrace){VBI.Trace("onsapdrag in base "+e.type);}if(this.IsDataAccepted(e)){return true;}return false;},onsapdown:function(e){if(VBI.m_bTrace){VBI.Trace("onsapdown in base "+e.type);}var s=this.m_Scene;if(this.m_Track){if(VBI.m_bTrace){VBI.Trace("Error: Track object should be already gone");}return true;}if(s.vbiclass=="3DScene"){return false;}if(!this.GetHitArray){return false;}var h,a=this.GetHitArray(e.offsetX,e.offsetY);if(a.length&&(h=a[0]).m_Design){if(VBI.m_bTrace){VBI.Trace("Start Tracking on "+this.m_ID+" caused by "+e.type);}this.m_DataSource.Select(h.m_Index);h.m_CBDrag=this.DesignHandleDrag.bind(this);h.m_CBDrop=this.DesignHandleDrop.bind(this);h.m_CBEnd=this.DesignHandleEnd.bind(this);h.m_ClientStartX=e.offsetX;h.m_ClientStartY=e.offsetY;h.m_bDragStart=false;h.m_PosOrig=s.GetNearestPosArray(this.m_Pos.GetValueVector(s.m_Ctx).slice(0));s.SetInputMode(VBI.InputModeTrackObject);s.SetCursor(this.DetailCursor(e,h));if(this.DesignBeginDrag){this.DesignBeginDrag(h);}this.m_Track=new s.DesignTrack(h);e.stopPropagation();e.preventDefault();return true;}if(a.length){this.m_DataSource.Select(h.m_Index);if(this.m_DragSourceInfo&&!this.m_Pos.IsChangeable(s.m_Ctx)){var c=s.m_Ctx;var d=this.m_DragSourceInfo.getItemArray(c);if(d.length){s.m_DragInfo={};s.m_DragInfo.aItems=d;s.m_DragInfo.strInstance=this.m_DataSource.m_Path+"."+this.m_DataSource.GetCurrentElement().GetKeyValue();s.m_DragInfo.strScene=this.m_Scene.m_ID;s.m_DragInfo.strID=this.m_ID;s.m_DragInfo.strExtData=this.m_DragData.GetValueString(s.m_Ctx);s.m_DragInfo.bDragStart=false;return true;}}}return false;},DetailClick:function(e,a,h){return false;},DetailContextmenu:function(e,a,h){return false;},DetailCursor:function(e,h){if(h.m_Design){if(h.m_Hit==VBI.HTBOXHANDLE){var c=['nw-resize','n-resize','ne-resize','w-resize','','e-resize','sw-resize','s-resize','se-resize'];return c[h.m_Handle];}else if(h.m_Hit==VBI.HTBOX){return'move';}}return'pointer';},GetSelectColor:function(c,o){var r;if((r=this.m_SelectColor.GetValueString(c))){return this.ApplyDeltaColor(c,o,r);}else{return o;}},GetNonSelectColor:function(c,o){var r;if((r=this.m_NonSelectColor.GetValueString(c))){return this.ApplyDeltaColor(c,o,r);}else{return o;}},GetHotColor:function(c,o){var r;if((r=this.m_HotDeltaColor.GetValueString(c))){return this.ApplyDeltaColor(c,o,r);}else{return this.m_colorHot;}},GetAltBorderColor:function(c,o){var r;if((r=this.m_AltColorBorder.GetValueString(c))){return this.ApplyDeltaColor(c,o,r);}else{return this.GetHotColor(c,o);}},ApplyDeltaColor:function(c,o,r){var a;var k=o+r;if(c.m_deltacolTable[k]==undefined){if((a=VBI.Types.string2rhls(r))){var b;if((b=VBI.Types.color2array(o))){var h=VBI.Utilities.RGB2HLS(b[0],b[1],b[2]);var d=VBI.Utilities.HLS2RGB(h[0]+a[0],h[1]*a[1],h[2]*a[2]);c.m_deltacolTable[k]='rgba('+Math.min(Math.round(d[0]),255)+","+Math.min(Math.round(d[1]),255)+","+Math.min(Math.round(d[2]),255)+","+Math.min((a[3]*b[3]).toString(),1.0)+')';}}else{c.m_deltacolTable[k]=VBI.Types.string2color(r);}}return c.m_deltacolTable[k];},GetHotScale:function(c){var r;if((r=this.m_HotScale.GetValueVector(c))){return r;}return[1.0,1.0,1.0];},RectSelect:function(s,h,o){var t,a,f=false;for(var n=this.m_BB.length-1;n>=0;--n){if((t=this.m_BB[n])){for(var b=this.m_IO[n].length-1;b>=0;--b){var c=this.m_IO[n][b];a=[s[0]-c,s[1],s[2]-c,s[3]];if(t[0]>=a[0]&&t[1]>=a[1]&&t[2]<=a[2]&&t[3]<=a[3]){o.push(n);h.push(this.GetDataIndex(n));f=true;}}}}return f;},LassoSelectCircle:function(p,h,o){var c=[];var O,t;var f=false;for(var n=this.m_BB.length-1;n>=0;--n){var a=[];var x=this.m_BB[n].m_Pos;var r=this.m_BB[n].m_Radius;var b=20;for(var d=0;d<b;++d){t=d*2*Math.PI/b;c=[x[0]+r*Math.sin(t),x[1]+r*Math.cos(t)];a.push(c);}O=this.m_IO[n];if(VBI.Utilities.polyInPolygon(p,a,O)){h.push(n);o.push(n);f=true;}}return f;},LassoSelect:function(p,h,o){var t;var H=false,f=false;var n,a;for(var b=this.m_BB.length-1;b>=0;--b){if((t=this.m_BB[b])){H=false;for(var c=this.m_IO[b].length-1;c>=0&&!H;--c){var d=this.m_IO[b][c];var e=[[(t[0]+d),t[1]],[(t[2]+d),t[1]],[(t[2]+d),t[3]],[(t[0]+d),t[3]]];if((VBI.Utilities.pointInPolygon(p,e[0][0],e[0][1]))){H=true;for(n=0;n<e.length&&H;n+=2){var g=e[n];var i=e[n+1];for(a=0;a<p.length&&H;++a){var j=p[a];var k=(a+1==p.length)?p[0]:p[a+1];VBI.Utilities.LineLineIntersection(g,i,j,k,true);if((VBI.Utilities.LineLineIntersection(g,i,j,k,true))){H=false;}}}}}if(H){o.push(b);h.push(this.GetDataIndex(b));f=true;}}}return f;},GetLabel:function(c){var l={};var t=this.m_Labeltext.GetValueString(c);var i=this.m_LabelIcon.GetValueString(c);if(t||i){l.text=t;l.icon=i;l.icColor=this.m_LabelIcBgrdCol.GetValueColor(c);l.icTextColor=this.m_LabelIcTextCol.GetValueColor(c);l.bgColor=this.m_LabelBgCol.GetValueColor(c);l.brdrCol=this.m_LabelBrdrCol.GetValueColor(c);l.arrow=this.m_LabelArrow.GetValueBool(c);l.rounded=this.m_LabelRounded.GetValueBool(c);l.offset=this.m_LabelOffset.GetValueVector(c);l.Align=this.m_LabelPos.GetValueLong(c);return l;}else{return null;}},RenderShadowDot:function(d,n,l,x,y,s,z){if(n.isCl){for(var i=n.bw.length;i--;){this.RenderShadowDot(d,n.bw[i],l,x,y,s,z);}}else{d.beginPath();d.moveTo(z[0]*(l*n[0]-x-s),z[1]*(l*n[1]-y-s));d.lineTo(z[0]*(l*n[0]-x+s),z[1]*(l*n[1]-y-s));d.lineTo(z[0]*(l*n[0]-x+s),z[1]*(l*n[1]-y+s));d.lineTo(z[0]*(l*n[0]-x-s),z[1]*(l*n[1]-y+s));d.closePath();d.stroke();}},GetRefBorders:function(n,r,m,l){var e=this.m_Scene.m_Canvas[0].m_nExactLOD;var c=(e==Math.floor(e)?1:0.5);var x,y,a=r;var b=m;if(n.isCl==1){var d=(n.e[0])[0],f=(n.e[2])[0];x=(d[0]+f[0])/2;y=(d[1]+f[1])/2;a=1.2*l*Math.max(f[0]-d[0],f[1]-d[1]);}else{x=(n.bo[0]+n.bo[2])/2;y=(n.bo[1]+n.bo[3])/2;}var g=c*a/l;var h=[x-g,x+g,y-g,y+g];var i=n;while(i.c!=undefined){a*=(1<<(b-i.c.lod));b=i.c.lod;i=i.c;x=(i.bo[0]+i.bo[2])/2;y=(i.bo[1]+i.bo[3])/2;g=a/l;h=[Math.max(h[0],x-g),Math.min(h[1],x+g),Math.max(h[2],y-g),Math.min(h[3],y+g)];}return h;},GetNextPoint:function(p,a,b,x,c){var d,e;if(x!=0){var f=x<0?0:1;d=(p[0]-b[f])/(p[0]-a[0]);var y=p[1]+d*(a[1]-p[1]);if(c==0||((y>=b[2])&&(y<=b[3]))){return[b[f],y,true];}e=c<0?2:3;d=(p[1]-b[e])/(p[1]-a[1]);return[p[0]+d*(a[0]-p[0]),b[e],false];}if(c!=0){e=c<0?2:3;d=(p[1]-b[e])/(p[1]-a[1]);return[p[0]+d*(a[0]-p[0]),b[e],false];}},CheckNextLinePoint:function(p,a,b,i){var c=(i<2);var t=c?0:1;var o=1-t;var d=(p[t]-b[i])/(p[t]-a[t]);if((d<=0)||(d>1)){return undefined;}var e=p[o]+d*(a[o]-p[o]);if((e<b[2*o])||(e>b[2*o+1])){return undefined;}return c?[b[i],e]:[e,b[i]];},paintLineList:function(d,p,l,x,y,z){var f;for(var j=0;j<4;++j){var a=p[j];for(var k=0;k<a.length;++k){if(f==undefined){d.moveTo(z[0]*(l*(a[k])[0]-x),z[1]*(l*(a[k])[1]-y));f=true;}else{d.lineTo(z[0]*(l*(a[k])[0]-x),z[1]*(l*(a[k])[1]-y));}}}},GetNextLinePoint:function(p,a,b,s,i){var c;var t=i?0:1;var o=1-t;var d=2*t+(s<0?0:1);var e=(p[t]-b[d])/(p[t]-a[t]);var f=p[o]+e*(a[o]-p[o]);if(i){c=(f<b[2])||(f>=b[3]);return[b[d],Math.max(Math.min(f,b[3]),b[2]),!c];}c=(f<b[0])||(f>=b[1]);return[Math.max(Math.min(f,b[1]),b[0]),b[d],c];},doCornerConnection:function(d,x,y,l,p,a,b,m,o,c,e,i,z){var f=this.GetNextLinePoint(p,a,b,m,i);d.lineTo(z[0]*(l*f[0]-x),z[1]*(l*f[1]-y));if(e&&(f[2]==i)){f=this.GetNextLinePoint(p,a,b,e,!i);d.lineTo(z[0]*(l*f[0]-x),z[1]*(l*f[1]-y));}if(c&&(e==0||e==-o)){f=this.GetNextLinePoint(p,a,b,c,i);f[2]=!f[2];d.lineTo(z[0]*(l*f[0]-x),z[1]*(l*f[1]-y));}return f;},RenderAreaFromBox:function(d,n,e,b,l,a,c,z){var f=this.m_Scene.m_Ctx.m_Clustering;var g;var p=[[[b[1],b[2]]],[[b[1],b[3]]],[[b[0],b[3]]],[[b[0],b[2]]]];var h=b[1]-b[0],k=b[3]-b[2];var m=[3,1,0,2];var o=[1,1,0,0];var q=[2,3,3,2];var x,y;var r=n;for(var i=0;i<n.e.length;++i){var s=f.getEdge(n.e[i],e);var t=[],u=[];for(var j=0;j<4;++j){if((g=this.CheckNextLinePoint(s[0],s[1],b,j))!=undefined){u.push(m[j]);t.push(g);}}if(t.length==2){while(r.bw!=undefined){r=r.bw[0];}var w=((4+u[1]-u[0])%4);if((w%2)==1){var A=(w==1?0:1);var B=1-A;var C=p[u[A]];if(u[A]%2){x=(t[B])[0];y=(t[A])[1];}else{x=(t[A])[0];y=(t[B])[1];}var D=[b[o[u[A]]],b[q[u[A]]]];var E=Math.abs(D[0]-x);var F=Math.abs(D[1]-y);var G=Math.abs(D[0]-r[0]);var H=Math.abs(D[1]-r[1]);if(!E||!F||((G/E)+(H/F)>1)){C.splice(C.length-1,1,t[A],t[B]);}else{var I=p[(u[A]+1)%4];I.splice(I.length-1,1,t[B]);I=p[(u[A]+2)%4];I.splice(0,1,t[B]);I=p[(u[A]-1)%4];I.splice(0,1,t[A]);}}if(w==2){while(r.bw!=undefined){r=r.bw[0];}var J;if(u[0]%2){var K=(u[0]==1?0:1),L=1-K;J=(r[0]-b[0])/h;var M=(1-J)*(t[K])[1]+J*(t[L])[1];if(M>r[1]){p[1].splice(p[1].length-1,1,t[K]);p[2]=[t[L]];}else{p[3].splice(p[3].length-1,1,t[L]);p[0]=[t[K]];}}else{var N=(u[0]==0?0:1),O=1-N;J=(r[1]-b[2])/k;var P=(1-J)*(t[O])[0]+J*(t[N])[0];if(P>r[0]){p[0].splice(p[0].length-1,1,t[N]);p[1]=[t[O]];}else{p[2].splice(p[2].length-1,1,t[O]);p[3]=[t[N]];}}}}}this.paintLineList(d,p,l,a,c,z);},RenderAreaFromEdges:function(d,n,p,a,b,l,x,y,z){var c,e,f,g,h,j=p;var k=0,m=0;d.moveTo(z[0]*(l*p[0]-x),z[1]*(l*p[1]-y));var o=false;var q,r;var s=n.e.length-1;for(var i=s;i--;){c=p.ot;r=(c[0]>b[1])-(c[0]<b[0]);q=(c[1]>b[3])-(c[1]<b[2]);if(o){if(r==0&&q==0){if(k&&m){if((h=this.GetNextLinePoint(p,j,b,g[2]?k:m,g[2]))){d.lineTo(z[0]*(l*h[0]-x),z[1]*(l*h[1]-y));}}h=this.GetNextPoint(c,p,b,k,m);d.lineTo(z[0]*(l*h[0]-x),z[1]*(l*h[1]-y));d.lineTo(z[0]*(l*c[0]-x),z[1]*(l*c[1]-y));o=false;}else{if(g[2]){if(k!=r){g=this.doCornerConnection(d,x,y,l,p,c,b,k,m,r,q,true,z);}}else if(m!=q){g=this.doCornerConnection(d,x,y,l,p,c,b,m,k,q,r,false,z);}k=r;m=q;}}else if(r==0&&q==0){d.lineTo(z[0]*(l*c[0]-x),z[1]*(l*c[1]-y));}else{g=this.GetNextPoint(p,c,b,r,q);d.lineTo(z[0]*(l*g[0]-x),z[1]*(l*g[1]-y));o=true;}f=c.li;e=a[f.ot];p=e.p;k=r;m=q;}if(o){if(k&&m){if((h=this.GetNextLinePoint(p,j,b,g[2]?r:q,g[2]))){d.lineTo(z[0]*(l*h[0]-x),z[1]*(l*h[1]-y));}}h=this.GetNextPoint(j,p,b,k,m);d.lineTo(z[0]*(l*h[0]-x),z[1]*(l*h[1]-y));}},FindEndPointInBorders:function(n,p,a,b){var c=n.e.length;var d,l,e;while(c){if((a[0]>=b[0])&&(a[0]<=b[1])&&(a[1]>=b[2])&&(a[1]<=b[3])){return a;}d=a.ot;l=d.li;e=p[l.ot];a=e.p;c--;}return undefined;},RenderShadowArea:function(d,n,e,r,m,s,c,C,l,x,y,z,a){var b=this.m_Scene.m_Ctx.m_Clustering;var p;if(n.ei!=undefined&&!a){this.RenderShadowArea(d,n,e,r,m,s,c,C,l,x,y,z,true);p=b.createEdgeIndex(e,n.ei);d.strokeStyle="rgba(0,0,0,0)";}else{p=b.createEdgeIndex(e,n.e);d.strokeStyle=c;}var f=this.GetRefBorders(n,r,m,l);d.lineWidth=s;d.beginPath();var g=this.FindEndPointInBorders(n,p,p[0].p,f);if(g==undefined){this.RenderAreaFromBox(d,n,e,f,l,x,y,z);}else{this.RenderAreaFromEdges(d,n,g,p,f,l,x,y,z);}d.closePath();if(!a&&C!=undefined){d.fillStyle=C;d.fill();}d.stroke();},RenderShadow:function(d,n,e,c,a,l,x,y){var z=this.m_Scene.GetZoomFactor4Mode();if(c.sCol){d.strokeStyle=c.sCol;d.lineWidth=2;d.lineCap='round';var s=c.sSize;if(s==-1){if(n.cnt>100){s=1;}else if(n.cnt>30){s=2;}else{s=3;}}if(s){this.RenderShadowDot(d,n,l,x,y,s,z);}}if((c.permArea&&(n.grI>1))||(n.e==undefined)||(a<n.lod-4&&n.c==undefined)){return;}if(c.bCol){var r=c.baseConf.m_ref;var m=c.baseConf.m_lod;if(c.bCol3){if(n.c&&n.c.lod==m-1){this.RenderShadowArea(d,n.c,e,r*2,m-1,1,c.bCol3,c.fCol3,l,x,y,z);}else{this.RenderShadowArea(d,n,e,r*2,m-1,1,c.bCol3,c.fCol3,l,x,y,z);}}this.RenderShadowArea(d,n,e,r,m,c.bSize,c.bCol,c.fCol,l,x,y,z);if(c.bCol2&&n.bw){if(a==n.lod){for(var i=0;i<n.bw.length;i++){var b=n.bw[i];if(b.e.length>0){this.RenderShadowArea(d,b,e,r/2,m+1,1,c.bCol2,c.fCol2,l,x,y,z);}}}else{this.RenderShadowArea(d,n,e,r/2,m+1,1,c.bCol2,c.fCol2,l,x,y,z);}}}}};VBI.VisualObjects.Spot=function(){this.m_fHotScale=1.2;this.load=function(d,c){Object.getPrototypeOf(this).load.call(this,d,c);this.m_Props.push(this.m_DataSource=new VBI.NodeProperty(d,'datasource',null,c));this.m_Props.push(this.m_Pos=new VBI.AttributeProperty(d,'pos',this.m_DataSource,c));this.m_Props.push(this.m_Image=new VBI.AttributeProperty(d,'image',this.m_DataSource,c));this.m_Props.push(this.m_ImageSelected=new VBI.AttributeProperty(d,'imageSelected',this.m_DataSource,c,null));this.m_Props.push(this.m_Icon=new VBI.AttributeProperty(d,'icon',this.m_DataSource,c));this.m_Props.push(this.m_Text=new VBI.AttributeProperty(d,'text',this.m_DataSource,c));this.m_Props.push(this.m_Tooltip=new VBI.AttributeProperty(d,'tooltip',this.m_DataSource,c,this.m_defaultTooltip));this.m_Props.push(this.m_Scale=new VBI.AttributeProperty(d,'scale',this.m_DataSource,c,[1.0,1.0,1.0]));this.m_Props.push(this.m_Alignment=new VBI.AttributeProperty(d,'alignment',this.m_DataSource,c,"5"));this.m_Props.push(this.m_ContentColor=new VBI.AttributeProperty(d,'contentColor',this.m_DataSource,c,"rgb(0,0,0)"));this.m_Props.push(this.m_ContentOffset=new VBI.AttributeProperty(d,'contentOffset',this.m_DataSource,c,[0,0,0]));this.m_Props.push(this.m_ContentFont=new VBI.AttributeProperty(d,'contentFont',this.m_DataSource,c,"arial"));this.m_Props.push(this.m_ContentSize=new VBI.AttributeProperty(d,'contentSize',this.m_DataSource,c,null));this.BaseLoad(d,c,this);};this.DetailHitTest=function(o,n,a,b){var i,h,s;var c=o.m_Ctx;var m=n;var d=null;var e=null;h=this.IsHot(m,c);if(this.bUsePreData){var I=this.m_Scene.m_PreassembledData.base[this.m_nPreDataIndex];var r=this.m_BBRefs[n];if(r.cI!=undefined){I=this.m_Scene.m_PreassembledData.clust[r.cI];}var f=I[r.i];i=f.im;if(h){d=f.hcol;}s=f.s;}else{this.m_DataSource.Select(m);i=this.m_Image.GetValueString(c);if(h){d=this.m_HotDeltaColor.GetValueString(c);}s=this.IsSelected(c);if(s){e=this.m_HotDeltaColor.GetValueString(c);}}var g,j=0;if((g=c.GetResources().GetImageBits(i,d,e))){var k=g[0];var l=this.m_BB[n];var w=l[2]-l[0];var p=l[3]-l[1];var q=Math.floor((a-l[0])/w*g[1]);var t=Math.floor((b-l[1])/p*g[2]);j=k[(t*g[1]+q)*4+3];}return(j>0)?{m_hit:(j==255?1:2)}:null;};this.MatchIcon=function(i){var a={};if(i){sap.ui.core.IconPool.insertFontFaceStyle();switch(i){case"A8":a.i="\ue078";a.f="SAP-icons";break;case"7T":a.i="\ue075";a.f="SAP-icons";break;case"7R":a.i="\ue08a";a.f="SAP-icons";break;case"7Q":a.i="\ue0b3";a.f="SAP-icons";break;case"13":a.i="\ue1cb";a.f="SAP-icons";break;case"89":a.i="\ue176";a.f="SAP-icons";break;case"5X":a.i="\ue326";a.f="VBI-Icons";break;case"7S":a.i="\ue345";a.f="VBI-Icons";break;default:a.f="SAP-icons";if(i.charCodeAt(0)>255){a.i=i;}else{var b=sap.ui.core.IconPool.getIconInfo(i);if(b){a.i=b.content;a.f=b.fontFamily;}}break;}}return a;};this.GetHitArray=function(x,y,a){var z=this.m_Scene.GetStretchFactor4Mode();var n=x/z[0];var b=y/z[0];var o={m_cb:this.DetailHitTest.bind(this),m_Ctx:this.m_Scene.m_Ctx,m_All:a};return this.BaseHitTest(n,b,o);};this.GetLabelPos=function(x,w,h,e){var a=parseInt(e!=undefined?e:"5",10);switch(a){case 0:return{left:x[0]-w/2,top:x[1]-h/2};case 8:return{left:x[0],top:x[1]};case 1:return{left:x[0]-w/2,top:x[1]};case 2:return{left:x[0]-w,top:x[1]};case 3:return{left:x[0]-w,top:x[1]-h/2};case 4:return{left:x[0]-w,top:x[1]-h};case 6:return{left:x[0],top:x[1]-h};case 7:return{left:x[0],top:x[1]-h/2};case 5:default:return{left:x[0]-w/2,top:x[1]-h};}};this.RenderThisInstance=function(e,a,c,b,n,d,f,g,h,i,l,x,y,r){if(VBI.m_bTrace){VBI.Trace("Spot: RenderThisInstance");}var j;var s=this.m_Scene;var z=s.GetZoomFactor4Mode();if(e.c!=undefined&&c.anim&&(h>c.animLow)&&i&&e.c!=undefined&&e.c.lod==h-1){var E=e.c;var k=i*i;j=[z[0]*(l*(e[0]*(1-k)+E[0]*k)-x),z[1]*(l*(e[1]*(1-k)+E[1]*k)-y)];if(c.anim==2){var m=[z[0]*(l*E[0]-x),z[1]*(l*E[1]-y)];var t=2*Math.abs(0.5-i);var o=""+(1-t);f.strokeStyle="rgba(110,110,110,"+o+")";f.lineWidth=2;f.lineCap='round';f.beginPath();f.moveTo(j[0],j[1]);f.lineTo(m[0],m[1]);f.stroke();}}else{j=[z[0]*(l*e[0]-x),z[1]*(l*e[1]-y)];}var p=s.m_Ctx.GetResources().GetImage((e.s&&e.simag)?e.simag:e.im,e.s?e.scol:null,e.h?e.hcol:null,s.RenderAsync.bind(s));var q=e.sc;var u=e.tx;var w=e.ic;var A=e.ctfont;if(!p){return false;}var B=e.fs&&e.fz&&(e.cnt!=undefined?""+e.cnt:undefined);var C=s.GetStretchFactor4Mode();var D=p.naturalWidth*q[0]/C[0];var F=p.naturalHeight*q[1]/C[1],G=F;if(e.h){if(e.hscale!=undefined){D=D*e.hscale[0];F=F*e.hscale[1];}}var H=this.GetLabelPos(j,D,F,e.al);var I=this.m_IO[n]=s.GetCorrectedInstanceOffsets(this.m_BB[n]=[H.left,H.top,H.left+D,H.top+F],z);if(!I.length){return false;}this.m_BBRefs.push({cI:b,i:d});if(e.h){s.VerifyHotItem(this,this.m_BBRefs.length-1);}this.m_BB[n].nI=d;if(this.IsPosChangeable(s.m_Ctx)){var J=this.m_DH[n]=[];if(this.IsHandleMode()){J.m_EditMode=VBI.EMHandle;J.push(j);}else if(this.IsBoxMode()){J.m_EditMode=VBI.EMBox;J.push(this.m_BB[n]);}}var K,L;if(u){L=Math.floor((e.ctsz?e.ctsz:12)*F/p.naturalHeight);VBI.Utilities.SetTextAttributes(f,L.toString()+"px "+A,e.ctcol,e.ctcol,"center","middle");K=u;}else if(w){var M=this.MatchIcon(w);if(M&&M.i&&M.f){L=Math.floor((e.ctsz?e.ctsz:16)*F/p.naturalHeight);VBI.Utilities.SetTextAttributes(f,(L?L:16).toString()+"px "+M.f,e.ctcol,e.ctcol,"center","middle");K=M.i;}}var N,O;for(O=0;O<I.length;++O){N=I[O];if(c&&(e.h||c.permArea)){this.RenderShadow(g,e,a,c,h,l,x-N,y);}f.drawImage(p,H.left+N,H.top,D,F);if(K){var P=[0,0,0];if(e.ctoffs&&e.ctoffs.length){P=e.ctoffs;}var Q=P[0]*q[0]/C[0];var R=P[1]*q[1]/C[1];if(e.h&&e.hscale!=undefined){Q*=e.hscale[0];R*=e.hscale[1];}f.fillText(K,H.left+N+Q+D/2,H.top+R+F/2);}}if(B){var S=e.fz?e.fz*F/p.naturalHeight:Math.floor(G/e.fs);VBI.Utilities.SetTextAttributes(f,(S).toString()+"px "+e.f,e.fc,e.fc,"left","alphabetic");for(O=0;O<I.length;++O){N=I[O];f.fillText(B,D+H.left+N+e.fo/C[0],H.top+e.foy/C[1]+(F+S/1.5)/2.0);}}if(r==true){if(e.label&&I.length){var T={pa:[j[0],j[1],j[2]],bb:null};this.m_Label.push(new VBI.Label(e.label,n,this.CalculateLabelPos,T,this.m_BB[n],I));}}return true;};this.RenderInstance=function(n,d,r,i,t,s,h,l,a){if(VBI.m_bTrace){VBI.Trace("Spot: RenderInstance");}if(!i){return;}var b=this.m_Scene;var z=b.GetZoomFactor4Mode();var c=b.GetStretchFactor4Mode();var x=b.GetPointFromPos(r,true);var w=i.naturalWidth*s[0]/c[0];var e=i.naturalHeight*s[1]/c[1];var f=this.GetHotScale(b.m_Ctx);if(h){w=Math.round(w*f[0]);e=Math.round(e*f[1]);}var p=this.GetLabelPos(x,w,e,this.m_Alignment.GetValueString(b.m_Ctx));var I=this.m_IO[n]=b.GetCorrectedInstanceOffsets(this.m_BB[n]=[p.left,p.top,p.left+w,p.top+e],z);if(this.IsPosChangeable(b.m_Ctx)){var D=this.m_DH[n]=[];if(this.IsHandleMode()){D.m_EditMode=VBI.EMHandle;D.push(x);}else if(this.IsBoxMode()){D.m_EditMode=VBI.EMBox;D.push(this.m_BB[n]);}}var g=this.m_ContentColor.GetValueString(b.m_Ctx);var j=this.m_ContentOffset.GetValueVector(b.m_Ctx);var k=this.m_ContentFont.GetValueString(b.m_Ctx);var m=this.m_ContentSize.GetValueLong(b.m_Ctx);var o;if(t){if(!m){m=12;}m=m*e/i.naturalHeight;VBI.Utilities.SetTextAttributes(d,(Math.floor(m)).toString()+"px "+k,g,g,"center","middle");o=t;}else if(a){if(!m){m=16;}m=m*e/i.naturalHeight;var q=this.MatchIcon(a);if(q&&q.i&&q.f){VBI.Utilities.SetTextAttributes(d,(Math.floor(m)).toString()+"px "+q.f,g,g,"center","middle");o=q.i;}}for(var u=0;u<I.length;++u){var y=I[u];d.drawImage(i,p.left+y,p.top,w,e);if(o){var A=j[0]*s[0]/c[0];var B=j[1]*s[1]/c[1];if(h){A*=f[0];B*=f[1];}d.fillText(o,p.left+y+w/2+A,p.top+e/2+B);}}if(l&&I.length){var L={pa:[x[0],x[1],x[2]],bb:null};this.m_Label.push(new VBI.Label(l,n,this.CalculateLabelPos,L,this.m_BB[n],I));}};this.CalculateLabelPos=function(s,p,i){var n=Math.floor(p.pa.length/3)*3,t=[],a=s.GetViewport();for(var b=0;b<n;b+=3){var c=[p.pa[b]+i,p.pa[b+1]];if(c[0]>a[0]&&c[0]<a[2]&&c[1]>a[1]&&c[1]<a[3]){t.push(c);}}return t.length?t:null;};this.Init4Render=function(){this.m_BB=[];this.m_IO=[];this.m_DH=[];this.m_BBRefs=[];};this.Render=function(c,d,p,s,a,S){var b=this.m_Scene;this.SwitchPreDataRendering(p!=undefined);var e;if(this.bUsePreData){if((p.m_nNumIgnore!=undefined)&&(p.m_nNumIgnore==p.length)){return 0;}var r=S?false:true;e=this.m_BB.length;var E=b.m_Canvas[0].m_nExactLOD;var x=b.m_Canvas[0].m_nCurrentX*b.m_MapManager.m_tileWidth;var y=b.m_Canvas[0].m_nCurrentY*b.m_MapManager.m_tileHeight;var f=p.config;var g=p.cI;var n=p.m_TreeFatherNode;var h;if(n){h=Math.ceil(E);var i=this.GetAnimClusterDistance(h,E);e=this.RenderTree(n,p.m_edges,f,g,e,h,i,d,a,p.m_lodOffset,x,y,false);}else{h=b.m_Canvas[0].m_nCurrentLOD;var j=p.length;var l=p.m_lodOffset;for(var k=0;k<j;++k){var m=p[k];if(!m.b2Ignore){if(this.RenderThisInstance(m,p.m_edges,f,g,e,k,d,a,h,0,l,x,y,r)){this.SetClusteredRichTooltip(m);e++;}}}}}else{var o=b.m_Ctx;var q,t;if((q=this.m_DataSource.GetCurrentNode(o))){var u=q.m_dataelements.length;for(var w=0;w<u;++w){this.m_DataSource.Select(w);var H=this.IsHot(w);var z=this.IsSelected(o);var A=this.m_Pos.GetValueVector(o);var B=this.m_Image.GetValueString(o);if(z&&(t=this.m_ImageSelected.GetValueString(o))){B=t;}var C=this.m_Text.GetValueString(o);var D=this.m_Icon.GetValueString(o);var F=this.m_Scale.GetValueVector(o);var G=o.GetResources().GetImage(B,z?this.m_SelectColor.GetValueString(o):null,H?this.m_HotDeltaColor.GetValueString(o):null,b.RenderAsync.bind(b));this.RenderInstance(w,d,A,G,C,F,H,this.GetLabel(o),D);this.SetRichTooltip(H);}}}this.BaseRender(c,d);return e;};this.DesignBeginDrag=function(o){o.m_ScaleOrig=this.m_Scale.GetValueVector(this.m_Scene.m_Ctx).slice(0);o.m_DhOrig=this.m_DH[o.m_Index].slice(0);if(o.m_IO){(o.m_DhOrig[0])[0]+=o.m_IO;(o.m_DhOrig[0])[2]+=o.m_IO;}};this.DesignGetActiveBoxHandles=function(i){return[1,1,1,1,0,1,0,0,0];};this.InternalChangeHotItem=function(n,a,h){if(this.bUsePreData){var r=this.m_BBRefs[n];if(r!=undefined){var I=(r.cI!=undefined)?this.m_Scene.m_PreassembledData.clust[r.cI]:this.m_Scene.m_PreassembledData.base[this.m_nPreDataIndex];if(I[r.i]!=undefined){I[r.i].h=a;this.m_HotClusterVO=((a&&I[r.i].isCl)?I[r.i]:undefined);}if(h){h.cI=a?r.cI:undefined;h.nI=a?r.i:undefined;}}}};this.BaseIsHot=this.IsHot;this.PreDataIsHot=function(n,c){var r=this.m_BBRefs[n];var I=(r.cI!=undefined)?this.m_Scene.m_PreassembledData.clust[r.cI]:this.m_Scene.m_PreassembledData.base[this.m_nPreDataIndex];return I[r.i].h;};this.BaseGetEntity=this.GetEntity;this.PreDataGetEntity=function(n,c){this.m_DataSource.Select(n);return this.m_Entity.GetValueString(c);};this.SwitchHotItemToStandard=function(){var s=this.m_Scene;var r=this.m_BBRefs[s.m_HotItem.m_Index];var I=(r.cI!=undefined)?this.m_Scene.m_PreassembledData.clust[r.cI]:this.m_Scene.m_PreassembledData.base[this.m_nPreDataIndex];var e=I[r.i];if(e){if(e.isCl==true){s.InternalSetHotItem(null,null);return e;}else{s.m_HotItem.m_Index=e.nI;if(s.m_HotItem.m_HitObj){s.m_HotItem.m_HitObj.m_Index=e.nI;}return undefined;}}};this.IsClusterable=function(){return true;};this.GetDataIndex=function(B){if(this.bUsePreData){var p=this.m_BBRefs[B];if(p!=undefined){var I=(p.cI==undefined?this.m_Scene.m_PreassembledData.base[this.m_nPreDataIndex]:this.m_Scene.m_PreassembledData.clust[p.cI]);var e=I[p.i];if(e!=undefined){return e.nI;}}}return B;};this.GetPreassembledElement=function(B){var p=this.m_BBRefs[B];if(p==undefined){return undefined;}var I=(p.cI==undefined?this.m_Scene.m_PreassembledData.base[this.m_nPreDataIndex]:this.m_Scene.m_PreassembledData.clust[p.cI]);return I[p.i];};this.GetInternalIndex=function(B){if(this.bUsePreData){return this.m_BBRefs[B];}return B;};this.getTooltip=function(c,h){this.m_DataSource.Select(this.GetDataIndex(h.m_Index));return this.m_Tooltip.GetValueString(c);};this.DesignBoxSize=VBI.Utilities.SceneBindDesignSpotBoxSize.bind(this);};VBI.VisualObjects.Spot.prototype=VBI.VisualObjects.Base;VBI.VisualObjects.Route=function(){this.m_LP=[];this.load=function(d,c){Object.getPrototypeOf(this).load.call(this,d,c);this.m_Props.push(this.m_DataSource=new VBI.NodeProperty(d,'datasource',null,c));this.m_Props.push(this.m_Pos=new VBI.AttributeProperty(d,'posarray',this.m_DataSource,c));this.m_Props.push(this.m_Scale=new VBI.AttributeProperty(d,'scale',this.m_DataSource,c));this.m_Props.push(this.m_Color=new VBI.AttributeProperty(d,'color',this.m_DataSource,c,this.m_defaultColor));this.m_Props.push(this.m_Start=new VBI.AttributeProperty(d,'start',this.m_DataSource,c,0));this.m_Props.push(this.m_End=new VBI.AttributeProperty(d,'end',this.m_DataSource,c,0));this.m_Props.push(this.m_Tooltip=new VBI.AttributeProperty(d,'tooltip',this.m_DataSource,c,this.m_defaultTooltip));this.m_Props.push(this.m_LineWidth=new VBI.AttributeProperty(d,'linewidth',this.m_DataSource,c,6.0));this.m_Props.push(this.m_DotColor=new VBI.AttributeProperty(d,'dotcolor',this.m_DataSource,c,this.m_defaultColor));this.m_Props.push(this.m_DotBorderColor=new VBI.AttributeProperty(d,'dotbordercolor',this.m_DataSource,c,this.m_defaultColor));this.m_Props.push(this.m_ColorBorder=new VBI.AttributeProperty(d,'colorBorder',this.m_DataSource,c,null));this.m_Props.push(this.m_LineDash=new VBI.AttributeProperty(d,'lineDash',this.m_DataSource,c,null));this.m_Props.push(this.m_DotWidth=new VBI.AttributeProperty(d,'dotwidth',this.m_DataSource,c,0.0));this.m_Props.push(this.m_Tri=new VBI.AttributeProperty(d,'directionIndicator',this.m_DataSource,c,0));this.BaseLoad(d,c,this);};this.DrawArrow=function(c,a,b,d,l,r,h){if((a.length<3)||(Math.max(a[0][0],a[1][0],a[2][0])<l)||(Math.max(a[0][1],a[1][1],a[2][1])<0)||(Math.min(a[0][0],a[1][0],a[2][0])>r)||(Math.min(a[0][1],a[1][1],a[2][1])>h)){return;}c.beginPath();c.moveTo(a[0][0],a[0][1]);c.lineTo(a[1][0],a[1][1]);c.lineTo(a[2][0],a[2][1]);c.lineTo(a[0][0],a[0][1]);c.closePath();if(d){c.strokeStyle=d;c.lineWidth=2;c.stroke();}c.fillStyle=b;c.fill();};this.CalcTriangle=function(p,a,b,c,r,R,i,n){var d=a[0]-p[0];var e=a[1]-p[1];while((Math.abs(d)>1000.0)&&(Math.abs(e)>1000.0)){d/=1000.0;e/=1000.0;}var l=Math.sqrt(d*d+e*e);var f=(d*b)/l;var g=(e*b)/l;var w=(d*c/2)/l;var h=(e*c/2)/l;var j,k;if(i){j=(d*n/2)/l;k=(e*n/2)/l;}var m=p[0]+f;var o=p[1]+g;if(!R){r.ta=[[p[0],p[1]],[m+h,o-w],[m-h,o+w]];r.pt=[m,o,0];if(i){r.int=[[m+k,o-j],[m-k,o+j]];}}else{r.ta=[[m,o,0],[p[0]+h,p[1]-w],[p[0]-h,p[1]+w]];r.pt=[p[0],p[1]];if(i){r.int=[[p[0]+k,p[1]-j],[p[0]-k,p[1]+j]];}}};this.getArrowLength=function(l){return(Math.min(15,l*5));};this.getArrowWidth=function(l){return(Math.min(Math.max(8,l*3),l+8));};this.CalcArrowIntermediate=function(L,p,n,a,s,e,b){var c=p;var r=false;var o=n;var d=this.getArrowWidth(a);var f=this.getArrowLength(a);var g=f*f;var h=0;var t,i,j;var k=[0,0,0];var m;var q;j=0;if(s){m={};h=0;for(q=o;q<L.length;++q){k=L[q];t=c[0]-k[0];i=c[1]-k[1];j=t*t+i*i;if(j>g){this.CalcTriangle(c,k,f,d,m,false,b,a);L.m_aArrows.push(m);r=true;break;}else{h++;}}if(m.pt){L.splice(o,h,c,m.pt);o=o+2;c=m.pt;}}if(e){var S=true;var u=c;var x=L[o];var w=this.getArrowWidth(a);var y=0;var l;c=[];while(S&&o<L.length){t=(x[0]-u[0]);i=(x[1]-u[1]);l=Math.sqrt(t*t+i*i);if(y+l>w){S=false;var z=t/(y+l)*w;var A=i/(y+l)*w;c=[u[0]+z,u[1]+A,0];}else{y+=l;o++;u=x;x=L[o];}}if(c.length){m={};h=0;for(q=o;q<L.length;++q){k=L[q];t=c[0]-k[0];i=c[1]-k[1];j=t*t+i*i;if(j>g){this.CalcTriangle(c,k,f,d,m,true,b,a);L.m_aArrows.push(m);r=true;break;}else{h++;}}if(m.pt){L.splice(o,h,c,[m.ta[0][0],m.ta[0][1],0]);o=o+2;}}}if(r){return o-1;}return-1;};this.CalcArrow=function(p,l,r,a,b,c){var d=this.getArrowWidth(a);var e=this.getArrowLength(a);var n=p.length/3;var t,f,g=e*e;if(((t=(l[0]-r[0]))*t+(f=(l[1]-r[1]))*f)<g){return false;}var h,i;var s,x=[0,0,0];var F=false;i=b?3*(n-1):0;s=[p[i],p[i+1],0.0];var j=3*n;for(h=3;h<j;h+=3){i=b?j-3-h:h;x=[p[i],p[i+1],0.0];if(((t=(s[0]-x[0]))*t+(f=(s[1]-x[1]))*f)>g){F=true;break;}}if(!F){return false;}this.CalcTriangle(s,x,e,d,c,false,false,0);c.idx=i;return true;};this.CalculateLabelPos=function(s,p,o){var a=VBI.Utilities.GetMidpointsForLine(p.pa,o,s.GetViewport());return a.aPos;};this.LassoSelect=function(p,h,o){var a,r,O;var f=false;for(var n=this.m_LP.length-1;n>=0;--n){a=this.m_LP[n];O=this.m_IO[n];var e=false;for(var b=0;b<O.length;++b){if(e){break;}for(var c=0;c<a.length;++c){r=a[c];if(!(e=VBI.Utilities.pointInPolygon(p,r[0]+O[b],r[1]))){break;}}}if(e){h.push(n);o.push(n);f=true;}}return f;};this.RenderInstance=function(n,d,h,c){var z=this.m_Scene.GetZoomFactor4Mode();this.m_LP[n]=[];var e;if(this.IsPosChangeable(c)){this.m_DH[n]=[];if(this.IsHandleMode()){e=VBI.EMHandle;}else if(this.IsBoxMode()){e=VBI.EMBox;}}var s=this.IsSelected(c);var p=this.m_Pos.GetValueVector(c);var a=this.m_Scene;if(p.cache==undefined){a.FillPositionCache(p);}var b=this.m_Color.GetValueColor(c);if(s){b=this.GetSelectColor(c,b);}if(h){b=this.GetHotColor(c,b);}var f=this.m_Start.GetValueLong(c);var g=this.m_End.GetValueLong(c);var t=this.m_Tri.GetValueLong(c);var l=this.m_LineWidth.GetValueFloat(c);if(h){l*=(this.GetHotScale(c))[0];}var i=this.m_DotColor.GetValueColor(c);if(s){i=this.GetSelectColor(c,i);}if(h){i=this.GetHotColor(c,i);}var j=this.m_DotBorderColor.GetValueColor(c);var k=this.m_ColorBorder.GetValueColor(c);if(s){j=this.GetSelectColor(c,j);k=this.GetSelectColor(c,k);}if(h){j=this.GetHotColor(c,j);k=this.GetHotColor(c,k);}var m=this.m_LineDash.GetValueString(c);var o=this.m_DotWidth.GetValueFloat(c);var q=this.GetLabel(c);var r=a.GetNearestPosArray(p);var u=a.GetPointFromPos([r.m_MinX,r.m_MaxY,0.0],false);var w=a.GetPointFromPos([r.m_MaxX,r.m_MinY,0.0],false);var x=Math.max(l,o/2);var I=this.m_IO[n]=a.GetCorrectedInstanceOffsets(this.m_BB[n]=[u[0]-x,u[1]-x,w[0]+x,w[1]+x],z);if(I.length){var y=a.GetPointArrayFromUCSArray(p.cache.data);if(e!=undefined){this.m_DH[n]=this.FillDesignHandles(y,e,n);}for(var A=0,B=I.length;A<B;++A){d.setTransform(1,0,0,1,I[A],0);this.RenderRoute(n,d,y,u,w,b,f,g,t,l,i,j,k,m,o,I[A]);if(VBI.m_bTrace){VBI.Utilities.DrawFrameRect(d,"red",this.m_BB[n]);}}d.setTransform(1,0,0,1,0,0);if(q){var C={pa:y,bb:[u,w]};this.m_Label.push(new VBI.Label(q,n,this.CalculateLabelPos,C,null,I));}}};this.FillDesignHandles=function(p,e,n){var h=[];if(e==VBI.EMHandle){var a=p.length;for(var b=0;b<a;b+=3){h.push([p[b],p[b+1]]);}}else if(e==VBI.EMBox){h.push(this.m_BB[n]);}h.m_EditMode=e;return h;};this.RenderRoute=function(n,d,p,l,r,c,s,e,t,b,f,g,h,i,j,o){if(p.length<6){return;}var x=-o,k=d.canvas.m_pixelWidth-o,y=d.canvas.m_pixelHeight;var R=((l[0]>x)&&(l[1]>0)&&(r[0]<k)&&(r[1]<y));var L=this.m_LP[n];var m=3,q=p.length-3;var C=L.length?false:true;var u={},w={};if(b&&s&&this.CalcArrow(p,l,r,b,false,u)){this.DrawArrow(d,u.ta,c,h,x,k,y);m=u.idx;if(C){L.m_RS=u;}}if(b&&e&&this.CalcArrow(p,l,r,b,true,w)){this.DrawArrow(d,w.ta,c,h,x,k,y);q=w.idx;if(C){L.m_RE=w;}}if(C){this.CollectLinePoints(p,L,m,q,s,e,t,u,w,b,o,h?true:false);}var z=this.CheckLineDashing(i,d);if(b){this.DrawActualRoute(d,L,c,h,b,R,x,k,y);}if(j){this.DrawRouteDots(d,L,s,e,f,g,j/2.0,R,x,k,y);}if(z){d.setLineDash([]);}if(L.m_aArrows&&L.m_aArrows.length){for(var A=0;A<L.m_aArrows.length;++A){this.DrawArrow(d,L.m_aArrows[A].ta,c,h,x,k,y);if(L.m_aArrows[A].int){var a=L.m_aArrows[A].int;d.beginPath();d.moveTo(a[0][0],a[0][1]);d.lineTo(a[1][0],a[1][1]);d.strokeStyle=c;d.lineWidth=2;d.stroke();}}}};this.CollectLinePoints=function(p,l,n,a,b,c,t,r,d,f,o,h){var g=Math.min(f*f/2,4);var i=this.m_Scene.GetViewport();l.m_aArrows=[];var s=r.pt?[r.pt[0],r.pt[1],0.0]:[p[0],p[1],0.0];var e=d.pt?[d.pt[0],d.pt[1],0.0]:[p[a],p[a+1],0.0];var j,k,x,m=s;l.push(m);for(var q=n;q<=a;q+=3){x=[p[q],p[q+1],0.0];if(((j=(m[0]-x[0]))*j+(k=(m[1]-x[1]))*k)>g){l.push(x);m=x;}}if(d.pt){l.push(d.pt);}if((b||c)&&t&&f&&this.CheckTriangleRendering()){if(!(s[0]>=i[0]&&s[0]<=i[2]&&s[1]>=i[1]&&s[1]<=i[3]&&e[0]>=i[0]&&e[0]<=i[2]&&e[1]>=i[1]&&e[1]<=i[3])){this.CalculateRouteArrows(l,b,c,f,o,h);}}};this.CheckTriangleRendering=function(){var s=this.m_Scene;var e=s.m_Canvas[0].m_nExactLOD;return(s.m_bNonIntPosStable||e==Math.floor(e)||e<=(s.m_CacheVars.minLOD+0.01));};this.CheckLineDashing=function(l,d){var s=this.m_Scene;var e=s.m_Canvas[0].m_nExactLOD;if(l&&d.setLineDash&&(s.m_bNonIntPosStable||e==Math.floor(e)||e<=(s.m_CacheVars.minLOD+0.01))){var a=l.split(";");d.setLineDash(a);return true;}return false;};this.DrawActualRoute=function(d,l,c,a,b,r,x,e,y){if(a){d.strokeStyle=a;d.lineWidth=b+2;d.lineJoin='round';d.lineCap='butt';}else{d.strokeStyle=c;d.lineWidth=b;d.lineJoin=d.lineCap='round';}var p=true;if(r){d.beginPath();p=false;d.moveTo((l[0])[0],(l[0])[1]);for(var n=1;n<l.length;++n){d.lineTo((l[n])[0],(l[n])[1]);}}else{var q,f;var t=this.m_Scene.m_TransitionTable;var g;var L=true;var h,i=l[0];if(i[1]<0){q=3;}else{q=i[1]>y?6:0;}if(i[0]<x){q++;}else{q+=(i[0]>e?2:0);}for(var j=1;j<l.length;++j){h=l[j];if(h[1]<0){f=3;}else{f=h[1]>y?6:0;}if(h[0]<x){f++;}else{f+=(h[0]>e?2:0);}g=t[q+9*f];if(g==1||(g>1&&this.Check4Intersect(i,h,g,x,e,0,y))){if(p){d.beginPath();p=false;}if(L){d.moveTo(i[0],i[1]);}d.lineTo(h[0],h[1]);L=false;}else{L=true;i=h;}q=f;}}if(!p){d.stroke();if(a){d.strokeStyle=c;d.lineWidth=b;d.stroke();}}};this.Check4Intersect=function(p,a,t,x,b,y,c){var d,e,f;var g=a[0]-p[0];var h=a[1]-p[1];if(t&20){f=(t&4)?c:y;e=(a[1]-f)/h;d=a[0]-g*e;if((d>=x)&&(d<=b)){return true;}}if(t&10){f=(t&2)?x:b;d=(a[0]-f)/g;e=a[1]-h*d;if((e>=y)&&(e<=c)){return true;}}return false;};this.DrawRouteDots=function(d,l,s,e,a,b,r,R,x,c,y){d.fillStyle=a;d.strokeStyle=b;d.lineWidth=1;var f=s?1:0;var g=l.length-(e?2:1);var z=2.0*Math.PI;for(var n=f;n<=g;++n){var h=l[n];if(R||((h[0]-r>x)&&(h[0]+r<c)&&(h[1]-r>0)&&(h[1]+r<y))){d.beginPath();d.arc(h[0],h[1],r,0,z);d.closePath();d.fill();d.stroke();}}};this.CalculateRouteArrows=function(l,s,e,a,o,b){var i=250;var S=0;var f=0;var t,c,n,d;var w=this.m_Scene.m_Canvas[this.m_Scene.m_nOverlayIndex].width;var h=this.m_Scene.m_Canvas[this.m_Scene.m_nOverlayIndex].height;var r=[-o,0,-o+w,h];var R=false;var L=false;var g=true;var p=l[0];var j=l[1];n=1;while(g){if(p==undefined||j==undefined){if(VBI.m_bTrace){VBI.Trace("Wrong offset in CalculateRouteArrows");}break;}R=VBI.Utilities.LineIntersectRect(p[0],p[1],j[0],j[1],r);if(R.bReturn==false){L=false;S=0;n++;if(n<l.length){p=j;j=l[n];}else{g=false;}}else{if(R.x0!=p[0]||R.y0!=p[1]){p=[R.x0,R.y0,0];l.splice(n,0,p);n++;L=false;}if(R.x1!=j[0]||R.y1!=j[1]){if(R.x1==p[0]&&R.y1==p[1]&&L){n+=2;if(n<l.length){p=l[n-1];j=l[n];L=false;}else{g=false;}}else{j=[R.x1,R.y1,0];l.splice(n,0,j);L=true;}}t=(j[0]-p[0]);c=(j[1]-p[1]);d=Math.sqrt(t*t+c*c);f+=d;if(S+d>i){var k=t/d*(i-S);var m=c/d*(i-S);var q=[p[0]+k,p[1]+m,0];var u=this.CalcArrowIntermediate(l,q,n,a,s,e,b);if(u>=0){n=u+1;p=l[u];j=l[n];S=0;}else{g=false;}}else{S+=d;n++;if(n<l.length){p=j;j=l[n];}else{g=false;}}}}};this.Init4Render=this.StandardInitWithLPs;this.Render=function(c,d,a){var s=this.m_Scene;var b=s.m_Ctx;var n;var h;if((n=this.m_DataSource.GetCurrentNode(b))){for(var e=0,l=n.m_dataelements.length;e<l;++e){this.m_DataSource.Select(e);if(this.IsHot(e)){h=e;}else{this.RenderInstance(e,d,false,b);}this.SetRichTooltip(this.IsHot(e));}}if(h!=undefined){this.m_DataSource.Select(h);this.RenderInstance(h,d,true,b);}this.BaseRender(c,d);};this.DetailHitDot=function(n,a,x,y,s){var t,b;return(((t=(x-n))*t+(b=(y-a))*b)<s)?true:false;};this.DetailHitTest=function(o,n,a,b){var x,y,c,d;this.m_DataSource.Select(n);var l=this.m_LineWidth.GetValueLong(this.m_Scene.m_Ctx)/2;var e=this.m_DotWidth.GetValueLong(this.m_Scene.m_Ctx)/2;var s=l*l;var f=e*e;var L=this.m_LP[n];x=L[0][0];y=L[0][1];if(f&&this.DetailHitDot(a,b,x,y,f)){return{m_hit:1,m_dot:0};}var g=L.length;var h;for(h=1;h<g;++h){c=L[h][0];d=L[h][1];if(l&&!((a<(Math.min(x,c)-l))||(a>(Math.max(x,c)+l))||(b<(Math.min(y,d)-l))||(b>(Math.max(y,d)+l)))&&(s>VBI.Utilities.sqDistance(x,y,c,d,a,b))){if(VBI.m_bTrace){VBI.Trace("VBI.VisualObjects.Route hit line "+n);}return{m_hit:1};}if(f&&this.DetailHitDot(a,b,c,d,f)){if(VBI.m_bTrace){VBI.Trace("VBI.VisualObjects.Route hit dot "+n);}return{m_hit:1,m_dot:h};}x=c;y=d;}if(L.m_aArrows){g=L.m_aArrows.length;for(h=0;h<g;++h){if(VBI.Utilities.pointInTriangle(L.m_aArrows[h].ta,[a,b])){return{m_hit:1};}}}if(L.m_RS&&VBI.Utilities.pointInTriangle(L.m_RS.ta,[a,b])){return{m_hit:1,m_arrow:0};}if(L.m_RE&&VBI.Utilities.pointInTriangle(L.m_RE.ta,[a,b])){return{m_hit:1,m_arrow:1};}return null;};this.GetHitArray=function(x,y,a){var o={m_cb:this.DetailHitTest.bind(this),m_All:a};var z=this.m_Scene.GetStretchFactor4Mode();var n=x/z[0];var b=y/z[1];return this.BaseHitTest(n,b,o);};this.DesignBoxSize=VBI.Utilities.SceneBindPosArrayDesignBoxSize.bind(this);};VBI.VisualObjects.Route.prototype=VBI.VisualObjects.Base;VBI.VisualObjects.Circle=function(){this.load=function(d,c){Object.getPrototypeOf(this).load.call(this,d,c);this.m_Props.push(this.m_DataSource=new VBI.NodeProperty(d,'datasource',null,c));this.m_Props.push(this.m_Pos=new VBI.AttributeProperty(d,'pos',this.m_DataSource,c));this.m_Props.push(this.m_ColorBorder=new VBI.AttributeProperty(d,'colorBorder',this.m_DataSource,c,this.m_defaultColor));this.m_Props.push(this.m_Radius=new VBI.AttributeProperty(d,'radius',this.m_DataSource,c,5));this.m_Props.push(this.m_Tooltip=new VBI.AttributeProperty(d,'tooltip',this.m_DataSource,c,this.m_defaultTooltip));this.m_Props.push(this.m_Color=new VBI.AttributeProperty(d,'color',this.m_DataSource,c,this.m_defaultColor));this.m_Props.push(this.m_Slices=new VBI.AttributeProperty(d,'slices',this.m_DataSource,c,10));this.m_Props.push(this.m_AltColorBorder=new VBI.AttributeProperty(d,'altBorderDeltaColor',this.m_DataSource,c,null));this.BaseLoad(d,c,this);};this.CalculateLabelPos=function(s,p,o){var a=VBI.Utilities.GetMidpointForPolygon(p.pa,p.bb,o,s.GetViewport());if(a&&a.aPos){return a.aPos;}return null;};this.LassoSelect=this.LassoSelectCircle;this.RenderInstance=function(n,d,p,c,a,b,s,l){var e=this.m_Scene;var f;var z=e.GetStretchFactor4Mode();var g=e.GetZoomFactor4Mode();var r=b/z[0];var x=e.GetPointFromPos(p,false);var h;var i=this.m_IO[n]=e.GetCorrectedInstanceOffsets(h=this.m_BB[n]=[x[0]-r,x[1]-r,x[0]+r,x[1]+r],g);h.m_Radius=r;h.m_Pos=x;if(this.IsPosChangeable(e.m_Ctx)){var D=(this.m_DH[n]=[]);if(this.IsHandleMode()){D.m_EditMode=VBI.EMHandle;D.push(x);}else if(this.IsBoxMode()){D.m_EditMode=VBI.EMBox;D.push(h);}}d.lineWidth=1;d.fillStyle=c;for(f=0;f<i.length;++f){d.setTransform(1,0,0,1,i[f],0);d.beginPath();d.arc(x[0],x[1],r,0,2*Math.PI);d.closePath();d.fill();d.strokeStyle=a;d.stroke();if(VBI.m_bTrace){VBI.Utilities.DrawFrameRect(d,"red",this.m_BB[n]);}}d.setTransform(1,0,0,1,0,0);if(l&&i.length){var j=[];var k=20;for(f=0;f<k;++f){var t=f*2*Math.PI/k;var m=x[0]+r*Math.sin(t);var o=x[1]+r*Math.cos(t);j.push(m,o);}var q={pa:j,bb:[[h[0],h[1]],[h[2],h[3]]]};this.m_Label.push(new VBI.Label(l,n,this.CalculateLabelPos,q,null,i));}};this.Init4Render=this.StandardInit;this.Render=function(c,d,a){var b=this.m_Scene.m_Ctx;var e=0;var n;if((n=this.m_DataSource.GetCurrentNode(b))){e=n.m_dataelements.length;for(var f=0;f<e;++f){this.m_DataSource.Select(f);var h=this.IsHot(f);var S=this.IsSelected(b);var p=this.m_Pos.GetValueVector(b);var g=this.m_Color.GetValueColor(b);if(S){g=this.GetSelectColor(b,g);}if(h){g=this.GetHotColor(b,g);}var i=this.m_ColorBorder.GetValueColor(b);if(S){i=this.GetSelectColor(b,i);}if(h){i=this.GetAltBorderColor(b,i);}var r=this.m_Radius.GetValueFloat(b);if(h){r=(this.GetHotScale(b))[0]*r;}var s=this.m_Slices.GetValueLong(b);this.RenderInstance(f,d,p,g,i,r,s,this.GetLabel(b));this.SetRichTooltip(h);}}this.BaseRender(c,d);return e;};this.DetailHitTest=function(o,n,a,b){var c=this.m_BB[n];var r=c.m_Radius;var x=c.m_Pos;var t,d;if(((t=(x[0]-a))*t+(d=(x[1]-b))*d)<r*r){return{m_hit:1};}return null;};this.GetHitArray=function(x,y,a){var z=this.m_Scene.GetStretchFactor4Mode();var o={m_cb:this.DetailHitTest.bind(this),m_zf:z,m_All:a};var n=x/z[0];var b=y/z[1];return this.BaseHitTest(n,b,o);};this.DesignGetActiveBoxHandles=function(i){var s=this.m_Scene;this.m_DataSource.Select(i);return this.m_Radius.IsChangeable(s.m_Ctx)?[0,1,0,1,0,1,0,1,0]:[0,0,0,0,0,0,0,0,0];};this.DesignBoxSize=VBI.Utilities.SceneBindRadiusDesignBoxSize.bind(this);};VBI.VisualObjects.Circle.prototype=VBI.VisualObjects.Base;VBI.VisualObjects.CircleDist=function(){this.load=function(d,c){Object.getPrototypeOf(this).load.call(this,d,c);this.m_Props.push(this.m_DataSource=new VBI.NodeProperty(d,'datasource',null,c));this.m_Props.push(this.m_Pos=new VBI.AttributeProperty(d,'midpoint',this.m_DataSource,c));this.m_Props.push(this.m_ColBorder=new VBI.AttributeProperty(d,'colorBorder',this.m_DataSource,c,this.m_defaultColor));this.m_Props.push(this.m_Radius=new VBI.AttributeProperty(d,'radius',this.m_DataSource,c,10));this.m_Props.push(this.m_Tooltip=new VBI.AttributeProperty(d,'tooltip',this.m_DataSource,c,this.m_defaultTooltip));this.m_Props.push(this.m_ColFill=new VBI.AttributeProperty(d,'color',this.m_DataSource,c,this.m_defaultColor));this.m_Props.push(this.m_Slices=new VBI.AttributeProperty(d,'slices',this.m_DataSource,c,10));this.m_Props.push(this.m_AltColorBorder=new VBI.AttributeProperty(d,'altBorderDeltaColor',this.m_DataSource,c,null));this.BaseLoad(d,c,this);};this.CalculateLabelPos=function(s,p,o){var a=VBI.Utilities.GetMidpointForPolygon(p.pa,p.bb,o,s.GetViewport());if(a&&a.aPos){return a.aPos;}return null;};this.LassoSelect=function(p,h,o){var c=[];var O,t;var f=false;for(var n=this.m_LP.length-1;n>=0;--n){var a=[];if(this.m_BB[n].m_bArcCircle){var x=this.m_BB[n].m_Pos;var r=this.m_BB[n].m_Radius;var b=20;for(var d=0;d<b;++d){t=d*2*Math.PI/b;c=[x[0]+r*Math.sin(t),x[1]+r*Math.cos(t)];a.push(c);}}else{a=this.m_LP[n];}O=this.m_IO[n];if(VBI.Utilities.polyInPolygon(p,a,O)){o.push(n);h.push(n);f=true;}}return f;};this.RenderCircleDist=function(n,d,a,c,b){var s=this.m_Scene;var l=this.m_LP[n];if(l.length){l=null;}var t,e,x,f=s.GetPointFromGeo(a[0],false);var A=false;var g,h;var i=this.m_Scene.m_Ctx;var p=this.m_Pos.GetValueVector(i);var r=this.m_Radius.GetValueFloat(i);A=(Math.abs(p[1]-45)<=10&&r<=10000)?true:false;if(A){var j=0;g=s.GetPointFromGeo(VBI.MathLib.DegToRad(p),false);for(var k=0;k<a.length;++k){x=s.GetPointFromGeo(a[k],false);j+=Math.sqrt((x[0]-g[0])*(x[0]-g[0])+(x[1]-g[1])*(x[1]-g[1]));}h=j/a.length;var m=this.m_BB[n];m[1]=g[1]-h;m[3]=g[1]+h;m.m_Radius=h;m.m_Pos=g;m.m_bArcCircle=true;}d.strokeStyle=b;d.fillStyle=c;d.lineWidth=1;d.beginPath();if(!A){d.moveTo(f[0],f[1]);if(l){l.push(f);}for(var o=1;o<a.length;++o){x=s.GetPointFromGeo(a[o],false);if(((t=(f[0]-x[0]))*t+(e=(f[1]-x[1]))*e)<9.0){continue;}if(l){l.push(x);}d.lineTo(x[0],x[1]);f=x;}d.closePath();}else{d.arc(g[0],g[1],h,0,2*Math.PI);}d.stroke();d.fill();};this.RenderInstance=function(n,d,p,c,a,r,s,l){var b,e=this.m_Scene;var z=e.GetZoomFactor4Mode();var f=this.m_Scene.m_Canvas[0].m_nExactLOD;var g=Math.sqrt(f);var h=Math.log(r);var i=1/h;var j=2*Math.PI/i;s=(j>s)?j:s;var k=s*g;k=(k<7)?7:k;k=(k>500)?500:k;var m=VBI.MathLib.EquidistantLonLat(VBI.MathLib.DegToRad(p),r,k);if(this.m_Pos.IsChangeable(e.m_Ctx)){(this.m_DH[n]=[e.GetPointFromPos(p,false)]);}var o=e.GetPointFromGeo([m.m_MinX,m.m_MaxY,0.0],false);var q=e.GetPointFromGeo([m.m_MaxX,m.m_MinY,0.0],false);var I=this.m_IO[n]=e.GetCorrectedInstanceOffsets(b=this.m_BB[n]=[o[0],o[1],q[0],q[1]],z);if(this.IsPosChangeable(e.m_Ctx)){var D=(this.m_DH[n]=[]);if(this.IsHandleMode()){D.m_EditMode=VBI.EMHandle;D.push(e.GetPointFromPos(p,false));}else if(this.IsBoxMode()){D.m_EditMode=VBI.EMBox;D.push(b);}}for(var t=0;t<I.length;++t){d.setTransform(1,0,0,1,I[t],0);this.RenderCircleDist(n,d,m,c,a);if(VBI.m_bTrace){VBI.Utilities.DrawFrameRect(d,"red",this.m_BB[n]);}}d.setTransform(1,0,0,1,0,0);if(l&&I.length){var u=[];for(var w=0;w<this.m_LP[n].length;++w){u.push(this.m_LP[n][w][0],this.m_LP[n][w][1]);}var x={pa:u,bb:[o,q]};this.m_Label.push(new VBI.Label(l,n,this.CalculateLabelPos,x,null,I));}};this.Init4Render=this.StandardInitWithLPs;this.Render=function(c,d,a){var b=this.m_Scene.m_Ctx;var n;if((n=this.m_DataSource.GetCurrentNode(b))){for(var e=0,l=n.m_dataelements.length;e<l;++e){this.m_DataSource.Select(e);var h=this.IsHot(e);var S=this.IsSelected(b);var p=this.m_Pos.GetValueVector(b);var f=this.m_ColBorder.GetValueColor(b);if(S){f=this.GetSelectColor(b,f);}if(h){f=this.GetAltBorderColor(b,f);}var r=this.m_Radius.GetValueFloat(b);if(h){r=(this.GetHotScale(b))[0]*r;}var s=this.m_Slices.GetValueLong(b);var g=this.m_ColFill.GetValueColor(b);if(S){g=this.GetSelectColor(b,g);}if(h){g=this.GetHotColor(b,g);}this.m_LP[e]=[];this.RenderInstance(e,d,p,g,f,r,s,this.GetLabel(b));this.SetRichTooltip(h);}}this.BaseRender(c,d);};this.DetailHitTest=function(o,n,a,b){var c=this.m_BB[n];if(c.m_bArcCircle){var r=c.m_Radius;var x=c.m_Pos;var t,d;if(((t=(x[0]-a))*t+(d=(x[1]-b))*d)<r*r){return{m_hit:1};}return null;}else{return VBI.Utilities.pointInPolygon(this.m_LP[n],a,b)?{m_hit:1}:null;}};this.GetHitArray=function(x,y,a){var z=this.m_Scene.GetStretchFactor4Mode();var n=x/z[0];var b=y/z[1];var o={m_cb:this.DetailHitTest.bind(this),m_zf:z,m_All:a};return this.BaseHitTest(n,b,o);};this.DesignGetActiveBoxHandles=function(i){var s=this.m_Scene;this.m_DataSource.Select(i);return this.m_Radius.IsChangeable(s.m_Ctx)?[0,1,0,1,0,1,0,1,0]:[0,0,0,0,0,0,0,0,0];};this.DesignBoxSize=VBI.Utilities.SceneBindMeterRadiusDesignBoxSize.bind(this);};VBI.VisualObjects.CircleDist.prototype=VBI.VisualObjects.Base;VBI.VisualObjects.m_AC=["rgba(0,143,211,1.0)","rgba(153,209,1,1.0)","rgba(243,155,2,1.0)","rgba(159,207,236,1.0)","rgba(75,167,7,1.0)","rgba(246,209,51,1.0)","rgba(203,77,44,1.0)","rgba(202,199,186,1.0)","rgba(13,134,156,1.0)","rgba(205,215,46,1.0)","rgba(36,114,48,1.0)","rgba(108,222,220,1.0)","rgba(235,115,0,1.0)","rgba(185,187,209,1.0)","rgba(0,109,211,1.0)","rgba(61,185,127,1.0)","rgba(165,84,148,1.0)","rgba(1,88,43,1.0)","rgba(77,182,239,1.0)","rgba(175,43,23,1.0)","rgba(212,153,18,1.0)","rgba(187,204,210,1.0)","rgba(48,146,13,1.0)","rgba(29,169,193,1.0)","rgba(42,71,201,1.0)","rgba(209,153,194,1.0)","rgba(204,88,38,1.0)","rgba(114,191,68,1.0)","rgba(10,72,157,1.0)","rgba(151,156,163,1.0)","rgba(14,145,144,1.0)","rgba(97,32,154,1.0)"];VBI.VisualObjects.Pie=function(){this.load=function(d,c){Object.getPrototypeOf(this).load.call(this,d,c);this.m_Props.push(this.m_DataSource=new VBI.NodeProperty(d,'datasource',null,c));this.m_Props.push(this.m_Series=new VBI.NodeProperty(d,'series',this.m_DataSource,c));this.m_Props.push(this.m_Scale=new VBI.AttributeProperty(d,'scale',this.m_DataSource,c,[1.0,1.0,1.0]));this.m_Props.push(this.m_Pos=new VBI.AttributeProperty(d,'pos',this.m_DataSource,c));this.m_Props.push(this.m_Values=new VBI.AttributeProperty(d,'value',this.m_Series,c));this.m_Props.push(this.m_Texts=new VBI.AttributeProperty(d,'text',this.m_Series,c));this.m_Props.push(this.m_SliceColor=new VBI.AttributeProperty(d,'slicecolor',this.m_Series,c));this.m_Props.push(this.m_Tooltips=new VBI.AttributeProperty(d,'extooltip',this.m_Series,c,this.m_defaultTooltip));this.m_Props.push(this.m_Tooltip=new VBI.AttributeProperty(d,'tooltip',this.m_DataSource,c,this.m_defaultTooltip));this.m_Props.push(this.m_StartColor=new VBI.AttributeProperty(d,'startcolor',this.m_DataSource,c,0));this.BaseLoad(d,c,this);};this.LassoSelect=this.LassoSelectCircle;this.RenderInstance=function(n,d,p,r,a,t,c,b,s){var e=this.m_Scene;var z=e.GetZoomFactor4Mode();var f=e.m_Ctx;var g=0;var h;for(h=0;h<a.length;++h){g+=a[h];}this.m_SUM[n]=g;var x=e.GetPointFromPos(p,false);var i;var I=this.m_IO[n]=e.GetCorrectedInstanceOffsets(i=this.m_BB[n]=[x[0]-r,x[1]-r,x[0]+r,x[1]+r],z);i.m_Radius=r;i.m_Pos=x;if(this.IsPosChangeable(f)){var D=(this.m_DH[n]=[]);if(this.IsHandleMode()){D.m_EditMode=VBI.EMHandle;D.push(x);}else if(this.IsBoxMode()){D.m_EditMode=VBI.EMBox;D.push(i);}}this.m_ARC[n]=[3*Math.PI/2];var j=this.m_StartColor.GetValueLong(f);var k=VBI.VisualObjects.m_AC.length;for(var l=0;l<I.length;++l){d.setTransform(1,0,0,1,I[l],0);var m=3*Math.PI/2;for(h=0;h<a.length;++h){var o=d.createRadialGradient(x[0],x[1],0,x[0],x[1],r);var q=c[h];if(!q){q=VBI.VisualObjects.m_AC[(h+j)%k];}if(s){q=this.GetSelectColor(f,q);}if(h==b){q=this.GetHotColor(f,q);}o.addColorStop(0,q);o.addColorStop(0.95,q);o.addColorStop(1.0,'rgba(255,255,255,0.0 )');d.fillStyle=o;d.beginPath();d.moveTo(x[0],x[1]);var u=Math.PI*2*(a[h]/g);d.arc(x[0],x[1],r,m,m+u,false);d.lineTo(x[0],x[1]);d.closePath();d.fill();m+=u;if(!l){this.m_ARC[n].push(m);}}}d.setTransform(1,0,0,1,0,0);};this.Init4Render=function(){this.m_BB=[];this.m_IO=[];this.m_DH=[];this.m_ARC=[];this.m_SUM=[];};this.Render=function(c,d,a){var s=this.m_Scene;var b=s.m_Ctx;var e=0;var n,f;if((n=this.m_DataSource.GetCurrentNode(b))){e=n.m_dataelements.length;for(var g=0;g<e;++g){this.m_DataSource.Select(g);var p=this.m_Pos.GetValueVector(b);var S=this.m_Scale.GetValueVector(b);var r=16*S[0];var h=this.IsHot(g);var i=this.IsSelected(b);if(h){r=(this.GetHotScale(b))[0]*r;}var V=[],t=[],j=[];if((f=this.m_Series.GetCurrentNode(b))){for(var k=0;k<f.m_dataelements.length;++k){this.m_Series.Select(k);V.push(this.m_Values.GetValueFloat(b));t.push(this.m_Texts.GetValueString(b));var l=this.m_SliceColor.GetValueString(b);j.push(l?this.m_SliceColor.GetValueColor(b):l);}}var m,o=(h&&(m=s.m_HotItem.m_HitObj)&&(m=m.m_Detail))?m.m_slice:-1;this.RenderInstance(g,d,p,r,V,t,j,o,i);this.SetRichTooltip(h);}}this.BaseRender(c,d);return e;};this.DetailHitTest=function(o,n,a,b){var c=this.m_BB[n];var r=c.m_Radius;var p=c.m_Pos;var t,d;if(((t=(p[0]-a))*t+(d=(p[1]-b))*d)<(r*r)){var e=Math.acos(d/Math.sqrt(t*t+d*d));var f=(t<=0?3*Math.PI/2+e:7*Math.PI/2-e);var m=this.m_ARC[n];var l=0,h=m.length-1,g;while(h>l+1){g=Math.round((l+h)/2);if(m[g]>f){h=g;}else{l=g;}}return{m_hit:1,m_slice:l};}return null;};this.GetHitArray=function(x,y,a){var z=this.m_Scene.GetStretchFactor4Mode();var n=x/z[0];var b=y/z[1];var o={m_cb:this.DetailHitTest.bind(this),m_All:a};return this.BaseHitTest(n,b,o);};this.doFormatedReplaces=function(m,s,e,a){var l=s.length;var n;while((n=m.indexOf(s))>=0){var b=n+m.substring(n+l).indexOf(e)+l+1;var f=m.substring(n+l,b-1);var u=false,c;if((c=f.indexOf(","))>=0){u=true;}else{c=f.indexOf(".");}var d=Math.min(10,(c>=0?parseInt(f.substring(c+1),10):0));var g=m.substring(n,b);var h=""+a.toFixed(d);if(u){h=h.replace(".",",");}m=m.replace(g,h);}return m;};this.getTooltip=function(c,h){var p=h.m_Index;var i=h.m_Detail.m_slice;this.m_DataSource.Select(p);this.m_Series.Select(i);var t=this.m_Tooltips.GetValueString(c);if(t==""){t=this.m_Tooltip.GetValueString(c);}if((t===null)||(t==="")){return"";}t=t.replace(/%MAIN%/,this.m_Tooltip.GetValueString(c));t=t.replace(/%NUM%/g,i+1);t=t.replace(/%ONUM%/g,i+1);t=t.replace(/%NAME%/g,this.m_Texts.GetValueString(c));var a=parseFloat(this.m_Values.GetValueString(c));t=this.doFormatedReplaces(t,"%VALUE","%",a);t=this.doFormatedReplaces(t,"%PERCENTAGE","%",100*a/this.m_SUM[p]);return t;};this.DesignBeginDrag=function(o){o.m_ScaleOrig=this.m_Scale.GetValueVector(this.m_Scene.m_Ctx).slice(0);o.m_DhOrig=this.m_DH[o.m_Index].slice(0);if(o.m_IO){(o.m_DhOrig[0])[0]+=o.m_IO;(o.m_DhOrig[0])[2]+=o.m_IO;}};this.DesignBoxSize=VBI.Utilities.SceneBindDesignBoxBoxSize.bind(this,true);};VBI.VisualObjects.Pie.prototype=VBI.VisualObjects.Base;VBI.VisualObjects.Box=function(){this.load=function(d,c){Object.getPrototypeOf(this).load.call(this,d,c);this.m_Props.push(this.m_DataSource=new VBI.NodeProperty(d,'datasource',null,c));this.m_Props.push(this.m_Pos=new VBI.AttributeProperty(d,'pos',this.m_DataSource,c,[0.0,0.0,0.0]));this.m_Props.push(this.m_Scale=new VBI.AttributeProperty(d,'scale',this.m_DataSource,c,[1.0,1.0,1.0]));this.m_Props.push(this.m_Tooltip=new VBI.AttributeProperty(d,'tooltip',this.m_DataSource,c,this.m_defaultTooltip));this.m_Props.push(this.m_Color=new VBI.AttributeProperty(d,'color',this.m_DataSource,c,this.m_defaultColor));this.m_Props.push(this.m_ColorBorder=new VBI.AttributeProperty(d,'colorBorder',this.m_DataSource,c,this.m_defaultColor));this.m_Props.push(this.m_AltColorBorder=new VBI.AttributeProperty(d,'altBorderDeltaColor',this.m_DataSource,c,null));this.BaseLoad(d,c,this);};this.RenderInstance=function(n,d,p,s,c,a,e){var g,h=this.m_Scene;var z=h.GetZoomFactor4Mode();var i=h.GetStretchFactor4Mode();if(!s){s=[1.0,1.0,1.0];}if(!c){c="#6f6f7a";}var x=h.GetPointFromPos(p,false);var j=1.0;var k=1.0;if(this.IsHot(n)){var m=this.GetHotScale(h.m_Ctx);j=m[0];k=m[1];}var o=370;var q=o*s[0]*j/i[0];var u=o*s[1]*k/i[1];if(!e){var f=Math.pow(2,h.GetCurrentZoomlevel())/14.6;q*=f;u*=f;}var l=x[0]-q/2;var t=x[1]-u/2;var r=x[0]+q/2;var b=x[1]+u/2;var I=this.m_IO[n]=h.GetCorrectedInstanceOffsets(g=this.m_BB[n]=[l,t,r,b],z);if(this.IsPosChangeable(h.m_Ctx)){var D=(this.m_DH[n]=[]);if(this.IsHandleMode()){D.m_EditMode=VBI.EMHandle;D.push(x);}else if(this.IsBoxMode()){D.m_EditMode=VBI.EMBox;D.push(g);}}for(var w=0;w<I.length;++w){d.setTransform(1,0,0,1,I[w],0);d.fillStyle=c;d.fillRect(l,t,q,u);d.lineWidth=1;d.strokeStyle=a;d.strokeRect(l,t,q,u);if(VBI.m_bTrace){VBI.Utilities.DrawFrameRect(d,"red",this.m_BB[n]);}}d.setTransform(1,0,0,1,0,0);};this.Init4Render=this.StandardInit;this.Render=function(c,d,a){var s=this.m_Scene,b=s.m_Ctx;var e=0;var n;if((n=this.m_DataSource.GetCurrentNode(b))){e=n.m_dataelements.length;for(var f=0;f<e;++f){this.m_DataSource.Select(f);var h=this.IsHot(f);var S=this.IsSelected(b);var p=this.m_Pos.GetValueVector(b);var g=this.m_Scale.GetValueVector(b);var C=this.m_Color.GetValueColor(b);if(S){C=this.GetSelectColor(b,C);}if(h){C=this.GetHotColor(b,C);}var i=this.m_ColorBorder.GetValueColor(b);if(S){i=this.GetSelectColor(b,i);}if(h){i=this.GetAltBorderColor(b,i);}var F=this.m_FxSize.GetValueBool(b);this.RenderInstance(f,d,p,g,C,i,F);this.SetRichTooltip(h);}}this.BaseRender(c,d);return e;};this.DetailHitTest=function(o,n,a,b){return{m_hit:1};};this.GetHitArray=function(x,y,a){var z=this.m_Scene.GetStretchFactor4Mode();var n=x/z[0];var b=y/z[1];var o={m_cb:this.DetailHitTest.bind(this),m_All:a};return this.BaseHitTest(n,b,o);};this.DesignBeginDrag=function(o){o.m_ScaleOrig=this.m_Scale.GetValueVector(this.m_Scene.m_Ctx).slice(0);o.m_DhOrig=this.m_DH[o.m_Index].slice(0);if(o.m_IO){(o.m_DhOrig[0])[0]+=o.m_IO;(o.m_DhOrig[0])[2]+=o.m_IO;}};this.DesignBoxSize=VBI.Utilities.SceneBindDesignBoxBoxSize.bind(this,false);};VBI.VisualObjects.Box.prototype=VBI.VisualObjects.Base;VBI.VisualObjects.Area=function(){this.m_LineWidth=1;this.load=function(d,c){Object.getPrototypeOf(this).load.call(this,d,c);this.m_Props.push(this.m_DataSource=new VBI.NodeProperty(d,'datasource',null,c));if(typeof(d["posarraymulti.bind"])==="string"||typeof(d["posarraymulti"])==="string"){this.m_Props.push(this.m_PosM=new VBI.AttributeProperty(d,'posarraymulti',this.m_DataSource,c));this.m_Pos=null;}else{this.m_Props.push(this.m_Pos=new VBI.AttributeProperty(d,'posarray',this.m_DataSource,c));this.m_PosM=null;}this.m_Props.push(this.m_Scale=new VBI.AttributeProperty(d,'scale',this.m_DataSource,c));this.m_Props.push(this.m_Color=new VBI.AttributeProperty(d,'color',this.m_DataSource,c,this.m_defaultColor));this.m_Props.push(this.m_ColorBorder=new VBI.AttributeProperty(d,'colorBorder',this.m_DataSource,c,null));this.m_Props.push(this.m_BorderDash=new VBI.AttributeProperty(d,'borderDash',this.m_DataSource,c,null));this.m_Props.push(this.m_Tooltip=new VBI.AttributeProperty(d,'tooltip',this.m_DataSource,c,this.m_defaultTooltip));this.m_Props.push(this.m_AltColorBorder=new VBI.AttributeProperty(d,'altBorderDeltaColor',this.m_DataSource,c,null));this.BaseLoad(d,c,this);};this.LassoSelect=function(p,h,o){var e=false;var s,a;var f=false;for(var n=this.m_LP.length-1;n>=0;--n){s=this.m_LP[n];e=false;for(var b=0;b<s.length;++b){a=s[b];if(jQuery.type(a[0])=='array'&&jQuery.type(a[0][0])=='array'){a=a[0];}if(!(e=VBI.Utilities.polyInPolygon(p,a,this.m_IO[n]))){break;}}if(e){h.push(n);o.push(n);f=true;}}return f;};this.RenderArea=function(a,d,p,c,b,e,l,h){var s=l*l/2;var i,x,t,f;var g=this.m_Scene;var n=g.m_CacheVars;if(p[0].length<6){return;}var L=this.m_LP[a];if(L.length){L=null;}var j=d.setLineDash?true:false;var k=false;var m=this.m_Scene.m_Canvas[0].m_nExactLOD;if(j&&e&&(VBI.m_bIsIDevice||VBI.m_bIsAndroid||m==Math.floor(m)||m<=(this.m_Scene.m_CacheVars.minLOD+0.01))){var o=e.split(";");d.setLineDash(o);k=true;}d.strokeStyle=(b)?b:c;d.fillStyle=c;d.lineWidth=h>-1?2:l;d.lineCap='round';var q=n.factX;var r=n.factY;var u=n.addX;var w=n.addY;d.beginPath();for(var y=0,z=p.length;y<z;++y){var A=[p[y][0]*q+u,p[y][1]*r+w];if(L){L.push([]);L[y].push(A);}d.moveTo(A[0],A[1]);var B=p[y].length;for(i=3;i<B;i+=3){x=[p[y][i]*q+u,p[y][i+1]*r+w,0.0];if(((t=(A[0]-x[0]))*t+(f=(A[1]-x[1]))*f)<s){continue;}d.lineTo(x[0],x[1]);if(L){L[y].push(x);}A=x;}}d.closePath();d.fill();d.stroke();if(k){d.setLineDash([]);}};this.CalculateLabelPos=function(s,p,o){var z=s.GetStretchFactor4Mode();var r=s.GetInternalDivClientRect();var a=r.width/z[0];var b=r.height/z[1];var P=s.m_Canvas[0].getPixelLeft()/z[0];var c=s.m_Canvas[0].getPixelTop()/z[1];var d=[-P,-c,-P+a,-c+b];var e=VBI.Utilities.GetMidpointsForPolygon(p.pa,p.bb,o,d);if(e&&e.aPos){return e.aPos;}return null;};this.ExtendBB=function(t,b){if(t[0]>b[0]){t[0]=b[0];}if(t[1]>b[1]){t[1]=b[1];}if(t[2]<b[2]){t[2]=b[2];}if(t[3]<b[3]){t[3]=b[3];}};this.IsPosChangeable=function(c){if(!VBI.m_bMouseSupported){return false;}if(this.m_PosM){return this.m_PosM.IsChangeable(c);}else{return Object.getPrototypeOf(this).IsPosChangeable.call(this,c);}};this.CalcExcludeAreaMinLod=function(s,m,l,a){var b=s.GetNearestPosArray(m);var c=s.GetPointFromPos([b.m_MinX,b.m_MaxY,0.0],false);var r=s.GetPointFromPos([b.m_MaxX,b.m_MinY,0.0],false);return this.CalcAreaMinLod(c,r,l,a);};this.RenderShape=function(a,d,p,c,b,e,l,h,f,g){var s=this.m_Scene;var E=false,i;if(typeof(p[0])==="number"){i=p;}else{i=p[0];E=true;}var z=s.GetZoomFactor4Mode();var n=s.m_CacheVars;if(i.cache==undefined){s.FillPositionCache(i);}var j=2.1;if(i.cache.minLod>g-j){return;}var k=[(i.cache.lt[0]*n.completeX-n.ox)*n.fx,(i.cache.lt[1]*n.completeY-n.oy)*n.fy];var r=[(i.cache.rb[0]*n.completeX-n.ox)*n.fx,(i.cache.rb[1]*n.completeY-n.oy)*n.fy];var B,I=s.GetCorrectedInstanceOffsets(B=[k[0]-l,k[1]-l,r[0]+l,r[1]+l],z);if(this.m_BB[a]){this.ExtendBB(this.m_BB[a],B);this.m_IO[a]=s.GetCorrectedInstanceOffsets(this.m_BB[a],z);}else{this.m_IO[a]=I;this.m_BB[a]=B;}var m;var o=null;if(I.length){o=[];o.push(i.cache.data);if(E){for(var q=1,t=p.length;q<t;++q){var u=p[q];if(u.cache==undefined){s.FillPositionCache(u);}if(u.cache.minLod<=g+j){o.push(u.cache.data);}}}if(this.IsPosChangeable(s.m_Ctx)){var D=(this.m_DH[a]=[]);if(this.IsHandleMode()){D.m_EditMode=VBI.EMHandle;var w=o[0].length/3;for(m=0;m<w;++m){D.push([(o[0][m*3]*n.completeX-n.ox)*n.fx,(o[0][m*3+1]*n.completeY-n.oy)*n.fy]);}}else if(this.IsBoxMode()){D.m_EditMode=VBI.EMBox;D.push(this.m_BB[a]);}}for(m=0;m<I.length;++m){d.setTransform(1,0,0,1,I[m],0);this.RenderArea(a,d,o,c,b,e,l,h);if(VBI.m_bTrace){VBI.Utilities.DrawFrameRect(d,"red",this.m_BB[a]);}}d.setTransform(1,0,0,1,0,0);if(f){var x=s.GetShortPointArrayFromUCSArray(i.cache.data);var y={pa:x,bb:[k,r]};this.m_Label.push(new VBI.Label(f,a,this.CalculateLabelPos,y,null,I));}}};this.RenderInstance=function(n,d,h,c,s,b){this.m_LP[n]=[];var e=this.m_Scene;var f=-1;var g=this.m_Color.GetValueColor(c);var i=this.m_ColorBorder.GetValueColor(c);var j=this.m_BorderDash.GetValueString(c);if(s){g=this.GetSelectColor(c,g);i=this.GetAltBorderColor(c,i);}else if(this.GetNumActiveSelections(c)){g=this.GetNonSelectColor(c,g);}if(h){var k=e.m_HotItem.m_HitObj.m_Detail;if(k&&k.m_edge>=0&&(this.BaseFindAction("EdgeClick")||this.BaseFindAction("EdgeContextMenu"))){f=k.m_edge;}else{g=this.GetHotColor(c,g);}i=this.GetAltBorderColor(c,i);}var p;if(this.m_Pos){p=this.m_Pos.GetValueVector(c);this.RenderShape(n,d,p,g,i,j,this.m_LineWidth,f,this.GetLabel(c),b);}else if(this.m_PosM){var a=this.m_PosM.GetValueVector(c);var m=[];for(var o=0,l=a.length;o<l;++o){this.RenderShape(n,d,a[o],g,i,j,this.m_LineWidth,f,this.GetLabel(c),b);if(this.m_LP[n].length){(m.push(this.m_LP[n]));this.m_LP[n]=[];}}this.m_LP[n]=m;}};this.Init4Render=this.StandardInitWithLPs;this.Render=function(c,d,a){var b=this.m_Scene.m_Ctx;var s=[];var n,l;var h;var e=this.m_Scene.m_Canvas[0].m_nExactLOD;if((n=this.m_DataSource.GetCurrentNode(b))){l=n.m_dataelements.length;for(var f=0;f<l;++f){this.m_DataSource.Select(f);var H=this.IsHot(f);if(H){h=f;}else if(this.IsSelected(b)){s.push(f);}else{this.RenderInstance(f,d,false,b,false,e);}this.SetRichTooltip(H);}}l=s.length;for(var i=0;i<l;i++){this.m_DataSource.Select(s[i]);this.RenderInstance(s[i],d,false,b,true,e);}if(h!=undefined){this.m_DataSource.Select(h);this.RenderInstance(h,d,true,b,this.IsSelected(b),e);}this.BaseRender(c,d);};this.DetailHitTest=function(a,n,b,c){var h=false;var l;var L=this.m_LP[n];if(jQuery.type(L[0])=='array'&&jQuery.type(L[0][0])=='array'&&jQuery.type(L[0][0][0])=='array'){l=L.length;for(var d=0;!h&&d<l;++d){L=this.m_LP[n][d];h=VBI.Utilities.pointInPolygon(L,b,c);}}else{h=VBI.Utilities.pointInPolygon(L,b,c);}if(h){var H={m_hit:1};var o;if((o=VBI.Utilities.pointOnLine(L[0],b,c,5,true))&&o.m_edge>=0){H.m_edge=o.m_edge;H.m_node=o.m_node;}return H;}return null;};this.GetHitArray=function(x,y,a){var z=this.m_Scene.GetStretchFactor4Mode();var n=x/z[0];var b=y/z[1];var o={m_cb:this.DetailHitTest.bind(this),m_All:a};return this.BaseHitTest(n,b,o);};this.ProcessDetailNodeEdgeEvent=function(e,a,h,n){var s=this.m_Scene,b=s.m_Ctx.m_Actions;if(b){var c;if((c=b.findAction(n,s,this))){var p=s.GetEventVPCoordsObj(e);p.edge=h.m_Detail.m_edge.toString();p.node=h.m_Detail.m_node.toString();this.m_Scene.m_Ctx.FireAction(c,s,this,a,p);return true;}}return false;};this.DetailClick=function(e,a,h){if(h.m_Detail&&(h.m_Detail.m_edge>=0)){return this.ProcessDetailNodeEdgeEvent(e,a,h,'EdgeClick');}return false;};this.DetailContextmenu=function(e,a,h){if(h.m_Detail&&(h.m_Detail.m_edge>=0)){return this.ProcessDetailNodeEdgeEvent(e,a,h,'EdgeContextMenu');}return false;};this.DesignBoxSize=VBI.Utilities.SceneBindPosArrayDesignBoxSize.bind(this);};VBI.VisualObjects.Area.prototype=VBI.VisualObjects.Base;VBI.VisualObjects.HeatMap=function(){this.load=function(d,c){jQuery.sap.require("sap.ui.vbm.lib.sapheatmap");Object.getPrototypeOf(this).load.call(this,d,c);this.m_Props.push(this.m_DataSource=new VBI.NodeProperty(d,'datasource',null,c));this.m_Props.push(this.m_Pos=new VBI.AttributeProperty(d,'pos',this.m_DataSource,c));this.m_Props.push(this.m_Value=new VBI.AttributeProperty(d,'value',this.m_DataSource,c,1));this.m_Props.push(this.m_Opacity=new VBI.AttributeProperty(d,'opacity',this.m_DataSource,c,0.5));this.m_Props.push(this.m_Gradient=new VBI.AttributeProperty(d,'gradient',this.m_DataSource,c,""));this.m_Props.push(this.m_Radius=new VBI.AttributeProperty(d,'radius',this.m_DataSource,c,5));this.m_Props.push(this.m_Behavior=new VBI.AttributeProperty(d,'behavior',this.m_DataSource,c,2));this.m_Props.push(this.m_RScale=new VBI.AttributeProperty(d,'radiusScale',this.m_DataSource,c,1.0));this.m_Props.push(this.m_VScale=new VBI.AttributeProperty(d,'valueScale',this.m_DataSource,c,1.0));this.m_Props.push(this.m_AExp=new VBI.AttributeProperty(d,'alphaExponent',this.m_DataSource,c,1.0));this.m_Props.push(this.m_CExp=new VBI.AttributeProperty(d,'colorExponent',this.m_DataSource,c,1.0));var g=(jQuery.type(this.m_Gradient.m_Value)=='array');this.GradientImage=new Image();this.GradientImage.onload=function(){this.GradientImage.IsLoaded=true;}.bind(this);if(g){this.m_GeneratedGradient=this.GenerateGradient(this.m_Gradient.m_Value);this.GradientImage.src=this.m_GeneratedGradient;}else{this.GradientImage.src=c.GetResources().GetData(this.m_Gradient.GetValueString(c));}this.cache=undefined;this.BaseLoad(d,c,this);};this.SetColor=function(c,p,m,a,b,d){var j=4*p;c[j]=a[0]*m+d[0]*b;c[j+1]=a[1]*m+d[1]*b;c[j+2]=a[2]*m+d[2]*b;c[j+3]=a[3]*m+d[3]*b;};this.SetColor1=function(c,p,a){var j=4*p;c[j]=a[0];c[j+1]=a[1];c[j+2]=a[2];c[j+3]=255;};this.GenerateGradient=function(c){var a=c.length/2;var b=c[2*(a-1)];var d=this.m_Scene.m_TargetName+"-"+this.m_Scene.m_ID+"-";var t=VBI.Utilities.CreateGeoSceneCanvas(d+"temporary",b,1,0,false);var e=t.getContext("2d");var f=[];e.lineWidth=1;var i;for(i=0;i<a;++i){e.fillStyle=c[2*i+1];e.fillRect(c[2*i],0,1,1);var D=e.getImageData(c[2*i],0,1,1);f.push(D.data);}var w=e.getImageData(0,0,b,1);for(i=1;i<a;++i){var g=f[i-1];var h=VBI.Utilities.RGB2HLS(g[0],g[1],g[2]);var k=h[0];var l=h[1];var s=h[2];var m=c[2*(i-1)],n=c[2*i],o=n-m;var p=f[i];var q=VBI.Utilities.RGB2HLS(p[0],p[1],p[2]);var r=q[0];var u=(r-k)/o;for(var j=m;j<=n;++j){var x=VBI.Utilities.HLS2RGB(k+(j-m)*u,l,s);this.SetColor1(w.data,j,x);}}e.putImageData(w,0,0);return t.toDataURL("png");};this.CollectData=function(c){var s=this.m_Scene;var n,V=[],r=[],p=[];var m=[];var d=0;if((n=this.m_DataSource.GetCurrentNode(c))){for(var e=0,l=n.m_dataelements.length;e<l;++e){this.m_DataSource.Select(e);var f=this.m_Pos.GetValueVector(c);m.push({x:f[0],y:f[1],r:this.m_Radius.GetValueFloat(c),v:this.m_Value.GetValueFloat(c)});}m.sort(function(a,b){return a.x-b.x;});for(var g=0;g<m.length;++g){var h=m[g];V.push(h.v);r.push(h.r);p.push(h.x,h.y,0);if(h.r>d){d=h.r;}}}s.FillPositionCache(p,true);this.cache=p.cache;this.cache.val=V;this.cache.rad=r;this.cache.maxRad=d;};this.Init4Render=function(){this.m_IO=[];};this.AddPoints2Heatmap=function(h,V,e,c,f){var a=h.m_V;var s=this.m_Scene;h.Clear();var b,d;var g=h.m_W;var i=h.m_H;var m=(e*V.maxRad/c)/2.0;var p=s.GetPointArrayFromUCSArray(V.data);for(var n=0;n<this.m_IO.length;++n){var l=V.data.length;var o=this.m_IO[n];var x=p[0]+o,j=p[l-3]+o;var t=0,k=l/3,q=0,r=0,u;if(x<=-m&&j>-m){t=l/3;while(t>q+1){u=Math.floor((q+t)/2);if(p[3*u]+o<=-m){q=u;}else{t=u;}}}if(x>i+m&&j<=i+m){while(k>r+1){u=Math.floor((r+k)/2);if(p[3*u]+o<=i+m){r=u;}else{k=u;}}}for(var w=3*t,y=t;y<k;w+=3,y++){var z=p[w]+o;var A=p[w+1];d=(e*V.rad[y]/c)/2.0;if((A>-d)&&(z<g+d)){b=f*(V.val[y])/50;a.AddPoint(z,A,b,d);}}}a.m_PointsSet=true;};this.Render=function(c,d){var s=this.m_Scene;var b=s.m_Ctx;var e=c.clientWidth;var f=c.clientHeight;var w=s.m_nWidthCanvas;var h=s.m_nHeightCanvas;var g=this.m_GeneratedGradient?this.m_GeneratedGradient:b.GetResources().GetData(this.m_Gradient.GetValueString(b));if(this.HeatmapWidth!=w||this.HeatmapHeight!=h){var i=document.createElement("canvas");i.width=2*w;i.height=2*h;this.Heatmap=VBI.CreateHM({canvas:i,colorTexture:g,colorTex:this.GradientImage,alpha:true,width:2*w,height:2*h,scene:this.m_Scene,aFunc:this.m_AExp.GetValueFloat(b),cFunc:this.m_CExp.GetValueFloat(b)});this.HeatmapWidth=w;this.HeatmapHeight=h;}var j=this.Heatmap;if(!this.cache){this.CollectData(b);}var l=s.GetPointFromUCSPoint([this.cache.lt[0],this.cache.lt[1]]);var r=s.GetPointFromUCSPoint([this.cache.rb[0],this.cache.rb[1]]);var z=s.GetZoomFactor4Mode();this.m_IO=s.GetCorrectedInstanceOffsets([l[0],l[1],r[0],r[1]],z);var k=this.m_RScale.GetValueFloat(b);var F=this.m_VScale.GetValueFloat(b);var m=this.m_Behavior.GetValueFloat(b);var n=s.m_Canvas[0].m_nExactLOD;var o=Math.floor(n);var p=(s.m_bObjCanvasMode==0?Math.pow(2,n-o):1.0)/k;var q=1.0;if(m>0){q=1+s.m_Canvas[0].m_nExactLOD;if(m==2){q=Math.pow(2,q);}}this.AddPoints2Heatmap(j,this.cache,q,p,F);j.Render();var a=d.globalAlpha;d.globalAlpha=this.m_Opacity.GetValueFloat(b);d.drawImage(j.m_Canv,0,0,e,f,0,0,e,f);d.globalAlpha=a;};this.DetailHitTest=function(o,n,a,b){return null;};this.GetHitArray=function(x,y){var z=this.m_Scene.GetStretchFactor4Mode();var n=x/z[0];var a=y/z[1];var o={m_cb:this.DetailHitTest.bind(this)};return this.BaseHitTest(n,a,o);};this.DesignBeginDrag=function(o){o.m_ScaleOrig=this.m_Scale.GetValueVector(this.m_Scene.m_Ctx).slice(0);o.m_DhOrig=this.m_DH[o.m_Index].slice(0);if(o.m_IO){(o.m_DhOrig[0])[0]+=o.m_IO;(o.m_DhOrig[0])[2]+=o.m_IO;}};this.DesignBoxSize=VBI.Utilities.SceneBindDesignBoxBoxSize.bind(this,true);};VBI.VisualObjects.HeatMap.prototype=VBI.VisualObjects.Base;VBI.VisualObjects.Container=function(){this.m_Sub=[];this.m_bContainer=true;this.m_openWin=[];this.m_Marker=1;this.load=function(d,c){Object.getPrototypeOf(this).load.call(this,d,c);this.m_Props.push(this.m_DataSource=new VBI.NodeProperty(d,'datasource',null,c));this.m_Props.push(this.m_Pos=new VBI.AttributeProperty(d,'pos',this.m_DataSource,c));this.m_Props.push(this.m_Key=new VBI.AttributeProperty(d,'key',this.m_DataSource,c,""));this.m_Props.push(this.m_Tooltip=new VBI.AttributeProperty(d,'tooltip',this.m_DataSource,c,""));this.m_Props.push(this.m_Alignment=new VBI.AttributeProperty(d,'alignment',this.m_DataSource,c,"0"));this.m_Sub.push(this.m_Scene.m_EvtCont.subscribe("onMove",this.onLayout.bind(this)));this.m_bChanged=true;};this.clear=function(){for(var n=0,l=this.m_Sub.length;n<l;++n){this.m_Sub[n].unsubscribe();}this.m_Sub=[];this.m_Marker++;this.sweepContainers(this.m_Scene.m_Ctx);Object.getPrototypeOf(this).clear.call(this);};this.getParentDiv=function(){return this.m_Scene.m_MapsLayerDiv;};this.sweepContainers=function(c){for(var k in this.m_openWin){if(this.m_openWin[k].Marker!=this.m_Marker){var a=this.m_openWin[k];c.onCloseContainer(a.id,a);var p=this.getParentDiv();p.removeChild(a);delete this.m_openWin[k];}}};this.updateContainers=function(c,s,a){var d=this.getParentDiv();var x=c.getPixelLeft();var y=c.getPixelTop();var l,n;var b;if((b=this.m_DataSource.GetCurrentNode(a))){l=b.m_dataelements.length;for(n=0;n<l;++n){this.m_DataSource.Select(n);var p=this.m_Pos.GetValueVector(a);var k=this.m_Key.GetValueString(a);var t=this.m_Tooltip.GetValueString(a);var e=s.GetPointFromPos(p,false);var f=this.m_openWin[k];if(f){if(!f.children.length){a.onOpenContainer(k,f);}}else{f=VBI.Utilities.CreateContainer("vbi_"+k,k,x+(e[0]|0),y+(e[1]|0),"50px","30px",t);f.addEventListener("mouseover",this.onMouseOverDiv.bind(f));f.addEventListener("mouseout",this.onMouseOutDiv.bind(f));f.m_ID=this.m_ID;this.m_openWin[k]=f;this.m_openWin[k].index=n;d.appendChild(f);a.onOpenContainer(k,f);}this.m_openWin[k].Marker=this.m_Marker;}}this.sweepContainers(a);};this.onMouseOverDiv=function(){this.bIsHot=true;};this.onMouseOutDiv=function(){this.bIsHot=false;};this.onLayout=function(o){var s=this.m_Scene;var c=s.m_Canvas[s.m_nOverlayIndex];this.clusterParams=this.GetClusterPosParameters();var e=s.m_Canvas[0].m_nExactLOD;if(!this.m_LastCanvasPos||this.m_LastCanvasPos[2]!=e){return;}var d=[c.getPixelLeft()-this.m_LastCanvasPos[0],c.getPixelTop()-this.m_LastCanvasPos[1]];for(var k in this.m_openWin){var a=this.m_openWin[k];if(d[0]){var n=parseFloat(a.style.left)+d[0];n+=this.findRoundWorldOffset(n);a.style.left=(n)+"px";}if(d[1]){a.style.top=(parseInt(a.style.top,10)+d[1])+"px";}}this.m_LastCanvasPos=[c.getPixelLeft(),c.getPixelTop(),s.m_Canvas[0].m_nExactLOD];};this.ContainerAlign=function(c,a){var b=this.m_Alignment.GetValueString(a);var s=c.style;switch(b){case"0":s.msTransform=s.transform=s.webkitTransform="translate( -50%, -50%)";break;case"1":s.msTransform=s.transform=s.webkitTransform="translate( -50%,   0%)";break;case"2":s.msTransform=s.transform=s.webkitTransform="translate(-100%,   0%)";break;case"3":s.msTransform=s.transform=s.webkitTransform="translate(-100%, -50%)";break;case"4":s.msTransform=s.transform=s.webkitTransform="translate(-100%,-100%)";break;case"5":s.msTransform=s.transform=s.webkitTransform="translate( -50%,-100%)";break;case"6":s.msTransform=s.transform=s.webkitTransform="translate(   0%,-100%)";break;case"7":s.msTransform=s.transform=s.webkitTransform="translate(   0%, -50%)";break;default:case"8":s.msTransform=s.transform=s.webkitTransform="translate(0%, 0%)";break;}};this.RenderInstances=function(c,z){var s=this.m_Scene;var a=s.m_Ctx;if(this.m_bChanged){this.updateContainers(c,s,a);this.m_bChanged=false;}var x=c.getPixelLeft();var y=c.getPixelTop();if(this.m_DataSource.GetCurrentNode(a)){for(var k in this.m_openWin){var b=this.m_openWin[k];if(b.index==undefined){continue;}this.m_DataSource.Select(b.index);var p=this.m_Pos.GetValueVector(a);var l=s.GetPointFromPos(p,true);var d=Math.round(x+(l[0]|0)*z[0]);d=d+this.findRoundWorldOffset(d);b.style.left=d+"px";b.style.top=Math.round(y+(l[1]|0)*z[1])+"px";this.ContainerAlign(b,a);}}};this.GetClusterPosParameters=function(){var r={};var s=this.m_Scene;var e=s.m_Canvas[0].m_nExactLOD;r.worldPxOnLOD=Math.pow(2,e)*s.m_nWidthCanvas/s.m_nTilesX*s.m_Proj.m_nXYRatio;r.nLeftBorder=s.m_nDivWidth-r.worldPxOnLOD;r.nRightBorder=s.m_nDivWidth-r.nLeftBorder;return r;};this.findRoundWorldOffset=function(x){var o=0;var c=this.clusterParams;while(x+o<c.nLeftBorder){o+=c.worldPxOnLOD;}while(x+o>c.nRightBorder){o-=c.worldPxOnLOD;}return o;};this.GetClusterPosition=function(d,e,c,n,a,l,x,y){var b;var s=this.m_Scene;var X=d.canvas.getPixelLeft();var Y=d.canvas.getPixelTop();var z=s.GetCurrentZoomFactors();b=[X+z[0]*(l*e[0]-x),Y+z[1]*(l*e[1]-y)];var o=this.findRoundWorldOffset(b[0]);var f=this.m_Scene.GetZoomFactor4Mode();b[0]+=o;b[2]=o/f[0];if(e.c!=undefined&&c.anim&&(n>c.animLow)&&a&&e.c!=undefined&&e.c.lod==n-1){var g=this.m_Scene.GetStretchFactor4Mode();var E=e.c;var h=a*a;b=[X+o+z[0]*(l*(e[0]*(1-h)+E[0]*h)-x),Y+z[1]*(l*(e[1]*(1-h)+E[1]*h)-y),o/f[0]];if(c.anim==2){var i=[o+f[0]*(l*E[0]-x),f[1]*(l*E[1]-y)];var t=2*Math.abs(0.5-a);var j=""+(1-t);d.strokeStyle="rgba(110,110,110,"+j+")";d.lineWidth=2;d.lineCap='round';d.beginPath();d.moveTo((b[0]-X)/g[0],(b[1]-Y)/g[0]);d.lineTo(i[0],i[1]);d.stroke();}}return b;};this.RenderThisInstance=function(e,a,c,b,n,d,f,g,h,i,l,x,y,r){var s=this.m_Scene;var j=this.m_Scene.m_Ctx;var k=this.getParentDiv();var m=this.GetClusterPosition(f,e,c,h,i,l,x,y);var o=s.m_Ctx.m_Clustering.getClusterIdent(s.m_PreassembledData,b,d);var p=this.m_openWin[o];if(p==undefined){p=VBI.Utilities.CreateContainer("vbi_"+o,o,m[0],m[1],"50px","30px","",true);p.addEventListener("mouseover",this.onMouseOverDiv.bind(p));p.addEventListener("mouseout",this.onMouseOutDiv.bind(p));p.m_ID=this.m_ID;p.index=e.nJ;k.appendChild(p);this.m_openWin[o]=p;j.onOpenContainer(o,p);this.ContainerAlign(p,j);}else{if(p.bIsHot){this.RenderShadow(g,e,a,c,h,l,x-m[2],y);}p.style.left=Math.round(m[0])+"px";p.style.top=Math.round(m[1])+"px";}this.m_openWin[o].Marker=this.m_Marker;};this.Render=function(c,d,p,s,a,C){var b=this.m_Scene;var e=this.m_Scene.m_Ctx;var E=b.m_Canvas[0].m_nExactLOD;this.m_Marker++;this.clusterParams=this.GetClusterPosParameters();if(C){var f=0;var x=b.m_Canvas[0].m_nCurrentX*b.m_MapManager.m_tileWidth;var y=b.m_Canvas[0].m_nCurrentY*b.m_MapManager.m_tileHeight;var g=p.config;var h=p.cI;var n=p.m_TreeFatherNode;var i=Math.ceil(E);if(n){var j=this.GetAnimClusterDistance(i,E);f=this.RenderTree(n,p.m_edges,g,h,f,i,j,d,a,p.m_lodOffset,x,y,false);}else{var l=p.m_lodOffset;var k=p.length;for(var m=0;m<k;++m){var o=p[m];if(!o.b2Ignore){if(this.RenderThisInstance(o,p.m_edges,g,h,f,m,d,a,i,0,l,x,y,false)){f++;}}}}this.sweepContainers(e);}else if(this.m_DataSource.GetCurrentNode(e)){var z=this.m_Scene.GetStretchFactor4Mode();this.RenderInstances(c,[z[0],z[1]]);}var q=b.m_Canvas[b.m_nOverlayIndex];this.m_LastCanvasPos=[q.getPixelLeft(),q.getPixelTop(),E];};this.GetHitArray=function(x,y){var h=[];for(var k in this.m_openWin){var c=this.m_openWin[k];if(c&&c.bIsHot){h.push({m_Index:c.index,m_Entity:null,m_Detail:{m_hit:2},m_IO:0});}}return h;};this.onclick=function(e){return this.BaseClick(e);};};VBI.VisualObjects.Container.prototype=VBI.VisualObjects.Base;VBI.VisualObjects.Base2D=function(){this.m_DOMElement=null;this.m_paddingLeft=5;this.m_paddingTop=5;this.m_paddingRight=5;this.m_paddingBottom=5;this.IsValid=function(){if(this.m_DOMElement&&this.m_Scene.m_Div){if(this.m_DOMElement.parentNode==this.m_Scene.m_Div){return true;}}return false;};this.load=function(i,d,c){Object.getPrototypeOf(this).load.call(i,d,c);i.m_Props.push(i.m_Left=new VBI.AttributeProperty(d,'left',null,c));i.m_Props.push(i.m_Top=new VBI.AttributeProperty(d,'top',null,c));i.m_Props.push(i.m_Right=new VBI.AttributeProperty(d,'right',null,c));i.m_Props.push(i.m_Bottom=new VBI.AttributeProperty(d,'bottom',null,c));i.m_Props.push(i.m_Align=new VBI.AttributeProperty(d,'align',null,c,1));};this.clear=function(){Object.getPrototypeOf(Object.getPrototypeOf(this)).clear.call(this);this.m_DOMElement=null;};this.BaseClick=function(e){var s=this.m_Scene;var a;if((a=s.m_Ctx.m_Actions)){var b;if((b=a.findAction("Click",s,this))){s.m_Ctx.FireAction(b,s,this,null,s.GetEventVPCoordsObj(e));e.preventDefault();return true;}}return false;};};VBI.VisualObjects.Base2D.prototype=VBI.VisualObjects.Base;VBI.VisualObjects.Caption=function(){this.m_LineWidth=1;this.load=function(d,c){Object.getPrototypeOf(this).load(this,d,c);this.m_Props.push(this.m_Text=new VBI.AttributeProperty(d,'text',null,c,""));this.m_Props.push(this.m_Design=new VBI.AttributeProperty(d,'design',null,c,"0"));this.m_Props.push(this.m_Level=new VBI.AttributeProperty(d,'level',null,c,0));this.m_Props.push(this.m_Tooltip=new VBI.AttributeProperty(d,'tooltip',null,c,""));};this.Render=function(c,d,a){if(this.IsValid()){return;}var e=this.m_Scene.m_Ctx;var l=this.m_Left.GetValueLong(e);var t=this.m_Top.GetValueLong(e);var r=this.m_Right.GetValueLong(e);var b=this.m_Bottom.GetValueLong(e);var f=this.m_Align.GetValueLong(e);var g=this.m_Text.GetValueString(e);var h=this.m_Design.GetValueLong(e);var i=this.m_Level.GetValueLong(e);var j=this.m_Tooltip.GetValueString(e);this.m_DOMElement=VBI.Utilities.CreateCaption(this.m_ID,g,l+this.m_paddingLeft,t+this.m_paddingTop,r+this.m_paddingLeft,b+this.m_paddingTop,j,h,i,f);this.m_Scene.m_Div.appendChild(this.m_DOMElement);};};VBI.VisualObjects.Caption.prototype=new VBI.VisualObjects.Base2D();VBI.VisualObjects.Label=function(){this.m_LineWidth=1;this.load=function(d,c){Object.getPrototypeOf(this).load(this,d,c);this.m_Props.push(this.m_Text=new VBI.AttributeProperty(d,'text',null,c,""));this.m_Props.push(this.m_Design=new VBI.AttributeProperty(d,'design',null,c,"0"));};this.Render=function(c,d,a){if(this.IsValid()){return;}var e=this.m_Scene.m_Ctx;var l=this.m_Left.GetValueLong(e);var t=this.m_Top.GetValueLong(e);var r=this.m_Right.GetValueLong(e);var f=this.m_Align.GetValueLong(e);var b=this.m_Bottom.GetValueLong(e);var g=this.m_Text.GetValueString(e);this.m_DOMElement=VBI.Utilities.CreateLabel(this.m_ID,g,l+this.m_paddingLeft,t+this.m_paddingTop,r+this.m_paddingLeft,b+this.m_paddingTop,0,f);this.m_Scene.m_Div.appendChild(this.m_DOMElement);};};VBI.VisualObjects.Label.prototype=new VBI.VisualObjects.Base2D();VBI.VisualObjects.Link=function(){this.m_LineWidth=1;this.load=function(d,c){Object.getPrototypeOf(this).load(this,d,c);this.m_Props.push(this.m_Reference=new VBI.AttributeProperty(d,'reference',null,""));this.m_Props.push(this.m_Autoexecute=new VBI.AttributeProperty(d,'autoexecute',null,c,false));this.m_Props.push(this.m_Tooltip=new VBI.AttributeProperty(d,'tooltip',null,c,""));this.m_Props.push(this.m_Text=new VBI.AttributeProperty(d,'text',null,c,""));};this.clear=function(){if(this.m_DOMElement){this.m_DOMElement.onclick=null;}Object.getPrototypeOf(this).clear.call(this);};this.Render=function(c,d,a){if(this.IsValid()){return;}var e=this.m_Scene.m_Ctx;var l=this.m_Left.GetValueLong(e);var t=this.m_Top.GetValueLong(e);var r=this.m_Right.GetValueLong(e);var b=this.m_Bottom.GetValueLong(e);var f=this.m_Align.GetValueLong(e);var g=this.m_Text.GetValueString(e);var h=this.m_Reference.GetValueString(e);var i=this.m_Autoexecute.GetValueBool(e);var j=this.m_Tooltip.GetValueString(e);this.m_DOMElement=VBI.Utilities.CreateLink(this.m_ID,g,l+this.m_paddingLeft,t+this.m_paddingTop,r+this.m_paddingLeft,b+this.m_paddingTop,i?h:null,j,f);this.m_Scene.m_Div.appendChild(this.m_DOMElement);this.m_DOMElement.onclick=this.onclick.bind(this);};this.onclick=function(e){return this.BaseClick(e);};};VBI.VisualObjects.Link.prototype=new VBI.VisualObjects.Base2D();VBI.VisualObjects.Image=function(){this.load=function(d,c){Object.getPrototypeOf(this).load(this,d,c);this.m_Props.push(this.m_Image=new VBI.AttributeProperty(d,'image',null,c));this.m_Props.push(this.m_Tooltip=new VBI.AttributeProperty(d,'tooltip',null,c,""));};this.Render=function(c,d,a){if(this.IsValid()){return;}var e=this.m_Scene.m_Ctx;var l=this.m_Left.GetValueLong(e);var t=this.m_Top.GetValueLong(e);var r=this.m_Right.GetValueLong(e);var b=this.m_Bottom.GetValueLong(e);var f=this.m_Align.GetValueLong(e);var i=this.m_Image.GetValueString(e);var g=this.m_Tooltip.GetValueString(e);var h;if((h=e.GetResources().GetImage(i))){this.m_DOMElement=VBI.Utilities.CreateImage(this.m_ID,h,l+this.m_paddingLeft,t+this.m_paddingTop,r+this.m_paddingLeft,b+this.m_paddingTop,g,f);this.m_Scene.m_Div.appendChild(this.m_DOMElement);}};};VBI.VisualObjects.Image.prototype=new VBI.VisualObjects.Base2D();VBI.VisualObjects.Button=function(){this.load=function(d,c){Object.getPrototypeOf(this).load(this,d,c);this.m_Props.push(this.m_Tooltip=new VBI.AttributeProperty(d,'tooltip',null,c,""));this.m_Props.push(this.m_Text=new VBI.AttributeProperty(d,'text',null,c,""));};this.clear=function(){if(this.m_DOMElement){this.m_DOMElement.onclick=null;}Object.getPrototypeOf(this).clear.call(this);};this.Render=function(c,d,a){if(this.IsValid()){return;}var e=this.m_Scene.m_Ctx;var l=this.m_Left.GetValueLong(e);var t=this.m_Top.GetValueLong(e);var r=this.m_Right.GetValueLong(e);var b=this.m_Bottom.GetValueLong(e);var f=this.m_Text.GetValueString(e);var g=this.m_Tooltip.GetValueString(e);this.m_DOMElement=VBI.Utilities.CreateButton(this.m_ID,f,l+this.m_paddingLeft,t+this.m_paddingTop,r+this.m_paddingLeft,b+this.m_paddingTop,g);this.m_Scene.m_Div.appendChild(this.m_DOMElement);this.m_DOMElement.onclick=this.onclick.bind(this);};this.onclick=function(e){return this.BaseClick(e);};};VBI.VisualObjects.Button.prototype=new VBI.VisualObjects.Base2D();VBI.VisualObjects.Dummy=function(){this.load=function(d,c){Object.getPrototypeOf(this).load.call(this,d,c);};this.RenderInstance=function(n,d,x,s,c){};this.Render=function(c,d,a){this.BaseRender(c,d);};this.RenderShadow=function(d,n,c,l,x,y){};};VBI.VisualObjects.Dummy.prototype=VBI.VisualObjects.Base;VBI.VisualObjects.Box3D=function(){this.load=function(d,c){Object.getPrototypeOf(this).load.call(this,d,c);this.m_Props.push(this.m_DataSource=new VBI.NodeProperty(d,'datasource',null,c));this.m_Props.push(this.m_Pos=new VBI.AttributeProperty(d,'pos',this.m_DataSource,c,[0.0,0.0,0.0]));this.m_Props.push(this.m_Scale=new VBI.AttributeProperty(d,'scale',this.m_DataSource,c,[1.0,1.0,1.0]));this.m_Props.push(this.m_Tooltip=new VBI.AttributeProperty(d,'tooltip',this.m_DataSource,c,this.m_defaultTooltip));this.m_Props.push(this.m_Color=new VBI.AttributeProperty(d,'color',this.m_DataSource,c,this.m_defaultColor));this.m_Props.push(this.m_ColorBorder=new VBI.AttributeProperty(d,'colorBorder',this.m_DataSource,c,this.m_defaultColor));this.BaseLoad(d,c,this);};this.RenderInstance=function(n,p,s,c,a,f){if(!s){s=[1.0,1.0,1.0];}if(!c){c="#6f6f7a";}};this.Render=function(c){var s=this.m_Scene;if(!s.m_bMainSceneInitialized){return 0;}var a=s.m_Ctx;var b=0;var n;if((n=this.m_DataSource.GetCurrentNode(a))){b=n.m_dataelements.length;for(var d=0;d<b;++d){this.m_DataSource.Select(d);var h=this.IsHot(d);var S=this.IsSelected(a);var p=this.m_Pos.GetValueVector(a);var e=this.m_Scale.GetValueVector(a);var C=this.m_Color.GetValueColor(a);if(S){C=this.GetSelectColor(a,C);}if(h){C=this.GetHotColor(a,C);}var f=this.m_ColorBorder.GetValueColor(a);if(S){f=this.GetSelectColor(a,f);}if(h){f=this.GetHotColor(a,f);}var F=this.m_FxSize.GetValueBool(a);this.RenderInstance(d,p,e,C,f,F);}}return b;};this.DetailHitTest=function(o,n,a,b){};this.GetHitArray=function(x,y){};};VBI.VisualObjects.Box3D.prototype=VBI.VisualObjects.Base;return v;};
},
	"sap/ui/vbm/lib/sapvoutils.js":function(){
VBI.Utilities.SceneBindDesignSpotBoxSize=function(o){"use strict";var s=this.m_Scene;if(o.m_Design&&(o.m_Hit==VBI.HTBOXHANDLE)&&this.m_Scale.IsChangeable(s.m_Ctx)){if(o.m_Handle>6){return;}var z=s.GetStretchFactor4Mode();var n=o.m_ClientX/z[0];var a=o.m_ClientY/z[0];var b=o.m_DhOrig[0];var m=(b[0]+b[2])/2.0;var w=(b[2]-b[0])/2.0;var h=(b[3]-b[1]);var f=1.0,c=1.0;switch(o.m_Handle){case 1:c=Math.abs(a-b[3])/h;break;case 2:case 5:if(o.m_Handle==2){c=Math.abs(a-b[3])/h;}f=Math.abs(n-m)/w;break;case 0:case 3:if(o.m_Handle==0){c=Math.abs(a-b[3])/h;}f=Math.abs(n-m)/w;break;default:break;}var d=o.m_ScaleOrig.slice(0);d[0]*=f;d[1]*=c;this.m_Scale.SetValueVector(s.m_Ctx,d);}};
VBI.Utilities.SceneBindDesignBoxBoxSize=function(k,o){"use strict";var s=this.m_Scene;if(o.m_Design&&(o.m_Hit==VBI.HTBOXHANDLE)&&this.m_Scale.IsChangeable(s.m_Ctx)){var z=s.GetStretchFactor4Mode();var n=o.m_ClientX/z[0];var a=o.m_ClientY/z[0];var b=o.m_DhOrig[0];var m=(b[0]+b[2])/2.0;var c=(b[1]+b[3])/2.0;var w=(b[2]-b[0])/2.0;var h=(b[3]-b[1])/2.0;var f=1.0,d=1.0;switch(o.m_Handle){case 0:case 2:case 6:case 8:f=Math.abs(n-m)/w;d=Math.abs(a-c)/h;if(k){f=d=Math.max(f,d);}break;case 1:case 7:d=Math.abs(a-c)/h;if(k){f=d;}break;case 3:case 5:f=Math.abs(n-m)/w;if(k){d=f;}break;default:break;}var e=o.m_ScaleOrig.slice(0);e[0]*=f;e[1]*=d;this.m_Scale.SetValueVector(s.m_Ctx,e);}};
VBI.Utilities.SceneBindMeterRadiusDesignBoxSize=function(o){"use strict";var s=this.m_Scene;if(o.m_Design){var c=this.m_Pos.GetValueVector(s.m_Ctx);var a=s.GetPosFromPoint([o.m_ClientX,o.m_ClientY,0]);var r=0;switch(o.m_Handle){case 1:case 7:r=VBI.MathLib.Distance(VBI.MathLib.DegToRad(c),VBI.MathLib.DegToRad([c[0],a[1]]));break;case 3:case 5:r=VBI.MathLib.Distance(VBI.MathLib.DegToRad(c),VBI.MathLib.DegToRad([a[0],c[1]]));break;default:break;}this.m_Radius.SetValueFloat(s.m_Ctx,Math.abs(r));}};
VBI.Utilities.SceneBindRadiusDesignBoxSize=function(o){"use strict";var s=this.m_Scene;if(o.m_Design){var c=this.m_Pos.GetValueVector(s.m_Ctx);var a=s.GetPointFromPos(c);a[0]+=o.m_IO;var r=0;switch(o.m_Handle){case 1:case 7:r=(a[1]-o.m_ClientY);break;case 3:case 5:r=(a[0]-o.m_ClientX);break;default:break;}this.m_Radius.SetValueFloat(s.m_Ctx,Math.abs(r));}};
VBI.Utilities.SceneBindPosArrayDesignBoxSize=function(o){"use strict";var s=this.m_Scene;if(o.m_Design){var p=s.GetPosFromPoint([o.m_ClientX-o.m_IO,o.m_ClientY,0]);var m=Number.MAX_VALUE;var a=-Number.MAX_VALUE;var b=Number.MAX_VALUE;var c=-Number.MAX_VALUE;var d=o.m_PosOrig.slice(0);var n,l=d.length/3,i;for(n=0;n<l;++n){i=n*3;if(m>d[i]){m=d[i];}if(a<d[i]){a=d[i];}if(b>d[i+1]){b=d[i+1];}if(c<d[i+1]){c=d[i+1];}}var e=0,f=1;var g=0,h=1;switch(o.m_Handle){case 0:case 1:if(o.m_Handle==0){e=a;f=(p[0]-a)/(m-a);}g=b;h=(p[1]-b)/(c-b);break;case 2:case 5:if(o.m_Handle==2){g=b;h=(p[1]-b)/(c-b);}e=m;f=(p[0]-m)/(a-m);break;case 6:case 3:if(o.m_Handle==6){g=c;h=(p[1]-c)/(b-c);}e=a;f=(p[0]-a)/(m-a);break;case 8:case 7:if(o.m_Handle==8){e=m;f=(p[0]-m)/(a-m);}g=c;h=(p[1]-c)/(b-c);break;default:break;}for(n=0;n<l;++n){i=n*3;d[i]=e+(d[i]-e)*f;d[i+1]=g+(d[i+1]-g)*h;}this.m_Pos.SetValueVector(s.m_Ctx,d);}};
VBI.Utilities.BackupFont=function(d){"use strict";d.m_BackupFont=[];d.m_BackupFont.m_font=d.m_font=d.font;d.m_BackupFont.m_fillStyle=d.fillStyle;d.m_BackupFont.m_strokeStyle=d.strokeStyle;d.m_BackupFont.m_textAlign=d.textAlign;d.m_BackupFont.m_textBaseline=d.textBaseline;};
VBI.Utilities.RestoreFont=function(d){"use strict";d.m_font=d.font=d.m_BackupFont.m_font;d.fillStyle=d.m_BackupFont.m_fillStyle;d.strokeStyle=d.m_BackupFont.m_strokeStyle;d.textAlign=d.m_BackupFont.m_textAlign;d.textBaseline=d.m_BackupFont.m_textBaseline;};
VBI.Utilities.SetTextAttributes=function(d,n,a,b,c,e){"use strict";if((n!=undefined)&&(d.m_font!=n)){d.m_font=d.font=n;}var C;if(a){C=VBI.Types.string2rgba(a);d.fillStyle=VBI.Utilities.RgbToHex(C[0],C[1],C[2]);}if(b){C=VBI.Types.string2rgba(b);d.strokeStyle=VBI.Utilities.RgbToHex(C[0],C[1],C[2]);}d.textAlign=c;d.textBaseline=e;};
VBI.Utilities.SetFont=function(d,n){"use strict";if((n!=undefined)&&(d.m_font!=n)){d.m_font=d.font=n;}};
VBI.DnDInfo=function(){"use strict";var d={};d.m_datasource=null;d.m_boundtype=null;d.m_type=[];d.clear=function(){for(var n=0;n<d.m_type.length;++n){d.m_type[n].clear();}if(d.m_boundtype){d.m_boundtype.clear();}if(d.m_datasource){d.m_datasource.clear();}d.m_datasource=null;d.m_boundtype=null;d.m_type=[];};d.load=function(a,c,i){if(a){if(jQuery.type(a)=='array'){for(var n=0;n<a.length;++n){if(jQuery.type(a[n])=='object'){if(a[n].datasource){d.m_datasource=new VBI.NodeProperty(a[n],'datasource',i.m_DataSource,c);d.m_boundtype=new VBI.AttributeProperty(a[n],'type',d.m_datasource,c);}else{d.m_type.push(new VBI.AttributeProperty(a[n],'type',null,c));}}}}else if(jQuery.type(a)=='object'){if(a.datasource){d.m_datasource=new VBI.NodeProperty(a,'datasource',i.m_DataSource,c);d.m_boundtype=new VBI.AttributeProperty(a,'type',d.m_datasource,c);}else{d.m_type.push(new VBI.AttributeProperty(a,'type',null,c));}}}};d.getItemArray=function(c){var v=[];var n;if(d.m_datasource){var a=d.m_datasource;var b;if((b=a.GetCurrentNode(c))){for(n=0;n<b.m_dataelements.length;++n){a.Select(n);v.push(d.m_boundtype.GetValueString(c));}}}if(d.m_type.length){for(n=0;n<d.m_type.length;++n){v.push(d.m_type[n].GetValueString(c));}}return v;};return d;};
VBI.NodeProperty=function(d,n,p,c){"use strict";var a=null;if(!(a=d[n])){a=d[n+".bind"];}var b=a.split("::");var e=b[b.length-1].split(".");b.splice(-1,1);b.push(e[0]);e[0]=b.join("::");this.m_NPath=e;this.m_Path=e;this.m_PNP=p;this.m_nCurElement=0;this.m_CurElement=null;this.m_DTN=c.m_DataTypeProvider.FindTypeNodeFromPath(this.m_Path);var t=this;while((t=t.m_PNP)){if(c.m_DataTypeProvider.isParentOf(t.m_DTN,this.m_DTN)){var f,g=t.m_DTN.GetPath();for(f=0;f<g.length;++f){if(this.m_NPath[0]==g[f]){this.m_NPath.splice(0,1);}else{break;}}break;}}this.m_PNP=t;this.NotifyDataChange=function(c){this.m_CurElement=null;this.m_DTN=c.m_DataTypeProvider.FindTypeNodeFromPath(this.m_Path);};this.clear=function(){this.m_PNP=null;this.m_CurElement=null;this.m_DTN=null;this.m_NPath=null;this.m_Path=null;};this.GetCurrentElement=function(c){if(this.m_CurElement){return this.m_CurElement;}var h=this.GetCurrentNode(c);if(!h){return null;}this.m_CurElement=h.m_dataelements[this.m_nCurElement];return(this.m_CurElement);};this.GetIndexedElement=function(c,i){var h=this.GetCurrentNode(c);if(!h){return null;}return h.m_dataelements[i];};this.GetCurrentNode=function(c){var h=null;if(this.m_PNP){var i=this.m_PNP.GetCurrentElement(c);h=i.FindNodeFromPath(this.m_NPath);}else{h=c.m_DataProvider.FindNodeFromPath(this.m_NPath);}return h;};this.Select=function(i){this.m_CurElement=null;this.m_nCurElement=i;};this.SetEditMode=function(c,m){var h;if((h=this.GetCurrentElement(c))){h.m_EditMode=m;}};this.GetEditMode=function(c){var h;if((h=this.GetCurrentElement(c))&&(h.m_EditMode!=undefined)){return h.m_EditMode;}return VBI.EMHandle;};this.IsElementSelected=function(c){var h;if((h=this.GetCurrentElement(c))){return h.IsSelected();}return false;};this.SetSelected=function(c,s){return;};return this;};
VBI.AttributeProperty=function(d,n,p,c,a){"use strict";var v;this.m_DefaultValue=a;if((v=d[n])){this.m_Name=n;this.m_Value=v;}else if((v=d[n+".bind"])){this.m_PNP=p;this.m_Name=n;var b=v.split("::");var e=b[b.length-1].split(".");b.splice(-1,1);b.push(e[0]);e[0]=b.join("::");this.m_RelBind=e;this.m_AbsBind=e;this.m_DTA=c.m_DataTypeProvider.FindTypeAttributeFromPath(this.m_AbsBind);var t=this;while((t=t.m_PNP)){if(c.m_DataTypeProvider.isParentOf(t.m_DTN,this.m_DTA)){var f,g=t.m_DTN.GetPath();for(f=0;f<g.length;++f){if(this.m_RelBind[0]==g[f]){this.m_RelBind.splice(0,1);}else{break;}}break;}}this.m_PNP=t;}this.NotifyDataChange=function(c){if(this.m_AbsBind){this.m_DTA=c.m_DataTypeProvider.FindTypeAttributeFromPath(this.m_AbsBind);}};this.clear=function(){this.m_PNP=null;this.m_DTA=null;this.m_DefaultValue=null;if(this.m_Name){this.m_Name=null;}if(this.m_Value){this.m_Value=null;}if(this.m_PNP){this.m_PNP=null;}if(this.m_RelBind){this.m_RelBind=null;}if(this.m_AbsBind){this.m_AbsBind=null;}};this.IsChangeable=function(c){var h;if((h=this.GetAttributeObject(c))){return h.IsChangeable();}return false;};this.GetAttributeObject=function(c){if(this.m_RelBind){if(this.m_PNP){return this.m_PNP.GetCurrentElement(c).FindAttributeFromPath(this.m_RelBind);}else{return c.m_DataProvider.FindAttributeFromPath(this.m_RelBind);}}return null;};this.GetValueFloat=function(c){if(this.m_Value){return VBI.Types.string2float(this.m_Value);}if(this.m_RelBind){var h;if((h=this.GetAttributeObject(c))){if(h.m_dta.m_Type==VBI.Types.st_float){return h.m_Value;}if(h.m_dta.m_Type==VBI.Types.st_string){return VBI.Types.string2float(h.m_Value);}if(h.m_dta.m_Type==VBI.Types.st_long){return VBI.Types.long2float(h.m_Value);}if(h.m_dta.m_Type==VBI.Types.st_bool){return h.m_Value?1.0:0.0;}}}return this.m_DefaultValue;};this.GetValueString=function(c){if(this.m_Value){return this.m_Value;}if(this.m_RelBind){var h;if((h=this.GetAttributeObject(c))){if(h.m_dta.m_Type==VBI.Types.st_string){return h.m_Value;}else{return h.GetStringValue();}}}return this.m_DefaultValue;};this.GetValueLong=function(c){if(this.m_Value){return VBI.Types.string2long(this.m_Value);}if(this.m_RelBind){var h;if((h=this.GetAttributeObject(c))){if(h.m_dta.m_Type==VBI.Types.st_long){return h.m_Value;}if(h.m_dta.m_Type==VBI.Types.st_bool){return h.m_Value;}if(h.m_dta.m_Type==VBI.Types.st_string){return VBI.Types.string2long(h.m_Value);}if(h.m_dta.m_Type==VBI.Types.st_float){return VBI.Types.float2long(h.m_Value);}}}return this.m_DefaultValue;};this.GetValueBool=function(c){if(this.m_Value){return VBI.Types.string2bool(this.m_Value);}if(this.m_RelBind){var h;if((h=this.GetAttributeObject(c))){if(h.m_dta.m_Type==VBI.Types.st_bool){return h.m_Value;}if(h.m_dta.m_Type==VBI.Types.st_string){return VBI.Types.string2bool(h.m_Value);}}}return this.m_DefaultValue;};this.GetValueVector=function(c){if(this.m_Value){if(typeof(this.m_Value)==="string"){return VBI.Types.string2vector(this.m_Value);}else{return VBI.Types.stringarray2vectorarray(this.m_Value);}}if(this.m_RelBind){var h;if((h=this.GetAttributeObject(c))){if((h.m_dta.m_Type==VBI.Types.st_vector)||(h.m_dta.m_Type==VBI.Types.st_vectorarray)||(h.m_dta.m_Type==VBI.Types.st_vectorarraymulti)){return h.m_Value;}if(h.m_dta.m_Type==VBI.Types.st_string){return VBI.Types.string2vector(h.m_Value);}}}return this.m_DefaultValue;};this.GetValueColor=function(c){var r;if(this.m_Value){r=VBI.Types.string2rgba(this.m_Value);return"rgba("+r[0]+","+r[1]+","+r[2]+","+r[3]+")";}if(this.m_RelBind){var h;if((h=this.GetAttributeObject(c))){if((h.m_dta.m_Type==VBI.Types.st_color)){return h.m_Value;}if(h.m_dta.m_Type==VBI.Types.st_string){r=VBI.Types.string2rgba(h.m_Value);return"rgba("+r[0]+","+r[1]+","+r[2]+","+r[3]+")";}}}return this.m_DefaultValue;};this.SetValueVector=function(c,v){if(this.m_Value){return null;}if(this.m_RelBind){var h;if((h=this.GetAttributeObject(c))){if((h.m_dta.m_Type==VBI.Types.st_vector)||(h.m_dta.m_Type==VBI.Types.st_vectorarray)){h.set(v);}if(h.m_dta.m_Type==VBI.Types.st_string){h.set(VBI.Types.float2string(v));}}}return null;};this.SetValueFloat=function(c,v){if(this.m_Value){return null;}if(this.m_RelBind){var h;if((h=this.GetAttributeObject(c))){if((h.m_dta.m_Type==VBI.Types.st_float)){h.set(v);}else if((h.m_dta.m_Type==VBI.Types.st_long)){h.set(VBI.Types.float2long(v));}else if(h.m_dta.m_Type==VBI.Types.st_string){h.set(VBI.Types.float2string(v));}}}return null;};this.IsBound=function(){return this.m_RelBind?true:false;};return this;};
},
	"sap/ui/vbm/lib/sapwindow.js":function(){
VBI.Windows=function(){"use strict";var w={};w.vbiclass="Windows";w.m_WindowArray=[];w.find=function(n){for(var a=0,l=w.m_WindowArray.length;a<l;++a){if(w.m_WindowArray[a].m_ID==n){return w.m_WindowArray[a];}}return null;};w.clear=function(){for(var n=0;n<w.m_WindowArray.length;++n){w.m_WindowArray[n].clear();}w.m_WindowArray=[];};w.create=function(d,c){var a=null;switch(d.type){case'callout':a=new VBI.CalloutWindow();break;case'legend':a=new VBI.LegendWindow();break;default:a=new VBI.Window();break;}if(a){a.load(d,c);}return a;};w.load=function(d,c){var a,n,l;if(d.Remove){if(jQuery.type(d.Remove)=='object'){if(d.Remove.name){w.Remove(d.Remove.name);}}else if(jQuery.type(d.Remove)=='array'){for(n=0,l=d.Remove.length;n<l;++n){if(d.Remove[n].name){w.Remove(d.Remove[n].name);}}}}if(d.Set){var b;if(jQuery.type(d.Set)=='object'){if(d.Set.name){b=w.find(d.Set.name);if(b){b.load(d.Set.Window,c);return;}else{b=w.create(d.Set.Window,c);w.Add(b);return;}}w.clear();if(d.Set.Window){if(jQuery.type(d.Set.Window)=='object'){b=w.create(d.Set.Window,c);w.Add(b);}else if(jQuery.type(d.Set.Window)=='array'){a=d.Set.Window;for(n=0;n<a.length;++n){b=w.create(a[n],c);w.Add(b);}return;}}}else if(jQuery.type(d.Set)=='array'){a=d.Set;for(n=0;n<a.length;++n){var i=a[n];if(i.name){b=w.find(i.name);if(b){b.load(i.Window,c);}else{b=w.create(i.Window,c);w.Add(b);}}}}}};w.Add=function(a){w.m_WindowArray.push(a);};w.Remove=function(n){var a=null;for(var b=0,l=w.m_WindowArray.length;b<l;++b){if((a=w.m_WindowArray[b]).m_ID==n){a.clear();w.m_WindowArray.splice(b,1);break;}}};w.Awake=function(t){for(var n=0;n<w.m_WindowArray.length;++n){w.m_WindowArray[n].Awake(t);}};w.GetMainWindow=function(){for(var n=0;n<w.m_WindowArray.length;++n){if(w.m_WindowArray[n].m_refParent==null){return w.m_WindowArray[n];}}return null;};w.NotifyDataChange=function(){var a=w.m_WindowArray;for(var n=0;n<a.length;++n){a[n].NotifyDataChange();}return null;};w.NotifyResize=function(){var a=w.m_WindowArray;for(var n=0;n<a.length;++n){a[n].NotifyResize();}return null;};w.NotifySceneMove=function(s){var a=w.m_WindowArray;for(var n=0,l=a.length;n<l;++n){a[n].NotifySceneMove(s);}return null;};w.NotifySceneZoom=function(s){var a=w.m_WindowArray;for(var n=0,l=a.length;n<l;++n){a[n].NotifySceneZoom(s);}return null;};w.Render=function(){var a=w.m_WindowArray;for(var n=0;n<a.length;++n){a[n].Render();}return null;};w.RenderAsync=function(){var a=w.m_WindowArray;for(var n=0;n<a.length;++n){a[n].RenderAsync(true);}return null;};return w;};
VBI.Window=function(){"use strict";this.vbiclass="Window";this.m_ID="";this.m_Caption="";this.m_Type="";this.m_bModal=true;this.m_refScene=null;this.m_refSceneInstance=null;this.m_refParent=null;this.m_Width=null;this.m_Height=null;this.m_Div=null;this.m_Ctx=null;this.BaseLoad=function(i,d,c){if(d.id){i.m_ID=d.id;}if(d.caption){i.m_Caption=d.caption;}if(d.refParent){i.m_refParent=d.refParent;}if(d.modal){i.m_bModal=(d.ref=="true")?true:false;}if(d.width){i.m_Width=parseInt(d.width,10);}if(d.height){i.m_Height=parseInt(d.height,10);}i.m_Ctx=c;if(d.refScene){i.m_refScene=d.refScene;}else if(VBI.m_bTrace){VBI.Trace("Error: no scene assigned to window");}};this.BaseClear=function(){var s=this.GetScene();if(s){s.m_Parent=null;}this.m_refParent=null;this.m_refScene=null;this.m_refSceneInstance=null;this.m_Ctx=null;this.m_Div=null;};this.clear=function(){this.BaseClear();};this.load=function(d,c){this.BaseLoad(this,d,c);};this.GetScene=function(){if(this.m_refSceneInstance){return this.m_refSceneInstance;}this.m_refSceneInstance=(this.m_Ctx&&this.m_Ctx.m_SceneManager)?this.m_Ctx.m_SceneManager.GetSceneByName(this.m_refScene):null;if(this.m_refSceneInstance){this.m_refSceneInstance.m_Parent=this;}return this.m_refSceneInstance;};this.GetHostingScene=function(){if(!this.m_refParent){return null;}var w=this.m_Ctx.m_Windows.find(this.m_refParent);if(w){return w.GetScene();}return null;};this.NotifyDataChange=function(){var s=this.GetScene();if(s){s.NotifyDataChange();}};this.NotifyResize=function(){return;};this.NotifySceneMove=function(s){return;};this.NotifySceneZoom=function(s){return;};this.Render=function(){var s=this.GetScene();if(s){s.Render();}};this.RenderAsync=function(){var s=this.GetScene();if(s){if(s.RenderAsync){s.RenderAsync(true);}else{s.Render();}}};this.Awake=function(t){var s=this.GetScene();if(s){s.Awake(t);}else if(VBI.m_bTrace){VBI.Trace("Error: Awake no scene assigned to window");}};this.Create=function(t){};this.Destroy=function(){};};
VBI.CalloutWindow=function(){"use strict";var c=new VBI.Window();c.m_oCallout=null;c.load=function(d,a){c.BaseLoad(c,d,a);c.m_Pos=new VBI.AttributeProperty(d,'pos',null,a);c.m_OffsetX=new VBI.AttributeProperty(d,'offsetX',null,a,0);c.m_OffsetY=new VBI.AttributeProperty(d,'offsetY',null,a,0);};c.clear=function(){c.UnRegisterEvents();c.Remove();c.BaseClear();c.m_oCallout=null;};c.processclosebuttonclick=function(e){c.m_Ctx.onCloseWindow(c.m_ID,c.m_oCallout.m_Content);c.clear();e.preventDefault();e.stopPropagation();};c.IsValid=function(){return(c.m_oCallout&&c.m_oCallout.m_Div)?true:false;};c.NotifySceneMove=function(s){c.UpdatePosition();};c.NotifySceneZoom=function(s){c.UpdatePosition();};c.CalcDivPosition=function(){if(!c.IsValid()){return undefined;}var p=VBI.m_bIsPhone;if(p){return undefined;}var o=c.m_OffsetX.GetValueLong();var a=c.m_OffsetY.GetValueLong();var b=c.m_Pos.GetValueVector(c.m_Ctx);var h=c.GetHostingScene();var d=h.m_Canvas[h.m_nOverlayIndex];var e=d.getPixelLeft();var f=d.getPixelTop();var E=h.m_Canvas[0].m_nExactLOD;var w=parseInt(Math.pow(2,E)*h.m_nWidthCanvas/h.m_nTilesX*h.m_Proj.m_nXYRatio,10);var n=(h.m_nDivWidth-w)/2;var g=h.m_nDivWidth-n;var t=[];var i,l;var O;if(b.length>5){var j=d.getPixelWidth();var k=d.getPixelHeight();d.setPixelWidth(h.m_nWidthCanvas);d.setPixelHeight(h.m_nHeightCanvas);h.m_ZoomFactors[0]=j/h.m_nWidthCanvas;h.m_ZoomFactors[1]=k/h.m_nHeightCanvas;var m=h.GetNearestPosArray(b);var q=h.GetPointFromPos([m.m_MinX,m.m_MaxY,0.0],false);var r=h.GetPointFromPos([m.m_MaxX,m.m_MinY,0.0],false);O=h.GetInstanceOffsets([q[0],q[1],r[0],r[1]]);var s=O.length?h.GetPointArrayFromPosArray(m,false):null;var u;var v=h.GetInternalDivClientRect();var x=v.width/h.m_ZoomFactors[0];var y=v.height/h.m_ZoomFactors[1];var P=e/h.m_ZoomFactors[0];var z=f/h.m_ZoomFactors[1];var A=[-P,-z,-P+x,-z+y];for(i=0,l=O.length;i<l;++i){u=VBI.Utilities.GetMidpointsForLine(s,O[i],A);if(u.aPos.length>u.max){t=u.aPos[u.max];t[0]*=h.m_ZoomFactors[0];t[1]*=h.m_ZoomFactors[1];break;}}d.setPixelWidth(j);d.setPixelHeight(k);}else{t=h.GetPointFromPos(b,true);if(t[0]+e<n){while(t[0]+e<n){t[0]+=w;}}else if(t[0]+e>g){while(t[0]+e>g){t[0]-=w;}}}if(t.length>1){t[0]+=e;t[1]+=f;t[0]+=o;t[1]+=a;var B=c.m_oCallout.GetAnchorPoint();t[0]-=B[0];t[1]-=B[1];}else{t.push(-1000,-1000);}return t;};c.UpdatePosition=function(){if(!c.IsValid()){return;}var p=c.CalcDivPosition();if(p){c.m_oCallout.m_Div.style.left=Math.round(p[0])+"px";c.m_oCallout.m_Div.style.top=Math.round(p[1])+"px";}else{c.m_oCallout.m_Div.style.top="";c.m_oCallout.m_Div.style.left="0px";c.m_oCallout.m_Div.style.bottom="0px";}c.m_oCallout.m_Div.style.visibility='visible';};c.Create=function(t){if(c.m_refParent&&!c.m_oCallout){var h=c.GetHostingScene();if(h){c.m_oCallout=VBI.Utilities.CreateDetail(t+"-"+c.m_ID,0,0,c.m_Width,c.m_Height,c.m_Caption,5);c.m_oCallout.m_Div.style.visibility='hidden';c.RegisterEvents();h.m_WindowLayerDiv.appendChild(c.m_oCallout.m_Div);c.m_Ctx.onOpenWindow(c.m_ID,c.m_oCallout.m_Content);c.UpdatePosition();}}};c.RegisterEvents=function(){var f=c.processclosebuttonclick.bind(c);c.m_oCallout.m_CloseButton.onclick=f;c.m_oCallout.m_CloseButton.ontouchend=f;};c.UnRegisterEvents=function(){if(!c.m_oCallout||!c.m_oCallout.m_CloseButton){return;}c.m_oCallout.m_CloseButton.onclick=null;c.m_oCallout.m_CloseButton.ontouchend=null;};c.Remove=function(){var a=c.m_oCallout;if(!a||!a.m_Div){return;}var b=a.m_Div;while(b.firstChild){b.removeChild(b.firstChild);}if(b.parentElement){b.parentElement.removeChild(b);}c.m_oCallout=null;};c.Awake=function(t){if(this.m_refParent){this.Create(t);}var s=this.GetScene();if(s){s.m_Div=c.m_oCallout.m_Content;s.Awake(t);}else if(VBI.m_bTrace){VBI.Trace("Error: Awake no scene assigned to window");}};return c;};
VBI.LegendWindow=function(){"use strict";var c=new VBI.Window();c.m_oLegend=null;c.m_Props=[];c.m_Data=[];c.m_bRenew=false;c.m_Position=[];c.m_bCreated=false;c.load=function(d,a){c.BaseLoad(c,d,a);c.m_Props.push(c.m_DataSource=new VBI.NodeProperty(d,'datasource',null,a));c.m_Props.push(c.m_Colors=new VBI.AttributeProperty(d,'colors',c.m_DataSource,a));c.m_Props.push(c.m_Images=new VBI.AttributeProperty(d,'images',c.m_DataSource,a));c.m_Props.push(c.m_Texts=new VBI.AttributeProperty(d,'texts',c.m_DataSource,a));c.m_Props.push(c.m_Tooltips=new VBI.AttributeProperty(d,'tooltips',c.m_DataSource,a));c.m_Position=[];if(d.top&&d.right){c.m_Position.push(parseInt(d.right,10));c.m_Position.push(parseInt(d.top,10));}};c.clear=function(){c.UnRegisterEvents();c.Remove();c.BaseClear();c.m_oLegend=null;if(c.m_Props){for(var n=0;n<c.m_Props.length;++n){c.m_Props[n].clear();}c.m_Props=[];}c.m_Data=[];};c.invalidate=function(){c.m_bRenew=true;};c.IsValid=function(){return(c.m_oLegend&&c.m_oLegend.m_Div)?true:false;};c.NotifySceneMove=function(s){};c.NotifySceneZoom=function(s){};c.LegendChanged=function(){var n=c.m_DataSource.GetCurrentNode(c.m_Ctx);if(n){var l=n.m_dataelements.length;if(l!=c.m_Data.length){return true;}for(var a=0;a<l;++a){c.m_DataSource.Select(a);var t=c.m_Texts.GetValueString(c.m_Ctx);if(t!=c.m_Data[a].text){return true;}if(c.m_Data[a].type==1){if(c.m_Data[a].value!=c.m_Images.GetValueString(c.m_Ctx)){return true;}}else if(c.m_Data[a].type==2){if(c.m_Data[a].value!=c.m_Colors.GetValueColor(c.m_Ctx)){return true;}}}}else{return true;}return false;};c.ApplyData=function(){var n=c.m_DataSource.GetCurrentNode(c.m_Ctx);if(n){var l=n.m_dataelements.length;for(var a=0;a<l;++a){var b;var i;var o={};c.m_DataSource.Select(a);o.text=c.m_Texts.GetValueString(c.m_Ctx);if(o.text){o.type=0;i=c.m_Images.GetValueString(c.m_Ctx);if(i){o.type=1;o.value=i;}else{b=c.m_Colors.GetValueColor(c.m_Ctx);if(b){o.type=2;o.value=b;}}c.m_Data.push(o);}}}};c.NotifyResize=function(){if(c.m_bCreated){c.calcMaxHeight();}};c.NotifyDataChange=function(){if(c.m_Props){for(var n=0,l=c.m_Props.length;n<l;++n){c.m_Props[n].NotifyDataChange(c.m_Ctx);}}if(c.LegendChanged()){c.m_Data=[];if(c.m_oLegend&&c.m_oLegend.m_Table){while(c.m_oLegend.m_Table.rows.length>0){c.m_oLegend.m_Table.deleteRow(-1);}c.ApplyData();c.FillContent();c.calcMaxHeight();}}};c.Create=function(t){var u=(c.m_oLegend&&!c.m_oLegend.m_Div.parentNode);if(c.m_bRenew){c.m_Data=[];if(c.m_oLegend&&c.m_oLegend.m_Table){while(c.m_oLegend.m_Table.rows.length>0){c.m_oLegend.m_Table.deleteRow(-1);}c.ApplyData();c.FillContent();}c.m_bRenew=false;}else if(c.m_refParent&&!c.m_oLegend||u){var h=c.GetHostingScene();if(h){var C=(this.m_Ctx.m_Actions.findAction("Click",h,c.m_ID))?true:false;c.m_oLegend=VBI.Utilities.CreateLegend(t+"-"+c.m_ID,0,c.m_Caption,5,C);if(!u){c.ApplyData();}c.FillContent();c.m_Expanded=true;c.RegisterEvents();c.m_oLegend.m_Div=h.m_LegendLayerDiv.appendChild(c.m_oLegend.m_Div);if(c.m_Position.length==2){if(!isNaN(c.m_Position[0])){c.m_oLegend.m_Div.style.right=c.m_Position[0]+"px";c.m_oLegend.m_Div.style.left='';}if(!isNaN(c.m_Position[1])){c.m_oLegend.m_Div.style.top=c.m_Position[1]+"px";}}c.calcMaxHeight();}}c.m_bCreated=true;};c.getId=function(a,b){return c.m_oLegend.m_Table.id+'-'+b+'-'+a;};c.FillContent=function(){if(!c.m_Data.length){return;}for(var n=0;n<c.m_Data.length;++n){var r=c.m_oLegend.m_Table.insertRow(-1);r.id=c.getId(n,'content-tablerow');var a=r.insertCell(0);var o=c.m_Data[n];if(o.type==2){var b=VBI.Utilities.CreateGeoSceneDivCSS(c.getId(n,'content-celldiv'),'vbi-legend-content-celldiv-square');b.style.backgroundColor=o.value;a.appendChild(b);}else if(o.type==1){var i=c.m_Ctx.GetResources().GetImage(o.value,null,null,c.invalidate.bind());if(i){var d=i.cloneNode(true);d.className='vbi-legend-content-celldiv';d.id=c.getId(n,'content-celldiv');a.appendChild(d);}}else{a.className="vbi-legend-content-celltext-group";a.colSpan=2;a.innerHTML=jQuery.sap.encodeHTML(o.text);}if(o.type>0){var e=r.insertCell(1);e.className="vbi-legend-content-celltext";e.id=c.getId(n,'content-celltext');e.innerHTML=jQuery.sap.encodeHTML(o.text);}}};c.processtouchend=function(e){document.removeEventListener('touchend',c.processtouchend,true);document.removeEventListener('touchmove',c.processtouchmove,true);};c.processmouseup=function(e){document.removeEventListener('mouseup',c.processmouseup,true);document.removeEventListener('mousemove',c.processmousemove,true);};c.movelegend=function(p){var n=p.slice(0);var h=c.GetHostingScene();if(n[0]<h.m_Div.clientLeft){n[0]=h.m_Div.clientLeft;}if(n[0]+c.m_oLegend.m_Div.clientWidth>h.m_Div.clientLeft+h.m_Div.clientWidth){n[0]=h.m_Div.clientLeft+h.m_Div.clientWidth-c.m_oLegend.m_Div.clientWidth;}if(n[1]<h.m_Div.clientTop){n[1]=h.m_Div.clientTop;}if(n[1]+c.m_oLegend.m_Header.clientHeight>h.m_Div.clientTop+h.m_Div.clientHeight){n[1]=h.m_Div.clientTop+h.m_Div.clientHeight-c.m_oLegend.m_Header.clientHeight;}jQuery(c.m_oLegend.m_Div).css('top',n[1]+'px');jQuery(c.m_oLegend.m_Div).css('right',h.m_Div.clientWidth-c.m_oLegend.m_Div.clientWidth-n[0]+'px');jQuery(c.m_oLegend.m_Div).css('left','');c.calcMaxHeight();};c.processtouchmove=function(e){var t=e.changedTouches[0];var x=parseInt(t.pageX,10);var y=parseInt(t.pageY,10);var n=[x-c.m_offset[0],y-c.m_offset[1]];c.movelegend(n);};c.processmousemove=function(e){if(e.which==1){var n=[e.pageX-c.m_offset[0],e.pageY-c.m_offset[1]];c.movelegend(n);}};c.processmousedragstart=function(e){if(e.which==1){c.m_offset=[e.pageX-c.m_oLegend.m_Div.offsetLeft,e.pageY-c.m_oLegend.m_Div.offsetTop];document.addEventListener('mouseup',c.processmouseup,true);document.addEventListener('mousemove',c.processmousemove,true);e.preventDefault();e.stopPropagation();}};c.processtouchdragstart=function(e){var t=e.changedTouches[0];var s=parseInt(t.pageX,10);var a=parseInt(t.pageY,10);c.m_offset=[s-c.m_oLegend.m_Div.offsetLeft,a-c.m_oLegend.m_Div.offsetTop];document.addEventListener('touchend',c.processtouchend,true);document.addEventListener('touchmove',c.processtouchmove,true);e.preventDefault();e.stopPropagation();};c.collapse=function(e){if(c.m_Expanded){c.m_oLegend.m_ButtonCol.style.visibility='hidden';c.m_oLegend.m_ButtonExp.style.visibility='';c.m_oLegend.m_Content.style.display='none';c.m_Expanded=false;}};c.calcMaxHeight=function(){var s=c.GetHostingScene().m_Div.clientHeight;if(s){var l=c.m_oLegend.m_Header.clientHeight;var a=parseInt(c.m_oLegend.m_Div.style.top,10);var y=a+l;var d=s-y;c.m_oLegend.m_Content.style.maxHeight=d+"px";}};c.expand=function(e){if(!c.m_Expanded){c.m_oLegend.m_ButtonCol.style.visibility='';c.m_oLegend.m_ButtonExp.style.visibility='hidden';c.m_oLegend.m_Content.style.display='';c.m_Expanded=true;}};c.clickTable=function(e){var s=e.target||e.srcElement;var r;var m=s.id.match(/\d+/g);if(m&&m.length){r=m[m.length-1];}else{m=s.parentNode.id.match(/\d+/g);if(m&&m.length){r=m[m.length-1];}}if(r){var h=c.GetHostingScene();var p={row:r,ctrlKey:e.ctrlKey,shiftKey:e.shiftKey,metaKey:e.metaKey,altKey:e.altKey};var a=null,b=this.m_Ctx.m_Actions;if(h&&b){a=this.m_Ctx.m_Actions.findAction("Click",h,c.m_ID);}if(a){this.m_Ctx.FireAction(a,h.m_ID,a.m_refVO,null,p);}}};c.RegisterEvents=function(){var f=c.processmousedragstart.bind(c);c.m_oLegend.m_Header.onmousedown=f;var a=c.processtouchdragstart.bind(c);c.m_oLegend.m_Header.ontouchstart=a;var b=c.collapse.bind(c);c.m_oLegend.m_ButtonCol.onclick=b;var d=c.expand.bind(c);c.m_oLegend.m_ButtonExp.onclick=d;var e=c.clickTable.bind(c);c.m_oLegend.m_Table.onclick=e;c.m_oLegend.m_Header.style.cursor=c.m_oLegend.m_Table.style.cursor='pointer';};c.UnRegisterEvents=function(){if(!c.m_oLegend){return;}if(c.m_oLegend.m_Header){c.m_oLegend.m_Header.onmousedown=null;c.m_oLegend.m_Header.ontouchstart=null;}if(c.m_oLegend.m_ButtonCol){c.m_oLegend.m_ButtonCol.onclick=null;}if(c.m_oLegend.m_ButtonExp){c.m_oLegend.m_ButtonExp.onclick=null;}if(c.m_oLegend.m_Table){c.m_oLegend.m_Table.onclick=null;}};c.Remove=function(){var a=c.m_oLegend;if(!a||!a.m_Div){return;}var b=a.m_Div;while(b.firstChild){b.removeChild(b.firstChild);}if(b.parentElement){b.parentElement.removeChild(b);}c.m_oLegend=null;};c.Awake=function(t){if(c.m_refParent){c.Create(t);}var s=this.GetScene();if(s){s.Awake(t);}else if(VBI.m_bTrace){VBI.Trace("Error: Awake no scene assigned to window");}};return c;};
},
	"sap/ui/vbm/lib/sapscene.js":function(){VBI.InputModeDefault=0;VBI.InputModeTrackObject=1;VBI.InputModeTrackMap=2;VBI.InputModeTrackDesign=3;VBI.InputModeRectSelect=4;VBI.InputModeLassoSelect=5;VBI.InputModeRectZoom=6;
VBI.SceneManager=function(){"use strict";var s={};s.vbiclass="SceneManager";s.m_SceneArray=[];s.find=function(n){for(var a=0;a<s.m_SceneArray.length;++a){if(s.m_SceneArray[a].m_ID==n){return s.m_SceneArray[a];}}return null;};s.clear=function(){for(var n=0;n<s.m_SceneArray.length;++n){s.m_SceneArray[n].clear();}s.m_SceneArray=[];};s.load=function(d,c){if(d.Set){s.loadScenes(d.Set,false,d,c);}if(d.Merge){s.loadScenes(d.Merge,true,d,c);}};s.loadScenes=function(a,i,d,c){if(jQuery.type(a)=='array'){for(var n=0;n<a.length;++n){s.loadScene(a[n],i,d,c);}}else{s.loadScene(a,i,d,c);}};s.loadScene=function(m,i,d,c){var a;var r=false;if(m.name){a=s.find(m.name);if(a){if(!i){a.clear();}if(m.SceneGeo){r=a.load(m.SceneGeo,c,i);}else if(m.Scene3D){r=a.load(m.Scene3D,c,i);}else{r=a.load(m.Scene,c,i);}if(r){a.ReAwake();}return;}}else if(!i){s.clear();}if(m.SceneGeo){s.loadNewScene(m.SceneGeo,'geo',c);}if(m.Scene3D){s.loadNewScene(m.Scene3D,'3d',c);}if(m.Scene){s.loadNewScene(m.Scene,'default',c);}};s.loadNewScene=function(a,b,c){var d=null;if(jQuery.type(a)=='object'){if(b=='geo'){d=new VBI.GeoScene(null,null,null);}else if(b=='3d'){d=new VBI.Scene3D(null);}else{d=new VBI.Scene(null,null,null);}d.load(a,c);s.Add(d);}else if(jQuery.type(a)=='array'){for(var n=0;n<a.length;++n){d=null;if(b=='geo'){d=new VBI.GeoScene(null,null,null);}else if(b=='3d'){d=new VBI.Scene3D(null);}else{d=new VBI.Scene(null,null,null);}d.load(a[n],c);s.Add(d);}}};s.Add=function(a){s.m_SceneArray.push(a);};s.GetScene=function(t){for(var i=0;i<s.m_SceneArray.length;++i){if(s.m_SceneArray[i].m_TargetName==t){return s.m_SceneArray[i];}}return null;};s.GetSceneByName=function(n){for(var i=0;i<s.m_SceneArray.length;++i){if(s.m_SceneArray[i].m_ID==n){return s.m_SceneArray[i];}}return null;};return s;};
VBI.Scene=function(t){"use strict";var s={};s.vbiclass="Scene";s.m_TargetName=t;s.m_EvtCont=new VBI.Events();s.m_ID="";s.m_Ctx=null;s.m_Div=null;s.m_Parent=null;s.m_CaptureVO=null;s.m_DesignVO=null;s.m_VOS=[];s.m_Events=null;s.m_Proj=null;s.m_LastDefinedCenterPos=s.m_LastZoomArea=undefined;s.m_HotItem={m_VO:null,m_Index:null,m_Design:null,m_HitObj:null};s.m_DragInfo=null;s.m_Target=t;s.m_KeysDown=[];s.m_KeysSkipUp=[];s.m_KeysSkipPress=[];s.LoadSingleVO=function(e,v,c,I){if(jQuery.type(e)=='object'){var a=null;if(s.vbiclass=="3DScene"){a=v.Factory3D.CreateInstance(e.type);}else{a=v.Factory.CreateInstance(e.type);}a.m_Scene=s;a.load(e,c);if(I){var n=a.m_ID;for(var i=s.m_VOS.length;i--;){if(s.m_VOS[i].m_ID==n){s.m_VOS[i]=a;return;}}}s.m_VOS.push(a);}};s.BaseLoad=function(d,c,i){if(!i){VBI.RegisterKeyboardHook();s.m_Ctx=c;if(d.id){s.m_ID=d.id;}}if(d.VO){var v=new VBI.VisualObjects();if(jQuery.type(d.VO)=='array'){for(var n=0;n<d.VO.length;++n){s.LoadSingleVO(d.VO[n],v,c,i);}}else{s.LoadSingleVO(d.VO,v,c,i);}}};s.BaseClear=function(){for(var n=0,a=s.m_VOS.length;n<a;++n){s.m_VOS[n].clear();}s.m_VOS=[];s.m_Ctx=null;s.m_CaptureVO=null;s.m_DesignVO=null;if(s.m_Parent){s.m_Parent.m_refSceneInstance=null;}s.m_HotItem=null;if(s.m_Events){s.m_Events.clear();s.m_Events=null;}VBI.UnRegisterKeyboardHook();};s.BaseGetVO=function(i){for(var n=0,a=s.m_VOS.length;n<a;++n){if(s.m_VOS[n].m_ID==i){return s.m_VOS[n];}}return null;};s.load=function(d,c,i){s.BaseLoad(d,c,i);return false;};s.clear=function(){s.BaseClear();s.m_Div=null;};s.VerifyHotItem=function(v,B){var h=s.m_HotItem;if((B!=h.m_Index)&&(v==h.m_VO)){var r=v.m_BBRefs[B];if((h.cI==r.cI)&&(h.nI==r.i)){h.m_Index=B;}}s.m_LastHotItem=undefined;};s.CheckHotItem=function(){if(this.m_LastHotItem){var r=this.m_LastHotItem;var I=(r.cI!=undefined)?s.m_PreassembledData.clust[r.cI]:s.m_PreassembledData.base[s.m_LastHotItem.m_VO];if(I.m_nRecalcs!=r.recalcs){s.InternalSetHotItem(null,null,true);this.m_LastHotItem=undefined;}}};s.SetLastHotItem=function(h){if(h.m_VO&&h.m_VO.m_BBRefs!=undefined){var r=h.m_VO.m_BBRefs[h.m_Index];var I=(r.cI!=undefined)?s.m_PreassembledData.clust[r.cI]:s.m_PreassembledData.base[h.m_VO.m_nPreDataIndex];s.m_LastHotItem={cI:r.cI,i:r.i,m_VO:h.m_VO.m_nPreDataIndex,recalcs:I.m_nRecalcs};}};s.InvalidateInvisibleHots=function(){if(this.m_LastHotItem!=undefined){var r=this.m_LastHotItem;var I=(r.cI!=undefined)?s.m_PreassembledData.clust[r.cI]:s.m_PreassembledData.base[s.m_LastHotItem.m_VO];if(I[r.i]!=undefined){I[r.i].h=false;s.InternalSetHotItem(null,null,true);}this.m_LastHotItem=undefined;}};s.InternalSetHotItem=function(v,h,u){var a=s.m_HotItem;var m=false;var o=a.m_Index;var b=a.m_VO;if(h){if(a.m_Index!=h.m_Index){a.m_Index=h.m_Index;m=true;}if(a.m_Design!=h.m_Design){a.m_Design=h.m_Design;m=true;}if(a.m_Entity!=h.m_Entity){a.m_Entity=h.m_Entity;m=true;}}else if(a.m_Entity||a.m_Detail){m=true;a.m_Entity=null;a.m_Detail=null;}if(a.m_VO!=v){a.m_VO=v;m=true;}if(!m){var c;if(h&&(c=a.m_HitObj)){if(!jQuery.sap.equal(c,h,2)){m=true;}}else if(h!=null||a.m_HitObj!=null){m=true;}}a.m_HitObj=h;if(m){if(b&&!u){b.InternalChangeHotItem(o,false,a);}if(v){v.InternalChangeHotItem(a.m_Index,true,a);}s.RenderAsync(false);}return m;};s.InternalRenderVisualObjects=function(c,a){var b=Date.now();var v=s.m_VOS;VBI.Utilities.BackupFont(a);for(var n=0;n<s.m_VOS.length;++n){v[n].Render(c,a);}VBI.Utilities.RestoreFont(a);s.m_nLastRenderingTime=Date.now()-b;};s.Render=function(){};s.Awake=function(t){s.InternalRenderVisualObjects(null,s.m_Ctx);};s.NotifyDataChange=function(){for(var n=0;n<s.m_VOS.length;++n){s.m_VOS[n].NotifyDataChange(s.m_Ctx);}s.m_nDataVersion++;};s.GetPointArrayFromPosArray=function(p,a){return p;};s.GetPosFromPoint=function(p){return p;};s.GetPointFromPos=function(p,a,i){return s.GetPointArrayFromPosArray(p,a,i);};s.GetInternalDivClientRect=function(){var r=s.m_Div.getBoundingClientRect();if(this.m_Ctx.moThumbnail&&this.m_Ctx.moThumbnail.nOrgWidth&&this.m_Ctx.moThumbnail.nOrgHeight){return{left:r.left,top:r.top,width:s.m_Ctx.moThumbnail.nOrgWidth,height:s.m_Ctx.moThumbnail.nOrgHeight,right:r.left+s.m_Ctx.moThumbnail.nOrgWidth,bottom:r.top+s.m_Ctx.moThumbnail.nOrgHeight};}return r;};s.GetEventVPCoords=function(e){if(!e){return[0,0];}var r=s.GetInternalDivClientRect();if(VBI.m_bIsRtl){return[r.right-e.clientX,e.clientY-r.top];}else{return[e.clientX-r.left,e.clientY-r.top];}};s.GetEventVPCoordsObj=function(e){var p=s.GetEventVPCoords(e);return{x:p[0].toString(),y:p[1].toString()};};s.GetEventVPCoordsObjWithScene=function(e){var p=s.GetEventVPCoords(e);return{x:p[0].toString(),y:p[1].toString(),scene:s.m_ID};};s.GetEventDropObjWithScene=function(e){return{strSource:s.m_DragInfo.strScene+"|"+s.m_DragInfo.strID+"|"+s.m_DragInfo.strInstance,scene:s.m_ID};};s.DispatchEvent=function(e,a){if(VBI.m_bTrace){VBI.Trace("DispatchEvent "+e.type+" as "+a+" mode:"+s.m_nInputMode+(s.m_Gesture?" gesture active":""));}if(s.m_nInputMode==VBI.InputModeTrackMap){return false;}var f,b=e.type;if(a){e.m_evName=b=a;}e.m_Scene=s;if(e.offsetX==undefined||e.offsetY==undefined){var r;if(e.clientX!==undefined&&e.clientY!==undefined){r=e.target.getBoundingClientRect();e.offsetX=e.clientX-r.left;e.offsetY=e.clientY-r.top;}else if(e.changedTouches!==undefined&&(e.changedTouches.length>0)){r=e.target.getBoundingClientRect();e.clientX=e.changedTouches[0].clientX;e.clientY=e.changedTouches[0].clientY;e.offsetX=e.clientX-r.left;e.offsetY=e.clientY-r.top;}}if(e.shiftKey==undefined){e.shiftKey=VBI.m_shiftKey;}if(e.ctrlKey==undefined){e.ctrlKey=VBI.m_ctrlKey;}if(s.m_DesignVO){if(VBI.m_bTrace){VBI.Trace("DispatchEvent to Design VO");}if((f=s.m_DesignVO["on"+b])&&typeof(f)=='function'){if(f.call(s.m_DesignVO,e)){return true;}}}if(s.m_CaptureVO){if((f=s.m_CaptureVO["on"+b])&&typeof(f)=='function'){if(f.call(s.m_CaptureVO,e)){return true;}}}var c=s.m_Ctx.m_Control;if(b.indexOf("click")!=-1&&(c instanceof sap.ui.vbm.GeoMap)&&c.getEnableOverlappingTest()){e.hitTests=[];for(var i=0;i<s.m_VOS.length;++i){if((f=s.m_VOS[i]["on"+b])&&typeof(f)=='function'){f.call(s.m_VOS[i],e);}}if(e.hitTests.length>1){e.hitTests=e.hitTests.filter(function(h){var v=c.getAggregatorContainer(h.m_Vo.m_ID);var d=(h.m_Vo.m_ID==="Region"&&c instanceof sap.ui.vbm.AnalyticMap);switch(b){case"sapclick":if(v){return v.isSubscribed("click",h.m_Index)||v.isSelectable();}else if(d){return c.hasListeners("regionClick")||c.isRegionSubscribed("click",h.m_Entity);}break;case"sapsecclick":if(v){return v.isSubscribed("contextMenu",h.m_Index);}else if(d){return c.hasListeners("regionContextMenu")||c.isRegionSubscribed("contextMenu",h.m_Entity);}break;}return false;});if(e.hitTests.length>1){s.showHitMenu(e,e.hitTests);delete e.hitTests;e.preventDefault();return true;}}if(e.hitTests.length>0){e.hitCached=e.hitTests[0];var o=e.hitCached.m_Vo;delete e.hitTests;return o["on"+b].call(o,e);}}else{for(var i=s.m_VOS.length-1;i>=0;--i){if((f=s.m_VOS[i]["on"+b])&&typeof(f)=='function'){if(f.call(s.m_VOS[i],e)){return true;}}}}return false;};return s;};
VBI.Scene3D=function(t){"use strict";var s=new VBI.Scene(t);s.vbiclass="3DScene";s.m_DivCopyright=null;s.m_bMainSceneInitialized=false;s.m_Events=null;s.m_Canvas=[];s.m_nMaxCanvasDimension=(VBI.m_bIsMobile?6144:8192);s.clear=function(){s.BaseClear();s.clearCanvases();s.m_TargetName=null;s.m_Proj=null;s.m_DivCopyright=null;s.m_Target=null;};s.clearCanvas=function(n){s.m_Canvas[n].m_Scene=null;s.m_Canvas[n]=null;};s.clearCanvases=function(){for(var n=0,a=s.m_Canvas.length;n<a;++n){s.clearCanvas(n);}s.m_Canvas=[];};s.Init=function(){};s.InitializeCanvas=function(c){c.m_Scene=s;c.m_nCurrentX=undefined;c.m_nCurrentY=undefined;c.m_bInvalid=false;if(!c.m_bNotInDOM){s.m_Div.appendChild(c);}};s.CreateCanvases=function(){s.m_Canvas.push(VBI.Utilities.Create3DSceneCanvas("layer1",s.m_nWidthCanvas,s.m_nHeightCanvas,2));for(var n=0;n<s.m_Canvas.length;++n){s.InitializeCanvas(s.m_Canvas[n]);}};s.Awake=function(t){if(!(s.m_Target=VBI.Utilities.GetDOMElement(t))){s.m_Target=VBI.Utilities.CreateDOMElement(t,"1px","1px");}if(s.m_Div){if(s.m_Div.parentNode==s.m_Target){return;}s.m_Target.appendChild(s.m_Div);return;}s.m_TargetName=t;s.m_Div=VBI.Utilities.Create3DSceneDiv(t+"-3Dscene");s.m_Target.appendChild(s.m_Div);s.DoAwake(t);};s.DoAwake=function(t){s.CalculateCanvasDimensions();s.CreateCanvases();s.Init();
// // append copyright
// scene.AddCopyright();
var c=s.m_Canvas[0];s.m_Events=new VBI.SceneEvent(this,c);};s.CalculateCanvasDimensions=function(){var n=s.m_Target.offsetWidth;var r=s.m_Div.getBoundingClientRect();var d=r.width?r.width:s.m_Div.clientWidth;var a=r.height?r.height:s.m_Div.clientHeight;if((d==s.m_nDivWidth)&&(a==s.m_nDivHeight)){return;}if(VBI.m_bTrace){VBI.Trace("Calculating Canvas Dimensions to "+d+","+a+", Dummy:"+n);}s.m_nDivWidth=d;s.m_nDivHeight=a;s.m_nWidthCanvas=d;s.m_nHeightCanvas=a;};s.Render=function(){var v=null;var c=0;for(var i=s.m_VOS.length;i--;){v=s.m_VOS[i];c+=v.Render(s.m_Canvas[0]);}};if(t){s.Awake(t);}return s;};
VBI.GeoScene=function(t,c,g){"use strict";var s=new VBI.Scene(t);s.vbiclass="GeoScene";s.m_RefMapLayerStack="";s.m_DivCopyright=null;s.m_Canvas=[];s.m_ZoomFactors=[1.0,1.0];s.m_StretchFactors=[1.0,1.0];s.m_MapManager=c;s.m_MapLayerStack=g;s.m_nMaxCanvasDimension=(VBI.m_bIsMobile?6144:8192);s.Click=null;s.m_nOverlayIndex=2;s.m_nLabelIndex=3;s.m_nNonDomIndex=4;s.m_nTapCount=0;s.GetHomeLocation=null;s.m_Touches=[];s.m_currentMouseX=0;s.m_currentMouseY=0;s.m_oldMouseX=0;s.m_oldMouseY=0;s.m_currentMouseDownX=0;s.m_currentTouchCount=0;s.m_currentMouseDownY=0;s.m_midPointX=0;s.m_midPointY=0;s.m_currentTouchDistance=0;s.m_nInputMode=VBI.InputModeDefault;s.m_AnimZoomTimer=null;s.m_startPointLonLat=[0.0,0.0];s.m_startLOD=0;s.m_bNavControlVisible=true;s.m_NavControl=null;s.m_RenderRequestID=0;s.m_SuppressedNavigation={zoom:false,move:false};s.m_bScaleVisible=true;s.m_Scale=null;s.m_nInitialTrackingMode=VBI.InputModeDefault;s.m_nCanvasXOversize=2.2;s.m_nCanvasYOversize=2.2;s.m_nCanvasStdXPos=s.m_nCanvasXOversize/4;s.m_nCanvasStdYPos=s.m_nCanvasYOversize/4;s.m_nTicksInALod=VBI.m_bIsMobile?6:12;s.m_nLodFactorZoomIn=Math.pow(2,1/s.m_nTicksInALod);s.m_nLodFactorZoomOut=1/s.m_nLodFactorZoomIn;s.m_nLodFactorZoomInHalf=Math.pow(2,1/(2*s.m_nTicksInALod));s.m_nLodFactorZoomOutHalf=1/s.m_nLodFactorZoomInHalf;s.m_nMaxAnimLodDiff=3;s.m_nZoomMode=1;s.m_nLastRenderingTime=0;s.m_nRenderTimeTarget=250;s.m_nNumOfScalingVOInst=0;s.m_nLastClusteringTime=0;s.m_nDataVersion=0;s.m_bObjCanvasMode=1;s.m_nlstWidth=s.m_nlstHeight=0;s.m_nGetImageDataIncidents=0;s.onTileLoaded=null;s.clear=function(){s.BaseClear();s.m_Touches=[];if(s.m_NavControl){s.m_NavControl.clear();s.m_NavControl=null;}if(s.m_Scale){s.m_Scale.clear();s.m_Scale=null;}s.clearTimers();s.clearCanvases();s.SetInputMode(VBI.InputModeDefault);s.Remove();s.m_RefMapLayerStack="";s.m_MapManager=null;s.m_MapLayerStack=null;s.m_TargetName=null;s.m_Proj=null;s.m_DivCopyright=null;s.m_Target=null;};s.loadSingleRemoveOnScene=function(r,a){if(jQuery.type(r)=='object'){switch(r.type){case"VO":var i=r.id;for(var j=s.m_VOS.length;j--;){if(s.m_VOS[j].m_ID==i){s.m_VOS[j].clear();s.m_VOS.splice(j,1);return;}}break;default:break;}}};s.loadRemoveOnScene=function(r,a){if(jQuery.type(r)=='array'){for(var j=0;j<r.length;++j){s.loadSingleRemoveOnScene(r[j],a);}}else{s.loadSingleRemoveOnScene(r,a);}};s.load=function(d,a,i){var r=false;if(i&&d.Remove){s.loadRemoveOnScene(d.Remove,a);}s.BaseLoad(d,a,i);if(d.refMapLayerStack){var n=a.m_MapLayerStackManager.GetMapLayerStack(d.refMapLayerStack);if(s.m_RefMapLayerStack!=n){s.m_RefMapLayerStack=n;r=true;}}else if(VBI.m_bTrace){VBI.Trace("no map layer specified in geo scene");}if(i){return r;}var m=-1000,b=1000;var e=-90,f=90;s.m_nMinLodVisualBorder=0;s.m_nMaxLodVisualBorder=99;s.m_nOffsetMinLod=0;s.m_bYBorderExists=false;if(d.VisualFrame){if(d.VisualFrame.minLon!=undefined){m=d.VisualFrame.minLon;}else{m=(d.VisualFrame.minX!=undefined?d.VisualFrame.minX:m);}if(d.VisualFrame.maxLon!=undefined){b=d.VisualFrame.maxLon;}else{b=(d.VisualFrame.maxX!=undefined?d.VisualFrame.maxX:b);}if(d.VisualFrame.minLat!=undefined){e=d.VisualFrame.minLat;}else{e=(d.VisualFrame.minY!=undefined?d.VisualFrame.minY:e);}if(d.VisualFrame.maxLat!=undefined){f=d.VisualFrame.maxLat;}else{f=(d.VisualFrame.maxY!=undefined?d.VisualFrame.maxY:f);}if(d.VisualFrame.minLOD!=undefined){s.m_nMinLodVisualBorder=d.VisualFrame.minLOD;}if(d.VisualFrame.maxLOD!=undefined){s.m_nMaxLodVisualBorder=d.VisualFrame.maxLOD;}if(d.VisualFrame.maxFraction!=undefined){s.m_fMaxMinLODFraction=d.VisualFrame.maxFraction;}if(d.VisualFrame.offsetMinLOD!=undefined){s.m_nOffsetMinLod=d.VisualFrame.offsetMinLOD;}}s.m_bXBorderExists=(m!=-1000)||(b!=1000);s.m_nBorderMinPoint=VBI.MathLib.DegToRad([m,f]);s.m_nBorderMaxPoint=VBI.MathLib.DegToRad([b,e]);s.m_Proj=s.setProjection();var u=[1.0,1.0],h=[1.0,1.0];s.m_Proj.LonLatToUCS(s.m_nBorderMinPoint,u);s.m_Proj.LonLatToUCS(s.m_nBorderMaxPoint,h);s.m_nXSizeVisualBorder=Math.max(0.0,Math.min(1.0,h[0]-u[0]));s.m_nYSizeVisualBorder=Math.max(0.0,Math.min(1.0,h[1]-u[1]));if(d.initialStartPosition){var j=d.initialStartPosition.split(';');s.m_startPointLonLat=VBI.MathLib.DegToRad([parseFloat(j[0]),parseFloat(j[1])]);}if(d.initialZoom){s.m_startLOD=parseInt(d.initialZoom,10);}if(d.ariaLabel){s.ariaLabel=d.ariaLabel;}var S={zoom:false,move:false,fade:false};if(d.NavigationDisablement){if(d.NavigationDisablement.zoom){s.m_SuppressedNavigation.zoom=VBI.Types.string2bool(d.NavigationDisablement.zoom);}if(d.NavigationDisablement.move){s.m_SuppressedNavigation.move=VBI.Types.string2bool(d.NavigationDisablement.move);}}if(d.navControlVisible){s.m_bNavControlVisible=VBI.Types.string2bool(d.navControlVisible);}S.zoom=s.m_SuppressedNavigation.zoom;S.move=s.m_SuppressedNavigation.move;if(s.m_SuppressedNavigation.zoom&&s.m_SuppressedNavigation.move){s.m_bNavControlVisible=false;}else if(s.m_bNavControlVisible){if(d.SuppressedNavControlVisibility){if(!S.zoom&&d.SuppressedNavControlVisibility.zoom){S.zoom=VBI.Types.string2bool(d.SuppressedNavControlVisibility.zoom);}if(!S.move&&d.SuppressedNavControlVisibility.move){S.move=VBI.Types.string2bool(d.SuppressedNavControlVisibility.move);}if(d.SuppressedNavControlVisibility.fade){S.fade=VBI.Types.string2bool(d.SuppressedNavControlVisibility.fade);}}if(S.move&&S.zoom){s.m_bNavControlVisible=false;}}if(d.scaleVisible){s.m_bScaleVisible=VBI.Types.string2bool(d.scaleVisible);}if(s.m_Ctx.moThumbnail){s.m_SuppressedNavControlVisibility=S;}else if(s.m_bNavControlVisible){s.m_NavControl=new VBI.NavigationControl(S);}if(s.m_bScaleVisible&&!s.m_Ctx.moThumbnail){s.m_Scale=new VBI.Scale(s);}if(d.rectZoom&&VBI.Types.string2bool(d.rectZoom)){s.m_nInitialTrackingMode=VBI.InputModeRectZoom;}else if(d.rectSelect&&VBI.Types.string2bool(d.rectSelect)){s.m_nInitialTrackingMode=VBI.InputModeRectSelect;}else if(d.lassoSelect&&VBI.Types.string2bool(d.lassoSelect)){s.m_nInitialTrackingMode=VBI.InputModeRectSelect;}else{s.m_nInitialTrackingMode=VBI.InputModeDefault;}return false;};s.SetInputMode=function(v){if(VBI.m_bTrace){VBI.Trace("SetInputMode: "+this.m_nInputMode);}if(this.m_nInputMode==v){return;}switch(this.m_nInputMode){case VBI.InputModeTrackMap:s.SetInputModeTrackMap(false);break;default:break;}switch(v){case VBI.InputModeTrackMap:s.SetInputModeTrackMap(true);break;default:break;}this.m_nInputMode=v;};s.SetToolTip=function(a,v,b,d){var C=s.m_Canvas[s.m_nLabelIndex];if(a instanceof sap.ui.core.TooltipBase){if(v==true&&!a._getPopup().isOpen()){var o=(b)+" "+(d+20);a.setMyPosition(sap.ui.core.Popup.Dock.BeginTop);a.setAtPosition(sap.ui.core.Popup.Dock.BeginTop);a.setOffset(o);a.setCollision("fit fit");a.openPopup(a.getParent());C.title="";}else if(v==false&&a._getPopup().isOpen()){a.closePopup();}}else if(C.title!=a){C.title=a;}};s.SetCursor=function(a){var C=s.m_Canvas[s.m_nLabelIndex];if(C.style.cursor!=a){C.style.cursor=a;}};s.RenderAsync=function(f){if(f!=false){s.bForceRecluster=true;}if(!s.m_RenderRequestID){s.m_RenderRequestID=window.requestAnimationFrame(s.DoRender);}};s.DoRender=function(){s.Render(!s.bForceRecluster);};s.Render=function(a){s.m_RenderRequestID=0;s.bForceRecluster=false;if(s.m_Canvas.length){s.InternalRenderLayer(s.m_Canvas[s.m_nOverlayIndex],false,true,a!=true,s.m_Canvas[0].m_nExactLOD);}};s.GoToInitialStart=function(){if(s.m_nMaxLodVisualBorder<Math.ceil(s.GetMinLOD())){s.m_nMaxLodVisualBorder=Math.ceil(s.GetMinLOD());}if(!s.ZoomToGeoPosition(s.m_startPointLonLat,s.m_startLOD,true,false,true)){var m=VBI.MathLib.RadToDeg(s.m_nBorderMinPoint);var a=VBI.MathLib.RadToDeg(s.m_nBorderMaxPoint);var l=[m[0],a[0]];var b=[m[1],a[1]];s.ZoomToMultiplePositions(l,b,1.1,true);}s.RenderAsync(true);};s.GetDistance=function(p,a){var G=s.GetPosFromVPPoint(p);var b=s.GetPosFromVPPoint(a);return VBI.MathLib.Distance(VBI.MathLib.DegToRad(G),VBI.MathLib.DegToRad(b));};s.GetTargetPointForDistance=function(d,p){var a=VBI.MathLib.DegToRad(s.GetPosFromVPPoint(p));var b=90*Math.PI/180;var l=Math.asin(Math.sin(a[1])*Math.cos(d/VBI.MathLib.earthradius)+Math.cos(a[1])*Math.sin(d/VBI.MathLib.earthradius)*Math.cos(b));var e=a[0]+Math.atan2(Math.sin(b)*Math.sin(d/VBI.MathLib.earthradius)*Math.cos(a[1]),Math.cos(d/VBI.MathLib.earthradius)-Math.sin(a[1])*Math.sin(l));return(s.GetPointFromGeo([e,l],false));};s.ZoomToMultiplePositions=function(l,d,e,S){var m=[];var f=[];if(l.length!=d.length){return;}var n;for(n=0;n<l.length;n++){var L=(parseFloat(l[n]));if(L<0){L+=360;}m.push(L);f.push(parseFloat(d[n]));}if(m.length!=f.length||!m.length){return;}m.sort(function(a,b){return a-b;});f.sort(function(a,b){return a-b;});var h=0,i=0,j,k;j=f[0];k=f[f.length-1];var o,p,q,r;p=m[m.length-1];for(n=0;n<m.length;n++){q=m[n];r=(q<p?(q+360-p):(q-p));if(o==undefined||r>o){o=r;h=(q<p?q+360:q);i=p;}p=q;}s.ZoomToArea(h,i,j,k,e?e:1.0,true,S);};s.ZoomToAreas=function(a,b){var x=Math.log(s.m_nDivWidth/(s.m_MapManager.m_tileWidth*s.m_nXSizeVisualBorder))*Math.LOG2E;var d=VBI.MathLib.GetSurroundingBox(a,0,x,s.CalculateYMinLod,s.m_bObjCanvasMode==1?0.5:0);s.ZoomToArea(d[0],d[1],d[2],d[3],b,true);var e=new Date().getTime();s.m_LastZoomArea=[e,"Areas",a,b];return true;};s.ZoomTo=function(a,b){var l=[],d=[];var z=function(f,v,d,l,h){f.forEach(e.bind(this,h,v,d,l));};var e=function(h,v,d,l,m){if(h===m.m_Value){if(v.m_Pos){var p=v.m_Pos.GetValueVector(this.m_Ctx);for(var k=0;k<p.length/3;++k){d.push(p[k*3+0]);l.push(p[k*3+1]);}}}};for(var i=0;i<this.m_VOS.length;++i){var v=this.m_VOS[i];var n=v.m_DataSource.GetCurrentNode(this.m_Ctx);if(n&&n.m_dataelements.length){for(var j=0;j<n.m_dataelements.length;++j){v.m_DataSource.Select(j);var f=n.m_dataelements[j].m_dataattributes;a.forEach(z.bind(this,f,v,d,l));}}}if(d.length){s.ZoomToMultiplePositions(d,l,b);}return true;};s.ZoomToAll=function(a,b){var l=[],d=[];for(var i=0;i<s.m_VOS.length;++i){var v=s.m_VOS[i];var e=v.m_DataSource?v.m_DataSource.GetCurrentNode(s.m_Ctx):null;if(e&&e.m_dataelements.length){for(var j=0;j<e.m_dataelements.length;++j){v.m_DataSource.Select(j);if(v.m_Pos){var p=v.m_Pos.GetValueVector(s.m_Ctx);for(var k=0;k<p.length/3;++k){d.push(p[k*3+0]);l.push(p[k*3+1]);}}else if(v.m_PosM){var p=v.m_PosM.GetValueVector(s.m_Ctx);for(var k=0;k<p.length;++k){for(var m=0;m<p[k].length;++m){for(var n=0;n<p[k][m].length/3;++n){d.push(p[k][m][n*3+0]);l.push(p[k][m][n*3+1]);}}}}}}}if(d.length){s.ZoomToMultiplePositions(d,l,a,b);}};s.CalculateYMinLod=function(m,a){if(m==a){return 1000;}var u=[256,256];var b=[256,256];s.m_Proj.LonLatToUCS(VBI.MathLib.DegToRad([0,m]),u);s.m_Proj.LonLatToUCS(VBI.MathLib.DegToRad([0,a]),b);var l=s.m_nDivHeight/Math.abs(b[1]-u[1]);l=Math.log(l)*Math.LOG2E;return l;};s.ZoomToArea=function(m,a,b,d,e,r,S){var n=256,f=256;if(s.m_MapManager){n=s.m_MapManager.m_tileWidth;f=s.m_MapManager.m_tileHeight;}var h=s.m_nDivHeight?s.m_nDivHeight:f;var i=s.m_nDivWidth?s.m_nDivWidth:n;var I;var p;if(jQuery.type(e)=='array'){if(e.length>=4){var x=e[0]+e[2];var y=e[1]+e[3];if((x<i)&&(y<h)){if((e[0]!=e[2])||(e[1]!=e[3])){p=[(e[2]-e[0])/2,(e[3]-e[1])/2];}i-=x;h-=y;I=((x<0)||(y<0));}}}else{h*=e;i*=e;I=(e>1.0);}if(a<m){a+=360;}while(m>180){m-=360;}while(a>180){a-=360;}var j=[m,b];var k=[a,d];j=VBI.MathLib.DegToRad(j);k=VBI.MathLib.DegToRad(k);var u=[n,f];var l=[n,f];s.m_Proj.LonLatToUCS(j,u);s.m_Proj.LonLatToUCS(k,l);var o=u[0]+l[0]+(l[0]<u[0])*n;var q=u[1]+l[1];var v=[o/n-1,q/f-1];var z=[1,1];s.m_Proj.UCSToLonLat(v,z);var w=14,A=14;if(d!=b){w=h/Math.abs(l[1]-u[1]);w=Math.log(w)*Math.LOG2E;}if(a!=m){A=i/Math.abs((l[0]-u[0])+(l[0]<=u[0])*n);A=Math.log(A)*Math.LOG2E;}var B=(I)?Math.max(A,w):Math.min(A,w);if(r){B=Math.floor(B);}s.ZoomToGeoPosition(z,B,false,false,S,p);if(B!=Math.floor(B)){setTimeout(function(){s.AnimateZoomToGeo(z,Math.floor(B),5);},20);}var C=new Date().getTime();s.m_LastZoomArea=[C,"Area",m,a,b,d,e];};s.getInfoForCluster=function(i,a){var p=JSON.parse(i);var b=s.m_Ctx.m_Clustering;return b.getInfoForCluster(p,a,s);};s.AdaptOtherCanvas=function(u,l,a,n){var b=a?1:0;var o=s.m_Canvas[1-b];if((a<=1)&&(a>=-2)){var d=l-o.m_nCurrentLOD;var e=Math.pow(2,-d);var p=Math.max(1,e);var f=o.getPixelLeft(),h=o.getPixelTop();var i=o.getPixelWidth(),j=o.getPixelHeight();var k=i/s.m_nWidthCanvas;var m=[(this.m_MapManager.m_tileWidth*o.m_nCurrentX+(s.m_nDivWidth/2-f)/k),(this.m_MapManager.m_tileHeight*o.m_nCurrentY+(s.m_nDivHeight/2-h)/k)];var q=[m[0]-e*u[0],m[1]-e*u[1]];if((Math.abs(q[0])<p*s.m_nWidthCanvas)&&(Math.abs(q[1])<p*s.m_nHeightCanvas)){var r=Math.pow(2,n);var v=r*(f-s.m_nDivWidth/2+k*q[0])+s.m_nDivWidth/2;var w=r*(h-s.m_nDivHeight/2+k*q[1])+s.m_nDivHeight/2;this.MoveCanvas(o,v,w,i*r,j*r);return b;}}return 0;};s.ZoomToGeoPosition=function(l,a,d,S,b,p){if((l.pixelShift!=undefined)&&(p==undefined)){p=l.pixelShift;}if(s.m_Canvas[s.m_nNonDomIndex].m_bCanvasValid){s.SwitchTmpCanvasToActive();}var x=0,y=0;var e=s.m_Canvas[0];var o=e.m_nExactLOD;var n=s.m_MapManager.m_tileWidth;var f=s.m_MapManager.m_tileHeight;var h=Math.min(Math.max(a,s.GetMinLOD()),s.GetMaxLOD());a=Math.floor(h);var i=Math.pow(2,h-a);var j=(1<<a);if(p!=undefined){x=p[0]/i;y=p[1]/i;}var u=[j*n,j*f];s.m_Proj.LonLatToUCS(l,u);var k=[u[0]-s.m_nDivWidth/2+x,u[1]-s.m_nDivHeight/2+y];var m=s.m_Proj.m_nUCSMin*j;var q=s.AdaptOtherCanvas(u,a,a-e.m_nCurrentLOD,h-e.m_nExactLOD);var r=Math.round(k[0]/n-s.m_nCanvasStdXPos-m);var v=Math.round(k[1]/f-s.m_nCanvasStdYPos);var w=-Math.floor(k[0]-(r+m)*n);var z=-Math.floor(k[1]-v*f);var A=Math.round(w+((i-1)*(w-s.m_nDivWidth/2)));var B=Math.round(z+((i-1)*(z-s.m_nDivHeight/2)));var C=Math.round(s.m_nWidthCanvas*i);var D=Math.round(s.m_nHeightCanvas*i);var E=[j,j];var F=[j,j];s.m_Proj.LonLatToUCS(s.m_nBorderMinPoint,E);s.m_Proj.LonLatToUCS(s.m_nBorderMaxPoint,F);var G=D/s.m_nHeightCanvas;var H=f*(v-E[1])*G-B;var I=f*(v-F[1])*G+s.m_nDivHeight-B;var J;var T=true;if(H<-s.m_nMaxPixelBeyondPoles){B=f*(v-E[1])*G+s.m_nMaxPixelBeyondPoles;}else if(I>s.m_nMaxPixelBeyondPoles){B=f*(v-F[1])*G+s.m_nDivHeight-s.m_nMaxPixelBeyondPoles;}else{T=false;}if(T){if(d){return false;}var K=(B+(i-1)*s.m_nDivHeight/2)/i;J=-Math.round(s.m_nCanvasStdYPos+K/f);v+=J;B+=i*J*f;}if(s.m_bXBorderExists){var L=n*(r-E[0])*G-A;var M=n*(r-F[0])*G+s.m_nDivWidth-A;var N=true;if(L<-s.m_nMaxPixelBeyondPoles){A=n*(r-E[0])*G+s.m_nMaxPixelBeyondPoles;}else if(M>s.m_nMaxPixelBeyondPoles){A=n*(r-F[0])*G+s.m_nDivWidth-s.m_nMaxPixelBeyondPoles;}else{N=false;}if(N){if(d){return false;}var O=(A+(i-1)*s.m_nDivWidth/2)/i;J=-Math.round(s.m_nCanvasStdXPos+O/f);r+=J;A+=i*J*n;}}var P=((e.m_nCurrentX==r)&&(e.m_nCurrentY==v)&&(e.m_nCurrentLOD==a));if(P){s.MoveCanvas(e,A,B,C,D);e.m_nExactLOD=h;}else{s.InvalidateCanvas(s.m_Canvas[1]);if(q==0){var Q=e.getContext("2d");Q.clearRect(0,0,e.width,e.height);}var R=s.m_Canvas[q];s.MoveCanvas(R,A,B,C,D);s.m_MapManager.RequestTiles(R,s.m_MapLayerStack,r,v,s.m_nTilesX,s.m_nTilesY,0,0,0,0,a,false);R.m_nExactLOD=h;if(q==1){s.ToggleCanvas(s);}}if(b!=true){s.InternalRenderLayer(s.m_Canvas[s.m_nOverlayIndex],false,!P,!P,h);}s.m_LastDefinedCenterPos=p?undefined:l;s.InternalOnMoveLayer(e,S);if(h!=o){s.InternalOnZoomLayer(s.m_Canvas[s.m_nOverlayIndex],S);}if(s.m_bNavControlVisible&&s.m_NavControl){s.m_NavControl.AdjustScrollPoint(h);}return true;};s.RefreshMapLayerStack=function(){var n=s.m_RefMapLayerStack?s.m_RefMapLayerStack.m_Name:s.m_MapLayerStack.m_Name;if(n){s.SetMapLayerStack(n);s.AddCopyright();}};s.SetMapLayerStack=function(n){var i=s.m_Ctx.m_MapLayerStackManager.GetMapLayerStack(n);if(i==null){return;}if(s.m_Canvas[s.m_nNonDomIndex].m_bCanvasValid){s.SwitchTmpCanvasToActive();}s.m_MapLayerStack=i;var a=s.m_Canvas[0];s.m_MapManager.RequestTiles(a,s.m_MapLayerStack,a.m_nCurrentX,a.m_nCurrentY,s.m_nTilesX,s.m_nTilesY,0,0,0,0,a.m_nCurrentLOD,false);s.InternalRenderLayer(s.m_Canvas[s.m_nOverlayIndex],false,true,true,a.m_nCurrentLOD);};s.ZoomToZoomlevel=function(l,n,S){var r=s.GetInternalDivClientRect();if((r.width!=s.m_nDivWidth)||(r.height!=s.m_nDivHeight)){s.resizeCanvas(0);}s.ZoomToGeoPosition(l,n,false,S);};s.GetMapLayerStack=function(){return s.m_MapLayerStack;};s.GetMinLOD=function(){var n=Math.max(s.m_nDivWidth/(s.m_MapManager.m_tileWidth*s.m_nXSizeVisualBorder),s.m_nDivHeight/(s.m_MapManager.m_tileHeight*s.m_nYSizeVisualBorder));var a=Math.log(n)*Math.LOG2E;var m=s.m_MapLayerStack;var b=Math.max(s.m_nMinLodVisualBorder-s.m_nOffsetMinLod,m?m.GetMinLOD():0);var d=Math.max(a,b);if(s.m_fMaxMinLODFraction!=undefined&&(d-Math.floor(d)>s.m_fMaxMinLODFraction)){return Math.ceil(d);}return d;};s.GetMinLODForWidth=function(w){var n=w/s.m_MapManager.m_tileWidth;var a=Math.log(n)*Math.LOG2E;var m=s.m_MapLayerStack;var b=Math.max(s.m_nMinLodVisualBorder,m?m.GetMinLOD():0)-s.m_nOffsetMinLod;return Math.max(a,b);};s.GetMaxLOD=function(){var m=s.m_MapLayerStack;return Math.min(m?m.GetMaxLOD():20,s.m_nMaxLodVisualBorder);};s.GetCurrentZoomlevel=function(){return s.m_Canvas[0].m_nExactLOD;};s.GetCenterPos=function(){if(s.m_LastDefinedCenterPos!=undefined){return s.m_LastDefinedCenterPos;}var a=s.getCanvas();var p=[s.m_nDivWidth/2-a.getPixelLeft(),s.m_nDivHeight/2-a.getPixelTop()];return(s.GetGeoFromPoint(p));};s.InternalRenderVisualObjects=function(a,d,b){var e=Date.now();var v=s.m_VOS;var V=v.length;var f;s.m_nNumOfScalingVOInst=0;VBI.Utilities.BackupFont(d);var h,i;if(b){if(s.m_nShadowIndex!=undefined){h=s.m_Canvas[s.m_nShadowIndex];i=h.getContext('2d');i.clearRect(0,0,h.width,h.height);}}s.BuildCacheDataObj();for(var n=0;n<V;++n){v[n].Init4Render();}for(var j=0;j<V;++j){var k=v[j];if(k.m_Label&&k.m_Label.length){for(var l=0;l<k.m_Label.length;++l){k.m_Label[l].clear();}}k.m_Label=[];if(b){var p=b.base[j];k.m_nPreDataIndex=j;f=k.Render(a,d,p);for(var m=p.clusterings.length;m--;){f+=k.Render(a,d,b.clust[p.clusterings[m].i],h,i,true);}}else{f=k.Render(a,d);}if(f!=undefined){s.m_nNumOfScalingVOInst+=f;}}this.InvalidateInvisibleHots();if(s.m_DesignVO){s.m_DesignVO.Render(a,d);}var o=s.m_Canvas[s.m_nLabelIndex];var q=o.getContext('2d');VBI.Utilities.BackupFont(q);q.clearRect(0,0,o.width,o.height);s.InternalRenderLabels(o,q);VBI.Utilities.RestoreFont(q);VBI.Utilities.RestoreFont(d);s.DestroyCacheDataObj();s.m_nLastRenderingTime=Date.now()-e;if(s.m_Ctx.moThumbnail){s.Copy2Thumbnail();}};s.TriggerReRenderTimer=function(n){window.clearInterval(s.m_ReRenderTimer);s.m_ReRenderTimer=window.setInterval(function(){window.clearInterval(s.m_ReRenderTimer);s.m_ReRenderTimer=null;if(!s.m_bNonIntPosStable){s.m_bNonIntPosStable=Date.now();}s.RenderAsync(true);if(s.m_bLineAnimationRunning){s.TriggerReRenderTimer(15);}},n);};s.AddThumbnailText=function(a,b){var x,y,d,e;var f=a.getContext('2d');switch(b.nFontPos){case 2:case 3:case 4:x=a.width;d="right";break;case 0:case 1:case 5:x=a.width/2;d="center";break;default:x=0;d="left";break;}switch(b.nFontPos){case 4:case 5:case 6:y=a.height;e="bottom";break;case 7:case 0:case 3:y=a.height/2;e="middle";break;default:y=0;e="top";break;}var C=VBI.Types.string2rgba(b.strCol);f.font=b.strFont;f.fillStyle=f.strokeStyle=VBI.Utilities.RgbToHex(C[0],C[1],C[2]);f.textAlign=d;f.textBaseline=e;f.fillText(b.strText,x,y);};s.GetOverlayPicture=function(m){var C;var r;var o=s.GetStretchFactor4Mode();var a=VBI.Utilities.CreateGeoSceneCanvas("temporarynondomlayer",s.m_nDivWidth,s.m_nDivHeight,0,2);var b=a.getContext("2d");if(m&2){C=s.m_Canvas[0];var d=s.GetCurrentZoomFactors();b.drawImage(C,-C.m_pixelLeft/d[0],-C.m_pixelTop/d[1],s.m_nDivWidth/d[0],s.m_nDivHeight/d[1],0,0,s.m_nDivWidth,s.m_nDivHeight);}C=s.m_Canvas[s.m_nOverlayIndex];b.drawImage(C,-C.m_pixelLeft/o[0],-C.m_pixelTop/o[1],s.m_nDivWidth/o[0],s.m_nDivHeight/o[1],0,0,s.m_nDivWidth,s.m_nDivHeight);if(m&1){C=s.m_Canvas[s.m_nLabelIndex];b.drawImage(C,-C.m_pixelLeft/o[0],-C.m_pixelTop/o[1],s.m_nDivWidth/o[0],s.m_nDivHeight/o[1],0,0,s.m_nDivWidth,s.m_nDivHeight);}try{r=a.toDataURL("png");}catch(e){VBI.Trace(e.message);return"";}return r;};s.Copy2Thumbnail=function(){var a=s.m_Canvas[s.m_nThumbnailIndex];var C=s.m_Canvas[0];var b=a.getContext("2d");var m=s.GetCurrentZoomFactors();var o=s.GetStretchFactor4Mode();b.clearRect(0,0,a.width,a.height);b.drawImage(C,-C.m_pixelLeft/m[0],-C.m_pixelTop/m[1],s.m_Ctx.moThumbnail.nOrgWidth/m[0],s.m_Ctx.moThumbnail.nOrgHeight/m[1],0,0,a.clientWidth,a.clientHeight);C=s.m_Canvas[s.m_nOverlayIndex];b.drawImage(C,-C.m_pixelLeft/o[0],-C.m_pixelTop/o[1],s.m_Ctx.moThumbnail.nOrgWidth/o[0],s.m_Ctx.moThumbnail.nOrgHeight/o[1],0,0,a.clientWidth,a.clientHeight);var d=s.m_Ctx.moThumbnail;if(d.strFont&&d.nFontPos!=undefined&&d.strText){s.AddThumbnailText(a,d);}};s.CopyCanvasAway=function(a,t){var l=t.getContext('2d');l.clearRect(0,0,t.width,t.height);l.drawImage(a,0,0,a.width,a.height);};s.UpdatePreData4Selected=function(V,I){var a=s.m_Ctx.m_Clustering;if((V!=undefined)&&a){a.VerifyCurrentSelection(s.m_VOS,s.m_PreassembledData,s.m_Ctx);a.AddSingle2Selected(V,s.m_VOS,I,s.m_PreassembledData,s.m_Ctx);}};s.UpdatePreData4SelArray=function(a){var b=s.m_Ctx.m_Clustering;if(b){b.VerifyCurrentSelection(s.m_VOS,s.m_PreassembledData,s.m_Ctx);b.AddMultiple2Selected(a,s.m_VOS,s.m_PreassembledData,s.m_Ctx);}};VBI.addSceneLabelFunctions(s);s.InvalidatePreassembledData=function(a,l){var h=s.m_HotItem.m_VO;var b;if(h!=undefined&&h.IsClusterable()){b=h.SwitchHotItemToStandard();}s.m_PreassembledData=undefined;if(s.m_nShadowIndex!=undefined){s.DisableShadowLayer();}return b;};s.DisableShadowLayer=function(){var a=s.m_Canvas[s.m_nShadowIndex];var d=a.getContext('2d');d.clearRect(0,0,a.width,a.height);s.clearCanvas(s.m_nShadowIndex);s.m_Canvas.splice(s.m_nShadowIndex,1);s.m_nShadowIndex=undefined;};s.SwitchCanvasSize=function(a,n,b){var d=[n,b];var e=d[0]*d[1]/1024;if(s.m_nCanvasMaxPixel<e){var f=Math.sqrt(e/s.m_nCanvasMaxPixel);d[0]=Math.floor(d[0]/f);d[1]=Math.floor(d[1]/f);s.m_bObjCanvasMode=2;}else{s.m_bObjCanvasMode=1;}a.width=s.m_Canvas[s.m_nLabelIndex].width=d[0];a.height=s.m_Canvas[s.m_nLabelIndex].height=d[1];if(s.m_nShadowIndex){s.m_Canvas[s.m_nShadowIndex].width=d[0];s.m_Canvas[s.m_nShadowIndex].height=d[1];}a.setPixelWidth(a.width);a.setPixelHeight(a.height);return d;};s.InternalRenderLayer=function(a,C,f,F,n,b){var d=s.m_Canvas[0];var l;var e=s.m_Ctx.m_Clustering;var h=((e!=undefined)&&e.m_Clusters.length);if((s.m_PreassembledData!=undefined)&&!h){l=s.InvalidatePreassembledData(e,d.m_nCurrentLOD);}if((f==false)&&(n!=undefined)){var i=Math.floor(n);if(n==s.m_nLastRenderLOD){return;}if((i==Math.floor(s.m_nLastRenderLOD))&&(n!=i&&(n>(s.GetMinLOD()+0.001)))){var j=Math.abs(n-s.m_nLastRenderLOD);if(j<s.m_nLastRenderingTime/s.m_nRenderTimeTarget){return;}}}s.m_OverlayImage=null;s.m_nLastRenderLOD=(n==undefined)?-1:n;var k,o=a.getPixelWidth();var m,p=a.getPixelHeight();if(s.m_bObjCanvasMode){var q=s.SwitchCanvasSize(a,o,p);s.m_StretchFactors=[o/q[0],p/q[1]];s.m_ZoomFactors=[q[0]/s.m_nWidthCanvas,q[1]/s.m_nHeightCanvas];k=o;m=p;}else{k=s.m_nWidthCanvas;m=s.m_nHeightCanvas;a.setPixelWidth(k);a.setPixelHeight(m);s.m_ZoomFactors=[1,1];s.m_StretchFactors=[o/s.m_nWidthCanvas,p/s.m_nHeightCanvas];}var r=a.getContext('2d');if(C){r.clearRect(0,0,a.width,a.height);a.setPixelWidth(o);a.setPixelHeight(p);return;}var S=false;if(h){this.SetLastHotItem(s.m_HotItem);var u=Date.now();s.m_PreassembledData=e.DoClustering(this,d.m_nCurrentLOD,d.m_nCurrentX,d.m_nCurrentY,s.m_nTilesX,s.m_nTilesY,s.m_VOS,s.m_Ctx,l,f,F,s.m_nDataVersion);this.CheckHotItem();if(s.m_PreassembledData.config.bNeedsShadowLayer&&(s.m_nShadowIndex==undefined)){s.m_nShadowIndex=s.m_Canvas.length;s.m_Canvas.push(VBI.Utilities.CreateGeoSceneCanvas(s.m_TargetName+"-"+s.m_ID+"-shadow",k,m));s.InitializeCanvas(s.m_Canvas[s.m_nShadowIndex],s.m_Canvas[s.m_nOverlayIndex]);S=true;}if(!s.m_PreassembledData.config.bNeedsShadowLayer&&(s.m_nShadowIndex!=undefined)){s.DisableShadowLayer();}s.m_nLastClusteringTime=Date.now()-u;}r.clearRect(0,0,a.width,a.height);s.InternalRenderVisualObjects(a,r,s.m_PreassembledData);if(s.m_bObjCanvasMode!=1){a.setPixelWidth(o);a.setPixelHeight(p);}if(S){s.MoveCanvas2ObjectCanvas(s.m_Canvas[s.m_nShadowIndex]);}s.InternalOnRenderLayer(a);if(s.m_Scale){s.m_Scale.Update();}if(s.m_bSwitch2OldCanvasMode&&d.m_nExactLOD==Math.round(d.m_nExactLOD)){s.m_bSwitch2OldCanvasMode=undefined;s.m_bObjCanvasMode=0;VBI.Trace("Switching back to old object canvas rendering style due to performance issues ");}};s.InternalOnMoveLayer=function(a,S){s.m_Ctx.m_Windows.NotifySceneMove(this);var b;if((b=s.m_Ctx.m_Actions)&&(S!=true)){var d=b.findAction("CenterChanged",s,"Map");if(d){var e=s.m_Canvas[s.m_nOverlayIndex];var n=e.getPixelWidth();var f=e.getPixelHeight();var l=s.GetPosFromPoint([0,0]);var r=s.GetPosFromPoint([n,f]);if(!s.m_Proj.m_bIsIsogonal){var h=s.GetPosFromPoint([n,0]);var i=s.GetPosFromPoint([0,f]);l=[Math.min(l[0],i[0]),Math.min(l[1],h[1])];r=[Math.max(h[0],r[0]),Math.max(i[1],r[1])];}var j=s.GetInternalDivClientRect();var v=-e.getPixelLeft();var k=-e.getPixelTop();var m=s.GetPosFromPoint([v,k]);var o=s.GetPosFromPoint([v+j.width,k+j.height]);var p={level:s.GetCurrentZoomlevel().toString(),min:l[0].toString()+";"+l[1].toString()+";0",max:r[0].toString()+";"+r[1].toString()+";0",vpmin:m[0].toString()+";"+m[1].toString()+";0",vpmax:o[0].toString()+";"+o[1].toString()+";0"};s.m_Ctx.FireAction(d,s,this,null,p);}}this.m_EvtCont.fire("onMove",{canvas:a});s.m_Ctx.onMoveLayer(a);};s.InternalOnZoomLayer=function(a,b){s.m_Ctx.m_Windows.NotifySceneZoom(this);if(b!=true){var d=s.m_Ctx.m_Actions;if(d){var e=d.findAction("ZoomChanged",s,"Map");if(e){var f=s.m_Canvas[s.m_nOverlayIndex];var n=f.getPixelWidth();var h=f.getPixelHeight();var l=s.GetPosFromPoint([0,0]);var r=s.GetPosFromPoint([n,0]);var i=s.GetPosFromPoint([0,h]);var j=s.GetPosFromPoint([n,h]);var k=s.GetInternalDivClientRect();var v=-f.getPixelLeft();var m=-f.getPixelTop();var o=s.GetPosFromPoint([v,m]);var p=s.GetPosFromPoint([v+k.width,m+k.height]);var q={level:s.GetCurrentZoomlevel().toString(),min:Math.min(l[0],i[0]).toString()+";"+Math.min(l[1],r[1]).toString()+";0",max:Math.max(j[0],r[0]).toString()+";"+Math.max(i[1],j[1]).toString()+";0",vpmin:o[0].toString()+";"+o[1].toString()+";0",vpmax:p[0].toString()+";"+p[1].toString()+";0"};if(b!=undefined&&b!=false){q.x=b.x.toString()-k.left;q.y=b.y.toString()-k.top;}s.m_Ctx.FireAction(e,s,this,null,q);}}}this.m_EvtCont.fire("onZoom",{canvas:a});s.m_Ctx.onZoomLayer(a);};s.InternalOnRenderLayer=function(a){s.m_Ctx.onRenderLayer(a);if(s.GetHomeLocation){var o=a.getPixelWidth();var b=a.getPixelHeight();var l=[0,0];var h=s.GetHomeLocation();l[0]=h[0];l[1]=h[1];var x=s.GetPointFromGeo(l);a.setPixelWidth(s.m_nWidthCanvas);a.setPixelHeight(s.m_nHeightCanvas);var d=a.getContext('2d');d.clearRect(0,0,a.width,a.height);d.fillStyle='yellow';d.beginPath();d.arc(x[0],x[1],5,0,Math.PI*2,true);d.closePath();d.fill();var i=null;if(s.m_Ctx){i=s.m_Ctx.GetImage("dummy",s.RenderAsync.bind());}if(i){d.drawImage(i,x[0]-i.naturalWidth/2,x[1]-i.naturalHeight);}a.setPixelWidth(o);a.setPixelHeight(b);}};s.MoveObject=function(o,x,y,w,h){o.m_pixelLeft=Math.round(x);o.m_pixelTop=Math.round(y);o.style.left=o.m_pixelLeft.toString()+"px";o.style.top=o.m_pixelTop.toString()+"px";if(w!==undefined){o.m_pixelWidth=Math.round(w);o.style.width=o.m_pixelWidth.toString()+"px";}if(h!==undefined){o.m_pixelHeight=Math.round(h);o.style.height=o.m_pixelHeight.toString()+"px";}};s.InvalidateCanvas=function(a){var b=a.getContext("2d");b.fillStyle='white';b.clearRect(0,0,a.width,a.height);a.m_bInvalid=true;};s.MoveCanvas=function(a,x,y,w,h){s.MoveObject(s.m_Canvas[s.m_nOverlayIndex],x,y,w,h);s.MoveObject(s.m_Canvas[s.m_nLabelIndex],x,y,w,h);if(s.m_nShadowIndex!=undefined){s.MoveObject(s.m_Canvas[s.m_nShadowIndex],x,y,w,h);}s.MoveObject(a,x,y,w,h);};s.MoveOnlyThisCanvas=function(a,x,y,w,h){s.MoveObject(a,x,y,w,h);};s.MoveCanvas2ObjectCanvas=function(a){var b=s.m_Canvas[s.m_nOverlayIndex];s.MoveObject(a,b.m_pixelLeft,b.m_pixelTop,b.m_pixelWidth,b.m_pixelHeight);};s.MoveMap=function(d,a){if(VBI.m_bTrace){VBI.Trace("MoveMap"+" DX:"+d+" DY:"+a);}var b=s.m_Canvas[s.m_nNonDomIndex];var e=s.m_Canvas[0];var f=(b.m_bCanvasValid?b:e);var m=s.m_MapManager;var n=f.getPixelWidth();var h=f.getPixelHeight();var i=f.getPixelLeft()+d;var j=f.getPixelTop()+a;var k=m.m_tileWidth,l=m.m_tileHeight;var o=n/s.m_nTilesX;var p=h/s.m_nTilesY;var q=h/s.m_nHeightCanvas;var r=(1<<e.m_nCurrentLOD);var u=[r,r];var v=[r,r];s.m_Proj.LonLatToUCS(s.m_nBorderMinPoint,u);s.m_Proj.LonLatToUCS(s.m_nBorderMaxPoint,v);if((a>0&&((l*q*(f.m_nCurrentY-u[1])-j)<-s.m_nMaxPixelBeyondPoles))||(a<0&&((l*q*(f.m_nCurrentY-v[1])+s.m_nDivHeight-j)>s.m_nMaxPixelBeyondPoles))){if(d==0){return;}a=0;j=f.getPixelTop();}if(s.m_bXBorderExists&&((d>0&&((k*q*(f.m_nCurrentX-u[0])-i)<-s.m_nMaxPixelBeyondPoles))||(d<0&&((k*q*(f.m_nCurrentX-v[0])+s.m_nDivWidth-i)>s.m_nMaxPixelBeyondPoles)))){if(a==0){return;}d=0;i=f.getPixelLeft();}var w=0;var x=0;var y;if((d>0)&&(y=i+s.m_nMapMoveXPreLoad)>0){w=Math.ceil(y/o);}else if((d<0)&&((y=s.m_nMapMoveXPreLoad+s.m_nDivWidth-(i+n))>0)){w=-Math.ceil(y/o);}var z=f.m_nCurrentX-w;if((a>0)&&(y=j+s.m_nMapMoveYPreLoad)>0){x=Math.ceil(y/p);}else if((a<0)&&(y=(s.m_nMapMoveYPreLoad+s.m_nDivHeight-(j+h)))>0){x=-Math.ceil(y/p);}var A=f.m_nCurrentY-x;var B=s.m_MapLayerStack;var S=B?B.m_bSingleBMP:false;if(w||x){var C=0,D=0;if(!s.m_Canvas[1].m_bInvalid){s.InvalidateCanvas(s.m_Canvas[1]);}s.MoveCanvas(e,e.getPixelLeft()+d,e.getPixelTop()+a);if(b.m_bCanvasValid){if(b.m_nTilesBefSwitch<b.m_nForceSwitchLimit){s.SwitchTmpCanvasToActive();}else{C=b.m_nOffsetX;D=b.m_nOffsetY;}}b.m_nTilesBefSwitch=(S||Math.abs(w)>=s.m_nTilesX||Math.abs(x)>=s.m_nTilesY)?1:(s.m_nTilesX-Math.abs(w))*(s.m_nTilesY-Math.abs(x));b.m_nForceSwitchLimit=Math.ceil(b.m_nTilesBefSwitch/2);b.m_nOffsetX=w+C;b.m_nOffsetY=x+D;s.MoveOnlyThisCanvas(b,i-w*o,j-x*p,n,h);var E=b.getContext("2d");E.clearRect(0,0,e.getPixelWidth(),e.getPixelHeight());if(m.RequestTiles(b,s.m_MapLayerStack,z,A,s.m_nTilesX,s.m_nTilesY,0,0,0,0,e.m_nCurrentLOD,false)){b.m_bCanvasValid=true;}else{s.SwitchTmpCanvasToActive();}}else{s.MoveCanvas(e,e.getPixelLeft()+d,e.getPixelTop()+a);s.MoveObject(s.m_Canvas[1],s.m_Canvas[1].getPixelLeft()+d,s.m_Canvas[1].getPixelTop()+a);if(b.m_bCanvasValid){s.MoveOnlyThisCanvas(b,i,j);}}var V=s.m_VOS;var R=false;for(var F=0,G=V.length;F<G;++F){if(V[F].m_Label.length>0&&V[F].CalculateLabelPos){R=true;break;}}if(R){var H=s.m_Canvas[s.m_nLabelIndex].getContext("2d");H.clearRect(0,0,s.m_Canvas[s.m_nLabelIndex].width,s.m_Canvas[s.m_nLabelIndex].height);VBI.Utilities.BackupFont(H);s.InternalRenderLabels(s.m_Canvas[s.m_nLabelIndex],H);VBI.Utilities.RestoreFont(H);}s.InternalOnMoveLayer(s.m_Canvas[s.m_nOverlayIndex]);s.m_LastDefinedCenterPos=undefined;};s.AdaptZoomFactor=function(a,f,x,y,b){var r={};r.bZoomNotPossible=true;var n=(1<<a.m_nCurrentLOD);if((a.m_nCurrentY<0)&&(y<-a.m_nCurrentY*(a.getPixelHeight()/s.m_nTilesY))){return r;}if(((a.m_nCurrentY+s.m_nTilesY)>n)&&(y>(n-a.m_nCurrentY)*(a.getPixelHeight()/s.m_nTilesY))){return r;}if(f<1){var d=Math.max((s.m_nDivWidth/(a.getPixelWidth()*s.m_nXSizeVisualBorder))*(s.m_nTilesX/n),(s.m_nDivHeight/(a.getPixelHeight()*s.m_nYSizeVisualBorder))*(s.m_nTilesY/n));if(f<d){if((d>=1)&&(f!=0)){return r;}f=d;}}var A=b&&(s.m_nZoomMode||(f==s.m_nLodFactorZoomIn)||(f==s.m_nLodFactorZoomOut));var e=a.m_nExactLOD+Math.log(f)*Math.LOG2E;var m=s.GetMinLOD();if((m!=Math.round(m))&&(f!=1.0)&&(a.m_nExactLOD<=Math.ceil(m))&&(Math.round(b*e)==Math.round(b*m))){A=false;}if(A&&Math.round(b*e)!=b*e){e=Math.round(b*e)/b;f=Math.pow(2,e-a.m_nExactLOD);}else if(e<m){e=m;f=Math.pow(2,e-a.m_nExactLOD);}r.factor=f;r.nNewLod=Math.floor(e);r.lodFallsOnInteger=(Math.round(e)==e);r.bZoomNotPossible=((e>s.GetMaxLOD())||(e<m));return r;};s.ZoomMap=function(f,x,y,a,S){s.m_bNonIntPosStable=false;if(s.m_Canvas[s.m_nNonDomIndex].m_bCanvasValid){s.SwitchTmpCanvasToActive();}var b=s.m_Canvas[0];var o=s.m_Canvas[1];var m=s.m_MapManager;var d=m.m_tileWidth,e=m.m_tileHeight;var n,h,i=0,j=0;var k=b.getPixelLeft(),l=b.getPixelTop();var p=b.getPixelWidth(),q=b.getPixelHeight();var r=o.getPixelWidth();var z=s.AdaptZoomFactor(b,f,x,y,a);if(z.bZoomNotPossible){return;}f=z.factor;var u=z.nNewLod;if(VBI.m_bTrace){VBI.Trace("Zoom by "+f+" to "+x+"/"+y);}var v=Math.round(p*f);var w=Math.round(v*b.height/b.width);var A=Math.round(k-((f-1)*x));var B=Math.round(l-((f-1)*y));if(f<1){var C=(1<<b.m_nCurrentLOD);var D=[C,C];var E=[C,C];s.m_Proj.LonLatToUCS(s.m_nBorderMinPoint,D);s.m_Proj.LonLatToUCS(s.m_nBorderMaxPoint,E);var F=w/s.m_nHeightCanvas;var G=(b.m_nCurrentY-D[1])*e*F-B;if(G<-s.m_nMaxPixelBeyondPoles){B=Math.round(e*(b.m_nCurrentY-D[1])*F+s.m_nMaxPixelBeyondPoles);y=(l-B)/(f-1);}else{var H=e*(b.m_nCurrentY-E[1])*F+s.m_nDivHeight-B;if(H>s.m_nMaxPixelBeyondPoles){B=Math.round(e*(b.m_nCurrentY-E[1])*F+s.m_nDivHeight-s.m_nMaxPixelBeyondPoles);y=(l-B)/(f-1);}}if(s.m_bXBorderExists){var I=(b.m_nCurrentX-D[0])*d*F-A;if(I<-s.m_nMaxPixelBeyondPoles){A=Math.round(d*(b.m_nCurrentX-D[0])*F+s.m_nMaxPixelBeyondPoles);x=(k-A)/(f-1);}var J=(b.m_nCurrentX-E[0])*d*F+s.m_nDivWidth-A;if(J>s.m_nMaxPixelBeyondPoles){A=Math.round(d*(b.m_nCurrentX-E[0])*F+s.m_nDivWidth-s.m_nMaxPixelBeyondPoles);x=(k-A)/(f-1);}}}s.MoveCanvas(b,A,B,v,w);var K=v/s.m_nTilesX;var L=w/s.m_nTilesY;var R=false;if(u==b.m_nCurrentLOD){if(!o.m_bInvalid){var M=Math.round(r*f);var N=Math.round(o.getPixelHeight()*f);if((M<=s.m_nMaxCanvasDimension)&&(N<=s.m_nMaxCanvasDimension)){var O=o.getPixelLeft();var P=o.getPixelTop();var Q=Math.round(O-((f-1)*(x+k-O)));var T=Math.round(P-((f-1)*(y+l-P)));s.MoveObject(o,Q,T,Math.round(r*f),Math.round(o.getPixelHeight()*f));}else{s.InvalidateCanvas(s.m_Canvas[1]);}}b.m_nExactLOD=b.m_nCurrentLOD+Math.log(K/d)*Math.LOG2E;if(A>0||B>0||(A+v<s.m_nDivWidth)||(B+w<s.m_nDivHeight)){R=true;n=-Math.ceil(A/K);h=-Math.ceil(B/L);i=A+n*K;j=B+h*L;A=b.m_nCurrentX+n;B=b.m_nCurrentY+h;if(VBI.m_bTrace){VBI.Trace("run out viewport newTop="+B+" nTilesY="+h+" nPosY="+j+" yOffset="+y+"\n");}}}else{R=true;var U=Math.pow(2,b.m_nCurrentLOD-u);var V=q/s.m_nHeightCanvas;var W=x/V+(U*(s.m_nDivWidth/2-k-x));var X=y/V+(U*(s.m_nDivHeight/2-l-y));if(u>b.m_nCurrentLOD){n=Math.round(W/U/d-s.m_nTilesX/2);h=Math.round(X/U/e-s.m_nTilesY/2);i=Math.ceil(A+n*K*U);j=Math.ceil(B+h*L*U);}else{var Y=((b.m_nCurrentX%U)+U)%U;var Z=((b.m_nCurrentY%U)+U)%U;n=Math.round((W/d+Y)/U-s.m_nTilesX/2);h=Math.round((X/e+Z)/U-s.m_nTilesY/2);i=A+K*(n*U-Y);j=B+L*(h*U-Z);}A=Math.floor(b.m_nCurrentX/U+n);B=Math.floor(b.m_nCurrentY/U+h);v=z.lodFallsOnInteger?(d*s.m_nTilesX):Math.ceil(v*U);w=z.lodFallsOnInteger?(e*s.m_nTilesY):Math.ceil(w*U);}var $=u+Math.log(v/s.m_nWidthCanvas)*Math.LOG2E;if(R){o.m_nExactLOD=$;s.MoveCanvas(o,i,j,v,w);s.m_MapManager.RequestTiles(s.m_Canvas[1],s.m_MapLayerStack,A,B,s.m_nTilesX,s.m_nTilesY,0,0,0,0,u,true);b.m_Scene.ToggleCanvas(b.m_Scene);}s.InternalRenderLayer(s.m_Canvas[s.m_nOverlayIndex],false,R,R,$);if(s.m_bNavControlVisible&&s.m_NavControl){s.m_NavControl.AdjustScrollPoint($);}s.InternalOnMoveLayer(b,S);s.InternalOnZoomLayer(s.m_Canvas[s.m_nOverlayIndex],S);s.m_LastDefinedCenterPos=s.m_LastZoomArea=undefined;};s.ZoomOtherCanvas=function(o,a,f,x,y){var n=Math.round(o.getPixelLeft()-((f-1)*x));var b=Math.round(o.getPixelTop()-((f-1)*y));var d=Math.round(o.getPixelWidth()*f);var e=Math.round(o.getPixelHeight()*f);s.MoveObject(o,n,b,d,e);};s.AnimationStep=function(){var a=s.m_Canvas[0].m_nExactLOD;var r=s.m_Canvas[0].getBoundingClientRect();if(a!=s.AnimZoomTarget){var b=Math.min((Date.now()-s.AnimZoomTimestamp)/s.AnimZoomDuration,1);var f=Math.min(b*(2-b),1);var z=Math.pow(2,s.AnimZoomOrigin+(s.AnimZoomTarget-s.AnimZoomOrigin)*f)/Math.pow(2,a);s.ZoomMap(z,s.AnimZoomClientX-r.left,s.AnimZoomClientY-r.top,b<1?0:1,true);if(b<1){s.m_AnimZoomRequestID=window.requestAnimationFrame(s.AnimationStep);return;}}s.ZoomMap(1,s.AnimZoomClientX-r.left,s.AnimZoomClientY-r.top,1,true);s.InternalOnMoveLayer(s.m_Canvas[s.m_nOverlayIndex],s.AnimZoomClickCoords);s.InternalOnZoomLayer(s.m_Canvas[s.m_nOverlayIndex],s.AnimZoomClickCoords);s.m_AnimZoomRequestID=0;s.AnimZoomClientX=s.AnimZoomClientY=s.AnimZoomClickCoords=undefined;s.AnimZoomTimestamp=s.AnimZoomDuration=s.AnimZoomOrigin=s.AnimZoomTarget=undefined;};s.AnimateZoom=function(z,a,b,i,e){var d=((e!=undefined&&e.clientX!=undefined)?{x:e.clientX,y:e.clientY}:undefined);s.AnimZoomClientX=a;s.AnimZoomClientY=b;s.AnimZoomClickCoords=d;s.AnimZoomOrigin=s.m_Canvas[0].m_nExactLOD;s.AnimZoomTarget=Math.round(s.AnimZoomTarget?s.AnimZoomTarget:s.AnimZoomOrigin)+(z?1:-1);s.AnimZoomTimestamp=Date.now();s.AnimZoomDuration=Math.pow(Math.abs(s.AnimZoomTarget-s.AnimZoomOrigin),0.8)*300;if(s.m_AnimZoomRequestID){window.cancelAnimationFrame(s.m_AnimZoomRequestID);}s.m_AnimZoomRequestID=window.requestAnimationFrame(s.AnimationStep);};s.AnimationToGeoStep=function(a,l,n,b,d){if(--s.m_nAnimOpenTicks){s.ZoomToZoomlevel(l,n-(s.m_nAnimOpenTicks-1)*(n-b)/(s.m_nAnimTicks-1),true);var e=Date.now(),f=a;if(s.m_AnimTimestamp){var h=Math.max(0,e-s.m_AnimTimestamp);f=Math.max(10,2*a-h);}s.m_AnimTimestamp=e;s.m_AnimZoomTimer=window.setTimeout(function(){s.AnimationToGeoStep(a,l,n,b,d);},f);return;}s.InternalOnZoomLayer(s.m_Canvas[s.m_nOverlayIndex]);if(s.m_AnimZoomTimer){s.m_nAnimOpenTicks=s.m_nAnimationTicks=undefined;window.clearInterval(s.m_AnimZoomTimer);s.m_AnimZoomTimer=null;s.InternalRenderLayer(s.m_Canvas[s.m_nOverlayIndex],false,false,false,s.m_Canvas[0].m_nExactLOD);}};s.AnimateZoomToGeo=function(l,G,i){var n=s.m_Canvas[0].m_nExactLOD;if(n==G){return;}s.m_bNonIntPosStable=false;var a=2*s.m_nTicksInALod;if(s.m_AnimZoomTimer){window.clearInterval(s.m_AnimZoomTimer);}s.m_nAnimTicks=2+Math.abs(Math.round((n-G)*a));s.m_nAnimOpenTicks=s.m_nAnimTicks;var b=n;var d=G;var e=i*a/s.m_nAnimTicks;s.m_AnimZoomTimer=window.setTimeout(function(){s.AnimationToGeoStep(e,l,d,b,a);},e);};s.PerFormMultiSelect=function(e,T){if(s.m_nInputMode!=VBI.InputModeLassoSelect&&s.m_nInputMode!=VBI.InputModeRectSelect){return;}var S,C;if((e.type.indexOf("touch")>=0)||(e.type.indexOf("pointer")>=0)){S=C=false;}else{C=e.ctrlKey;S=e.shiftKey;}var l=s.m_VOS.length;var a=false;var h=[],o=[];var n,b,d,f,i,v;var F=false;for(var j=0;j<l;++j){o[j]=[];h=[];if(s.m_nInputMode==VBI.InputModeLassoSelect&&!s.m_VOS[j].LassoSelect){continue;}if(s.m_nInputMode==VBI.InputModeLassoSelect){F=s.m_VOS[j].LassoSelect(T.m_PosMoves,h,o[j]);}else{F=s.m_VOS[j].RectSelect(T.selectionRect,h,o[j]);}if(F){v=s.m_VOS[j];if(!(i=v.m_DataSource)){continue;}if(!S&&!C&&i){if((d=i.GetCurrentNode(s.m_Ctx))){for(b=0;b<=1;b++){for(n=0;n<d.m_dataelements.length;++n){i.Select(n);if((f=i.GetIndexedElement(s.m_Ctx,n))){if(v.IsSelected(s.m_Ctx)){if(VBI.IndexOf(h,n)==-1){v.Select(f,s.m_Ctx,false);a=true;}}else if(VBI.IndexOf(h,n)!=-1){v.Select(f,s.m_Ctx,true);a=true;}}}}}}else if(S){for(n=0;n<h.length;n++){i.Select(h[n]);if((f=i.GetIndexedElement(s.m_Ctx,h[n]))){if(!v.IsSelected(s.m_Ctx)){v.Select(f,s.m_Ctx,true);a=true;}}}}else if(C){var k=[];for(n=0;n<h.length;n++){i.Select(h[n]);var m={};if(v.IsSelected(s.m_Ctx)){m.toSelect=false;}else{m.toSelect=true;}m.idx=n;k.push(m);}for(b=0;b<=1;b++){for(n=0;n<k.length;n++){i.Select(h[k[n]]);if((f=v.m_DataSource.GetIndexedElement(s.m_Ctx,h[k[n].idx]))){if(b==0&&k[n].toSelect){v.Select(f,s.m_Ctx,true);a=true;}if(b==1&&!k[n].toSelect){v.Select(f,s.m_Ctx,false);a=true;}}}}}}}if(s.m_PreassembledData&&o.length){s.UpdatePreData4SelArray(o);}var p;if(a&&(p=s.m_Ctx.m_Actions)){var q;if((q=p.findAction("Select",s,"General"))){s.m_Ctx.FireAction(q,s,"General",null,null);}}};s.endTrackingMode=function(){if(s.m_nInputMode==VBI.InputModeRectSelect||s.m_nInputMode==VBI.InputModeLassoSelect||s.m_nInputMode==VBI.InputModeRectZoom){s.m_DesignVO.ExitMode();}};s.GetViewport=function(){var z=s.GetStretchFactor4Mode();var r=s.GetInternalDivClientRect();var a=r.width/z[0];var b=r.height/z[1];var P=s.m_Canvas[0].getPixelLeft()/z[0];var d=s.m_Canvas[0].getPixelTop()/z[1];return[-P,-d,-P+a,-d+b];};s.IsTransparent=function(a,b){var C=s.m_Canvas[s.m_nOverlayIndex];if(!C){return false;}var d=C.getContext("2d");var r=C.getBoundingClientRect();var e=Date.now();var p=d.getImageData(Math.round(a-r.left),Math.round(b-r.top),1,1);if(s.m_bObjCanvasMode&&VBI.m_bIsMyChromeTest&&(C.width!=s.m_nlstWidth||C.height!=s.m_nlstHeight)){var f=Date.now()-e;s.m_nlstWidth=C.width;s.m_nlstHeight=C.height;if(f>40){s.m_nGetImageDataIncidents++;if(s.m_nGetImageDataIncidents>2||f>200){s.m_bSwitch2OldCanvasMode=true;}}}var h=p.data[3];return h?false:true;};s.GetCurrentZoomFactors=function(){return[s.m_StretchFactors[0]*s.m_ZoomFactors[0],s.m_StretchFactors[1]*s.m_ZoomFactors[1]];};s.GetStretchFactor4Mode=function(){return s.m_StretchFactors;};s.GetZoomFactor4Mode=function(){return s.m_ZoomFactors;};s.ToggleCanvas=function(s){var a=s.m_Canvas[0];s.m_Canvas[0]=s.m_Canvas[1];s.m_Canvas[1]=a;s.m_Canvas[0].className="vbi-geoscenecanvas vbi-map-inactive";s.m_MapsLayerDiv.insertBefore(s.m_Canvas[1],s.m_Canvas[0]);jQuery.sap.delayedCall(0,this,function(b){if(s.m_Canvas[0]){s.m_Canvas[0].className="vbi-geoscenecanvas vbi-map-active";}});};VBI.addScenePositioningFunctions(s);s.getCanvas=function(){return s.m_Canvas[0];};s.SetEdgeTransition=function(m,e,a,o,b,n,d){m[e+9*o]=1;m[e+9*a]=d;m[e+9*b]=d;m[a+9*e]=d;m[b+9*e]=d;m[e+9*n]=d;m[n+9*e]=d;};s.SetCornerTransition=function(m,a,t,e){m[a+9*t]=e;m[t+9*a]=e;};s.BuildQuarterTransistionTable=function(){var r=[];var i;for(i=0;i<81;++i){r.push(0);}for(i=0;i<9;++i){r[i]=1;r[9*i]=1;}s.SetEdgeTransition(r,3,7,6,8,2,16);s.SetEdgeTransition(r,2,4,1,7,6,8);s.SetEdgeTransition(r,6,4,3,5,1,4);s.SetEdgeTransition(r,1,5,2,8,3,2);s.SetCornerTransition(r,4,8,18);s.SetCornerTransition(r,5,7,24);return r;};s.clearTimers=function(){if(s.m_AnimZoomTimer){window.clearInterval(s.m_AnimZoomTimer);s.m_AnimZoomTimer=null;}};s.clearCanvas=function(n){s.m_Canvas[n].m_Scene=null;s.m_Canvas[n]=null;};s.clearCanvases=function(){for(var n=0,a=s.m_Canvas.length;n<a;++n){s.clearCanvas(n);}s.m_Canvas=[];};s.Remove=function(){if(s.m_Div){s.SetInputMode(VBI.InputModeDefault);while(s.m_Div.firstChild){s.m_Div.removeChild(s.m_Div.firstChild);}s.m_Div.parentElement.removeChild(s.m_Div);s.m_Div=null;s.clearTimers();s.clearCanvases();}if(s.m_Target){while(s.m_Target.firstChild){s.m_Target.removeChild(s.m_Target.firstChild);}s.m_Target=null;}};s.AddCopyright=function(){if(!s.m_MapLayerStack){return;}if(!s.m_DivCopyright){var C=VBI.Utilities.CreateGeoSceneDivCSS(s.m_Target.id+"-copyright","vbi-copyright");C.m_VBIType="C";s.m_MapDecoDiv.appendChild(C);s.m_DivCopyright=C;}var a=s.m_MapLayerStack.GetCopyright();if(a){s.m_DivCopyright.innerHTML=a;}else{s.m_DivCopyright.style.paddingRight=0;s.m_DivCopyright.style.paddingLeft=0;}};s.ReAwake=function(){s.m_MapLayerStack=s.m_RefMapLayerStack;s.AddCopyright();s.resizeCanvas(0,true);};s.Awake=function(t,c,g){s.m_Target=VBI.Utilities.GetDOMElement(t);if(!s.m_Target){s.m_Target=VBI.Utilities.CreateDOMElement(t,"1px","1px");}if(s.m_Div){if(!s.m_Div.children||!s.m_Div.children.length){s.m_awakeFrame={pos:s.GetCenterPos(),lod:s.GetCurrentZoomlevel()};}else{if(s.m_Div.parentNode==s.m_Target){return;}s.m_Target.appendChild(s.m_Div);if(s.m_bNavControlVisible&&s.m_NavControl){s.m_NavControl.AttachEvents();}return;}}s.m_TargetName=t;s.m_MapManager=typeof c!=='undefined'?c:VBI.MapManager;s.m_MapLayerStack=typeof g!=='undefined'?g:s.m_RefMapLayerStack;s.m_Div=VBI.Utilities.CreateGeoSceneDivCSS(t+"-geoscene-viewport","vbi-viewport");s.m_Target.appendChild(s.m_Div);s.m_MoveableLayer=VBI.Utilities.CreateGeoSceneDivCSS(t+"-geoscene-moveable-layer","vbi-moveable-layer");s.m_Div.appendChild(s.m_MoveableLayer);s.m_MapsLayerDiv=VBI.Utilities.CreateGeoSceneDivCSS(t+"-geoscene-mapslayer","vbi-map-layer");s.m_MoveableLayer.appendChild(s.m_MapsLayerDiv);
// add a layer div for map deco like scale and copyright
s.m_MapDecoDiv=VBI.Utilities.CreateGeoSceneDivCSS(t+"-geoscene-decolayer","vbi-structure-layer");s.m_Div.appendChild(s.m_MapDecoDiv);s.m_LegendLayerDiv=VBI.Utilities.CreateGeoSceneDivCSS(t+"-geoscene-legendlayer","vbi-structure-layer");s.m_Div.appendChild(s.m_LegendLayerDiv);s.m_WindowLayerDiv=VBI.Utilities.CreateGeoSceneDivCSS(t+"-geoscene-winlayer","vbi-structure-layer");if(VBI.m_bIsPhone){s.m_Div.appendChild(s.m_WindowLayerDiv);}else{s.m_MoveableLayer.appendChild(s.m_WindowLayerDiv);}s.DoAwake(t);};s.setProjection=function(){if(!s.m_RefMapLayerStack||!s.m_RefMapLayerStack.m_MapLayerArray||!s.m_RefMapLayerStack.m_MapLayerArray.length){return new VBI.MercatorProjection();}var l=s.m_RefMapLayerStack.m_MapLayerArray;var n=l[0].GetMapProvider().m_nProjection;for(var i=2;i<l.length;++i){if(l[i].GetMapProvider().m_nProjection!=n){if(VBI.m_bTrace){VBI.Trace("projection of layer "+i+" is inconsistent to base layer. Choosing projection of base layer");}}}switch(n){case 1:return new VBI.MercatorProjection();case 2:return new VBI.LinearProjection();case 3:return new VBI.ElliMercatorProjection();default:return new VBI.MercatorProjection();}};s.DoAwake=function(t){s.CalculateCanvasDimensions();s.CreateCanvases();
// append copyright
if(!s.m_Ctx.moThumbnail){s.AddCopyright();}var C=s.m_Canvas[s.m_nLabelIndex];if(s.m_Events){s.m_Events.clear();}s.m_Events=new VBI.SceneEvent(this,C.parentElement);if(s.m_bNavControlVisible&&s.m_NavControl){s.m_NavControl.Awake(s,t);}if(s.m_bScaleVisible&&s.m_Scale){s.m_Scale.Awake(s,t);}var e=s.GetMinLOD();if(s.m_startLOD<e){var f=Math.ceil(e);s.m_startLOD=(f-e)<0.6?f:e;}if(s.m_bObjCanvasMode&&VBI.m_bIsMyChromeTest&&!s.m_bObjCanvasModeChecked){s.ChromePerformanceCheck(C);}if(s.m_awakeFrame){s.ZoomToGeoPosition(s.m_awakeFrame.pos,s.m_awakeFrame.lod,true,false,true);s.RenderAsync(true);s.m_awakeFrame=null;}else{s.GoToInitialStart();}if(s.m_nInitialTrackingMode==VBI.InputModeRectSelect){new s.RectSelection();}else if(s.m_nInitialTrackingMode==VBI.InputModeLassoSelect){new s.LassoSelection();}else if(s.m_nInitialTrackingMode==VBI.InputModeRectZoom){new s.RectangularZoom();}s.m_nInitialTrackingMode=VBI.InputModeDefault;};s.ChromePerformanceCheck=function(C){var T=false;var d=[855,672,1512,240,801,901,1222,1392,1023,1024];var o=C.width,a=C.height;var b;var e=C.getContext("2d");C.width=C.height=1024;b=e.getImageData(500,500,1,1);var f,h=Date.now();for(var i=0;i<10;++i){f=Date.now();C.width=C.height=d[i];b=e.getImageData(500,500,1,1);if(Date.now()-f>60){T=true;break;}}C.width=o;C.height=a;if(T||(Date.now()-h>80)){s.m_bObjCanvasMode=0;var r=T?"("+(Date.now()-f)+" ms peak)":"("+((Date.now()-h)/10)+" ms average)";VBI.Trace("Setting Object Canvas Mode to Old Style due to Performance issues "+r);if(VBI.m_bTrace){VBI.Trace("Some Pixel was "+b);}}else{VBI.Trace("Chrome Performance Test passed with "+((Date.now()-h)/10)+" ms average time.");}s.m_bObjCanvasModeChecked=true;};s.CalcCanvasWidth=function(w,a){return(Math.floor(w/a+s.m_nCanvasXOversize))*a;};s.CalcCanvasHeight=function(h,a){return(Math.floor(h/a+s.m_nCanvasYOversize))*a;};s.GetInternalDivWidth=function(){if(this.m_Ctx.moThumbnail&&this.m_Ctx.moThumbnail.nOrgWidth){return this.m_Ctx.moThumbnail.nOrgWidth;}var r=s.m_Div.parentNode.getBoundingClientRect();return r.width?r.width:s.m_Div.clientWidth;};s.GetInternalDivHeight=function(){if(this.m_Ctx.moThumbnail&&this.m_Ctx.moThumbnail.nOrgHeight){return this.m_Ctx.moThumbnail.nOrgHeight;}var r=s.m_Div.parentNode.getBoundingClientRect();return r.height?r.height:s.m_Div.clientHeight;};s.GetPreviewImage=function(m,a){var l=m;if(l.m_PreviewPosition){s.m_MapManager.GetPreviewImage(l.m_PreviewPosition.longitude,l.m_PreviewPosition.latitude,l.m_PreviewPosition.lod,l,s,a);}else{var p=s.m_Ctx.m_Control.getInitialPosition();var b=s.m_Ctx.m_Control.getInitialZoom();var d=p.split(";");s.m_MapManager.GetPreviewImage(d[0],d[1],b,l,s,a);}};s.CalculateCanvasDimensions=function(){var n=s.m_Target.offsetWidth;var m=s.m_MapManager;var d=s.GetInternalDivWidth();var a=s.GetInternalDivHeight();if((d==s.m_nDivWidth)&&(a==s.m_nDivHeight)){return;}s.m_nDivWidth=d;s.m_nDivHeight=a;s.m_nWidthCanvas=s.CalcCanvasWidth(d,m.m_tileWidth);s.m_nHeightCanvas=s.CalcCanvasHeight(a,m.m_tileHeight);s.m_nTilesX=s.m_nWidthCanvas/m.m_tileWidth;s.m_nTilesY=s.m_nHeightCanvas/m.m_tileHeight;m.m_requestTileWidth=m.m_tileWidth;m.m_requestTileHeight=m.m_tileHeight;var l=s.m_MapLayerStack;if(l.m_nMaxSquare&&l.m_MapLayerArray.length){var b=0;for(var i=0;i<l.m_MapLayerArray.length;++i){if(!i||(l.m_MapLayerArray[i].m_refMapProvider.m_nResolution<b)){b=parseInt(l.m_MapLayerArray[i].m_refMapProvider.m_nResolution,10);}}var e=l.m_nMaxSquare*b;if((s.m_nTilesX*m.m_tileWidth>e)||(s.m_nTilesY*m.m_tileHeight>e)){var f=Math.floor(e/Math.max(s.m_nTilesX,s.m_nTilesY));m.m_requestTileWidth=f;m.m_requestTileHeight=f;}}if(VBI.m_bTrace){VBI.Trace("Setting Canvas Size to ("+s.m_nWidthCanvas+","+s.m_nHeightCanvas+") on div with size ("+d+","+a+"). Dummy is "+n);}s.m_nMapMoveXPreLoad=Math.min(120,m.m_tileWidth*(s.m_nTilesX-1)-d);s.m_nMapMoveYPreLoad=Math.min(120,m.m_tileHeight*(s.m_nTilesY-1)-a);s.m_nCanvasStdXPos=(s.m_nWidthCanvas-s.m_nDivWidth)/m.m_tileWidth/2;s.m_nCanvasStdYPos=(s.m_nHeightCanvas-s.m_nDivHeight)/m.m_tileHeight/2;s.m_nMaxPixelBeyondPoles=0;};s.SwitchTmpCanvasToActive=function(){var d=s.m_Canvas[0],a=s.m_Canvas[s.m_nNonDomIndex];var b=d.getContext('2d');b.clearRect(0,0,d.getPixelWidth(),d.getPixelHeight());b.drawImage(s.m_Canvas[s.m_nNonDomIndex],0,0);s.MoveCanvas(d,d.getPixelLeft()-a.m_nOffsetX*d.getPixelWidth()/s.m_nTilesX,d.getPixelTop()-a.m_nOffsetY*d.getPixelHeight()/s.m_nTilesY);d.m_nCurrentX=a.m_nCurrentX;d.m_nCurrentY=a.m_nCurrentY;a.m_bCanvasValid=false;a.m_CanvasRedirect=d;a.m_CanvasRedirRequest=a.m_nRequest;a.m_nOffsetX=a.m_nOffsetY=0;a.m_nTilesBefSwitch=undefined;s.InternalRenderLayer(s.m_Canvas[s.m_nOverlayIndex],false,true,true,d.m_nExactLOD);};s.InitializeCanvas=function(a,n){a.m_Scene=s;a.m_nCurrentLOD=2;a.m_nExactLOD=2;a.m_nCurrentX=undefined;a.m_nCurrentY=undefined;a.m_nAppliedRequest=0;a.m_bInvalid=false;if(a.m_bNotInDOM!=2){if(!n){s.m_MapsLayerDiv.appendChild(a);}else{s.m_MapsLayerDiv.insertBefore(a,n);}}};s.AttachCanvasesToDOM=function(){var a=s.m_Div.firstChild,n;while(a){var b=a.m_VBIType;n=a.nextSibling;if(b=="L"||b=="N"||b=="S"||b=="C"){s.m_Div.removeChild(a);}else if(a.m_VBIHidden){a.m_VBIHidden=false;a.style.display=a.m_VBIOrgDiplay;}a=n;}for(var i=0;i<s.m_Canvas.length;++i){if(s.m_Canvas[i].m_bNotInDOM!=2){s.m_Canvas[i].m_bNotInDOM=!s.m_Canvas[i].m_bNotInDOM;}}s.m_bThumbnailedCanvases=false;if(s.m_bNavControlVisible){s.m_NavControl=new VBI.NavigationControl(s.m_SuppressedNavControlVisibility);s.m_NavControl.AttachEvents();s.m_NavControl.Awake(s,s.m_TargetName);}if(s.m_bScaleVisible){s.m_Scale=new VBI.Scale(s);s.m_Scale.Awake(s,s.m_TargetName);}s.AddCopyright();};s.DetachCanvasesFromDOM=function(){for(var i=0;i<s.m_Canvas.length;++i){if(s.m_Canvas[i].m_bNotInDOM!=2){s.m_Canvas[i].m_bNotInDOM=!s.m_Canvas[i].m_bNotInDOM;}}var a=s.m_TargetName+"-"+s.m_ID+"-";var b=s.m_Div.firstChild,n;while(b){var d=b.m_VBIType;n=b.nextSibling;if(d=="L"||d=="N"||d=="S"||d=="C"){s.m_Div.removeChild(b);}else{b.m_VBIHidden=true;b.m_VBIOrgDiplay=b.style.display;b.style.display='none';}b=n;}var e;if(s.m_nThumbnailIndex){e=s.m_Canvas[s.m_nThumbnailIndex];e.width=s.m_Div.clientWidth;e.setPixelWidth(e.width);e.height=s.m_Div.clientHeight;e.setPixelHeight(e.height);}else{e=VBI.Utilities.CreateGeoSceneCanvas(a+"thumbnail",s.m_Div.clientWidth,s.m_Div.clientHeight,0,false);s.m_ThumbnaiEvents=new VBI.ThumbnailEvent(this,e);s.m_Canvas.push(e);s.m_nThumbnailIndex=s.m_Canvas.length-1;}s.m_Div.appendChild(e);s.m_bThumbnailedCanvases=true;if(s.m_NavControl){s.m_SuppressedNavControlVisibility=s.m_NavControl.suppressedVisibility;s.m_NavControl.clear();s.m_NavControl=null;}if(s.m_Scale){s.m_Scale.clear();s.m_Scale=null;}s.m_DivCopyright=null;};s.CreateCanvases=function(){var i=s.m_TargetName+"-"+s.m_ID+"-";var T=false;if(s.m_Ctx.moThumbnail){T=true;if(!s.m_Ctx.moThumbnail.bThumbnailed){s.m_Ctx.DoMinimize(s);}}s.clearCanvases();s.m_Canvas.push(VBI.Utilities.CreateGeoSceneCanvas(i+"layer1",s.m_nWidthCanvas,s.m_nHeightCanvas,-1,T,"vbi-map-active"));s.m_Canvas.push(VBI.Utilities.CreateGeoSceneCanvas(i+"layer2",s.m_nWidthCanvas,s.m_nHeightCanvas,-1,T,"vbi-map-inactive"));s.m_Canvas.push(VBI.Utilities.CreateGeoSceneCanvas(i+"objectlayer",s.m_nWidthCanvas,s.m_nHeightCanvas,-1,T));s.m_Canvas.push(VBI.Utilities.CreateGeoSceneCanvas(i+"labellayer",s.m_nWidthCanvas,s.m_nHeightCanvas,0,T,undefined,s.ariaLabel));s.m_Canvas.push(VBI.Utilities.CreateGeoSceneCanvas(i+"nondomlayer",s.m_nWidthCanvas,s.m_nHeightCanvas,-1,2));if(T){s.m_Canvas.push(VBI.Utilities.CreateGeoSceneCanvas(i+"thumbnail",s.m_Div.clientWidth,s.m_Div.clientHeight,0,false));s.m_nThumbnailIndex=s.m_Canvas.length-1;s.m_ThumbnaiEvents=new VBI.ThumbnailEvent(this,s.m_Canvas[s.m_nThumbnailIndex]);s.m_bThumbnailedCanvases=true;}s.m_nShadowIndex=undefined;for(var n=0;n<s.m_Canvas.length;++n){s.InitializeCanvas(s.m_Canvas[n]);}s.ToggleCanvas(s);if(s.m_Ctx.moThumbnail){s.DetachCanvasesFromDOM();}if(s.m_nCanvasMaxPixel==undefined){var e=8192;if(VBI.m_bIsMyChromeTest){e=32767;}if(VBI.m_bIsIDevice){e=5120;}if(VBI.m_bIsAndroid){e=16384;}s.m_nCanvasMaxPixel=s.CalculateCanvasMaxPixel(s.m_Canvas[2],e,16384);}};s.CalculateCanvasMaxPixel=function(a,m,b){var o=a.width;var d=a.height;if(m>b-100){return m;}var e=a.getContext("2d");if(s.CanvasSizeTest(a,e,Math.floor(m*1.05))){while(b-m>50){var f=Math.floor((m+b)/2);if(s.CanvasSizeTest(a,e,f)){m=f;}else{b=f;}}}a.width=o;a.height=d;return m;};s.CanvasSizeTest=function(a,b,v){a.height=1024;a.width=v;b.fillStyle="#050000";b.fillRect(v-1,1023,1,1);var p=b.getImageData(v-1,1023,1,1).data;return(p[0]+256*(p[1]+256*p[2])==5);};s.DivIsAlive=function(){var r=s.m_Div.getBoundingClientRect();return(r.width!=0||r.height!=0);};s.resizeCanvas=function(e,f,S){if(!s.DivIsAlive()){return;}if(!s.m_Canvas.length){s.DoAwake();return;}if(s.m_Canvas[s.m_nNonDomIndex].m_bCanvasValid){s.SwitchTmpCanvasToActive();}var m=s.m_MapManager;var a=s.m_Canvas[0];var o=s.m_nDivWidth;var b=s.m_nDivHeight;var d=s.GetMinLODForWidth(o);var h=a.getPixelWidth()/s.m_nWidthCanvas;s.m_nLastRenderLOD=-1;s.CalculateCanvasDimensions();if(s.m_Ctx.moThumbnail){if(!s.m_bThumbnailedCanvases){s.DetachCanvasesFromDOM();}else{var j=s.m_Canvas[s.m_nThumbnailIndex];j.width=s.m_Div.clientWidth;j.height=s.m_Div.clientHeight;j.setPixelWidth(s.m_Div.clientWidth);j.setPixelHeight(s.m_Div.clientHeight);}}else if(s.m_bThumbnailedCanvases){s.AttachCanvasesToDOM();}else if((!f)&&(s.m_nDivWidth==o)&&(s.m_nDivHeight==b)){return;}if(VBI.m_bTrace){VBI.Trace("Resizing ("+(o)+","+(b)+") to ("+(s.m_nDivWidth)+","+(s.m_nDivHeight)+")");}var k=a.m_nCurrentX;var l=a.m_nCurrentY;var n=a.m_nCurrentLOD;var p=a.getPixelLeft()+(s.m_nDivWidth-o)/2;var x=Math.round((-p/m.m_tileWidth-s.m_nCanvasStdXPos)/h);p+=h*x*m.m_tileWidth;var q=a.getPixelTop()+(s.m_nDivHeight-b)/2;var y=Math.round((-q/m.m_tileHeight-s.m_nCanvasStdYPos)/h);q+=h*y*m.m_tileHeight;for(var i=0;i<s.m_Canvas.length;++i){if(i!=s.m_nThumbnailIndex){if(s.m_Canvas[i].width!=s.m_nWidthCanvas){s.m_Canvas[i].width=s.m_nWidthCanvas;}if(s.m_Canvas[i].height!=s.m_nHeightCanvas){s.m_Canvas[i].height=s.m_nHeightCanvas;}}}s.InvalidateCanvas(s.m_Canvas[1]);s.MoveCanvas(a,p,q,h*s.m_nWidthCanvas,h*s.m_nHeightCanvas);s.m_MapManager.RequestTiles(a,s.m_MapLayerStack,k+x,l+y,s.m_nTilesX,s.m_nTilesY,0,0,0,0,n,false);var r=s.m_LastZoomArea;var A=false;if(r!=undefined){var u=new Date().getTime();if((u-r[0])<3000){switch(r[1]){case"Area":s.ZoomToArea(r[2],r[3],r[4],r[5],r[6]);A=true;break;case"Areas":s.ZoomToAreas(r[2],r[3]);A=true;break;default:break;}}}if(!A){var v=s.GetMinLOD();if(a.m_nExactLOD<v){s.ZoomMap(Math.pow(2,v-a.m_nExactLOD)*1.000001,s.m_nDivWidth/2-p,s.m_nDivHeight/2-q);}else if(!S&&a.m_nExactLOD!=Math.floor(a.m_nExactLOD)){s.AnimateZoomToGeo(s.GetCenterPos(),Math.floor(a.m_nExactLOD),5);}else{s.InternalRenderLayer(s.m_Canvas[s.m_nOverlayIndex],false,true,true,a.m_nExactLOD);s.InternalOnMoveLayer(s.m_Canvas[s.m_nOverlayIndex]);}var w=s.GetMaxLOD();if(a.m_nExactLOD>w){s.ZoomMap(Math.pow(2,w-a.m_nExactLOD),s.m_nDivWidth/2-p,s.m_nDivHeight/2-q);}}if((f||(s.GetMinLOD()!=d))&&s.m_NavControl){s.m_NavControl.AdaptMinMaxLOD(s);}if(s.m_bNavControlVisible&&s.m_NavControl){s.m_NavControl.AdjustScrollPoint(s.m_Canvas[0].m_nExactLOD);}s.InternalRenderLayer(s.m_Canvas[s.m_nOverlayIndex],false,false,true,s.m_Canvas[0].m_nExactLOD);};s.showHitMenu=function(e,h){sap.ui.require(["sap/ui/unified/Menu","sap/ui/unified/MenuItem"],function(M,d){var f=s.m_Ctx;if(f.m_strOpenMenu){f.m_Menus.findMenuByID(f.m_strOpenMenu).close();f.m_strOpenMenu=undefined;}if(f.m_HitMenu){f.m_HitMenu.close();f.m_HitMenu.destroy();}var m=new M({maxVisibleItems:5});var p=s.GetEventVPCoordsObj(e);var l=sap.ui.getCore().getConfiguration().getLanguageTag();var i=function(a){var v=a.m_Vo;var b=v.getLabelText(f,a);if(!b||b==""){b=v.getTooltip(f,a);if(!b||b==""){b=v.m_DataSource.m_Path+"."+v.m_DataSource.GetCurrentElement(f).GetKeyValue();}}return b;};h.sort(function(a,b){if(!a.txt){a.txt=i(a);}if(!b.txt){b.txt=i(b);}return a.txt.localeCompare(b.txt,l);});h.forEach(function(a){m.addItem(new d({text:a.txt,select:function(){e.hitCached=a;a.m_Vo["on"+e.m_evName](e);}}));});f.m_HitMenu=m;m.open(true,0,"begin top","begin top",s.m_Div,(parseInt(p.x,10)+5)+" "+(parseInt(p.y,10)+5),"fit");});};VBI.addSceneLassoTrackingFunctions(s);VBI.addSceneRectangularTrackingFunctions(s);s.m_TransitionTable=s.BuildQuarterTransistionTable();if(t){s.Awake(t,c,g);}return s;};
}
},"sap/ui/vbm/library-preload"
);
//# sourceMappingURL=library-preload.js.map