/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["./library","./DrawerToolbarRenderer","sap/ui/core/Control","sap/m/VBox","sap/m/FlexItemData","sap/m/OverflowToolbar","sap/ui/core/Icon","sap/m/Button","sap/m/ToolbarSeparator","sap/m/ToggleButton","sap/m/MenuButton","./tools/Tool","./tools/RotateTurntableTool","./tools/RotateOrbitTool","./tools/RectSelectTool","./tools/CrossSectionTool","sap/m/Menu","sap/m/MenuItem","./ZoomTo","./getResourceBundle","./threejs/Viewport","./Viewport","./DrawerToolbarButton","sap/ui/base/ManagedObjectObserver"],function(v,D,C,V,F,O,I,B,T,a,M,b,R,c,d,e,f,g,Z,h,j,k,l,m){"use strict";var n=C.extend("sap.ui.vk.DrawerToolbar",{metadata:{properties:{expanded:{type:"boolean",defaultValue:true}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getToolbar",aggregation:"content",forwardBinding:true}}},associations:{viewport:{type:"sap.ui.vk.Viewport",multiple:false}},events:{expanded:{parameters:{expand:{type:"boolean"}}}}},constructor:function(i,S){C.apply(this,arguments);}});var o=[{name:"show",unicode:"e000"},{name:"hide",unicode:"e001"},{name:"turntable",unicode:"e002"},{name:"orbit",unicode:"e003"},{name:"pan",unicode:"e004"},{name:"zoom",unicode:"e005"},{name:"fit-to-view",unicode:"e006"},{name:"rectangular-selection",unicode:"e007"},{name:"structure-browser",unicode:"e008"},{name:"configuration",unicode:"e009"},{name:"setting",unicode:"e00a"},{name:"full-screen",unicode:"e00b"},{name:"predefined-views",unicode:"e00c"},{name:"authoring-app",unicode:"e00d"},{name:"dot",unicode:"e00e"},{name:"empty",unicode:"e00f"},{name:"right-panel-menu",unicode:"e010"},{name:"viewer-app",unicode:"e011"},{name:"hide-association",unicode:"e012"},{name:"cross-section",unicode:"e013"},{name:"cross-section-x",unicode:"e014"},{name:"cross-section-z",unicode:"e015"},{name:"cross-section-y",unicode:"e016"},{name:"reverse-direction",unicode:"e017"},{name:"create-editable-visualisation",unicode:"e018"},{name:"cross-section-z-",unicode:"e019"}],q="vk-icons",r="vk-icons";o.forEach(function(i){sap.ui.core.IconPool.addIcon(i.name,q,r,i.unicode);});var s="sap-icon://vk-icons/";n.prototype.init=function(){if(C.prototype.init){C.prototype.init.apply(this);}this._toolbar=new O({width:"auto",design:sap.m.ToolbarDesign.Solid,layoutData:new F({growFactor:0,shrinkFactor:0}),content:this.createButtons()});this._toolbar.ontouchstart=function(i){i.setMarked();};this._toolbarObserver=new m(this._toolbarContentChanged.bind(this));this._toolbarObserver.observe(this._toolbar,{aggregations:["content"]});this._container=new V({renderType:sap.m.FlexRendertype.Bare,alignContent:sap.m.FlexAlignContent.Center,alignItems:sap.m.FlexAlignItems.Center,items:[this._toolbar,new I({src:"sap-icon://navigation-up-arrow",noTabStop:true,press:function(i){this._toggleExpanded();}.bind(this),layoutData:new F({growFactor:0,shrinkFactor:0})}).addStyleClass("drawerToolbarIcon")]});};n.prototype._toolbarContentChanged=function(){var p=this._toolbar.getContent();for(var i=0;i<p.length;i++){if(p[i].getMetadata().getName()=="sap.m.ToolbarSeparator"){if(p[i-1]==undefined||p[i+1]==undefined||p[i-1].getMetadata().getName()=="sap.m.ToolbarSeparator"){this._toolbar.removeContent(i);}}}};n.prototype._getViewport=function(){var i=sap.ui.getCore().byId(this.getViewport());if(i instanceof j){return i;}if(i instanceof k&&i._implementation instanceof j){return i._implementation;}return null;};var t=[null,new THREE.Quaternion().setFromAxisAngle(new THREE.Vector3(0,1,0),0),new THREE.Quaternion().setFromAxisAngle(new THREE.Vector3(0,1,0),Math.PI),new THREE.Quaternion().setFromAxisAngle(new THREE.Vector3(0,1,0),-Math.PI/2),new THREE.Quaternion().setFromAxisAngle(new THREE.Vector3(0,1,0),Math.PI/2),new THREE.Quaternion().setFromAxisAngle(new THREE.Vector3(1,0,0),-Math.PI/2),new THREE.Quaternion().setFromAxisAngle(new THREE.Vector3(1,0,0),Math.PI/2)];n.prototype.createButtons=function(){var i=this;var p,x;function y(S,U,W){p.setPressed(true);if(i._crossSectionTool){i._crossSectionTool.setActive(true,S);if(U!==undefined){i._crossSectionTool.setAxis(U);x.setIcon(s+"cross-section-"+["x","y","z"][U]);}}}p=new a({icon:s+"cross-section",type:sap.m.ButtonType.Transparent,tooltip:"Cross Section",press:function(S){var U=i._getViewport();if(U){if(this.getPressed()){y(U);}else if(i._crossSectionTool){i._crossSectionTool.setActive(false,U);}}}});p.vitId=l.crossSection;x=new M({type:sap.m.ButtonType.Transparent,tooltip:"Cross Section Axis",icon:s+"cross-section-x",menu:new f({items:[new g({icon:s+"cross-section-x",text:"X",press:function(S){var U=i._getViewport();if(U){y(U,0,false);}}}),new g({icon:s+"cross-section-y",text:"Y",press:function(S){var U=i._getViewport();if(U){y(U,1,false);}}}),new g({icon:s+"cross-section-z",text:"Z",press:function(S){var U=i._getViewport();if(U){y(U,2,false);}}}),new g({icon:s+"reverse-direction",text:"Flip",startsSection:true,press:function(S){var U=i._getViewport();if(U&&i._crossSectionTool&&i._crossSectionTool.getActive()){i._crossSectionTool.setFlip(!i._crossSectionTool.getFlip());}}})]})});x.vitId=l.crossSectionAxis;var z=new a({icon:s+"turntable",type:sap.m.ButtonType.Transparent,tooltip:"Turntable",press:function(S){var U=i._getViewport();if(U){i._activateGesture(U,0);}}});z.vitId=l.turntable;var A=new a({icon:s+"orbit",type:sap.m.ButtonType.Transparent,tooltip:"Orbit",pressed:false,press:function(S){var U=i._getViewport();if(U){i._activateGesture(U,1);}}});A.vitId=l.orbit;var E=new a({icon:s+"pan",type:sap.m.ButtonType.Transparent,tooltip:"Pan",press:function(S){var U=i._getViewport();if(U){i._activateGesture(U,2);}}});E.vitId=l.pan;var G=new a({icon:s+"zoom",type:sap.m.ButtonType.Transparent,tooltip:"Zoom",press:function(){var S=i._getViewport();if(S){i._activateGesture(S,3);}}});G.vitId=l.zoom;this._gestureButtons=[z,A,E,G];var H=new B({icon:s+"show",type:sap.m.ButtonType.Transparent,tooltip:"Show",press:function(){var S=i._getViewport();if(S){var U=S._viewStateManager;var W=[];U.enumerateSelection(function(X){W.push(X);});U.setVisibilityState(W,true,false);}}});H.vitId=l.show;var J=new B({icon:s+"hide",type:sap.m.ButtonType.Transparent,tooltip:"Hide",press:function(){var S=i._getViewport();if(S){var U=S._viewStateManager;var W=[];U.enumerateSelection(function(X){W.push(X);});U.setVisibilityState(W,false,false);}}});J.vitId=l.hide;var K=new B({icon:s+"fit-to-view",type:sap.m.ButtonType.Transparent,tooltip:"Fit to View",press:function(){var S=i._getViewport();if(S){S.zoomTo(Z.All,null,0.5,0);}}});K.vitId=l.fitToView;var L=new a({icon:s+"rectangular-selection",type:sap.m.ButtonType.Transparent,tooltip:"Rectangular Selection",press:function(S){var U=i._getViewport();if(U&&i._rectSelectTool){i._rectSelectTool.setActive(this.getPressed(),U);}}});L.vitId=l.rectangularSelection;var N=new M({icon:s+"predefined-views",activeIcon:s+"predefined-views",type:sap.m.ButtonType.Transparent,tooltip:h().getText("PREDEFINED_VIEW_MENUBUTTONTOOLTIP"),menu:new f({items:[new g({text:h().getText("PREDEFINED_VIEW_INITIAL")}),new g({text:h().getText("PREDEFINED_VIEW_FRONT"),startsSection:true}),new g({text:h().getText("PREDEFINED_VIEW_BACK")}),new g({text:h().getText("PREDEFINED_VIEW_LEFT")}),new g({text:h().getText("PREDEFINED_VIEW_RIGHT")}),new g({text:h().getText("PREDEFINED_VIEW_TOP")}),new g({text:h().getText("PREDEFINED_VIEW_BOTTOM")})]}).attachItemSelected(function(S){var U=i._getViewport();if(U){var W=S.getParameters("item").item;var X=this.indexOfItem(W);U._viewportGestureHandler.setView(t[X],1000);}})});N.vitId=l.predefinedViews;var P=new a({icon:s+"full-screen",type:sap.m.ButtonType.Transparent,tooltip:h().getText("VIEWER_FULLSCREENBUTTONTOOLTIP"),press:function(S){var U=i._getViewport();var W=function(Y){return!!(Y.fullScreen||Y.webkitIsFullScreen||Y.mozFullScreen||Y.msFullscreenElement);};if(this.getPressed()){if(!W(document)){if(!i._fullScreenHandler){i._fullScreenHandler=function(S){var Y=W(document);if(!Y){document.removeEventListener("fullscreenchange",i._fullScreenHandler);document.removeEventListener("mozfullscreenchange",i._fullScreenHandler);document.removeEventListener("webkitfullscreenchange",i._fullScreenHandler);document.removeEventListener("MSFullscreenChange",i._fullScreenHandler);this.setPressed(false);U.removeStyleClass("sapVizKitViewerFullScreen");}}.bind(this);}var X=document.getElementsByTagName("body")[0];if(X.requestFullscreen){document.addEventListener("fullscreenchange",i._fullScreenHandler);X.requestFullscreen();}else if(X.webkitRequestFullScreen){document.addEventListener("webkitfullscreenchange",i._fullScreenHandler);X.webkitRequestFullscreen();}else if(X.mozRequestFullScreen){document.addEventListener("mozfullscreenchange",i._fullScreenHandler);X.mozRequestFullScreen();}else if(X.msRequestFullscreen){document.addEventListener("MSFullscreenChange",i._fullScreenHandler);X.msRequestFullscreen();}}U.addStyleClass("sapVizKitViewerFullScreen");}else{if(W(document)){if(document.cancelFullScreen){document.cancelFullScreen();}else if(document.msExitFullscreen){document.msExitFullscreen();}else if(document.mozCancelFullScreen){document.mozCancelFullScreen();}else if(document.webkitCancelFullScreen){document.webkitCancelFullScreen();}}U.removeStyleClass("sapVizKitViewerFullScreen");}}});P.vitId=l.fullscreen;var Q=[H,J,new T(),this._gestureButtons[0],this._gestureButtons[1],this._gestureButtons[2],this._gestureButtons[3],new T(),K,new T(),L,new T(),p,x,new T(),N,new T(),P];return Q;};var u=["drawerToolbarIconTurntable","drawerToolbarIconOrbit","drawerToolbarIconPan","drawerToolbarIconZoom"];var w=function(i,p){this.viewport=i;this._toolbar=p;this._mode=1;this._gesture=false;this._x=0;this._y=0;};w.prototype.beginGesture=function(i){this._gesture=true;if(this._mode<3){this._x=i.points[0].x;this._y=i.points[0].y;}else{this._x=i.x;this._y=i.y;}if(i.event&&(sap.ui.Device.os.macintosh?i.event.metaKey:i.event.ctrlKey)&&this._toolbar._rectSelectTool){var p=this.viewport.getDomRef().getBoundingClientRect();this._selectionRect={x1:this._x-p.left,y1:this._y-p.top,x2:this._x-p.left,y2:this._x-p.top};}};w.prototype.endGesture=function(){this._gesture=false;if(this._selectionRect){this._toolbar._rectSelectTool._select(this._selectionRect.x1,this._selectionRect.y1,this._selectionRect.x2,this._selectionRect.y2,this.viewport,this.viewport.getScene(),this.viewport.getCamera());this._selectionRect=null;this.viewport.setSelectionRect(null);}else{this.viewport.removeStyleClass(u[this._mode]);}};w.prototype.move=function(i){if(this._gesture&&i.n==1){var p=i.points[0];if(this._selectionRect){var x=this.viewport.getDomRef().getBoundingClientRect();this._selectionRect.x2=p.x-x.left;this._selectionRect.y2=p.y-x.top;this.viewport.setSelectionRect(this._selectionRect);}else{this.viewport.addStyleClass(u[this._mode]);var y=p.x-this._x;var z=p.y-this._y;var A=this.viewport._viewportGestureHandler._cameraController;switch(this._mode){case 0:A.rotate(y,z,true);break;case 1:A.rotate(y,z,false);break;case 2:A.pan(y,z);break;case 3:A.zoom(1+z*0.005);break;default:break;}this._x=p.x;this._y=p.y;}i.handled=true;}};w.prototype.hover=function(){};w.prototype.getViewport=function(){return this.viewport;};n.prototype._activateGesture=function(i,p){this._gestureButtons.forEach(function(x,y){x.setPressed(y===p);});if(!this._cameraHandler){this._cameraHandler=new w(i,this);i._loco.addHandler(this._cameraHandler,0);}this._cameraHandler._mode=p;};n.prototype._getToolbar=function(){return this._toolbar;};n.prototype._toggleExpanded=function(){var i=!this.getExpanded();this.setExpanded(i);this.fireExpanded({expand:i});};n.prototype.setExpanded=function(E){this.setProperty("expanded",E,true);var i=this.getDomRef();if(i){if(!E){i.classList.add("drawerToolbarCollapsed");i.classList.remove("drawerToolbarExpanded");this._container.addStyleClass("vboxCollapsed");}else{i.classList.add("drawerToolbarExpanded");i.classList.remove("drawerToolbarCollapsed");this._container.removeStyleClass("vboxCollapsed");}}return this;};n.prototype.onAfterRendering=function(){var i=this._getViewport();if(i){this._activateGesture(i,1);if(!this._crossSectionTool){this._crossSectionTool=new e();i.addTool(this._crossSectionTool);}if(!this._rectSelectTool){this._rectSelectTool=new d();}}};return n;});
