/*
 * ! SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["jquery.sap.global","./ContainerBase","sap/ui/core/IconPool","sap/ui/vbm/lib/sapvbi","sap/ui/Device","./MapContainerRenderer","./MapContainerButtonType","./getResourceBundle"],function(q,C,I,s,D,M,a,g){"use strict";var b=C.extend("sap.ui.vk.MapContainer",{metadata:{library:"sap.ui.vk",properties:{"showNavbar":{type:"boolean",group:"Misc",defaultValue:true},"showHome":{type:"boolean",group:"Misc",defaultValue:true},"showMapLayer":{type:"boolean",group:"Misc",defaultValue:true},"showRectangularZoom":{type:"boolean",group:"Misc",defaultValue:true},"showZoom":{type:"boolean",group:"Misc",defaultValue:true}},aggregations:{"listPanelStack":{type:"sap.ui.vk.ListPanelStack",multiple:false},"scrollCont":{type:"sap.m.ScrollContainer",multiple:false,visibility:"hidden"}},associations:{},events:{}}});b.prototype.init=function(){this._currentText=new sap.m.Text({}).addStyleClass("mapLayerSelectedText");C.prototype.init.apply(this,arguments);var m=new sap.ui.model.json.JSONModel();m.setData({rectZoom:false});this.setModel(m,"rectZoom");this._oNavbar=new sap.m.Toolbar({width:"auto"});this._oScrollCont=new sap.m.ScrollContainer({horizontal:false,vertical:true,focusable:false});this.setAggregation("scrollCont",this._oScrollCont,true);this._oHomeButton=new sap.m.Button({icon:"sap-icon://home",type:sap.m.ButtonType.Transparent,tooltip:g().getText("MAPCONTAINER_HOME"),press:this._onNavbarHome.bind(this)});this._oRectZoomButton=new sap.m.ToggleButton({icon:"sap-icon://draw-rectangle",type:sap.m.ButtonType.Transparent,pressed:"{rectZoom>/rectZoom}",tooltip:g().getText("MAPCONTAINER_RECT_ZOOM")}).setModel(m,"rectZoom");this._oZoomInButton=new sap.m.Button({icon:"sap-icon://add",type:sap.m.ButtonType.Transparent,tooltip:g().getText("MAPCONTAINER_ZOOMIN"),press:this._onNavbarZoomIn.bind(this)});this._oZoomOutButton=new sap.m.Button({icon:"sap-icon://less",type:sap.m.ButtonType.Transparent,tooltip:g().getText("MAPCONTAINER_ZOOMOUT"),press:this._onNavbarZoomOut.bind(this)});if(D.system.phone){this._oMenuOpenButton=new sap.m.Button({layoutData:new sap.m.OverflowToolbarLayoutData({priority:sap.m.OverflowToolbarPriority.NeverOverflow}),icon:"sap-icon://menu2",type:sap.m.ButtonType.Transparent,tooltip:g().getText("CONTAINERBASE_MENU"),press:function(){this._bSegmentedButtonSaveSelectState=true;this._showListPanelStack();}.bind(this)});this._oMenuCloseButton=new sap.m.Button({type:sap.m.ButtonType.Transparent,icon:"sap-icon://nav-back",press:function(){this._bSegmentedButtonSaveSelectState=true;this._hideListPanelStack();}.bind(this)});}};b.prototype.exit=function(){if(this._oNavbar){this._oNavbar.destroy();this._oNavbar=undefined;}if(this._oScrollCont){this._oScrollCont.destroy();this._oScrollCont=undefined;}C.prototype.exit.apply(this,arguments);};b.prototype.getListPanelStack=function(){return this._oScrollCont.getContent()[0];};b.prototype.setListPanelStack=function(p){if(D.system.phone){p.setCollapsible(false);p.setWidth("100%");}this._oScrollCont.removeAllContent();return this._oScrollCont.addContent(p);};b.prototype.onBeforeRendering=function(){C.prototype.onBeforeRendering.apply(this,arguments);this._oNavbar.removeAllContent();var c=this.getSelectedContent();if(c!==null){var d=c.getContent();this._isInstanceGeoAnalytic=d instanceof sap.ui.vbm.GeoMap||d instanceof sap.ui.vbm.AnalyticMap;if(this._isInstanceGeoAnalytic){if(this.getShowHome()){this._oNavbar.addContent(this._oHomeButton);}if(!D.system.phone&&this.getShowRectangularZoom()){this._oNavbar.addContent(this._oRectZoomButton);}if(this.getShowZoom()){this._oNavbar.addContent(this._oZoomInButton);this._oNavbar.addContent(this._oZoomOutButton);}this._shouldRenderListPanel=true;}else{this._shouldRenderListPanel=false;}this._isSupportingMapLayerSwitch=d instanceof sap.ui.vbm.GeoMap&&!(d instanceof sap.ui.vbm.AnalyticMap);if(this._isSupportingMapLayerSwitch&&d.getMapConfiguration()!==null&&this.getShowMapLayer()){var e=d.getMapConfiguration();var l=[].concat(e.MapLayerStacks);if(l.length>1){this._box=new sap.m.HBox({}).addStyleClass("mapContainerHboxPopover");this._popover=new sap.m.Popover({enableScrolling:false,placement:sap.m.PlacementType.Horizontal,content:this._box,showHeader:false});this._selectionMap=new sap.m.Image({width:"4.7rem",press:function(f){if(this._popover.isOpen()){this._popover.close();}else{this._popover.openBy(this._selectionMap);}}.bind(this)}).addStyleClass("mapLayerPopoverItem");}this._shouldRenderMapLayerSwitch=true;}else{this._shouldRenderMapLayerSwitch=false;}}};b.prototype.onAfterRendering=function(){if(D.system.phone){var l=document.getElementById(this.getId()+"-LPW");this.getDomRef().appendChild(l);}C.prototype.onAfterRendering.apply(this,arguments);if(this.getSelectedContent()!==null){var c=this.getSelectedContent().getContent();if(this._isSupportingMapLayerSwitch===true&&c.getMapConfiguration()){var d=c.getMapConfiguration();var e=[].concat(d.MapLayerStacks);if(e.length>1){e.forEach(function(v,i){var f=new sap.ui.layout.VerticalLayout({});var h=c.mVBIContext.GetMainScene();var j=c.mVBIContext.m_MapLayerStackManager.GetMapLayerStack(v.name);var o=new sap.m.Image({width:"4.5rem",press:function(m){this._popover.close();o.setAlt(v.name);var p=m.getSource();var t=p.getAlt();c.setRefMapLayerStack(t);this._currentText.setText(v.name);h.GetPreviewImage(j,function(r){q(".mapLayerPopoverItem").attr("src",r.src);});this._currentMapLayerStackIndex=i;}.bind(this)});var k=new sap.m.Text({text:v.name}).addStyleClass("mapLayerPopoverItemText");o.addStyleClass("layerType");h.GetPreviewImage(j,function(m){o.setSrc(m.src);});h.GetPreviewImage(h.m_MapLayerStack,function(m){q(".mapLayerPopoverItem").attr("src",m.src);});var n=e[this._currentMapLayerStackIndex||0].name;this._currentText.setText(n);this._box.addItem(f);f.addContent(o);f.addContent(k);},this);}}}};b.prototype.setToolbarItem=function(c){if(!c||!c.id){return null;}var o;for(var i=0;i<this._customButtons.length;++i){if(c.id===this._customButtons[i].id){o=this._customButtons[i];o.index=i;this._customButtons.splice(i,1);break;}}if(!o){o={id:c.id,visible:true,active:true,index:this._customButtons.length,type:a.Click};}if("index"in c){o.index=c.index;}if("visible"in c){o.visible=c.visible;}if("overflow"in c){o.overflow=c.overflow;}if("active"in c){o.active=c.active;}if("text"in c){o.text=c.text;}if("tooltip"in c){o.tooltip=c.tooltip;}if("icon"in c){o.icon=c.icon;}if("activeIcon"in c){o.activeIcon=c.activeIcon;}if("press"in c){o.press=c.press;}if("toggled"in c){o.toggled=c.toggled;if(o.button){o.button.setPressed(c.toggled);}}if("type"in c){o.type=c.type;}if(o.index>this._customButtons.length){o.index=this._customButtons.length;}else if(o.index<0){o.index=0;}this._customButtons.splice(o.index,0,o);this.invalidate();return o;};b.prototype.setSelectedContent=function(c){var o;if(this._oSelectedContent){if((o=this._oSelectedContent.getContent())instanceof sap.ui.vbm.GeoMap){o.unbindProperty("rectZoom","rectZoom>/rectZoom");}}C.prototype.setSelectedContent.apply(this,arguments);var n=this._oSelectedContent.getContent();if(n instanceof sap.ui.vbm.GeoMap){n.bindProperty("rectZoom","rectZoom>/rectZoom");}};b.prototype._addToolbarContent=function(){if(D.system.phone){this._oToolbar.addContent(this._oMenuOpenButton);}C.prototype._addToolbarContent.apply(this,arguments);};b.prototype._onNavbarZoomIn=function(e){var c=this.getSelectedContent().getContent();if(c.getZoomlevel&&c.setZoomlevel&&c.setEnableAnimation){c.setEnableAnimation(true);c.setZoomlevel(c.getZoomlevel()+1);}};b.prototype._onNavbarZoomOut=function(e){var c=this.getSelectedContent().getContent();if(c.getZoomlevel&&c.setZoomlevel&&c.setEnableAnimation){c.setEnableAnimation(true);c.setZoomlevel(c.getZoomlevel()-1);}};b.prototype._onNavbarHome=function(e){var c=this.getSelectedContent().getContent();if(c.goToStartPosition){c.goToStartPosition();}};b.prototype._showListPanelStack=function(){q("#"+this.getId()+"-LPW").addClass("sapUiVkMapContainerLPWIn");q("#"+this.getId()+"-wrapper").addClass("sapUiVkMapContainerMapOut");};b.prototype._hideListPanelStack=function(){q("#"+this.getId()+"-LPW").removeClass("sapUiVkMapContainerLPWIn");q("#"+this.getId()+"-wrapper").removeClass("sapUiVkMapContainerMapOut");};return b;});
