/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["jquery.sap.global","./RedlineElement","./Redline"],function(q,R,a){"use strict";var b=R.extend("sap.ui.vk.RedlineElementFreehand",{metadata:{library:"sap.ui.vk",properties:{path:{type:"float[]",defaultValue:null}}}});b.prototype.setPath=function(p){this.setProperty("path",p,true);var d=this.getDomRef();if(d){d.setAttribute("d",this._getProcessedPath());}};b.prototype.edit=function(o,c){var p=this.getParent();var t=p._toVirtualSpace(o,c);var d=this.getPath()||[];d.push(t.x-this.getOriginX(),t.y-this.getOriginY());this.setPath(d);var e=this.getDomRef();if(e){e.setAttribute("d",this._getProcessedPath());}return this;};b.prototype.applyZoom=function(z){this.setProperty("path",this.getPath().map(function(v){return v*z;}),true);return this;};b.prototype._getProcessedPath=function(){var p=this.getParent(),o=p._toPixelSpace(this.getOriginX(),this.getOriginY());var d="";(this.getPath()||[]).forEach(function(e,i){e=p._toPixelSpace(e);if(i===0){d+="M "+(o.x+e);}else if(i===1){d+=" "+(o.y+e);}else{d+=" "+(i%2===0?"L "+(o.x+e):(o.y+e));}});return d;};b.prototype.renderElement=function(r,h){r.write("<path");r.writeElementData(this);r.writeAttribute("d",this._getProcessedPath());r.writeAttribute("stroke",this.getStrokeColor());r.writeAttribute("stroke-width",this.getStrokeWidth());if(this.getStrokeDashArray().length>0){r.writeAttribute("stroke-dasharray",this.getStrokeDashArray().toString());}r.writeAttribute("opacity",this.getOpacity());r.writeAttribute("fill","none");if(h){r.writeAttribute("filter","url(#halo)");}r.write("></path>");};b.prototype.exportJSON=function(){return q.extend(true,R.prototype.exportJSON.call(this),{type:a.ElementType.Freehand,version:1,path:(this.getPath()||[]).slice()});};b.prototype.importJSON=function(j){if(j.type===a.ElementType.Freehand){if(j.version===1){R.prototype.importJSON.call(this,j);if(j.hasOwnProperty("path")){this.setPath(j.path.slice());}}else{q.sap.log.error("wrong version number");}}else{q.sap.log.error("Redlining JSON import: Wrong element type");}return this;};b.prototype.exportSVG=function(){var e=document.createElementNS(a.svgNamespace,"path");e.setAttribute("x",this.getOriginX());e.setAttribute("y",this.getOriginY());e.setAttribute("d",this.getPath());e.setAttribute("fill","none");e.setAttribute("stroke",this.getStrokeColor());e.setAttribute("stroke-width",this.getStrokeWidth());if(this.getStrokeDashArray().length>0){e.setAttribute("stroke-dasharray",this.getStrokeDashArray().toString());}if(this.getOpacity()<1){e.setAttribute("opacity",this.getOpacity());}e.setAttribute("data-sap-element-id",this.getElementId());e.setAttribute("data-sap-halo",this.getHalo());return e;};b.prototype.importSVG=function(s){if(s.tagName==="path"){R.prototype.importSVG.call(this,s);if(s.getAttribute("d")){this.setPath(s.getAttribute("d").split(",").map(parseFloat));}}else{q.sap.log.error("Redlining SVG import: Wrong element type");}return this;};return b;});
