/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["jquery.sap.global","./RedlineElement","./Redline"],function(q,R,a){"use strict";var b=R.extend("sap.ui.vk.RedlineElementText",{metadata:{library:"sap.ui.vk",properties:{text:{type:"string",defaultValue:"Text"},font:{type:"string",defaultValue:""},fontSize:{type:"float",defaultValue:32},fillColor:{type:"sap.ui.core.CSSColor",defaultValue:"rgba(0,0,0,0)"}}}});b.prototype.edit=function(p,c){var d=this.getParent(),e=d._toVirtualSpace(p,c);this.setOriginX(e.x);this.setOriginY(e.y);return this;};b.prototype.applyZoom=function(z){this.setFontSize(this.getFontSize()*z);return this;};b.prototype.renderElement=function(r,h){var p=this.getParent()._toPixelSpace(this.getOriginX(),this.getOriginY());r.write("<text");r.writeElementData(this);r.writeAttribute("x",p.x);r.writeAttribute("y",p.y);if(this.getFont()){r.writeAttribute("font-family",this.getFont());}r.writeAttribute("font-size",this.getFontSize());r.writeAttribute("fill",this.getFillColor());r.writeAttribute("stroke",this.getStrokeColor());r.writeAttribute("stroke-width",this.getStrokeWidth());if(this.getStrokeDashArray().length>0){r.writeAttribute("stroke-dasharray",this.getStrokeDashArray().toString());}r.writeAttribute("opacity",this.getOpacity());if(h){r.writeAttribute("filter","url(#halo)");}r.write(">");r.write(this.getText());r.write("</text>");};b.prototype.exportJSON=function(){return q.extend(true,R.prototype.exportJSON.call(this),{type:a.ElementType.Text,version:1,text:this.getText(),font:this.getFont(),fontSize:this.getFontSize(),fillColor:this.getFillColor()});};b.prototype.importJSON=function(j){if(j.type===a.ElementType.Text){if(j.version===1){R.prototype.importJSON.call(this,j);if(j.hasOwnProperty("text")){this.setText(j.text);}if(j.hasOwnProperty("font")){this.setFont(j.font);}if(j.hasOwnProperty("fontSize")){this.setFontSize(j.fontSize);}if(j.hasOwnProperty("fillColor")){this.setFillColor(j.fillColor);}}else{q.sap.log.error("wrong version number");}}else{q.sap.log.error("Redlining JSON import: Wrong element type");}return this;};b.prototype.exportSVG=function(){var e=document.createElementNS(a.svgNamespace,"text");e.setAttribute("x",this.getOriginX());e.setAttribute("y",this.getOriginY());if(this.getFont()){e.setAttribute("font-family",this.getFont());}e.setAttribute("font-size",this.getFontSize());e.setAttribute("fill",this.getFillColor());e.setAttribute("stroke",this.getStrokeColor());e.setAttribute("stroke-width",this.getStrokeWidth());if(this.getStrokeDashArray().length>0){e.setAttribute("stroke-dasharray",this.getStrokeDashArray().toString());}if(this.getOpacity()<1){e.setAttribute("opacity",this.getOpacity());}e.setAttribute("data-sap-element-id",this.getElementId());e.setAttribute("data-sap-halo",this.getHalo());e.textContent=this.getText();return e;};b.prototype.importSVG=function(e){if(e.tagName==="text"){R.prototype.importSVG.call(this,e);if(e.getAttribute("x")){this.setOriginX(parseFloat(e.getAttribute("x")));}if(e.getAttribute("y")){this.setOriginY(parseFloat(e.getAttribute("y")));}if(e.getAttribute("text")){this.setText(e.getAttribute("text"));}if(e.getAttribute("font-family")){this.setFont(e.getAttribute("font-family"));}if(e.getAttribute("font-size")){this.setFontSize(parseFloat(e.getAttribute("font-size")));}if(e.getAttribute("fill")){this.setFillColor(e.getAttribute("fill"));}}else{q.sap.log("Redlining SVG import: Wrong element type");}return this;};return b;});
