/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["./library","sap/ui/core/Control","sap/ui/table/TreeTable","sap/ui/table/Column","sap/ui/model/json/JSONModel","sap/ui/core/ResizeHandler","sap/m/Title","sap/m/SearchField","sap/m/Toolbar","sap/m/ToolbarLayoutData","sap/m/ToolbarSpacer","sap/m/Text","sap/ui/core/Icon","./ContentConnector","./ViewStateManager","./SceneTreeRenderer","./getResourceBundle"],function(v,C,T,a,J,R,b,S,c,d,e,f,I,g,V,h,j){"use strict";var k=C.extend("sap.ui.vk.SceneTree",{metadata:{library:"sap.ui.vk",properties:{title:{type:"string",defaultValue:j().getText("SCENETREE_TITLE")},showTitle:{type:"boolean",defaultValue:true},showSearchField:{type:"boolean",defaultValue:true}},aggregations:{treeTable:{type:"sap.ui.table.TreeTable",multiple:false}},associations:{contentConnector:{type:"sap.ui.vk.ContentConnector",multiple:false},viewStateManager:{type:"sap.ui.vk.ViewStateManager",multiple:false}},events:{contentChanged:{enableEventBubbling:true}}}});var m="sap-icon://show",n="sap-icon://hide";var t=j().getText("SCENETREE_VISIBILITYSTATEVISIBLE"),o=j().getText("SCENETREE_VISIBILITYSTATEHIDDEN");k.prototype._createNodeForSceneTree=function(i,l,p){var q=p.getVisibilityState(l);return{name:i,id:l,visible:q};};k.prototype.setScene=function(s,i){this.setViewStateManager(i);this._setScene(s);};k.prototype._setScene=function(s){this._scene=s;this.refresh();};k.prototype.init=function(){if(C.prototype.init){C.prototype.init.apply(this);}var i=this;this._title=new b({width:"100%",textAlign:sap.ui.core.TextAlign.Center,text:this.getTitle()});this._searchField=new S({layoutData:new d({shrinkable:true,maxWidth:"400px"}),search:function(p){var q=p.getParameter("query"),r=i._scene.getDefaultNodeHierarchy(),s=i._viewStateManager;if(r&&s){var u=!q?[]:r.findNodesByName({value:q,predicate:"contains"});var w=new Set(u);var x=[];s.enumerateSelection(function(y){if(!w.has(y)){x.push(y);}});s.setSelectionState(x,false,false);s.setSelectionState(u,true,false);}}});this._toolbar=new c({content:[this._title,new e(),this._searchField]});var l=new I({src:m,tooltip:t,width:"2em",height:"1.3em",size:"1.2em",press:function(p){var q=this.getSrc()!==m;this.setSrc(q?m:n);this.setTooltip(q?t:o);i._toggleVisibilityForAllChildren(i._model.getData(),q);}});this._tree=new T({title:this._toolbar,columnHeaderHeight:32,columns:[new a({label:j().getText("SCENETREE_NAME"),tooltip:j().getText("SCENETREE_NAME"),template:new f({text:"{name}",maxLines:1,tooltip:"{name}"}),resizable:false}),new a(this.getId()+"-visibilityColumn",{label:l,template:new I({src:{path:"",formatter:function(p){if(!p){return null;}return p.visible?m:n;}},tooltip:{path:"",formatter:function(p){if(!p){return null;}return p.visible?t:o;}},height:"1.3em",size:"1.2em",press:function(p){var q=i._tree.getContextByIndex(this.getParent().getIndex());var r=q?q.getObject():null;if(r){i._viewStateManager.setVisibilityState(r.id,!r.visible,false);}}}),width:"2.5em",resizable:false,hAlign:"Center"})],enableSelectAll:false,selectionMode:"MultiToggle",selectionBehavior:"RowSelector",visibleRowCountMode:"Fixed",expandFirstLevel:false,collapseRecursive:false,rowHeight:32});this.setAggregation("treeTable",this._tree);this.attachContentChanged(function(p){l.setSrc(m);l.setTooltip(t);});this._scene=null;this._syncing=false;this._updateSelectionTimer=0;this._updateVisibilityTimer=0;this._model=new J();this._tree.setModel(this._model);this._tree.bindRows({path:"/"});this._tree.attachRowSelectionChange(this._handleRowSelectionChange.bind(this));this._tree.attachFirstVisibleRowChanged(this._updateSelection.bind(this));this._tree.getBinding("rows").attachChange(this._dataChange.bind(this));};k.prototype.setTitle=function(i){this.setProperty("title",i,true);this._title.setText(i);return this;};k.prototype.setShowTitle=function(i){this.setProperty("showTitle",i,true);this._title.setVisible(i);this._updateTitleBar();return this;};k.prototype.setShowSearchField=function(i){this.setProperty("showSearchField",i,true);this._searchField.setVisible(i);this._updateTitleBar();return this;};k.prototype._updateTitleBar=function(){this._tree.setTitle(this.getShowTitle()||this.getShowSearchField()?this._toolbar:null);this._handleResize();};k.prototype.onBeforeRendering=function(){this._tree.setVisible(true);if(!this._resizeListenerId){this._resizeListenerId=R.register(this,this._handleResize.bind(this));}};k.prototype._handleRowSelectionChange=function(l){if(this._syncing||this._tree.getBinding("rows")._aSelectedContexts!=undefined){return;}var s=[];var p=[];var r=l.getParameter("rowIndices");for(var i in r){var q=r[i];var u=this._tree.getContextByIndex(q);var w=u?u.getObject().id:null;if(w){(this._tree.isIndexSelected(q)?s:p).push(w);}}if(s.length>0){this._viewStateManager.setSelectionState(s,true);}if(p.length>0){this._viewStateManager.setSelectionState(p,false);}};k.prototype._handleSelectionChanged=function(p){if(this._syncing){return;}function q(r,u){var w=r.getBinding("rows");if(w){for(var i=r.getFirstVisibleRow(),l=Math.min(i+r.getVisibleRowCount(),w.getLength());i<l;i++){var x=w.getContextByIndex(i);if(x&&x.getObject().id===u){return true;}}}return false;}var s=p.getParameter("selected");if(s.length===1&&!q(this._tree,s[0])){if(this._updateSelectionTimer>0){clearTimeout(this._updateSelectionTimer);this._updateSelectionTimer=0;}this._expandToNode(s[0],this._updateSelection.bind(this));}else if(this._updateSelectionTimer===0){this._updateSelectionTimer=setTimeout(this._updateSelection.bind(this),0);}};k.prototype._updateSelection=function(){this._updateSelectionTimer=0;if(this._syncing){return;}this._syncing=true;var p=this._viewStateManager,q=this._tree,r=q.getBinding("rows");if(p&&r){for(var i=q.getFirstVisibleRow(),l=Math.min(i+q.getVisibleRowCount(),r.getLength());i<l;i++){var s=r.getContextByIndex(i);if(s){var u=s.getObject().id;if(u){var w=p.getSelectionState(u);if(w!=q.isIndexSelected(i)){q[w?"addSelectionInterval":"removeSelectionInterval"](i,i);}}}}}this._syncing=false;};k.prototype._expandToNode=function(i,l){var p={tree:this._tree,rows:this._tree.getBinding("rows"),index:0,nodeRef:i,ancestors:new Set(this._scene.getDefaultNodeHierarchy().getAncestors(i)),callback:l};function s(r,u,w){var x=r.getFirstVisibleRow(),y=r.getVisibleRowCount();if((u<x)||(u>=(x+y))){x=Math.min(Math.max(u-(y>>1),0),w-y);setTimeout(function(){r.setFirstVisibleRow(x);},0);}}function q(p,r){if(r&&r.getParameter("reason")!=="expand"){return;}var u=p.rows.getLength();while(p.index<u){var w=p.rows.getContextByIndex(p.index);if(!w){break;}var i=w.getObject().id;if(i===p.nodeRef){s(p.tree,p.index,u);break;}if(p.ancestors.has(i)&&!p.tree.isExpanded(p.index)){p.tree.expand(p.index++);return;}p.index++;}p.rows.detachChange(p.expandHandlerProxy);p.callback();}p.expandHandlerProxy=q.bind(this,p);p.rows.attachChange(p.expandHandlerProxy);q(p);};k.prototype._dataChange=function(i){var r=i.getParameter("reason");if((r==="expand"||r==="collapse")&&this._updateSelectionTimer===0){this._updateSelectionTimer=setTimeout(this._updateSelection.bind(this),0);}};k.prototype._toggleVisibilityForAllChildren=function(l,p){var q=l.hasOwnProperty("children")?l.children:l;for(var i=0;q[i]!=null;i++){this._viewStateManager.setVisibilityState(q[i].id,p,false);}};k.prototype._handleVisibilityChanged=function(i){if(this._updateVisibilityTimer===0){this._updateVisibilityTimer=setTimeout(this._updateVisibility.bind(this),0);}};k.prototype._updateVisibility=function(){this._updateVisibilityTimer=0;this._getNodeVisibilityRecursive(this._model.getData());this._tree.getModel().refresh(true);};k.prototype._getNodeVisibilityRecursive=function(l){if(l.id!=null){l.visible=this._viewStateManager.getVisibilityState(l.id);}var p=l.hasOwnProperty("children")?l.children:l;for(var i=0;p[i]!=null;i++){this._getNodeVisibilityRecursive(p[i]);}};k.prototype._handleResize=function(i){var l=i?i.size.height:this.getDomRef().clientHeight;var p=this._tree.getTitle()?2.1:1.1;this._tree.setVisibleRowCount(Math.max(Math.floor(l/(this._tree.getRowHeight()+1)-p),0));this._updateSelection();};k.prototype.refresh=function(){if(!this._scene||!this._viewStateManager||!this._viewStateManager.getNodeHierarchy()){this._model.setData([]);return;}var i=this._scene.getDefaultNodeHierarchy();var l=[];var p=function(l,q){q.forEach(function(r){if(r.userData&&r.userData.skipIt){p(l,i.getChildren(r));}else{var s=i.createNodeProxy(r);var u=this._createNodeForSceneTree(s.getName(),s.getNodeRef(),this._viewStateManager);l.push(u);i.destroyNodeProxy(s);u.children=[];p(u.children,i.getChildren(r));}}.bind(this));}.bind(this);p(l,i.getChildren());this._model.setData(l);this._tree.setModel(this._model);this._tree.bindRows({path:"/",parameters:{arrayNames:["children"]}});this._tree.getBinding("rows").attachChange(this._dataChange.bind(this));this.fireContentChanged();};k.prototype._onBeforeClearContentConnector=k.prototype._onBeforeClearViewStateManager=function(){this._setScene(null);};k.prototype._onAfterUpdateContentConnector=k.prototype._onAfterUpdateViewStateManager=function(){if(this._contentConnector){this._setContent(this._contentConnector.getContent());}};k.prototype._setContent=function(i){this._setScene(i);};k.prototype._handleContentReplaced=function(i){this._setContent(i.getParameter("newContent"));};k.prototype._handleNodeHierarchyReplaced=function(i){this._setScene(this._scene);};k.prototype._handleContentChangesFinished=function(i){this.refresh();};g.injectMethodsIntoClass(k);V.injectMethodsIntoClass(k);return k;});
