/*
 * ! SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["jquery.sap.global","./library","sap/ui/core/Control","./Scene","./ContentResource","./ContentConnector","./dvl/ContentManager","./FlexibleControl","sap/m/VBox","sap/m/FlexItemData","sap/ui/layout/Splitter","sap/ui/layout/SplitterLayoutData","./DvlException","./Messages","./ProgressIndicator","./Notifications","./ViewStateManager","./Toolbar","./SceneTree","./StepNavigation","./ViewGallery","./Viewport","./NativeViewport","./RedlineDesign","./ViewerRenderer","./SelectionMode","./getResourceBundle","./cssColorToColor","./colorToCSSColor","./abgrToColor","./colorToABGR"],function(q,v,C,S,a,b,D,F,V,c,d,e,f,M,P,N,g,T,h,j,k,m,n,R,o,p,r,s,t,u,w){"use strict";var x=q.sap.log;var y=C.extend("sap.ui.vk.Viewer",{metadata:{library:"sap.ui.vk",properties:{enableOverlay:{type:"boolean",defaultValue:false},enableSceneTree:{type:"boolean",defaultValue:true},showSceneTree:{type:"boolean",defaultValue:true},enableStepNavigation:{type:"boolean",defaultValue:true},enableNotifications:{type:"boolean",defaultValue:true},showStepNavigation:{type:"boolean",defaultValue:false},showStepNavigationThumbnails:{type:"boolean",defaultValue:true},overlayStepNavigation:{type:"boolean",defaultValue:false},enableToolbar:{type:"boolean",defaultValue:true},enableProgressIndicator:{type:"boolean",defaultValue:true},width:{type:"sap.ui.core.CSSSize",defaultValue:null},height:{type:"sap.ui.core.CSSSize",defaultValue:null},toolbarTitle:{type:"string",defaultValue:""},shouldTrackVisibilityChanges:{type:"boolean",defaultValue:false},recursiveSelection:{type:"boolean",defaultValue:false},runtimeSettings:{type:"object",defaultValue:{}},webGLContextAttributes:{type:"object",defaultValue:{antialias:true,alpha:true,premultipliedAlpha:false}},showAllHotspots:{type:"boolean",defaultValue:false},hotspotColorABGR:{type:"int",defaultValue:0xc00000ff},hotspotColor:{type:"sap.ui.core.CSSColor",defaultValue:"rgba(255, 0, 0, 0.7529411764705882)"}},aggregations:{contentResources:{type:"sap.ui.vk.ContentResource",forwarding:{getter:"_getContentConnector",aggregation:"contentResources"}},overlay:{type:"sap.ui.vk.Overlay",multiple:false},progressIndicator:{type:"sap.ui.vk.ProgressIndicator",multiple:false,visibility:"hidden"},layout:{type:"sap.m.VBox",multiple:false,visibility:"hidden"},contentConnector:{type:"sap.ui.vk.ContentConnector",multiple:false,visibility:"hidden"},viewStateManager:{type:"sap.ui.vk.ViewStateManager",multiple:false,visibility:"hidden"}},defaultAggregation:"contentResources",events:{contentResourceChangesProcessed:{},sceneLoadingSucceeded:{parameters:{scene:{type:"sap.ui.vk.Scene"}}},sceneLoadingFailed:{parameters:{reason:{type:"object"}}},sceneDestroying:{parameters:{scene:{type:"sap.ui.vk.Scene"},preventGarbageCollection:{type:"function"}}},selectionChanged:{parameters:{selected:{type:"any[]"},unselected:{type:"any[]"}}},fullScreen:{parameters:{isFullScreen:{type:"boolean"}}},urlClicked:{parameters:{nodeRef:"any",url:"string"}},nodeClicked:{parameters:{nodeRef:"any",x:"int",y:"int"}}}}});y.prototype.applySettings=function(i){this._inApplySettings=true;C.prototype.applySettings.apply(this,arguments);delete this._inApplySettings;if(this._viewStateManager){this._viewStateManager.setShouldTrackVisibilityChanges(this.getShouldTrackVisibilityChanges());this._viewStateManager.setRecursiveSelection(this.getRecursiveSelection());}this._componentsState={sceneTree:{defaultEnable:this.getEnableSceneTree(),shouldBeEnabled:true,userInteractionShow:this.getShowSceneTree()},stepNavigation:{defaultEnable:this.getEnableStepNavigation(),userInteractionShow:this.getShowStepNavigation()},progressIndicator:{defaultEnable:this.getEnableProgressIndicator()},messagePopover:{defaultEnable:this.getEnableNotifications()}};this.setEnableSceneTree(false);this.setEnableStepNavigation(false);};y.prototype.init=function(){if(C.prototype.init){C.prototype.init.apply(this);}this._contentConnector=new b(this.getId()+"-contentconnector");this.setAggregation("contentConnector",this._contentConnector);this._contentConnector.attachContentReplaced(this._handleContentReplaced,this);this._contentConnector.attachContentChangesStarted(this._handleContentChangesStarted,this);this._contentConnector.attachContentChangesFinished(this._handleContentChangesFinished,this);this._contentConnector.attachContentChangesProgress(this._handleContentChangesProgress,this);this._viewStateManager=new g(this.getId()+"-viewstatemanager",{contentConnector:this._contentConnector});this.setAggregation("viewStateManager",this._viewStateManager);x.debug("sap.ui.vk.Viewer.init() called.");this._mainScene=null;this._busyIndicatorCounter=0;this._viewport=null;this._nativeViewport=null;this._redlineDesign=null;this._stepNavigation=null;this._sceneTree=null;this._overlayManager={initialized:false,changed:false,control:null,onNativeViewportMove:function(i){var l=i.getParameter("pan");var A=i.getParameter("zoom");this.control.setPanAndZoom(l.x,l.y,A);},onViewportZoom:function(i){var l=i.getParameter("zoomFactor");this.control.setPanAndZoom(0,0,l);},onViewportPan:function(i){var l=i.getParameter("dx");var A=i.getParameter("dy");this.control.setPanAndZoom(l,A,1);}};this._overlayManager.delegate={onAfterRendering:this._onAfterRenderingOverlay.bind(this,this._viewport,this._nativeViewport,this._overlayManager)};this._toolbar=new T({title:this.getToolbarTitle(),visible:this.getEnableToolbar(),viewer:this});this._stackedViewport=new F(this.getId()+"-stackedViewport",{width:"100%",height:"100%",layout:"Stacked",layoutData:new e({size:"auto",minSize:200})});this._splitter=new d(this.getId()+"-splitter",{layoutData:new sap.m.FlexItemData({growFactor:1,minHeight:"200px"}),contentAreas:[this._stackedViewport]}).addStyleClass("sapUiVizKitSplitter");this._messagePopover=new N({visible:true});this._messagePopover.attachAllMessagesCleared(this._updateLayout,this);this._messagePopover.attachMessageAdded(this._updateLayout,this);this._layout=new V(this.getId()+"-vbox",{height:"100%",items:[this._toolbar,this._splitter,this._messagePopover]}).addStyleClass("sapUiVizKitLayout");this.setAggregation("layout",this._layout);this.setTooltip(r().getText("VIEWER_TITLE"));if(this.getEnableProgressIndicator()){this._progressIndicator=new P({visible:false}).addStyleClass("sapUiVizKitProgressIndicator");this.setAggregation("progressIndicator",this._progressIndicator);}};y.prototype.exit=function(){x.debug("sap.ui.vk.Viewer.exit() called.");if(this._viewport){this._viewport.detachEvent("viewActivated",this._onViewportViewActivated,this);this._viewport.destroy();this._viewport=null;}if(this._nativeViewport){this._nativeViewport.destroy();this._nativeViewport=null;}this._setMainScene(null);this._toolbar=null;this._messagePopover=null;this._sceneTree=null;this._stepNavigation=null;this._componentsState=null;this._viewStateManager=null;this._contentConnector=null;if(C.prototype.exit){C.prototype.exit.apply(this);}};y.prototype._setMainScene=function(i){if(i){if(i!==this._mainScene){this._mainScene=i;this._showViewport();if(this._componentsState.sceneTree.defaultEnable){this._instantiateSceneTree();this.setEnableSceneTree(true);if(this._componentsState.sceneTree.userInteractionShow&&this._componentsState.sceneTree.shouldBeEnabled){this.setShowSceneTree(true);this._sceneTree.setVisible(true);}else{this.setShowSceneTree(false);}}else if(this._sceneTree&&this._viewStateManager){this._sceneTree.setScene(i,this._viewStateManager);}this.setEnableStepNavigation(this.getEnableStepNavigation()||this._componentsState.stepNavigation.defaultEnable);if(this.getEnableStepNavigation()){this._instantiateStepNavigation();this.setShowStepNavigation(this._componentsState.stepNavigation.userInteractionShow);}}if(this._stepNavigation){this._stepNavigation.refresh(i);}}else{this._mainScene=null;this.setEnableSceneTree(false);this.setEnableStepNavigation(false);}return this;};y.prototype.getGraphicsCore=function(){return this._mainScene instanceof v.dvl.Scene?this._mainScene.getGraphicsCore():null;};y.prototype.getScene=function(){return this._mainScene;};y.prototype.getViewStateManager=function(){return this._viewStateManager;};y.prototype.getViewport=function(){if(!this._viewport){this._viewport=new m(this.getId()+"-viewport",{viewStateManager:this._viewStateManager,selectionMode:p.Exclusive,contentConnector:this._contentConnector});this._viewport.attachEvent("viewActivated",this._onViewportViewActivated,this);}return this._viewport;};y.prototype.getNativeViewport=function(){return this._nativeViewport;};y.prototype.getToolbar=function(){return this._toolbar;};y.prototype.getSceneTree=function(){return this._sceneTree;};y.prototype.getRedlineDesign=function(){return this._redlineDesign;};y.prototype.getOverlay=function(){return this._overlayManager.control;};y.prototype.setEnableOverlay=function(i){if(i!==this.getProperty("enableOverlay")){this.setProperty("enableOverlay",i);this._overlayManager.changed=true;}return this;};y.prototype.setEnableSceneTree=function(i){this.setProperty("enableSceneTree",i,true);if(!i){this.setProperty("showSceneTree",false);}this._updateLayout();return this;};y.prototype.setEnableNotifications=function(i){this.setProperty("enableNotifications",i,true);this._messagePopover.setVisible(false);this._updateLayout();return this;};y.prototype.setShowSceneTree=function(i){this.setProperty("showSceneTree",i,true);this._updateLayout();return this;};y.prototype.setEnableStepNavigation=function(i){this.setProperty("enableStepNavigation",i,true);if(!i){this.setProperty("showStepNavigation",false);}this._updateLayout();return this;};y.prototype.setShowStepNavigation=function(i){this.setProperty("showStepNavigation",i,true);this._updateLayout();return this;};y.prototype.setEnableToolbar=function(i){this.setProperty("enableToolbar",i,true);this._toolbar.setVisible(i);return this;};y.prototype.setRecursiveSelection=function(i){this.setProperty("recursiveSelection",i,true);if(this._viewStateManager){this._viewStateManager.setRecursiveSelection(i);}return this;};y.prototype.setToolbarTitle=function(i){this.setProperty("toolbarTitle",i);this._toolbar.setTitle(i);return this;};y.prototype.activateFullScreenMode=function(i){var l=function(E){return!!(E.fullScreen||E.webkitIsFullScreen||E.mozFullScreen||E.msFullscreenElement);};if(i){if(!l(document)){if(!this._fullScreenHandler){var A=this;this._fullScreenHandler=function(E){var G=l(document);if(!G){A.removeStyleClass("sapVizKitViewerFullScreen");document.removeEventListener("fullscreenchange",A._fullScreenHandler);document.removeEventListener("mozfullscreenchange",A._fullScreenHandler);document.removeEventListener("webkitfullscreenchange",A._fullScreenHandler);document.removeEventListener("MSFullscreenChange",A._fullScreenHandler);}A.fireFullScreen({isFullScreen:G});};}var B=document.getElementsByTagName("body")[0];if(B.requestFullScreen){document.addEventListener("fullscreenchange",this._fullScreenHandler);B.requestFullScreen();}else if(B.webkitRequestFullScreen){document.addEventListener("webkitfullscreenchange",this._fullScreenHandler);B.webkitRequestFullScreen();}else if(B.mozRequestFullScreen){document.addEventListener("mozfullscreenchange",this._fullScreenHandler);B.mozRequestFullScreen();}else if(B.msRequestFullscreen){document.addEventListener("MSFullscreenChange",this._fullScreenHandler);B.msRequestFullscreen();}}this.addStyleClass("sapVizKitViewerFullScreen");}else{if(l(document)){if(document.cancelFullScreen){document.cancelFullScreen();}else if(document.webkitCancelFullScreen){document.webkitCancelFullScreen();}else if(document.mozCancelFullScreen){document.mozCancelFullScreen();}else if(document.msExitFullscreen){document.msExitFullscreen();}}this.removeStyleClass("sapVizKitViewerFullScreen");}return this;};function z(i){if(!i){return false;}return i instanceof v.dvl.Viewport;}y.prototype.getShowAllHotspots=function(){var i=this.getViewport().getImplementation();return z(i)?i.getShowAllHotspots():this.getProperty("showAllHotspots");};y.prototype.setShowAllHotspots=function(i){this.setProperty("showAllHotspots",i,true);var l=this.getViewport().getImplementation();if(z(l)){l.setShowAllHotspots(i);}return this;};y.prototype.getHotspotColorABGR=function(){var i=this.getViewport().getImplementation();return z(i)?i.getHotspotColorABGR():this.getProperty("hotspotColorABGR");};y.prototype.setHotspotColorABGR=function(i){this.setProperty("hotspotColorABGR",i,true);this.setProperty("hotspotColor",t(u(i)),true);var l=this.getViewport().getImplementation();if(z(l)){l.setHotspotColorABGR(i);}return this;};y.prototype.getHotspotColor=function(){var i=this.getViewport().getImplementation();return z(i)?i.getHotspotColor():this.getProperty("hotspotColor");};y.prototype.setHotspotColor=function(i){this.setProperty("hotspotColor",i,true);this.setProperty("hotspotColorABGR",w(s(i)),true);var l=this.getViewport().getImplementation();if(z(l)){l.setHotspotColor(i);}return this;};y.prototype.setRuntimeSettings=function(i){if(this._inApplySettings){this.setProperty("runtimeSettings",i,true);D.setRuntimeSettings(i);}else{x.error(r().getText(M.VIT29.summary),M.VIT29.code,"sap.ui.vk.Viewer");}return this;};y.prototype.setWebGLContextAttributes=function(i){if(this._inApplySettings){this.setProperty("webGLContextAttributes",i,true);D.setWebGLContextAttributes(i);}else{x.error(r().getText(M.VIT30.summary),M.VIT30.code,"sap.ui.vk.Viewer");}return this;};y.prototype.invalidate=function(i){if(i instanceof a){this._contentConnector.invalidate(i);return;}C.prototype.invalidate.apply(this,arguments);};y.prototype._getContentConnector=function(){return this._contentConnector;};y.prototype.onBeforeRendering=function(){this._showOverlay();};y.prototype.isTreeBinding=function(i){return i==="contentResources";};y.prototype.setBusy=function(i){if(i){if(this._busyIndicatorCounter===0){this.setBusyIndicatorDelay(0);C.prototype.setBusy.call(this,true);}this._busyIndicatorCounter+=1;}else{this._busyIndicatorCounter-=1;if(this._busyIndicatorCounter==0){C.prototype.setBusy.call(this,false);}}};y.prototype._updateLayout=function(){if(this._sceneTree){if(this.getShowSceneTree()&&this.getEnableSceneTree()){this._sceneTree.setVisible(true);if(this._splitter.indexOfContentArea(this._sceneTree)<0){this._splitter.insertContentArea(this._sceneTree,0);}}else{if(this._splitter.indexOfContentArea(this._sceneTree)>=0){this._splitter.removeContentArea(this._sceneTree);}this._sceneTree.setVisible(false);}}if(this._stepNavigation){this._stepNavigation.setVisible(this.getShowStepNavigation()&&this.getEnableStepNavigation());}if(this._messagePopover){this._messagePopover.setVisible(this.getEnableNotifications()&&this._messagePopover.getAggregation("_messagePopover").getItems().length>0);}if(this._toolbar){this._toolbar.refresh();}};y.prototype._instantiateSceneTree=function(){if(!this._sceneTree){this._sceneTree=new h({layoutData:new e({size:"320px",minSize:200}),viewStateManager:this._viewStateManager,contentConnector:this._contentConnector});}return this;};y.prototype._instantiateStepNavigation=function(){if(this._stepNavigation){this._layout.removeItem(this._stepNavigation);this._viewport.removeContent(this._stepNavigation);this._splitter.detachResize(this._handleSplitterResize,this);this._stepNavigation=null;}if(this._mainScene instanceof v.dvl.Scene){this._stepNavigation=new j({showThumbnails:this.getShowStepNavigationThumbnails(),contentConnector:this._contentConnector});this._layout.insertItem(this._stepNavigation,3);}else if(this._mainScene instanceof v.threejs.Scene){this._stepNavigation=new k({viewport:this.getViewport(),contentConnector:this._contentConnector});if(!this.getOverlayStepNavigation()){this._layout.insertItem(this._stepNavigation,3);}else{this._stepNavigation.addStyleClass("sapVizKitViewGallery");this._viewport.addContent(this._stepNavigation);this._splitter.attachResize(this._handleSplitterResize,this);}}return this;};y.prototype._handleSplitterResize=function(){this._stepNavigation.resizeToolbarSpacer();};y.prototype._showViewport=function(){var i=this.getViewport().getImplementation();if(z(i)){i.setHotspotColor(this.getProperty("hotspotColor"));i.setHotspotColorABGR(this.getProperty("hotspotColorABGR"));i.setShowAllHotspots(this.getProperty("showAllHotspots"));}if(this._nativeViewport){this._nativeViewport.setVisible(false);}this._stackedViewport.removeAllContent();this._stackedViewport.addContent(this._viewport);this._viewport.setVisible(true);return this;};y.prototype._showNativeViewport=function(){if(!this._nativeViewport){this._nativeViewport=new n(this.getId()+"-nativeViewport",{limitZoomOut:true,contentConnector:this._contentConnector});}if(this._viewport){this._viewport.setVisible(false);}this._stackedViewport.removeAllContent();this._stackedViewport.addContent(this._nativeViewport);this._nativeViewport.setVisible(true);return this;};y.prototype._showOverlay=function(){var O=this._overlayManager;if(O.changed){var i;if(this.getEnableOverlay()){sap.ui.require(["sap/ui/vk/Overlay"],function(l){if(!O.initialized){if(!(i=this.getAggregation("overlay"))){i=new l();}i.setZoomOnResize(false);O.control=i;O.initialized=true;}else{i=O.control;i.reset();}if(this._nativeViewport&&this._nativeViewport.getVisible()){i.setTarget(this._nativeViewport);O.savedLimitZoomOutState=this._nativeViewport.getLimitZoomOut();this._nativeViewport.setLimitZoomOut(true);this._nativeViewport.attachEvent("move",O.onNativeViewportMove,O);}else if(this._viewport&&this._viewport.getVisible()){i.setTarget(this._viewport);O.savedLimitZoomOutState=false;this._viewport.attachEvent("zoom",O.onViewportZoom,O);this._viewport.attachEvent("pan",O.onViewportPan,O);}this._stackedViewport.addContent(i);this._stackedViewport.addDelegate(O.delegate);}.bind(this));}else{this._nativeViewport.detachEvent("move",O.onNativeViewportMove,O);this._stackedViewport.removeDelegate(O.delegate);this._stackedViewport.removeContent(O.control);this._nativeViewport.setLimitZoomOut(O.savedLimitZoomOutState);}O.changed=false;}};y.prototype._onAfterRenderingOverlay=function(E){var i=this._overlayManager.control.getDomRef();if(i&&(this._nativeViewport||this._viewport)){var l=this._nativeViewport&&this._nativeViewport.getVisible()?this._nativeViewport.getDomRef():this._viewport.getDomRef();if(i.parentNode!==l){i.parentNode.style.display="none";}l.appendChild(i);i.style.width="100%";i.style.height="100%";}};y.prototype.setDecryptionHandler=function(i){this._contentConnector.setDecryptionHandler(i);return this;};y.prototype.setAuthorizationHandler=function(i){this._contentConnector.setAuthorizationHandler(i);return this;};y.prototype._instantiateRedlineDesign=function(i){var l=this.getViewport().getImplementation();if((l&&l.getVisible())||(this.getNativeViewport()&&this.getNativeViewport().getVisible())){var A=l&&l.getVisible()?l:this.getNativeViewport();var B=A.getOutputSize();this._redlineDesign=new R({visible:false,virtualTop:B.top,virtualLeft:B.left,virtualSideLength:B.sideLength,redlineElements:i});this._redlineDesign._setTargetViewport(A);}return this;};y.prototype.activateRedlineDesign=function(i){var l=this.getViewport().getImplementation();if(l instanceof v.threejs.Viewport){l._viewportGestureHandler._activateRedline();}if(l instanceof v.dvl.Viewport&&l.getViewInfo().camera&&l.getViewInfo().camera.projectionType==="perspective"){l._activateRedline();}i=i||[];this._instantiateRedlineDesign(i);this.getRedlineDesign().placeAt(this._stackedViewport);this.getRedlineDesign().setVisible(true);var A=function(J){var K=J.getParameter("deltaX"),L=J.getParameter("deltaY");l.queueCommand(function(K,L){l.pan(K,L);l.endGesture();}.bind(this,K,L));};var B=function(J){var K=J.getParameter("originX"),L=J.getParameter("originY"),O=J.getParameter("zoomFactor");l.queueCommand(function(K,L,O){l.beginGesture(K,L);l.zoom(O);l.endGesture();}.bind(this,K,L,O));};var E=function(J){var K=J.getParameter("deltaX"),L=J.getParameter("deltaY");this.getNativeViewport().queueCommand(function(){this.getNativeViewport().pan(K,L);this.getNativeViewport().endGesture();}.bind(this));};var G=function(J){var K=J.getParameter("originX"),L=J.getParameter("originY"),O=J.getParameter("zoomFactor");this.getNativeViewport().queueCommand(function(K,L,O){this.getNativeViewport().beginGesture(K,L);this.getNativeViewport().zoom(O);this.getNativeViewport().endGesture();}.bind(this,K,L,O));};var H=function(J){var K=J.getParameter("deltaX"),L=J.getParameter("deltaY");l.queueCommand(function(K,L){l._viewportGestureHandler._cameraController.beginGesture(K,L);l._viewportGestureHandler._cameraController.pan(K,L);l._viewportGestureHandler._cameraController.endGesture();}.bind(this,K,L));};var I=function(J){var K=J.getParameter("originX"),L=J.getParameter("originY"),O=J.getParameter("zoomFactor");l.queueCommand(function(K,L,O){l._viewportGestureHandler._cameraController.beginGesture(K,L);l._viewportGestureHandler._cameraController.zoom(O);l._viewportGestureHandler._cameraController.endGesture();}.bind(this,K,L,O));};if(this.getNativeViewport()&&this.getNativeViewport().getVisible()){this.getRedlineDesign().attachEvent("pan",E.bind(this));this.getRedlineDesign().attachEvent("zoom",G.bind(this));}else if(l&&z(l)&&l.getVisible()){this.getRedlineDesign().attachEvent("pan",A.bind(this));this.getRedlineDesign().attachEvent("zoom",B.bind(this));}else if(l instanceof v.threejs.Viewport&&l.getVisible()){this.getRedlineDesign().attachEvent("pan",H.bind(this));this.getRedlineDesign().attachEvent("zoom",I.bind(this));}else{q.sap.log.Error("Error: Viewport not supported");}return this;};y.prototype.destroyRedlineDesign=function(){if(this.getRedlineDesign()){var i=this.getViewport().getImplementation();if(i instanceof v.dvl.Viewport){i._deactivateRedline();}else if(i instanceof v.threejs.Viewport){i._viewportGestureHandler._deactivateRedline();}this.getRedlineDesign().destroy();this._redlineDesign=null;}return this;};y.prototype._onViewportViewActivated=function(i){this._componentsState.sceneTree.shouldBeEnabled=i.getParameter("type")==="3D";};y.prototype._handleContentReplaced=function(i){var l=i.getParameter("newContent");if(l&&l instanceof v.Scene){this._showViewport();if(this.getRedlineDesign()){this.getRedlineDesign().updatePanningRatio();}this._setMainScene(l);}else if(l instanceof HTMLImageElement||l instanceof HTMLObjectElement){this._setMainScene(null);this._showNativeViewport();if(this.getEnableOverlay()){this._overlayManager.changed=true;this._showOverlay();}}else{this._setMainScene(null);if(this._viewport){this._viewport.setVisible(false);}if(this._nativeViewport){this._nativeViewport.setVisible(false);}this._stackedViewport.removeAllContent();}};y.prototype._handleContentChangesStarted=function(i){this.setBusy(true);if(this._componentsState.progressIndicator.defaultEnable){this._progressIndicator.setPercentValue(0.0);this._progressIndicator.setVisible(true);this.getViewport().stopAnimation();}};y.prototype._handleContentChangesFinished=function(i){x.info("Finished");setTimeout(function(){this._progressIndicator.setVisible(false);this._progressIndicator.setDisplayValue("");this._progressIndicator.setPercentValue(0);}.bind(this),0);this.setBusy(false);var l=i.getParameter("content");if(l){this.fireSceneLoadingSucceeded({scene:l});}var A=i.getParameter("failureReason");if(A){this.fireSceneLoadingFailed({reason:A});this._showNativeViewport();var B=r().getText("VIEWER_UNKNOWN_CONTENT_RESOURCE_TYPE_CAUSE");if(A.errorMessage===B){this._nativeViewport.loadFailed();}else{var E=r().getText("VIEWPORT_MESSAGEERRORLOADINGFILE");this._nativeViewport.loadFailed(E);}(Array.isArray(A)?A:[A]).forEach(function(G){x.error(r().getText(M.VIT13.summary),G.errorMessage,"sap.ui.vk.Viewer");});}this.fireContentResourceChangesProcessed();};y.prototype._handleContentChangesProgress=function(A){function B(K,E){for(var i=0,l=K.length;i<l;i++){var L=K[i];var O=L.getSource();if((O===E)||(O instanceof File&&O.name===E)){return L;}L=B(L.getContentResources(),E);if(L){return L;}}return null;}if(this._progressIndicator.getVisible()){var E=A.getParameter("source"),G=A.getParameter("percentage"),H=A.getParameter("phase");var I=B(this.getContentResources(),E);if(I&&I.getName()!==undefined){E=I.getName();}else{var J=E.match(/\..{3,4}$/);E=J&&J[0]?E.split(/\\|\//).pop():"";}this._progressIndicator.setPercentValue(G);this._progressIndicator.setDisplayValue(E+" "+H+" "+(G?Math.floor(G)+"%":""));}};y.prototype._handleContentDestroying=function(i){this.fireSceneDestroying({scene:i.getParameter("content").scene,preventGarbageCollection:i.getParameter("preventGarbageCollection")});};return y;});
