/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["jquery.sap.global","sap/ui/base/EventProvider"],function(q,E){"use strict";var V=E.extend("sap.ui.vk.ViewportHandler",{metadata:{publicMethods:["beginGesture","move","endGesture","click","doubleClick","contextMenu","getViewport"]},constructor:function(a){this._viewport=a;this._rect=null;this._evt={x:0,y:0,z:0,d:0,tdx:0,tdy:0,tdd:0,initd:0};this._gesture=false;this._viewport.attachEvent("resize",this,this._onresize);this._nomenu=false;}});V.prototype.destroy=function(){this._viewport=null;this._rect=null;this._evt=null;this._gesture=false;};V.prototype._getOffset=function(o){var r=o.getBoundingClientRect();var p={x:r.left+window.pageXOffset,y:r.top+window.pageYOffset};return p;};V.prototype._inside=function(e){if(this._rect==null||true){var i=this._viewport.getIdForLabel();var d=document.getElementById(i);if(d==null){return false;}var o=this._getOffset(d);this._rect={x:o.x,y:o.y,w:d.offsetWidth,h:d.offsetHeight};}return(e.x>=this._rect.x&&e.x<=this._rect.x+this._rect.w&&e.y>=this._rect.y&&e.y<=this._rect.y+this._rect.h);};V.prototype._onresize=function(e){this._gesture=false;this._rect=null;};V.prototype.beginGesture=function(a){if(this._inside(a)&&!this._gesture){this._gesture=true;var x=a.x-this._rect.x,y=a.y-this._rect.y;this._evt.tdx=0;this._evt.tdy=0;this._evt.tdd=0;this._evt.x=x;this._evt.y=y;this._evt.d=a.d;this._evt.initd=a.d;this._evt.avgd=a.d;this._evt.avgx=0;this._evt.avgy=0;q.sap.log.debug("Loco: beginGesture: "+x+", "+y);this._viewport.queueCommand(function(){this._viewport.beginGesture(x,y);}.bind(this));a.handled=true;if(document.activeElement){try{document.activeElement.blur();}catch(e){}}var d=document.getElementById(this._viewport.getIdForLabel());d.focus();}this._nomenu=false;};V.prototype.move=function(e){if(this._gesture){var x=e.x-this._rect.x,y=e.y-this._rect.y;var d=x-this._evt.x;var a=y-this._evt.y;var b=e.d-this._evt.d;this._evt.tdx=this._evt.tdx+d;this._evt.tdy=this._evt.tdy+a;this._evt.tdd=this._evt.tdd+b;this._evt.x=x;this._evt.y=y;this._evt.d=e.d;this._evt.avgx=this._evt.avgx*0.99+d*0.01;this._evt.avgy=this._evt.avgy*0.99+a*0.01;var z=1.0;if(this._evt.initd>0){z=1.0+b*(1.0/this._evt.initd);}else if(e.n==2){if(e.points[0].y>e.points[1].y){z=1.0-b*0.005;if(z<0.333){z=0.333;}}else{z=1.0+b*0.005;if(z>3){z=3;}}}if(this._evt.initd>0){var c=Math.sqrt(this._evt.avgx*this._evt.avgx+this._evt.avgy*this._evt.avgy);q.sap.log.debug("AvgDist: "+c);if((Math.abs(e.d-this._evt.avgd)/this._evt.avgd)<(c/10)){z=1.0;}}this._evt.avgd=this._evt.avgd*0.97+e.d*0.03;this._evt.n=e.n;switch(e.n){case 1:q.sap.log.debug("Loco: Rotate: "+(d)+", "+(a));this._viewport.queueCommand(function(){this._viewport.rotate(d,a);}.bind(this));break;case 2:q.sap.log.debug("Loco: Pan: "+(d)+", "+(a));if(z!=0&&z!=1.0){q.sap.log.debug("Loco: Zoom: "+(z));}this._viewport.queueCommand(function(){if(this._evt.tdx!==0&&this._evt.tdy!==0){this._viewport.pan(d,a);}if((d<10&&a<10&&z!=0&&z!=1.0)&&this._evt.tdd!==0){this._viewport.zoom(z);}}.bind(this));break;default:break;}this._nomenu=true;e.handled=true;}};V.prototype.endGesture=function(e){if(this._gesture){var x=e.x-this._rect.x,y=e.y-this._rect.y;q.sap.log.debug("Loco: endGesture: "+x+", "+y);this._viewport.queueCommand(function(){this._viewport.endGesture();}.bind(this));this._gesture=false;e.handled=true;}};V.prototype.click=function(e){if(this._inside(e)&&e.buttons<=1){var x=e.x-this._rect.x,y=e.y-this._rect.y;q.sap.log.debug("Loco: click: "+(x)+", "+(y));this._viewport.queueCommand(function(){this._viewport.tap(x,y,false);}.bind(this));e.handled=true;}};V.prototype.doubleClick=function(e){if(this._inside(e)&&e.buttons<=1){var x=e.x-this._rect.x,y=e.y-this._rect.y;q.sap.log.debug("Loco: doubleClick: "+(x)+", "+(y));this._viewport.queueCommand(function(){this._viewport.tap(x,y,true);}.bind(this));e.handled=true;}};V.prototype.contextMenu=function(e){if(this._inside(e)||this._nomenu||e.buttons==5){this._nomenu=false;e.handled=true;}};V.prototype.keyEventHandler=function(e){};V.prototype.getViewport=function(){return this._viewport;};return V;});
