/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
var dvlLib="../ve/dvl";if(sap.ui.Device.browser.internet_explorer){dvlLib="../ve/dvl_asm";}sap.ui.define(["jquery.sap.global","sap/ui/base/EventProvider","../thirdparty/html2canvas",dvlLib,"./Scene","../ContentResource","../DownloadManager","./ViewStateManager","../DvlException","../Messages","sap/ui/thirdparty/URI","./GraphicsCoreApi","./checkResult","./getPointer","./getJSONObject","../getResourceBundle","../utf8ArrayBufferToString"],function(q,E,H,D,S,C,a,V,b,M,U,G,c,d,f,h,u){"use strict";var l=q.sap.log;function j(e){return e instanceof File?"local":"remote";}function k(e){return e instanceof File?e.name:e;}var n=function(e){Object.defineProperties(this,{source:{value:e,writable:false,enumerable:true},_refCount:{value:0,writable:true,enumerable:false}});};n.prototype.isInUse=function(){return this._refCount>0;};n.prototype.addRef=function(){++this._refCount;return this;};n.prototype.release=function(){--this._refCount;return this;};n.prototype.destroy=function(){};var o=function(e,g,i){n.call(this,e);Object.defineProperties(this,{content:{value:i,writable:false,enumerable:true},vdsSourceDatum:{value:g,writable:false,enumerable:true}});};o.prototype=Object.create(n.prototype);o.prototype.constructor=o;o.prototype.destroy=function(){if(this.vdsSourceDatum){this.vdsSourceDatum.release();}n.prototype.destroy.call(this);};var p=function(e,g,i){Object.defineProperties(this,{dvlSceneId:{value:e,writable:false,enumerable:true},sourceDatum:{value:g,writable:false,enumerable:true},root:{value:!!i,writable:false,enumerable:true},_refCount:{value:0,writable:true,enumerable:false}});};p.prototype.isInUse=function(){return this._refCount>0;};p.prototype.addRef=function(){++this._refCount;return this;};p.prototype.release=function(){--this._refCount;return this;};p.prototype.destroy=function(){if(this.sourceDatum){this.sourceDatum.release();}};var r=function(e,g){Object.defineProperties(this,{source:{value:e.getSource()},sourceType:{value:e.getSourceType()},sourceId:{value:e.getSourceId(),writable:true},name:{value:e.getName()},localMatrix:{value:e.getLocalMatrix(),writable:true},password:{value:e.getPassword()},children:{value:e.getContentResources().map(function(e){return new r(e);})},dvlSceneDatum:{value:null,writable:true},nodeProxy:{value:null,writable:true},fake:{value:!!g},sourceProperties:{value:null,writable:true}});e._shadowContentResource=this;};r.prototype.destroy=function(){if(this.dvlSceneDatum){this.dvlSceneDatum.release();}};var s=function(e,g){Object.defineProperties(this,{vkScene:{value:e},shadowContentResource:{value:g}});};var t=E.extend("sap.ui.vk.dvl.GraphicsCore",{metadata:{publicMethods:["attachSceneLoadingFinished","attachSceneLoadingProgress","attachSceneLoadingStarted","buildSceneTree","buildSceneTreeAsync","createViewStateManager","destroyScene","destroyViewStateManager","detachSceneLoadingFinished","detachSceneLoadingProgress","detachSceneLoadingStarted","getApi","loadContentResourcesAsync","showDebugInfo","updateSceneTree","updateSceneTreeAsync"]},constructor:function(e,g){E.apply(this);var i=q.extend({},e,{filePackagePrefixURL:q.sap.getResourcePath("sap/ui/vk/ve")+"/"});this._dvlClientId=q.sap.uid();var m=this;this._initialized=new Promise(function(z){m._initResolve=z;});sap.ve.dvl.createRuntime(i).then(function(z){m._dvl=z;m._dvl.CreateCoreInstance(m._dvlClientId);c(m._dvl.Core.Init(m._DVLMajorVersion,m._DVLMinorVersion));var A=sap.ui.getCore();A.attachLocalizationChanged(m._onlocalizationChanged,m);c(m._dvl.Core.SetLocale(A.getConfiguration().getLanguageTag()));m._canvas=m._createRenderingCanvasAndContext(g);m._rendererId=d(m._dvl.Core.CreateRenderer());m._dvl.Renderer.SetOptionF(sap.ve.dvl.DVLRENDEROPTIONF.DVLRENDEROPTIONF_DPI,96*window.devicePixelRatio,m._rendererId);m._initResolve();});this._sourceData=[];this._dvlSceneData=[];this._vkSceneData=[];this._viewports=[];this._renderLoopRequestId=null;this._renderLoopFunction=this._renderLoop.bind(this);this._viewStateManagers=[];},_DVLMajorVersion:7,_DVLMinorVersion:4});t.create=function(e,i){return new Promise(function(m,z){try{var g=new t(e,i);g._initialized.then(function(){m(g);});}catch(A){z(A);}});};t.prototype.destroy=function(){sap.ui.getCore().detachLocalizationChanged(this._onlocalizationChanged,this);var e=this._viewports.slice();e.reverse();e.forEach(function(g){g.control.setGraphicsCore(null);});this._viewports=null;this._cleanupVkSceneData();this._vkSceneData=null;this._cleanupDvlSceneData();this._dvlSceneData=null;this._cleanupSourceData();this._sourceData=null;this._viewStateManagers.slice().forEach(this.destroyViewStateManager.bind(this));this._viewStateManagers=null;this._webGLContext=null;this._canvas=null;this._dvl.Core.DeleteRenderer(this._rendererId);this._rendererId=null;this._dvl.Core.Release();this._dvl=null;E.prototype.destroy.apply(this);};t.prototype._createRenderingCanvasAndContext=function(e){var g=document.createElement("canvas");g.id=q.sap.uid();this._webGLContext=this._dvl.Core.CreateWebGLContext(g,e);return g;};t.prototype._getCanvas=function(){return this._canvas;};t.prototype._getWebGLContext=function(){return this._webGLContext;};t.prototype._getDvl=function(){return this._dvl;};t.prototype._getDvlClientId=function(){return this._dvlClientId;};t.prototype._findSourceData=function(e){var g=Object.getOwnPropertyNames(e);return this._sourceData.filter(function(i){return g.every(function(m){return e[m]===i[m];});});};t.prototype._destroySourceDatum=function(e){if(!(e instanceof o)){this._dvl.Core.DeleteFileByUrl(k(e.source),j(e.source));}e.destroy();return this;};t.prototype._cleanupSourceData=function(){var e=false;for(var i=this._sourceData.length-1;i>=0;--i){var g=this._sourceData[i];if(!g.isInUse()){var m=g instanceof o?g.vdsSourceDatum:null;this._sourceData.splice(i,1);this._destroySourceDatum(g);if(m&&!m.isInUse()){e=true;}}}if(e){this._cleanupSourceData();}return this;};t.prototype._findDvlSceneData=function(e){var g=Object.getOwnPropertyNames(e);return this._dvlSceneData.filter(function(i){return g.every(function(m){return e[m]===i[m];});});};t.prototype._destroyDvlSceneDatum=function(e){this._dvl.Scene.Release(e.dvlSceneId);e.destroy();return this;};t.prototype._cleanupDvlSceneData=function(){for(var i=this._dvlSceneData.length-1;i>=0;--i){var e=this._dvlSceneData[i];if(!e.isInUse()){this._dvlSceneData.splice(i,1);this._destroyDvlSceneDatum(e);}}};t.prototype._findVkSceneData=function(e){var g=Object.getOwnPropertyNames(e);return this._vkSceneData.filter(function(i){return g.every(function(m){return e[m]===i[m];});});};t.prototype._cleanupVkSceneData=function(){for(var i=this._vkSceneData.length-1;i>=0;--i){this.destroyScene(this._vkSceneData[i].vkScene);}};t.prototype._destroyShadowContentResource=function(g,i){if(i.children){i.children.forEach(this._destroyShadowContentResource.bind(this,g));}if(i.nodeProxy){var m=g.getDefaultNodeHierarchy();try{m.removeNode(i.nodeProxy.getNodeRef());}catch(e){var z="Failed to delete node with ID = "+i.nodeProxy.getNodeRef()+".";if(e instanceof b){z+=" Error code: "+e.code+". Message: "+e.message+".";}l.error(z);}m.destroyNodeProxy(i.nodeProxy);}i.destroy();};t.prototype._filterContentResources=function(e,g){var i=[];e.forEach(function enumerate(m){if(g(m)){i.push(m);}m.getContentResources().forEach(enumerate);});return i;};t.prototype._getContentResourcesWithMissingPasswords=function(g){var i=this._dvl.Library;return this._filterContentResources(g,function(m){var z=m.getSource();try{return z&&(f(i.RetrieveInfo(k(z),j(z))).flags&sap.ve.dvl.DVLFILEFLAG.ENCRYPTED)&&!m.getPassword();}catch(e){l.warning("Failed to get information from Emscripten virtual file system about file '"+k(z)+"'");return false;}});};t.prototype._getContentResourcesWithEncryptedVds3=function(g){var i=this._dvl.Library;return this._filterContentResources(g,function(m){var z=m.getSource();if(z){try{var A=f(i.RetrieveInfo(k(z),j(z)));return A.major<=3&&(A.flags&sap.ve.dvl.DVLFILEFLAG.ENCRYPTED);}catch(e){l.warning("Failed to get information from Emscripten virtual file system about file '"+k(z)+"'");return false;}}else{return false;}});};t.prototype._collectAndCheckSourceProperties=function(g){var i=g.dvlSceneDatum.sourceDatum;if(!i){return this;}try{if(i instanceof o){i=i.vdsSourceDatum;}var m=f(this._dvl.Library.RetrieveInfo(k(i.source),j(i.source)));g.sourceProperties={version:{major:m.major,minor:m.minor}};if(m.flags&(sap.ve.dvl.DVLFILEFLAG.PAGESCOMPRESSED|sap.ve.dvl.DVLFILEFLAG.WHOLEFILECOMPRESSED)){g.sourceProperties.compressed=true;}if(m.flags&sap.ve.dvl.DVLFILEFLAG.ENCRYPTED){g.sourceProperties.encrypted=true;}}catch(e){l.warning("Failed to get information from Emscripten virtual file system about file '"+k(g.source)+"'");}return this;};t.prototype.loadContentResourcesAsync=function(e,g,i){var z=this,A=[],B=new Map();e.forEach(function enumerate(m){var K=m.getSource();if(K&&A.indexOf(K)<0&&z._findSourceData({source:K}).length===0){A.push(K);var L=m.getSource();var N;if(L instanceof Object){N=L.name;}else{N=L;}if(m.getSourceType()==="vdsl"||m.getSourceType()==="vds"&&N.split(".").pop()==="vdsl"){B.set(K,{});}}m.getContentResources().forEach(enumerate);});var F=[];if(A.length>0){var I;var J=new a(A,null,this._authorizationHandler).attachItemSucceeded(function(K){var L=K.getParameter("source");var N=K.getParameter("response");if(B.has(L)){var O=u(N);if(O.trim().length===0){I=I||[];I.push({source:L,status:M.VIT22.code,statusText:h().getText(M.VIT22.summary)});l.error(h().getText(M.VIT22.summary),M.VIT22.code,"sap.ui.vk.dvl.GraphicsCore");return;}else{var P=O.split(/\n|\r\n/);var m=P[0].match(/^file=(.+)$/);if(!m){I=I||[];I.push({source:L,status:M.VIT23.code,statusText:h().getText(M.VIT23.summary)});l.error(h().getText(M.VIT23.summary),M.VIT23.code,"sap.ui.vk.dvl.GraphicsCore");return;}else{var Q=B.get(L);Q.content=P;var R=m[1];var T=R;var W=new U(T);if(W.is("relative")){if(L instanceof File){I=I||[];I.push({source:L,status:M.VIT24.code,statusText:h().getText(M.VIT24.summary)});l.error(h().getText(M.VIT24.summary),M.VIT24.code,"sap.ui.vk.dvl.GraphicsCore");return;}else{var X=new U(L);R=W.absoluteTo(X).href();}}Q.referencedSource=R;Q.content[0]=Q.content[0].replace(T,this._dvl.Core.GetFilename(Q.referencedSource,"remote"));if(A.indexOf(Q.referencedSource)<0&&this._findSourceData({source:Q.referencedSource}).length===0){A.push(Q.referencedSource);J.queue(Q.referencedSource);}}}}else{var Y=L instanceof File;var Z=Y?L.name:L;var $=j(L);this._dvl.Core.CreateFileFromArrayBuffer(N,Z,$);F.push(new n(L));}},this).attachAllItemsCompleted(function(m){Array.prototype.push.apply(this._sourceData,F);B.forEach(function(K,L){var N=this._findSourceData({source:K.referencedSource})[0];if(N){var O=new o(L,N,K.content.join("\n"));this._sourceData.push(O);N.addRef();}}.bind(this));if(g){g(I);}},this).attachItemFailed(function(m){I=I||[];I.push({source:m.getParameter("source"),status:m.getParameter("status"),statusText:m.getParameter("statusText")});},this);if(i){J.attachItemProgress(i,this);}J.start();}else if(g){g();}return this;};t.prototype._buildPlaceholders=function(e,g,i,m){var z=[];m.forEach(function build(g,i,A){var B=e.createNode(g,A.name,i);A.nodeProxy=e.createNodeProxy(B);if(A.localMatrix){A.nodeProxy.setLocalMatrix(A.localMatrix);}if(A.source){z.push(A);}A.children.forEach(build.bind(this,B,null));}.bind(this,g,i));return z;};t.prototype._updatePlaceholders=function(e,g,m){var z=this,A=e.getDefaultNodeHierarchy(),B=[];(function update(F,m,I){function J(N,O){if(!N&&!O){return true;}else if(!!N^!!O){return false;}else{return N.source===O.getSource()&&N.sourceType===O.getSourceType()&&N.name===O.getName()&&N.password===O.getPassword();}}function K(N,O){O._shadowContentResource=N;N.sourceId=O.getSourceId();N.localMatrix=O.getLocalMatrix();if(N.nodeProxy){N.nodeProxy.setLocalMatrix(N.localMatrix);}}var i=0;var L=q.sap.arrayDiff(F,m,J,true);L.forEach(function(N){for(;i<N.index;++i){update(F[i].children,m[i].getContentResources(),F[i].nodeProxy.getNodeRef());K(F[i],m[i]);}if(N.type==="delete"){z._destroyShadowContentResource(e,F[N.index]);F.splice(N.index,1);}else if(N.type==="insert"){var O;if(i<F.length&&F[i].nodeProxy){O=F[i].nodeProxy.getNodeRef();}var P=new r(m[N.index]);B=B.concat(z._buildPlaceholders(A,I,O,[P]));F.splice(N.index,0,P);++i;}});for(;i<F.length;++i){update(F[i].children,m[i].getContentResources(),F[i].nodeProxy&&F[i].nodeProxy.getNodeRef());K(F[i],m[i]);}})(g.fake?g.children:[g],m,null);return B;};t.prototype._loadAndMergeContentResource=function(g,i){if(i.source){var m=this._findSourceData({source:i.source})[0];if(!m){l.warning("Failed to load content resource with sourceId '"+i.sourceId+"' due to failed downloading from URL '"+k(i.source)+"'.");}else{var z=i.nodeProxy.getNodeRef();var A=this._findDvlSceneData({sourceDatum:m,root:false})[0];if(!A){try{A=new p(d(m instanceof o?this._dvl.Core.LoadSceneFromVDSL(m.content,i.password):this._dvl.Core.LoadSceneByUrl(k(i.source),i.password,j(i.source))),m,false);}catch(e){l.error(h().getText(M.VIT34.summary)+": "+k(i.source),M.VIT34.code,"sap.ui.vk.dvl.GraphicsCore");return;}this._dvlSceneData.push(A);m.addRef();}i.dvlSceneDatum=A;A.addRef();this._collectAndCheckSourceProperties(i);this._dvl.Renderer.ResetView(sap.ve.dvl.DVLRESETVIEWFLAG.CAMERA,this._rendererId);this._dvl.Scene.Merge(g._dvlSceneRef,A.dvlSceneId,z);}}};t.prototype.buildSceneTree=function(g){if(g.length===0){return null;}var i;var m;var z=g.map(function(I){return new r(I);});if(z.length===1&&z[0].name==null){m=z[0];if(m.source){var A=this._findSourceData({source:m.source})[0];try{i=new p(d(A instanceof o?this._dvl.Core.LoadSceneFromVDSL(A.content,m.password):this._dvl.Core.LoadSceneByUrl(k(m.source),m.password,j(m.source))),A,true);}catch(e){l.error(h().getText(M.VIT34.summary)+": "+k(m.source),M.VIT34.code,"sap.ui.vk.dvl.GraphicsCore");return null;}A.addRef();}else{i=new p(this._dvl.Core.CreateEmptyScene(),null,true);}}else{var B=new C({sourceType:"vds",sourceId:q.sap.uid()});m=new r(B,true);B.destroy();B=null;Array.prototype.push.apply(m.children,z);z=[m];i=new p(this._dvl.Core.CreateEmptyScene(),null,true);}this._dvlSceneData.push(i);m.dvlSceneDatum=i;i.addRef();this._collectAndCheckSourceProperties(m);var F=new S(this,i.dvlSceneId);this._vkSceneData.push(new s(F,m));this._buildPlaceholders(F.getDefaultNodeHierarchy(),null,null,m.children).forEach(this._loadAndMergeContentResource.bind(this,F.getDefaultNodeHierarchy()));return F;};t.prototype.updateSceneTree=function(e,g,i){if(g.length===0){return null;}var m;var z=this._getContentResourcesWithEncryptedVds3(g);if(z.length>0){l.error(h().getText(M.VIT25.summary),M.VIT25.code,"sap.ui.vk.dvl.GraphicsCore");m=m||{};m.contentResourcesWithEncryptedVds3=z;}var A=this._getContentResourcesWithMissingPasswords(g);if(A.length>0){l.error(h().getText(M.VIT21.summary),M.VIT21.code,"sap.ui.vk.dvl.GraphicsCore");m=m||{};m.contentResourcesWithMissingPasswords=A;}if(m&&i){i(m);}if(!e){return this.buildSceneTree(g);}var B=this._findVkSceneData({vkScene:e})[0].shadowContentResource;var F=!!B.source;var I=g.length===1&&!!g[0].getSource();if(!(F&&I&&B.source===g[0].getSource()||!F&&!I&&B.fake===g.length>1)||!B.fake&&g.length===1&&B.name!==g[0].getName()){return this.buildSceneTree(g);}this._updatePlaceholders(e,B,g).forEach(this._loadAndMergeContentResource.bind(this,e.getDefaultNodeHierarchy()));e.getDefaultNodeHierarchy().fireChanged();return e;};t.prototype._loadDvlSceneAsync=function(g,i){return new Promise(function(m,z){var A;var B=function(J){A();this.fireSceneLoadingFinished({source:g.source,sceneId:J.sceneId});m(J.sceneId);};var F=function(J){A();var K=J.errorMessage;if(K==null){K=sap.ve.dvl.DVLRESULT.getDescription?sap.ve.dvl.DVLRESULT.getDescription(J.errorCode):"";}var L={source:g.source,errorCode:J.errorCode,errorMessage:K};this.fireSceneLoadingFinished(L);z(L);};var I=function(J,K){this.fireSceneLoadingProgress({source:k(g.source),percentage:K});return true;}.bind(this);A=function(){this._dvl.Client.NotifyFileLoadProgress=null;this._dvl.Client.detachSceneFailed(F,this);this._dvl.Client.detachSceneLoaded(B,this);}.bind(this);this._dvl.Client.attachSceneLoaded(B,this);this._dvl.Client.attachSceneFailed(F,this);this._dvl.Client.NotifyFileLoadProgress=I;this.fireSceneLoadingStarted({source:k(g.source)});try{c(g instanceof o?this._dvl.Core.LoadSceneFromVDSLAsync(g.content,i):this._dvl.Core.LoadSceneByUrlAsync(k(g.source),i,j(g.source)));}catch(e){A();F.call(this,{errorCode:e instanceof b?e.code:sap.ve.dvl.DVLRESULT.FAIL,errorMessage:e instanceof b?null:e});}}.bind(this));};var v=function(e,g){return new Promise(function(i){(function step(m){if(m>=e.length){i();}else{g(e[m]).catch(function(){}).then(function(){step(m+1);});}})(0);});};t.prototype._loadAndMergeContentResourcesAsync=function(e,g){var i,m=this;return v(g,function(z){if(z.source){var A=m._findSourceData({source:z.source})[0];if(!A){var B="Failed to load content resource with sourceId '"+z.sourceId+"' due to failed downloading from URL '"+k(z.source)+"'.";l.warning(B);i=i||[];i.push({errorMessage:B,source:z.source});return Promise.reject();}return(function(){var F=m._findDvlSceneData({sourceDatum:A,root:false})[0];if(F){return Promise.resolve(F);}else{return m._loadDvlSceneAsync(A,z.password).then(function(I){F=new p(I,A,false);m._dvlSceneData.push(F);A.addRef();return Promise.resolve(F);},function(I){i=i||[];i.push(I);return Promise.reject();});}})().then(function(F){z.dvlSceneDatum=F;F.addRef();m._collectAndCheckSourceProperties(z);var I=z.nodeProxy.getNodeRef();m._dvl.Renderer.ResetView(sap.ve.dvl.DVLRESETVIEWFLAG.CAMERA,m._rendererId);m._dvl.Scene.Merge(e._dvlSceneRef,F.dvlSceneId,I);return Promise.resolve();});}return Promise.resolve();}).then(function(){return Promise.resolve(i);});};t.prototype.buildSceneTreeAsync=function(e){if(e.length===0){return Promise.resolve(null);}var g=e.map(function(i){return new r(i);});return function(){var i;if(g.length===1&&g[0].name==null){i=g[0];if(i.source){var m=this._findSourceData({source:i.source})[0];if(m){return this._loadDvlSceneAsync(m,i.password).then(function(A){var B=new p(A,m,true);m.addRef();return Promise.resolve({shadowContentResource:i,dvlSceneDatum:B});});}else{return Promise.reject({errorMessage:"Failed to download the root content resource.",source:i.source});}}return Promise.resolve({shadowContentResource:i,dvlSceneDatum:new p(this._dvl.Core.CreateEmptyScene(),null,true)});}else{var z=new C({sourceType:"vds",sourceId:q.sap.uid()});i=new r(z,true);z.destroy();z=null;Array.prototype.push.apply(i.children,g);g=[i];return Promise.resolve({shadowContentResource:i,dvlSceneDatum:new p(this._dvl.Core.CreateEmptyScene(),null,true)});}}.call(this).then(function(i){this._dvlSceneData.push(i.dvlSceneDatum);i.shadowContentResource.dvlSceneDatum=i.dvlSceneDatum;i.dvlSceneDatum.addRef();this._collectAndCheckSourceProperties(i.shadowContentResource);var m=new S(this,i.dvlSceneDatum.dvlSceneId);this._vkSceneData.push(new s(m,i.shadowContentResource));var z=m.getDefaultNodeHierarchy();return this._loadAndMergeContentResourcesAsync(z,this._buildPlaceholders(m.getDefaultNodeHierarchy(),null,null,i.shadowContentResource.children)).then(function(A){return Promise.resolve({scene:m,failureReason:A});});}.bind(this));};t.prototype.updateSceneTreeAsync=function(e,g){if(g.length===0){return Promise.resolve(null);}var i=this._getContentResourcesWithEncryptedVds3(g);if(i.length>0){l.error(h().getText(M.VIT25.summary),M.VIT25.code,"sap.ui.vk.dvl.GraphicsCore");}var m=this._getContentResourcesWithMissingPasswords(g);if(m.length>0){l.error(h().getText(M.VIT21.summary),M.VIT21.code,"sap.ui.vk.dvl.GraphicsCore");}if(!e){return this.buildSceneTreeAsync(g);}var z=this._findVkSceneData({vkScene:e})[0].shadowContentResource;var A=!!z.source;var B=g.length===1&&!!g[0].getSource();if(!(A&&B&&z.source===g[0].getSource()||!A&&!B&&z.fake===g.length>1)||!z.fake&&g.length===1&&z.name!==g[0].getName()){return this.buildSceneTreeAsync(g);}return new Promise(function(F,I){var J=e.getDefaultNodeHierarchy();this._loadAndMergeContentResourcesAsync(J,this._updatePlaceholders(e,z,g)).then(function(K){F({scene:e,failureReason:K});J.fireChanged();});}.bind(this));};t.prototype.destroyScene=function(e){var g;for(g=0;g<this._vkSceneData.length;++g){if(this._vkSceneData[g].vkScene===e){break;}}if(g===this._vkSceneData.length){l.warning("Scene with id '"+e.getId()+"' is not created by this GraphicsCore.");return this;}var i=this._vkSceneData.splice(g,1)[0];this._destroyShadowContentResource(e,i.shadowContentResource);e.destroy();return this;};var w=function(e,g,m){for(var i=0,z=e.length;i<z;++i){if(g.call(m,e[i],i,e)){return i;}}return-1;};var x=function(e,g){return w(e,function(i){return i.control===g;});};var y=function(e,g){return w(e,function(i){return i.rendererId===g;});};t.prototype._registerViewport=function(e){if(x(this._viewports,e)>=0){return false;}var g={control:e,canvas:null,rendererId:null};if(this._viewports.length===0){g.canvas=this._canvas;g.rendererId=this._rendererId;this._startRenderLoop();}else{if(this._viewports.length===1){var i=this._viewports[0];i.control._setCanvas(i.canvas=document.createElement("canvas"));this._dvl.Client.attachFrameFinished(this._handleFrameFinished,this);}g.canvas=document.createElement("canvas");g.rendererId=this._dvl.Core.CreateRenderer();}e._setCanvas(g.canvas);e._setRenderer(g.rendererId);e.attachResize(this._handleViewportResize,this);this._viewports.push(g);return true;};t.prototype._deregisterViewport=function(e){var i=x(this._viewports,e);if(i<0){return false;}var g=this._viewports.splice(i,1)[0];if(this._viewports.length===0){this._stopRenderLoop();}else{if(this._viewports.length===1){this._dvl.Client.detachFrameFinished(this._handleFrameFinished,this);var m=this._viewports[1-i];m.control._setCanvas(m.canvas=this._canvas);}this._dvl.Core.DeleteRenderer(g.rendererId);}e.detachResize(this._handleViewportResize,this);e._setRenderer(null);e._setCanvas(null);return true;};t.prototype._getViewportCount=function(){return this._viewports.length;};t.prototype._handleViewportResize=function(e){if(this._viewports.length>1){this._canvas.width=Math.max.apply(null,this._viewports.map(function(g){return g.canvas.width;}));this._canvas.height=Math.max.apply(null,this._viewports.map(function(g){return g.canvas.height;}));}};t.prototype._startRenderLoop=function(){if(!this._renderLoopRequestId){this._renderLoopRequestId=window.requestAnimationFrame(this._renderLoopFunction);}return this;};t.prototype._stopRenderLoop=function(){if(this._renderLoopRequestId){window.cancelAnimationFrame(this._renderLoopRequestId);this._renderLoopRequestId=null;}return this;};t.prototype._renderLoop=(function(){var e;return function(){var m=this._viewports.length>1;this._viewports.forEach(function(g){var i=g.canvas,z=g.rendererId;this._dvl.Renderer._processCommandQueue(z);if(i.width>0&&i.height>0&&this._dvl.Renderer.ShouldRenderFrame(z)){if(m&&e!==z){this._dvl.Renderer.SetDimensions(i.width,i.height,z);}g.control.renderFrame();e=z;}},this);this._renderLoopRequestId=window.requestAnimationFrame(this._renderLoopFunction);};})();t.prototype._handleFrameFinished=function(e){if(this._viewports.length>1){var i=y(this._viewports,e.rendererId);if(i>=0){var g=this._viewports[i].canvas,m=g.getContext("2d"),z=g.width,A=g.height;m.drawImage(this._canvas,0,this._canvas.height-A,z,A,0,0,z,A);}}};t.prototype.createViewStateManager=function(e,g){var i=new V();i._setNodeHierarchy(e).setShouldTrackVisibilityChanges(g);this._viewStateManagers.push(i);return i;};t.prototype.destroyViewStateManager=function(e){var i=this._viewStateManagers.indexOf(e);if(i>=0){this._viewStateManagers.splice(i,1)[0].destroy();}return this;};t.prototype.showDebugInfo=function(e){this._viewports.forEach(function(g){g.control.setShowDebugInfo(e);});return this;};t.prototype.getApi=function(e){switch(e){case G.LegacyDvl:return this._dvl;default:return null;}};t.prototype.collectGarbage=function(){this._cleanupDvlSceneData();this._cleanupSourceData();return this;};t.prototype._onlocalizationChanged=function(e){if(e.getParameter("changes").language){c(this._dvl.Core.SetLocale(sap.ui.getCore().getConfiguration().getLanguageTag()));}};t.prototype.setDecryptionHandler=function(e){this._dvl.Client.setDecryptionHandler(e);return this;};t.prototype.setAuthorizationHandler=function(e){this._authorizationHandler=e;return this;};t.prototype.getDecryptionHandler=function(){return this._dvl.Client.getDecryptionHandler();};t.prototype.attachSceneLoadingFinished=function(e,g,i){return this.attachEvent("sceneLoadingFinished",e,g,i);};t.prototype.detachSceneLoadingFinished=function(e,g){return this.detachEvent("sceneLoadingFinished",e,g);};t.prototype.fireSceneLoadingFinished=function(e,g,i){return this.fireEvent("sceneLoadingFinished",e,g,i);};t.prototype.attachSceneLoadingProgress=function(e,g,i){return this.attachEvent("sceneLoadingProgress",e,g,i);};t.prototype.detachSceneLoadingProgress=function(e,g){return this.detachEvent("sceneLoadingProgress",e,g);};t.prototype.fireSceneLoadingProgress=function(e,g,i){return this.fireEvent("sceneLoadingProgress",e,g,i);};t.prototype.attachSceneLoadingStarted=function(e,g,i){return this.attachEvent("sceneLoadingStarted",e,g,i);};t.prototype.detachSceneLoadingStarted=function(e,g){return this.detachEvent("sceneLoadingStarted",e,g);};t.prototype.fireSceneLoadingStarted=function(e,g,i){return this.fireEvent("sceneLoadingStarted",e,g,i);};return t;});
