/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["jquery.sap.global","sap/ui/core/ResizeHandler","../abgrToColor","../CameraFOVBindingType","../CameraProjectionType","../colorToABGR","../colorToCSSColor","../ContentConnector","../cssColorToColor","../getResourceBundle","../Loco","../Messages","../SelectionMode","../Smart2DHandler","../ViewportBase","../ViewportHandler","../ViewStateManager","../VisibilityMode","../ZoomTo","./getJSONObject","./Scene","./ViewportRenderer"],function(q,R,a,C,b,c,d,e,g,h,L,M,S,k,V,l,n,o,Z,p,r,s){"use strict";var t;var u=function(){if(t){return;}t={encodedProjectionType:{},decodedProjectionType:{},encodedBindingType:{},decodedBindingType:{},decodedZoomTo:{}};t.decodedProjectionType[b.Perspective]=sap.ve.dvl.DVLCAMERAPROJECTION.PERSPECTIVE;t.decodedProjectionType[b.Orthographic]=sap.ve.dvl.DVLCAMERAPROJECTION.ORTHOGRAPHIC;t.encodedProjectionType[sap.ve.dvl.DVLCAMERAPROJECTION.PERSPECTIVE]=b.Perspective;t.encodedProjectionType[sap.ve.dvl.DVLCAMERAPROJECTION.ORTHOGRAPHIC]=b.Orthographic;t.decodedBindingType[C.Minimum]=sap.ve.dvl.DVLCAMERAFOVBINDING.MIN;t.decodedBindingType[C.Maximum]=sap.ve.dvl.DVLCAMERAFOVBINDING.Max;t.decodedBindingType[C.Horizontal]=sap.ve.dvl.DVLCAMERAFOVBINDING.HORZ;t.decodedBindingType[C.Vertical]=sap.ve.dvl.DVLCAMERAFOVBINDING.VERT;t.encodedBindingType[sap.ve.dvl.DVLCAMERAFOVBINDING.MIN]=C.Minimum;t.encodedBindingType[sap.ve.dvl.DVLCAMERAFOVBINDING.MAX]=C.Maximum;t.encodedBindingType[sap.ve.dvl.DVLCAMERAFOVBINDING.HORZ]=C.Horizontal;t.encodedBindingType[sap.ve.dvl.DVLCAMERAFOVBINDING.VERT]=C.Vertical;t.decodedZoomTo[Z.All]=sap.ve.dvl.DVLZOOMTO.DVLZOOMTO_ALL;t.decodedZoomTo[Z.Visible]=sap.ve.dvl.DVLZOOMTO.DVLZOOMTO_VISIBLE;t.decodedZoomTo[Z.Selected]=sap.ve.dvl.DVLZOOMTO.DVLZOOMTO_SELECTED;t.decodedZoomTo[Z.Node]=sap.ve.dvl.DVLZOOMTO.DVLZOOMTO_NODE;t.decodedZoomTo[Z.NodeSetIsolation]=sap.ve.dvl.DVLZOOMTO.DVLZOOMTO_NODE_SETISOLATION;t.decodedZoomTo[Z.Restore]=sap.ve.dvl.DVLZOOMTO.DVLZOOMTO_RESTORE;t.decodedZoomTo[Z.RestoreRemoveIsolation]=sap.ve.dvl.DVLZOOMTO.DVLZOOMTO_RESTORE_REMOVEISOLATION;t.decodedZoomTo[Z.ViewLeft]=sap.ve.dvl.DVLZOOMTO.VIEW_LEFT;t.decodedZoomTo[Z.ViewRight]=sap.ve.dvl.DVLZOOMTO.VIEW_RIGHT;t.decodedZoomTo[Z.ViewTop]=sap.ve.dvl.DVLZOOMTO.VIEW_TOP;t.decodedZoomTo[Z.ViewBottom]=sap.ve.dvl.DVLZOOMTO.VIEW_BOTTOM;t.decodedZoomTo[Z.ViewBack]=sap.ve.dvl.DVLZOOMTO.VIEW_BACK;t.decodedZoomTo[Z.ViewFront]=sap.ve.dvl.DVLZOOMTO.VIEW_FRONT;};var v=V.extend("sap.ui.vk.dvl.Viewport",{metadata:{library:"sap.ui.vk",properties:{showAllHotspots:{type:"boolean",defaultValue:false},hotspotColorABGR:{type:"int",defaultValue:0xc00000ff},hotspotColor:{type:"sap.ui.core.CSSColor",defaultValue:"rgba(255, 0, 0, 0.7529411764705882)"},backgroundColorTopABGR:{type:"int",defaultValue:0xff000000},backgroundColorBottomABGR:{type:"int",defaultValue:0xffffffff}},events:{pan:{parameters:{dx:"int",dy:"int"}},zoom:{parameters:{zoomFactor:"float"}},rotate:{parameters:{dx:"int",dy:"int"}},frameRenderingFinished:{}}}});var w=v.getMetadata().getParent().getClass().prototype;v.prototype.init=function(){u();if(w.init){w.init.call(this);}this._graphicsCore=null;this._dvl=null;this._dvlRendererId=null;this._viewStateManager=null;this._canvas=null;this._resizeListenerId=null;this._is2D=false;this._viewportHandler=new l(this);this._loco=new L(this);this._loco.addHandler(this._viewportHandler,-1);this._smart2DHandler=null;this._lastPlayedStep=null;this._contentConnector=null;};v.prototype.exit=function(){this._loco.removeHandler(this._viewportHandler);this._viewportHandler.destroy();if(this._resizeListenerId){R.deregister(this._resizeListenerId);this._resizeListenerId=null;}this._clearContentConnector();this.setViewStateManager(null);this.setScene(null);this.setGraphicsCore(null);if(w.exit){w.exit.call(this);}};v.prototype.setGraphicsCore=function(f){if(f!=this._graphicsCore){if(this._graphicsCore){this._dvl.Client.detachFrameFinished(this._handleFrameFinished,this);this._dvl.Client.detachStepEvent(this._updateLastPlayedStep,this);this._dvl.Renderer.SetViewStateManager(null,this._dvlRendererId);this._graphicsCore._deregisterViewport(this);this._dvl=null;}this._graphicsCore=f;if(this._graphicsCore){this._dvl=this._graphicsCore._getDvl();this._graphicsCore._registerViewport(this);this.setShowDebugInfo(this.getShowDebugInfo());this._dvl.Client.attachStepEvent(this._updateLastPlayedStep,this);this._dvl.Client.attachFrameFinished(this._handleFrameFinished,this);this._dvl.Renderer.SetViewStateManager(this._viewStateManager,this._dvlRendererId);}}return this;};v.prototype.getGraphicsCore=function(){return this._graphicsCore;};v.prototype._setCanvas=function(f){var i=this.getDomRef()&&this._canvas!==f;this._canvas=f;if(i){this.invalidate();}return this;};v.prototype._setRenderer=function(f){this._dvlRendererId=f;return this;};v.prototype._updateLastPlayedStep=function(f){if(f.type===sap.ve.dvl.DVLSTEPEVENT.DVLSTEPEVENT_STARTED){this._lastPlayedStep=f.stepId;}};v.prototype.setScene=function(f){if(this._dvlRendererId){this._dvl.Renderer.AttachScene(f&&f.getSceneRef()||null,this._dvlRendererId);this._dvlSceneRef=f?f.getSceneRef():null;if(f){this._dvl.Client.attachUrlClicked(this._fireUrlClicked,this);var i=this._isSmart2DContent()||this._isSmart2DContentLegacy();if(i){this._dvl.Renderer.SetBackgroundColor(1,1,1,1,1,1,1,1,this._dvlRendererId);}else{var j=this._getDecomposedABGR(this.getBackgroundColorTopABGR());var m=this._getDecomposedABGR(this.getBackgroundColorBottomABGR());this._dvl.Renderer.SetBackgroundColor(j.red,j.green,j.blue,j.alpha,m.red,m.green,m.blue,m.alpha,this._dvlRendererId);}this.fireViewActivated({type:i?"2D":"3D"});}else{this._dvl.Client.detachUrlClicked(this._fireUrlClicked,this);if(this._smart2DHandler){this._loco.removeHandler(this._smart2DHandler);}this.invalidate();}}return this;};v.prototype._isSmart2DContent=function(){var f=p(this._dvl.Scene.RetrieveSceneInfo(this._dvlSceneRef,sap.ve.dvl.DVLSCENEINFO.DVLSCENEINFO_HOTSPOTS).ChildNodes);return f&&f.length>0;};v.prototype._isSmart2DContentLegacy=function(){var f=this._dvl.Scene.GetCurrentCamera(this._dvlSceneRef),i=this._dvl.Camera.GetRotation(f),j=this._dvl.Camera.GetProjection(f);return i[0]===90&&i[1]===-90&&i[2]===0&&j===sap.ve.dvl.DVLCAMERAPROJECTION.ORTHOGRAPHIC;};v.prototype._initializeSmart2DHandler=function(){if(this._viewStateManager){if(this._smart2DHandler){this._loco.removeHandler(this._smart2DHandler);}this._smart2DHandler=new k(this,this._viewStateManager);this._loco.addHandler(this._smart2DHandler,0);}if(this.getShowAllHotspots()){var f=this._viewStateManager.getNodeHierarchy(),i=f.getHotspotNodeIds();this.showHotspots(i,true);}};v.prototype._fireUrlClicked=function(f){this.fireUrlClicked({url:f.url,nodeRef:f.nodeId});};v.prototype.setHotspotColorABGR=function(f){this.setProperty("hotspotColorABGR",f,true);this.setProperty("hotspotColor",d(a(this.getProperty("hotspotColorABGR"))),true);return this;};v.prototype.setHotspotColor=function(f){this.setProperty("hotspotColor",f,true);this.setProperty("hotspotColorABGR",c(g(this.getProperty("hotspotColor"))),true);return this;};v.prototype._getStepAndProcedureIndexes=function(f,m){var x=-1,y=-1,N=false;for(var i=0;i<f.length;i++){if(!N){for(var j=0;j<f[i].steps.length;j++){if(f[i].steps[j].id===m){y=j;x=i;N=true;break;}}}else{break;}}return{stepIndex:y,procedureIndex:x};};v.prototype._getStepVeIdById=function(f){if(f){var i=this._dvl.Scene.RetrieveVEIDs(this._dvlSceneRef,f);if(Array.isArray(i)){for(var j=0,m=i.length;j<m;++j){var x=i[j];if(x.source==="SAP"&&x.type==="VE_VIEWPORT"&&Array.isArray(x.fields)){for(var y=0,N=x.fields.length;y<N;++y){var O=x.fields[y];if(O.name==="ID"){return O.value;}}}}}}return null;};v.prototype._getStepIdByVeId=function(f,i){for(var j=0,m=f.length;j<m;++j){var x=f[j].steps;for(var y=0,N=x.length;y<N;++y){var O=x[y].id;if(this._getStepVeIdById(O)===i){return O;}}}return null;};var z=function(f){f.camera={};};var A=function(f){if(typeof f.camera==="object"&&f.camera!==null){f.camera.matrices=false;}};var B=function(f){if(typeof f.camera==="object"&&f.camera!==null){f.camera.useTransitionCamera=false;}};var D=function(f){f.animation=true;};var E=function(f){f.visibility=false;};var F=function(f){if(typeof f.visibility==="object"&&f.visibility!==null){f.visibility.mode=o.Complete;}};v.prototype.getViewInfo=function(f){if(!this._dvlSceneRef){return null;}var i={};if(typeof f!=="object"||f===null){z(i);A(i);B(i);D(i);E(i);F(i);}else{if(typeof f.camera==="object"&&f.camera!==null){i.camera={};if(typeof f.camera.matrices==="boolean"){i.camera.matrices=f.camera.matrices;}else if("matrices"in f.camera){i.camera.matrices=false;}else{A(i);}if(typeof f.camera.useTransitionCamera==="boolean"){i.camera.useTransitionCamera=f.camera.useTransitionCamera;}else if("useTransitionCamera"in f.camera){i.camera.useTransitionCamera=false;}else{B(i);}}else if(typeof f.camera==="boolean"){if(f.camera===true){i.camera={};A(i);B(i);}else{i.camera=false;}}else if("camera"in f){i.camera=false;}else{z(i);A(i);B(i);}if(typeof f.animation==="boolean"){i.animation=f.animation;}else if("animation"in f){i.animation=false;}else{D(i);}if(typeof f.visibility==="object"&&f.visibility!==null){i.visibility={};if(f.visibility.mode===o.Complete||f.visibility.mode===o.Differences){i.visibility.mode=f.visibility.mode;}else{F(i);}}else if(typeof f.visibility==="boolean"){if(f.visibility===true){i.visibility={};F(i);}else{i.visibility=false;}}else if("visibility"in f){i.visibility=false;}else{E(i);F(i);}}var j={};if(i.camera){var m=null;if(i.camera.useTransitionCamera){m=this._dvl.Renderer.GetTransitionCamera(this._dvlRendererId);if(m===sap.ve.dvl.DVLID_INVALID){m=null;}}if(m===null){m=this._dvl.Renderer.GetCurrentCamera(this._dvlRendererId);}var x=this._dvl.Camera.GetRotation(m),y=this._dvl.Camera.GetOrigin(m);j.camera={rotation:{yaw:x[0],pitch:x[1],roll:x[2]},position:{x:y[0],y:y[1],z:y[2]},projectionType:t.encodedProjectionType[this._dvl.Camera.GetProjection(m)],bindingType:t.encodedBindingType[this._dvl.Camera.GetFOVBinding(m)]};if(this._matView){j.viewMatrix=this._matView.slice();}if(this._matProj){j.projectionMatrix=this._matProj.slice();}if(j.camera.projectionType===b.Perspective){j.camera.fieldOfView=this._dvl.Camera.GetFOV(m);}else if(j.camera.projectionType===b.Orthographic){j.camera.zoomFactor=this._dvl.Camera.GetOrthoZoomFactor(m);}if(i.camera.matrices){var N=this._dvl.Renderer.GetCameraMatrices(this._dvlRendererId);j.camera.matrices={view:N.view,projection:N.projection};}}if(i.animation){var O=this._dvl.Scene.RetrieveSceneInfo(this._dvlSceneRef,sap.ve.dvl.DVLSCENEINFO.DVLSCENEINFO_STEP_INFO),P=O.StepId!==sap.ve.dvl.DVLID_INVALID;var Q=P?O.StepId:this._lastPlayedStep,T=P?O.StepTime:0,U=this._dvl.Scene.RetrieveProcedures(this._dvlSceneRef),W=this._getStepAndProcedureIndexes(U.procedures,Q),X=this._getStepVeIdById(Q);j.animation={animationTime:T,stepIndex:W.stepIndex,procedureIndex:W.procedureIndex};if(X){j.animation.stepVeId=X;}}if(i.visibility&&this._viewStateManager){j.visibility={mode:i.visibility.mode};if(i.visibility.mode===o.Complete){var Y=this._viewStateManager.getVisibilityComplete();j.visibility.visible=Y.visible;j.visibility.hidden=Y.hidden;}else if(this._viewStateManager.getShouldTrackVisibilityChanges()){j.visibility.changes=this._viewStateManager.getVisibilityChanges();}else{q.sap.log.warning(h().getText(M.VIT32.summary),M.VIT32.code,"sap.ui.vk.dvl.Viewport");}}return j;};v.prototype.setViewInfo=function(f,i){var j=false;if(f.animation){var m=this._dvl.Scene.RetrieveProcedures(this._dvlSceneRef),x=f.animation.procedureIndex,y=f.animation.stepIndex,N=f.animation.stepVeId,O,P=f.animation.animationTime||0;if(N||y>=0&&x>=0){if(N){O=this._getStepIdByVeId(m.procedures,f.animation.stepVeId);}else if(x>=0&&x<m.procedures.length){if(y>=0&&y<m.procedures[x].steps.length){O=m.procedures[x].steps[y].id;}else{q.sap.log.error(h().getText(M.VIT26.summary),M.VIT26.code,"sap.ui.vk.dvl.Viewport");}}else{q.sap.log.error(h().getText(M.VIT27.summary),M.VIT27.code,"sap.ui.vk.dvl.Viewport");}if(O){this._dvl.Renderer.ActivateStep(this._dvlRendererId,O,false,false,P);this._dvl.Renderer.PauseCurrentStep(this._dvlRendererId);}}else{j=true;}}if(f.camera){var Q;if(f.camera.projectionType===b.Perspective||f.camera.projectionType===b.Orthographic){Q=t.decodedProjectionType[f.camera.projectionType];}else{q.sap.log.error(h().getText(M.VIT19.summary),M.VIT19.code,"sap.ui.vk.dvl.Viewport");Q=sap.ve.dvl.DVLCAMERAPROJECTION.PERSPECTIVE;}var T=this._dvl.Scene.CreateCamera(this._dvlSceneRef,Q,sap.ve.dvl.DVLID_INVALID);if(Q===sap.ve.dvl.DVLCAMERAPROJECTION.PERSPECTIVE){this._dvl.Camera.SetFOV(T,f.camera.fieldOfView);}else if(Q===sap.ve.dvl.DVLCAMERAPROJECTION.ORTHOGRAPHIC){this._dvl.Camera.SetOrthoZoomFactor(T,f.camera.zoomFactor);}if(f.camera.position){this._dvl.Camera.SetOrigin(T,f.camera.position.x,f.camera.position.y,f.camera.position.z);}if(f.camera.rotation){this._dvl.Camera.SetRotation(T,f.camera.rotation.yaw,f.camera.rotation.pitch,f.camera.rotation.roll);}if(f.camera.bindingType){var U=t.decodedBindingType[f.camera.bindingType]||sap.ve.dvl.DVLCAMERAFOVBINDING.MIN;this._dvl.Camera.SetFOVBinding(T,U);}i=i||0;this._dvl.Renderer.ActivateCamera(this._dvlRendererId,T,i);this._dvl.Scene.DeleteNode(this._dvlSceneRef,T);}if(f.viewMatrix){this._matView=f.viewMatrix.slice();}if(f.projectionMatrix){this._matProj=f.projectionMatrix.slice();}if(f.visibility){var W=this._viewStateManager.getNodeHierarchy(),X=new Map(),Y=W.findNodesByName();Y.forEach(function(a1){var b1=W.createNodeProxy(a1),c1=q.grep(b1.getVeIds(),function(c1){return c1.type==="VE_LOCATOR";});c1=Array.isArray(c1)&&c1.length>0?c1[0].fields[0].value:null;W.destroyNodeProxy(b1);if(c1){X.set(c1,a1);}});switch(f.visibility.mode){case o.Complete:var $=f.visibility.visible,_=f.visibility.hidden;$.forEach(function(a1){this._viewStateManager.setVisibilityState(X.get(a1),true,false);},this);_.forEach(function(a1){this._viewStateManager.setVisibilityState(X.get(a1),false,false);},this);break;case o.Differences:if(j){this.resetView({camera:false,visibility:true,transition:false});}f.visibility.changes.forEach(function(a1){var b1=X.get(a1);if(b1){this._viewStateManager.setVisibilityState(b1,!this._viewStateManager.getVisibilityState(b1),false);}},this);break;default:q.sap.log.error(h().getText(M.VIT28.summary),M.VIT28.code,"sap.ui.vk.dvl.Viewport");break;}}return this;};v.prototype.setSelectionRect=function(f){if(!f){this._dvl.Renderer.DrawSelectionRect(0,0,0,0,this._dvlRendererId);}else{this._dvl.Renderer.DrawSelectionRect(f.x1,f.y1,f.x2,f.y2,this._dvlRendererId);}};v.prototype.getOutputSize=function(){var f=this.getViewInfo().camera.bindingType,i=this.getDomRef().getBoundingClientRect(),j=i.width,m=i.height,x;switch(t.decodedBindingType[f]){case sap.ve.dvl.DVLCAMERAFOVBINDING.MIN:x=Math.min(j,m);break;case sap.ve.dvl.DVLCAMERAFOVBINDING.MAX:x=Math.max(j,m);break;case sap.ve.dvl.DVLCAMERAFOVBINDING.HORZ:x=j;break;case sap.ve.dvl.DVLCAMERAFOVBINDING.VERT:x=m;break;default:break;}return{left:(j-x)/2,top:(m-x)/2,sideLength:x};};v.prototype.onBeforeRendering=function(){if(this._resizeListenerId){R.deregister(this._resizeListenerId);this._resizeListenerId=null;}};v.prototype.onAfterRendering=function(){var f=this.getDomRef();if(this._canvas){f.appendChild(this._canvas);}this._resizeListenerId=R.register(this,this._handleResize.bind(this));this._handleResize({size:{width:f.clientWidth,height:f.clientHeight}});};v.prototype._handleResize=function(f){if(this._dvlRendererId&&this._canvas){var i=f.size.width*window.devicePixelRatio;var j=f.size.height*window.devicePixelRatio;if(this._matProj){var m=this._matProj[0];var x=this._matProj[5];var y=Math.max(m,x);if(i>j){m=y*j/i;x=y;}else{m=y;x=y*i/j;}this._matProj[8]*=m/this._matProj[0];this._matProj[9]*=x/this._matProj[5];this._matProj[0]=m;this._matProj[5]=x;}this._dvl.Renderer.SetDimensions(i,j,this._dvlRendererId);this._dvl.Renderer.SetOptionF(sap.ve.dvl.DVLRENDEROPTIONF.DVLRENDEROPTIONF_DPI,96*window.devicePixelRatio,this._dvlRendererId);this._canvas.width=i;this._canvas.height=j;this._canvas.style.width=f.size.width+"px";this._canvas.style.height=f.size.height+"px";this.fireResize({size:{width:f.size.width,height:f.size.height}});return true;}};v.prototype._handleVisibilityChanged=v.prototype._handleSelectionChanged=v.prototype._handleOpacityChanged=v.prototype._handleTintColorChanged=function(f){if(this._dvlRendererId){this._dvl.Renderer.ForceRenderFrame(this._dvlRendererId);}};v.prototype.showHotspots=function(f,i,j){var m=sap.ui.vk.dvl.NodeProxy.prototype[typeof j==="string"?"setTintColor":"setTintColorABGR"];var x=function(N,j,T){var U=N.createNodeProxy(T);m.call(U,j);N.destroyNodeProxy(U);};if(!Array.isArray(f)){f=[f];}var y=j===undefined?this.getHotspotColorABGR():j;if(!i){y=0;}var N=this._viewStateManager.getNodeHierarchy();if(this._isSmart2DContent()){var O=[];f.forEach(function(T){var U=p(this._dvl.Scene.RetrieveNodeInfo(this._dvlSceneRef,T,sap.ve.dvl.DVLNODEINFO.DVLNODEINFO_CHILDREN).ChildNodes);Array.prototype.push.apply(O,U);}.bind(this));Array.prototype.push.apply(O,f);O.forEach(x.bind(null,N,y));}else{var P=[];var Q=function(T){var O=N.getChildren(T);Array.prototype.push.apply(P,O);O.forEach(Q);};f.forEach(Q);Array.prototype.push.apply(P,f);P.forEach(x.bind(null,N,y));}return this;};v.prototype._getDecomposedABGR=function(i){return{red:(i>>>0&0xff)/255,green:(i>>>8&0xff)/255,blue:(i>>>16&0xff)/255,alpha:(i>>>24&0xff)/255};};v.prototype._setBackgroundColor=function(){if(this._dvl){var f=this._getDecomposedABGR(this.getBackgroundColorTopABGR()),i=this._getDecomposedABGR(this.getBackgroundColorBottomABGR());this._dvl.Renderer.SetBackgroundColor(f.red,f.green,f.blue,f.alpha,i.red,i.green,i.blue,i.alpha,this._dvlRendererId);}};v.prototype.setBackgroundColorTopABGR=function(i){this.setProperty("backgroundColorTopABGR",i,true);this._setBackgroundColor();return this;};v.prototype.setBackgroundColorTop=function(f){this.setProperty("backgroundColorTop",f,true);return this.setBackgroundColorTopABGR(c(g(f)));};v.prototype.setBackgroundColorBottomABGR=function(i){this.setProperty("backgroundColorBottomABGR",i,true);this._setBackgroundColor();return this;};v.prototype.setBackgroundColorBottom=function(f){this.setProperty("backgroundColorBottom",f,true);return this.setBackgroundColorBottomABGR(c(g(f)));};v.prototype.setShouldRenderFrame=function(){if(this._dvlRendererId){this._dvl.Renderer.ForceRenderFrame(this._dvlRendererId);}return this;};v.prototype.shouldRenderFrame=function(){return this._dvlRendererId&&this._dvl.Renderer.ShouldRenderFrame(this._dvlRendererId);};v.prototype.renderFrame=function(){if(this._dvlRendererId){if(this._matView&&this._matProj){this.renderFrameEx(this._matView,this._matProj,this._dvlRendererId);}else{this._dvl.Renderer.RenderFrame(this._dvlRendererId);}}return this;};v.prototype.renderFrameEx=function(f,i){if(this._dvlRendererId){this._dvl.Renderer.RenderFrameEx.apply(this,[].concat(f,i),this._dvlRendererId);}return this;};v.prototype.resetView=function(f){if(f!==undefined&&!q.isPlainObject(f)){q.sap.log.error(h().getText(M.VIT31.summary),M.VIT31.code,"sap.ui.vk.dvl.Viewport");}var i={camera:true,transition:true,visibility:false};q.extend(i,f);if(i.camera||i.visibility){var j=(i.camera?sap.ve.dvl.DVLRESETVIEWFLAG.CAMERA:0)|(i.transition?sap.ve.dvl.DVLRESETVIEWFLAG.SMOOTHTRANSITION:0)|(i.visibility?sap.ve.dvl.DVLRESETVIEWFLAG.VISIBILITY:0);if(this._dvlRendererId){this._dvl.Renderer.ResetView(j,this._dvlRendererId);this._lastPlayedStep=null;}}return this;};v.prototype.canIsolateNode=function(f){if(this._dvlRendererId){return this._dvl.Renderer.CanIsolateNode(f,this._dvlRendererId);}else{return false;}};v.prototype.setIsolatedNode=function(f){if(this._dvlRendererId){this._dvl.Renderer.SetIsolatedNode(f,this._dvlRendererId);}return this;};v.prototype.getIsolatedNode=function(){if(this._dvlRendererId){return this._dvl.Renderer.GetIsolatedNode(this._dvlRendererId);}else{return sap.ve.dvl.DVLID_INVALID;}};v.prototype.hitTest=function(x,y){if(this._dvlRendererId){var f=this._dvl.Renderer.HitTest(x*window.devicePixelRatio,y*window.devicePixelRatio,this._dvlRendererId).id;this.setShouldRenderFrame();return f;}else{return null;}};v.prototype.setShowDebugInfo=function(f){this.setProperty("showDebugInfo",f,true);if(this._dvlRendererId){this._dvl.Renderer.SetOption(sap.ve.dvl.DVLRENDEROPTION.DVLRENDEROPTION_SHOW_DEBUG_INFO,f,this._dvlRendererId);}return this;};v.prototype._handleFrameFinished=function(f){if(f.rendererId===this._dvlRendererId){this.fireFrameRenderingFinished();}};v.prototype.beginGesture=function(x,y){if(this._dvlRendererId){this._gesturePoint={x:x,y:y};this._dvl.Renderer.BeginGesture(x*window.devicePixelRatio,y*window.devicePixelRatio,this._dvlRendererId);}return this;};v.prototype.endGesture=function(){if(this._dvlRendererId){this._dvl.Renderer.EndGesture(this._dvlRendererId);}return this;};v.prototype._activateRedline=function(){this.renderFrame();var m=this._dvl.Renderer.GetCameraMatrices();this._matView=m.view;this._matProj=m.projection;};v.prototype._deactivateRedline=function(){this._matView=null;this._matProj=null;};v.prototype.pan=function(f,i){if(this._dvlRendererId&&!this.getFreezeCamera()){if(this._matProj){var j=this.getDomRef();this._matProj[8]-=f*2/j.clientWidth;this._matProj[9]+=i*2/j.clientHeight;this.setShouldRenderFrame();}else{this._dvl.Renderer.Pan(f*window.devicePixelRatio,i*window.devicePixelRatio,this._dvlRendererId);}this.firePan({dx:f,dy:i});}return this;};v.prototype.rotate=function(f,i){if(this._dvlRendererId&&!this.getFreezeCamera()){this._dvl.Renderer.Rotate(f*window.devicePixelRatio,i*window.devicePixelRatio,this._dvlRendererId);this.fireRotate({dx:f,dy:i});}return this;};function G(f){var m=f;var i=m[15]===1;var j=2/m[0];var x=2/m[5];var y,N;if(i){y=-m[12]*j;N=-m[13]*x;}else{y=m[8]*j;N=m[9]*x;}var O=(j+y)*0.5;var P=y-O;var Q=(x+N)*0.5;var T=N-Q;return{left:P,top:Q,right:O,bottom:T};}function H(f,i){var m=f;var j=m[15]===1;m[0]=2/(i.right-i.left);m[5]=2/(i.top-i.bottom);if(j){m[12]=-(i.right+i.left)/(i.right-i.left);m[13]=-(i.top+i.bottom)/(i.top-i.bottom);}else{m[8]=(i.right+i.left)/(i.right-i.left);m[9]=(i.top+i.bottom)/(i.top-i.bottom);}}v.prototype.zoom=function(i){if(this._dvlRendererId&&!this.getFreezeCamera()){if(this._matProj){var j=this.getDomRef();var m=G(this._matProj);var x=m.left+(m.right-m.left)*this._gesturePoint.x/j.clientWidth;var y=m.top+(m.bottom-m.top)*this._gesturePoint.y/j.clientHeight;var f=1/i;m.left=x+(m.left-x)*f;m.right=x+(m.right-x)*f;m.top=y+(m.top-y)*f;m.bottom=y+(m.bottom-y)*f;H(this._matProj,m);this.setShouldRenderFrame();}else{this._dvl.Renderer.Zoom(i,this._dvlRendererId);}this.fireZoom({zoomFactor:i});}return this;};v.prototype.zoomTo=function(f,j,m,x){if(this._dvlRendererId){var y=0;if(Array.isArray(f)){for(var i in f){y|=t.decodedZoomTo[f[i]];}}else{y=t.decodedZoomTo[f];}this._dvl.Renderer.ZoomTo(y,j,m,x,this._dvlRendererId);}return this;};v.prototype.tap=function(x,y,i){if(this._dvlRendererId){var f=x*window.devicePixelRatio,j=y*window.devicePixelRatio;if(!i){var m=this.hitTest(x,y);var N={picked:m===sap.ve.dvl.DVLID_INVALID||m==null?[]:[m]};this.fireNodesPicked(N);if(this.getSelectionMode()===S.Exclusive){this.exclusiveSelectionHandler(N.picked);}else if(this.getSelectionMode()===S.Sticky){this.stickySelectionHandler(N.picked);}if(m!==sap.ve.dvl.DVLID_INVALID){this.fireNodeClicked({nodeRef:m,nodeId:m,x:x,y:y},true,true);}this._dvl.Renderer.Tap(f,j,false,false,this._dvlRendererId);}else if(!this.getFreezeCamera()){this._dvl.Renderer.Tap(f,j,true,false,this._dvlRendererId);}}return this;};v.prototype.rectSelect=function(x,y,f,i){var j=[];if(this._dvlRendererId){var m=p(this._dvl.Renderer.RectSelect(x,y,f,i,this._dvlRendererId));if(m.SelectedNodes){j=m.SelectedNodes;}}return j;};v.prototype.queueCommand=function(f){if(this._dvlRendererId){this._dvl.Renderer._queueCommand(f,this._dvlRendererId);}return this;};v.prototype._setContent=function(f){var i=null;if(f&&f instanceof r){i=f;}this._setScene(i);};v.prototype._onAfterUpdateContentConnector=function(){this._setContent(this._contentConnector.getContent());};v.prototype._onBeforeClearContentConnector=function(){this._setScene(null);};v.prototype._handleContentReplaced=function(f){var i=f.getParameter("newContent");this._setContent(i);};v.prototype._setScene=function(f){var i=f&&f.getGraphicsCore();this.setGraphicsCore(i);this.setScene(f);if(f&&(this._isSmart2DContent()||this._isSmart2DContentLegacy())){this._initializeSmart2DHandler();}};v.prototype._handleContentChangesFinished=function(f){if(f.getSource().getContentResources().length>1){this.zoomTo(Z.Visible,sap.ve.dvl.DVLID_INVALID,0,0);}this.setShouldRenderFrame();};v.prototype._onAfterUpdateViewStateManager=function(){if(this._dvl){this._dvl.Renderer.SetViewStateManager(this._viewStateManager,this._dvlRendererId);}};v.prototype._onBeforeClearViewStateManager=function(){if(this._dvl){this._dvl.Renderer.SetViewStateManager(null,this._dvlRendererId);}};var I={x:-2,y:-2};var J=2;var K=5;[{key:"left",dx:-J,dy:0},{key:"right",dx:+J,dy:0},{key:"up",dx:0,dy:-J},{key:"down",dx:0,dy:+J}].forEach(function(i){v.prototype["onsap"+i.key]=function(f){this.beginGesture(I.x,I.y);this.rotate(i.dx,i.dy);this.endGesture();this.setShouldRenderFrame();f.preventDefault();f.stopPropagation();};});[{key:"left",dx:-K,dy:0},{key:"right",dx:+K,dy:0},{key:"up",dx:0,dy:-K},{key:"down",dx:0,dy:+K}].forEach(function(i){v.prototype["onsap"+i.key+"modifiers"]=function(f){if(f.shiftKey&&!(f.ctrlKey||f.altKey||f.metaKey)){this.beginGesture(I.x,I.y);this.pan(i.dx,i.dy);this.endGesture();this.setShouldRenderFrame();f.preventDefault();f.stopPropagation();}};});[{key:"minus",d:0.98},{key:"plus",d:1.02}].forEach(function(i){v.prototype["onsap"+i.key]=function(f){this.beginGesture(this.$().width()/2,this.$().height()/2);this.zoom(i.d);this.endGesture();this.setShouldRenderFrame();f.preventDefault();f.stopPropagation();};});e.injectMethodsIntoClass(v);n.injectMethodsIntoClass(v);return v;});
