/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["../PerspectiveCamera","./thirdparty/three"],function(P,t){"use strict";var T=P.extend("sap.ui.vk.threejs.PerspectiveCamera",{metadata:{}});var b=P.getMetadata().getParent().getClass().prototype;T.prototype.init=function(){if(b.init){b.init.call(this);}var n=1;var f=10000;this._nativeCamera=new THREE.PerspectiveCamera(30,1,n,f);this._nativeCamera.position.set(0,0,100);this.setUsingDefaultClipPlanes(true);};T.prototype.update=function(w,h){var o=this._nativeCamera.aspect;var a=this._nativeCamera.zoom;this._nativeCamera.aspect=w/h;this._nativeCamera.zoom=Math.min(this._nativeCamera.aspect,1);var v=this._nativeCamera.view;if(v&&v.enabled){var s=w/v.fullWidth;var c=h/v.fullHeight;var d=this._nativeCamera.zoom/a;var e=d*o/this._nativeCamera.aspect;v.offsetX=(v.offsetX*e+(v.fullWidth-v.width)*(1-e)*0.5)*s;v.offsetY=(v.offsetY*d+(v.fullHeight-v.height)*(1-d)*0.5)*c;v.width*=s;v.height*=c;v.fullWidth=w;v.fullHeight=h;}this._nativeCamera.updateProjectionMatrix();};T.prototype.exit=function(){if(b.exit){b.exit.call(this);}this._nativeCamera=null;};T.prototype.getFov=function(){return this._nativeCamera.fov;};T.prototype.setFov=function(v){this._nativeCamera.fov=v;this._nativeCamera.updateProjectionMatrix();this.setIsModified(true);return this;};T.prototype.getCameraRef=function(){return this._nativeCamera;};T.prototype.setCameraRef=function(c){this._nativeCamera=c;return this;};T.prototype.getNearClipPlane=function(){return this._nativeCamera.near;};T.prototype.setNearClipPlane=function(v){this._nativeCamera.near=v;this.setUsingDefaultClipPlanes(false);this._nativeCamera.updateProjectionMatrix();this.setIsModified(true);return this;};T.prototype.getFarClipPlane=function(){return this._nativeCamera.far;};T.prototype.setFarClipPlane=function(v){this._nativeCamera.far=v;this.setUsingDefaultClipPlanes(false);this._nativeCamera.updateProjectionMatrix();this.setIsModified(true);return this;};T.prototype.getPosition=function(){return this._nativeCamera.position.toArray();};T.prototype.setPosition=function(v){this._nativeCamera.position.fromArray(v);this._nativeCamera.updateMatrixWorld();return this;};T.prototype.getUpDirection=function(){return this._nativeCamera.up.toArray();};T.prototype.setUpDirection=function(v){this._nativeCamera.up.fromArray(v);this._nativeCamera.updateMatrixWorld();return this;};T.prototype.getTargetDirection=function(){return this._nativeCamera.getWorldDirection().toArray();};T.prototype.setTargetDirection=function(v){var a=new THREE.Vector3().fromArray(v);a.add(this._nativeCamera.position);this._nativeCamera.lookAt(a);return this;};T.prototype.setUsingDefaultClipPlanes=function(v){this._nativeCamera.userData.usingDefaultClipPlanes=v;return this;};T.prototype.getUsingDefaultClipPlanes=function(){return this._nativeCamera.userData.usingDefaultClipPlanes;};T.prototype.adjustClipPlanes=function(a){var e=this._nativeCamera;e.updateMatrixWorld();a=a.clone().applyMatrix4(e.matrixWorldInverse);e.near=-a.max.z;e.far=-a.min.z;var f=Math.max((e.far-e.near)*0.0025,0.001);e.far=Math.max(e.far,0.1);f=Math.max(f,e.far*0.0025);e.near-=f;e.far+=f;e.near=Math.max(e.near,e.far*0.0025);var c=-(e.far+e.near)/(e.far-e.near);var d=-2*e.far*e.near/(e.far-e.near);e.projectionMatrix.elements[10]=c;e.projectionMatrix.elements[14]=d;return this;};return T;});
