/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["jquery.sap.global","../ViewportBase","sap/ui/core/ResizeHandler","sap/ui/events/KeyCodes","../Loco","./thirdparty/three","../ContentConnector","../ViewStateManager","./ViewportGestureHandler","./OrthographicCamera","./PerspectiveCamera","./NodesTransitionHelper","../Messages","sap/ui/base/ManagedObjectObserver","./ViewportRenderer","../CameraProjectionType","../CameraFOVBindingType","../VisibilityMode","../ZoomTo","../SelectionMode","../RenderMode","../getResourceBundle","../cssColorToColor","../ViewStateManager","./ViewStateManager","./Scene","./ContentDeliveryService","./AnimationTimeController","./AnimationHelper","../AnimationTrackType"],function(Q,V,R,K,L,c,C,d,f,O,P,N,M,g,k,l,n,o,Z,S,r,u,v,z,T,A,B,D,E,F){"use strict";var G=V.extend("sap.ui.vk.threejs.Viewport",{metadata:{library:"sap.ui.vk",events:{cameraChanged:{parameters:{position:"float[]",quaternion:"float[]",zoom:"float"},enableEventBubbling:true},frameRenderingFinished:{}}}});var H=G.getMetadata().getParent().getClass().prototype;THREE.PropertyBinding.prototype.GetterByBindingType[0]=function(b,a){b[a]=this.targetObject[this.propertyName];};THREE.AnimationMixer.prototype.updateWithoutMixing=function(a){a*=this.timeScale;var b=this._actions,e=this._nActiveActions,t=this.time+=a,h=Math.sign(a),p=this._accuIndex^=1;var q=this._bindings,s=this._nActiveBindings;var i;for(i=0;i!==s;++i){q[i].realCumulativeWeight=0;}for(i=0;i!==e;++i){var w=b[i];var x=w._propertyBindings;var j,m;if(x){for(j=0,m=x.length;j!==m;++j){x[j].cumulativeWeight=0;}}w._update(t,a,h,p);if(x){for(j=0,m=x.length;j!==m;++j){x[j].realCumulativeWeight+=x[j].cumulativeWeight;}}}for(i=0;i!==s;++i){if(q[i].realCumulativeWeight){q[i].cumulativeWeight=1;}q[i].apply(p);}return this;};G.prototype.init=function(){if(H.init){H.init.call(this);}this._resizeListenerId=null;this._renderLoopRequestId=0;this._renderLoopFunction=this._renderLoop.bind(this);this._shouldRenderFrame=true;this._clippingPlanes=[];this._animationMixer=null;this._renderer=new THREE.WebGLRenderer({antialias:true,alpha:true});this._renderer.setPixelRatio(window.devicePixelRatio);this._renderer.setSize(1,1);this._renderer.shadowMap.enabled=true;this._camera=new P();var b=["varying float vPos;","void main() {","	gl_Position = vec4(position, 1.0);","	vPos = position.y * -0.5 + 0.5;","}"].join("\n");var a=["uniform vec4 topColor;","uniform vec4 bottomColor;","varying float vPos;","void main() {","	gl_FragColor = mix(topColor, bottomColor, vPos);","}"].join("\n");var e=new THREE.Vector4();var h=new THREE.Vector4();this._updateColor(e,this.getBackgroundColorTop());this._updateColor(h,this.getBackgroundColorBottom());this._checkBackgroundColor();this._backgroundMaterial=new THREE.ShaderMaterial({uniforms:{topColor:{value:e},bottomColor:{value:h}},vertexShader:b,fragmentShader:a,side:THREE.DoubleSide,depthTest:false,depthWrite:false,blending:THREE.NoBlending});var i=new THREE.Geometry();i.vertices.push(new THREE.Vector3(-1,1,0),new THREE.Vector3(1,1,0),new THREE.Vector3(-1,-1,0),new THREE.Vector3(1,-1,0));i.faces.push(new THREE.Face3(0,2,1),new THREE.Face3(1,2,3));this._backgroundCamera=new THREE.Camera();this._backgroundScene=new THREE.Scene();this._backgroundScene.add(new THREE.Mesh(i,this._backgroundMaterial));var x=["#include <clipping_planes_pars_vertex>","varying vec3 vNormal;","void main() {","#include <begin_vertex>","#include <project_vertex>","#include <clipping_planes_vertex>","#include <beginnormal_vertex>","#include <defaultnormal_vertex>","	vNormal = normalize( transformedNormal );","}"].join("\n");var j=["#include <clipping_planes_pars_fragment>","uniform vec4 color1;","uniform vec4 color2;","varying vec3 vNormal;","void main() {","#include <clipping_planes_fragment>","	gl_FragColor = mix(color1, color2, abs(normalize(vNormal).z));","}"].join("\n");this._xrayColor1=new THREE.Vector4(0,0.75,1,0.45);this._xrayColor2=new THREE.Vector4(0,0,1,0);this._xrayMaterial=new THREE.ShaderMaterial({uniforms:{color1:{value:this._xrayColor1},color2:{value:this._xrayColor2}},vertexShader:x,fragmentShader:j,side:THREE.DoubleSide,depthWrite:false,depthFunc:THREE.LessDepth,blending:THREE.NormalBlending,clipping:true,transparent:true});this._viewportGestureHandler=new f(this);this._loco=new L(this);this._loco.addHandler(this._viewportGestureHandler,-1);this._zoomedObject=null;this._nodesTransitionHelper=new N();this._nodesTransitionHelper.setViewport(this);this._cdsLoader=null;this._animationTimeController=new D();this._animationHelper=new E();this.attachCameraChanged(function(m){this.setShouldRenderFrame();});this._sceneObserver=new g(this.setShouldRenderFrame.bind(this));this._currentViews=null;this._currentViewIndex=0;this._currentView=null;this._playingProcedure=false;this._playingPlaybacks=false;this._totalTimeOfPlaybacks=0;this._startTimeOfPlaybacks=0;this._notPlayingAnimations=false;this._currentAnimationActions=[];};G.prototype.cameraUpdateCompleted=function(p){var a=function(b){var e;if(b._currentView){e=b._currentView.getPlaybacks();}if(e&&e.length&&!b._notPlayingAnimations){b._startAnimation();}else if(!e||b._notPlayingAnimations){b.fireViewFinished({viewIndex:this._currentViewIndex});b._playNextStep();}else{b._playNextStep();}};if(this._playingPlaybacks){setTimeout(a,10,this);}else{this.fireViewFinished({viewIndex:this._currentViewIndex});}this._playingPlaybacks=false;};G.prototype.exit=function(){this._loco.removeHandler(this._viewportGestureHandler);this._viewportGestureHandler.destroy();if(this._resizeListenerId){R.deregister(this._resizeListenerId);this._resizeListenerId=null;}this._stopRenderLoop();this.setScene(null);this.setCamera(null);this._renderer=null;this._backgroundCamera=null;this._backgroundMaterial=null;this._backgroundScene=null;this._loco=null;this._viewportGestureHandler=null;if(this._cdsLoader){this._cdsLoader.detachSceneUpdated(this._handleCdsSceneUpdate,this);}if(H.exit){H.exit.call(this);}};G.prototype._startRenderLoop=function(){if(!this._renderLoopRequestId){this._renderLoopRequestId=window.requestAnimationFrame(this._renderLoopFunction);}return this;};G.prototype._stopRenderLoop=function(){if(this._renderLoopRequestId){window.cancelAnimationFrame(this._renderLoopRequestId);this._renderLoopRequestId=0;}return this;};G.prototype.setBackgroundColorTop=function(a){H.setBackgroundColorTop.call(this,a);if(this._backgroundMaterial!==null){this._updateColor(this._backgroundMaterial.uniforms.topColor.value,a);this._checkBackgroundColor();}return this;};G.prototype.pauseAnimation=function(){this._animationTimeController.pause();this.setShouldRenderFrame();};G.prototype.resumeAnimation=function(){this._animationTimeController.resume();this.setShouldRenderFrame();};G.prototype.handleDragAnimation=function(e){var p=e.getParameter("value");if(this._animationTimeController.isAnimationStopped()||!this._animationMixer){if(!this._startAnimation(true)){return;}}this._animationTimeController.drag(p);this.setShouldRenderFrame();};G.prototype.handleCompleteDraggingAnimation=function(e){var p=e.getParameter("value");if(!this._animationTimeController.isAnimationStopped()){this._animationTimeController.completeDragging(p);}this.setShouldRenderFrame();};G.prototype.handleKeyFrameAdded=function(e){var a=e.getParameters();if(a.trackType===F.rotate){a.targetNodeRef.quaternion.set(a.keyFrameValue[0],a.keyFrameValue[1],a.keyFrameValue[2],a.keyFrameValue[3]);}else if(a.trackType===F.translate){a.targetNodeRef.position.set(a.keyFrameValue[0],a.keyFrameValue[1],a.keyFrameValue[2]);}else if(a.trackType===F.scale){a.targetNodeRef.scale.set(a.keyFrameValue[0],a.keyFrameValue[1],a.keyFrameValue[2]);}else if(a.trackType===F.opacity){a.targetNodeRef.traverse(function(b){if(b.material&&b.material.opacity){b.userData.opacity=a.keyFrameValue[0];b._vkUpdateMaterialOpacity();}});}else if(a.trackType===F.color){a.targetNodeRef.traverse(function(b){if(b.material&&b.material.color){b.material.color.setRGB(a.keyFrameValue[0],a.keyFrameValue[1],a.keyFrameValue[2]);}});}this.setShouldRenderFrame();};G.prototype.handleKeyFrameUpdated=function(e){this.handleKeyFrameAdded(e);this.setShouldRenderFrame();};G.prototype.handleKeyFrameDeleted=function(e){var a=e.getParameters();var b=this._scene.getAnimationSequence(a.sequenceId);if(!b){return;}var h=b.getNearestKeyFrame(a.targetNodeRef,a.trackType,a.keyFrameTime);if(h){if(a.trackType===F.rotate){var i=b.getRotateKeyFrameInQuaternion(a.targetNodeRef,h.index);if(i){a.targetNodeRef.quaternion.set(i[0],i[1],i[2],i[3]);}}else if(a.trackType===F.translate){a.targetNodeRef.position.set(h.value[0],h.value[1],h.value[2]);}else if(a.trackType===F.scale){a.targetNodeRef.scale.set(h.value[0],h.value[1],h.value[2]);}else if(a.trackType===F.opacity){a.targetNodeRef.traverse(function(m){if(m.material&&m.material.opacity){m.userData.opacity=h.value[0];m._vkUpdateMaterialOpacity();}});}else if(a.trackType===F.color){a.targetNodeRef.traverse(function(m){if(m.material&&m.material.color){m.material.color.setRGB(h.value[0],h.value[1],h.value[2]);}});}}else{var j;if(a.trackType===F.rotate||a.trackType===F.translate||a.trackType===F.scale){j=this._animationHelper.getNodePositionFromNearestPlayback(this._scene,this._currentView,a.sequenceId,a.targetNodeRef);if(!j){j=this._animationHelper.getNodePositionByView(this._currentView,a.targetNodeRef);}}if(j){if(a.trackType===F.rotate){a.targetNodeRef.quaternion.copy(j.quaternion);var q=[j.quaternion.x,j.quaternion.y,j.quaternion.z,j.quaternion.w];b.resetOriginalPosition(a.targetNodeRef,q,null,null);}else if(a.trackType===F.translate){a.targetNodeRef.position.copy(j.position);var p=[j.position.x,j.position.y,j.position.z];b.resetOriginalPosition(a.targetNodeRef,null,p,null);}else if(a.trackType===F.scale){a.targetNodeRef.scale.copy(j.scale);var s=[j.scale.x,j.scale.y,j.scale.z];b.resetOriginalPosition(a.targetNodeRef,null,null,s);}}}this.setShouldRenderFrame();};G.prototype.AddHandlersToAnimationSequenceEvents=function(a){a.detachKeyFrameAdded(this.handleKeyFrameAdded,this);a.detachKeyFrameUpdated(this.handleKeyFrameUpdated,this);a.detachKeyFrameDeleted(this.handleKeyFrameDeleted,this);a.attachKeyFrameAdded(this.handleKeyFrameAdded,this);a.attachKeyFrameUpdated(this.handleKeyFrameUpdated,this);a.attachKeyFrameDeleted(this.handleKeyFrameDeleted,this);};G.prototype.setBackgroundColorBottom=function(a){H.setBackgroundColorBottom.call(this,a);if(this._backgroundMaterial!==null){this._updateColor(this._backgroundMaterial.uniforms.bottomColor.value,a);this._checkBackgroundColor();}return this;};G.prototype.setClippingPlanes=function(a){this._clippingPlanes=a;return this;};G.prototype.onBeforeRendering=function(){if(this._resizeListenerId){R.deregister(this._resizeListenerId);this._resizeListenerId=null;}this._stopRenderLoop();};G.prototype.onAfterRendering=function(){var a=this.getDomRef();a.appendChild(this._renderer.domElement);this._resizeListenerId=R.register(this,this._handleResize.bind(this));this._handleResize({size:{width:a.clientWidth,height:a.clientHeight}});this._startRenderLoop();};G.prototype._handleResize=function(e){if(!this._camera||!this._renderer){return false;}var w=e.size.width;var h=e.size.height;if(this._camera){this._camera.update(w,h);}this._renderer.setSize(w,h);this.fireResize({size:{width:w,height:h}});this.setShouldRenderFrame();return true;};G.prototype.setScene=function(s){this._scene=s;this._homeCamera=null;this._sceneObserver.disconnect();var a=this._scene?this._scene.getSceneRef():undefined;if(a){this._sceneObserver.observe(this._scene,{properties:["doubleSided"]});var b;for(var i=0;i<a.children.length;i++){b=a.children[i];if(b.private&&b.name==="DefaultLights"&&b.children.length){if(b.children[0]instanceof THREE.PointLight){this._eyePointLight=b.children[0];}}}}this._animationTimeController.reset();this.fireAnimationUpdated({value:0});this.setShouldRenderFrame();return this;};G.prototype.getScene=function(){return this._scene;};G.prototype.setCamera=function(a){if(H.setCamera){H.setCamera.call(this,a);}var b=this.getCamera();if(b&&this._renderer){var s=this._renderer.getSize();b.update(s.width,s.height);if(!this._homeCamera&&b.getCameraRef()){this._homeCamera=b.getCameraRef().clone();}}this.setShouldRenderFrame();return this;};G.prototype.getRenderer=function(){return this._renderer;};G.prototype._getViewStateManagerThreeJS=function(){if(this._viewStateManager){if(this._viewStateManager instanceof T){return this._viewStateManager;}if(this._viewStateManager instanceof z&&this._viewStateManager._implementation instanceof T){return this._viewStateManager._implementation;}}return null;};G.prototype._updateBoundingBoxesIfNeeded=function(){var a=this._getViewStateManagerThreeJS();if(a){a._updateBoundingBoxesIfNeeded();}};G.prototype._updateColor=function(a,b){var e=v(b);a.color=new THREE.Color(e.red/255,e.green/255,e.blue/255);a.alpha=e.alpha;a.x=a.color.r*a.alpha;a.y=a.color.g*a.alpha;a.z=a.color.b*a.alpha;a.w=a.alpha;};G.prototype._checkBackgroundColor=function(){var a=this.getBackgroundColorTop();if(a===this.getBackgroundColorBottom()){if(this._backgroundColor===null){this._backgroundColor=new THREE.Vector4();}this._updateColor(this._backgroundColor,a);}else{this._backgroundColor=null;}this.setShouldRenderFrame();};G.prototype._handleCdsSceneUpdate=function(){this.setShouldRenderFrame();};G.prototype.setShouldRenderFrame=function(){this._shouldRenderFrame=true;return this;};G.prototype.shouldRenderFrame=function(){return this._shouldRenderFrame;};G.prototype.setRenderMode=function(a){this.setProperty("renderMode",a,true);if(this._scene){switch(a){case r.LineIllustration:case r.ShadedIllustration:case r.SolidOutline:this._scene._createOutlineGeometry(a);break;default:this._scene._hideOutlineGeometry();break;}}this.setShouldRenderFrame();return this;};G.prototype.hitTest=function(x,y){var a=this._scene?this._scene.getSceneRef():undefined;var b=this._camera?this._camera.getCameraRef():undefined;if(!b||!a){return null;}var e=this._renderer.domElement;var m=new THREE.Vector2((x-e.clientLeft)/e.clientWidth*2-1,(e.clientTop-y)/e.clientHeight*2+1);var h=new THREE.Raycaster();h.setFromCamera(m,b);if(this._clippingPlanes){for(var p in this._clippingPlanes){var j=this._clippingPlanes[p];var q=j.distanceToPoint(h.ray.origin),t=-q/j.normal.dot(h.ray.direction);if(t>0){if(q<0){h.near=Math.max(h.near,t);}else{h.far=Math.min(h.far,t);}}else if(q<0){return null;}}}var s=h.intersectObjects(a.children,true);if(s){for(var i in s){var w=s[i];var X=w.object;var Y=X.parent;while(Y){if(Y.userData.closed){X=Y;}Y=Y.parent;}while(X.parent&&((X.userData.treeNode&&X.userData.treeNode.skipIt)||(!X.name&&X.children.length===0))){X=X.parent;}if(!X.isBillboard&&!X.isDetailView){w.object=X;return w;}}}return null;};G.prototype.tap=function(x,y,i){if(!i){if(this._viewStateManager){var h=this.hitTest(x,y);var a=h&&h.object;var p={picked:a?[a]:[]};this.fireNodesPicked(p);if(this.getSelectionMode()===S.Exclusive){this.exclusiveSelectionHandler(p.picked);}else if(this.getSelectionMode()===S.Sticky){this.stickySelectionHandler(p.picked);}if(a!==null){this.fireNodeClicked({nodeRef:a,x:x,y:y},true,true);}}}else if(!this.getFreezeCamera()){var b=this.hitTest(x,y);if(b&&(this._zoomedObject===null||this._zoomedObject!==b.object)){this._zoomedObject=b.object;this._viewportGestureHandler.zoomObject(this._zoomedObject,true);}else{this._viewportGestureHandler.zoomObject(this._zoomedObject,false);this._zoomedObject=null;}}return this;};var I={x:-2,y:-2};var J=2;var U=5;G.prototype.onkeydown=function(e){if(!e.isMarked()){var a;switch(e.keyCode){case K.ARROW_LEFT:case K.ARROW_RIGHT:case K.ARROW_UP:case K.ARROW_DOWN:if(e.ctrlKey||e.altKey||e.metaKey){break;}var b={x:0,y:0};switch(e.keyCode){case K.ARROW_LEFT:b.x=-1;break;case K.ARROW_RIGHT:b.x=+1;break;case K.ARROW_UP:b.y=-1;break;case K.ARROW_DOWN:b.y=+1;break;default:break;}a=this._viewportGestureHandler._cameraController;a.beginGesture(I.x,I.y);if(e.shiftKey){a.pan(U*b.x,U*b.y);}else{a.rotate(J*b.x,J*b.y,true);}a.endGesture();this.setShouldRenderFrame();e.preventDefault();e.stopPropagation();break;case 189:case K.PLUS:case K.NUMPAD_MINUS:case K.NUMPAD_PLUS:a=this._viewportGestureHandler._cameraController;a.beginGesture(this.$().width()/2,this.$().height()/2);a.zoom(e.keyCode===K.PLUS||e.keyCode===K.NUMPAD_PLUS?1.02:0.98);a.endGesture();this.setShouldRenderFrame();e.preventDefault();e.stopPropagation();break;default:break;}}};G.prototype._handleVisibilityChanged=G.prototype._handleOpacityChanged=G.prototype._handleTintColorChanged=G.prototype._handleHighlightColorChanged=function(e){this.setShouldRenderFrame();};G.prototype._handleSelectionChanged=function(e){var t=this.getTools();for(var i=0;i<t.length;i++){var a=sap.ui.getCore().byId(t[i]);var b=a.getGizmoForContainer(this);if(b&&b.handleSelectionChanged){b.handleSelectionChanged(e);}}this.setShouldRenderFrame();};G.prototype.setSelectionRect=function(a){this.setShouldRenderFrame();if(!a){this._selectionRect=null;return;}var s=this._renderer.getSize();var x=(a.x1/s.width)*2-1,y=(a.y1/s.height)*-2+1,b=(a.x2/s.width)*2-1,e=(a.y2/s.height)*-2+1;if(!this._selectionRect){var h=new THREE.Geometry();h.vertices.push(new THREE.Vector3(x,e,-1),new THREE.Vector3(b,e,-1),new THREE.Vector3(b,y,-1),new THREE.Vector3(x,y,-1));this._selectionRect=new THREE.LineLoop(h,new THREE.LineBasicMaterial({color:0xC0C000,linewidth:window.devicePixelRatio}));}else{var i=this._selectionRect.geometry.vertices;i[0].set(x,e,-1);i[1].set(b,e,-1);i[2].set(b,y,-1);i[3].set(x,y,-1);this._selectionRect.geometry.verticesNeedUpdate=true;}};G.prototype._renderLoop=function(){if(!this._renderer||!this.getDomRef()){this._renderLoopRequestId=0;return;}if(this._viewportGestureHandler){this._viewportGestureHandler.animateCameraUpdate();}if(this._nodesTransitionHelper){this._nodesTransitionHelper.displayNodesMoving();}if(this.getCamera()){var a=this.getCamera().getCameraRef();if(this._eyePointLight&&a){this._eyePointLight.position.copy(a.position);}if(this.getCamera().getIsModified()){this.getCamera().setIsModified(false);this._shouldRenderFrame=true;}}if(this._shouldRenderFrame){this._shouldRenderFrame=false;this.render();}this._renderLoopRequestId=window.requestAnimationFrame(this._renderLoopFunction);};function _(a,b,s){s.children.forEach(function(e){if(e.userData._vkDynamicObjects){e.userData._vkDynamicObjects.forEach(function(h){if(h.visible){h._vkUpdate(a,b);}});}});}function W(e,h,s,i,j){s.children.forEach(function(m){if(m.userData._vkDetailViews){m.userData._vkDetailViews.sort(function(a,b){return a.renderOrder-b.renderOrder;});m.userData._vkDetailViews.forEach(function(a){if(a.node.visible){a.detailView._render(e,h,s,i,j);}});}});}G.prototype.render=function(){var a=this._renderer;if(!a){return;}var b=this._scene?this._scene.getSceneRef():null;var e=this._camera?this._camera.getCameraRef():null;if(!b||!e){return;}if(this._animationMixer){var h=this._animationTimeController.getCurrentStatus();if(h.progress<0){this._animationMixer.dispatchEvent({type:"restart"});this._shouldRenderFrame=false;return;}else if(h.delta>0){for(var j=0;j<this._currentAnimationActions.length;j++){var m=this._currentAnimationActions[j];if(!m.enabled||m.paused){m.enabled=true;m.paused=false;}}this._animationMixer.updateWithoutMixing(h.delta);this.setShouldRenderFrame();this.fireAnimationUpdated({value:h.progress});if(h.progress>=100&&!this._animationTimeController.getInfinite()){this._animationMixer.dispatchEvent({type:"complete"});this.fireAnimationFinished();}}else if(h.progress>=100){this._shouldRenderFrame=false;}}var t=this.getTools();var p=this._getViewStateManagerThreeJS();var i,q,s,w;if(this._camera.getUsingDefaultClipPlanes()||(e.isOrthographicCamera&&e.zoom<=0)){w=this._scene._computeBoundingBox(true,false);if(!w.isEmpty()){if(e.isOrthographicCamera&&e.zoom<=0){this._camera.adjustZoom(w);}if(this._camera.getUsingDefaultClipPlanes()){for(i=0;i<t.length;i++){q=sap.ui.getCore().byId(t[i]);s=q.getGizmoForContainer(this);if(s&&s.expandBoundingBox){s.expandBoundingBox(w);}}this._camera.adjustClipPlanes(w);}}}_(a,e,b);a.clippingPlanes=this._clippingPlanes;switch(this.getRenderMode()){case r.XRay:if(p){var x=b.children[b.children.length-1].clone();p._selectedNodes.forEach(function(X){if(X.visible){X.add(x);a.render(X,e);a.autoClear=false;X.remove(x);}});}b.overrideMaterial=this._xrayMaterial;break;case r.LineIllustration:case r.ShadedIllustration:case r.SolidOutline:this._scene._outlineMaterial.linewidth=this._renderer.getPixelRatio();break;default:break;}a.autoClear=this._backgroundColor!=null;if(a.autoClear){a.setClearColor(this._backgroundColor.color,this._backgroundColor.alpha);}else{a.render(this._backgroundScene,this._backgroundCamera);}if(this.getRenderMode()===r.XRay){a.autoClear=false;}a.render(b,e);a.autoClear=false;a.clippingPlanes=[];b.overrideMaterial=null;W(a,e,b,w,this._eyePointLight);if(p){var y=p._boundingBoxesScene;if(y){p._updateBoundingBoxes();a.render(y,e);}}for(i=0;i<t.length;i++){q=sap.ui.getCore().byId(t[i]);s=q.getGizmoForContainer(this);if(s&&s.render){s.render(this);}}if(this._selectionRect){a.render(this._selectionRect,this._backgroundCamera);}this.fireFrameRenderingFinished();};G.prototype.getImage=function(a,b,t,e,i){if(this._scene===null){return null;}a=Math.min(a||16,2048);b=Math.min(b||16,2048);var j=new THREE.WebGLRenderer({preserveDrawingBuffer:true,antialias:true,alpha:true});j.setPixelRatio(window.devicePixelRatio);j.setSize(a,b);var m=this.getBackgroundColorTop();var p=this.getBackgroundColorBottom();if(t&&!e){j.setClearColor(t,1);}else if(!t&&e){j.setClearColor(e,1);}else{if(t&&e){this.setBackgroundColorTop(t);this.setBackgroundColorBottom(e);}j.render(this._backgroundScene,this._backgroundCamera);j.autoClear=false;}document.body.appendChild(j.domElement);var q=this.getCamera().getCameraRef().clone();var s=a/b;if(q.isOrthographicCamera){var w=q.right-q.left;var h=q.top-q.bottom;if(w>h){q.top=w/s/2;q.bottom=-w/s/2;}else{q.left=-h*s/2;q.right=h*s/2;}}else{var x=2*Math.atan(q.aspect*Math.tan(q.fov*Math.PI/360));if(q.fov<x*180/Math.PI){q.fov=360*Math.atan(Math.tan(x*0.5)/s)/Math.PI;}q.aspect=s;}q.updateProjectionMatrix();var y=[];var X=this._getViewStateManagerThreeJS();if(!i){if(X!==null){X.enumerateSelection(function($){y.push($);});X.setSelectionState(y,false,false,true);}}j.render(this._scene.getSceneRef(),q);var Y=j.getContext().canvas.toDataURL();if(X!==null&&y.length>0){X.setSelectionState(y,true,false,true);}document.body.removeChild(j.domElement);j.dispose();if(p&&t){this.setBackgroundColorBottom(p);}if(m&&e){this.setBackgroundColorTop(m);}return Y;};G.prototype._setContent=function(a){var s;var b;if(a){s=a;if(!(s instanceof A)){s=null;}b=a.camera;if(!(b instanceof O||b instanceof P)){b=new P();}if(b instanceof O){var e=new THREE.Box3().setFromObject(s.getSceneRef());var h=e.getCenter();var j=b.getTargetDirection();var p=b.getPosition();var m=[h.x-p[0],h.y-p[1],h.z-p[2]];var q=m[0]*j[0]+m[1]*j[1]+m[2]*j[2];if(q<0){var t=e.getSize().length()/2;t-=q;p[0]-=j[0]*t;p[1]-=j[1]*t;p[2]-=j[2]*t;b.setPosition(p);}}var i;if(a.loaders){for(i=0;i<a.loaders.length;i++){if(a.loaders[i]instanceof B){this._cdsLoader=a.loaders[i];this._cdsLoader.attachSceneUpdated(this._handleCdsSceneUpdate,this);break;}}}if(a.builders){for(i=0;i<a.builders.length;i++){a.builders[i]._fireSceneUpdated=this.setShouldRenderFrame.bind(this);a.builders[i]._fireLoadingFinished=function($){this.setRenderMode(this.getRenderMode());}.bind(this);}}}if(this._animationMixer){this._animationMixer.stopAllAction();this._animationMixer=null;}this.setScene(s);if(s){var w=s.getInitialView();if(w){this._currentView=w;this._resetNodesMaterialAndOpacityByCurrentView();var x=this._currentView.getPlaybacks();if(x){for(var y=0;y<x.length;y++){var X=x[y];var Y=s.getAnimationSequence(X.getSequenceId());if(Y){this.AddHandlersToAnimationSequenceEvents(Y);}}}}}if(b){this.setCamera(b);}if(a){if(a.backgroundTopColor!==undefined){this.setBackgroundColorTop(new THREE.Color(a.backgroundTopColor).getStyle());}if(a.backgroundBottomColor!==undefined){this.setBackgroundColorBottom(new THREE.Color(a.backgroundBottomColor).getStyle());}if(a.renderMode!==undefined){this.setRenderMode(a.renderMode);}}};G.prototype._onAfterUpdateContentConnector=function(){this._setContent(this._contentConnector.getContent());};G.prototype._onBeforeClearContentConnector=function(){if(H._onBeforeClearContentConnector){H._onBeforeClearContentConnector.call(this);}this.setScene(null);};G.prototype._handleContentReplaced=function(e){var a=e.getParameter("newContent");this._setContent(a);};G.prototype._onAfterUpdateViewStateManager=function(){};G.prototype._onBeforeClearViewStateManager=function(){};C.injectMethodsIntoClass(G);d.injectMethodsIntoClass(G);G.prototype._restoreOriginalValueAfterAnimation=function(){var p;if(this._currentView){p=this._currentView.getPlaybacks();}if(!p||!p.length){return;}for(var a=0;a<p.length;a++){var b=this._scene.getAnimationSequence(p[a].getSequenceId());var e;if(b){e=b.getNativeAnimationClip();}if(e){if(e&&e.tracks){for(var t=0;t<e.tracks.length;t++){var h=e.tracks[t];var i=h.userData;if(!i){continue;}var j=i.originalValue;if(!j){continue;}var m=i.targetNode;if(!m){continue;}if(i.type==="SCALE"){m.scale.copy(j);}else if(i.type==="TRANSLATE"){m.position.copy(j);}else if(i.type==="ROTATE"){m.quaternion.copy(j);}}}}}};G.prototype._resetNodePositionsForAnimation=function(){var a;if(this._currentView&&this._currentView.userData&&this._currentView.userData.nodeStartDataByAnimation){a=this._currentView.userData.nodeStartDataByAnimation.entries();}if(a){var b=a.next();while(!b.done){var e=b.value[0];var h=b.value[1];b=a.next();if(!h){continue;}if(h.scale){e.scale.copy(h.scale);}if(h.position){e.position.copy(h.position);}if(h.quaternion){e.quaternion.copy(h.quaternion);}if(h.opacity!==undefined){e.userData.opacity=h.opacity;e._vkUpdateMaterialOpacity();}if(h.color){e.material.color=h.color.clone();e.material.needsUpdate=true;}}}return;};G.prototype._runAnimation=function(a){var p;if(this._currentView){p=this._currentView.getPlaybacks();}if(!p||!p.length){return false;}this.fireAnimationStarted();this._animationTimeController.setInfinite(false);var b=0;this._currentAnimationActions=[];var t=[];var e,h,i;for(i=0;i<p.length;i++){e=p[i];h=this._scene.getAnimationSequence(e.getSequenceId());if(h){if(!h.userData){h.userData={};}h.userData.playbackCount=0;}}for(i=0;i<p.length;i++){e=p[i];h=this._scene.getAnimationSequence(e.getSequenceId());var j;if(h){if(h.userData.playbackCount===0){j=h.getNativeAnimationClip();h.userData.playbackCount=1;}else{var m=e.getSequenceId()+h.userData.playbackCount.toString();var q=this._scene.getAnimationSequence(m);if(!q){q=this._scene.createAnimationSequence(m);q.clone(h,true);}j=q.getNativeAnimationClip();h.userData.playbackCount++;}this.AddHandlersToAnimationSequenceEvents(h);}if(j){var s=this._animationMixer.clipAction(j);var w=e.getRepeat();if(!w){w=1;}if(e.getInfinite()){if(this._playingProcedure){w=Math.round(10/h.getDuration());if(w<10){w=10;}s.setLoop(THREE.LoopRepeat,w);}else{s.setLoop(THREE.LoopRepeat,Infinity);this._animationTimeController.setInfinite(true);}}else if(w>0){if(!e.getReversed()){s.setLoop(THREE.LoopRepeat,w);}else if(w>1){s.setLoop(THREE.LoopRepeat,w-1);}else{s.setLoop(THREE.LoopOnce,1);}}else{s.setLoop(THREE.LoopOnce,1);}var x=e.getTimeScale();if(x<=0){x=1;}if(e.getReversed()){s.timeScale=-1;s.time=j.duration/x;}s.clampWhenFinished=true;s.timeScale*=x;this._currentAnimationActions.push(s);t.push(e.getStartTime()+e.getPreDelay());var y=e.getStartTime()+e.getPreDelay()+w*h.getDuration()/x+e.getPostDelay();if(y>b){b=y;}}}if(b==0){this._animationMixer=null;this.fireViewFinished({viewIndex:this._currentViewIndex});this._playNextStep();return false;}this._animationTimeController.startAnimation(b,a);for(var X=0;X<this._currentAnimationActions.length;X++){this._currentAnimationActions[X].play().startAt(t[X]);}this.setShouldRenderFrame();return true;};G.prototype.startAnimation=function(){this.resumeAnimation();this._startAnimation();};G.prototype._startAnimation=function(a){if(this._animationMixer){this._animationMixer.stopAllAction();this._animationMixer=null;}var p;if(this._currentView){p=this._currentView.getPlaybacks();}if(!p||!p.length){this._playingPlaybacks=false;return false;}var b=this._scene?this._scene.getSceneRef():undefined;if(!b){return false;}this._resetNodesStatusByCurrenView();this._resetNodePositionsForAnimation();this._animationMixer=new THREE.AnimationMixer(b);if(!this._animationMixer.userData){this._animationMixer.userData={};}this._animationMixer.userData.completed=false;this._animationMixer.userData.viewport=this;this._animationMixer.addEventListener("complete",function(e){if(this.userData.viewport){this.userData.completed=true;if(this.userData.viewport._currentView){this.userData.viewport._currentView.animationCompleted=true;}var h=function(i){i.fireViewFinished({viewIndex:this._currentViewIndex});i._playNextStep();};setTimeout(h,10,this.userData.viewport);Q.sap.log.debug("Animation completed");}},false);this._animationMixer.addEventListener("restart",function(e){if(this.userData.viewport){this.userData.completed=true;if(this.userData.viewport._currentView){this.userData.viewport._currentView.animationCompleted=true;}var h=function(i){var p;if(i._currentView){p=i._currentView.getPlaybacks();}if(p&&p.length){i._startAnimation();}};setTimeout(h,10,this.userData.viewport);Q.sap.log.debug("Animation restart");}},false);return this._runAnimation(a);};G.prototype.stopAnimation=function(){if(this._animationMixer){this._animationMixer.stopAllAction();this._animationMixer=null;}this._resetNodesStatusByCurrenView();this._resetNodePositionsForAnimation();this._animationTimeController.stopAnimation();this.fireAnimationUpdated({value:0});this._playingProcedure=false;this.setShouldRenderFrame();};G.prototype.getCurrentView=function(){return this._currentView;};G.prototype._activateSingleView=function(a){if(this._animationMixer){this._animationMixer.stopAllAction();this._animationMixer=null;}if(this._scene._scene.userData.viewportGroups){var b=this._scene._scene.userData.viewportGroups;var t=this;b.forEach(function(d1){d1.modelViews.forEach(function(e1){if(e1===a){t._currentViewIndex=d1.modelViews.indexOf(e1);}});});}this.fireViewActivated({viewIndex:this._currentViewIndex,view:a});this._animationTimeController.reset();this.fireAnimationUpdated({value:0});this._currentView=a;if(a.topColor!==undefined){this.setBackgroundColorTop(new THREE.Color(a.topColor).getStyle());}if(a.bottomColor!==undefined){this.setBackgroundColorBottom(new THREE.Color(a.bottomColor).getStyle());}if(a.renderMode!==undefined){this.setRenderMode(a.renderMode);}var e=a.camera;if(!e&&a.getCameraInfo()){var h=a.getCameraInfo();if(h.type==="PerspectiveCamera"){e=new P();e.setFov(h.fov);}if(h.type==="OrthographicCamera"){e=new O();e.setZoomFactor(h.zoomFactor);if(h.zoomNeedRecalculate){e.setZoomNeedRecalculate(true);}}e.setPosition(h.position);e.setNearClipPlane(h.nearClipPlane);e.setFarClipPlane(h.farClipPlane);e.setUpDirection(h.upDirection);e.setTargetDirection(h.targetDirection);e.setUsingDefaultClipPlanes(h.usingDefaultClipPlanes);a.camera=e;}var i=this._scene?this._scene.getSceneRef():undefined;if(e){var j=e.getCameraRef();if(j.type==="OrthographicCamera"&&i){var p=e.getPosition();var s=this.getScene();if(s){var m=new THREE.Box3().setFromObject(i);var q=m.getCenter();var w=e.getTargetDirection();var x=[q.x-p[0],q.y-p[1],q.z-p[2]];var y=x[0]*w[0]+x[1]*w[1]+x[2]*w[2];if(y<0){var X=m.getSize().length()/2;X-=y;p[0]-=w[0]*X;p[1]-=w[1]*X;p[2]-=w[2]*X;}}e.setPosition(p);}}this._resetNodesMaterialAndOpacityByCurrentView();this._animationHelper.setInitialNodePositionsOnView(this._currentView,this._scene);this._resetNodesStatusByCurrenView(true,true,true);this._resetNodePositionsForAnimation();var Y=this._currentView.getPlaybacks();if(Y){for(var $=0;$<Y.length;$++){var a1=Y[$];var b1=this._scene.getAnimationSequence(a1.getSequenceId());if(b1){this.AddHandlersToAnimationSequenceEvents(b1);b1.setInitialStatusToTargetNodesValues();}}}if(e){var c1=2000;if(a.flyToTime!=null){c1=a.flyToTime;}this._playingPlaybacks=true;this._viewportGestureHandler.activateCamera(e.getCameraRef(),c1,this._playingProcedure);}else{this.fireViewFinished();}};G.prototype._updateMaterialInNode=function(a){var b=a.target;if(!b){return;}var i,e;for(i=0;i<b.children.length;i++){e=b.children[i];if(e.material&&(e.userData.animatedOpacity||e.userData.animatedColor)){e._vkUpdateMaterialColor();e._vkUpdateMaterialOpacity();if(e.userData.animatedOpacity){e.material.transparent=true;}}}var h;if(b.userData.materialId!==undefined){h=a.materialId!==b.userData.materialId;}else{h=a.materialId!==undefined;}var j;if(b.userData.opacity!==undefined){j=a.opacity!==b.userData.opacity;}else{j=a.opacity!==undefined||b.userData.animatedOpacity;}b.userData.materialId=a.materialId;b.userData.opacity=a.opacity;if(h||j){var m=this._scene.getMaterial(b.userData.materialId);for(i=0;i<b.children.length;i++){e=b.children[i];if(e.material){if(h){var p=m?m:this._scene.getMaterial(e.userData.initialMaterialId);if(p){var q=p.getMaterialRef();e.userData.materialId=q.userData.materialId;e.userData.originalMaterial=q;e.material=q.clone();if(this._scene._sceneBuilder){this._scene._sceneBuilder._attachMaterialClone(e.userData.materialId,e.material);}if(e.userData.animatedOpacity){e.material.transparent=true;}}}e._vkUpdateMaterialOpacity();}}}};G.prototype._resetNodesMaterialAndOpacityByCurrentView=function(){if(!this._currentView){return;}var a;if(this._currentView.getNodeInfos){a=this._currentView.getNodeInfos();}if(a){a.forEach(this._updateMaterialInNode.bind(this));}};G.prototype._resetNodesStatusByCurrenView=function(i,s,a){if(!this._currentView){return;}function b(x){return new THREE.Matrix4().set(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],x[8],x[9],x[10],x[11],0,0,0,1);}if(this._viewStateManager){var e=this._viewStateManager.getNodeHierarchy();if(e){var p;if(this._currentView){p=this._currentView.getPlaybacks();}var h;if(i&&this._currentView.userData&&this._currentView.userData.nodeStartDataByAnimation){h=this._currentView.userData.nodeStartDataByAnimation;}var j;if(this._currentView.getNodeInfos){j=this._currentView.getNodeInfos();}if(j){j.forEach(function(x){if(x.target===null){return;}function y(a1,b1,c1){for(var ei=0;ei<a1.elements.length;ei++){if(Math.abs(a1.elements[ei]-b1.elements[ei])>c1){return false;}}return true;}if(x.transform){var X=b(x.transform);if(!y(X,x.target.matrix,1e-6)){if(!p&&a){var Y=e.createNodeProxy(x.target);this._nodesTransitionHelper.setNodeForDisplay(Y);}X.decompose(x.target.position,x.target.quaternion,x.target.scale);x.target.updateMatrix();var $;if(h){$=h.get(x.target);}if($){if($.scale){x.target.scale.copy($.scale);}if($.position){x.target.position.copy($.position);}if($.quaternion){x.target.quaternion.copy($.quaternion);}if($.opacity!==undefined){x.userData.opacity=$.opacity;x._vkUpdateMaterialOpacity();}if($.color){x.material.color=$.color.clone();x.material.needsUpdate=true;}x.target.updateMatrix();}}}}.bind(this));}if(s){this._viewStateManager.setVisibilityState(e.getChildren()[0].children,false,false);if(j){var m=[];var q=[];for(var t=0;t<j.length;t++){if(j[t].visible){m.push(j[t].target);}else{q.push(j[t].target);}}this._viewStateManager.setVisibilityState(m,true,false);this._viewStateManager.setVisibilityState(q,false,false);this._nodesTransitionHelper.startDisplay(500);}else if(this._currentView.visibleNodes){var w=this._scene?this._scene.getSceneRef():undefined;if(w){this._viewStateManager.setVisibilityState(w.children[0],false,true);this._viewStateManager.setVisibilityState(w.children[0],true,false);this._viewStateManager.setVisibilityState(this._currentView.visibleNodes,true,false);}}}}}};G.prototype.resetCurrentView=function(i){if(!this._currentView){return this;}if(this._animationMixer){this._animationMixer.stopAllAction();this._animationMixer=null;}this.fireAnimationUpdated({value:0});this._resetNodesMaterialAndOpacityByCurrentView();if(i){this._animationHelper.setInitialNodePositionsOnView(this._currentView,this._scene);}this._resetNodesStatusByCurrenView(i,false,false);if(i){this._resetNodePositionsForAnimation();}this.setShouldRenderFrame();return this;};G.prototype.activateView=function(a,b){this._playingProcedure=false;if(this._notPlayingAnimations==undefined){this._notPlayingAnimations=false;}else{this._notPlayingAnimations=b;}this._activateSingleView(a);return this;};G.prototype.updateNodeInfoInCurrentView=function(a,b){if(!this._currentView){return;}var e;if(this._currentView.getNodeInfos){e=this._currentView.getNodeInfos();}if(e){var h;for(var i=0;i<e.length;i++){var j=e[i];if(j.target===null||j.target!==a){continue;}h=j;break;}if(!h){h={};e.push(h);}var t=new THREE.Matrix4();t.compose(a.position,a.quaternion,a.scale);var m=t.toArray();h.transform=[m[0],m[4],m[8],m[12],m[1],m[5],m[9],m[13],m[2],m[6],m[10],m[14]];if(b!==undefined){h.opacity=b;}}};G.prototype._playNextStep=function(){if(!this._playingProcedure){return;}this._currentViewIndex++;if(this._currentViews.length<=this._currentViewIndex){this._playingProcedure=false;this.fireProcedureFinished();}else{var a=this._currentViews[this._currentViewIndex];this._activateSingleView(a);}};G.prototype.playProcedure=function(a,b,e){if(a){this._currentViews=a;}if(b==null){b=0;}if(!this._currentViews||this._currentViews.length<=b){return this;}this._currentViewIndex=b;if(this._notPlayingAnimations==undefined){this._notPlayingAnimations=false;}else{this._notPlayingAnimations=e;}if(this._playingProcedure&&this._animationMixer){this.resumeAnimation();}else{this._playingProcedure=true;var h=this._currentViews[b];this._activateSingleView(h);}return this;};G.prototype.zoomTo=function(w,a,b,m){var e=this._scene?this._scene.getSceneRef():null;var h=this._camera?this._camera.getCameraRef():null;if(!h||!e){return this;}m=m||0;var i=new THREE.Box3();var q=null;var j=null;(Array.isArray(w)?w:[w]).forEach(function(w){switch(w){case Z.All:e._expandBoundingBox(i,false,true);break;case Z.Visible:e._expandBoundingBox(i,true,true);break;case Z.Selected:var p=this._getViewStateManagerThreeJS();if(p){p.enumerateSelection(function(a){a._expandBoundingBox(i,false,true);});}break;case Z.Node:if(!a){return this;}j=a;if(Array.isArray(a)){a.forEach(function(a){a._expandBoundingBox(i,false,true);});}else{a._expandBoundingBox(i,false,true);}break;case Z.Restore:Q.sap.log.error(u().getText("VIEWPORT_MSG_RESTORENOTIMPLEMENTED"));return this;case Z.NodeSetIsolation:Q.sap.log.error(u().getText("VIEWPORT_MSG_NODESETISOLATIONNOTIMPLEMENTED"));return this;case Z.RestoreRemoveIsolation:Q.sap.log.error(u().getText("VIEWPORT_MSG_RESTOREREMOVEISOLATIONNOTIMPLEMENTED"));return this;case Z.ViewLeft:q=new THREE.Quaternion().setFromAxisAngle(new THREE.Vector3(0,1,0),-Math.PI/2);break;case Z.ViewRight:q=new THREE.Quaternion().setFromAxisAngle(new THREE.Vector3(0,1,0),Math.PI/2);break;case Z.ViewTop:q=new THREE.Quaternion().setFromAxisAngle(new THREE.Vector3(1,0,0),-Math.PI/2);break;case Z.ViewBottom:q=new THREE.Quaternion().setFromAxisAngle(new THREE.Vector3(1,0,0),Math.PI/2);break;case Z.ViewBack:q=new THREE.Quaternion().setFromAxisAngle(new THREE.Vector3(0,1,0),Math.PI);break;case Z.ViewFront:q=new THREE.Quaternion().setFromAxisAngle(new THREE.Vector3(0,1,0),0);break;default:break;}}.bind(this));if(!i.isEmpty()){this._viewportGestureHandler.zoomTo(i,q,m,b*1000,j,j!==null);}return this;};G.prototype.pan=function(a,b){this._viewportGestureHandler._cameraController.pan(a,b);};G.prototype.rotate=function(a,b){this._viewportGestureHandler._cameraController.rotate(a,b);};G.prototype.zoom=function(a){this._viewportGestureHandler._cameraController.zoom(a);};G.prototype.getViewInfo=function(q){var a={};if(q==null){q={};}if(q.camera==null){q.camera=true;}var b=this._camera?this._camera.getCameraRef():null;if(q.camera&&b){var e=b.rotation.clone();e.reorder("YXZ");a.camera={rotation:{yaw:THREE.Math.radToDeg(e.y),pitch:THREE.Math.radToDeg(e.x),roll:THREE.Math.radToDeg(e.z)},position:{x:b.position.x,y:b.position.y,z:b.position.z},projectionType:b.isOrthographicCamera?l.Orthographic:l.Perspective,bindingType:n.Vertical};var h=b.view;if(h&&h.enabled){a.camera.view={fullWidth:h.fullWidth,fullHeight:h.fullHeight,offsetX:h.offsetX,offsetY:h.offsetY,width:h.width,height:h.height};}if(a.camera.projectionType===l.Perspective){a.camera.fieldOfView=b.fov;}else if(a.camera.projectionType===l.Orthographic){a.camera.zoomFactor=b.zoom;}if(q.camera.matrices){a.camera.matrices={view:b.matrixWorldInverse.elements.slice(),projection:b.projectionMatrix.elements.slice()};}}if(q.visibility&&this._viewStateManager){var i=q.visibility.mode==null?o.Complete:q.visibility.mode;a.visibility={mode:i};if(i===o.Complete){var j=this._viewStateManager.getVisibilityComplete();a.visibility.visible=j.visible;a.visibility.hidden=j.hidden;}else if(this._viewStateManager.getShouldTrackVisibilityChanges()){a.visibility.changes=this._viewStateManager.getVisibilityChanges();}else{Q.sap.log.warning(u().getText(M.VIT32.summary),M.VIT32.code,"sap.ui.vk.threejs.Viewport");}}return a;};G.prototype.setViewInfo=function(a,b){var e=this._camera?this._camera.getCameraRef():null;if(a.camera&&e){var h=a.camera;var i=h.projectionType===l.Orthographic?new THREE.OrthographicCamera():new THREE.PerspectiveCamera();i.userData=e.userData;i.aspect=e.aspect;i.position.copy(h.position);var j=h.rotation;i.quaternion.setFromEuler(new THREE.Euler(THREE.Math.degToRad(j.pitch),THREE.Math.degToRad(j.yaw),THREE.Math.degToRad(j.roll),"YXZ"));i.fov=h.fieldOfView||i.fov;i.zoom=h.zoomFactor||i.zoom;if(e.view&&e.view.enabled){var m=h.view||e.view;i.setViewOffset(m.fullWidth,m.fullHeight,m.offsetX,m.offsetY,m.width,m.height);i.aspect=m.fullWidth/m.fullHeight;i.zoom=Math.min(i.aspect,1);}this._viewportGestureHandler.activateCamera(i,(b||0)*1000);}if(a.visibility){var p=this._viewStateManager.getNodeHierarchy(),q=new Map(),s=p.findNodesByName();s.forEach(function(x){var y=p.createNodeProxy(x);var X=y.getVeId();p.destroyNodeProxy(y);if(X){q.set(X,x);}});switch(a.visibility.mode){case o.Complete:var t=a.visibility.visible,w=a.visibility.hidden;t.forEach(function(x){this._viewStateManager.setVisibilityState(q.get(x),true,false);},this);w.forEach(function(x){this._viewStateManager.setVisibilityState(q.get(x),false,false);},this);break;case o.Differences:this._viewStateManager.resetVisibility();a.visibility.changes.forEach(function(x){var y=q.get(x);if(y){this._viewStateManager.setVisibilityState(y,!this._viewStateManager.getVisibilityState(y),false);}},this);break;default:Q.sap.log.error(u().getText(M.VIT28.summary),M.VIT28.code,"sap.ui.vk.threejs.Viewport");break;}}this.setShouldRenderFrame();return this;};G.prototype.queueCommand=function(a){if(this instanceof G){a();}return this;};G.prototype.getOutputSize=function(){var b=this.getDomRef().getBoundingClientRect();var a=b.width;var e=b.height;var h;h=Math.min(a,e);return{left:(a-h)/2,top:(e-h)/2,sideLength:h};};return G;});
