/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["sap/ui/base/EventProvider"],function(E){"use strict";var C=E.extend("sap.ui.vk.tools.CrossSectionToolHandler",{metadata:{},constructor:function(t){this._tool=t;this._gizmo=t.getGizmo();this._rect=null;this._mouse=new THREE.Vector2();this._rayCaster=new THREE.Raycaster();this._rayCaster.linePrecision=0;this._gizmoAxis=new THREE.Vector3();this._dragOrigin=new THREE.Vector2();this._dragOffset=0;this._dragDelta=0;}});C.prototype._updateRayCaster=function(e){var s=this.getViewport().getRenderer().getSize();this._mouse.x=((e.x-this._rect.x)/s.width)*2-1;this._mouse.y=((e.y-this._rect.y)/s.height)*-2+1;this._rayCaster.setFromCamera(this._mouse,this.getViewport().getCamera().getCameraRef());};C.prototype._updateArrowHandle=function(e){var t=this._gizmo.getTouchObject();var a=-1;if(e.n===1){this._updateRayCaster(e);var i=this._rayCaster.intersectObject(t,true);a=i.length>0?this._gizmo.getAxis():-1;}if(a!==this._axisIndex){this._axisIndex=a;this._gizmo.highlightArrowHandle(a>=0);if(a>=0){this._gizmoAxis.setScalar(0).setComponent(this._axisIndex,1);}this.getViewport().setShouldRenderFrame();}};C.prototype.hover=function(e){if(this._inside(e)&&!this._gesture){this._updateArrowHandle(e);e.handled|=this._axisIndex>=0;}};C.prototype.click=function(e){if(this._inside(e)&&!this._gesture){this._updateArrowHandle(e);this._gizmo.selectHandle(this._axisIndex);e.handled|=this._axisIndex>=0;}};C.prototype.beginGesture=function(e){if(this._inside(e)&&!this._gesture){this._updateArrowHandle(e);this._gizmo.selectHandle(this._axisIndex);if(this._axisIndex>=0){this._gesture=true;e.handled=true;this._dragOrigin.set(e.x,e.y);this._dragOffset=this._gizmo._getOffset();this._dragDelta=this._gizmo._getDelta()/500;}}};C.prototype.move=function(e){if(this._gesture){e.handled=true;this._updateRayCaster(e);var d=this._gizmoAxis.clone().applyQuaternion(this.getViewport().getCamera().getCameraRef().quaternion.clone().inverse());d.z=0;d.normalize();if(d.x===0&&d.y===0){d.y=1;}this._gizmo._setOffset(this._dragOffset+((e.x-this._dragOrigin.x)*d.x-(e.y-this._dragOrigin.y)*d.y)*this._dragDelta);}};C.prototype.endGesture=function(e){if(this._gesture){this._gesture=false;e.handled=true;this._updateArrowHandle(e);}};C.prototype.getViewport=function(){return this._tool._viewport;};C.prototype._getOffset=function(o){var r=o.getBoundingClientRect();var p={x:r.left+window.pageXOffset,y:r.top+window.pageYOffset};return p;};C.prototype._inside=function(e){if(this._rect===null||true){var i=this._tool._viewport.getIdForLabel();var d=document.getElementById(i);if(d===null){return false;}var o=this._getOffset(d);this._rect={x:o.x,y:o.y,w:d.offsetWidth,h:d.offsetHeight};}return(e.x>=this._rect.x&&e.x<=this._rect.x+this._rect.w&&e.y>=this._rect.y&&e.y<=this._rect.y+this._rect.h);};return C;});
