/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["./Tool","./RectSelectToolHandler","../Loco"],function(T,R,L){"use strict";var a=T.extend("sap.ui.vk.tools.RectSelectTool",{metadata:{properties:{subtractMode:{type:"boolean",defaultValue:false}}},constructor:function(i,s){if(a._instance){return a._instance;}T.apply(this,arguments);this._viewport=null;this._handler=new R(this);this._loco=null;a._instance=this;}});a.prototype.init=function(){if(T.prototype.init){T.prototype.init.call(this);}this.setFootprint(["sap.ui.vk.dvl.Viewport","sap.ui.vk.threejs.Viewport"]);};a.prototype.setActive=function(v,b,g){if(T.prototype.setActive){T.prototype.setActive.call(this,v,b,g);}if(v){this._activateTool(b);}else{this._deactivateTool();}if(b){b.setShouldRenderFrame();}return this;};a.prototype._activateTool=function(b){this._viewport=this.getViewportImplementation(b);if(this._prepare()){this._handler.activate(this._viewport);}};a.prototype._deactivateTool=function(){this._handler.deactivate();};a.prototype._prepare=function(){if(this.isViewportType("sap.ui.vk.dvl.Viewport")&&this._viewport._dvl){return true;}else if(this.isViewportType("sap.ui.vk.threejs.Viewport")&&this._viewport._scene&&this._viewport._scene.getSceneRef()){return true;}else{return false;}};a.prototype.queueCommand=function(b){if(this._prepare()){if(this.isViewportType("sap.ui.vk.threejs.Viewport")){b();}}return this;};function c(b,d,v){var m=b.elements;var i=m[15]===1;var r=2/m[0];var t=2/m[5];var e,f;if(i){e=-m[12]*r;f=-m[13]*t;}else{e=m[8]*r;f=m[9]*t;}var g=(r+e)*0.5;var l=e-g;var h=(t+f)*0.5;var j=f-h;var k=THREE.Math.lerp(l,g,Math.min(d.x1,d.x2)/v.width);var n=THREE.Math.lerp(l,g,Math.max(d.x1,d.x2)/v.width);var o=THREE.Math.lerp(h,j,Math.min(d.y1,d.y2)/v.height);var p=THREE.Math.lerp(h,j,Math.max(d.y1,d.y2)/v.height);m[0]=2/(n-k);m[5]=2/(o-p);if(i){m[12]=-(n+k)/(n-k);m[13]=-(o+p)/(o-p);}else{m[8]=(n+k)/(n-k);m[9]=(o+p)/(o-p);}}a.prototype.select=function(x,y,b,d,s,e){if(!this._prepare()){return[];}return this._select(x,y,b,d,this._viewport,s,e);};a.prototype._select=function(x,y,b,d,v,s,e){var n=[];if(v.getMetadata().getName()==="sap.ui.vk.dvl.Viewport"){n=v.rectSelect(x,y,b,d);if(n.length>0){var p={picked:n};v.fireNodesPicked(p);if(this.getSubtractMode()){v._viewStateManager.setSelectionStates([],n);}else{v._viewStateManager.setSelectionStates(n,[]);}}return n;}var f=s?s.getSceneRef():undefined;var g=e?e.getCameraRef():undefined;var h=v._getViewStateManagerThreeJS();if(!g||!f||!h||x===b||y===d){return n;}var r={x1:x,y1:y,x2:b,y2:d};var m=g.projectionMatrix.clone();c(m,r,v._renderer.getSize());var j=new THREE.Matrix4().multiplyMatrices(m,g.matrixWorldInverse);var k=new THREE.Frustum().setFromMatrix(j);var o=new THREE.Vector3();function q(w){var z=w.geometry;if(z!==undefined&&k.intersectsObject(w)){var i,l=0;if(z.isGeometry){var A=z.vertices;for(i=0,l=A.length;i<l;i++){o.copy(A[i]).applyMatrix4(w.matrixWorld);if(!k.containsPoint(o)){break;}}}else if(z.isBufferGeometry){var B=z.attributes.position;if(B!==undefined){for(i=0,l=B.count;i<l;i++){o.fromBufferAttribute(B,i).applyMatrix4(w.matrixWorld);if(!k.containsPoint(o)){break;}}}}return l>0&&i===l;}return false;}function t(l){if(l.visible===false){return;}var w=0,z=0;if(l.geometry!==undefined){w++;if(q(l)){z++;}}var A=l.children;if(A.length>0){for(var i=0;i<A.length;i++){var B=A[i];if(B.geometry!==undefined&&!B.name&&B.children.length===0){if(B.visible===true){w++;if(q(B)){z++;}}}else{t(B);}}}if(z>0&&w===z){n.push(l);}}t(f);if(n.length>0){var u={picked:n};v.fireNodesPicked(u);if(this.getSubtractMode()){h.setSelectionStates([],n);}else{h.setSelectionStates(n,[]);}}return n;};return a;});
