sap.ui.define(["./TotaraUtils","./Command"],function(T,C){"use strict";function R(b){this.batchSize=b;this.globalList=new Set();this.requestedList=[];this.waitingList=new Set();}R.prototype.push=function(i,r){i=i.toString();if(!this.globalList.has(i)){this.globalList.add(i);this.requestedList.push(r||i);this.waitingList.add(i);}};R.prototype.fetchBatch=function(){return this.requestedList.splice(0,this.batchSize);};R.prototype.pop=function(i){i=i.toString();return this.waitingList.delete(i);};R.prototype.isReady=function(i){i=i.toString();return this.globalList.has(i)&&!this.waitingList.has(i);};R.prototype.clear=function(){this.globalList.clear();this.requestedList=[];this.waitingList.clear();};R.prototype.isEmpty=function(){return this.requestedList.length===0;};R.prototype.isWaiting=function(){return this.waitingList.size>0;};function P(b){R.call(this,b);this.priorityMap=new Map();}P.prototype=Object.create(R.prototype);P.prototype.constructor=P;P.prototype.push=function(i,p){if(!this.globalList.has(i)){this.globalList.add(i);this.requestedList.push(i);this.waitingList.add(i);this.priorityMap.set(i,p);}};P.prototype.clear=function(){R.prototype.clear.call(this);this.priorityMap.clear();};P.prototype.fetchBatch=function(){var p=this.priorityMap;this.requestedList.sort(function(a,b){return p.get(b)-p.get(a);});var d=R.prototype.fetchBatch.call(this);d.forEach(p.delete,p);return d;};var c=function(a,s){this.context=a;this.sceneId=s;this.token=a.token||T.generateToken();this.meshes=new R(128);this.materials=new R(128);this.images=new R(1);this.geometries=new P(32);this.geomMeshes=new P(32);this.annotations=new R(128);this.views=new R(1);this.tracks=new R(128);this.sequences=new R(128);this.highlights=new R(1);};c.prototype.isEmpty=function(){return this.meshes.isEmpty()&&this.annotations.isEmpty()&&this.materials.isEmpty()&&this.images.isEmpty()&&this.geometries.isEmpty()&&this.geomMeshes.isEmpty()&&this.views.isEmpty()&&this.tracks.isEmpty()&&this.sequences.isEmpty()&&this.highlights.isEmpty();};c.prototype.isWaitingForContent=function(){return this.meshes.isWaiting()||this.images.isWaiting()||this.materials.isWaiting()||this.geometries.isWaiting()||this.geomMeshes.isWaiting()||this.annotations.isWaiting()||this.views.isWaiting()||this.tracks.isWaiting()||this.sequences.isWaiting()||this.highlights.isWaiting();};c.prototype.clearContent=function(){this.meshes.clear();this.annotations.clear();this.materials.clear();this.images.clear();this.geometries.clear();this.geomMeshes.clear();this.views.clear();this.tracks.clear();this.sequences.clear();this.highlights.clear();};c.prototype.createGetContentCommand=function(a,i,e){var o={sceneId:this.sceneId,ids:i.map(function(b){return parseInt(b,10);}),token:this.token};return T.createRequestCommand(a,e?Object.assign(o,e):o);};c.prototype.generateRequestCommand=function(){var i;var a=null;if(!this.meshes.isEmpty()){i=this.meshes.fetchBatch();a=this.createGetContentCommand(C.getMesh,i);}else if(!this.annotations.isEmpty()){i=this.annotations.fetchBatch();a=this.createGetContentCommand(C.getAnnotation,i);}else if(!this.materials.isEmpty()){i=this.materials.fetchBatch();a=this.createGetContentCommand(C.getMaterial,i);}else if(!this.geometries.isEmpty()){i=this.geometries.fetchBatch();a=this.createGetContentCommand(C.getGeometry,i);a.sceneId=this.sceneId;a.geometryIds=i;}else if(!this.geomMeshes.isEmpty()){i=this.geomMeshes.fetchBatch();a=this.createGetContentCommand(C.getMesh,i,{$expand:"geometry"});a.sceneId=this.sceneId;a.meshIds=i;}else if(!this.images.isEmpty()){i=this.images.fetchBatch();a=this.createGetContentCommand(C.getImage,[i[0].imageId]);a.sceneId=this.sceneId;a=Object.assign(a,i[0]);}else if(!this.sequences.isEmpty()){i=this.sequences.fetchBatch();a=this.createGetContentCommand(C.getSequence,i);}else if(!this.tracks.isEmpty()){i=this.tracks.fetchBatch();a=this.createGetContentCommand(C.getTrack,i);}else if(!this.views.isEmpty()){i=this.views.fetchBatch();a=T.createRequestCommand(C.getView,{sceneId:this.sceneId,groupId:i[0].viewGroupId,id:i[0].viewId,includeHidden:this.context.includeHidden!==undefined?this.context.includeHidden:false,includeAnimation:this.context.includeAnimation!==undefined?this.context.includeAnimation:true,token:this.token});}else if(!this.highlights.isEmpty()){i=this.highlights.fetchBatch();a=T.createRequestCommand(C.getHighlightStyle,{sceneId:this.sceneId,id:i[0],token:this.token});}return a;};return c;});
