/*
 * ! SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(['jquery.sap.global',"sap/ui/core/Message","./ArrayUtilities"],function(q,S,a){"use strict";var T={};T.mapBranch=function(t,b){var c=b(t);if(t.includedChildren){c.includedChildren=t.includedChildren.map(function(d){return T.mapBranch(d,b);});}if(t.excludedChildren){c.excludedChildren=t.excludedChildren.map(function(d){return T.mapBranch(d,b);});}return c;};T.mapTree=function(r,b){var c=[];r.forEach(function(d){c.push(T.mapBranch(d,b));});return c;};var v=function(i){return Array.isArray(i)?sap.ui.vtm.ArrayUtilities.shallowClone(i):i;};var m=function(b){if(b===null||b===undefined){return b;}var c={};var k=Object.keys(b);k.forEach(function(d){c[d]=v(b[d]);});return c;};T.cloneMetadata=function(t){return m(t.metadata);};T.cloneIdentifiers=function(t){return m(t.identifiers);};T.cloneAppData=function(t){return m(t.appData);};T.hasVisibility=function(t){return t.visibility===true||t.visibility===false;};T.getAppDataDescriptors=function(t){if(!t.appData){return[];}return Object.keys(t.appData);};T.getAppDataValues=function(t,d){if(!t.appData){return[];}return a.wrap(t.appData[d]);};T.setAppDataValues=function(t,d,b){var c=a.unwrap(b);if(c===undefined){if(t.appData){delete t.appData[d];}}else{if(!t.appData){t.appData={};}t.appData[d]=b;}};T.getMetadataDescriptors=function(t){if(!t.metadata){return[];}return Object.keys(t.metadata);};T.getMetadataValues=function(t,d){if(!t.metadata){return[];}return a.wrap(t.metadata[d]);};T.setMetadataValues=function(t,d,b){var c=a.unwrap(b);if(c===undefined){if(t.metadata){delete t.metadata[d];}}else{if(!t.metadata){t.metadata={};}t.metadata[d]=b;}};T.getIdentifierDescriptors=function(t){if(!t||!t.identifiers){return[];}return Object.keys(t.identifiers);};T.getIdentifierValues=function(t,d){if(!t.identifiers){return[];}return a.wrap(t.identifiers[d]);};T.setIdentifierValues=function(t,d,b){var c=a.unwrap(b);if(c===undefined){if(t.identifiers){delete t.identifiers[d];}}else{if(!t.identifiers){t.identifiers={};}t.identifiers[d]=b;}};T.getSceneNodeIds=function(t){if(!t.sceneNodeIds){return[];}return a.wrap(t.sceneNodeIds);};T.setSceneNodeIds=function(t,s){s=a.unwrap(s);if(s===undefined){if(t.sceneNodeIds){delete t.sceneNodeIds;}}else{t.sceneNodeIds=s;}};T.getIncludedChildren=function(t){if(!t.includedChildren){return[];}return t.includedChildren;};T.getExcludedChildren=function(t){if(!t.excludedChildren){return[];}return t.excludedChildren;};T.getChildren=function(t,c){switch(c){case sap.ui.vtm.ChildCollectionType.None:return[];case null:case undefined:case sap.ui.vtm.ChildCollectionType.Included:return T.getIncludedChildren(t);case sap.ui.vtm.ChildCollectionType.Excluded:return T.getExcludedChildren(t);case sap.ui.vtm.ChildCollectionType.IncludedAndExcluded:return T.getIncludedChildren(t).concat(T.getExcludedChildren(t));default:throw"Unknown sap.ui.vtm.ChildCollectionType value: "+c;}};T.setIncludedChildren=function(t,i){i=sap.ui.vtm.ArrayUtilities.wrap(i);if(i.length==0){delete t.includedChildren;}else{t.includedChildren=i;}};T.setExcludedChildren=function(t,e){e=sap.ui.vtm.ArrayUtilities.wrap(e);if(e.length==0){delete t.excludedChildren;}else{t.excludedChildren=e;}};T.setChildren=function(t,c,b){switch(b){case sap.ui.vtm.ChildCollectionType.None:break;case null:case undefined:case sap.ui.vtm.ChildCollectionType.Included:T.setIncludedChildren(t,c);break;case sap.ui.vtm.ChildCollectionType.Excluded:T.setExcludedChildren(t,c);break;case sap.ui.vtm.ChildCollectionType.IncludedAndExcluded:throw"sap.ui.vtm.ChildCollectionType.IncludedAndExcluded cannot be used in sap.ui.vtm.TreeItemUtilities.setChildren";default:throw"Unknown sap.ui.vtm.ChildCollectionType value: "+b;}};T.hasIncludedChildren=function(t){return t.includedChildren&&t.includedChildren.length;};T.hasExcludedChildren=function(t){return t.excludedChildren&&t.excludedChildren.length;};T.hasChildren=function(t,c){switch(c){case sap.ui.vtm.ChildCollectionType.None:return false;case null:case undefined:case sap.ui.vtm.ChildCollectionType.Included:return T.hasIncludedChildren(t);case sap.ui.vtm.ChildCollectionType.Excluded:return T.hasExcludedChildren(t);case sap.ui.vtm.ChildCollectionType.IncludedAndExcluded:return T.hasIncludedChildren(t)||T.hasExcludedChildren(t);default:throw"Unknown sap.ui.vtm.ChildCollectionType value: "+c;}};T.calculateAbsoluteMatrix=function(r,p){if(!r){return p||sap.ui.vtm.MatrixUtilities.createIdentity();}return p?sap.ui.vtm.MatrixUtilities.multiply(r,p):r;};T.calculateRelativeMatrix=function(b,p){if(!b){throw"An absolute matrix value is needed to calculate a relative matrix value";}return p?sap.ui.vtm.MatrixUtilities.multiply(b,sap.ui.vtm.MatrixUtilities.invert(p)):b;};T.addIncludedChild=function(i,c){if(i.includedChildren){i.includedChildren.push(c);}else{i.includedChildren=[c];}};T.addExcludedChild=function(i,c){if(i.excludedChildren){i.excludedChildren.push(c);}else{i.excludedChildren=[c];}};T.addChild=function(i,c,b){switch(b){case sap.ui.vtm.ChildCollectionType.None:break;case null:case undefined:case sap.ui.vtm.ChildCollectionType.Included:T.addIncludedChild(i,c);break;case sap.ui.vtm.ChildCollectionType.Excluded:T.addExcludedChild(i,c);break;case sap.ui.vtm.ChildCollectionType.IncludedAndExcluded:throw"sap.ui.vtm.ChildCollectionType.IncludedAndExcluded cannot be used in sap.ui.vtm.TreeItemUtilities.addChild";default:throw"Unknown sap.ui.vtm.ChildCollectionType value: "+b;}};T.removeIncludedChild=function(i,c){var b=(typeof c==='string')?c:c.id;if(i.includedChildren){var d=sap.ui.vtm.ArrayUtilities.findIndex(i.includedChildren,function(f){return f.id===b;});if(d!==undefined){var e=i.includedChildren[d];i.includedChildren.splice(d,1);if(i.includedChildren.length==0){delete i.includedChildren;}return e;}}return undefined;};T.removeExcludedChild=function(i,c){var b=(typeof c==='string')?c:c.id;if(i.excludedChildren){var d=sap.ui.vtm.ArrayUtilities.findIndex(i.excludedChildren,function(f){return f.id===b;});if(d!==undefined){var e=i.excludedChildren[d];i.excludedChildren.splice(d,1);if(i.excludedChildren.length==0){delete i.excludedChildren;}return e;}}return undefined;};T.removeChild=function(i,c,b){switch(b){case sap.ui.vtm.ChildCollectionType.None:break;case null:case undefined:case sap.ui.vtm.ChildCollectionType.Included:return T.removeIncludedChild(i,c);case sap.ui.vtm.ChildCollectionType.Excluded:return T.removeExcludedChild(i,c);case sap.ui.vtm.ChildCollectionType.IncludedAndExcluded:return T.removeIncludedChild(i,c)||T.removeExcludedChild(i,c);default:throw"Unknown sap.ui.vtm.ChildCollectionType value: "+b;}};T.includeAllChildren=function(t,r){t=sap.ui.vtm.ArrayUtilities.wrap(t);t.forEach(function(i){var b=T.getChildren(i,sap.ui.vtm.ChildCollectionType.IncludedAndExcluded);T.setIncludedChildren(i,b);T.setExcludedChildren(i,[]);if(r){b.forEach(function(c){T.includeAllChildren(c,true);});}});};T.excludeAllChildren=function(t,r){t=sap.ui.vtm.ArrayUtilities.wrap(t);t.forEach(function(i){var b=T.getChildren(i,sap.ui.vtm.ChildCollectionType.IncludedAndExcluded);T.setChildren(i,[]);T.setExcludedChildren(i,b);if(r){b.forEach(function(c){T.excludeAllChildren(c,true);});}});};T.removeRoot=function(r,b){var c=(typeof b==='string')?b:b.id;var i=sap.ui.vtm.ArrayUtilities.findIndex(r,function(e){return e.id===c;});if(i!==undefined){var d=r[i];r.splice(i,1);return d;}return undefined;};T.addRoot=function(r,b){r.push(b);};T.validateTreeItem=function(t){var i=function(o){return o===null||o===undefined;};var e=[];if(t){if(i(t.id)){e.push("id is not specified");}if(!i(t.absoluteMatrix)){if(!sap.ui.vtm.MatrixUtilities.isValid(t.absoluteMatrix,true)){e.push("absoluteMatrix is not valid");}}if(!i(t.relativeMatrix)){if(!sap.ui.vtm.MatrixUtilities.isValid(t.relativeMatrix,true)){e.push("relativeMatrix is not valid");}}}return e;};T.validateTree=function(r){var e=[];var p=function(t,b){var c=T.validateTreeItem(t);if(c&&c.length!==0){var d=b+": "+c.join(", ");e.push(d);}var i;var f=t.includedChildren;if(f){for(i=0;i<f.length;i++){p(f[i],b+"/includedChildren/"+i);}}var g=t.excludedChildren;if(g){for(i=0;i<g.length;i++){p(g[i],b+"/excludedChildren/"+i);}}};for(var j=0;j<r.length;j++){p(r[j],""+j);}return e;};T.traverseBranch=function(t,c,b){if(!t){return;}var d=c(t,b)||sap.ui.vtm.ChildCollectionType.Included;if(b&&d!==sap.ui.vtm.ChildCollectionType.None){b.push(t);}if(d===sap.ui.vtm.ChildCollectionType.IncludedAndExcluded||d===sap.ui.vtm.ChildCollectionType.Included){var i=t.includedChildren;if(i){i.forEach(function(f){T.traverseBranch(f,c,b);});}}if(d===sap.ui.vtm.ChildCollectionType.IncludedAndExcluded||d===sap.ui.vtm.ChildCollectionType.Excluded){var e=t.excludedChildren;if(e){e.forEach(function(f){T.traverseBranch(f,c,b);});}}if(b&&d!==sap.ui.vtm.ChildCollectionType.None){b.pop();}};T.traverseTree=function(r,c){if(r){r.forEach(function(b){T.traverseBranch(b,c,[]);});}};T.getMessages=function(t){if(!t.messages||!t.messages.length){return[];}var p=JSON.parse(t.messages);var c=p.map(function(b){return new sap.ui.core.Message(b);});return c;};T.setMessages=function(t,b){if(!b||!b.length){delete t.messages;return;}var c=b.map(function(d){var e={};var l=d.getLevel();if(l){e.level=l;}var f=d.getText();if(f){e.text=f;}var i=d.getIcon();if(i){e.icon=i;}var g=d.getTimestamp();if(g){e.timestamp=g;}var r=d.getReadOnly();if(r){e.readOnly=r;}return e;});t.messages=JSON.stringify(c);};return T;},true);
