# $Id: //bc/lmt_023_REL/src/upg/R3ld/R3loadctl/DDLADA_GEN.TPL#15 $ SAP

# include the generic db independent TPL:
#include DDLGEN.TPL
#include DDLADA_CRR.TPL

# no order by!
seltab_sorted: &tpl:seltab&

cretab: &tpl:cretabgen& NO FIXED LENGTH COLUMN

crepky: ALTER TABLE &tab_name& ADD PRIMARY KEY ( /%{ &key_fld_name& /-, /} )

drppky:

creind: CREATE &unique& INDEX &ind_name&
        ON &tab_name&
        ( /%{ &fld_name& /-, /} )

drpind: &tpl:drpindgen& ON &tab_name&

trcdat: &tpl:deldat0&

#  is handled internally
unload:

# new versions of GTTs:
cretabtmp: CREATE GLOBAL TEMPORARY TABLE &tab_name&
           (/%{&fld_name& &fld_desc&, /}
           PRIMARY KEY(/%{&key_fld_name&/-, /}))
           ON COMMIT DELETE ROWS
drptabtmp: &tpl:drptab&

crepkytmp:
drppkytmp:
creindtmp: &tpl:creind&
drpindtmp: &tpl:drpind&

# old versions of GTTs:
cretabtmp_old: CREATE TABLE "$TMP_&tab_name0&" (
               "$ada_session_id" CHAR (6) BYTE not null default TRANSACTION, /%{ &fld_name& &fld_desc&/-, /}
               ) NO FIXED LENGTH COLUMN
               /;
               CREATE VIEW &tab_name& AS SELECT /%{ &fld_name& /-, /} FROM "$TMP_&tab_name0&" WHERE "$ada_session_id" = TRANSACTION
drptabtmp_old: DROP VIEW &tab_name&
               /;
               DROP TABLE "$TMP_&tab_name0&"

crepkytmp_old: ALTER TABLE "$TMP_&tab_name0&" ADD PRIMARY KEY ("$ada_session_id", /%{ &key_fld_name& /-, /} )
drppkytmp_old: ALTER TABLE "$TMP_&tab_name0&" DROP PRIMARY KEY

creindtmp_old: CREATE &unique& INDEX &ind_name& ON "$TMP_&tab_name0&" ("$ada_session_id", /%{ &fld_name& /-, /} )
drpindtmp_old: &tpl:drpindgen& ON "$TMP_&tab_name0&"

ind4pky:       WBCROSSGT~0 WBCROSSGT^0

# --------------------------------------------------------------------------------------------------------------
checklogwriter: SELECT COUNT(*) FROM "DB_STATE" WHERE "DESCRIPTION" = 'Log writing' AND "VALUE" = 'on'

# --------------------------------------------------------------------------------------------------------------
# Hook to disable this
UseRegLoader: 1

pre_instab:  /?(&useregloader& and &is_min_dbversion[7.9.10]& and &is_sorted_data& and &is_split_primarykey&){ CALL SYSDBA.REGISTER_LOADER_TASK( USER, '&tab_name0&' ) /}
post_instab: /?(&useregloader& and &is_min_dbversion[7.9.10]& and &is_sorted_data& and &is_split_primarykey&){ CALL SYSDBA.UNREGISTER_LOADER_TASK /}

# --------------------------------------------------------------------------------------------------------------
#  #########  #
#  CRR Stuff  #
#  #########  #

#  https://help.sap.com/viewer/58c8145174ef49c1b78fae156ce46f62/113/en-US/455838f1484365d1e10000000a1553f6.html
#  Documentation is not correct, works for insert from a subquery, too
#  Similar to crr_upserthist_part
#
crr_insselhist__ADA{mode,type}:   INSERT
                                    INTO &crrloghist_tab_name&
                                          (/%{&log_key_fld_name&, /}   "&tpl:crrfld_oplast&",   "&tpl:crrfld_sequence&",
                                              "&tpl:crrfld_replicating&")
                                  SELECT &select_hint&
                                         /%{L.&log_key_fld_name&, /} L."&tpl:crrfld_oplast&", L."&tpl:crrfld_sequence&",
                                              &tpl:crr_procnum_act{mode=&mode&}&
                                    FROM &crrlog_tab_name& L
                                    LEFT OUTER JOIN &crrloghist_tab_name& H
                                      ON /%{H.&log_key_fld_name& = L.&log_key_fld_name& /-AND /}
                                   WHERE L."&tpl:crrfld_sequence&" >= ?
                                     AND L."&tpl:crrfld_sequence&" <  ?
                                     #
                                     # The FAST/SAFE decision building block #
                                     AND &tpl:crr_decide_fastorsafe_oj{mode=&mode&,type=&type&}&
                                     #
                                     # Leave out the temporary M records during the Continuous Replay!
                                     /?("&type&" = "CONTI"){AND L."&tpl:crrfld_oplast&" != 'M'/}
                                     #
                                         &where_add[L]&
                                  #
                                  # The UPDATE branch
                                  UPDATE DUPLICATES
                                  /* ADA MERGE LOG->LOGHIST for &tab_name&: &mode&/&type& */

crr_upserthist_fastconti:         &tpl:crr_insselhist__ADA{mode=FAST,type=CONTI}&
crr_upserthist_fastfinal:         &tpl:crr_insselhist__ADA{mode=FAST,type=FINAL}&
crr_upserthist_safeconti:         &tpl:crr_insselhist__ADA{mode=SAFE,type=CONTI}&
crr_upserthist_safefinal:         &tpl:crr_insselhist__ADA{mode=SAFE,type=FINAL}&

crr_upsertsqltype_fastconti:      INSSEL
crr_upsertsqltype_fastfinal:      INSSEL
crr_upsertsqltype_safeconti:      INSSEL
crr_upsertsqltype_safefinal:      INSSEL


######################################


#  =======  #
#           #
#  Indexes  #
#           #
#  =======  #

#  NB: secondarx indexes always contain the primary key fields

crr_creindlog:      0(/%{&log_key_fld_name&/-, /})
                    U1(&tpl:crrfld_sequence&)
                    UIO(&tpl:crrfld_sequence&, &tpl:crrfld_oplast&)

crr_creindloghist:  0(/%{ &log_key_fld_name& /-, /})
                    U1(&tpl:crrfld_sequence&)
                    2(&tpl:crrfld_replicating&)
                    USR(&tpl:crrfld_sequence&, &tpl:crrfld_replicating&)
                    UIO(&tpl:crrfld_sequence&, &tpl:crrfld_replicating&, &tpl:crrfld_oplast&)

use_value_M:        1
