#  $Id: //bc/lmt_023_REL/src/upg/R3ld/R3loadctl/DDLCRR.TPL#13 $ SAP

#  ---------------------------------------------------------

#  ===========================================  #
#                                               #
#  Some DEFINEs to have them not in the C code  #
#                                               #
#  ===========================================  #

crr_offset_fast_act:       0
crr_offset_safe_act:     500

crr_offset_cnt_fast_ok: 1000
crr_offset_cnt_safe_ok: 2000

crr_offset_fin_fast_ok: 1000
crr_offset_fin_safe_ok: 3000

crr_offset_err:         7000



# ################################### #
#                                     #
# FAST SEARCH: procnumber 001 ... 499 #
# SAFE SEARCH: procnumber 501 ... 999 #
#                                     #
# ################################### #
crr_procnum_act{mode}:          /@(&mode&){/:(FAST)&proc_number_fast_act&/:(SAFE)&proc_number_safe_act&/}

crr_procnum_ok{mode,type}:      /@(&mode&){
                                /:(FAST)  /@(&type&){/:(CONTI)&proc_number_cnt_fast_ok&/:(FINAL)&proc_number_fin_fast_ok&/}
                                /:(SAFE)  /@(&type&){/:(CONTI)&proc_number_cnt_safe_ok&/:(FINAL)&proc_number_fin_safe_ok&/}
                                /}

############################################
#                                          #
# A range of ok codes                      #
# that can be overwritten                  #
# by the MERGE command                     #
#                                          #
# FAST  SELECT overwrites FAST+SAFE SELECT #
# SAFE  SELECT overwrites only SAFE SELECT #
#                                          #
# CONTI REPLAY overwrites CONT+FINL REPLAY #
# FINAL REPLAY overwrites only FINL REPLAY #
#                                          #
############################################

crr_rangelower_ok{mode,type}:
    /@(&type&){
    /:(CONTI)  /@(&mode&){/:(FAST)&tpl:crr_offset_cnt_fast_ok&/:(SAFE)&tpl:crr_offset_cnt_safe_ok&/}
    /:(FINAL)  /@(&mode&){/:(FAST)&tpl:crr_offset_fin_fast_ok&/:(SAFE)&tpl:crr_offset_fin_safe_ok&/}
    /}


#  The search window for the final replay
#  has a maximal size
#  for the FR the normal window is enlarged by a factor
crr_finalwindow_maxsize:    200000
crr_finalwindow_factor:       1000

#  compatibility with ABAP
crr_compatibilityflags:       6

#  ====================================  #
#                                        #
#  For trigger templates "DDL*_CRR.TPL"  #
#                                        #
#  ====================================  #

crr_trgcntrl_table:           UPGTRIGGER
crr_trgcntrl_defmode:         UKR_OFF
crr_trg_waitsec:              60
crr_trg_needstablock:         0
crr_create_online:            0
crr_has_commit_hook:          0
crr_need_opdelins:            0

crr_savcommit_table:          UPGCOMMITID
crr_transactstatus_table:     UPGTNXSTATUS

crrfld_scenario:              SCENARIO
crrfld_tabname:               TABNAME
crrfld_trigmode:              TRIGMODE
crrfld_timestamp:             TIMESTAMP

#  ===========================================  #
crr_trg_inscntrl: INSERT
                    INTO "&tpl:crr_trgcntrl_table&"
                         ("&tpl:crrfld_scenario&", "&tpl:crrfld_tabname&", "&tpl:crrfld_trigmode&",      "&tpl:crrfld_timestamp&")
                  VALUES ('RRC',                   '&tab_name0&',          '&tpl:crr_trgcntrl_defmode&', '&date_stamp&')

crr_trg_delcntrl: DELETE
                    FROM "&tpl:crr_trgcntrl_table&"
                   WHERE "&tpl:crrfld_scenario&" = 'RRC'
                     AND "&tpl:crrfld_tabname&"  = '&tab_name0&'

#  ===========================================  #

crrfld_opfirst:         CRR_OP_FIRST
crrfld_oplast:          CRR_OP_LAST
crrfld_opdelins:        CRR_OP_DELINS
crrfld_sequence:        CRR_SEQUENCE
crrfld_replicating:     CRR_REPLICATING
crrfld_isdeleted:       CRR_ISDELETED

crrfld_tnxid:           TNX_ID
crrfld_commitid:        COMMIT_ID
crrfld_op:              CRR_OP

#  definitions of field types only
crrlog_fldtypes:    &tpl:crrfld_opfirst&      ddtype=CHAR len=1 not_null,
                    &tpl:crrfld_oplast&       ddtype=CHAR len=1 not_null,
                    &tpl:crrfld_opdelins&     ddtype=CHAR len=1 not_null,
                    &tpl:crrfld_sequence&     ddtype=INT8 not_null,
                    &tpl:crrfld_replicating&  ddtype=INT4 not_null,
                    &tpl:crrfld_isdeleted&    ddtype=CHAR len=1 not_null,
                    &tpl:crrfld_tnxid&        ddtype=DEC  len=10 digits=19 not_null,
                    &tpl:crrfld_op&           ddtype=CHAR len=1 not_null


#  additional field "CRR_OP_DELINS" only needed on Oracle + DB6
crrlog_tabflds:     &tpl:crrfld_opfirst& &tpl:crrfld_oplast& /?(&tpl:crr_need_opdelins&){ &tpl:crrfld_opdelins& /} &tpl:crrfld_sequence&

crrloghist_tabflds: &tpl:crrfld_oplast& &tpl:crrfld_sequence& &tpl:crrfld_replicating&

crrsnap_tabflds:    &tpl:crrfld_tnxid& &tpl:crrfld_op&

#  ===========================================  #
crrlog_cretab:      &tpl:cretab&
crrlog_drptab:      &tpl:drptab&
crrlog_crepky:      &tpl:crepky&
crrlog_creind:      &tpl:creind&

crrloghist_cretab:  &tpl:cretab&
crrloghist_drptab:  &tpl:drptab&
crrloghist_crepky:  &tpl:crepky&
crrloghist_creind:  &tpl:creind&

crrsnap_cretab:     &tpl:cretab&
crrsnap_drptab:     &tpl:drptab&
crrsnap_crepky:     &tpl:crepky&
crrsnap_creind:     &tpl:creind&

crrsnaphist_cretab: &tpl:cretab&
crrsnaphist_drptab: &tpl:drptab&
crrsnaphist_crepky: &tpl:crepky&
crrsnaphist_creind: &tpl:creind&

isdeleted{alias}:   CASE WHEN &alias&.&key_fld_name[1]& IS NULL THEN 'X'
                         ELSE ' '
                         END

#  ======================================================  #
#                                                          #
#  Post-creation tasks for the log/loghist/snap/... table  #
#                                                          #
#  ======================================================  #

crrpostcre_seq:
crrpostcre_log:
crrpostcre_loghist:
crrpostcre_snap:
crrpostcre_snaphist:


#  =======  #
#           #
#  Indexes  #
#           #
#  =======  #

crr_creindlog:      0(/%{&log_key_fld_name&/-, /})
                    U1(&tpl:crrfld_sequence&)
                    UIO(&tpl:crrfld_sequence&, /%{&log_key_fld_name&, /} &tpl:crrfld_oplast&)

crr_creindloghist:  0(/%{ &log_key_fld_name& /-, /})
                    U1(&tpl:crrfld_sequence&)
                    2(&tpl:crrfld_replicating&)
                    USR(&tpl:crrfld_sequence&, &tpl:crrfld_replicating&)
                    UIO(&tpl:crrfld_replicating&, /%{&log_key_fld_name&, /} &tpl:crrfld_sequence&, &tpl:crrfld_oplast&)

_crr_hint4log:
_crr_hint4loghist:

crr_creindsnap:     0(/%{&key_fld_name&/-, /} /?(&tpl:crr_has_commit_hook&){ , &tpl:crrfld_tnxid& /})

crr_creindsnaphist: 0(/%{&key_fld_name&/-, /})



#  ==========================  #
#                              #
#  Truncate the LogHist table  #
#                              #
#  ==========================  #

crr_trcloghist:     &tpl:trcdat{tab_name=&crrloghist_tab_name&}&


#  ============================  #
#                                #
#  Have a look at UPGTRTOUCH     #
#  whether a trigger on TABNAME  #
#  has fired or not              #
#                                #
#  ============================  #

crr_trtouch_name:   UPGTRTOUCH

crr_trtouch:        SELECT 'X'
                      FROM "&tpl:crr_trtouch_name&"
                     WHERE "TABNAME" = ?


#  =========================================================================  #
#                                                                             #
#  get highest sequence number in case a range select does not return values  #
#  => it is cheap to get the minimum also                                     #
#  => param for crr_sequence is the start range                               #
#                                                                             #
#  =========================================================================  #

crr_minmaxhint:
crr_selminmaxlog1:  SELECT MIN("&tpl:crrfld_sequence&")   AS MINSEQ,
                           MAX("&tpl:crrfld_sequence&")+1 AS MAXSEQ
                      FROM &crrlog_tab_name& &tpl:crr_minmaxhint&
                     WHERE "&tpl:crrfld_sequence&" >= ?
                     /* MinMax for &tab_name& */

crr_selminmaxlog2{dummy}:  SELECT (SELECT MIN("&tpl:crrfld_sequence&")
                                     FROM &crrlog_tab_name& &tpl:crr_minmaxhint&
                                    WHERE "&tpl:crrfld_sequence&" >= ?
                                   ) AS MINSEQ,
                                  (SELECT MAX("&tpl:crrfld_sequence&")+1
                                     FROM &crrlog_tab_name& &tpl:crr_minmaxhint&
                                    WHERE "&tpl:crrfld_sequence&" >= ?
                                   ) AS MAXSEQ
                             FROM &dummy&
                             /* MinMax for &tab_name& using &dummy& table*/

crr_selminmaxlog:   &tpl:crr_selminmaxlog1&

#  =========================================================================================  #
#                                                                                             #
#  update all records with &proc_number_fast_act& rsp. &proc_number_safe_act& to &proc_number_xxx_ok&  #
#                                                                                             #
#  =========================================================================================  #

_crr_sethist__ok{procno_ok,procno_act}:  UPDATE &crrloghist_tab_name&
                                            SET "&tpl:crrfld_replicating&" = &procno_ok&
                                          WHERE "&tpl:crrfld_replicating&" = &procno_act&
                                            AND "&tpl:crrfld_sequence&" >= ?
                                            AND "&tpl:crrfld_sequence&" < ?
                                            /* Set LOGHIST OK for &tab_name& */

crr_sethistok_fastconti:    &tpl:_crr_sethist__ok{procno_ok=&proc_number_cnt_fast_ok&,procno_act=&proc_number_fast_act&}&
crr_sethistok_safeconti:    &tpl:_crr_sethist__ok{procno_ok=&proc_number_cnt_safe_ok&,procno_act=&proc_number_safe_act&}&

crr_sethistok_fastfinal:    &tpl:_crr_sethist__ok{procno_ok=&proc_number_fin_fast_ok&,procno_act=&proc_number_fast_act&}&
crr_sethistok_safefinal:    &tpl:_crr_sethist__ok{procno_ok=&proc_number_fin_safe_ok&,procno_act=&proc_number_safe_act&}&
#                                                                        |   |    |                           |    |
#                                                                        |   |    +--> ok code                |    +--> active code
#                                                                        |   |                                |
#                                                                        |   +-->  mode: fast/safe select  <--+
#                                                                        |
#                                                                        +--> replay: std/fin = continuous/final replay

#  ===========================================================================  #
#                                                                               #
#  update one or many records with &proc_number_fast_act& to &proc_number_err&  #
#                                                                               #
#  ===========================================================================  #

_crr_sethist_err:       UPDATE &crrloghist_tab_name& /* SET LOGHIST to error for &tab_name& */
                           SET "&tpl:crrfld_replicating&" = &proc_number_err&

crr_sethist_err:        &tpl:_crr_sethist_err&
                         WHERE "&tpl:crrfld_replicating&" IN (&proc_number_fast_act&, &proc_number_safe_act&)

crr_sethist_err_key:    &tpl:_crr_sethist_err&
                         WHERE /%{&log_key_fld_name& = &log_key_fld_marker& /-AND /}


#  ===================================  #
#                                       #
#  Select num of remaining log entries  #
#  Update: Select the MAX and subtract  #
#          the lower border             #
#          Multiply with 0.75           #
#                                       #
#  ===================================  #

crr_selremainlog: SELECT &select_hint& MAX("&tpl:crrfld_sequence&")
                    FROM &crrlog_tab_name&


#  ==================  #
#                      #
#  Revert to snapshot  #
#                      #
#  ==================  #

crrsnap_seltabflds: &tpl:crrfld_opfirst&

#  use "inner join" since even an insert writes dummy data to snap table!
crrsnap_seltab: SELECT &select_hint& L.&tpl:crrfld_opfirst&
                       /%{, /?(&is_log_key_fld&){ L.&fld_name& /}{ S.&fld_name& /} /}
                  FROM &crrlog_tab_name&  L
            INNER JOIN &crrsnap_tab_name& S
                    ON /%{L.&log_key_fld_name& = S.&log_key_fld_name& /-AND /}
                       &where[L]&

crrsnap_seltab_sorted: &tpl:crrsnap_seltab& ORDER BY /%{S.&key_fld_name&/-, /}

crrsnap_collect_tcr_del: &tpl:trcdat{tab_name=&crrsnaphist_tab_name&}&

crrsnap_collect_tcr: INSERT INTO &crrsnaphist_tab_name&
                                 (/%{ &fld_name&, /} &tpl:crrfld_tnxid&, &tpl:crrfld_op&)
                     SELECT &select_hint& /%{ S.&fld_name&, /} S.&tpl:crrfld_tnxid&, S.&tpl:crrfld_op&
                      FROM &crrsnap_tab_name& S
                        INNER JOIN &tpl:crr_transactstatus_table& T
                           ON S.&tpl:crrfld_tnxid& = T.&tpl:crrfld_tnxid&
                        WHERE T.&tpl:crrfld_commitid& IN
                  (SELECT MIN(&tpl:crrfld_commitid&)
                           FROM &crrsnap_tab_name& A
                 INNER JOIN &tpl:crr_transactstatus_table& B
                            ON A.&tpl:crrfld_tnxid& = B.&tpl:crrfld_tnxid&
                     WHERE /%{A.&log_key_fld_name& = S.&log_key_fld_name& /-AND /}
                       AND B.&tpl:crrfld_commitid& > &crr_tcr_commitid&
                              )
                       &where_add[L]&

crrsnap_seltab_tcr: SELECT &select_hint& &tpl:crrfld_op& /%{, &fld_name& /}
                        FROM &crrsnaphist_tab_name&
                            &where&

crrsnap_seltab_sorted_tcr: &tpl:crrsnap_seltab_tcr& ORDER BY /%{S.&key_fld_name&/-, /}

crrsnap_sel_commitid: SELECT &tpl:crrfld_commitid& FROM &tpl:crr_savcommit_table&

#  ============================  #
#                                #
#  Zap deleted + insert entries  #
#                                #
#  ============================  #

crrzap_seltab: SELECT &select_hint& /%{&log_key_fld_name&/-, /}
                       /?(&is_cluster_table&){ , 0 /}
                 FROM &crrlog_tab_name&
                WHERE &tpl:crrfld_opdelins& = 'X'
                      &where_add&

crrzap_seltab_sorted: &tpl:crrzap_seltab& ORDER BY /%{S.&key_fld_name&/-, /}

#  =========  #
#             #
#  Replicate  #
#             #
#  =========  #

crrrepl_delhistactive: DELETE
                         FROM &crrloghist_tab_name&
                        WHERE "&tpl:crrfld_replicating&" IN (&proc_number_fast_act&, &proc_number_safe_act&)

crrrepl_seltabflds: &tpl:crrfld_oplast& &tpl:crrfld_sequence& &tpl:crrfld_isdeleted&

crrrepl_seltab:     SELECT &select_hint&
                           H."&tpl:crrfld_oplast&", H."&tpl:crrfld_sequence&", &tpl:isdeleted{alias=T}& AS &tpl:crrfld_isdeleted&
                           /%{, /?(&is_log_key_fld&){ H.&fld_name& /}{ T.&fld_name& /} /}
                      FROM &crrloghist_tab_name& H
           LEFT OUTER JOIN &tab_name& T
                        ON /%{H.&log_key_fld_name& = T.&log_key_fld_name& /-AND /}
                     WHERE H."&tpl:crrfld_replicating&" IN (&proc_number_fast_act&, &proc_number_safe_act&)

crrrepl_seltab_orderby:     ORDER BY /%{T.&key_fld_name&/-, /}
crrrepl_seltab_sorted:      &tpl:crrrepl_seltab& &tpl:crrrepl_seltab_orderby&


#  ==============================  #
#                                  #
#  If the MERGE does not return    #
#  the number of processed rows    #
#  one has to count them manually  #
#                                  #
#  ==============================  #

crr_upsertgetcount0:    SELECT &select_hint& COUNT(*)
                          FROM &crrloghist_tab_name&
                         WHERE "&tpl:crrfld_replicating&" IN (&proc_number_fast_act&, &proc_number_safe_act&)
                               &where_add&


###############################################
#                                             #
#  Statement type of "upserthist":            #
#  * like an update         => read dbcount   #
#  * like an insert/select  => read dbcount   #
#  * like a  select         => read callback  #
#                                             #
###############################################


crr_upsertsqltype_fastconti: UPDATE
crr_upsertsqltype_fastfinal: UPDATE
crr_upsertsqltype_safeconti: UPDATE
crr_upsertsqltype_safefinal: UPDATE

_crr_hint4merge_hd:
_crr_hint4merge_sel:


###############################################
#                                             #
#  Some DBS need a Stored Function/Procedure  #
#  to have the MERGE running fine!            #
#  Some not...                                #
#                                             #
###############################################

crr_creproc:
crr_drpproc:


#  =================================  #
#                                     #
#  DB2/DB4/DB6/MSS/SYB MERGE INTO     #
#  -> with "WHEN MATCHED AND" syntax  #
#                                     #
#  =================================  #

# DB2: https://www.toadworld.com/platforms/ibmdb2/w/wiki/7608.merge-overview
#      https://www.ibm.com/support/knowledgecenter/SSEPEK/pdf/db2z_11_sqlrefbook.pdf
# DB4: https://www.ibm.com/support/knowledgecenter/ssw_ibm_i_72/db2/rbafzmerge.htm
# DB6: https://www.ibm.com/developerworks/community/blogs/SQLTips4DB2LUW/entry/merge?lang=en
# MSS: https://docs.microsoft.com/de-de/sql/t-sql/statements/merge-transact-sql
# SYB: http://infocenter.sybase.com/help/index.jsp?topic=/com.sybase.infocenter.dc36272.1572/html/commands/commands89.htm

crr_mergel2h_option:



crr_mergelog2hist_full{mode,type}:  MERGE &tpl:_crr_hint4merge_hd&
                                       INTO &crrloghist_tab_name& &tpl:crr_mergel2h_option& H
                                      USING (SELECT &tpl:_crr_hint4merge_sel&
                                                    /%{LL.&log_key_fld_name&/-, /}, LL."&tpl:crrfld_oplast&", LL."&tpl:crrfld_sequence&"
                                               FROM &crrlog_tab_name& LL
                                              WHERE LL."&tpl:crrfld_sequence&" >= ?
                                                AND LL."&tpl:crrfld_sequence&" < ?
                                                    &where_add[LL]&
                                            ) L
                                         ON (/%{H.&log_key_fld_name& = L.&log_key_fld_name& /-AND /})
                                       #
                                       # The UPDATE branch
                                       WHEN MATCHED
                                        #
                                        # The FAST/SAFE decision building block #
                                        AND &tpl:crr_decide_fastorsafe_ij{mode=&mode&,type=&type&}&
                                        #
                                       THEN
                                     UPDATE
                                        SET H."&tpl:crrfld_oplast&"      = L."&tpl:crrfld_oplast&",
                                            H."&tpl:crrfld_sequence&"    = L."&tpl:crrfld_sequence&",
                                            H."&tpl:crrfld_replicating&" = &tpl:crr_procnum_act{mode=&mode&}&
                                       #
                                       # The INSERT branch
                                       WHEN NOT MATCHED
                                       THEN
                                     INSERT (/%{  &log_key_fld_name&, /}   "&tpl:crrfld_oplast&",   "&tpl:crrfld_sequence&", "&tpl:crrfld_replicating&")
                                     VALUES (/%{L.&log_key_fld_name&, /} L."&tpl:crrfld_oplast&", L."&tpl:crrfld_sequence&",  &tpl:crr_procnum_act{mode=&mode&}&)
                                     /* Generic Full MERGE LOG->LOGHIST for &tab_name&: &mode&/&type& */


crr_upserthist_fastconti_full:    &tpl:crr_mergelog2hist_full{mode=FAST,type=CONTI}&
crr_upserthist_fastfinal_full:    &tpl:crr_mergelog2hist_full{mode=FAST,type=FINAL}&
crr_upserthist_safeconti_full:    &tpl:crr_mergelog2hist_full{mode=SAFE,type=CONTI}&
crr_upserthist_safefinal_full:    &tpl:crr_mergelog2hist_full{mode=SAFE,type=FINAL}&


#  ===========================  #
#                               #
#  The different select logics  #
#  for FAST resp. SAFE SELECT   #
#                               #
#  ===========================  #

# ---------------------------------- #
# The decision logic with outer join #
# ---------------------------------- #

crr_decide_fastorsafe_oj_pid{mode,repl}: # with PIDs for FAST and SAFE SELECT
                                      # ignore illegal sequence numbers handled afterwards in the paranoia check
                                          (  H.&log_key_fld_name[1]& IS NULL # new LOG entries #
                                          OR L."&tpl:crrfld_sequence&" >= H."&tpl:crrfld_sequence&"
                                          )
                                      #
                                      /@(&mode&){
                                      /:(FAST) /* &mode& (outer join) */
                                      AND (  H.&log_key_fld_name[1]& IS NULL # new LOG entries
                                             # FAST: do not overwrite active ones! #
                                          OR H."&tpl:crrfld_replicating&" > &repl&
                                          )
                                      /:(SAFE) /* &mode& (outer join) */
                                      AND (  H.&log_key_fld_name[1]& IS NULL # new LOG entries #
                                             # SAFE: do not overwrite active resp. OK from FAST #
                                          OR H."&tpl:crrfld_replicating&" > &repl&
                                             # transport new sequences #
                                          OR L."&tpl:crrfld_sequence&"    > H."&tpl:crrfld_sequence&"
                                          )
                                      /}

crr_decide_fastorsafe_oj{mode,type}:  &tpl:crr_decide_fastorsafe_oj_pid{mode=&mode&,
                                                                        repl=&tpl:crr_rangelower_ok{mode=&mode&,type=&type&}&
                                                                        }&


# ---------------------------------- #
# The decision logic with inner join #
# ---------------------------------- #

crr_decide_fastorsafe_ij_pid{mode,repl}: # with PIDs for FAST and SAFE SELECT
                                      # ignore illegal sequence numbers  handled afterwards in the paranoia check
                                          L."&tpl:crrfld_sequence&"    >= H."&tpl:crrfld_sequence&"
                                      #
                                      /@(&mode&){
                                      /:(FAST) /* &mode& (inner join) */
                                          # FAST: do not overwrite active ones! #
                                      AND H."&tpl:crrfld_replicating&" > &repl&
                                      /:(SAFE) /* &mode& (inner join) */
                                      AND (  # SAFE: do not overwrite active resp. OK from FAST #
                                             H."&tpl:crrfld_replicating&" > &repl&
                                             # transport new sequences #
                                          OR L."&tpl:crrfld_sequence&"    > H."&tpl:crrfld_sequence&"
                                          )
                                      /}

crr_decide_fastorsafe_ij{mode,type}:  &tpl:crr_decide_fastorsafe_ij_pid{mode=&mode&,
                                                                        repl=&tpl:crr_rangelower_ok{mode=&mode&,type=&type&}&
                                                                        }&


#  =============================================================================  #
#                                                                                 #
#  Select all inconsistencies between the log and the loghist table               #
#  1. All with seqno in log different from the seqno of the same pkey in loghist  #
#  2. All in Log which do not exist in loghist                                    #
#  3. All in loghist which are active (< offset_ok)                               #
#  4. ALL in loghist which are in error state (> offset_err)                      #
#                                                                                 #
#  =============================================================================  #

use_value_M: 0

# Simplified version with LEFT OUTER JOIN
crr_chklogloghist_oj:       SELECT /%{L.&log_key_fld_name&, /} /%{L.&crrlog_fld_name&, /} H."&tpl:crrfld_sequence&", H."&tpl:crrfld_replicating&"
                              FROM &crrlog_tab_name& L
                   LEFT OUTER JOIN &crrloghist_tab_name& H
                                ON H."&tpl:crrfld_sequence&" = L."&tpl:crrfld_sequence&"
                             WHERE H.&log_key_fld_name[1]& IS NULL
                                OR(H.&log_key_fld_name[1]& IS NOT NULL AND
                                   H."&tpl:crrfld_replicating&" IN (&proc_number_fast_act&, &proc_number_safe_act&, &proc_number_err&)
                                   )
                             /* Simplified ChkLogLoghist (OJ) for &tab_name& */


# Simplified version with two branches via UNION ALL
crr_chklogloghist_ua:       SELECT /%{L.&log_key_fld_name&, /}
                                   L."&tpl:crrfld_opfirst&", L."&tpl:crrfld_oplast&", L."&tpl:crrfld_sequence&", -1
                              FROM &crrlog_tab_name& L
                             WHERE NOT EXISTS (SELECT 1
                                                 FROM &crrloghist_tab_name& H
                                                WHERE H."CRR_SEQUENCE" = L."CRR_SEQUENCE"
                                               )
                         UNION ALL
                            SELECT /%{H.&log_key_fld_name&, /}
                                   'X',                      H."&tpl:crrfld_oplast&", H."&tpl:crrfld_sequence&", H."&tpl:crrfld_replicating&"
                              FROM &crrloghist_tab_name& H
                             WHERE H."CRR_REPLICATING" IN (&proc_number_fast_act&, &proc_number_safe_act&, &proc_number_err&)
                            /* Simplified ChkLogLoghist (UA) for &tab_name& */


crr_chklogloghist:          &tpl:crr_chklogloghist_oj&


#  ====================================  #
#                                        #
#  Delete with key specified             #
#                                        #
#  ====================================  #

crr_deltabkey:      DELETE
                      FROM &tab_name&
                     WHERE /%{&log_key_fld_name& = &log_key_fld_marker& /-AND /}


#  ====================================  #
#                                        #
#  Drop/Create SEQ/LOG*/SNAP*            #
#                                        #
#  ====================================  #

crr_nextval:        &crrseq_name&.NEXTVAL

#  ====================================  #
crr_locklogtab:     &tpl:locktab{tab_name=&crrlog_tab_name&}&
crr_lockloghist:    &tpl:locktab{tab_name=&crrloghist_tab_name&}&


#  ====================================  #
#                                        #
#  Fill the log table via INSERT/SELECT  #
#                                        #
#  ====================================  #
crr_fillfactor:         1

crr_filllogtab:         &tpl:crr_locklogtab&
                        /;
                        INSERT
                          INTO &crrlog_tab_name&
                              (/%{&log_key_fld_name&, /} /%{&crrlog_fld_name& /-, /})
                        SELECT /%{&log_key_fld_name&, /}
                               &crr_op_first_value&, &crr_op_last_value&, /?(&tpl:crr_need_opdelins&){ ' ', /} &tpl:crr_fillfactor& * &tpl:crr_nextval&
                          FROM &tab_name&
                       /?(&is_cluster_table&){ WHERE PAGENO = 0 &where_add& /}{ &where&  /}


#  ===================================================================  #
#                                                                       #
#  Some DBs need something special at the beginning of the replication  #
#  Some don't                                                           #
#                                                                       #
#  ===================================================================  #

#  use crr_runoncebeforeall: in casethis is needed
