# $Id: //bc/lmt_023_REL/src/upg/R3ld/R3loadctl/DDLDB6_GEN.TPL#11 $ SAP

# include the generic db independent TPL:
#include DDLGEN.TPL
#include DDLDB6_CRR.TPL

cretab: &tpl:cretabgen&
        IN &location& INDEX IN &locationI& LONG IN &locationL&
	&itc_clause& &compression_clause&

cretabtmp: CREATE GLOBAL TEMPORARY TABLE &tab_name&
           ( /%{ &fld_name& &fld_desc& /-, /} )
           IN SYSTOOLSTMPSPACE
           NOT LOGGED ON COMMIT DELETE ROWS

lazytb: CREATE VIEW &tab_name& AS SELECT * FROM
        ( VALUES( /%{ &fld_cast& /-, /} )) AS &tab_name&
        ( /%{ &fld_name& /-, /} )
        WHERE 1 = 2 --DDL_TABLE &tpl:cretab&

creind: &tpl:creindgen&
        ALLOW REVERSE SCANS

drpind: &tpl:drpindgen&

crepky: &tpl:creind{ind_name=&pri_key&,unique=UNIQUE}&
        /;
        ALTER TABLE &tab_name&
        ADD CONSTRAINT &pri_key&
        PRIMARY KEY ( /%{ &key_fld_name& /-, /} )

crepkytmp: &tpl:creind{ind_name= &pri_key&,unique=UNIQUE}&

drppky: ALTER TABLE &tab_name& DROP PRIMARY KEY
        /;
        &tpl:drpind{ind_name=&pri_key&}&

drppkytmp: &tpl:drpind{ind_name=&pri_key&}&

deldat:  BEGIN
           DECLARE rows_deleted INTEGER;
           delete_loop: LOOP
             DELETE FROM
               ( SELECT 1 FROM &tab_name& &where& LIMIT &commit_count& );
             get diagnostics rows_deleted = row_count ;
             COMMIT;
             IF rows_deleted = 0 THEN LEAVE delete_loop; END IF;
           END LOOP delete_loop;
         END

#  for fast loader
copytable:      CREATE TABLE &current_tab_name& LIKE &tab_name& IN &location& &db_compression&

enableappmode:  ALTER TABLE &current_tab_name& APPEND ON VOLATILE
disableappmode: ALTER TABLE &current_tab_name& APPEND OFF NOT VOLATILE &mdc_clause&

switchlockmode: ALTER TABLE &current_tab_name& LOCKSIZE TABLE

actlogmode:     ALTER TABLE &current_tab_name& ACTIVATE NOT LOGGED INITIALLY


#  #########  #
#             #
#  CRR stuff  #
#             #
#  #########  #

#  additional field "CRR_OP_DELINS" needed
crr_need_opdelins:      1

# ------------------------------------------------------------------------------------------
# DB6: https://www.ibm.com/developerworks/community/blogs/SQLTips4DB2LUW/entry/merge?lang=en

############################################
#                                          #
#  Work with a Declared GTT => ATOMIC :-)  #
#  Using a slow but exact LOOP cursor      #
#  but no slow GET DIAGNOSTICS             #
#                                          #
############################################

crr_upserthist_gtt:     "/1CRR/TBL/MERGE_ROWCOUNT"
crr_upserthist_gttf:    "MERGE_ROWCOUNT"
crr_runoncebeforeall:   DECLARE GLOBAL TEMPORARY TABLE &tpl:crr_upserthist_gtt& (&tpl:crr_upserthist_gttf& BIGINT) NOT LOGGED ON COMMIT DELETE ROWS

crr_upserthist_conti{mode}: BEGIN ATOMIC
                                  DECLARE sum_rows BIGINT DEFAULT 0;
                                  SET sum_rows = 0;
                                  DELETE FROM SESSION.&tpl:crr_upserthist_gtt&;

                                  # Cursor definition
                                  FOR LX AS
                                    SELECT &tpl:_crr_hint4merge_sel&
                                           /%{L.&log_key_fld_name&/-, /}, L."&tpl:crrfld_oplast&", L."&tpl:crrfld_sequence&"
                                      FROM &crrlog_tab_name& L
                           LEFT OUTER JOIN &crrloghist_tab_name& H
                                        ON /%{H.&log_key_fld_name& = L.&log_key_fld_name& /-AND /}
                                     WHERE L."&tpl:crrfld_sequence&" >= ?
                                       AND L."&tpl:crrfld_sequence&" < ?
                                       #
                                       # the FAST/SAFE decision building block #
                                       AND &tpl:crr_decide_fastorsafe_oj{mode=&mode&,type=CONTI}&
                                       #
                                       AND L."&tpl:crrfld_oplast&" != 'M'
                                           &where_add[L]&

                                  # Loop start
                                  DO
                                    MERGE
                                     INTO &crrloghist_tab_name& AS HX
                                    USING TABLE( VALUES (/%{LX.&log_key_fld_name&, /} LX."&tpl:crrfld_oplast&", LX."&tpl:crrfld_sequence&", &tpl:crr_procnum_act{mode=&mode&}& )
                                               )
                                       ON (/%{HX.&log_key_fld_name& = LX.&log_key_fld_name& /-AND /})

                                     # The UPDATE branch
                                     WHEN MATCHED THEN
                                   UPDATE
                                      SET HX."&tpl:crrfld_oplast&"      = LX."&tpl:crrfld_oplast&",
                                          HX."&tpl:crrfld_sequence&"    = LX."&tpl:crrfld_sequence&",
                                          HX."&tpl:crrfld_replicating&" = &tpl:crr_procnum_act{mode=&mode&}&

                                     # The INSERT branch
                                     WHEN NOT MATCHED THEN
                                   INSERT ( /%{   &log_key_fld_name&, /}    "&tpl:crrfld_oplast&",    "&tpl:crrfld_sequence&", "&tpl:crrfld_replicating&" )
                                   VALUES ( /%{LX.&log_key_fld_name&, /} LX."&tpl:crrfld_oplast&", LX."&tpl:crrfld_sequence&",  &tpl:crr_procnum_act{mode=&mode&}& );

                                   # Statistics
                                   SET sum_rows = sum_rows + 1;
                                  END FOR;

                                  # Transfer the result via DGGT
                                  INSERT
                                    INTO SESSION.&tpl:crr_upserthist_gtt&
                                         (&tpl:crr_upserthist_gttf&)
                                  VALUES (sum_rows);
                                END
                                /* DB6 MERGE LOG->LOGHIST for &tab_name&: &mode&/CONTI */

crr_upsertcount__DB6:       SELECT &tpl:crr_upserthist_gttf&
                              FROM SESSION.&tpl:crr_upserthist_gtt&

crr_upserthist_fastconti:   &tpl:crr_upserthist_conti{mode=FAST}&
crr_upserthist_safeconti:   &tpl:crr_upserthist_conti{mode=SAFE}&
crr_upserthist_fastfinal:   &tpl:crr_upserthist_fastfinal_full&
crr_upserthist_safefinal:   &tpl:crr_upserthist_safefinal_full&

crr_upsertsqltype_fastconti: OTHERS
crr_upsertsqltype_safeconti: OTHERS

crr_upsertcount_conti:      &tpl:crr_upsertcount__DB6&


#  ===================================================  #
#                                                       #
#  LOG and LOGHIST can have the table attribute APPEND  #
#                                                       #
#  ===================================================  #

crrtab_attributes:      ALTER TABLE &tab_name& APPEND ON

crrpostcre_log:         /?(not &has_task_modifier[f]&){
                            ALTER TABLE &crrlog_tab_name& ALTER COLUMN "&tpl:crrfld_sequence&" DROP DEFAULT /;
                            ALTER TABLE &crrlog_tab_name& ALTER COLUMN "&tpl:crrfld_sequence&" SET GENERATED ALWAYS AS IDENTITY (START WITH 1 INCREMENT BY 1 NO CYCLE CACHE 50 ORDER) /;
                        /}
                        ALTER TABLE &crrlog_tab_name& VOLATILE /;
                        &tpl:crrtab_attributes{tab_name=&crrlog_tab_name&}&

crrpostcre_loghist:     ALTER TABLE &crrloghist_tab_name& VOLATILE /;
                        &tpl:crrtab_attributes{tab_name=&crrloghist_tab_name&}&

crrpostcre_snap:        &tpl:crrtab_attributes{tab_name=&crrsnap_tab_name&}&

#  therefore set erroneous rows to err instead of deleting them:
crrrepl_delhistactive:  &tpl:crr_sethist_err&
