# $Id: //bc/lmt_023_REL/src/upg/R3ld/R3loadctl/DDLGEN.TPL#12 $ SAP

#include DDLCRR.TPL

#---------------------------------------------------------
seltab:             SELECT &select_hint& /%{&fld_name&/-, /} FROM &tab_name&
                        &where&

seltab_sorted:      &tpl:seltab& ORDER BY /%{&key_fld_name&/-, /}

seltab_single:      SELECT /%{&fld_name&/-, /} FROM &tab_name&
                        WHERE /%{&key_fld_name& = &key_fld_marker& /-AND /}

#  this must be sorted for page number!
selclu_single:      SELECT /%{&fld_name&/-, /} FROM &tab_name&
                        WHERE /%{&clu_key_fld_name& = &clu_key_fld_marker& /-AND /}
                    ORDER BY &pageno_fld_name&

instab:             INSERT INTO &tab_name& (/%{&fld_name&/-, /})
                        VALUES (/%{&fld_marker&/-, /})

deltabkey:          DELETE FROM &tab_name&
                        WHERE /%{&key_fld_name& = &key_fld_marker& /-AND /}

locktab:            LOCK TABLE &tab_name& IN EXCLUSIVE MODE

#---------------------------------------------------------
cretabgen:          CREATE TABLE &tab_name& ( /%{ &fld_name& &fld_desc& /-, /} )

drptabgen:          DROP TABLE &tab_name&

# +++  defines (no tokens!!) +++
creindgen:          CREATE &unique& INDEX &ind_name&
                        ON &tab_name& ( /%{ &key_fld_name& /-, /} )

drpindgen:          DROP INDEX &ind_name&

deldat0:            DELETE FROM &tab_name&

deldatgen:          &tpl:deldat0& &where&

trcdatgen:          TRUNCATE TABLE &tab_name&

# +++  check table existance  +++
chktabexistsgen:    SELECT 'X' FROM &dbschema&.&tab_name& WHERE 1 = 0


# +++  find cluster entries without page zero
chkmisspagezero:    SELECT /%{ &log_key_fld_name&, /} MIN(&pageno_fld_name&) FROM &tab_name&
                        GROUP BY /%{ &log_key_fld_name&/-, /}
                        HAVING MIN(&pageno_fld_name&) > 0

#---------------------------------------------------------
# +++  views +++
creviegen:          CREATE VIEW &view_name& ( /%{ &fld_name& /-, /} )
                        AS &query&

drpviegen:          DROP VIEW &view_name&

#---------------------------------------------------------
#  Set defaults to be overwritten by database specific templates
cretab:             &tpl:cretabgen&
drptab:             &tpl:drptabgen&
drpind:             &tpl:drpindgen&
deldat:             &tpl:deldatgen&
trcdat:             &tpl:trcdatgen&
chktabexists:       &tpl:chktabexistsgen&
crevie:             &tpl:creviegen&
drpvie:             &tpl:drpviegen&

#  defaults to nothing
revmerge:
revunload:

#---------------------------------------------------------
#---------------------------------------------------------
# +++  generic entries  +++
negtab: LICHECK MLICHECK

negdat: LICHECK MLICHECK

#  hardcoded
negdat: PKRT_LOAD{LOAD_KIND = 3 OR LOAD_KIND = 4}
        PKRT_LOAD_DEP{LOAD_KIND = 3 OR LOAD_KIND = 4}

negind: LICHECK~0 MLICHECK~0 LICHECK^0 MLICHECK^0
