# $Id: //bc/lmt_023_REL/src/upg/R3ld/R3loadctl/DDLDB2_GEN.TPL#11 $ SAP

# include the generic db independent TPL:
#include DDLGEN.TPL
#include DDLDB2_CRR.TPL

cretab: &tpl:cretabgen& CCSID &ccsid&

crepky: &tpl:creindgen{ind_name=&pri_key&,unique=UNIQUE}&
        DEFINE NO &clustered&
        /;
        ALTER TABLE &tab_name&
          ADD PRIMARY KEY ( /%{ &key_fld_name& /-, /} )
drppky: ALTER TABLE &tab_name& DROP PRIMARY KEY
        /;
        DROP INDEX &pri_key&

creind: &tpl:creindgen& DEFINE NO
drpind: &tpl:drpindgen&

#seltab: /?( not &is_sorted_data& and ( not &is_split_data& or &is_split_on_partition_boundary& )){
#         WITH DSN_INLINE_OPT_HINT ( TABLE_NAME, ACCESS_TYPE ) AS ( VALUES ('&tab_name&', 'RSCAN') )
#        /}
#    SELECT /%{&fld_name&/-, /}
#          FROM &tab_name&
#        &where&

seltab:         SELECT &select_hint&
                     /%{ /@(&fld_ddtype&){
                         /:(DATN)
                           substr(CAST(&fld_name& AS CHAR(10)),1,4)
                        || substr(CAST(&fld_name& AS CHAR(10)),6,2)
                        || substr(CAST(&fld_name& AS CHAR(10)),9,2)
                         /:(TIMN)
                           substr(CAST(&fld_name& AS CHAR(8)),1,2)
                        || substr(CAST(&fld_name& AS CHAR(8)),4,2)
                        || substr(CAST(&fld_name& AS CHAR(8)),7,2)
                                 /:       &fld_name& /}/-, /} FROM &tab_name& &where&

# +++  temporary tables  +++ #
cretabtmp: CREATE TABLE &cgtt_tab_name&
               ( &cgtt_id_column& &cgtt_idcoldesc&,
                /%{ &fld_name& &fld_desc& /-, /} )
           CCSID &ccsid& VOLATILE MEMBER CLUSTER APPEND YES
           /;
           CREATE VIEW &tab_name&
               ( /%{ &fld_name& /-, /} )
               AS SELECT /%{ &fld_name& /-, /}
                    FROM &cgtt_tab_name&
                   WHERE &cgtt_id_column& = CURRENT CLIENT_ACCTNG

drptabtmp: DROP VIEW &tab_name&
           /;
           DROP TABLE &cgtt_tab_name&
crepkytmp: CREATE UNIQUE INDEX &pri_key& ON &cgtt_tab_name&
               ( &cgtt_id_column&, /%{ &key_fld_name& /-, /} )
               DEFINE NO &clustered&
drppkytmp: &tpl:drpindgen&

creindtmp: CREATE &unique& INDEX &ind_name&
               ON &cgtt_tab_name& ( &cgtt_id_column&, /%{ &fld_name& /-, /} ) DEFINE NO
drpindtmp: &tpl:drpindgen&



#  #########  #
#             #
#  CRR stuff  #
#             #
#  #########  #

#  additional field "CRR_OP_DELINS" needed
crr_need_opdelins:      1

crrproc_name__DB2{mode}: "&crrproc_name0&_&mode&"

_crrproc{mode}: CREATE FUNCTION &tpl:crrproc_name__DB2{mode=&mode&}&
                                ( IV_WIN_START   DECIMAL(15,0),
                                  IV_WIN_END     DECIMAL(15,0),
                                  IV_PID_LOWER   INTEGER,
                                  IV_PID_ACTIVE  INTEGER)
                  RETURNS BIGINT

                  VERSION V1 SPECIFIC &tpl:crrproc_name__DB2{mode=&mode&}&
                  LANGUAGE SQL
                  NO EXTERNAL ACTION
                  MODIFIES SQL DATA
                  PARAMETER CCSID UNICODE
                  CONCURRENT ACCESS RESOLUTION USE CURRENTLY COMMITTED
                  APPLICATION ENCODING SCHEME UNICODE
                  REOPT ONCE
                  DISABLE DEBUG MODE

                BEGIN
                  DECLARE NROWS BIGINT DEFAULT 0;

                  FOR CC AS
                    SELECT /%{LX.&log_key_fld_name&/-, /}, LX."&tpl:crrfld_oplast&", LX."&tpl:crrfld_sequence&"
                      FROM (
                            # OUTER JOIN for new records
                            SELECT /%{L.&log_key_fld_name&/-, /}, L."&tpl:crrfld_oplast&", L."&tpl:crrfld_sequence&"
                              FROM &crrlog_tab_name&      L
                   LEFT OUTER JOIN &crrloghist_tab_name&  H
                                ON /%{H.&log_key_fld_name& = L.&log_key_fld_name& /-AND /}
                             WHERE H.&log_key_fld_name[1]& IS NULL
                               AND L."&tpl:crrfld_sequence&" >= IV_WIN_START
                               AND L."&tpl:crrfld_sequence&" <  IV_WIN_END
                            #
                         UNION ALL
                            #
                            # INNER JOIN for records to be updated
                            SELECT /%{L.&log_key_fld_name&/-, /}, L."&tpl:crrfld_oplast&", L."&tpl:crrfld_sequence&"
                              FROM &crrlog_tab_name&      L
                        INNER JOIN &crrloghist_tab_name&  H
                                ON /%{H.&log_key_fld_name& = L.&log_key_fld_name& /-AND /}
                             WHERE L."&tpl:crrfld_sequence&" >= IV_WIN_START
                               AND L."&tpl:crrfld_sequence&" <  IV_WIN_END
                               #
                               # the FAST/SAFE decision building block #
                               AND &tpl:crr_decide_fastorsafe_ij_pid{mode=&mode&,
                                                                     repl=IV_PID_LOWER
                                                                     }&
                            ) LX
                  DO
                      MERGE
                       INTO &crrloghist_tab_name& H
                      USING (VALUES (/%{CC.&log_key_fld_name&/-, /}, CC."&tpl:crrfld_oplast&", CC."&tpl:crrfld_sequence&") )
                         AS L       (/%{&log_key_fld_name&/-, /},       "&tpl:crrfld_oplast&",    "&tpl:crrfld_sequence&")
                         ON (/%{H.&log_key_fld_name& = L.&log_key_fld_name& /-AND /})
                      #
                      # The UPDATE branch
                      WHEN MATCHED THEN
                    UPDATE
                       SET H."&tpl:crrfld_oplast&"      = L."&tpl:crrfld_oplast&",
                           H."&tpl:crrfld_sequence&"    = L."&tpl:crrfld_sequence&",
                           H."&tpl:crrfld_replicating&" = IV_PID_ACTIVE
                      #
                      # The INSERT branch
                      WHEN NOT MATCHED THEN
                    INSERT (/%{  &log_key_fld_name&, /}   "&tpl:crrfld_oplast&",   "&tpl:crrfld_sequence&", "&tpl:crrfld_replicating&")
                    VALUES (/%{L.&log_key_fld_name&, /} L."&tpl:crrfld_oplast&", L."&tpl:crrfld_sequence&", IV_PID_ACTIVE);
                    #
                    SET NROWS = NROWS + 1;
                  END FOR;
                  #
                  RETURN NROWS;
                END

crr_creproc:    &tpl:_crrproc{mode=FAST}&
                /;
                &tpl:_crrproc{mode=SAFE}&

crr_drpproc:    DROP FUNCTION &tpl:crrproc_name__DB2{mode=FAST}&
                /;
                DROP FUNCTION &tpl:crrproc_name__DB2{mode=SAFE}&

_dummytabdb2:   SYSIBM.SYSDUMMY1

crr_upserthist__DB2{mode,type}: SELECT &tpl:crrproc_name__DB2{mode=&mode&}&
                                           (?, ?,
                                           &tpl:crr_rangelower_ok{mode=&mode&,type=&type&}&,
                                           &tpl:crr_procnum_act{mode=&mode&}&
                                           )
                                  FROM &tpl:_dummytabdb2&
                                  /* DB2 MERGE LOG->LOGHIST w/ StoredFct for &tab_name&: &mode&/&type& */

crr_upserthist_fastconti:       &tpl:crr_upserthist__DB2{mode=FAST,type=CONTI}&
crr_upserthist_fastfinal:       &tpl:crr_upserthist__DB2{mode=FAST,type=FINAL}&
crr_upserthist_safeconti:       &tpl:crr_upserthist__DB2{mode=SAFE,type=CONTI}&
crr_upserthist_safefinal:       &tpl:crr_upserthist__DB2{mode=SAFE,type=FINAL}&

crr_upsertsqltype_fastconti:    SELECT
crr_upsertsqltype_fastfinal:    SELECT
crr_upsertsqltype_safeconti:    SELECT
crr_upsertsqltype_safefinal:    SELECT

crr_selminmaxlog:               &tpl:crr_selminmaxlog2{dummy=&tpl:_dummytabdb2&}&

crr_chklogloghist:              &tpl:crr_chklogloghist_ua&

crrpostcre_log:                 ALTER TABLE &crrlog_tab_name& VOLATILE
crrpostcre_loghist:             ALTER TABLE &crrloghist_tab_name& VOLATILE
