# $Id: //bc/lmt_023_REL/src/upg/R3ld/R3loadctl/DDLORA_GEN.TPL#14 $ SAP

# include the generic db independent TPL:
#include DDLGEN.TPL
#include DDLORA_CRR.TPL

oratimeout:600

setlocktimeout: ALTER SESSION SET DDL_LOCK_TIMEOUT = &tpl:oratimeout&

objstorage: STORAGE (INITIAL     &init&
                     NEXT        &next&
                     MINEXTENTS  &minext&
                     MAXEXTENTS  &maxext&
                     PCTINCREASE &pctinc& )

ind_nrparallel:   4

parallel_clause: PARALLEL &tpl:ind_nrparallel& /;
                 ALTER INDEX &ind_name& NOPARALLEL

cretab:   &tpl:cretabgen&
          TABLESPACE &tablespace&
          &compress& &lob_cache& &tpl:objstorage&

drptab:   &tpl:setlocktimeout& /;
          &tpl:drptabgen&

creindex: CREATE &unique& INDEX &ind_name&
          ON &tab_name&
          ( /%{ &key_fld_name& /-, /} )
          TABLESPACE &tablespace&
          &tpl:objstorage&

creind:   &tpl:creindex&
          /?(not &is_order_by&){ &tpl:parallel_clause{ind_name=&ind_name&}& /}

drpind:   &tpl:setlocktimeout& /;
          &tpl:drpindgen&

crepky:   &tpl:creindex{ind_name=&pri_key&,unique=UNIQUE}&
          /?(not &is_order_by&){ &tpl:parallel_clause{ind_name=&pri_key&}& /}

drppky:   &tpl:setlocktimeout& /;
          DROP INDEX &pri_key&


crevie:   CREATE VIEW &view_name&
          ( /%{ &fld_name& /-, /} )
          AS &query&

drpvie:   DROP VIEW &view_name&

cretabtmp: CREATE GLOBAL TEMPORARY TABLE &tab_name&
           ( /%{ &fld_name& &fld_desc& /-, /} )

crepkytmp: CREATE UNIQUE INDEX &pri_key&
           ON &tab_name&
           ( /%{ &key_fld_name& /-, /} )

creindtmp: CREATE &unique& INDEX &ind_name&
           ON &tab_name&
           ( /%{ &fld_name& /-, /} )

trcdat:   &tpl:setlocktimeout& /;
          TRUNCATE TABLE &tab_name&

deldat:   DELETE FROM &tab_name& &where&

negcpr: ARFCSSTATE ARFCSDATA ARFCRSTATE TRFCQDATA TRFCQIN TRFCQOUT TRFCQSTATE QRFCTRACE QRFCLOG

#  #########  #
#             #
#  CRR stuff  #
#             #
#  #########  #

#  additional field "CRR_OP_DELINS" needed
crr_need_opdelins:      1

crr_trtouch_fct:        /1CRR/READ_&tpl:crr_trtouch_name&
crr_cretrtouch_fct:     CREATE OR REPLACE FUNCTION "&tpl:crr_trtouch_fct&" (P_TABNAME IN VARCHAR2)
                        RETURN CHAR
                        RESULT_CACHE RELIES_ON(&tpl:crr_trtouch_name&)
                        AS
                          L_FLAG CHAR = ' ';
                        BEGIN
                          SELECT 'X'
                            INTO L_FLAG
                            FROM "&tpl:crr_trtouch_name&"
                           WHERE "TABNAME" = P_TABNAME;

                          RETURN L_FLAG;
                        END

#  For the CRR LOG table only
crrlog_cretab:  CREATE TABLE &crrlog_tab_name&
                (/%{&fld_name& &fld_desc&/-, /},
                 CONSTRAINT "&crrlog_tab_name0&~PK" PRIMARY KEY ("&tpl:crrfld_sequence&")
                )
                ORGANIZATION INDEX
                TABLESPACE &tablespace&
                &tpl:objstorage&

crr_creindlog:  U1(/%{&log_key_fld_name&/-, /})


# ORA: https://docs.oracle.com/cd/B28359_01/server.111/b28286/statements_9016.htm#SQLRF01606
#      https://docs.oracle.com/cd/B19306_01/server.102/b14200/sql_elements006.htm


# Hint was proposed by Oracle, but maybe it is not helpful.
# => default: OFF
crr_useORAhint: 0

_crr_hint4merge_hd: /*+ PARALLEL INDEX(H "&crrloghist_tab_name0&~0") USE_HASH(L H) */

crr_mergelog2hist__ORA{mode,type}:  MERGE /?(&tpl:crr_useORAhint&){ &tpl:_crr_hint4merge_hd& /}{ /* no hint! */ /}
                                     INTO &crrloghist_tab_name& H
                                    USING (SELECT /%{LL.&log_key_fld_name&/-, /},
                                                  LL."&tpl:crrfld_oplast&",
                                                  LL."&tpl:crrfld_sequence&"
                                             FROM &crrlog_tab_name& LL
                                            WHERE LL."&tpl:crrfld_sequence&" >= ?
                                              AND LL."&tpl:crrfld_sequence&" <  ?
                                                  &where_add[LL]&
                                           ) L
                                       ON (/%{H.&log_key_fld_name& = L.&log_key_fld_name& /-AND /})
                                     #
                                     # The UPDATE branch
                                     WHEN MATCHED THEN
                                   UPDATE
                                      SET H."&tpl:crrfld_oplast&"      = L."&tpl:crrfld_oplast&",
                                          H."&tpl:crrfld_sequence&"    = L."&tpl:crrfld_sequence&",
                                          H."&tpl:crrfld_replicating&" = &tpl:crr_procnum_act{mode=&mode&}&
                                          #
                                          # The FAST/SAFE decision building block #
                                    WHERE &tpl:crr_decide_fastorsafe_ij{mode=&mode&,type=&type&}&
                                     #
                                     # The INSERT branch
                                     WHEN NOT MATCHED THEN
                                   INSERT (/%{  &log_key_fld_name&, /}   "&tpl:crrfld_oplast&",   "&tpl:crrfld_sequence&", "&tpl:crrfld_replicating&" )
                                   VALUES (/%{L.&log_key_fld_name&, /} L."&tpl:crrfld_oplast&", L."&tpl:crrfld_sequence&",  &tpl:crr_procnum_act{mode=&mode&}& )
                                   /* ORA MERGE LOG->LOGHIST for &tab_name&: &mode&/&type& */


crr_upserthist_fastconti:   &tpl:crr_mergelog2hist__ORA{mode=FAST,type=CONTI}&
crr_upserthist_fastfinal:   &tpl:crr_mergelog2hist__ORA{mode=FAST,type=FINAL}&
crr_upserthist_safeconti:   &tpl:crr_mergelog2hist__ORA{mode=SAFE,type=CONTI}&
crr_upserthist_safefinal:   &tpl:crr_mergelog2hist__ORA{mode=SAFE,type=FINAL}&

crr_selminmaxlog:           &tpl:crr_selminmaxlog2{dummy=DUAL}&
crr_chklogloghist:          &tpl:crr_chklogloghist_ua&

# from SAP Note 2295541
crrpostcre_log:         BEGIN DBMS_STATS.UNLOCK_TABLE_STATS(ownname => '&dbschema0&', tabname => '&crrlog_tab_name&'); END; /;
                        #
                        BEGIN DBMS_STATS.SET_TABLE_STATS (ownname => '&dbschema0&', tabname => '&crrlog_tab_name&',        numrows  => 10000000, no_invalidate=>FALSE); END; /;
                        BEGIN DBMS_STATS.SET_TABLE_STATS (ownname => '&dbschema0&', tabname => '&crrlog_tab_name&',        numblks  =>   100000, no_invalidate=>FALSE); END; /;
                        # primary key
                        BEGIN DBMS_STATS.SET_INDEX_STATS (ownname => '&dbschema0&', indname => '"&crrlog_tab_name0&~PK"',  numrows  => 10000000, no_invalidate=>FALSE); END; /;
                        BEGIN DBMS_STATS.SET_INDEX_STATS (ownname => '&dbschema0&', indname => '"&crrlog_tab_name0&~PK"',  numlblks =>   100000, no_invalidate=>FALSE); END; /;
                        BEGIN DBMS_STATS.SET_INDEX_STATS (ownname => '&dbschema0&', indname => '"&crrlog_tab_name0&~PK"',  indlevel =>        3, no_invalidate=>FALSE); END; /;
                        BEGIN DBMS_STATS.SET_INDEX_STATS (ownname => '&dbschema0&', indname => '"&crrlog_tab_name0&~PK"',  numdist  => 10000000, no_invalidate=>FALSE); END; /;
                        BEGIN DBMS_STATS.SET_INDEX_STATS (ownname => '&dbschema0&', indname => '"&crrlog_tab_name0&~PK"',  clstfct  =>   140000, no_invalidate=>FALSE); END; /;
                        # index U1
                        BEGIN DBMS_STATS.SET_INDEX_STATS (ownname => '&dbschema0&', indname => '"&crrlog_tab_name0&~U1"',  numrows  => 10000000, no_invalidate=>FALSE); END; /;
                        BEGIN DBMS_STATS.SET_INDEX_STATS (ownname => '&dbschema0&', indname => '"&crrlog_tab_name0&~U1"',  numlblks =>   100000, no_invalidate=>FALSE); END; /;
                        BEGIN DBMS_STATS.SET_INDEX_STATS (ownname => '&dbschema0&', indname => '"&crrlog_tab_name0&~U1"',  indlevel =>        3, no_invalidate=>FALSE); END; /;
                        BEGIN DBMS_STATS.SET_INDEX_STATS (ownname => '&dbschema0&', indname => '"&crrlog_tab_name0&~U1"',  numdist  => 10000000, no_invalidate=>FALSE); END; /;
                        BEGIN DBMS_STATS.SET_INDEX_STATS (ownname => '&dbschema0&', indname => '"&crrlog_tab_name0&~U1"',  clstfct  =>   140000, no_invalidate=>FALSE); END; /;
                        # sequence no and ABAP key fields
                        BEGIN DBMS_STATS.SET_COLUMN_STATS(ownname => '&dbschema0&', tabname => '&crrlog_tab_name&', colname => '&tpl:crrfld_sequence&', distcnt => 1000000, no_invalidate=>FALSE); END; /;
                     /%{BEGIN DBMS_STATS.SET_COLUMN_STATS(ownname => '&dbschema0&', tabname => '&crrlog_tab_name&', colname => '&log_key_fld_name&',    distcnt => 1000000, no_invalidate=>FALSE); END; /;
                     /}
                        BEGIN DBMS_STATS.LOCK_TABLE_STATS(ownname => '&dbschema0&', tabname => '&crrlog_tab_name&'); END;


crrpostcre_loghist:     BEGIN DBMS_STATS.UNLOCK_TABLE_STATS(ownname => '&dbschema0&', tabname => '&crrloghist_tab_name&'); END; /;
                        #
                        BEGIN DBMS_STATS.SET_TABLE_STATS (ownname => '&dbschema0&', tabname => '&crrloghist_tab_name&',        numrows  => 10000000, no_invalidate=>FALSE); END; /;
                        BEGIN DBMS_STATS.SET_TABLE_STATS (ownname => '&dbschema0&', tabname => '&crrloghist_tab_name&',        numblks  =>   100000, no_invalidate=>FALSE); END; /;
                        # primary key
                        BEGIN DBMS_STATS.SET_INDEX_STATS (ownname => '&dbschema0&', indname => '"&crrloghist_tab_name0&~0"',   numrows  => 10000000, no_invalidate=>FALSE); END; /;
                        BEGIN DBMS_STATS.SET_INDEX_STATS (ownname => '&dbschema0&', indname => '"&crrloghist_tab_name0&~0"',   numlblks =>   100000, no_invalidate=>FALSE); END; /;
                        BEGIN DBMS_STATS.SET_INDEX_STATS (ownname => '&dbschema0&', indname => '"&crrloghist_tab_name0&~0"',   indlevel =>        3, no_invalidate=>FALSE); END; /;
                        BEGIN DBMS_STATS.SET_INDEX_STATS (ownname => '&dbschema0&', indname => '"&crrloghist_tab_name0&~0"',   numdist  => 10000000, no_invalidate=>FALSE); END; /;
                        BEGIN DBMS_STATS.SET_INDEX_STATS (ownname => '&dbschema0&', indname => '"&crrloghist_tab_name0&~0"',   clstfct  =>   140000, no_invalidate=>FALSE); END; /;
                        # index U1
                        BEGIN DBMS_STATS.SET_INDEX_STATS (ownname => '&dbschema0&', indname => '"&crrloghist_tab_name0&~U1"',  numrows  => 10000000, no_invalidate=>FALSE); END; /;
                        BEGIN DBMS_STATS.SET_INDEX_STATS (ownname => '&dbschema0&', indname => '"&crrloghist_tab_name0&~U1"',  numlblks =>   100000, no_invalidate=>FALSE); END; /;
                        BEGIN DBMS_STATS.SET_INDEX_STATS (ownname => '&dbschema0&', indname => '"&crrloghist_tab_name0&~U1"',  indlevel =>        3, no_invalidate=>FALSE); END; /;
                        BEGIN DBMS_STATS.SET_INDEX_STATS (ownname => '&dbschema0&', indname => '"&crrloghist_tab_name0&~U1"',  numdist  => 10000000, no_invalidate=>FALSE); END; /;
                        BEGIN DBMS_STATS.SET_INDEX_STATS (ownname => '&dbschema0&', indname => '"&crrloghist_tab_name0&~U1"',  clstfct  =>   140000, no_invalidate=>FALSE); END; /;
                        # index USR
                        BEGIN DBMS_STATS.SET_INDEX_STATS (ownname => '&dbschema0&', indname => '"&crrloghist_tab_name0&~USR"', numrows  => 10000000, no_invalidate=>FALSE); END; /;
                        BEGIN DBMS_STATS.SET_INDEX_STATS (ownname => '&dbschema0&', indname => '"&crrloghist_tab_name0&~USR"', numlblks =>   100000, no_invalidate=>FALSE); END; /;
                        BEGIN DBMS_STATS.SET_INDEX_STATS (ownname => '&dbschema0&', indname => '"&crrloghist_tab_name0&~USR"', indlevel =>        3, no_invalidate=>FALSE); END; /;
                        BEGIN DBMS_STATS.SET_INDEX_STATS (ownname => '&dbschema0&', indname => '"&crrloghist_tab_name0&~USR"', numdist  => 10000000, no_invalidate=>FALSE); END; /;
                        BEGIN DBMS_STATS.SET_INDEX_STATS (ownname => '&dbschema0&', indname => '"&crrloghist_tab_name0&~USR"', clstfct  =>   140000, no_invalidate=>FALSE); END; /;
                        # index UIO
                        BEGIN DBMS_STATS.SET_INDEX_STATS (ownname => '&dbschema0&', indname => '"&crrloghist_tab_name0&~UIO"', numrows  => 10000000, no_invalidate=>FALSE); END; /;
                        BEGIN DBMS_STATS.SET_INDEX_STATS (ownname => '&dbschema0&', indname => '"&crrloghist_tab_name0&~UIO"', numlblks =>   100000, no_invalidate=>FALSE); END; /;
                        BEGIN DBMS_STATS.SET_INDEX_STATS (ownname => '&dbschema0&', indname => '"&crrloghist_tab_name0&~UIO"', indlevel =>        3, no_invalidate=>FALSE); END; /;
                        BEGIN DBMS_STATS.SET_INDEX_STATS (ownname => '&dbschema0&', indname => '"&crrloghist_tab_name0&~UIO"', numdist  => 10000000, no_invalidate=>FALSE); END; /;
                        BEGIN DBMS_STATS.SET_INDEX_STATS (ownname => '&dbschema0&', indname => '"&crrloghist_tab_name0&~UIO"', clstfct  =>   140000, no_invalidate=>FALSE); END; /;
                        # sequence no and ABAP key fields
                        BEGIN DBMS_STATS.SET_COLUMN_STATS(ownname => '&dbschema0&', tabname => '&crrloghist_tab_name&', colname => '&tpl:crrfld_sequence&', distcnt => 1000000, no_invalidate=>FALSE); END; /;
                     /%{BEGIN DBMS_STATS.SET_COLUMN_STATS(ownname => '&dbschema0&', tabname => '&crrloghist_tab_name&', colname => '&log_key_fld_name&',    distcnt => 1000000, no_invalidate=>FALSE); END; /;
                     /}
                        BEGIN DBMS_STATS.LOCK_TABLE_STATS(ownname => '&dbschema0&', tabname => '&crrloghist_tab_name&'); END;
