# $Id: //bc/lmt_023_REL/src/upg/R3ld/R3loadctl/DDLSYB_GEN.TPL#10 $ SAP

# include the generic db independent TPL:
#include DDLGEN.TPL
#include DDLSYB_CRR.TPL

with_consumers:   WITH CONSUMERS = 3

cretab: CREATE /?(&is_temp_table&){ GLOBAL TEMPORARY /} TABLE &tab_name&
        ( /%{ &fld_name& &fld_desc& /-, /} ) &compression& &on_commit&

creind: &tpl:creindgen&
        &tpl:with_consumers&

crepky: &tpl:creindgen{ind_name=&pri_key&,unique=UNIQUE}&
        &tpl:with_consumers&

drppky: &tpl:drpindgen{ind_name=&tab_name&.&pri_key&}&
drpind: &tpl:drpindgen{ind_name=&tab_name&.&ind_name&}&

negcpr: ARFCSSTATE ARFCSDATA ARFCRSTATE TRFCQDATA TRFCQIN TRFCQOUT TRFCQSTATE QRFCTRACE QRFCLOG

irll: DDNTF FIELDS 8000
irll: DDNTF_CONV_UC FIELDS 8000
irll: DYNPLOAD DATA 8000
irll: DYNPSOURCE EXTENSIONS 4000
irll: DYNPSOURCE FIELDINFO 6000
irll: DYNPSOURCE LOGICINFO 6000
irll: REPOLOAD LDATA 10000
irll: REPOLOAD QDATA 6000
irll: REPOSRC DATA 16000
irll: REPOTEXT DATA 16000
irll: VBDATA VBDATA 16000

volatile: VBDATA
volatile: VBHDR
volatile: VBMOD
volatile: ARFCRSTATE
volatile: ARFCSDATA
volatile: ARFCSSTATE
volatile: QREFTID
volatile: TRFCQDATA
volatile: TRFCQIN
volatile: TRFCQINS
volatile: TRFCQSTATE
volatile: RSBATCHCTRL

#  #########  #
#             #
#  CRR stuff  #
#             #
#  #########  #

crr_upserthist_gtt:     [/1CRR/TBL/MERGE_ROWCOUNT]
crr_upserthist_gttf:    [MERGE_ROWCOUNT]

crrproc_name__SYB{mode}: [&crrproc_name0&_&mode&]

_crrproc{mode}: CREATE PROCEDURE [&crrproc_name0&_&mode&]
                                   ( @IV_WIN_START DECIMAL(15,0),
                                     @IV_WIN_END   DECIMAL(15,0),
                                     @IV_PID_LOWER INTEGER,
                                     @IV_PID_ACT   INTEGER)
                    AS BEGIN
                        DECLARE @LV_SEQ      NUMERIC(15)
                        DECLARE @LV_OP_LAST  VARCHAR(1)
                        DECLARE @LV_NROWS    BIGINT
                        /%{
                        DECLARE @CUR_&log_key_fld_name_alt0& &log_key_fld_fulltype& /}

                        SET @LV_NROWS = 0
                        DELETE FROM &tpl:crr_upserthist_gtt&;

                        DECLARE CC CURSOR FOR
                           SELECT /%{L.[&log_key_fld_name0&]/-, /}, L.[&tpl:crrfld_oplast&], L.[&tpl:crrfld_sequence&]
                             FROM &crrlog_tab_name& AS L
                  LEFT OUTER JOIN &crrloghist_tab_name& AS H
                               ON /%{H.&log_key_fld_name& = L.&log_key_fld_name& /-AND /}
                            WHERE L.[&tpl:crrfld_sequence&] >= @IV_WIN_START
                              AND L.[&tpl:crrfld_sequence&] <  @IV_WIN_END
                               #
                               # the FAST/SAFE decision building block #
                               AND &tpl:crr_decide_fastorsafe_oj_pid{mode=&mode&,
                                                                     repl=@IV_PID_LOWER
                                                                     }&
                                  &where_add[L]&

                        OPEN  CC
                        FETCH CC INTO /%{ @CUR_&log_key_fld_name_alt0& /-, /}, @LV_OP_LAST, @LV_SEQ
                        WHILE @@sqlstatus = 0
                        BEGIN
                             MERGE
                              INTO &crrloghist_tab_name& AS HH
                             USING ( SELECT /%{ @CUR_&log_key_fld_name_alt0& /-, /}, @LV_OP_LAST, @LV_SEQ ) AS LL (/%{&log_key_fld_name&/-, /}, [&tpl:crrfld_oplast&], [&tpl:crrfld_sequence&])
                                ON (/%{HH.&log_key_fld_name& = LL.&log_key_fld_name& /-AND /})

                             # The UPDATE branch
                             WHEN MATCHED THEN
                               UPDATE
                                  SET HH.[&tpl:crrfld_oplast&]      = LL.[&tpl:crrfld_oplast&],
                                      HH.[&tpl:crrfld_sequence&]    = LL.[&tpl:crrfld_sequence&],
                                      HH.[&tpl:crrfld_replicating&] = @IV_PID_ACT

                             # The INSERT branch
                             WHEN NOT MATCHED THEN
                               INSERT (/%{   &log_key_fld_name&, /}    [&tpl:crrfld_oplast&],    [&tpl:crrfld_sequence&], [&tpl:crrfld_replicating&])
                               VALUES (/%{LL.&log_key_fld_name&, /} LL.[&tpl:crrfld_oplast&], LL.[&tpl:crrfld_sequence&], @IV_PID_ACT)

                            SET @LV_NROWS = @LV_NROWS + 1
                            FETCH CC INTO /%{ @CUR_&log_key_fld_name_alt0& /-, /}, @LV_OP_LAST, @LV_SEQ
                        END
                        CLOSE CC

                        # Transfer the result via GGT
                        INSERT
                          INTO &tpl:crr_upserthist_gtt&
                               (&tpl:crr_upserthist_gttf&)
                        VALUES (@LV_NROWS);
                     END

crr_creproc:    &tpl:_crrproc{mode=FAST}& /;
                COMMIT /;
                &tpl:_crrproc{mode=SAFE}& /;
                COMMIT


crr_drpproc:    DROP PROCEDURE &tpl:crrproc_name__SYB{mode=FAST}& /;
                COMMIT /;
                DROP PROCEDURE &tpl:crrproc_name__SYB{mode=SAFE}& /;
                COMMIT

crr_upserthist__SYB{mode,type}:   BEGIN
                                       SELECT 0
                                         EXEC &tpl:crrproc_name__SYB{mode=&mode&}&
                                              @IV_WIN_START = ?,
                                              @IV_WIN_END   = ?,
                                              @IV_PID_LOWER = &tpl:crr_rangelower_ok{mode=&mode&,type=&type&}&,
                                              @IV_PID_ACT   = &tpl:crr_procnum_act{mode=&mode&}&
                                    END
                                    /* SYB MERGE LOG->LOGHIST w/ StoredProc for &tab_name&: &mode&/&type& */

crr_upsertcount__SYB:           SELECT &tpl:crr_upserthist_gttf&
                                  FROM &tpl:crr_upserthist_gtt&

crr_upserthist_fastconti:       &tpl:crr_upserthist__SYB{mode=FAST,type=CONTI}&
crr_upserthist_fastfinal:       &tpl:crr_upserthist__SYB{mode=FAST,type=FINAL}&
crr_upserthist_safeconti:       &tpl:crr_upserthist__SYB{mode=SAFE,type=CONTI}&
crr_upserthist_safefinal:       &tpl:crr_upserthist__SYB{mode=SAFE,type=FINAL}&

crr_upsertsqltype_fastconti:    OTHERS
crr_upsertsqltype_fastfinal:    OTHERS
crr_upsertsqltype_safeconti:    OTHERS
crr_upsertsqltype_safefinal:    OTHERS

crr_upsertcount_conti:          &tpl:crr_upsertcount__SYB&
crr_upsertcount_final:          &tpl:crr_upsertcount__SYB&




crr_filllogtab:             &tpl:crr_locklogtab&
                            /;
                            SELECT /%{&log_key_fld_name&, /} &tpl:crrfld_sequence&=IDENTITY(bigint)
                              INTO &crrlogtemp_tab_name&
                              FROM &tab_name&
     /?(&is_cluster_table&){ WHERE PAGENO = 0 &where_add& /}{ &where&  /}
                            /;
                            INSERT
                              INTO &crrlog_tab_name&
                                  (/%{&log_key_fld_name&, /}
                                   &tpl:crrfld_opfirst&, &tpl:crrfld_oplast&, &tpl:crrfld_sequence&
                                  )
                            SELECT /%{&log_key_fld_name&, /}
                                   &crr_op_first_value&, &crr_op_last_value&, &tpl:crrfld_sequence&
                              FROM &crrlogtemp_tab_name&
                            /;
                            DROP TABLE &crrlogtemp_tab_name&
