# $Id: //bc/lmt_023_REL/src/upg/R3ld/R3loadctl/DDLHDB_GEN.TPL#16 $ SAP

# include the generic db independent TPL:
#include DDLGEN.TPL
#include DDLHDB_CRR.TPL

crr_shdusr_name: SAPABAP1SHD

#  Ensure neutral format for geometry data in case of future changes in binary format!

seltab:         SELECT &select_hint& /%{ /@(&fld_ddtype&){ /:(GGM1) &fld_name&.ST_AsEWKB() /: &fld_name& /}/-, /}
                  FROM &tab_name&
                &where&

instab:         INSERT INTO &tab_name& &insert_partition_spec&
                       (/%{&fld_name&/-, /})
                VALUES (&tpl:insert_values&)

repltab:        REPLACE &tab_name& (/%{&fld_name&/-, /})
                   VALUES (&tpl:insert_values&) WITH PRIMARY KEY

insert_values:  /%{/@(&fld_ddtype&){ /:(GGM1) ST_GeomFromEWKB(&fld_marker&) /: &fld_marker& /}/-, /}

# ==============================================================================

cretab:             &tpl:cretab_mt&
drptab:             &tpl:drptab_mt&

crepky:             &tpl:crepky_mt&
drppky:             &tpl:drppky_mt&

creind:             &tpl:creind_mt&
drpind:             &tpl:drpind_mt&
creindfull:         &tpl:creindfull_mt&
drpindfull:         &tpl:drpindfull_mt&

cretabtmp:          &tpl:cretabtmp_mt&
drptabtmp:          &tpl:drptabtmp_mt&

crepkytmp:          &tpl:crepkytmp_mt&
drppkytmp:          &tpl:drppkytmp_mt&

creindtmp:          &tpl:creindtmp_mt&
drpindtmp:          &tpl:drpindtmp_mt&

merge:              &tpl:merge_mt&
unload:             &tpl:unload_mt&

crevie:             &tpl:crevie_mt&
drpvie:             &tpl:drpvie_mt&

# ==============================================================================
# =============================  multi tenancy  ================================
# ==============================================================================

#  we treat "t" identical to "rw" except for views
cretab_mt:          /@(&sharing_type&){
                    /:(ro)
                        &tpl:cretab_mtro&
                    /:(rw,t)
                        &tpl:cretab_mtrw_r& /;
                        &tpl:cretab_mtrw_w& /;
                        &tpl:cretab_mtrw_v&
                    /:(s)
                        &tpl:cretab_mts_r& /;
                        &tpl:cretab_mts_w& /;
                        &tpl:cretab_mts_v&
                    /:
                        &tpl:cretab_vl&
                    /}

drptab_mt:          /@(&sharing_type&){
                    /:(ro)
                        &tpl:drptab_mtro&
                    /:(rw,t)
                        &tpl:drptab_mtrw_v& /;
                        &tpl:drptab_mtrw_w& /;
                        &tpl:drptab_mtrw_r&
                    /:(s)
                        &tpl:drptab_mts_v& /;
                        &tpl:drptab_mts_w& /;
                        &tpl:drptab_mts_r&
                    /:
                        &tpl:drptab_vl&
                    /}

# ----------- Sharing type R - read-only tables --------------------
cretab_mtro:        CREATE VIEW &tab_name_standard&
                        AS SELECT /%{ &fld_name& /-, /}
                            FROM &sharepath&.&tab_name_mapped& WITH READ ONLY

drptab_mtro:        &tpl:drpvie_vl{view_name=&tab_name_standard&}&

# ----------- Sharing type W - read-write tables  ----------------------
# read-write table statements for read-part (r), write-part (w) and union view (u)
cretab_mtrw_r:      /?(&has_task_modifier_ext[r,rwu]&){
                        CREATE VIEW &tab_name_readonly& AS
                            SELECT /%{ &fld_name& /-, /}
                                FROM &sharepath&.&tab_name_mapped&
                    /}

drptab_mtrw_r:      /?(&has_task_modifier_ext[r,rwu]&){
                        &tpl:drpvie_vl{view_name=&tab_name_readonly&}&
                    /}

cretab_mtrw_w:      /?(&has_task_modifier_ext[w,rwu]&){
                        &tpl:cretab_vl{tab_name=&tab_name_writable&}&
                    /}

drptab_mtrw_w:      /?(&has_task_modifier_ext[w,rwu]&){
                        &tpl:drptab_vl{tab_name=&tab_name_writable&}&
                    /}

cretab_mtrw_v:      /?(&has_task_modifier_ext[u,rwu]&){
                        CREATE VIEW &tab_name_standard& AS
                           SELECT /%{ &fld_name& /-, /}
                             FROM &tab_name_readonly&
                           UNION ALL
                           SELECT /%{ &fld_name& /-, /}
                             FROM &tab_name_writable&
                             WITH READ ONLY
                    /}

drptab_mtrw_v:      /?(&has_task_modifier_ext[u,rwu]&){
                        &tpl:drpvie_vl{view_name=&tab_name_standard&}&
                    /}

# Checking collisions between "/R/table" and "/W/table" parts
chktab_mtrw:        SELECT /%{ TR.&key_fld_name& /-, /}
                       FROM &tab_name_readonly& TR, &tab_name_writable& TW
                           WHERE /%{ TR.&key_fld_name& = TW.&key_fld_name& /-AND /}

# --------------- Sharing type 'S' for tables - REPOSRC  --------------------------------
# create read-only part of REPOSRC (/R/REPOSRC) in tenant
cretab_mts_r:       /?(&has_task_modifier_ext[r,rwu]&){
                        CREATE VIEW &tab_name_readonly&
                          AS SELECT &reposrc_adm&."PROGNAME", &reposrc_adm&."R3STATE", "SQLX", "EDTX", "DBNA", "CLAS", "TYPE",
                              "OCCURS", "SUBC", "APPL", "SECU", "CNAM", "CDAT", "VERN", "LEVL", "RSTAT", "RMAND",
                              "RLOAD", &reposrc_adm&."UNAM", &reposrc_adm&."UDAT", &reposrc_adm&."UTIME", "DATALG", "VARCL",
                              "DBAPL", "FIXPT", "SSET", &reposrc_adm&."SDATE", &reposrc_adm&."STIME", &reposrc_adm&."IDATE",
                              &reposrc_adm&."ITIME", "LDBNAME", "UCCHECK", "MAXLINELN", "DATA"
                          FROM &reposrc_adm& INNER JOIN &sharepath&.&tab_name_mapped&
                            ON &tab_name_mapped&."PROGNAME" = &reposrc_adm&."PROGNAME"
                          WHERE &tab_name_mapped&."R3STATE" = 'A'
                            AND &reposrc_adm&."R3STATE" = 'A'
                    /}

drptab_mts_r:       /?(&has_task_modifier_ext[r,rwu]&){
                        &tpl:drpvie_vl{view_name=&tab_name_readonly&}&
                    /}

# create writable part of REPOSRC in tenant
cretab_mts_w:       /?(&has_task_modifier_ext[w,rwu]&){
                        &tpl:cretab_mtrw_w&
                    /}
drptab_mts_w:       /?(&has_task_modifier_ext[w,rwu]&){
                        &tpl:drptab_mtrw_w&
                    /}

# create view only part of REPOSRC in tenant
cretab_mts_v:       /?(&has_task_modifier_ext[u,rwu]&){
                        &tpl:cretab_mtrw_v&
                    /}

drptab_mts_v:       /?(&has_task_modifier_ext[u,rwu]&){
                        &tpl:drptab_mtrw_v&
                    /}

crepky_mt:          &tpl:crepky_vl&
drppky_mt:          &tpl:drppky_vl&

# --- Sharing type T for views (like PROGDIR)
crevie_mt:          /@(&sharing_type&){
                    /:(t)
                        &tpl:crevie_mtt_r& /;
                        &tpl:crevie_mtt_w& /;
                        &tpl:crevie_mtt_v&
                    /:
                        &tpl:crevie_vl&
                    /}

drpvie_mt:          /@(&sharing_type&){
                    /:(t)
                        &tpl:drpvie_mtt_v& /;
                        &tpl:drpvie_mtt_w& /;
                        &tpl:drpvie_mtt_r&
                    /:
                        &tpl:drpvie_vl&
                    /}

# Create read-only part view of sharing type T
crevie_mtt_r:       /?(&has_task_modifier_ext[r,rwu]&){
                        &tpl:crevie_vl{view_name=&view_name_readonly&,base_table=&base_table_readonly&}&
                    /}

drpvie_mtt_r:       /?(&has_task_modifier_ext[r,rwu]&){
                        &tpl:drpvie_vl{view_name=&view_name_readonly&}&
                    /}

# Create write-only part of sharing type T
crevie_mtt_w:       /?(&has_task_modifier_ext[w,rwu]&){
                        &tpl:crevie_vl{view_name=&view_name_writable&,base_table=&base_table_writable&}&
                    /}

drpvie_mtt_w:       /?(&has_task_modifier_ext[w,rwu]&){
                        &tpl:drpvie_vl{view_name=&view_name_writable&}&
                    /}

# Create main view of sharing type T
crevie_mtt_v:       /?(&has_task_modifier_ext[u,rwu]&){
                        &tpl:crevie_vl{view_name=&view_name_standard&,base_table=&base_table_standard&}&
                    /}

drpvie_mtt_v:       /?(&has_task_modifier_ext[u,rwu]&){
                        &tpl:drpvie_vl{view_name=&view_name_standard&}&
                    /}

creind_mt:          &tpl:creind_vl&
drpind_mt:          &tpl:drpind_vl&
creindfull_mt:      &tpl:creindfull_vl&
drpindfull_mt:      &tpl:drpindfull_vl&

cretabtmp_mt:       &tpl:cretabtmp_vl&
drptabtmp_mt:       &tpl:drptabtmp_vl&

crepkytmp_mt:       &tpl:crepkytmp_vl&
drppkytmp_mt:       &tpl:drppkytmp_vl&

creindtmp_mt:       &tpl:creindtmp_vl&
drpindtmp_mt:       &tpl:drpindtmp_vl&

merge_mt:           &tpl:merge_vl&
unload_mt:          &tpl:unload_vl&

# ==============================================================================
# ==============================  view layer   =================================
# ==============================================================================
cretab_vl:          /?(&is_view_layer&){
                        /?(&has_task_modifier_ext[t,tv]&){
                            &tpl:cretab_base{tab_name=&dbschema_vldata&.&tab_name_vldata&}& /;
                        /}
                        /?(&has_task_modifier_ext[v,tv]&){
                            CREATE PROJECTION VIEW &tab_name& AS
                                SELECT /%{ &fld_name& /-, /}
                                    FROM &dbschema_vldata&.&tab_name_vldata& /;
                        /}
                    /}{
                        &tpl:cretab_base&
                    /}

drptab_vl:          /?(&is_view_layer&){
                        /?(&has_task_modifier_ext[v,tv]&){
                            &tpl:drpvie_base{view_name=&tab_name&}& /;
                        /}
                        /?(&has_task_modifier_ext[t,tv]&){
                            &tpl:drptab_base{tab_name=&dbschema_vldata&.&tab_name_vldata&}& /;
                        /}
                    /}{
                        &tpl:drptab_base&
                    /}

# ----------------------------
crepky_vl:          /?(&is_view_layer&){
                        &tpl:crepky_base{tab_name=&dbschema_vldata&.&tab_name_vldata&,pri_key=&pri_key_vldata&}&
                    /}{
                        &tpl:crepky_base&
                    /}

drppky_vl:          /?(&is_view_layer&){
                        &tpl:drppky_base{tab_name=&dbschema_vldata&.&tab_name_vldata&,pri_key=&pri_key_vldata&}&
                    /}{
                        &tpl:drppky_base&
                    /}

# ----------------------------
creind_vl:          /?(&is_view_layer&){
                        &tpl:creind_base{tab_name=&dbschema_vldata&.&tab_name_vldata&,ind_name=&dbschema_vldata&.&ind_name_vldata&}&
                    /}{
                        &tpl:creind_base&
                    /}

drpind_vl:          /?(&is_view_layer&){
                        &tpl:drpind_base{tab_name=&dbschema_vldata&.&tab_name_vldata&,ind_name=&dbschema_vldata&.&ind_name_vldata&}&
                    /}{
                        &tpl:drpind_base&
                    /}

# ----------------------------
creindfull_vl:      /?(&is_view_layer&){
                        &tpl:creindfull_base{tab_name=&dbschema_vldata&.&tab_name_vldata&,ind_name=&dbschema_vldata&.&ind_name_vldata&}&
                    /}{
                        &tpl:creindfull_base&
                    /}

drpindfull_vl:      /?(&is_view_layer&){
                        &tpl:drpindfull_base{ind_name=&dbschema_vldata&.&ind_name_vldata&}&
                    /}{
                        &tpl:drpindfull_base&
                    /}

# ----------------------------
trcdat_vl:          /?(&is_view_layer&){
                        &tpl:trcdatgen{tab_name=&dbschema_vldata&.&tab_name_vldata&}&
                    /}{
                        &tpl:trcdatgen&
                    /}

# ----------------------------
merge_vl:           /?(&is_view_layer&){
                        &tpl:merge_base{tab_name=&dbschema_vldata&.&tab_name_vldata&}&
                    /}{
                        &tpl:merge_base&
                    /}

unload_vl:          /?(&is_view_layer&){
                        &tpl:unload_base{tab_name=&dbschema_vldata&.&tab_name_vldata&}&
                    /}{
                        &tpl:unload_base&
                    /}

#  GTT's are in view layer schema as "normal"
cretabtmp_vl:       &tpl:cretabtmp_base&
drptabtmp_vl:       &tpl:drptabtmp_base&

crepkytmp_vl:       &tpl:crepky_base&
drppkytmp_vl:       &tpl:drppky_base&

creindtmp_vl:       &tpl:creind_base&
drpindtmp_vl:       &tpl:drpind_base&

crevie_vl:          &tpl:crevie_base&
drpvie_vl:          &tpl:drpvie_base&

# ----------------------------
# existance check in view layer. No full if only 'v' modifier out of 'v' and 't' is given
chktabexists:       /?(&is_view_layer& and not &is_temp_table& and &has_task_modifier_ext[t,tv]&){
                        &tpl:chktabexistsgen{dbschema=&dbschema_vldata&,tab_name=&tab_name_vldata&}&
                    /}{
                        &tpl:chktabexistsgen&
                    /}

# ==============================================================================
# ============================  basic statements  ==============================
# ==============================================================================

# +++ tables  +++
cretab_base:        CREATE &tab_type& TABLE
                        &tab_name& ( /%{ &fld_name& &fld_desc& /-, /} )
                        /@(&load_unit&){ /:(COLUMN) COLUMN LOADABLE /:(PAGE) PAGE LOADABLE /: /}
                        &extclause[attributes]&
drptab_base:        &tpl:drptabgen&

crepky_base:        ALTER TABLE &tab_name&
                        ADD CONSTRAINT &pri_key&
                        PRIMARY KEY &inverted_hash& ( /%{ &key_fld_name& /-, /} )
drppky_base:        ALTER TABLE &tab_name&
                        DROP CONSTRAINT &pri_key&

creind_base:        CREATE &unique& INDEX &ind_name&
                        ON &tab_name& ( /%{ &fld_name& /-, /} )
drpind_base:        &tpl:drpindgen&

creindfull_base:    CREATE FULLTEXT INDEX &ind_name&
                        ON &tab_name& ( /%{ &fld_name& /-, /} )
                            &index_attributes&
drpindfull_base:    DROP FULLTEXT INDEX &ind_name&

#  Must use "ROW" instead of "&tab_type& since COLUMN temporary tables cannot have primary key
cretabtmp_base:     CREATE GLOBAL TEMPORARY ROW TABLE
                        &tab_name& (/%{&fld_name& &fld_desc& /-, /})
                        ON COMMIT DELETE ROWS
drptabtmp_base:     &tpl:drptab_base&

merge_base:         /?("&tab_type&" = "COLUMN"){
                        MERGE DELTA OF &tab_name&
                    /}

unload_base:        /?("&tab_type&" = "COLUMN"){
                        UNLOAD &tab_name&
                    /}

#  use "view_type" for Hana
crevie_base:        CREATE &view_type& VIEW &view_name& ( /%{ &fld_name& /-, /} )
                        AS &query&

drpvie_base:        &tpl:drpviegen&

# ==============================================================================
# ===============================  CRR stuff  ==================================
# ==============================================================================

ValidExternalClauses: attributes

# To ignore filter rules, uncomment this line
#IgnoreFilterRules: 1

# HDB MERGE INTO -> no "WHEN MATCHED AND" syntax
# HDB: https://help.sap.com/viewer/4fe29514fd584807ac9f2a04f6754767/2.0.02/en-US/3226201f95764a57810dd256c9524d56.html

crr_mergelog2hist_part{mode,type}: MERGE &tpl:_crr_hint4merge_hd&
                                     INTO &crrloghist_tab_name& HX
                                    USING (SELECT &tpl:_crr_hint4merge_sel&
                                                  /%{L.&log_key_fld_name&/-, /}, L."&tpl:crrfld_oplast&", L."&tpl:crrfld_sequence&"
                                             FROM &crrlog_tab_name& L
                                  LEFT OUTER JOIN &crrloghist_tab_name& H
                                               ON /%{H.&log_key_fld_name& = L.&log_key_fld_name& /-AND /}
                                            WHERE L."&tpl:crrfld_sequence&" >= ?
                                              AND L."&tpl:crrfld_sequence&" < ?
                                              #
                                              # the decision building block #
                                              AND &tpl:crr_decide_fastorsafe_oj{mode=&mode&,type=&type&}&
                                              #
                                              &where_add[L]&
                                          ) LX
                                       ON (/%{HX.&log_key_fld_name& = LX.&log_key_fld_name& /-AND /})

                                     # The UPDATE branch
                                     WHEN MATCHED THEN
                                   UPDATE
                                      SET HX."&tpl:crrfld_oplast&"      = LX."&tpl:crrfld_oplast&",
                                          HX."&tpl:crrfld_sequence&"    = LX."&tpl:crrfld_sequence&",
                                          HX."&tpl:crrfld_replicating&" = &tpl:crr_procnum_act{mode=&mode&}&

                                     # The INSERT branch
                                     WHEN NOT MATCHED THEN
                                   INSERT (/%{   &log_key_fld_name&, /}    "&tpl:crrfld_oplast&",    "&tpl:crrfld_sequence&", "&tpl:crrfld_replicating&")
                                   VALUES (/%{LX.&log_key_fld_name&, /} LX."&tpl:crrfld_oplast&", LX."&tpl:crrfld_sequence&",  &tpl:crr_procnum_act{mode=&mode&}&)
                                   /* HDB Partial MERGE LOG->LOGHIST for &tab_name&: &mode&/&type& */


crr_upserthist_fastconti: &tpl:crr_mergelog2hist_part{mode=FAST,type=CONTI}&
crr_upserthist_fastfinal: &tpl:crr_mergelog2hist_part{mode=FAST,type=FINAL}&
crr_upserthist_safeconti: &tpl:crr_mergelog2hist_part{mode=SAFE,type=CONTI}&
crr_upserthist_safefinal: &tpl:crr_mergelog2hist_part{mode=SAFE,type=FINAL}&

#  lockwait is only supported with 2.0.12
crr_trg_waitsec:    /?(&is_min_dbversion[2.0.12]&){ 60 /}{ 0 /}

#  ==========================  #
#  Indexes (Constraints only)  #
#  ==========================  #

crr_creindlog:      0(/%{&log_key_fld_name&/-, /})
                    U1(&tpl:crrfld_sequence&)

crr_creindloghist:  0(/%{ &log_key_fld_name& /-, /})
                    U1(&tpl:crrfld_sequence&)

# ==============================================================================
# ==============================================================================
