/*******************************************************************************
 Changes  for 4.6B
-----------------

no changes

List of Changes  for 4.6C
-----------------

pg01 - P. Goertz 02/08/00
 - Stored procedure sap_atomic_defaultbind is slightly modified.
 - Reading the SQL Server release is made Shiloh compatiple.

List of Changes for 6.10
-----------------

ae01 - A. Engelko 04/04/2001
 - Only MSSQL2000 is supported for 6.10
 - Startup parameter p is not needed any more
 - stored procedure xp_msver is now used to determine the version of MSSQL
 - new sap_atomic_defaultbinf from P. Goertz 

ae02 - A. Engelko 13/09/2001
 - check for hotfix 425946

List of Changes for 6.20
-----------------

ae01 - A. Engelko 08.03.2002
 - check for SP2 on MSSQL 8
ae02 - A. Engelko 03.06.2002
 - check existance of report RSMSS8DD by start release 31I 
   to be shure the transport SAPKVSS31I was imported
 - check for dictionary tables with columns of type char by start release 31I
 
 
List of Changes for 7.10
-----------------

ae01 - P. Sternberger 27.08.08
 - skip the old db-release checks since this is done with conf-files


********************************************************************************/
set nocount on
print 'SCRIPT MSSINCHK'
print '================='
go   

-- checks depending on the start release

declare @rel char(3) 

select @rel = VERSION from SVERS

if @rel in ('40B', '45B')   
begin
  if not exists (select * from sysobjects
		     where name = 'mss_varbin_conversion'
		     and id = object_id(user_name() + '.' + name, 'U') )
    print 'FATAL ERROR: Long Datatype Conversion not performed!'
end 
else if @rel = '31I'
begin

  if not exists (select * from D010S where PROG = 'RSMSS8DD')
  begin
    print 'FATAL ERROR: transport SAPKVSS31I not imported!'
    print 'You must import transport SAPKVSS31I located '
    print 'on the kernel cd in the directory TRANS\31I'
    print 'before starting the upgrade!' 
  end

  if exists( select b.name, a.name, d.name from syscolumns a
             join sysobjects b on a.id = b.id and a.xtype = 175 and b.type = 'U' 
             join DD03L c on b.name = c.TABNAME and c.POSITION = '0001'
             join systypes d on a.xtype = d.xtype )
  begin
    print 'FATAL ERROR: tables with char columns were found!'
    print 'Your system contains SAP tables with columns of type char.'
    print 'These must be converted prior to upgrade.'
    print 'Please, contact the SAP support (component BC-DB-MSS-UPG)'
    print 'and attach this log file to the message!'

    select b.name, a.name, d.name from syscolumns a
    join sysobjects b on a.id = b.id and a.xtype = 175 and b.type = 'U' 
    join DD03L c on b.name = c.TABNAME and c.POSITION = '0001'
    join systypes d on a.xtype = d.xtype
  end

end

-- all checks done

go

print 'Execution completed successfully'

set nocount off   
go
