/*******************************************************************************/ 
/*                                                                             */ 
/*                 4.6C MSS LONG COLUMNS SCRIPT                                */ 
/*-----------------------------------------------------------------------------*/ 
/*                                                                             */ 
/* To be executed at the beginning of phase NEWTAB_CRE for start release 3.x;  */ 
/* with the output of the script the file MSS.TAB is changed via mss_tc.exe.   */ 
/* For start release 3.x the long datatype conversion has to be carried out    */ 
/* after the upgrade. During the upgrade the old mppings are still active,     */ 
/* i.e., also new tables are created with the old mappings.                    */ 
/*                                                                             */ 
/*******************************************************************************/  
/********************************************************************************    
Created on 05/31/99 by Peter Goertz for the 4.6A upgrade.   
********************************************************************************/ 
/********************************************************************************

  List of Changes  for 4.6B
 ----------------- 
   pg01 - P. Goertz 11/08/99
              - Accessing the 4.6B shadow tables 


  List of Changes  for 4.6C
 ----------------- 
   pg02 - P. Goertz 02/08/00
              - Accessing the 4.6C shadow tables


No changes for 6.10 ( A. Engelko )

********************************************************************************/

  set nocount on



print '  ' 
print '  ' 
print ' SCRIPT MSSLCOLS' 
print '=================' 
print '  ' 
print '  '
go    

-- RAW in transp. tables (max_length(RAW) = 255)  
select l2.TABNAME, l3.FIELDNAME, 'varbinary', 'binary'   from DD02L___4G l2, DD03L___4G l3     
where l2.TABCLASS = 'TRANSP'
and l2.TABNAME = l3.TABNAME
and l3.DATATYPE = 'RAW'
order by l2.TABNAME

-- RAW in phys. pools and clusters 
-- (max_length(RAW) = 4K in pools, max_length(RAW) = 3800 in clusters) 
select SQLTAB, FIELDNAME, 'varbinary', 'binary'   from DD16S___4G     
where DATATYPE = 'RAW'
and convert(int, LENG) < 256     
order by SQLTAB

select SQLTAB, FIELDNAME, '[varbinary (' + LENG + ')]', 'image'   from DD16S___4G     
where DATATYPE = 'RAW'
and convert(int, LENG) > 255     
order by SQLTAB    

-- LRAW, only in transp. tables (min_length(LRAW) = 256)  
select l2.TABNAME, l3.FIELDNAME, '[varbinary (' + l3.LENG + ')]', 'image'   from DD02L___4G l2, DD03L___4G l3     
where l2.TABCLASS = 'TRANSP'
and l2.TABNAME = l3.TABNAME
and l3.DATATYPE = 'LRAW'
order by l2.TABNAME


-- LCHR, only in transp. tables (min_length(LCHR) = 256)  
select l2.TABNAME, l3.FIELDNAME, '[varchar (' + l3.LENG + ')]', 'text'   from DD02L___4G l2, DD03L___4G l3     
where l2.TABCLASS = 'TRANSP'
and l2.TABNAME = l3.TABNAME
and l3.DATATYPE = 'LCHR'
order by l2.TABNAME 


print ' '
print ' '
print 'Execution completed successfully'
go


set nocount off
go
