/*******************************************************************************/
/*                                                                             */
/*                  6.20 MSS PRE-UPGRADE SCRIPT                                */
/*                                                                             */
/*-----------------------------------------------------------------------------*/
/*                                                                             */
/*  This script has to be run in phase DBCHK at the beginning of the upgrade   */
/*  in the R/3 database.                                                       */
/*                                                                             */
/*******************************************************************************/

/********************************************************************************

   Created on 06/08/98 by Peter Goertz for the 4.0B FCS upgrade out of the 
   3.X pre-upgrade script.

********************************************************************************/

/********************************************************************************

  List of Changes  for the 4.0B/4.5A final version
 -----------------

   C. Woelfle 08/25/98
       - Set AllowPageLock to false for D010S, D010SINF, D010L, D010LINF,
         because of deadlocks in phase PCON; on the recommendation of 
         Juergen Thomas (Microsoft).
       - Deleted performing update statistics on SQL Server system tables
         for 4.5A, caused problems on Build 549.04.
     
   P. Goertz 10/26/98
       - Set AllowPageLock to false for ATAB; long VARDATA field (RAW(452)
         in DD, image on DB) caused deadlocks during phase PCON.
       - Deleted performing update statistics on SQL Server system tables
         for 4.0B, too.
         Some system tables are only virtual systems tables on which
         statistics can not be created (since Build 549.04).
         Because of automatic update statistics this is also not necessary 
         for "real" system tables.
       - Deleted setting permissions. No longer necessary to set special
         grants, sapr3 is now member of the sysadmin group.


  List of Changes  for 4.5B 
 -----------------
 
   P. Goertz 02/15/99
       - Set AllowPageLock to false for STXH and STXL.

   P. Goertz 03/11/99
       - Set AllowPageLock to false for CROSS. Deadlocks on CROSS
         occured during a tp put (BSE).

   P. Goertz 04/14/99
       - Added deleting from SMODILOG for release 4.5A.
         Because of a change in the correction workbench objects that
         were imported after a 4.5A installation would else be listed 
         in SPAU.


  List of Changes  for 4.6A 
 -----------------

   P. Goertz 05/31/99
       - Took out deleting from SMODILOG, was only necessary for release 
         4.5A which is no start release for the 4.6A upgrade.


  List of Changes  for 4.6B
 -----------------

   no changes


  List of Changes  for 4.6C
 -----------------

   no changes


  List of Changes  for 4.6D
 -----------------

   no changes

  List of Changes  for 6.10
 -----------------

   no changes

  List of Changes  for 6.20
 -----------------

   A. Engelko 06.02.2002
       - Some tables names were changed with 6.10 


********************************************************************************/


set nocount on
go



print '  '
print '  '
print ' SCRIPT MSSPREUP'
print '================='
print '  '
print '  '
go



declare @vers varchar(1)
select @vers = VERSION from SVERS

if @vers < '6'
begin 
  exec sp_indexoption 'D010S', 'AllowPageLocks', 'False'    
  exec sp_indexoption 'D010SINF', 'AllowPageLocks', 'False' 
  exec sp_indexoption 'D010L', 'AllowPageLocks', 'False'    
  exec sp_indexoption 'D010LINF', 'AllowPageLocks', 'False' 
end
else begin
  exec sp_indexoption 'REPOLOAD', 'AllowPageLocks', 'False'    
  exec sp_indexoption 'REPOSRC', 'AllowPageLocks', 'False' 
end
go

exec sp_indexoption 'ATAB', 'AllowPageLocks', 'False' 
exec sp_indexoption 'STXH', 'AllowPageLocks', 'False' 
exec sp_indexoption 'STXL', 'AllowPageLocks', 'False' 
exec sp_indexoption 'CROSS', 'AllowPageLocks', 'False' 
go

print 'Execution completed successfully'

set nocount off
go


