/*******************************************************************************/
/*                                                                             */
/*                 6.20 MSS POST-UPGRADE SCRIPT                                */
/*		                                                               */
/*-----------------------------------------------------------------------------*/
/*                                                                             */
/* This script must be executed at the end of the upgrade in the R/3 database. */
/*                                                                             */
/*******************************************************************************/

/*******************************************************************************

  Created on 07/19/98 by Peter Goertz for the 4.0B FCS upgrade for clearing up 
  table DBDIFF and dropping some DB objects no longer necessary on 
  SQL Server 7.0.

********************************************************************************/

/********************************************************************************

  List of Changes  for the 4.0B/4.5A final version
 -----------------

   C. Woelfle 08/25/98
       - Set AllowPageLock to true for D010S, D010SINF, D010L, D010LINF,
         AllowPageLock is set to false in the pre-upgrade script.

   P. Goertz 10/26/98
       - Set AllowPageLock to true for ATAB.
         AllowPageLock is set to false in the pre-upgrade script.
               

  List of Changes  for 4.5B
 -----------------
 
   P. Goertz 02/16/99
       - Dropped clearing up DBDIFF, is included in MSSPROCS.
       - Set AllowPageLock to true for STXH, STXL.
         AllowPageLock is set to false in the pre-upgrade script.
       - Added execution of MSSPROCS entries for SQL Server 7.0.

   P. Goertz 03/11/98
       - Set AllowPageLock to true for CROSS.
         AllowPageLock is set to false in the pre-upgrade script.


  List of Changes  for 4.6A
 -----------------
 
   P. Goertz 05/31/99
       - Took out execution of MSSPROCS, takes now place in phase
         PORT_IM2 via script MSSPROCS.SQL.
       - Added clearing up DBDIFF; clearing up DBDIFF in phase 
         PORT_IM2 out of MSSPROCS.SQL is to early.

   P. Goertz 06/22/99
       - Added droppping of stored procedures Y... and SAP... which are
         corrupted in the sense that at least on of the objects they use
         (column depid in sysdepends) no longer exists or was dropped
         and recreated and so got a new id.


  List of Changes  for 4.6B
 -----------------
 
   no changes


  List of Changes  for 4.6C
 -----------------
 
   P. Goertz 02/10/00
       - Took out the DBDIFF step as it's no longer necessary; DBDIFF is
         now maintained in the official development system.


  List of Changes  for 4.6D
 -----------------
 
   no changes

  List of Changes  for 6.10
 -----------------
 
   no changes

  List of Changes  for 6.20
 -----------------
 
   A. Engelko 12.02.2002
	 - Added tables REPOLOAD & REPOSRC.


********************************************************************************/



set nocount on
go



print ' '
print ' '
print ' SCRIPT MSSPSTUP'
print '================='
print ' '
print ' '
go



-- For some tables AllowPageLocks must be set to true, was set to false in the
-- pre-upgrade script.

print 'Setting AllowPageLocks to True'
print '------------------------------'
print '  '
go

print 'REPOLOAD'
go
sp_indexoption 'REPOLOAD', 'AllowPageLocks', 'TRUE'    
print '  '
go

print 'REPOSRC'
go
sp_indexoption 'REPOSRC', 'AllowPageLocks', 'TRUE'    
print '  '
go

print 'ATAB'
go
sp_indexoption 'ATAB', 'AllowPageLocks', 'TRUE'    
print '  '
go

print 'STXH'
go
sp_indexoption 'STXH', 'AllowPageLocks', 'TRUE'    
print '  '
go

print 'STXL'
go
sp_indexoption 'STXL', 'AllowPageLocks', 'TRUE'    
print '  '
go

print 'CROSS'
go
sp_indexoption 'CROSS', 'AllowPageLocks', 'TRUE'    
print '  '
go



-- dropping corrupted procedures

print ' '
print ' '
print ' '
print 'Dropping corrupted procedures'
print '-----------------------------'
print ' '

declare @proc_name sysname
declare @cmd varchar(256)

declare corrupt_procs cursor
  for select distinct so.name 
        from sysdepends sd, sysobjects so
          where (so.name like 'Y%' or
                 so.name like 'SAP%')
            and so.xtype = 'P'
            and so.id = sd.id
            and not exists (select name from sysobjects where id = sd.depid)
          order by so.name

open corrupt_procs
fetch next from corrupt_procs 
  into @proc_name
while (@@fetch_status <> -1)
  begin
    if (@@fetch_status <> -2)
      begin
        select @cmd = 'drop proc ' + @proc_name
        print @cmd
        exec( @cmd )
      end
    fetch next from corrupt_procs
      into @proc_name
  end
close corrupt_procs
deallocate corrupt_procs

print ' '
print 'Corrupted procedures dropped'
go

set nocount off
go

print ' '
print ' '
print 'Execution completed successfully'
go
