/*******************************************************************************/
/*                                                                             */
/*                  6.10 MSS SPACE SCRIPT                                      */
/*-----------------------------------------------------------------------------*/
/*                                                                             */
/*  This script calculates the available space in the R/3 database as well as  */
/*  the available space on those drives which hold data with autogrowth on if  */
/*  1 GB is reserved for the transaction log.                                  */
/*                                                                             */
/*******************************************************************************/

/********************************************************************************

  Created by Peter Goertz on 02/15/00 for the 4.6C upgrade, it combines the
  former scripts MSSDBSPC.SQL and MSSAVAIL.SQL. The former scripts MSSSPACE.SQL
  is now called MSSUSAGE.SQL

  Changed by Andrey Engelko on 13.03.2001 for 6.10. 
  The script from 4.6D is now used.

********************************************************************************/



set nocount on
go



print '  '
print '  '
print ' SCRIPT MSSSPACE'
print '================='
print '  '
print '  '
go



-- calculating the space available in the R/3 database


declare @cmd varchar(255)


-- Get the PageSize in KB

declare @PageSize int
select @PageSize = low/1024 from master..spt_values where type = 'E' AND number = 1 


-- Get information about extents

create table #filestats 
               (f_id int, 
                f_group int, 
                total_ex int, 
                used_ex int,
                f_lname sysname,
                f_pname sysname)
insert into #filestats
  exec( 'dbcc showfilestats with no_infomsgs' )


-- Get the used space in number of extents

declare @UsedSpace decimal(15)
select @UsedSpace = sum(used_ex) from #filestats


-- Get the total space in number of extents

declare @TotalSpace decimal(15)
select @TotalSpace = sum(total_ex) from #filestats


drop table #filestats


-- get the FreeSpace in MB 

declare @FreeSpace decimal(15)
select @FreeSpace = (@TotalSpace - @UsedSpace) / 1024 * 8 * @PageSize

select @cmd = 'AVAILABLE DB SPACE (MB) =' + convert(varchar(256),@FreeSpace)
print @cmd
print ' '


go



-- calculating the disk space available for files with autogrowth on
-- if 1GB is reserved for the transaction log

-- local variables

declare @cmd varchar(256)
declare @drive char(1)
declare @drive_freespace int
declare @drive_sum int
declare @free_space int
declare @free_space_log int
declare @free_space_no_log int
declare @growth int
declare @log_size int
declare @max_size int
declare @root_lower char(4)
declare @root_upper char(4)
declare @size int
declare @sum_drive_freespace int
declare @sum_drive_sum int


-- temporary tables

create table #drives_sys
               (drive char(1))

create table #drives_xp
               (drive char(1), 
                drive_freespace int)

create table #free_space
               (drive char(1), 
                drive_sum int, 
                drive_freespace int,
                log char(1))


-- searching for drives on which datafiles are located,
-- estimating freespace of these drives

insert into #drives_sys
    select substring(filename,1,1) from sysfiles where status & 0x40 = 0

insert into #drives_xp exec master..xp_fixeddrives

delete from #drives_xp
  where upper(drive) not in (select * from #drives_sys)
    and lower(drive) not in (select * from #drives_sys)

delete from #drives_sys


-- calculating for every drive on which datafiles are
-- located the size the files can grow

declare calc_sum cursor 
for select drive, drive_freespace from #drives_xp

open calc_sum
fetch next from calc_sum into @drive, @drive_freespace
while (@@fetch_status <> -1)
begin
  if (@@fetch_status <> -2)
    begin

      select @root_upper = upper(@drive) + ':\%'
      select @root_lower = lower(@drive) + ':\%' 

      select @drive_sum = 0

      declare calc_drive_sum cursor 
      for select size, maxsize, growth from sysfiles
        where ( filename like @root_upper or
                filename like @root_lower )
          and status & 0x40 = 0 

      open calc_drive_sum
      fetch next from calc_drive_sum into @size, @max_size, @growth
      while (@@fetch_status <> -1)
      begin
        if (@@fetch_status <> -2)
          if (@max_size = -1 and @growth >0)
            select @drive_sum = @drive_sum + @drive_freespace
          else if (@max_size > 0 and @growth >0)
            select @drive_sum = @drive_sum + 
                                (@max_size - @size) / 1024 * 8
        fetch next from calc_drive_sum into @size, @max_size, @growth
      end
      close calc_drive_sum  
      deallocate calc_drive_sum

      if @drive_sum >= @drive_freespace
        insert into #free_space 
          values(@drive, @drive_freespace, @drive_freespace, 'N')
      else
        insert into #free_space 
          values(@drive, @drive_sum, @drive_freespace, 'N')
    end
  fetch next from calc_sum into @drive, @drive_freespace
end
close calc_sum
deallocate calc_sum

drop table #drives_xp


-- determinig on which drives containing datafiles are 
-- also logfiles located

insert into #drives_sys
  select substring(filename,1,1) from sysfiles where status & 0x40 = 64

declare log_on_drive cursor
  for select drive from #drives_sys

open log_on_drive
fetch next from log_on_drive into @drive
while (@@fetch_status <> -1)
begin 
  if (@@fetch_status <> -2)
    update #free_space
      set log = 'Y' where 
        drive in (upper(@drive), lower(@drive))
  fetch next from log_on_drive into @drive
end
close log_on_drive
deallocate log_on_drive

drop table #drives_sys


-- calculating the size datafiles can grow if 1 GB 
-- if reserved for the transaction log (not recommended
-- that logfiles and datafiles are located on the same drive)

select @log_size =
  (select sum(size)/1024*8 from sysfiles 
     where status & 0x40 = 64)

if exists( select * from #free_space where log = 'Y')
  if @log_size < 1024
    begin
      select @sum_drive_sum = (select sum(drive_sum) 
        from #free_space where log = 'Y')
      select @sum_drive_freespace = (select sum(drive_freespace)
        from #free_space where log = 'Y')
      if @sum_drive_freespace - @sum_drive_sum < 1024 - @log_size
        select @free_space_log = @sum_drive_freespace -
                                 (1024 - @log_size)
      else
        select @free_space_log = @sum_drive_sum
    end
  else 
    select @free_space_log =
      (select sum(drive_sum) from #free_space
         where log = 'Y')
else
  select @free_space_log = 0

if exists( select * from #free_space where log = 'N')
  select @free_space_no_log =
    (select sum(drive_sum) from #free_space
       where log = 'N')
else 
  select @free_space_no_log = 0

if @free_space_log < 0
  select @free_space = @free_space_no_log
else
  select @free_space = @free_space_log + @free_space_no_log

drop table #free_space

select @cmd = 'AVAILABLE DISK SPACE (MB) =' + convert(varchar(256),@free_space)
print @cmd
print ' '


go



set nocount off
go



print ' '
print ' '
print 'Execution completed successfully'
go

