/*******************************************************************************
-- script MSSUPGSPS
-- Contains upgrade specific stored procedures and common stored procs needed in upgrade.
-- Executed in prepare.

-- Version 6.20 (created on 08.03.2002 by A. Engelko)


List of Changes for 7.10
-----------------

ae01 - P. Sternberger 27.08.08
 - SP sap_upg_getreleaseredefined - use a more genaral way of parsing @@version - the old one
 	 brought an error when parsing "Microsoft SQL Server 2008 (RTM) - 10.0.1600.22 (X64)" since it
 	 sought for ' (' as the end of the version-string

********************************************************************************/


/***********************************************************************************************/
/* sap_drop_sapr3                                                                              */
/***********************************************************************************************/

if exists( select * from sysobjects where name = 'sap_drop_sapr3' and id = object_id(user_name() + '.' + name, 'P') )
  drop proc sap_drop_sapr3
go

create proc sap_drop_sapr3 @ntuser sysname
as

BEGIN
set nocount on

declare @dbname sysname
declare @loginname sysname
declare @cmd varchar(256)

print ' Stored procedure sap_drop_sapr3'
print '================================='

-- checking the existence of sapr3

if not exists( select * from master..syslogins where loginname = 'sapr3' )
begin
  print 'Msg: Login sapr3 does not exist!'
  return
end

-- checking the default database of sapr3

if (select dbname from master..syslogins where loginname = 'sapr3') <> db_name()
begin
  print 'Msg: ' + db_name() + ' is not the default database of login sapr3!'
  return
end

-- reassigning jobs with owner sapr3

select @loginname = loginname from master..syslogins where upper(loginname) = upper(@ntuser)

select @cmd = 'msdb..sp_manage_jobs_by_login ''REASSIGN'', ''sapr3'', ''' + @loginname + ''''
exec( @cmd)

-- revoking database access of sapr3

create table #all_dbs (name sysname)
insert into #all_dbs select name from master..sysdatabases

declare get_all_dbs cursor for select name from #all_dbs
open get_all_dbs
fetch next from get_all_dbs into @dbname
while (@@fetch_status <> -1)
  begin
    if (@@fetch_status <> -2)
      begin
        select @cmd = 'if not exists( select * from ' + @dbname + 
                      '..sysusers where name = ''sapr3'' )' +
                      ' delete from #all_dbs where name = ''' + @dbname + ''''
        exec( @cmd ) 
      end
    fetch next from get_all_dbs into @dbname
  end
close get_all_dbs
deallocate get_all_dbs

declare revoke_dbaccess cursor for select name from #all_dbs
open revoke_dbaccess
fetch next from revoke_dbaccess into @dbname
while (@@fetch_status <> -1)
  begin
    if (@@fetch_status <> -2)
      begin
        select @cmd = @dbname + '..sp_revokedbaccess ''sapr3'''
        exec( @cmd )        
      end
    fetch next from revoke_dbaccess into @dbname
  end
close revoke_dbaccess
deallocate revoke_dbaccess

delete from #all_dbs

-- dropping aliases of sapr3

insert into #all_dbs select name from master..sysdatabases

declare get_all_dbs cursor for select name from #all_dbs
open get_all_dbs
fetch next from get_all_dbs into @dbname
while (@@fetch_status <> -1)
  begin
    if (@@fetch_status <> -2)
      begin
        select @cmd = 'if not exists( select * from ' + @dbname + 
                      '..sysusers where sid = suser_sid(''sapr3'') )' +
                        ' delete from #all_dbs where name = ''' + @dbname + ''''
        exec( @cmd ) 
      end
    fetch next from get_all_dbs into @dbname
  end
close get_all_dbs
deallocate get_all_dbs

declare drop_aliases cursor for select name from #all_dbs
open drop_aliases
fetch next from drop_aliases into @dbname
while (@@fetch_status <> -1)
  begin
    if (@@fetch_status <> -2)
      begin
        select @cmd = @dbname + '..sp_dropalias ''sapr3'''
        exec( @cmd )        
      end
    fetch next from drop_aliases into @dbname
  end
close drop_aliases
deallocate drop_aliases

drop table #all_dbs

-- dropping sapr3

select @cmd = 'master..sp_droplogin ''sapr3'''
exec( @cmd )

print 'Execution completed successfully'
set nocount off
END
go

/***********************************************************************************************/
/* sap_upg_getrelease                                                                          */
/***********************************************************************************************/
if (exists(select name from sysobjects where name = 'sap_upg_getrelease' and id = object_id(user_name() + '.' + name, 'P') ))
  drop procedure sap_upg_getrelease
go

-- procedure 'sap_upg_getrelease' will be created in via script MSSUPGGETREL.SQL...