<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" omit-xml-declaration="yes" />

  <xsl:template match="/">
    <results>
      <xsl:variable name="error">
        <xsl:value-of select="0"/>

        <xsl:for-each select="//reject|//accept">
          <xsl:variable name="num_attribs"><xsl:value-of select="count(@*)"/></xsl:variable>
          <xsl:if test="$num_attribs = 0">
            <xsl:value-of select="1"/>
          </xsl:if>
        </xsl:for-each>
      </xsl:variable>

      <xsl:choose>
        <xsl:when test="$error > 0">
          <assert checking="reject/accept" result="error" />
        </xsl:when>
        <xsl:otherwise>
          <assert checking="reject/accept" result="success" />
        </xsl:otherwise>
      </xsl:choose>

    </results>
  </xsl:template>
</xsl:stylesheet>

