<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" omit-xml-declaration="yes" />

  <xsl:template match="/">
    <results>
      <xsl:variable name="error">
        <xsl:value-of select="0"/>

        <xsl:for-each select="//tool">
          <xsl:variable name="tool_name"><xsl:value-of select="@name"/></xsl:variable>
          <xsl:variable name="useoutput"><xsl:value-of select="useoutput/@tool"/></xsl:variable>
          <xsl:if test="$tool_name = $useoutput">
            <xsl:value-of select="1"/>
          </xsl:if>
        </xsl:for-each>
      </xsl:variable>

      <xsl:choose>
        <xsl:when test="$error > 0">
          <assert checking="useoutput-selfref" result="error" />
        </xsl:when>
        <xsl:otherwise>
          <assert checking="useoutput-selfref" result="success" />
        </xsl:otherwise>
      </xsl:choose>

    </results>
  </xsl:template>
</xsl:stylesheet>

