#  *********************************************************************
# ***********************************************************************
# ****                                                               ****
# ***                                                                 ***
# ***           SAP DB RDBMS Environment (R/3 >= 4.6C)                ***
# ***                                                                 ***
# ***           don't change !!                                       ***
# ***                                                                 ***
# ***                                                                 ***
# ***                                                                 ***
# ***********************************************************************
#  *********************************************************************
#


setenv dbms_type ADA

if ( -f /etc/opt/sdb) then
  set indepPath=`awk -F= '/IndepPrograms/ {print $2; exit 0}' /etc/opt/sdb`
else
  echo "MaxDB Registry file does not exist. Can't set MaxDB Environment"
  exit
endif

set global_version=`$indepPath/bin/dbmcli -s dbm_version VERSION | awk -F. '/7\.[0-9]/ {printf "%d%d",$1,$2}'`
set instPath=""

foreach d ( $indepPath/bin )
  set i=0
  foreach p ( $path )
    if ( "$p" == "$d" ) then
      set i=1
      break
    endif
  end
  if ( $i == 0 ) then
    set path = ( $d $path )
  endif
end

if ( $global_version < 78 ) then 
  if ( -d $indepPath/lib/lib64 ) then
    set libPath=$indepPath/lib/lib64
  else
    set libPath=$indepPath/lib
  endif
else
  if ( $?SAPSYSTEMNAME ) then
    foreach item ( `$indepPath/bin/dbmcli -s inst_enum | awk '/\/+/ {print $2}'` )
      if ( $instPath == "" ) then
        set isolated=`$indepPath/bin/dbmcli -s inst_enum $item | awk '/ISOLATED/ {print $3}'`
        if ( $isolated == "YES" ) then
          set installation=`$indepPath/bin/dbmcli -s inst_enum $item | awk '/Name/ {print $3}'`
          if ( $installation == "CL_$SAPSYSTEMNAME" ) then
            set instPath=`$indepPath/bin/dbmcli -s inst_enum $item | awk '/INSTROOT/ {print $3}'`
          endif
        endif
      endif
    end
  else
    set version=`$indepPath/bin/dbmcli -U c dbm_version VERSION | awk -F. '/7\.[0-9]/ {printf "%d%d",$1,$2}'`
    if ( $version >= 78 ) then
      set instPath=`$indepPath/bin/dbmcli -U c dbm_version INSTROOT | awk '/^\/+/ {print $1}'`
    endif
  endif
  if ( $instPath == "" ) then
    if ( -d $indepPath/lib/lib64 ) then
      set libPath=$indepPath/lib/lib64
    else
      set libPath=$indepPath/lib
    endif
  else
    foreach d ( $instPath/bin )
      set i=0
      foreach p ( $path )
          if ( "$p" == "$d" ) then
              set i=1
              break
          endif
      end
      if ( $i == 0 ) then
          set path = ( $d $path )
      endif
    end
    if ( -d $instPath/lib/lib64 ) then
      set libPath=$instPath/lib/lib64
    else
      set libPath=$instPath/lib
    endif
  endif
endif

switch (`uname`)
    case HP*:
        if ( ! $?SHLIB_PATH ) then
            setenv SHLIB_PATH $libPath
        else
            foreach d ( $libPath )
                set i=0
                foreach p ( `echo $SHLIB_PATH | sed 's/:/ /g'` )
                    if ( "$p" == "$d" ) then
                        set i=1
                        break
                    endif
                end
                if ( $i == 0 ) then
                    setenv SHLIB_PATH ${SHLIB_PATH}:$d
                endif
            end
        endif
        breaksw
    case AIX*:
        if ( ! $?LIBPATH ) then
            setenv LIBPATH $libPath
        else
            foreach d ( $libPath )
                set i=0
                foreach p ( `echo $LIBPATH | sed 's/:/ /g'` )
                    if ( "$p" == "$d" ) then
                        set i=1
                        break
                    endif
                end
                if ( $i == 0 ) then
                    setenv LIBPATH ${LIBPATH}:$d
                endif
            end
        endif
        breaksw
    default:
        if ( ! $?LD_LIBRARY_PATH ) then
            setenv LD_LIBRARY_PATH $libPath
        else
            foreach d ( $libPath )
                set i=0
                foreach p ( `echo $LD_LIBRARY_PATH | sed 's/:/ /g'` )
                    if ( "$p" == "$d" ) then
                        set i=1
                        break
                    endif
                end
                if ( $i == 0 ) then
                    setenv LD_LIBRARY_PATH ${LD_LIBRARY_PATH}:$d
                endif
            end
        endif
        breaksw
endsw

if ( ! $?SAPSYSTEMNAME ) then
    switch (`uname`)
        case Sun*:
            set prompt="`hostname`:`whoami` \!% "
            breaksw
        case SIN*:
        case Reliant*:
            set prompt="`/usr/ucb/hostname`:`/usr/ucb/whoami` \!% "
            breaksw
        default:
            set prompt="`hostname`:$LOGNAME \!> "
            breaksw
    endsw
endif
