#  *********************************************************************
# ***********************************************************************
# ****                                                               ****
# ***                                                                 ***
# ***           SAP DB RDBMS Environment (R/3 >= 4.6C)                ***
# ***                                                                 ***
# ***           don't change !!                                       ***
# ***                                                                 ***
# ***                                                                 ***
# ***                                                                 ***
# ***********************************************************************
#  *********************************************************************
#

dbms_type=ADA; export dbms_type

if [ -f /etc/opt/sdb ]; then
  indepPath=`awk -F= '/IndepPrograms/ {print $2; exit 0}' /etc/opt/sdb 2>/dev/null`
else 
  echo "MaxDB Registry file does not exist. Can't set MaxDB Environment"
  return
fi

global_version=`$indepPath/bin/dbmcli -s dbm_version VERSION | awk -F. '/7\.[0-9]/ {printf "%d%d",$1,$2}'`
instPath=""

for d in ${indepPath}/bin; do
    i=0
    for p in `echo $PATH | sed 's/:/ /g'`; do
        if [ "$p" = "$d" ]; then
            i=1
            break
        fi
    done
    if [ $i -eq 0 ]; then
        PATH=${d}:${PATH}; export PATH
    fi
done

if [ $global_version -lt 78 ]; then
  if [ -d "${indepPath}/lib/lib64" ]; then
    libPath=${indepPath}/lib/lib64
  else
    libPath=${indepPath}/lib
  fi
else
  if [ $?SAPSYSTEMNAME ]; then
    for item in `$indepPath/bin/dbmcli -s inst_enum | awk '/\/+/ {print $2}'`; do
      if [ "$instPath" = "" ]; then
        isolated=`$indepPath/bin/dbmcli -s inst_enum $item | awk '/ISOLATED/ {print $3}'`
        if [ "$isolated" = "YES" ]; then
          installation=`$indepPath/bin/dbmcli -s inst_enum $item | awk '/Name/ {print $3}'`
          if [ "$installation" = "CL_$SAPSYSTEMNAME" ]; then
            instPath=`$indepPath/bin/dbmcli -s inst_enum $item | awk '/INSTROOT/ {print $3}'`
          fi
        fi
      fi
    done
  else
    version=`$indepPath/bin/dbmcli -U c dbm_version VERSION | awk -F. '/7\.[0-9]/ {printf "%d%d",$1,$2}'`
    if [ $version -ge 78 ]; then
      instPath=`$indepPath/bin/dbmcli -U c dbm_version INSTROOT | awk '/^\/+/ {print $1}'`
    fi
  fi
  if [ "$instPath" = "" ]; then
    if [ -d "${indepPath}/lib/lib64" ]; then
      libPath=${indepPath}/lib/lib64
    else
      libPath=${indepPath}/lib
    fi
  else
    for d in ${instPath}/bin; do
      i=0
      for p in `echo $PATH | sed 's/:/ /g'`; do
          if [ "$p" = "$d" ]; then
              i=1
              break
          fi
      done
      if [ $i -eq 0 ]; then
          PATH=${d}:${PATH}; export PATH
      fi
    done
    if [ -d ${instPath}/lib/lib64 ]; then
      libPath=${instPath}/lib/lib64
    else
      libPath=${instPath}/lib
    fi
  fi
fi

case `uname` in
    HP*)
        if [ -z "$SHLIB_PATH" ]; then
            SHLIB_PATH=${libPath} 
        else
            for d in ${libPath}; do
                i=0
                for p in `echo $SHLIB_PATH | sed 's/:/ /g'`; do
                    if [ "$p" = "$d" ]; then
                        i=1
                        break
                    fi
                done
                if [ $i -eq 0 ]; then
                    SHLIB_PATH=${SHLIB_PATH}:${d}
                fi
            done
        fi
        export SHLIB_PATH
        ;;
    AIX*)
        if [ -z "$LIBPATH" ]; then
            LIBPATH=${libPath}
        else
            for d in ${libPath}; do
                i=0
                for p in `echo $LIBPATH | sed 's/:/ /g'`; do
                    if [ "$p" = "$d" ]; then
                        i=1
                        break
                    fi
                done
                if [ $i -eq 0 ]; then
                    LIBPATH=${LIBPATH}:${d}
                fi
            done
        fi
        export LIBPATH
        ;;
    *)
        if [ -z "$LD_LIBRARY_PATH" ]; then
            LD_LIBRARY_PATH=${libPath}
        else
            for d in ${libPath}; do
                i=0
                for p in `echo $LD_LIBRARY_PATH | sed 's/:/ /g'`; do
                    if [ "$p" = "$d" ]; then
                        i=1
                        break
                    fi
                done
                if [ $i -eq 0 ]; then
                    LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:$d
                fi
            done
        fi
        export LD_LIBRARY_PATH
        ;;
esac

if [ -z "$SAPSYSTEMNAME" ]; then
    if ( tty -s ) then
        y=`hostname|cut -f1-2 -d.`
        x=`whoami`
        PS1="$y:$x> "
        export PS1
        unset y
        unset x
    fi
fi
