# ************************************************************************
# ************************************************************************
# ****                                                                ****
# ***           $HOME/.dbenv.csh                                       ***
# ***           Db2 LUW Environment for SAP and Database Administrator ***
# ***                                                                  ***
# ***           don't change !!                                        ***
# ***                                                                  ***
# ************************************************************************
#-----------------------------------------------------------------------
# set Environment Variable DB2DB6_FORCE_RUNTIME_CLIENT to force the usage 
#     of the Db2 Runtime Client
#-----------------------------------------------------------------------
# setenv DB2DB6_FORCE_RUNTIME_CLIENT 1

#-----------------------------------------------------------------------
# Set the DB2INSTANCE environment variable to the name of the instance.
# The name of the instance is the login name of the UNIX user that owns
# the instance.
#-----------------------------------------------------------------------
setenv DB2INSTANCE db2@LOWDBSID@

#-----------------------------------------------------------------------
# Execute the following only , if user $DB2INSTANCE exists 
#
#----------------------------------------------------------------------- 

if ( -x /usr/xpg4/bin/id ) then
        setenv id /usr/xpg4/bin/id
   else setenv id id
endif

if ( `sh -c "$id -un $DB2INSTANCE 2>/dev/null"` == "$DB2INSTANCE" ) then
   if ( -d ~db2@LOWDBSID@/sqllib ) then
      #-----------------------------------------------------------------------
      # Add the directories:
      #   INSTHOME/sqllib/bin  - database executables
      #   INSTHOME/sqllib/adm  - sysadm executables
      #   INSTHOME/sqllib/misc - miscellaneous utilities
      # to the user's PATH.
      #-----------------------------------------------------------------------
      setenv INSTHOME ~db2@LOWDBSID@
      set path=( $path $INSTHOME/sqllib/bin $INSTHOME/sqllib/adm )
      set path=( $path $INSTHOME/sqllib/misc )
      switch (`uname`)
        case Linux*: 
                     set ORIGINPATH = (`/bin/echo $path | /bin/sed 's/:/ /g'`)
                     breaksw
            default: 
                     set ORIGINPATH = (`/usr/bin/echo $path | /usr/bin/sed 's/:/ /g'`)
                     breaksw
      endsw
      set TEMPOPATH = ""

      foreach dirname ( ${ORIGINPATH} )
           if ("X${dirname}" !~ X*${INSTHOME}/sqllib/bin* && "X${dirname}" !~ X*${INSTHOME}/sqllib/adm* && "X${dirname}" !~ X*${INSTHOME}/sqllib/misc) set TEMPOPATH=( "${TEMPOPATH}${dirname} " )
      end
      set path = ( ${TEMPOPATH} )

      if ("$path" !~ *${INSTHOME}/sqllib/bin*) set path=( $path ${INSTHOME}/sqllib/bin)
      if ("$path" !~ *${INSTHOME}/sqllib/adm*) set path=( $path ${INSTHOME}/sqllib/adm)
      if ("$path" !~ *${INSTHOME}/sqllib/misc*) set path=( $path ${INSTHOME}/sqllib/misc)
      #-----------------------------------------------------------------------
      # The following variables are used for JDBC support
      #-----------------------------------------------------------------------
      #-----------------------------------------------------------------------
      # Only add sqlj.zip if SDK is installed
      #-----------------------------------------------------------------------
      if ( ${?CLASSPATH} == 0 ) setenv CLASSPATH ""
      if ( -e ${INSTHOME}/sqllib/java/sqlj.zip ) setenv CLASSPATH "${CLASSPATH}:${INSTHOME}/sqllib/java/sqlj.zip"

      setenv CLASSPATH "${CLASSPATH}:${INSTHOME}/sqllib/java/db2java.zip"
      setenv CLASSPATH "${CLASSPATH}:${INSTHOME}/sqllib/java/runtime.zip:."
      #-----------------------------------------------------------------------
      # setting the db2dump alias
      #-----------------------------------------------------------------------
      if ( -x /usr/xpg4/bin/awk ) then
         setenv awk /usr/xpg4/bin/awk
      else
         setenv awk awk
      endif
      alias cddump 'cd `db2 get dbm config |'$awk' -F "=" '\'' /\(DIAGPATH\)/ { if ( $2 != " " ) { print $2 } else { print INSTHOME "/sqllib/db2dump" } } '\'' INSTHOME=$INSTHOME`'
      unsetenv awk
   endif
endif

unsetenv id

#-----------------------------------------------------------------------
# DB2DBDFT [Default= SAMPLE]
# is set to the database alias name of the database that will
# be implicitly connected to when applications are started.
#-----------------------------------------------------------------------
setenv DB2DBDFT @DB_SID@

#-----------------------------------------------------------------------
# Set DBSL TRACE environment variables
#-----------------------------------------------------------------------

#setenv DB6_DBSL_TRACE " "
#setenv DB6_DBSL_STAT " "
 
switch (`uname`)
   case AIX*:
   case Sun*:
   case Linux*:
      setenv LANG en_US
      breaksw
      
   case HP*:
      setenv LANG en_US.iso88591

   default: 
      breaksw
endsw

#-----------------------------------------------------------------------
# setting for DBSL shared library 
#-----------------------------------------------------------------------
setenv dbms_type   @DB_TYPE@
if ( "@DB_SCHEMA@" != "" ) then
setenv dbs_db6_schema @DB_SCHEMA@
endif
if ( "@DB_USER@" != "" ) then
setenv dbs_db6_user @DB_USER@
endif

