#  **F*******************************************************************
# ***********************************************************************
# ****                                                               ****
# ***           $HOME/.dbenv.sh                                       ***
# ***           Db2 LUW Environment for SAP and Database Administrator ***
# ***                                                                 ***
# ***           don't change !!                                       ***
# ***                                                                 ***
# ***********************************************************************

#-----------------------------------------------------------------------
# set Environment Variable DB2DB6_FORCE_RUNTIME_CLIENT to force the 
#     usage of Db2 RUNTIME CLIENT
#-----------------------------------------------------------------------
# DB2DB6_FORCE_RUNTIME_CLIENT=1
# export DB2DB6_FORCE_RUNTIME_CLIENT

#-----------------------------------------------------------------------
# Set the DB2INSTANCE environment variable to the name of the instance.
# The name of the instance is the login name of the UNIX user that owns
# the instance.
#-----------------------------------------------------------------------
DB2INSTANCE=db2@LOWDBSID@
export DB2INSTANCE

#-----------------------------------------------------------------------
# Execute the following only , if user $DB2INSTANCE exists 
#
#----------------------------------------------------------------------- 

if [ -x /usr/xpg4/bin/id ]
   then id=/usr/xpg4/bin/id
   else id=id
fi

if [ "`$id -un $DB2INSTANCE 2>/dev/null`" = "$DB2INSTANCE" ]
   then 
   if [ -d ~db2@LOWDBSID@/sqllib ] 
      then 
      #-----------------------------------------------------------------------
      # Add the directories:
      #   INSTHOME/sqllib/bin  - database executables
      #   INSTHOME/sqllib/adm  - sysadm executables
      #   INSTHOME/sqllib/misc - miscellaneous utilities
      # to the user's PATH.
      #-----------------------------------------------------------------------
      INSTHOME=~db2@LOWDBSID@
      export INSTHOME
      PATH=${PATH}:$INSTHOME/sqllib/bin:$INSTHOME/sqllib/adm
      PATH=${PATH}:$INSTHOME/sqllib/misc
      export PATH

      #-----------------------------------------------------------------------
      # The following variables are used for JDBC support
      #-----------------------------------------------------------------------
      #-----------------------------------------------------------------------
      # Only add sqlj.zip if SDK is installed
      #-----------------------------------------------------------------------
      CLASSPATH=${CLASSPATH:-""}

      if [ -f ${INSTHOME}/sqllib/java/sqlj.zip ]; then
         CLASSPATH=$CLASSPATH:${INSTHOME}/sqllib/java/sqlj.zip
      fi

      CLASSPATH=$CLASSPATH:${INSTHOME}/sqllib/java/db2java.zip
      CLASSPATH=$CLASSPATH:${INSTHOME}/sqllib/java/runtime.zip:.
      export CLASSPATH
   
      #-----------------------------------------------------------------------
      # setting the db2dump alias
      #-----------------------------------------------------------------------
      if [ -x /usr/xpg4/bin/awk ]
         then
         awk="/usr/xpg4/bin/awk"
         else
         awk="awk"
         fi
      alias cddump='cd `db2 get dbm config |'$awk' -F "=" '\'' /\(DIAGPATH\)/ { if ( $2 != " " ) { print $2 } else { print INSTHOME "/sqllib/db2dump" } } '\'' INSTHOME=$INSTHOME`'
      unset awk
   fi
fi   

unset id

#-----------------------------------------------------------------------
# DB2DBDFT [Default= SAMPLE]
# is set to the database alias name of the database that will
# be implicitly connected to when applications are started.
#-----------------------------------------------------------------------
DB2DBDFT=@DB_SID@
export DB2DBDFT

#-----------------------------------------------------------------------
# Set DBSL TRACE environment variables
#-----------------------------------------------------------------------

#DB6_DBSL_TRACE=" "
#export DB6_DBSL_TRACE
#DB6_DBSL_STAT=" "
#export DB6_DBSL_STAT

case `uname` in
   AIX*|BOS*|Sun*|Linux*)
      LANG=en_US
      export LANG  
      ;;
   HP*)
      LANG=en_US.iso88591
      export LANG  
      ;;
esac        

#-----------------------------------------------------------------------
# setting for DBSL shared library                 
#-----------------------------------------------------------------------
dbms_type=@DB_TYPE@ 
export dbms_type 
dbs_db6_schema=@DB_SCHEMA@ 
export dbs_db6_schema
dbs_db6_user=@DB_USER@ 
export dbs_db6_user

