#  *********************************************************************
# ***********************************************************************
# ****                                                               ****
# ***                                                                 ***
# ***           SAP HANA Environment 	          	              ***
# ***                                                                 ***
# ***           don't change !!                                       ***
# ***                                                                 ***
# ***                                                                 ***
# ***                                                                 ***
# ***********************************************************************
#  *********************************************************************
#
switch (`uname`)
  case Linux:
    switch (`uname -m`)
      case ia64:
        set _PLATFORM=linuxia64
        breaksw
      case x86_64:
        set _PLATFORM=linuxx86_64
        breaksw
      case s390x:
        set _PLATFORM=linuxs390x
        breaksw
      case ppc64:
        set _PLATFORM=linuxppc64
        breaksw
      case ppc64le:
        set _PLATFORM=linuxppc64le
        breaksw
      case i686:
      case i386:
        set _PLATFORM=linuxintel
        breaksw
      default:
        set _PLATFORM=linuxintel
        breaksw
    endsw
    breaksw
  case AIX*:
    set _PLATFORM=rs6000_64
    breaksw
  case Sun*:
    switch (`uname -m`)
      case sun4u*:
        set _PLATFORM=sun_64
        breaksw
      case i86pc:
        set _PLATFORM=sunx86_64
        breaksw
      default:
        set _PLATFORM=sun_64
        breaksw
    endsw
    breaksw
  case HP*:
    switch (`uname -m`)
      case ia64:
        set _PLATFORM=hpia64
        breaksw
      default:
        set _PLATFORM=hp_64
        breaksw
    endsw
    breaksw
  case OSF*:
    set _PLATFORM=alphaosf
    breaksw
  case OS/390*:
    set _PLATFORM=os390
    breaksw
  default:
    set _PLATFORM=os390
    breaksw
endsw

setenv dbms_type HDB
if ( -f /usr/sap/"$SAPSYSTEMNAME"/SYS/exe/uc/$_PLATFORM/hdbclient/hdbclient.lst) then
  set clientPath=/usr/sap/"$SAPSYSTEMNAME"/SYS/exe/uc/$_PLATFORM/hdbclient
else if( -f /usr/sap/"$SAPSYSTEMNAME"/hdbclient/hdbclient.lst) then
  set clientPath=/usr/sap/"$SAPSYSTEMNAME"/hdbclient
else
  echo No HANA client found. Cannot set HANA client environment!
  exit
endif

set i=0
foreach p ( $path )
  if ( "$p" == "$clientPath" ) then
    set i=1
    break
  endif
end
if ( $i == 0 ) then
  set path = ( $path $clientPath )
endif

switch (`uname`)
    case HP*:
        if ( ! $?SHLIB_PATH ) then
            setenv SHLIB_PATH $clientPath
        else
            set i=0
            foreach p ( `echo $SHLIB_PATH | sed 's/:/ /g'` )
                if ( "$p" == "$clientPath" ) then
                    set i=1
                    break
                endif
            end
            if ( $i == 0 ) then
                setenv SHLIB_PATH ${SHLIB_PATH}:$clientPath
            endif
        endif
        breaksw
    case AIX*:
        if ( ! $?LIBPATH ) then
            setenv LIBPATH $clientPath
        else
            set i=0
            foreach p ( `echo $LIBPATH | sed 's/:/ /g'` )
                if ( "$p" == "$clientPath" ) then
                    set i=1
                    break
                endif
            end
            if ( $i == 0 ) then
                setenv LIBPATH ${LIBPATH}:$clientPath
            endif
        endif
        breaksw
    default:
        if ( ! $?LD_LIBRARY_PATH ) then
            setenv LD_LIBRARY_PATH $clientPath
        else
            set i=0
            foreach p ( `echo $LD_LIBRARY_PATH | sed 's/:/ /g'` )
                if ( "$p" == "$clientPath" ) then
                    set i=1
                    break
                endif
            end
            if ( $i == 0 ) then
                setenv LD_LIBRARY_PATH ${LD_LIBRARY_PATH}:$clientPath
            endif
        endif
        breaksw
endsw

# set HDB_USE_IDENT for alternative userstore folder
if(-f /usr/sap/"$SAPSYSTEMNAME"/SYS/profile/DEFAULT.PFL) then
  set hdb_use_ident = `awk -F= '/^dbs\/hdb\/hdb_use_ident/ {print $2; exit 0}' /usr/sap/"$SAPSYSTEMNAME"/SYS/profile/DEFAULT.PFL`
  if ( $hdb_use_ident != "") then
    setenv HDB_USE_IDENT $hdb_use_ident
  endif
endif

# set dbs_hdb_connect_property for additional connect properties if not already set
if ( ! $?dbs_hdb_connect_property ) then
  set connect_property = "@DBS_HDB_CONNECT_PROPERTY@"
  if ( "$connect_property" == "" ) then
    if (-f /usr/sap/"$SAPSYSTEMNAME"/SYS/profile/DEFAULT.PFL) then
      set connect_property = `awk -F"= " '/^dbs\/hdb\/connect_property/ {print $2; exit 0}' /usr/sap/"$SAPSYSTEMNAME"/SYS/profile/DEFAULT.PFL`
      if ( "$connect_property" =~ *'$('* ) then
        set connect_property = `sappfpar dbs/hdb/connect_property pf=/usr/sap/"$SAPSYSTEMNAME"/SYS/profile/DEFAULT.PFL`
      endif
    endif
  endif
  if ( "$connect_property" != "") then
    setenv dbs_hdb_connect_property "$connect_property"
    # set secudir as well
    if ( ! $?SECUDIR ) then
      set secudir = "@SECUDIR@"
      if ( "$secudir" != "") then
        setenv SECUDIR "$secudir"
      endif
    endif
  endif
endif

