#  *********************************************************************
# ***********************************************************************
# ****                                                               ****
# ***                                                                 ***
# ***           SAP HANA Environment                                  ***
# ***                                                                 ***
# ***           don't change !!                                       ***
# ***                                                                 ***
# ***                                                                 ***
# ***                                                                 ***
# ***********************************************************************
#  *********************************************************************
#
case `uname` in
  Linux)
    case `uname -m` in
      ia64)
        _PLATFORM=linuxia64
        ;;
      x86_64)
        _PLATFORM=linuxx86_64
        ;;
      s390x)
        _PLATFORM=linuxs390x
        ;;
      ppc64)
        _PLATFORM=linuxppc64
        ;;
      ppc64le)
        _PLATFORM=linuxppc64le
        ;;
      i686|i386)
        _PLATFORM=linuxintel
        ;;
      *)
        _PLATFORM=linuxintel
        ;;
    esac
    ;;
  AIX*)
    _PLATFORM=rs6000_64
    ;;
  Sun*)
    case `uname -m` in
      sun4u*)
        _PLATFORM=sun_64
        ;;
      i86pc)
        _PLATFORM=sunx86_64
        ;;
      *)
        _PLATFORM=sun_64
        ;;
    esac
    ;;
  HP*)
    case `uname -m` in
      ia64)
        _PLATFORM=hpia64
        ;;
      *)
        _PLATFORM=hp_64
        ;;
    esac
    ;;
  OSF*)
    _PLATFORM=alphaosf
    ;;
  OS/390*)
    _PLATFORM=os390
    ;;
  OS400*)
    _PLATFORM=as400_pase_64
    ;;
  *)
    _PLATFORM=os390
    ;;
esac

dbms_type=HDB; export dbms_type

if [ -f /usr/sap/"$SAPSYSTEMNAME"/SYS/exe/uc/$_PLATFORM/hdbclient/hdbclient.lst ]; then
  clientPath=/usr/sap/"$SAPSYSTEMNAME"/SYS/exe/uc/$_PLATFORM/hdbclient
elif [ -f /usr/sap/"$SAPSYSTEMNAME"/hdbclient/hdbclient.lst ]; then
  clientPath=/usr/sap/"$SAPSYSTEMNAME"/hdbclient
else
  echo No HANA client found. Cannot set HANA client environment!
  return
fi

i=0
for p in `echo $PATH | sed 's/:/ /g'`; do
  if [ "$p" = "$clientPath" ]; then
    i=1
    break
  fi
done
if [ $i -eq 0 ]; then
  PATH=${PATH}:${clientPath}; export PATH
fi

case `uname` in
    HP*)
	if [ -z "$SHLIB_PATH" ]; then
  	    SHLIB_PATH=${clientPath}
	else
  	    i=0
  	    for p in `echo $SHLIB_PATH | sed 's/:/ /g'`; do
    	        if [ "$p" = "$clientPath" ]; then
      	           i=1
	           break
                fi
	    done
	    if [ $i -eq 0 ]; then
    	        SHLIB_PATH=${SHLIB_PATH}:${clientPath}
  	    fi
	fi
	export SHLIB_PATH
	;;
    AIX*)
	if [ -z "$LIBPATH" ]; then
  	    LIBPATH=${clientPath}
	else
  	    i=0
  	    for p in `echo $LIBPATH | sed 's/:/ /g'`; do
    	        if [ "$p" = "$clientPath" ]; then
      	           i=1
	           break
                fi
	    done
	    if [ $i -eq 0 ]; then
    	        LIBPATH=${LIBPATH}:${clientPath}
  	    fi
	fi
	export LIBPATH
	;;
    OS400*)
	for q in PASE_PATH PASE_LIBPATH LIBPATH
	do
	    eval "qx_=\"\${${q}}\""
	    if [ -z "$qx_" ]; then
		eval "${q}=\"${clientPath}\""
	    else
		i=0
		for p in `echo "${qx_}" | sed 's/::*/ /g'`; do
		    if [ "$p" = "$clientPath" ]; then
			i=1
			break
		    fi
		done
		if [ $i -eq 0 ]; then
		    eval "${q}=\"${qx_}:${clientPath}\""
		fi
	    fi
	    export "$q"
	done
	;;
    *)
	if [ -z "$LD_LIBRARY_PATH" ]; then
  	    LD_LIBRARY_PATH=${clientPath}
	else
  	    i=0
  	    for p in `echo $LD_LIBRARY_PATH | sed 's/:/ /g'`; do
    	        if [ "$p" = "$clientPath" ]; then
      	           i=1
	           break
                fi
	    done
	    if [ $i -eq 0 ]; then
    	        LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:${clientPath}
  	    fi
	fi
	export LD_LIBRARY_PATH
	;;
esac

if [ -z "$SAPSYSTEMNAME" ]; then
    if ( tty -s ) then
        y=`hostname|cut -f1-2 -d.`
        x=`whoami`
        PS1="$y:$x> "
        export PS1
        unset y
        unset x
    fi
fi

# set HDB_USE_IDENT for alternative userstore folder
if [ -f /usr/sap/"$SAPSYSTEMNAME"/SYS/profile/DEFAULT.PFL ]; then
  hdb_use_ident=`awk -F"= " '/^dbs\/hdb\/hdb_use_ident/ {print $2; exit 0}' /usr/sap/"$SAPSYSTEMNAME"/SYS/profile/DEFAULT.PFL`
  if [ "$hdb_use_ident" != "" ]; then
    export HDB_USE_IDENT=$hdb_use_ident
  fi
fi

# set dbs_hdb_connect_property for additional connect properties if not already set
if [ -z "$dbs_hdb_connect_property" ]; then
  connect_property="@DBS_HDB_CONNECT_PROPERTY@"
  if [ "$connect_property" == "" ]; then
    if [ -f /usr/sap/"$SAPSYSTEMNAME"/SYS/profile/DEFAULT.PFL ]; then
      connect_property=`awk -F"= " '/^dbs\/hdb\/connect_property/ {print $2; exit 0}' /usr/sap/"$SAPSYSTEMNAME"/SYS/profile/DEFAULT.PFL`
      if [[ "$connect_property" == *'$('* ]]; then
        connect_property=`sappfpar dbs/hdb/connect_property pf=/usr/sap/"$SAPSYSTEMNAME"/SYS/profile/DEFAULT.PFL`
      fi
    fi
  fi
  if [ "$connect_property" != "" ]; then
    export dbs_hdb_connect_property="$connect_property"
    # set secudir as well
    if [ -z "$SECUDIR" ]; then
      secudir="@SECUDIR@"
      if [ "$secudir" != "" ]; then
        export SECUDIR="$secudir"
      fi
    fi
  fi
fi


# EOF
