/*--- Execute MSSSOURCE scripts -------------------------------------*/
/*--- (C) 2007, SAP Labs --------------------------------------------*/

/*
    cscript mssspexe.js //nologo
*/

/*===================================================================*/
/*--- Global variables ----------------------------------------------*/

var   con      ;    // DB connection parameter structure
var   out      ;    // StdOut stream
var   clock    ;    // Date object
var   ADOconn  ;    // Database connection
var   srcRS    ;    // schema.MSSSOURCE recordset
var   excep    ;

/*=== Functions =====================================================*/

/*--- Populate con from user and system environment -----------------*/

function setCon ()
{
  var shell  = WScript.CreateObject("WScript.Shell");
  var PrcEnv = shell.Environment("PROCESS");

  con.dbserver = PrcEnv("MSSQL_SERVER");
  con.dbname   = PrcEnv("MSSQL_DBNAME");
  con.objsrc   = PrcEnv("MSSQL_SCHEMA");
  con.login    = PrcEnv("MSSQL_USER");
  con.passwd   = PrcEnv("MSSQL_PASSWD");

  if ( con.dbserver == "" )
    con.dbserver = "."

  out.Write ("Connection data from environment :\n");
  out.Write ("DB server = >" + con.dbserver + "<\n") ;
  out.Write ("DB name   = >" + con.dbname   + "<\n") ;
  out.Write ("DB schema = >" + con.objsrc   + "<\n") ;
  out.Write ("SQL login = >" + con.login    + "<\n") ;

}  // setCon

/*--- Construct OLEDB connection string -----------------------------*/

function connString ()
{
  con.string = "Provider='SQLOLEDB';Data Source='" + con.dbserver + "';";

  if ( con.dbname != "" )
    con.string = con.string + "Initial Catalog='" + con.dbname + "';";

  if ( con.login == "" )
  {
    con.string = con.string + "Integrated Security='SSPI';" +
                              "Application Name='MSSSPEXE';" ;
  }
  else
  {
    con.string = con.string + "User ID='" + con.login +
                              "';Password='" + con.passwd + "';" +
                              "Application Name='MSSSPEXE';" ;
  }

  out.Write ("Connection string :\n");
  out.Write (">" + con.string + "<\n");

}  // connString

/*--- Connect to DB, get DB release and set schema ------------------*/

function dbConn()
{
  var   excep  ;
  var   sSQL   ;
  var   ADOrs  ;
  var   dbvers ;
  var   recno  ;

  /*--- Connect to database -----------------------------------------*/
  
  ADOconn = new ActiveXObject ("adodb.connection");
  ADOconn.ConnectionString = con.string;
  
  try
  {
    ADOconn.Open();
  }
  catch (excep)
  {
    out.Write ("Error during DB connect : " + excep.number + "\n");
    out.Write (excep.description + "\n");
    return (false);
  }

  out.Write ("Database connect successful\n");

  /*--- Determine database version ----------------------------------*/
  
  sSQL = "master..xp_msver 'ProductVersion'" ;
  ADOrs = new ActiveXObject ("adodb.recordset") ;
  
  try
  {
    ADOrs.Open (sSQL, ADOconn) ;
  }
  catch (excep)
  {
    out.Write ("Error when reading DB release : " + excep.number + "\n");
    out.Write (excep.description + "\n");
    return (false);
  }
  
  dbvers = ADOrs("Character_Value").Value ;
  ADOrs.Close();

  out.Write ("Database version from xp_msver : " + dbvers + "\n");
  
  switch ( dbvers.substring(0,2) )
  {
    case("8."):
      con.dbrelease = "8.0" ;
      break;
    case("9."):
      con.dbrelease = "9.0" ;
      break;
    case("10"):
      con.dbrelease = "A.0" ;
      break;
    default:
      out.Write ("Error : database release " + dbvers + " not supported\n");
      return(false);
  }

  out.Write ("Major database release : " + con.dbrelease + "\n");

  /*--- Switch schema ------------------------------------------------*/

  if ( con.objsrc != "" && con.objsrc != "dbo" )
  {
    sSQL = "setuser '" + con.objsrc + "'";

    try
    {
      ADOconn.Execute(sSQL, recno, 0x80);  // adExecuteNoRecords
    }
    catch (excep)
    {
      out.Write ("Error when setting schema >" + con.objsrc + "<\n");
      out.Write ("Error code : " + excep.number + "\n");
      out.Write (excep.description + "\n");
      return (false);
    }

    out.Write ("Successful switch to schema >" + con.objsrc + "<\n");
  }

  return(true);

}  // dbConn

/*--- Open MSSSOURCE rowset ------------------------------------------*/

function openSRC ()
{
  var   sSQL ;

  /*--- Construct SQL statement --------------------------------------*/

  sSQL = "SELECT PROCNAME, SRCLINE FROM ";

  if ( con.objsrc != "" && con.objsrc != "dbo" )
    sSQL = sSQL + con.objsrc + "." ;

  sSQL = sSQL + "MSSSOURCE WHERE DBRELEASE = ' ' OR DBRELEASE = '" +
         con.dbrelease + "' ORDER BY PROCNAME, LINENR" ;

  srcRS = new ActiveXObject ("adodb.recordset") ;

  /*--- Open recordset -----------------------------------------------*/

  try
  {
    srcRS.Open (sSQL, con.string) ;
  }
  catch (excep)
  {
    out.Write ("Error when opening MSSSOURCE recordset : " + excep.number + "\n");
    out.Write (excep.description + "\n");
    return (false);
  }

  out.Write ("MSSSOURCE recordset opened.\n");
  out.Write ("SQL : >" + sSQL + "<\n");

  return(true);

}  // openSRC

/*--- Execute the next batch in MSSSOURCE ----------------------------*/

function runSource ()
{
  var    stmt     ;   // SQL batch to execute
  var    go_test  ;
  var    re       ;
  var    currProc ;   // Currently executing script
  var    recno    ;

  stmt     = "" ;
  currProc = "" ;

  while ( ! srcRS.EOF )
  {
    /*--- Check script name ------------------------------------------*/

    if ( srcRS("PROCNAME").Value != null &&
         srcRS("PROCNAME").Value != currProc )
    {
      re = /\S/g ;
      if ( stmt.match(re) )     // Statement string is not empty
      {
        try
        {
          ADOconn.Execute(stmt, recno, 0x80);  // adExecuteNoRecords
        }
        catch (excep)
        {
          out.Write ("Error executing statement batch : " + stmt + "\n");
          out.Write ("Error code : " + excep.number + "\n");
          out.Write (excep.description + "\n");
        }
      }
      stmt = "" ;

      currProc = srcRS("PROCNAME").Value ;
      out.Write ("Execute : " + currProc + "\n") ;
    }

    /*--- Check for 'GO' line ---------------------------------------*/
    
    go_test = srcRS("SRCLINE").Value ;
    
    if ( go_test == null || go_test == "" )
      go_test = " ";
    
    re = /^[ \t]*go[ \t]*$/i ;
    if ( go_test.match(re) )    // Line contains exactly 'GO'
    {
      re = /\S/g ;
      if ( stmt.match(re) )     // Statement string is not empty
      {
        try
        {
          ADOconn.Execute(stmt, recno, 0x80);  // adExecuteNoRecords
        }
        catch (excep)
        {
          out.Write ("Error executing statement batch : " + stmt + "\n");
          out.Write ("Error code : " + excep.number + "\n");
          out.Write (excep.description + "\n");
        }
      }
      stmt = "" ;
    }
    else
    {
      stmt = stmt + go_test + "\n" ;
    }
    
    try
    {
      srcRS.MoveNext();
    }
    catch (excep)
    {
      out.Write ("Error fetching next MSSSOURCE record : " + excep.number + "\n");
      out.Write (excep.description + "\n");
      return (false);
    }
  }

  return (true);

}  // runSource

/*=== Main ===========================================================*/

  /*--- Startup ... --------------------------------------------------*/

  clock = new Date();
  out = WScript.StdOut ;
  out.Write (clock.toTimeString() + " : MSSSPEXE.JS starting...\n");

  /*--- Allocate con object ------------------------------------------*/

  con = new Object() ;

  con.dbserver  = ""    ;  // SQL Server instance
  con.dbname    = ""    ;  // Database name
  con.objsrc    = ""    ;  // Object source schema
  con.login     = ""    ;  // SQL Login (empty = integrated security)
  con.passwd    = ""    ;  // SQL login password
  con.string    = ""    ;  // ADO connection string
  con.dbrelease = ""    ;  // "8.0" | "9.0" | "A.0"

  /*--- Read environment ---------------------------------------------*/

  setCon() ;

  /*--- Construct connection string ----------------------------------*/

  connString() ;

  /*--- Connect to DB, get DB release, set schema, open MSSSOURCE ----*/
  /*--- recordset and execute MSSSOURCE content                   ----*/

  if ( ! dbConn() || ! openSRC() || ! runSource () )
  {
    clock = new Date();

    try
    {
      srcRS.Close();
      ADOconn.Close();
    } 
    catch (excep) { }

    out.Write (clock.toTimeString() + " : MSSSPEXE.JS aborting...\n");
    WScript.Quit(1);
  }
  else
  {
    clock = new Date();
    out.Write (clock.toTimeString() + " : MSSSPEXE.JS done (OK).\n");
  }

  try
  {
    srcRS.Close();
    ADOconn.Close();
  } 
  catch (excep) { }

  WScript.Quit(0);


