This file contains templates for some scripts which are used 
by MS SQL Server porting group during the upgrade 

Version 6.20
Created on 05.02.2002 by A. Engelko
 
###create shadow###
-- create shadow user
-- shadow is substituted with shadow user name
-- password is substituted with password for shadow
-- db is substituted with db name of the system being upgraded

print 'Creating Login <shadow>'
set nocount on
go

use master
--check if login exists
if (not exists(select name from syslogins where name = '<shadow>'))
	exec sp_addlogin '<shadow>', '<password>', '<db>'
if (not exists(select name from sysusers where name = '<shadow>'))
	exec sp_grantdbaccess '<shadow>'

exec sp_addrolemember 'db_owner', '<shadow>'
go

use <db>
--check if the user exists
if (not exists(select name from sysusers where name = '<shadow>'))
	exec sp_grantdbaccess '<shadow>'

exec sp_addrolemember 'db_ddladmin', '<shadow>'
go

setuser '<shadow>'
if exists (select * from sysobjects where name = 'sap_check_if_sick' and id = object_id(user_name() + '.' + name, 'P') )
  drop proc sap_check_if_sick
go
create procedure sap_check_if_sick
as begin
  select 'OK'
end
go
-- Fix because of changes in note 1598149
if exists (select * from INFORMATION_SCHEMA.ROUTINES
             where ROUTINE_SCHEMA = user
               and ROUTINE_NAME = N'sap_get_object_type'
               and ROUTINE_TYPE = N'PROCEDURE')
  drop proc sap_get_object_type
go
CREATE proc sap_get_object_type
  @object_name sysname,
  @schema_name sysname,
  @db_name sysname,
  @object_type char(2) output
AS
BEGIN
set nocount on
-- declare local variables
declare @cmd nvarchar(1024)
declare @pstr nvarchar(64)

-- build the select statement
set @cmd = N'select @object_type = o.xtype ' +
             N'from ' + @db_name + N'.dbo.sysobjects o, ' +
                        @db_name + N'.dbo.sysusers u ' +
                 N'where o.name = @object_name ' +
                 N'and o.uid = u.uid ' +
                 N'and u.name = ''' + @schema_name + N''''

set @pstr = N'@object_name sysname, @object_type char(2) output'

-- get the type
exec sp_executesql @cmd, @pstr, @object_name, @object_type output
END
go

setuser
grant all on [<schema>].[sap_upg_getrelease] to <shadow>

setuser
print 'Execution completed successfully'
set nocount off
go

###drop shadow###
-- used to drop all objects of the shadow user and the user hisself at the end of upgrade
-- shadow is substituted with the name of the shadow user

-- first drop all objects shadow owns in the current db
-- and then revoke db access for him

set nocount on
go

use <db>
setuser

--create table with commands
if (exists( select * from sysobjects where name = 'upg_dropcmds' and id = object_id(user_name() + '.' + name, 'U')))
	drop table [upg_dropcmds]
create table upg_dropcmds (otype char(2) primary key, ocmd  varchar(100))
go
if (exists( select * from sysobjects where name = 'upg_dbss' and id = object_id(user_name() + '.' + name, 'U')))
	drop table [upg_dbss]
create table upg_dbss (dname sysname)
go

declare @cmd varchar(250)
declare @dbname sysname

insert upg_dropcmds values ('U', 'drop table ')
insert upg_dropcmds values ('V', 'drop view ')
insert upg_dropcmds values ('P', 'drop procedure ')
insert upg_dropcmds values ('IF', 'drop function ')
insert upg_dropcmds values ('TF', 'drop function ')
insert upg_dropcmds values ('FN', 'drop function ')
insert upg_dropcmds values ('D', 'drop default ')

declare udbs cursor for
	select name from master..sysdatabases 
	where name <> 'master'
	and name <> '<db>'

open udbs
fetch next from udbs into @dbname
while @@fetch_status = 0
begin
	select @cmd =  'if (exists(select name from ['+@dbname+']..sysusers where name = ''<shadow>'' ))
			insert upg_dbss values('''+@dbname+''')'
	exec (@cmd)
	fetch next from udbs into @dbname
end

close udbs
deallocate udbs
go

-- process

use <db>
setuser
declare @cmd varchar(250)
declare @objname sysname
declare @objtype char(2)

if (exists(select name from master..syslogins where name = '<shadow>'))
begin

	-- first drop the agent jobs to avoid re-creation of dropped table in the shadow schema
	use msdb
    exec sp_manage_jobs_by_login @action = N'DELETE', @current_owner_login_name = N'<shadow>'

	use <db>
	setuser
	-- drop all objects of <shadow>
	declare objnames cursor for
	select name, type from sysobjects 
	where id = object_id('<shadow>' + '.' + name) 
	and type <> 'K'
	order by type desc

	open objnames
	fetch next from objnames into @objname, @objtype
	while @@fetch_status = 0 begin
		select @cmd = ''
		select @cmd = ocmd from upg_dropcmds where otype = @objtype
		if (len(@cmd) > 0) begin
			select @cmd = @cmd + '[<shadow>].[' + @objname + ']'
			print 'executing ' + @cmd
			exec (@cmd)
		end
		else print 'Unable to drop objects of type ' + @objtype

		fetch next from objnames 
		into @objname, @objtype
	end

	close objnames
	deallocate objnames

	setuser

	use <db>
	if (exists(select name from sysusers where name = '<shadow>')) begin
		exec sp_revokedbaccess '<shadow>'
	end

	if (not exists(select dname from [upg_dbss])) begin
		use master
		if (exists(select name from sysusers where name = '<shadow>')) begin
			exec sp_revokedbaccess '<shadow>'
		end
		exec sp_droplogin '<shadow>' 
	end
	else begin
		print ''
		print 'Important information from your SAP team:'
		print '-------------------------------------------------------------'
		print 'User <shadow> has access to dbs other then <db>,'
		print 'so the login cannot be dropped by the upgrade! (Are you running some upgrades in parallel?)'
		print 'You can proceed upgrading your system with ''yes'''
	end
end
else begin
	print 'Login ''<shadow>'' not found'
end

use <db>
drop table [upg_dropcmds]
drop table [upg_dbss]

set nocount off
print 'Execution completed successfully'
go

###check user###
-- check whether user exists in the db
-- shadow is substituted with shadow user name
-- db is substituted with db name of the system being upgraded
print 'Checking existance of user <shadow> in <db>'
set nocount on
go
if (exists(select * from <db>..sysusers where name = '<shadow>')) 
	print 'USER EXISTS=YES' 
else 
	print 'USER EXISTS=NO'
go
set nocount off
print 'Execution completed successfully'
go

###free anly###
-- drops extended procedure ntbw_execute
-- used only for BW upgrade from release 1.2B
if exists ( select * from master.dbo.sysobjects where name = 'ntbw_execute' )
begin
	exec master.dbo.sp_dropextendedproc 'ntbw_execute'
	dbcc ntbwanly (free)
end
print 'Execution completed successfully'
go

###del sapr3###
-- drops the user sapr3
-- DomainName is substituted with the name of the domain
-- UserName is substituted with OS user name
sap_drop_sapr3 '<DomainName>\<UserName>'

###get BW release###
-- used to get the release of BW System
-- schema is substituted with the schema name (relevant only for MCOD systems)
setuser <schemauser>
select 'BWRelease='+RELEASE from CVERS where COMPONENT='SAP_BW'
print 'Execution completed successfully'
go

###check connect###
-- used to check whether the integrated security can be used
-- sqllogin is substituted with the schema name (relevant only for MCOD systems)
setuser <schemauser>
select VERSION from SVERS
go

###drop old SPs###
-- used to drop all Y and SAP SPs after kernel switch
-- schemauser is substituted with the schema name 
setuser <schemauser>
if exists( select * from sysobjects where name = 'sap_summary_locks' and id = object_id(user_name() + '.' + name, 'V'))
drop view sap_summary_locks
go
exec sap_droproc
go
print 'Execution completed successfully'
go

###CheckTmpObjects###
use <db>
declare @all float
declare @tmp float
declare @sid int
select @sid = user_id('<schema>')
select @all = count(*) from sysobjects where id = object_id(user_name(@sid) + '.' + name) 
select @tmp = count(*) from sysobjects where id = object_id(user_name(@sid) + '.' + name) and name like 'BI0/0%'
print 'RATIO=' + cast(floor(@tmp/@all + .5) as varchar)


###strdbs###
@rem --------------------------------------------
@rem Startup script for MS SQL Server database 8.0
@rem --------------------------------------------

@rem --------------------------------------------
@rem start MS SQL Server service
@rem --------------------------------------------
call net start <server>

@rem --------------------------------------------
@rem start MS SQL Server agent
@rem --------------------------------------------
call net start <agent>

###create sp for names###
setuser
setuser <sourceuser>
go
set nocount on

declare @vers   nvarchar(3)
declare @cname  nvarchar(32)
declare @rev    nvarchar(1)

set @cname = '<sp name>'
exec [<schema>].[sap_upg_getrelease] @vers output
set @vers = @vers + '.0'

print 'setuser ' + <targetuser>

select @rev = MAX(REVISION) from MSSPROCS 
  where PROCNAME = @cname and (DBRELEASE = @vers or DBRELEASE = '')

select SRCLINE from MSSSOURCE 
  where PROCNAME = @cname and (DBRELEASE = @vers or DBRELEASE = '') and REVISION = @rev
  order by LINENR

###create sp for area###
setuser
setuser <sourceuser>
go

set nocount on

declare @vers  nvarchar(3)
declare @rev   nvarchar(1)
declare @cname varchar(32)

exec [<schema>].[sap_upg_getrelease] @vers output
set @vers = @vers + '.0'

declare ac cursor for 
select distinct PROCNAME from MSSPROCS where PROCAREA = '<area>' 
OPEN ac

print 'setuser ' + <targetuser>

FETCH NEXT FROM ac into @cname
WHILE @@FETCH_STATUS = 0
BEGIN
    select @rev = MAX(REVISION) from MSSPROCS 
      where PROCNAME = @cname and (DBRELEASE = @vers or DBRELEASE = '')

    select SRCLINE from MSSSOURCE
      where PROCNAME = @cname and (DBRELEASE = @vers or DBRELEASE = '') and REVISION = @rev
      order by LINENR

    FETCH NEXT FROM ac into @cname
END

CLOSE ac
DEALLOCATE ac

###create sap_atomic_defaultbind###
-- unclear why this procedure was patched since 2002...
-- we keep it patched for compatibility reasons for SQL 2000 - SQL 2008 (R2)

-- personalisation: we need "setuser" because the script that originally contained this TSQL-coding
-- was executed personalized! - sapupdbmss.c: cU("MSSUPGSPS"), FileAndPers, ...
setuser <schemauser>

if exists (select * from sysobjects
             where name = N'sap_atomic_defaultbind'
               and xtype = 'P'
               and id = object_id(user_name() + '.' + name) )
  drop proc sap_atomic_defaultbind
go

create proc sap_atomic_defaultbind
  @defaultval nvarchar(96),
  @tabname sysname,
  @fieldname sysname

as

BEGIN

declare @length int
declare @defaultname sysname
declare @cmd nvarchar(256)

select @length = datalength(@defaultval) / 2

select @defaultname =
  case
    when (@defaultval = N' ' and @length = 1)
      then N'str_default'
    when (@defaultval = N'' and @length = 0)
      then N'empstr_default'
    when (@defaultval = N'0')
      then case
        when (select t.name
                from dbo.sysobjects o, dbo.syscolumns c, dbo.systypes t
                  where o.name = @tabname
                    and o.xtype = 'U'
                    and o.id = object_id(user_name() + '.' + o.name)
                    and c.id = o.id
                    and c.name = @fieldname
                    and t.xusertype = c.xusertype) like N'%varchar'
          then N'numc1_default'
          else N'num_default'
      end
    when (@defaultval = N'0X00' or @defaultval = N'0x00')
      then N'raw_default'     -- not used
    else (N'numc' + convert(nvarchar,@length) + N'_default')
  end

select @cmd = N'sp_bindefault ' + @defaultname + N', [' +
              @tabname + N'.' + @fieldname + N']'
exec( @cmd )

END

go

###create mssprocs_ignore_errors###
-- No-op for SQL10
print 'Execution completed successfully'

###create mssprocs_throw_errors###
setuser <schemauser>
update MSSSOURCE set SRCLINE = replace(SRCLINE,'COVREF','skip_covref')
where PROCNAME = 'sap_z_set_parameters' and SRCLINE like '%COVREF%'

update MSSSOURCE set SRCLINE = replace(SRCLINE,'REPOLOAD','skip_repoload')
where PROCNAME = 'sap_z_set_parameters' and SRCLINE like '%REPOLOAD%'

update MSSSOURCE set SRCLINE = replace(SRCLINE,'REPOSRC','skip_reposrc')
where PROCNAME = 'sap_z_set_parameters' and SRCLINE like '%REPOSRC%'

update MSSSOURCE set SRCLINE = replace(SRCLINE,'D010INC','skip_d010inc')
where PROCNAME = 'sap_z_set_parameters' and SRCLINE like '%D010INC%'

update MSSSOURCE set SRCLINE = replace(SRCLINE,'D010TAB','skip_d010tab')
where PROCNAME = 'sap_z_set_parameters' and SRCLINE like '%D010TAB%'

if  ((select object_id(user + '.[COVREF]', 'U')) IS NOT NULL ) EXEC sp_indexoption COVREF, DisAllowPageLocks , 0
if  ((select object_id(user + '.[REPOLOAD]', 'U')) IS NOT NULL ) EXEC sp_indexoption REPOLOAD, DisAllowPageLocks , 0
if  ((select object_id(user + '.[REPOSRC]', 'U')) IS NOT NULL ) EXEC sp_indexoption REPOSRC, DisAllowPageLocks , 0
if  ((select object_id(user + '.[D010INC]', 'U')) IS NOT NULL ) EXEC sp_indexoption D010INC, DisAllowPageLocks , 0
if  ((select object_id(user + '.[D010TAB]', 'U')) IS NOT NULL ) EXEC sp_indexoption D010TAB, DisAllowPageLocks , 0

print 'Execution completed successfully'

###check user schema mismatch###
-- There is not schema in SQL 2000
print 'Execution completed successfully'
###drop performance tables###
print 'Execution completed successfully'
