This file contains templates for some scripts which are used 
by MS SQL Server porting group during the upgrade 

Version 6.20
Created on 05.02.2002 by A. Engelko
 
###create shadow###
-- create shadow user
-- shadow is substituted with shadow user name
-- password is substituted with password for shadow
-- db is substituted with db name of the system being upgraded

print 'Creating Login <shadow>'
set nocount on
go

use master
--check if login exists
if not exists (select * from master.sys.server_principals where name = '<shadow>') 
	create login <shadow> with password = '<password>', default_database = <db>, check_expiration = off, check_policy = off
if (not exists(select name from master.sys.database_principals where name = '<shadow>'))
	CREATE USER <shadow> WITH DEFAULT_SCHEMA = <shadow>
if (not exists(select * from sys.schemas where name = '<shadow>'))
	EXEC ('CREATE SCHEMA <shadow> AUTHORIZATION <shadow>')

exec sp_addrolemember 'db_owner', '<shadow>'
go

use master 
grant control server to <shadow>
print 'Granted control server to <shadow>'
go

use <db>
--check if the user exists
if (not exists(select name from sys.database_principals where name = '<shadow>'))
	CREATE USER <shadow> WITH DEFAULT_SCHEMA = <shadow>
if (not exists(select * from sys.schemas where name = '<shadow>'))
	EXEC ('CREATE SCHEMA <shadow> AUTHORIZATION <shadow>')

exec sp_addrolemember 'db_ddladmin', '<shadow>'
go

EXECUTE AS USER = '<shadow>'
if exists (select * from sys.objects where name = 'sap_check_if_sick' and object_id = object_id(user_name() + '.' + name, 'P') )
  drop proc sap_check_if_sick
go
create procedure sap_check_if_sick
as begin
  select 'OK'
end
go

-- Fix because of changes in note 1598149
if  ((select object_id(schema_name() + '.' + 'sap_get_object_type', 'P'))
   IS NOT NULL )
begin
  drop proc sap_get_object_type;
end
go

CREATE proc sap_get_object_type
  @object_name sysname,
  @schema_name sysname,
  @db_name sysname,
  @object_type char(2) output
AS
BEGIN
set nocount on;
-- declare local variables
declare @cmd nvarchar(1024);
declare @pstr nvarchar(256);

-- check schema
if @schema_name is null or RTRIM(@schema_name) = N''
  SET @schema_name = schema_name();


-- build the select statement
set @cmd = N'use ['+@db_name+N'];'+
  N'select @object_type = so.[type] from sys.objects so, ' +
  N'sys.schemas sch ' +
  N' where sch.schema_id = so.schema_id and ' +
  N' sch.name = @schema_name and ' +
  N' so.[name] = @object_name ';
set @pstr = N'@object_type nvarchar(10) output,' +
            N'@schema_name sysname, ' +
            N'@object_name sysname';
-- get the type
exec sp_executesql @cmd, @pstr, @object_type output,@schema_name,@object_name;

END
go

REVERT;
grant all on [<schema>].[sap_upg_getrelease] to <shadow>

REVERT;
print 'Execution completed successfully'
set nocount off
go

###drop shadow###
-- used to drop all objects of the shadow user and the user hisself at the end of upgrade
-- shadow is substituted with the name of the shadow user

-- first drop all objects shadow owns in the current db
-- and then revoke db access for him

set nocount on
go

use <db>
REVERT;

--create table with commands
if (exists( select * from sys.objects where name = 'upg_dropcmds' and object_id = object_id(user_name() + '.' + name, 'U') ))
	drop table [upg_dropcmds]
create table upg_dropcmds (otype char(2) primary key, ocmd  varchar(100))
go
if (exists( select * from sys.objects where name = 'upg_dbss' and object_id = object_id(user_name() + '.' + name, 'U') ))
	drop table [upg_dbss]
create table upg_dbss (dname sysname)
go

declare @cmd varchar(250)
declare @dbname sysname

insert upg_dropcmds values ('U', 'drop table ')
insert upg_dropcmds values ('V', 'drop view ')
insert upg_dropcmds values ('P', 'drop procedure ')
insert upg_dropcmds values ('IF', 'drop function ')
insert upg_dropcmds values ('TF', 'drop function ')
insert upg_dropcmds values ('FN', 'drop function ')
insert upg_dropcmds values ('D', 'drop default ')

declare udbs cursor for
	select name from master.sys.databases
	where name <> 'master'
	and name <> '<db>'

open udbs
fetch next from udbs into @dbname
while @@fetch_status = 0
begin
	select @cmd =  'if (exists(select name from ['+@dbname+'].sys.database_principals where name = ''<shadow>'' ))
			insert upg_dbss values('''+@dbname+''')'
	exec (@cmd)
	fetch next from udbs into @dbname
end

close udbs
deallocate udbs
go

-- process

use <db>
REVERT;
declare @cmd varchar(250)
declare @objname sysname
declare @objtype char(2)

if (exists(select name from master.sys.server_principals where name = '<shadow>'))
begin

	-- first drop the agent jobs to avoid re-creation of dropped table in the shadow schema
	use msdb
    exec sp_manage_jobs_by_login @action = N'DELETE', @current_owner_login_name = N'<shadow>'

	use <db>
	REVERT;
	-- drop all objects of <shadow>
	declare objnames cursor for
	select name, type from sys.objects 
	where object_id = object_id('<shadow>' + '.' + name) 
	and type <> 'PK' and name != 'upg_dropcmds'
	order by type desc

	open objnames
	fetch next from objnames into @objname, @objtype
	while @@fetch_status != -1
	begin
		if (@@fetch_status = 0) begin
			select @cmd = ''
			select @cmd = ocmd from upg_dropcmds where otype = @objtype
			if (len(@cmd) > 0) begin
				select @cmd = @cmd + '[<shadow>].[' + @objname + ']'
				print 'executing ' + @cmd
				exec (@cmd)
			end
			else print 'Unable to drop objects of type ' + @objtype
		end
		fetch next from objnames into @objname, @objtype
	end

	close objnames
	deallocate objnames

	REVERT;      

	use <db>
	if (exists(select * from sys.schemas where name = '<shadow>'))
	BEGIN
		DROP SCHEMA <shadow>
	END
	if (exists(select name from sys.database_principals where name = '<shadow>')) 
	begin
		DROP USER <shadow>		
	end	

	if (not exists(select dname from [upg_dbss])) begin
		use master
		if (exists(select * from sys.schemas where name = '<shadow>'))
		BEGIN
			DROP SCHEMA <shadow>
		END
		if (exists(select name from sys.database_principals where name = '<shadow>')) 
		begin
			DROP USER <shadow>
		end
				
		DROP LOGIN <shadow>
	end
	else begin
		print ''
		print 'Important information from your SAP team:'
		print '-------------------------------------------------------------'
		print 'User <shadow> has access to dbs other then <db>,'
		print 'so the login cannot be dropped by the upgrade! (Are you running some upgrades in parallel?)'
		print 'You can proceed upgrading your system with ''yes'''
	end
end
else begin
	print 'Login ''<shadow>'' not found'
end

use <db>
drop table [upg_dropcmds]
drop table [upg_dbss]

set nocount off
print 'Execution completed successfully'
go

###check user###
-- check whether user exists in the db
-- shadow is substituted with shadow user name
-- db is substituted with db name of the system being upgraded
print 'Checking existance of user <shadow> in <db>'
set nocount on
go
if (exists(select * from <db>.sys.database_principals where name = '<shadow>')) 
	print 'USER EXISTS=YES' 
else 
	print 'USER EXISTS=NO'
go
set nocount off
print 'Execution completed successfully'
go

###free anly###
-- drops extended procedure ntbw_execute
-- used only for BW upgrade from release 1.2B
-- sp_dropextendedproc is deprecated since SQL 2005
-- can be removed if sp_dropextendedproc is no longer available - until then we just leave it here
if exists ( select * from master.dbo.sysobjects where name = 'ntbw_execute' )
begin
	exec master.dbo.sp_dropextendedproc 'ntbw_execute'
	dbcc ntbwanly (free)
end
print 'Execution completed successfully'
go

###del sapr3###
-- drops the user sapr3
-- DomainName is substituted with the name of the domain
-- UserName is substituted with OS user name
sap_drop_sapr3 '<DomainName>\<UserName>'

###get BW release###
-- used to get the release of BW System
-- schema is substituted with the schema name (relevant only for MCOD systems)
IF ('<schema>' != 'dbo') EXECUTE AS LOGIN = '<schema>'
select 'BWRelease='+RELEASE from CVERS where COMPONENT='SAP_BW'
print 'Execution completed successfully'
go

###check connect###
-- used to check whether the integrated security can be used
-- sqllogin is substituted with the schema name (relevant only for MCOD systems)
IF ('<schema>' != 'dbo') EXECUTE AS USER = '<schema>'
select VERSION from SVERS
go

###drop old SPs###
-- used to drop all Y and SAP SPs after kernel switch
-- schemauser is substituted with the schema name 
IF ('<schema>' != 'dbo') EXECUTE AS LOGIN = '<schema>'
if exists( select * from sys.objects where name = 'sap_summary_locks' and object_id = object_id(user_name() + '.' + name, 'V') )
drop view sap_summary_locks
go
exec sap_droproc
go
--on MSSQL 2005 make sure the new types are used
declare @tabname sysname
declare @colname sysname
declare @datatype sysname
declare @nullflag nvarchar(1)
declare @cmd nvarchar(1024)
declare @n_altered int
declare c cursor for
select t.TABLE_NAME,c.COLUMN_NAME,c.DATA_TYPE, nullflag = substring(c.IS_NULLABLE,1,1)
      from INFORMATION_SCHEMA.COLUMNS c, INFORMATION_SCHEMA.TABLES t
      where c.TABLE_NAME = t.TABLE_NAME AND
            c.TABLE_SCHEMA = t.TABLE_SCHEMA AND
            t.TABLE_TYPE like '%TABLE%' AND
            c.TABLE_SCHEMA = user AND
            c.DATA_TYPE IN ('text','ntext','image')
      order by t.TABLE_NAME,c.COLUMN_NAME
  open c
  set @n_altered = 0
  fetch next from c into @tabname,@colname,@datatype,@nullflag
  while (@@fetch_status <> -1)
  begin
    if (@@fetch_status <> -2)
    begin
      set @cmd = N'alter table [' + @tabname + N'] alter column [' + @colname + N'] '
      if @datatype = N'text' set @cmd = @cmd + N'varchar(MAX)'
      else if @datatype = N'ntext' set @cmd = @cmd + N'nvarchar(MAX)'
      else set @cmd = @cmd + N'varbinary(MAX)'
      if @nullflag = N'N'
          set @cmd = @cmd + ' NOT NULL'
      else
          set @cmd = @cmd + ' NULL'
      exec( @cmd )
      set @n_altered = @n_altered + 1
    end
    fetch next from c into @tabname,@colname,@datatype,@nullflag
  end
  close c
  deallocate c
  select convert(varchar,@n_altered) + N' columns were altered'
go
print 'Execution completed successfully'
go

###CheckTmpObjects###
use <db>
declare @all float
declare @tmp float
declare @sid int
select @sid = schema_id('<schema>')
select @all = count(*) from sys.objects where schema_id=@sid
select @tmp = count(*) from sys.objects where schema_id=@sid and name like 'BI0/0%'
print 'RATIO=' + cast(floor(@tmp/@all + .5) as varchar)

###CreateSAPSchema###
use master
if not exists (select * from master.sys.server_principals where name = '<sid>')
 create login <sid> with password = '', default_database = <db>, check_expiration = off, check_policy = off 
else 
 alter login <sid> with default_database = <db>, check_expiration = off, check_policy = off 
go

use <db>
IF NOT EXISTS (SELECT * FROM sys.database_principals WHERE name = '<sid>')
begin
	create user <sid> for login <sid> with default_schema = <sid>
	exec sp_addrolemember N'db_owner', N'<sid>'
end
else 
begin
	ALTER USER <sid> WITH LOGIN = <sid>
	exec sp_addrolemember N'db_owner', N'<sid>'
	alter user <sid> with default_schema = <sid>
end
go

use <db>
declare @stm nvarchar(4000)
if not exists (select * from sys.schemas where name = N'<sid>') 
begin
	select @stm = 'create schema <sid> authorization <sid>'
	exec(@stm)
end
go

use <db>
alter authorization on schema::<sid> to <sid>

use master
exec sp_dropsrvrolemember N'<sid>', N'sysadmin'
exec sp_addsrvrolemember N'<sid>', N'serveradmin'
exec sp_addsrvrolemember N'<sid>', N'dbcreator'
exec sp_addsrvrolemember N'<sid>', N'bulkadmin'
if not exists (select * from sys.database_principals where name = '<sid>') create user <sid> for login <sid>
exec sp_addrolemember N'db_owner', N'<sid>'
-- Used to be grant all but since grant all is deprecated and it translates to execute we just use execute here
grant execute on xp_cmdshell to <sid>
grant control server to <sid>
go

use msdb
if not exists (select * from sys.database_principals where name = '<sid>')
	create user <sid> for login <sid>
exec sp_addrolemember N'db_owner', N'<sid>'
go

use tempdb
if not exists (select * from sys.database_principals where name = '<sid>')
	create user <sid> for login <sid>
exec sp_addrolemember N'db_owner', N'<sid>'
go

###MoveObjects###
use <db>

declare @newid		sysname
declare @oldid		sysname
declare @oldid_uid	smallint
declare @newid_uid	smallint    
declare @object 	sysname
declare @object_full	nvarchar(999)

set @oldid = 'dbo'
set @newid = '<sid>'
set @oldid_uid = user_id(@oldid)
set @newid_uid = user_id(@newid)

if @oldid_uid is not null and @newid_uid is not null
	begin
	declare object_cursor cursor local for 
		select name 
		from sys.objects 
		where type in ('U', 'V', 'P', 'D', 'TF', 'FN', 'IF')
		and name not in ('syssegments','sysconstraints')
		and not (name = 'dtproperties' and type = 'U')
		and not (name like 'dt_%' and type = 'P') 
		and name not like 'DF[_][_]%[_][_]%'
		and object_id = object_id(@oldid + '.' + name)		

	open object_cursor
	fetch next from object_cursor into @object
	while @@fetch_status=0
	begin
		set @object_full = user_name(@oldid_uid) + '.[' + @object + ']'
		EXECUTE ('ALTER SCHEMA ' + @newid + ' TRANSFER ' + @object_full)
		fetch next from object_cursor into @object
	end
	end

###strdbs###
@rem --------------------------------------------
@rem Startup script for MS SQL Server database 8.0
@rem --------------------------------------------

@rem --------------------------------------------
@rem start MS SQL Server service
@rem --------------------------------------------
call net start <server>

@rem --------------------------------------------
@rem start MS SQL Server agent
@rem --------------------------------------------
call net start <agent>

###create sp for names###
REVERT
IF ('<schema>' != 'dbo') EXECUTE AS USER = '<schema>'
go
set nocount on

declare @vers   nvarchar(3)
declare @cname  nvarchar(32)
declare @rev    nvarchar(1)

set @cname = '<sp name>'
exec [<schema>].[sap_upg_getrelease] @vers output
set @vers = @vers + '.0'

IF (<targetuser> != '') print 'EXECUTE AS USER = ' + <targetuser>

select @rev = MAX(REVISION) from MSSPROCS 
  where PROCNAME = @cname and (DBRELEASE = @vers or DBRELEASE = '')

select SRCLINE from MSSSOURCE 
  where PROCNAME = @cname and (DBRELEASE = @vers or DBRELEASE = '') and REVISION = @rev
  order by LINENR

###create sp for area###
REVERT
IF (<sourceuser> != '' AND <sourceuser> != 'dbo') EXECUTE AS USER = <sourceuser>
go

set nocount on

declare @vers  nvarchar(3)
declare @rev   nvarchar(1)
declare @cname varchar(32)

exec [<schema>].[sap_upg_getrelease] @vers output
set @vers = @vers + '.0'

declare ac cursor for 
select distinct PROCNAME from MSSPROCS where PROCAREA = '<area>' 
OPEN ac

IF (<targetuser> != '''''') print 'EXECUTE AS USER = ' + ''<targetuser>''

FETCH NEXT FROM ac into @cname
WHILE @@FETCH_STATUS = 0
BEGIN
    select @rev = MAX(REVISION) from MSSPROCS 
      where PROCNAME = @cname and (DBRELEASE = @vers or DBRELEASE = '')

    select SRCLINE from MSSSOURCE
      where PROCNAME = @cname and (DBRELEASE = @vers or DBRELEASE = '') and REVISION = @rev
      order by LINENR

    FETCH NEXT FROM ac into @cname
END

CLOSE ac
DEALLOCATE ac

###create sap_atomic_defaultbind###

IF ('<schema>' != 'dbo') EXECUTE AS LOGIN = '<schema>'
go

------------------------------------------
-- sap_atomic_defaultbind               -- 
------------------------------------------

-- Patched because we want to update the SQL10 version and replace it with
-- a new one which handles the DF defaults

if  ((select object_id(schema_name() + '.' + 'sap_atomic_defaultbind', 'P'))
  IS NOT NULL )
begin
  drop proc sap_atomic_defaultbind;
end
go


create proc sap_atomic_defaultbind
  @defaultval nvarchar(96),
  @tabname sysname,
  @fieldname sysname

as

BEGIN

set nocount on;

-- declare local variables
declare @cmd nvarchar(512);

-- unbind an existing default if there is one
-- this is especially necessary for a modification of the default
-- e.g. when DDIC type changes from NUMC to CHAR (both are mapped to
-- varchar but the default is once '0' and afterwards ' ')
-- see SDB2SMSS ALTER_TABLE /$NEXT_DEFMODFIELD$
if (select default_object_id from sys.columns
    where object_id = object_id(@tabname) and name = @fieldname) > 0
  exec sap_atomic_defaultunbind @tabname, @fieldname;

-- check if the value N'0' was mapped to an integer data type
-- also check for varbinary defaults (TS231111)
if ( @defaultval = N'0' and (select t.name
                 from sys.columns c, sys.types t
                  where
                    c.object_id = object_id(schema_name()+'.'+@tabname,'U')
                    and c.name = @fieldname
                    and t.user_type_id = c.user_type_id) not like N'%varchar' )
	or upper(left(@defaultval,3)) = N'0X8'
-- it is no string value then use value 0 or 0x8.. instead of '0' or '0x8..'
select @cmd = N'ALTER TABLE ['+@tabname+N'] '+
              N'ADD DEFAULT '+@defaultval+N' FOR ['+@fieldname+N'];';

else
-- for all other datatype encapsulate the value in ''
select @cmd = N'ALTER TABLE ['+@tabname+N'] '+
              N'ADD DEFAULT '''+@defaultval+N''' FOR ['+@fieldname+N'];';

exec( @cmd );

END
go

------------------------------------------
-- sap_atomic_defaultunbind             -- 
------------------------------------------

if  ((select object_id(schema_name() + '.' + 'sap_atomic_defaultunbind', 'P'))
   IS NOT NULL )
begin
  drop proc sap_atomic_defaultunbind;
end
go

create proc sap_atomic_defaultunbind
  @tabname sysname,
  @fieldname sysname
as

BEGIN


set nocount on;

-- declare local variable

declare @cmd nvarchar(500);

-- unbind the default

declare @def_obj_id varchar(100);
declare @def_obj_name varchar(200);

select @def_obj_id = default_object_id,
       @def_obj_name = object_name(default_object_id)
from sys.columns
where object_id = object_id(@tabname) and name = @fieldname;

if @def_obj_id > 0
begin
if (@def_obj_id IN
   (SELECT object_id FROM sys.objects
   WHERE type = 'D' AND parent_object_id = 0))

--unbind the old default
  begin
    select @cmd = N'sp_unbindefault [' +
           @tabname + N'.' + @fieldname + N']';
    exec( @cmd );
  end
else
  begin
    select @cmd = N'ALTER TABLE ['+@tabname+N'] DROP CONSTRAINT
    ['+@def_obj_name+N']';
    exec( @cmd );
  end
end
END

go

------------------------------------------
-- sap_atomic_next_typemodfield         -- 
------------------------------------------

if  ((select object_id(schema_name() + '.' + 'sap_atomic_next_typemodfield',
'P'))
  IS NOT NULL )
begin
  drop proc sap_atomic_next_typemodfield;
end
go

create proc sap_atomic_next_typemodfield
  @tabname sysname,
  @fieldname sysname,
  @fieldtype nvarchar(64),
  @nullable char(1),
  @defaultval nvarchar(96) = null
as
BEGIN

set nocount on;

-- declare local variables
declare @cmd nvarchar(500);
declare @old_fieldtype nvarchar(64);
declare @cdefault int;
declare @isnullable int;


-- get the default and the isnullable flag
select @cdefault = c.default_object_id,
       @isnullable = c.is_nullable
  from sys.columns c
    where c.object_id = object_id(schema_name()+'.'+@tabname,'U' )
      and c.name = @fieldname;

-- adjust the nullable flag
if @nullable = '' set @nullable = ' ';


-- modify the column
if @fieldtype in (N'smallint', N'int', N'bigint')
  begin
    -- unbind num_default if it is bound
    if @cdefault > 0
      begin
        select @cmd = N'sap_atomic_defaultunbind ''' + @tabname + N''', '''
                      + @fieldname + N'''';
        exec( @cmd );
      end
    -- update the column if necessary
    if @nullable = ' ' and @isnullable = 1
      begin
        select @cmd = N'update [' + @tabname + N'] set [' +
                      @fieldname + N'] = 0 where [' + @fieldname +
                      N'] is null';
        exec( @cmd );
      end
    -- alter the column
    select @cmd = N'alter table [' + @tabname + N'] alter column [' +
                  @fieldname + N'] ' + @fieldtype;
    if @nullable = 'X'
      select @cmd =
        case @isnullable
          when 1 then @cmd + N' null'
          when 0 then @cmd + N' not null'
        end;
    else
      select @cmd =
        case @nullable
          when 'N' then @cmd + N' null'
          when ' ' then @cmd + N' not null'
        end;
    exec( @cmd );
    -- re-bind num_default if necessary
    if @nullable = 'X' and @cdefault > 0  or
       @nullable = ' '
      begin
-- num_default = 0
--              select @cmd = N'sp_bindefault num_default, [' +
--                            @tabname + N'.' + @fieldname + N']';
        select @cmd = N'sap_atomic_defaultbind 0,''' +
                      @tabname + N''',''' + @fieldname+N'''';
        exec( @cmd );
      end
  end

else

if @fieldtype = N'image'
  -- only binary/varbinary --> image and
  -- image --> image (here nothing has to be done)
  begin
    if (select t.name
                from sys.columns c, sys.types t
                  where
                    c.object_id = object_id(schema_name()+'.'+@tabname,'U')
                    and c.name = @fieldname
                    and t.user_type_id = c.user_type_id) like N'%binary'
      begin
        -- unbind the default if one is bound
        if @cdefault > 0     -- shouldn't really be the case
          begin
            select @cmd = N'sap_atomic_defaultunbind ''' + @tabname + N''', '''
                      + @fieldname + N'''';
            exec( @cmd );
          end
        -- alter the column
        select @cmd = N'alter table [' + @tabname +
                      N'] alter column [' + @fieldname + N'] image null';
        exec( @cmd );
      end
  end

else

if @fieldtype = N'text'
  -- only varchar --> text and
  -- text --> text (here nothing has to be done)
  begin
    if (select t.name
          from sys.columns c, sys.types t
            where
              c.object_id = object_id(schema_name()+'.'+@tabname,'U')
              and c.name = @fieldname
              and t.user_type_id = c.user_type_id) = N'varchar'
      begin
        -- unbind the default if one is bound
        if @cdefault > 0     -- shouldn't really be the case
          begin
            select @cmd = N'sap_atomic_defaultunbind ''' + @tabname + N''', '''
                      + @fieldname + N'''';
            exec( @cmd );
          end
        -- alter the column
        select @cmd = N'alter table [' + @tabname +
                      N'] alter column [' + @fieldname + N'] text null';
        exec( @cmd );
      end
  end

else

if @fieldtype = N'ntext'
  -- only nvarchar --> ntext and
  -- ntext --> ntext (here nothing has to be done)
  begin
    if (select t.name
                from sys.columns c, sys.types t
                  where
                    c.object_id = object_id(schema_name()+'.'+@tabname,'U')
                    and c.name = @fieldname
                    and t.user_type_id = c.user_type_id) = N'nvarchar'
      begin
        -- unbind the default if one is bound
        if @cdefault > 0     -- shouldn't really be the case
          begin
            select @cmd = N'sap_atomic_defaultunbind ''' + @tabname + N''', '''
                      + @fieldname + N'''';
            exec( @cmd );
          end
        -- alter the column
        select @cmd = N'alter table [' + @tabname +
                      N'] alter column [' + @fieldname + N'] ntext null';
        exec( @cmd );
      end
  end

---------------- added for SQL 2005 -----------------------------------
else
if @fieldtype = N'varbinary(max)'
  -- only binary/varbinary --> varbinary(max) and
  -- varbinary(max) --> varbinary(max) (here nothing has to be done)
  begin
    if (select t.name
            from sys.columns c, sys.types t
              where
                c.object_id = object_id(schema_name()+'.'+@tabname,'U')
                and c.name = @fieldname
                and t.user_type_id = c.user_type_id) like N'%binary'
      begin
        -- unbind the default if one is bound
        if @cdefault > 0     -- shouldn't really be the case
          begin
            select @cmd = N'sap_atomic_defaultunbind ''' + @tabname + N''', '''
                      + @fieldname + N'''';
            exec( @cmd );
          end
        -- alter the column
        select @cmd = N'alter table [' + @tabname +
          N'] alter column [' + @fieldname + N'] varbinary(max) null';
        exec( @cmd );
      end
  end
else
if @fieldtype = N'varchar(max)'
  -- only varchar --> varchar(max) and
  -- varchar(max) --> varchar(max) (here nothing has to be done)
  begin
    if (select t.name
          from sys.columns c, sys.types t
            where
              c.object_id = object_id(schema_name()+'.'+@tabname,'U')
              and c.name = @fieldname
              and t.user_type_id = c.user_type_id) = N'varchar'
      begin
        -- unbind the default if one is bound
        if @cdefault > 0     -- shouldn't really be the case
          begin
            select @cmd = N'sap_atomic_defaultunbind ''' + @tabname + N''', '''
                      + @fieldname + N'''';
            exec( @cmd );
          end
        -- alter the column
        select @cmd = N'alter table [' + @tabname +
          N'] alter column [' + @fieldname + N'] varchar(max) null';
        exec( @cmd );
      end
  end
else
if @fieldtype = N'nvarchar(max)'
  -- only nvarchar --> nvarchar(max) and
  -- nvarchar(max) --> nvarchar(max) (here nothing has to be done)
  begin
    if (select t.name
          from sys.columns c, sys.types t
            where
              c.object_id = object_id(schema_name()+'.'+@tabname,'U')
              and c.name = @fieldname
              and t.user_type_id = c.user_type_id) = N'nvarchar'
      begin
        -- unbind the default if one is bound
        if @cdefault > 0     -- shouldn't really be the case
          begin
            select @cmd = N'sap_atomic_defaultunbind ''' + @tabname + N''', '''
                      + @fieldname + N'''';
            exec( @cmd );
          end
        -- alter the column
        select @cmd = N'alter table [' + @tabname +
             N'] alter column [' + @fieldname + N'] nvarchar(max) null';
        exec( @cmd );
      end
  end
---------------- end addition for SQL 2005 ------------------------------

else

  -- decimal, binary/varbinary, varchar/nvarchar
  begin
    -- unbind the default if one is bound
    -- not really necessary, but we get rid of a default we don't need
    if @cdefault > 0
      begin
        select @cmd = N'sap_atomic_defaultunbind ''' + @tabname + N''', '''
                      + @fieldname + N'''';
        exec( @cmd );
      end
    -- update the column if necessary
    -- only for decimal and varchar/nvarchar
    if @nullable = ' ' and @isnullable = 1 and
       patindex(N'%binary%',@fieldtype) = 0
      begin
        select @cmd = N'update [' + @tabname + N'] set [' +
                      @fieldname + N'] =';
        if patindex(N'%varchar%',@fieldtype) > 0
          if @defaultval is not null     -- 6.x
            if datalength(@defaultval) > 0
              select @cmd = @cmd + N' '' ''';
            else     -- @defaultval = '', i.e., DD type SSTR
              select @cmd = @cmd + N' ''''';
          else     -- 4.6x
            select @cmd = @cmd + N' '' ''';
        else     -- patindex(N'%decimal%',@fieldtype) > 0
          select @cmd = @cmd + N' 0';
        select @cmd = @cmd + N' where [' + @fieldname +
                      N'] is null';
        exec( @cmd );
      end
    -- alter the column
    select @cmd = N'alter table [' + @tabname + N'] alter column [' +
                  @fieldname + '] ' + @fieldtype;
    if @nullable = 'X'
      select @cmd =
        case @isnullable
          when 1 then @cmd + N' null'
          when 0 then @cmd + N' not null'
        end;
    else
      select @cmd =
        case @nullable
          when 'N' then @cmd + N' null'
          when ' ' then @cmd + N' not null'
        end;
    exec( @cmd );
    -- bind num_default (decimal) or
    -- str_default or empstr_default (varchar/nvarchar)
    -- if necessary
    if @nullable = 'X' and @cdefault > 0  or
       @nullable = ' '
      if patindex(N'%varchar%',@fieldtype) > 0
        begin
          if @defaultval is not null     -- 6.x
            if datalength(@defaultval) > 0
            select @cmd = N'sap_atomic_defaultunbind ''' + @tabname + N''', '''
                      + @fieldname + N'''';
            else     -- @defaultval = '', i.e., DD type SSTR
-- empstr_default = ''
--              select @cmd = N'sp_bindefault empstr_default, [' +
--                            @tabname + N'.' + @fieldname + N']';
        select @cmd = N'sap_atomic_defaultbind '''', ''' +
                      @tabname + N''',''' + @fieldname + N'''';
          else     -- 4.6x
-- str_default = ' '
--            select @cmd = N'sp_bindefault str_default, [' + @tabname +
--                          N'.' + @fieldname + N']';
        select @cmd = N'sap_atomic_defaultbind '' '', ''' +
                      @tabname + N''',''' + @fieldname + N'''';
          exec( @cmd );
        end
      else if patindex(N'%decimal%',@fieldtype) > 0
        begin
-- num_default = 0
--          select @cmd = N'sp_bindefault num_default, [' + @tabname +
--                        N'.' + @fieldname + N']';
        select @cmd = N'sap_atomic_defaultbind 0, ''' +
                      @tabname + N''',''' + @fieldname + N'''';
          exec( @cmd );
        end

  end

END
go
------------------------------------------
-- sap_get_indexes                      -- 
------------------------------------------
if  ((select object_id(schema_name() + '.' + 'sap_get_indexes', 'P')) IS NOT NULL )
begin
  drop proc sap_get_indexes
end
go

create proc sap_get_indexes
  @table_name sysname,
  @schema_name sysname,
  @db_name sysname,
  @only_unique_inds char(1),
  @also_autocre_stats char(1),
  @also_mancre_stats char(1)
as
begin
	set nocount on;
	-- declare local variables
	declare @cmd nvarchar(2048);
	declare @conditions nvarchar (1024);

	if @schema_name is null or RTRIM(@schema_name) = ''
	  SET @schema_name = schema_name();

	set @cmd = N'use ['+@db_name+N'];'+
	N' select distinct tabname, indname, indid
	from
	(
	select distinct
	  OBJECT_NAME(i.object_id) as tabname,
	  i.name as indname,
	  i.index_id as indid,
	  s.auto_created as is_autocreated,
	  s.user_created as is_manually_created,
	  i.is_unique as is_unique
	from sys.indexes i, sys.objects o, sys.stats s
	where s.object_id = i.object_id
	 and  i.object_id = o.object_id';
	if @table_name <> '' and @table_name <> ' '
	   set @cmd = @cmd + N' and o.name = '''+ @table_name +N'''';
	set @cmd = @cmd +
	N' and  o.type = ''U''
	 and  i.index_id = s.stats_id
	 and  o.schema_id = SCHEMA_ID('''+@schema_name+N''')
	 and  i.index_id > 0
	 and i.index_id < 255
	union
	select distinct
	  OBJECT_NAME(s.object_id) as tabname,
	  s.name as indname,
	  s.stats_id as indid,
	  s.auto_created as is_autocreated,
	  s.user_created as is_manually_created ,
	  0 as is_unique
	from sys.stats s, sys.objects o
	where s.object_id = o.object_id';
	if @table_name <> '' and @table_name <> ' '
	   set @cmd = @cmd + N' and o.name = '''+ @table_name +N'''';
	set @cmd = @cmd +
	N' and o.type = ''U''
	  and o.schema_id = SCHEMA_ID('''+@schema_name+N''')
	  and s.stats_id > 0
	  and s.stats_id < 255
	) as tab
	where tab.indid > 0 and tab.indid < 255 ';
	set @conditions = N'';
	if @table_name <> '' and @table_name <> ' '
	   set @conditions = @conditions + N' and tabname = '''+ @table_name +'''';
	if @only_unique_inds = 'X'
	   set @conditions = @conditions +
	   N' and tab.is_unique = 1 ';
	if  @also_autocre_stats <> 'X' and @also_mancre_stats = 'X'
	   set @conditions = @conditions +
	   N' and (tab.is_autocreated = 0 or tab.is_manually_created = 1)';
	else if  @also_autocre_stats = 'X' and @also_mancre_stats <> 'X'
	   set @conditions = @conditions +
	   N' and (tab.is_autocreated = 1 or tab.is_manually_created = 0)';
	else if  @also_autocre_stats <> 'X' and @also_mancre_stats <> 'X'
	   set @conditions = @conditions +
	   N' and (tab.is_autocreated = 0 and tab.is_manually_created = 0)';
	set @cmd = @cmd + @conditions + ';';
	exec (@cmd);
end
GO

###create mssprocs_ignore_errors###

EXECUTE AS USER = '<shadow>'
go
-- QUOTED_IDENTIFIER is needed for XPath, XML and XQuery 
-- which might be part of one or the other MSSSOURCE scripts
SET QUOTED_IDENTIFIER ON
declare @proc          nvarchar(64);
declare @srcline       nvarchar(160);
declare @crlf          nvarchar(2);
declare @rel           nvarchar(3);
declare @btch          nvarchar(max);
declare @errorMessage  nvarchar(4000);
declare @errorSeverity int;
declare @errorState    int;

/* This line is very important. Otherwise no SQL Error will be thrown in Java */
set nocount on;
 
set @rel = (@@microsoftversion / 65536) / 256;
if @rel > 9
BEGIN
   SELECT @rel = MAX(DBRELEASE) FROM [MSSSOURCE] WHERE (ASCII(left(DBRELEASE, 1))-55) <= @rel
END
ELSE
BEGIN
   SELECT @rel = MAX(DBRELEASE) FROM [MSSSOURCE] WHERE left(DBRELEASE, 1) <= @rel
END

IF @rel = 'A.0'
BEGIN
  DECLARE @mainschema  sysname
  DECLARE @saprel      nvarchar(20)
  SELECT @saprel = RELEASE FROM CVERS WHERE COMPONENT = 'SAP_BASIS'  
  IF @saprel = '710' AND (SELECT count(*) FROM MSSPROCS WHERE DBRELEASE = 'A.0') = 1
    SET @rel = '9.0'
END

set @crlf = char(13) + char(10);
 
declare procs cursor for
select a.PROCNAME from MSSSOURCE as a
  where DBRELEASE in (N' ',@rel)
   and REVISION = (select MAX(REVISION) from MSSSOURCE as b
         where b.PROCNAME = a.PROCNAME and DBRELEASE in (N' ',@rel))
group by a.PROCNAME;

/* for each stored procedure name -> get the source lines */
open procs;
fetch next from procs into @proc;
while @@FETCH_STATUS = 0
begin
/* check if error occured in preceeding execution */
  if @errorMessage <> N''
    PRINT @errorMessage
 
  set @btch = N'';
 
  declare srclines cursor for
    select SRCLINE from MSSSOURCE where PROCNAME = @proc
      and DBRELEASE in (N' ',@rel)
      and REVISION = (select MAX(REVISION) from MSSSOURCE
  where PROCNAME = @proc and DBRELEASE in (N' ',@rel))
    order by LINENR;
 
  open srclines;
  fetch next from srclines into @srcline;
  while @@FETCH_STATUS = 0
  begin
    if LTRIM(UPPER(@srcline)) = N'GO' or LTRIM(UPPER(@srcline)) = N'GO;'
    begin
      begin try
        exec(@btch);
      end try
      begin catch
        SELECT
          @errorMessage = CAST(ERROR_NUMBER() as nvarchar)+N': '+ERROR_MESSAGE(),
          @errorSeverity = ERROR_SEVERITY(),
         @errorState = ERROR_STATE();
      end catch
      set @btch = N'';
    end
    else
      set @btch = @btch + @srcline + @crlf;
    fetch next from srclines into @srcline;
  end
  close srclines;
  deallocate srclines;
 
  begin try
    if @errorMessage <> N''
      PRINT @errorMessage
    exec(@btch);
  end try
  begin catch
    SELECT
      @errorMessage = CAST(ERROR_NUMBER() as nvarchar)+N': '+ERROR_MESSAGE(),
      @errorSeverity = ERROR_SEVERITY(),
      @errorState = ERROR_STATE();
  end catch
  
  fetch next from procs into @proc;
end -- while more procs

close procs;
deallocate procs;

if @errorMessage <> N''
begin
  set @errorMessage = N'Creation of stored procedure '''+@proc+''' threw SQL Error '+@errorMessage;                         
  PRINT @errorMessage
end;

###create mssprocs_throw_errors###

IF ('<schema>' != 'dbo') EXECUTE AS LOGIN = '<schema>'
go
-- QUOTED_IDENTIFIER is needed for XPath, XML and XQuery 
-- which might be part of one or the other MSSSOURCE scripts
SET QUOTED_IDENTIFIER ON
/* This is a fix for sap_tf_wrapper */
declare @lineNr int
  
SELECT @lineNr=LINENR FROM MSSSOURCE WHERE 
   PROCNAME = 'sap_tf_wrapper' AND
   SRCLINE  like '%distribution_policy,distribution_policy_desc,distribution_leading_columns%'
     AND DBRELEASE ='B.0'

IF @lineNr IS NOT NULL
BEGIN
  UPDATE MSSSOURCE SET SRCLINE =
    'distribution_policy=0,distribution_policy_desc='''',distribution_leading_columns=0'
  WHERE LINENR = @lineNr AND PROCNAME = 'sap_tf_wrapper' AND DBRELEASE ='B.0'
END
go

/* Fixes deadlocks in the XPRAS phase */
update MSSSOURCE set SRCLINE = replace(SRCLINE,'COVREF','skip_covref')
where PROCNAME = 'sap_z_set_parameters' and SRCLINE like '%COVREF%'

update MSSSOURCE set SRCLINE = replace(SRCLINE,'REPOLOAD','skip_repoload')
where PROCNAME = 'sap_z_set_parameters' and SRCLINE like '%REPOLOAD%'

update MSSSOURCE set SRCLINE = replace(SRCLINE,'REPOSRC','skip_reposrc')
where PROCNAME = 'sap_z_set_parameters' and SRCLINE like '%REPOSRC%'

update MSSSOURCE set SRCLINE = replace(SRCLINE,'D010INC','skip_d010inc')
where PROCNAME = 'sap_z_set_parameters' and SRCLINE like '%D010INC%'

update MSSSOURCE set SRCLINE = replace(SRCLINE,'D010TAB','skip_d010tab')
where PROCNAME = 'sap_z_set_parameters' and SRCLINE like '%D010TAB%'

if  ((select object_id(user + '.[COVREF]', 'U')) IS NOT NULL ) ALTER INDEX ALL ON COVREF SET (ALLOW_PAGE_LOCKS = OFF)
if  ((select object_id(user + '.[REPOLOAD]', 'U')) IS NOT NULL ) ALTER INDEX ALL ON REPOLOAD SET (ALLOW_PAGE_LOCKS = OFF)
if  ((select object_id(user + '.[REPOSRC]', 'U')) IS NOT NULL ) ALTER INDEX ALL ON REPOSRC SET (ALLOW_PAGE_LOCKS = OFF)
if  ((select object_id(user + '.[D010INC]', 'U')) IS NOT NULL ) ALTER INDEX ALL ON D010INC SET (ALLOW_PAGE_LOCKS = OFF)
if  ((select object_id(user + '.[D010TAB]', 'U')) IS NOT NULL ) ALTER INDEX ALL ON D010TAB SET (ALLOW_PAGE_LOCKS = OFF)

GO

declare @proc            nvarchar(64);
declare @srcline         nvarchar(160);
declare @crlf            nvarchar(2);
declare @rel             nvarchar(3);
declare @btch            nvarchar(max);
declare @errorMessage    nvarchar(4000);
declare @errorSeverity   int;
declare @errorState      int;

/* This line is very important. Otherwise no SQL Error will be thrown in Java */
set nocount on;
 
set @rel = (@@microsoftversion / 65536) / 256;
if @rel > 9
  select @rel = char(ASCII('A') + (@rel - 10));
  
set @rel = @rel + N'.0';
 
set @crlf = char(13) + char(10);
 
declare procs cursor for
select a.PROCNAME from MSSSOURCE as a
  where DBRELEASE in (N' ',@rel)
and REVISION = (select MAX(REVISION) from MSSSOURCE as b
  where b.PROCNAME = a.PROCNAME and DBRELEASE in (N' ',@rel))
group by a.PROCNAME;

/* for each stored procedure name -> get the source lines */
open procs;
fetch next from procs into @proc;
while @@FETCH_STATUS = 0
begin
  /* check if error occured in preceeding execution */
  if @errorMessage <> N''
    break;
 
  set @btch = N'';
 
  declare srclines cursor for
    select SRCLINE from MSSSOURCE where PROCNAME = @proc
      and DBRELEASE in (N' ',@rel)
      and REVISION = (select MAX(REVISION) from MSSSOURCE
  where PROCNAME = @proc and DBRELEASE in (N' ',@rel))
    order by LINENR;
 
  open srclines;
  fetch next from srclines into @srcline;
  while @@FETCH_STATUS = 0
  begin
    if LTRIM(UPPER(@srcline)) = N'GO' or LTRIM(UPPER(@srcline)) = N'GO;'
    begin
      begin try
        exec(@btch);
      end try
      begin catch
        SELECT
          @errorMessage = CAST(ERROR_NUMBER() as nvarchar)+N': '+ERROR_MESSAGE(),
          @errorSeverity = ERROR_SEVERITY(),
          @errorState = ERROR_STATE();
         break;
      end catch
      set @btch = N'';
    end
    else
      set @btch = @btch + @srcline + @crlf;
    fetch next from srclines into @srcline;
  end
  close srclines;
  deallocate srclines;
 
  begin try
    if @errorMessage <> N''
      break;
    exec(@btch);
  end try
  begin catch
    SELECT
      @errorMessage = CAST(ERROR_NUMBER() as nvarchar)+N': '+ERROR_MESSAGE(),
      @errorSeverity = ERROR_SEVERITY(),
      @errorState = ERROR_STATE();
  end catch
  
  fetch next from procs into @proc;
end -- while more procs

close procs;
deallocate procs;
 
if @errorMessage <> N''
begin
  set @errorMessage = N'Creation of stored procedure '''+@proc+''' threw SQL Error '+@errorMessage;
  RAISERROR (@errorMessage, @errorSeverity, @errorState);
end;

print 'Execution completed successfully'

###check user schema mismatch###
USE <db>
if (user_id('<schema>') <> schema_id('<schema>'))
BEGIN
	print 'Schema/User mismatch detected'
END
ELSE
BEGIN
	print 'Execution completed successfully'
END
###drop performance tables###

IF ('<schema>' != 'dbo') EXECUTE AS LOGIN = '<schema>'
GO

CREATE TABLE #tables (TABLENAME nvarchar(200))
GO
INSERT INTO #tables VALUES (N'sap_tsize_sample')
GO
BEGIN TRY
	DECLARE @tableToDrop nvarchar(200)
	DECLARE @cmd nvarchar(2000)
	DECLARE tablecursor CURSOR FOR
	SELECT TABLENAME FROM #tables
	OPEN tablecursor
	FETCH NEXT FROM tablecursor INTO @tableToDrop
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF EXISTS( SELECT * FROM sys.objects WHERE name = @tableToDrop 
			and object_id = object_id(schema_name() + '.' + name, 'U'))
		BEGIN
			EXEC('DROP TABLE ' + @tableToDrop)
			print 'Dropped table ' + @tableToDrop
		END
		FETCH NEXT FROM tablecursor INTO @tableToDrop
	END

	print 'Execution completed successfully'
END TRY
BEGIN CATCH
	print 'Error during execution ' + ERROR_MESSAGE() 
END CATCH

BEGIN TRY
	CLOSE tablecursor
	DEALLOCATE tablecursor
END TRY
BEGIN CATCH
	print 'Could not dispose tablecursor cursor'
END CATCH
