# @(#) $Id: //inst/inst_scripts/lmts_006_REL/tpls/ora/DBENV.CSH#5 $
# Oracle RDBMS Environment

switch (`uname`)
  case Linux:
    switch (`uname -m`)
      case ia64:
        set _PLATFORM=linuxia64
        breaksw
      case x86_64:
        set _PLATFORM=linuxx86_64
        breaksw
      case s390x:
        set _PLATFORM=linuxs390x
        breaksw
      case ppc64:
        set _PLATFORM=linuxppc64
        breaksw
      case i686:
      case i386:
        set _PLATFORM=linuxintel
        breaksw
      default:
        set _PLATFORM=linuxintel
        breaksw
    endsw
    breaksw

  case AIX*:
    set _PLATFORM=rs6000_64
    breaksw

  case Sun*:
    switch (`uname -m`)
      case sun4u*:
        set _PLATFORM=sun_64
        breaksw
      case i86pc:
        set _PLATFORM=sunx86_64
        breaksw
      default:
        set _PLATFORM=sun_64
        breaksw
    endsw
    breaksw

  case HP*:
    switch (`uname -m`)
      case ia64:
        set _PLATFORM=hpia64
        breaksw
      default:
        set _PLATFORM=hp_64
        breaksw
    endsw
    breaksw

  case OSF*:
    set _PLATFORM=alphaosf
    breaksw

  case OS/390*:
    set _PLATFORM=os390
    breaksw

  default:
    set _PLATFORM=os390
    breaksw

endsw

set _UC_NUC=@UC_NUC@

#setenv SAPEXE /usr/sap/@SAPSYSTEMNAME@/SYS/exe/"$_UC_NUC"/"$_PLATFORM"
setenv SAPEXE /usr/sap/@SAPSYSTEMNAME@/SYS/exe/run

setenv THREAD @THREAD@
setenv DB_SID @DB_SID@
if ( $THREAD == NOPS ) then
    set DBSID = ${DB_SID}
else
    set DBSID = ${DB_SID}${THREAD}
endif




setenv dbms_type       @DB_TYPE@
setenv dbs_ora_tnsname @PDB_SID@
@REMARK1@setenv dbs_ora_schema  @DB_SCHEMA@
setenv ORACLE_SID      $DBSID
## ORACLE_BASE set now server version dependent
#setenv ORACLE_BASE     /oracle

# check for running user and set for orasid ORA_NLS10
set USER = `id | awk -F\( '{print $2}' | awk -F\) '{print $1}'`
set TRUL = 'tr "ABCDEFGHIJKLMNOPQRSTUVWXYZ" "abcdefghijklmnopqrstuvwxyz"'
set ORASID = "ora`echo $DB_SID | $TRUL`"
if ( $USER != $ORASID ) then
  setenv TNS_ADMIN       @TNS_ADMIN@
  set ADD=@INSTANTCLIENT@
  set _t=@ORACLE_HOME@/bin/sqlplus
  set _f=/sapmnt/@SAPSYSTEMNAME@/profile/DEFAULT.PFL
  set SAPDBHOST=""
  if ( -r "$_f" ) then
    set SAPDBHOST=`awk -F= '/^[ 	]*SAPDBHOST[ 	]*=/ {print $2; exit}' $_f | awk '{print $1}'`
  endif
  if ( -e "$_t" || `uname -n` == "$SAPDBHOST"  ) then
    setenv ORACLE_HOME @ORACLE_HOME@
  endif
  # pluggable db parameter
  @ORA_PDB_NAME@
else
  setenv ORACLE_HOME     @ORACLE_HOME@ 
  set ADD="$ORACLE_HOME"/lib
  # pluggable db parameter
  @ORA_PDB_NAME@
endif

setenv NLS_LANG        @NLS_LANG@
setenv SAPDATA_HOME    @SAPDATA_HOME@
setenv DIR_LIBRARY     $SAPEXE

switch (`uname`)
  case AIX*:
    if ( ${?ORACLE_HOME} ) then
      if ( "$ORACLE_HOME" =~ *121* ) then
        setenv ORACLE_BASE     /oracle/${DB_SID}
      else if ( "$ORACLE_HOME" =~ *122* ) then
        setenv ORACLE_BASE     /oracle/${DB_SID}
      else if ( "$ORACLE_HOME" =~ *18* ) then
        setenv ORACLE_BASE     /oracle/${DB_SID}
      else if ( "$ORACLE_HOME" =~ *19* ) then
        setenv ORACLE_BASE     /oracle/${DB_SID}
      else if ( "$ORACLE_HOME" =~ *112* ) then
        setenv ORACLE_BASE     /oracle
      else
        setenv ORACLE_BASE     /oracle
      endif
    endif
  breaksw

  case HP*:
    if ( ${?ORACLE_HOME} ) then
      if ( "$ORACLE_HOME" =~ *121* ) then
        setenv ORACLE_BASE     /oracle/${DB_SID}
      else if ( "$ORACLE_HOME" =~ *122* ) then
        setenv ORACLE_BASE     /oracle/${DB_SID}
      else if ( "$ORACLE_HOME" =~ *18* ) then
        setenv ORACLE_BASE     /oracle/${DB_SID}
      else if ( "$ORACLE_HOME" =~ *19* ) then
        setenv ORACLE_BASE     /oracle/${DB_SID}
      else if ( "$ORACLE_HOME" =~ *112* ) then
        setenv ORACLE_BASE     /oracle
      else
        setenv ORACLE_BASE     /oracle
      endif
    endif
  breaksw

  default:
    if ( ${?ORACLE_HOME} ) then
       if ( "$ORACLE_HOME" =~ "*121*" ) then
         setenv ORACLE_BASE     /oracle/${DB_SID}
       else if ( "$ORACLE_HOME" =~ "*122*" ) then
         setenv ORACLE_BASE     /oracle/${DB_SID}
       else if ( "$ORACLE_HOME" =~ "*18*" ) then
         setenv ORACLE_BASE     /oracle/${DB_SID}
       else if ( "$ORACLE_HOME" =~ "*19*" ) then
         setenv ORACLE_BASE     /oracle/${DB_SID}
       else if ( "$ORACLE_HOME" =~ "*112*" ) then
         setenv ORACLE_BASE     /oracle
       else
         setenv ORACLE_BASE     /oracle
       endif
    endif
  breaksw
endsw

if ( ${?ORACLE_HOME} ) then
  foreach d ( $ORACLE_HOME/bin )
    set i=0
    foreach p ( $path )
        if ( "$p" == "$d" ) then
            set i=1
            break
        endif
    end
    if ( $i == 0 ) then
        set path = ( $d $path )
    endif
  end
endif

switch (`uname`)
    case AIX*:
        if ( ! $?LIBPATH ) then
            setenv LIBPATH /usr/lib:/lib:${ADD}:$SAPEXE
        else
            foreach d ( $SAPEXE ${ADD} )
                set i=0
                foreach p ( `echo $LIBPATH | sed 's/:/ /g'` )
                    if ( "$p" == "$d" ) then
                        set i=1
                        break
                    endif
                end
                if ( $i == 0 ) then
                    setenv LIBPATH ${LIBPATH}:$d
                endif
            end
        endif
        breaksw

    case HP*:
        if ( ! $?SHLIB_PATH ) then
            setenv SHLIB_PATH ${ADD}:$SAPEXE
        else
            foreach d ( $SAPEXE ${ADD} )
                set i=0
                foreach p ( `echo $SHLIB_PATH | sed 's/:/ /g'` )
                    if ( "$p" == "$d" ) then
                        set i=1
                        break
                    endif
                end
                if ( $i == 0 ) then
                    setenv SHLIB_PATH ${SHLIB_PATH}:$d
                endif
            end
        endif
        breaksw

    case SIN*:
    case Reliant*:
    case Linux*:
        if ( ! $?LD_LIBRARY_PATH ) then
            setenv LD_LIBRARY_PATH ${ADD}:$SAPEXE
        else
            foreach d ( $SAPEXE ${ADD} )
                set i=0
                foreach p ( `echo $LD_LIBRARY_PATH | sed 's/:/ /g'` )
                    if ( "$p" == "$d" ) then
                        set i=1
                        break
                    endif
                end
                if ( $i == 0 ) then
                    setenv LD_LIBRARY_PATH ${LD_LIBRARY_PATH}:$d
                endif
            end
        endif
        breaksw
        
    case OSF*:
        if ( ! $?LD_LIBRARY_PATH ) then
            setenv LD_LIBRARY_PATH ${ADD}:$SAPEXE@LIB_PATH_SEPARATOR@@OCL_LIB_PATH@
        else
            foreach d ( $SAPEXE @OCL_LIB_PATH@ ${ADD} )
                set i=0
                foreach p ( `echo $LD_LIBRARY_PATH | sed 's/:/ /g'` )
                    if ( "$p" == "$d" ) then
                        set i=1
                        break
                    endif
                end
                if ( $i == 0 ) then
                    setenv LD_LIBRARY_PATH ${LD_LIBRARY_PATH}:$d
                endif
            end
        endif
        breaksw

    default:
        if ( ! $?LD_LIBRARY_PATH ) then
            setenv LD_LIBRARY_PATH ${ADD}:$SAPEXE
        else
            foreach d ( $SAPEXE ${ADD} )
                set i=0
                foreach p ( `echo $LD_LIBRARY_PATH | sed 's/:/ /g'` )
                    if ( "$p" == "$d" ) then
                        set i=1
                        break
                    endif
                end
                if ( $i == 0 ) then
                    setenv LD_LIBRARY_PATH ${LD_LIBRARY_PATH}:$d
                endif
            end
        endif
        breaksw
endsw

# define some nice aliases
alias cdora 'cd /usr/sap/@SAPSYSTEMNAME@/SYS/profile/oracle'
alias cdoh  'cd $ORACLE_HOME'
alias cdsh  'cd $SAPDATA_HOME'

# end Oracle RDBMS Environment
