# @(#) $Id: //inst/inst_scripts/lmts_006_REL/tpls/ora/DBENV.SH#6 $
# Oracle RDBMS Environment

case `uname` in
  Linux)
    case `uname -m` in
      ia64)  
        _PLATFORM=linuxia64
        ;;
      x86_64)  
        _PLATFORM=linuxx86_64
        ;;
      s390x)  
        _PLATFORM=linuxs390x
        ;;
      ppc64)  
        _PLATFORM=linuxppc64
        ;;
      i686|i386)
        _PLATFORM=linuxintel
        ;;
      *)
        _PLATFORM=linuxintel
        ;;
    esac
    ;;

  AIX*)
    _PLATFORM=rs6000_64
    ;;

  Sun*)
    case `uname -m` in
      sun4u*)
        _PLATFORM=sun_64
        ;;
      i86pc)
        _PLATFORM=sunx86_64
        ;;
      *)
        _PLATFORM=sun_64
        ;;
    esac
    ;;

  HP*)
    case `uname -m` in
      ia64)
        _PLATFORM=hpia64
        ;;
      *)
        _PLATFORM=hp_64
        ;;
    esac
    ;;

  OSF*)
    _PLATFORM=alphaosf
    ;;

  OS/390*)
    _PLATFORM=os390
    ;;

  *)
    _PLATFORM=os390
    ;;

esac 

_UC_NUC=@UC_NUC@

#SAPEXE=/usr/sap/@SAPSYSTEMNAME@/SYS/exe/"$_UC_NUC"/"$_PLATFORM"; export SAPEXE
SAPEXE=/usr/sap/@SAPSYSTEMNAME@/SYS/exe/run; export SAPEXE

THREAD=@THREAD@; export THREAD
DB_SID=@DB_SID@; export DB_SID
if [ $THREAD = NOPS ]; then
     DBSID=$DB_SID
else
     DBSID=${DB_SID}${THREAD}
fi

dbms_type=@DB_TYPE@; export dbms_type
dbs_ora_tnsname=@PDB_SID@; export dbs_ora_tnsname
@REMARK1@dbs_ora_schema=@DB_SCHEMA@; export dbs_ora_schema
ORACLE_SID=$DBSID; export ORACLE_SID
@REMARK@ORACLE_HOME=@ORACLE_HOME@; export ORACLE_HOME
# ORACLE_BASE now depends on oracle server version
#ORACLE_BASE=/oracle; export ORACLE_BASE
NLS_LANG=@NLS_LANG@ ; export NLS_LANG
SAPDATA_HOME=@SAPDATA_HOME@; export SAPDATA_HOME
DIR_LIBRARY=$SAPEXE; export DIR_LIBRARY


# check for running user and set for orasid ORA_NLS10
USER=`id | awk -F\( '{print $2}' | awk -F\) '{print $1}'`
TRUL='tr "ABCDEFGHIJKLMNOPQRSTUVWXYZ" "abcdefghijklmnopqrstuvwxyz"'
ORASID="ora`echo $DB_SID | $TRUL`"
if [ $USER != $ORASID ]; then
  TNS_ADMIN=@TNS_ADMIN@; export TNS_ADMIN
  ADD=@INSTANTCLIENT@
  _f=/sapmnt/@SAPSYSTEMNAME@/profile/DEFAULT.PFL
  _t=@ORACLE_HOME@/bin/sqlplus
  SAPDBHOST=""
  if [ -r "$_f" ]; then
    SAPDBHOST=`awk -F= '/^[ 	]*SAPDBHOST[ 	]*=/ {print $2; exit}' $_f | awk '{print $1}'`
  fi
  if [ -e "$_t" -o `uname -n` = "$SAPDBHOST" ]; then
    ORACLE_HOME=@ORACLE_HOME@; export ORACLE_HOME
  fi
  # pluggable db parameter
  @ORA_PDB_NAME_SH@
else
  ORACLE_HOME=@ORACLE_HOME@; export ORACLE_HOME
  ADD="$ORACLE_HOME"/lib
  # pluggable db parameter
  @ORA_PDB_NAME_SH@
fi

if [ ! -z "$ORACLE_HOME" ]; then
  str1=121
  str2=112
  str3=122
  str4=18
  str5=19
# only bash not ksh on AIX
# if [[ $ORACLE_HOME =~ "121" ]]; then
  if [ "${ORACLE_HOME#*$str1}" != "$ORACLE_HOME" ]; then
    ORACLE_BASE=/oracle/${DB_SID}; export ORACLE_BASE
# only bash not ksh on AIX
#  elif [[ $ORACLE_HOME =~ "112" ]]; then
  elif [ "${ORACLE_HOME#*$str2}" != "$ORACLE_HOME" ]; then
    ORACLE_BASE=/oracle; export ORACLE_BASE
#  elif [[ $ORACLE_HOME =~ "122" ]]; then
  elif [ "${ORACLE_HOME#*$str3}" != "$ORACLE_HOME" ]; then
    ORACLE_BASE=/oracle/${DB_SID}; export ORACLE_BASE
  elif [ "${ORACLE_HOME#*$str4}" != "$ORACLE_HOME" ]; then
    ORACLE_BASE=/oracle/${DB_SID}; export ORACLE_BASE
  elif [ "${ORACLE_HOME#*$str5}" != "$ORACLE_HOME" ]; then
    ORACLE_BASE=/oracle/${DB_SID}; export ORACLE_BASE
  else
    ORACLE_BASE=/oracle; export ORACLE_BASE
  fi
fi

if [ ! -z "$ORACLE_HOME" ]; then
  for d in $ORACLE_HOME/bin; do
    i=0
    for p in `echo $PATH | sed 's/:/ /g'`; do
        if [ "$p" = "$d" ]; then
            i=1
            break
        fi
    done
    if [ $i -eq 0 ]; then
        PATH=${d}:${PATH}; export PATH
    fi
  done
fi

case `uname` in
    AIX*)
        if [ -z "$LIBPATH" ]; then
            LIBPATH=/usr/lib:/lib:${ADD}:$SAPEXE
        else
            for d in $SAPEXE ${ADD}; do
                i=0
                for p in `echo $LIBPATH | sed 's/:/ /g'`; do
                    if [ "$p" = "$d" ]; then
                        i=1
                        break
                    fi
                done
                if [ $i -eq 0 ]; then
                    LIBPATH=${LIBPATH}:${d}; export LIBPATH
                fi
            done
        fi
        ;;

    HP*)
        if [ -z "$SHLIB_PATH" ]; then
            SHLIB_PATH=${ADD}:$SAPEXE
        else
            for d in $SAPEXE ${ADD}; do
                i=0
                for p in `echo $SHLIB_PATH | sed 's/:/ /g'`; do
                    if [ "$p" = "$d" ]; then
                        i=1
                        break
                    fi
                done
                if [ $i -eq 0 ]; then
                    SHLIB_PATH=${SHLIB_PATH}:${d}; export SHLIB_PATH
                fi
            done
        fi
        ;;

    Linux* | SIN* | Reliant*)
        if [ -z "$LD_LIBRARY_PATH" ]; then
            LD_LIBRARY_PATH=${ADD}:$SAPEXE
        else
            for d in $SAPEXE ${ADD}; do
                i=0
                for p in `echo $LD_LIBRARY_PATH | sed 's/:/ /g'`; do
                    if [ "$p" = "$d" ]; then
                        i=1
                        break
                    fi
                done
                if [ $i -eq 0 ]; then
                    LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:${d}; export LD_LIBRARY_PATH
                fi
            done
        fi
        ;;

    OSF*)
        if [ -z "$LD_LIBRARY_PATH" ]; then
            LD_LIBRARY_PATH=${ADD}:$SAPEXE@LIB_PATH_SEPARATOR@@OCL_LIB_PATH@
        else
            for d in $SAPEXE @OCL_LIB_PATH@ ${ADD}; do
                i=0
                for p in `echo $LD_LIBRARY_PATH | sed 's/:/ /g'`; do
                    if [ "$p" = "$d" ]; then
                        i=1
                        break
                    fi
                done
                if [ $i -eq 0 ]; then
                    LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:${d}; export LD_LIBRARY_PATH
                fi
            done
        fi
        ;;

    *)
        if [ -z "$LD_LIBRARY_PATH" ]; then
            LD_LIBRARY_PATH=${ADD}
        else
            for d in $ADD; do
                i=0
                for p in `echo $LD_LIBRARY_PATH | sed 's/:/ /g'`; do
                    if [ "$p" = "$d" ]; then
                        i=1
                        break
                    fi
                done
                if [ $i -eq 0 ]; then
                    LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:${d}; export LD_LIBRARY_PATH
                fi
            done
        fi
        ;;
esac

# define some nice aliases
alias cdora='cd /usr/sap/@SAPSYSTEMNAME@/SYS/profile/oracle'
alias cdoh='cd $ORACLE_HOME'
alias cdsh='cd $SAPDATA_HOME'

# end Oracle RDBMS Environment
