set feedback off
set termout off
spool ORAGETNLS.LOG
set serverout on

VARIABLE language varchar2(40);
VARIABLE territory varchar2(40);
VARIABLE characterset varchar2(40);
 
WHENEVER SQLERROR EXIT SQL.SQLCODE
WHENEVER OSERROR EXIT FAILURE

begin
   DECLARE
     cur number;
  begin

   begin
     select value into :language from v$nls_parameters where parameter = 'NLS_LANGUAGE';

     EXCEPTION
      when others then
        dbms_output.put_line('error during select of NLS_LANGUAGE');
      RAISE;
    end;

   begin
     select value into :territory from v$nls_parameters where parameter = 'NLS_TERRITORY';

     EXCEPTION
      when others then
        dbms_output.put_line('error during select of NLS_TERRITORY');
      RAISE;
    end;

   begin
     select value into :characterset from v$nls_parameters where parameter = 'NLS_CHARACTERSET';

     EXCEPTION
      when others then
        dbms_output.put_line('error during select of NLS_CHARACTERSET');
      RAISE;
    end;
  end;
end;
/
set termout on
begin
  begin
    dbms_output.put_line('.');
    dbms_output.put_line('.found following NLS-Setting:');
    dbms_output.put_line('.  NLS_LANGUAGE:     '|| :language);
    dbms_output.put_line('.  NLS_TERRITORY:    '|| :territory);
    dbms_output.put_line('.  NLS_CHARACTERSET: '|| :characterset);
    dbms_output.put_line('.');
    dbms_output.put_line('. writing information to NLSLANG.DAT');
    dbms_output.put_line('.');
  end;
end;
/
spool off
set termout off
spool NLSLANG.DAT
begin
    dbms_output.put_line('NLS_LANG='||:language||'_'||:territory||'.'||:characterset||chr(10));
end;
/
spool off
exit success
