# SAP R/3 Environment - please do not edit


switch (`uname`)
  case Linux:
    switch (`uname -m`)
      case ia64:
        set _PLATFORM=linuxia64
        breaksw
      case x86_64:
        set _PLATFORM=linuxx86_64
        breaksw
      case s390x:
        set _PLATFORM=linuxs390x
        breaksw
      case ppc64:
        set _PLATFORM=linuxppc64
        breaksw
      case ppc64le:
        set _PLATFORM=linuxppc64le
        breaksw
      case i686:
      case i386:
        set _PLATFORM=linuxintel
        breaksw
      default:
        set _PLATFORM=linuxintel
        breaksw
    endsw
    breaksw

  case AIX*:
    set _PLATFORM=rs6000_64
    breaksw

  case Sun*:
    switch (`uname -m`)
      case sun4u*:
        set _PLATFORM=sun_64
        breaksw
      case i86pc:
        set _PLATFORM=sunx86_64
        breaksw
      default:
        set _PLATFORM=sun_64
        breaksw
    endsw
    breaksw

  case HP*:
    switch (`uname -m`)
      case ia64:
        set _PLATFORM=hpia64
        breaksw
      default:
        set _PLATFORM=hp_64
        breaksw
    endsw
    breaksw

  case OSF*:
    set _PLATFORM=alphaosf
    breaksw

  case OS/390*:
    set _PLATFORM=os390_64
    breaksw

  default:
    set _PLATFORM=os390_64
    breaksw

endsw

setenv SAPSYSTEMNAME  @SID@

set _UC_NUC=@UC_NUC@
set _DEF_EXE1=/usr/sap/"$SAPSYSTEMNAME"/SYS/exe/"$_UC_NUC"/"$_PLATFORM"
set _DEF_EXE2=/usr/sap/"$SAPSYSTEMNAME"/SYS/exe/run
set _DEF_EXE="$_DEF_EXE1 $_DEF_EXE2"

setenv DIR_LIBRARY ${_DEF_EXE2}

setenv RSEC_SSFS_DATAPATH /usr/sap/"$SAPSYSTEMNAME"/SYS/global/security/rsecssfs/data
setenv RSEC_SSFS_KEYPATH /usr/sap/"$SAPSYSTEMNAME"/SYS/global/security/rsecssfs/key
setenv rsdb_ssfs_connect @RSDB_SSFS_CONNECT@

foreach d ( $_DEF_EXE $HOME )
    set i=0
    foreach p ( $path )
        if ( "$p" == "$d" ) then
            set i=1
            break
        endif
    end
    if ( $i == 0 ) then
        set path = ( $path $d )
    endif
end

switch (`uname`)
    case Sun*:
        foreach d ( /usr/ccs/bin /usr/ucb /usr/gnu/bin )
            set i=0
            foreach p ( $path )
                if ( "$p" == "$d" ) then
                    set i=1
                    break
                endif
            end
            if ( $i == 0 ) then
                set path = ( $path $d )
            endif
        end
        breaksw
    case SIN*:
    case Reliant*:
        foreach d ( /usr/ccs/bin /usr/ucb )
            set i=0
            foreach p ( $path )
                if ( "$p" == "$d" ) then
                    set i=1
                    break
                endif
            end
            if ( $i == 0 ) then
                set path = ( $path $d )
            endif
        end
        breaksw
    case OSF*:
        foreach d ( /usr/sbin )
            set i=0
            foreach p ( $path )
                if ( "$p" == "$d" ) then
                    set i=1
                    break
                endif
            end
            if ( $i == 0 ) then
                set path = ( $path $d )
            endif
        end
        breaksw
    default:
endsw


switch (`uname`)
    case AIX*:
        if ( ! $?LIBPATH ) then
            setenv LIBPATH /usr/lib:/lib:${_DEF_EXE2}:${_DEF_EXE1}
        else
            foreach d ( $_DEF_EXE )
                set i=0
                foreach p ( `echo $LIBPATH | sed 's/:/ /g'` )
                    if ( "$p" == "$d" ) then
                        set i=1
                        break
                    endif
                end
                if ( $i == 0 ) then
                    setenv LIBPATH ${LIBPATH}:"$d"
                endif
            end
        endif
        breaksw

    case HP*:
        if ( ! $?SHLIB_PATH ) then
            setenv SHLIB_PATH ${_DEF_EXE2}:${_DEF_EXE1}
        else
            foreach d ( $_DEF_EXE )
                set i=0
                foreach p ( `echo $SHLIB_PATH | sed 's/:/ /g'` )
                    if ( "$p" == "$d" ) then
                        set i=1
                        break
                    endif
                end
                if ( $i == 0 ) then
                    setenv SHLIB_PATH ${SHLIB_PATH}:"$d"
                endif
            end
        endif
        breaksw

    case OS\/390:
        if ( ! $?LIBPATH ) then
            setenv LIBPATH /usr/lib:/lib:/usr/lpp/icli/sbin:${_DEF_EXE2}:${_DEF_EXE1}
        else
            foreach d ( /usr/lpp/icli/sbin $_DEF_EXE)
                set i=0
                foreach p ( `echo $LIBPATH | sed 's/:/ /g'` )
                    if ( "$p" == "$d" ) then
                        set i=1
                        break
                    endif
                end
                if ( $i == 0 ) then
                    setenv LIBPATH ${LIBPATH}:"$d"
                endif
            end
        endif
        breaksw

    default:
        if ( ! $?LD_LIBRARY_PATH ) then
            setenv LD_LIBRARY_PATH ${_DEF_EXE2}:${_DEF_EXE1}
        else
            foreach d ( $_DEF_EXE)
                set i=0
                foreach p ( `echo $LD_LIBRARY_PATH | sed 's/:/ /g'` )
                    if ( "$p" == "$d" ) then
                        set i=1
                        break
                    endif
                end
                if ( $i == 0 ) then
                    setenv LD_LIBRARY_PATH ${LD_LIBRARY_PATH}:"$d"
                endif
            end
        endif
        breaksw
endsw


switch (`uname`)
    case Sun*:
	limit descriptors 4096
        unsetenv LD_LIBRARY_PATH_64
	breaksw
    case OS\/390:
        alias hostname 'hostname -s'
        breaksw
    default:
endsw

# set TERM environment variable, terminal mode and terminal options
tty -s
if ( $status == 0 ) then
    switch (`uname`)
        case AIX*:
        case BOS*:
            if (! $?TERM) setenv TERM aixterm
            eval `tset -I -Q`
            stty erase '^h' kill '^u' intr '^c' susp '^z'
            breaksw
        case HP*:
            if (! $?TERM) setenv TERM hp
            eval `tset -I -Q`
            stty erase '^h' kill '^u' intr '^c' susp '^z'
            breaksw
        case OSF*:
            if ( ! $?TERM ) setenv TERM vt100
            eval `tset -I -Q`
            switch ($TERM)
                case vt*:
                    stty erase '^?' kill '^u' intr '^c' susp '^z'
                    breaksw
                default:
                    stty erase '^h' kill '^u' intr '^c' susp '^z'
                    breaksw
            endsw
	    breaksw
        case OS\/390:
            if (! $?TERM) setenv TERM xterm
            stty erase '^h' kill '^u' intr '^c' susp '^z'
            breaksw
        case Sun*:
            if (! $?TERM) setenv TERM sun
            eval `tset -I -Q`
            stty erase '^h' kill '^u' intr '^c' susp '^z'
            breaksw
        case SIN*:
        case Reliant*:
            if (! $?TERM) setenv TERM 97801
            eval `tset -I -Q`
            stty erase '^h' kill '^u' intr '^c' susp '^z'
            breaksw
        case ULT*:
            if (! $?TERM) setenv TERM vt100
            eval `tset -I -n -Q`
            switch ($TERM)
                case vt*:
                    stty erase '^?' kill '^u' intr '^c' susp '^z'
                    breaksw
                default:
                    stty erase '^h' kill '^u' intr '^c' susp '^z'
                    breaksw
            endsw
	    breaksw
        case dgux*:
	    breaksw
        case Linux*:
	    breaksw
        default:
            if (! $?TERM) setenv TERM xterm
            eval `tset -I -Q`
            stty erase '^h' kill '^u' intr '^c' susp '^z'
            breaksw
    endsw

endif

# define prompt string
switch (`uname`)
    case OS\/390:
        alias hostname 'hostname -s'
        set prompt="`hostname`:%/ (\!)%#"
        breaksw
    case Sun*:
		switch (`uname -r`)
			case 5.9:
			case 5.10:
				set prompt="`/usr/ucb/hostname`:`/usr/ucb/whoami` \!% "
				breaksw
			default:
				set prompt="`/usr/bin/hostname`:`/usr/bin/whoami` \!% "
				breaksw
			endsw
        breaksw
    case OSF*:
    case SIN*:
    case Reliant*:
        set prompt="`/usr/ucb/hostname`:`/usr/ucb/whoami` \!% "
        breaksw
    case ULT*:
        set LOGNAME=$USER
    case OSF1:
        set prompt="`hostname`:$USER \!> "
        breaksw
    default:
        set prompt="`hostname`:$LOGNAME \!> "
        breaksw
endsw

# number of commands saved in history list
set history = 50

# commandline expansion
set filec

# notify user of completed jobs
set notify

# define some nice aliases
alias pd pushd
alias pop popd
alias dir 'ls -l'
alias l 'ls -abxCF'
alias h 'history'
alias Pwd '/bin/pwd'
alias Su "rlogin `hostname` -l"
alias cdexe 'cd $_DEF_EXE2'
alias cdpro 'cd /usr/sap/$SAPSYSTEMNAME/SYS/profile'
alias cdglo 'cd /usr/sap/$SAPSYSTEMNAME/SYS/global'
alias cdput 'cd /usr/sap/$SAPSYSTEMNAME/put'

ls -d /usr/sap/$SAPSYSTEMNAME/[D,G,S,J,T,A]*[0-9][0-9] >& /dev/null
if ( $status == 0 ) then 
  set INSTANCEDIR_LIST=`ls -d /usr/sap/$SAPSYSTEMNAME/[D,G,S,J,T,A]*[0-9][0-9]`
  set INSTANCEDIR_CI="/usr/sap/$SAPSYSTEMNAME/DVEBM"
  set INSTANCEDIR_DI="/usr/sap/$SAPSYSTEMNAME/D"
  set INSTANCEDIR_GW="/usr/sap/$SAPSYSTEMNAME/G"
  set INSTANCEDIR_S="/usr/sap/$SAPSYSTEMNAME/SCS"
  set INSTANCEDIR_JC="/usr/sap/$SAPSYSTEMNAME/JC"
  set INSTANCEDIR_J="/usr/sap/$SAPSYSTEMNAME/J"
  set INSTANCEDIR_T="/usr/sap/$SAPSYSTEMNAME/TRX"
  set INSTANCEDIR_AS="/usr/sap/$SAPSYSTEMNAME/ASCS"

  foreach d ( $INSTANCEDIR_LIST )
    echo $d | grep `echo $INSTANCEDIR_CI` > /dev/null
    set rc1 = $status
    echo $d | grep `echo $INSTANCEDIR_DI` > /dev/null
    set rc2 = $status
    echo $d | grep `echo $INSTANCEDIR_GW` > /dev/null
    set rc3 = $status
    echo $d | grep `echo $INSTANCEDIR_S` > /dev/null
    set rc4 = $status
    echo $d | grep `echo $INSTANCEDIR_JC` > /dev/null
    set rc5 = $status
    echo $d | grep `echo $INSTANCEDIR_J` > /dev/null
    set rc6 = $status
    echo $d | grep `echo $INSTANCEDIR_T` > /dev/null
    set rc7 = $status
    echo $d | grep `echo $INSTANCEDIR_AS` > /dev/null
    set rc8 = $status
    if ( $rc1 == 0 ) then
      alias cdD 'cd /usr/sap/$SAPSYSTEMNAME/DVEBM*[0-9][0-9]'
    else if ( $rc2 == 0 ) then
      alias cdDi 'cd /usr/sap/$SAPSYSTEMNAME/D[0-9][0-9]'
    else if ( $rc3 == 0) then
      alias cdG 'cd /usr/sap/$SAPSYSTEMNAME/G[0-9][0-9]'
    else if ( $rc4 == 0) then
      alias cdS 'cd /usr/sap/$SAPSYSTEMNAME/SCS[0-9][0-9]'
    else if ( $rc5 == 0) then
      alias cdJC 'cd /usr/sap/$SAPSYSTEMNAME/JC[0-9][0-9]'
    else if ( $rc6 == 0) then
      alias cdJ 'cd /usr/sap/$SAPSYSTEMNAME/J[0-9][0-9]'
    else if ( $rc7 == 0) then
      alias cdT 'cd /usr/sap/$SAPSYSTEMNAME/TRX[0-9][0-9]'
    else if ( $rc8 == 0) then
      alias cdAS 'cd /usr/sap/$SAPSYSTEMNAME/ASCS[0-9][0-9]'
    endif
  end
endif

# end SAP R/3 Environment
